<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?php print $language ?>" xml:lang="<?php print $language ?>">

<head>
  <title><?php print $head_title ?></title>
  <?php print $head ?>
  <?php print $styles ?>
  <?php print $scripts ?>
  <script type="text/javascript"><?php /* Needed to avoid Flash of Unstyle Content in IE */ ?> </script>
</head>

<body>
<div id="page">

<div id="header" class="<?php if ($is_front) { print 'hfront'; } else { print 'hany'; } ?>">
  <div id="logo-wrap">
    <div id="logo">
      <?php if ($logo) { ?><a href="<?php print $base_path ?>" title="<?php print t('Home') ?>"><img src="<?php print $logo ?>" alt="<?php print t('Home') ?>" /></a><?php } ?>
      <div id="site-name-wrap">
        <?php if ($site_name) { ?><h1 class='site-name'><a href="<?php print $base_path ?>" title="<?php print t('Home') ?>"><?php print $site_name ?></a></h1><?php } ?>
        <?php if ($site_slogan) { ?><div class='site-slogan'><?php print $site_slogan ?></div><?php } ?>
      </div>
    </div>
  </div>
    <div id="menu">
      <?php if (isset($secondary_links)) { ?><?php print theme('links', $secondary_links, array('class' =>'links', 'id' => 'subnavlist')) ?><?php } ?>
      <?php if (isset($primary_links)) { ?><?php print theme('links', $primary_links, array('class' =>'links', 'id' => 'navlist')) ?><?php } ?>
    </div>
    <div><?php print $header ?></div>
</div>
<div id="mission-wrap">
    <?php if ($mission) { ?><div id="mission"><?php print $mission ?></div><?php } ?>
</div>
<div id="search-wrap">
  <?php print $search_box ?>
</div>

<div id="content">
  <div id="main-wrap">
    <div id="main">
      <?php print $breadcrumb ?>
      <h1 class="title"><?php print $title ?></h1>
      <div class="tabs"><?php print $tabs ?></div>
      <?php print $help ?>
      <?php print $messages ?>
      <?php print $content; ?>
      <?php print $feed_icons; ?>
    </div>
    <?php if ($sidebar_left) { ?><div id="sidebar-left">
      <?php print $sidebar_left ?>
    <div class="clearing">&nbsp;</div>
    </div><?php } ?>
  </div>
  <?php if ($sidebar_right) { ?><div id="sidebar-right">
    <div class="clearing">&nbsp;</div>
    <?php print $sidebar_right ?>
    <div class="clearing">&nbsp;</div>
  </div><?php } ?>
</div>

<div id="footer">
  <?php print $footer_message ?>
</div>

</div>

<?php print $closure ?>
</body>
</html>
