<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?php print $language ?>" xml:lang="<?php print $language ?>">

<head>
  <title><?php print $head_title ?></title>
  <?php print $head ?>
  <?php print $styles ?>
  <script type="text/javascript"><?php /* Needed to avoid Flash of Unstyle Content in IE */ ?> </script>
</head>
<body>

<div id="page">

<div id="header">
  <div id="submenu">
    <?php if (isset($search_box)) { ?><?php print $search_box ?><?php } ?>
    <?php if (isset($secondary_links)) { ?>
      <?php print theme('links', $secondary_links, array('class' =>'links', 'id' => 'secondary')) ?>
    <?php } ?>
    <div class="clearing">&nbsp;</div>
  </div>
  <div id="subheader">
    <div id="logo">
      <?php if ($logo) { ?><a href="<?php print $base_path ?>" title="<?php print t('Home') ?>"><img src="<?php print $logo ?>" alt="<?php print t('Home') ?>" /></a><?php } ?>
      <div class="snwrap">
        <?php if ($site_name) { ?><h1 class='site-name'><a href="<?php print $base_path ?>" title="<?php print t('Home') ?>"><?php print $site_name ?></a></h1><?php } ?>
        <?php if ($site_slogan) { ?><div class='site-slogan'><?php print $site_slogan ?></div><?php } ?>
      </div>
    </div>
    <?php if ($mission) { ?><div class="mission-wrap"><div id="mission"><?php print $mission ?></div></div><?php } ?>
    <div class="clearing">&nbsp;</div>
  </div>
  <div id="menu">
    <?php if (isset($primary_links)) { ?>
      <?php print theme('links', array_reverse($primary_links), array('class' =>'links', 'id' => 'primary')) ?>
      <div class="clearing">&nbsp;</div>
    <?php } ?>
  </div>
  <div>
    <?php print $header ?>
  </div>
  <div class="clearing">&nbsp;</div>
</div>

<?php
  $w_twocol="w_80 ";
  $w_blockleft="w_23 ";
  $w_main="w_73 ";
  $ml_blockright="ml_81 ";
  $ml_main="ml_24 ";
  if (! $sidebar_right) {
    $w_twocol="w_100 ";
    $ml_blockright=" ";
  }
  if (! $sidebar_left) {
    $w_main="w_96 ";
    $w_blockleft=" ";
    $ml_main=" ";
  }
?>

<div id="content">

<div id="threecol">
  <div id="twocol" class="<?php print $w_twocol; ?>">
    <?php if ($sidebar_left) { ?>
      <div id="block-left" class="<?php print $w_blockleft; ?>">
        <div id="sidebar-left"><?php print $sidebar_left ?></div>
      </div>
    <?php } ?>
    <div id="main_wrap" class="<?php print $w_main; ?>">
      <div id="main">
        <?php print $breadcrumb ?>
        <h1 class="title"><?php print $title ?></h1>
        <div class="tabs"><?php print $tabs ?></div>
        <?php print $help ?>
        <?php print $messages ?>
        <?php print $content; ?>
        <?php print $feed_icons; ?>
      </div>
    </div> 
  </div>
  <?php if ($sidebar_right) { ?>
    <div id="block-right" class="<?php print $ml_blockright; ?>">
      <div id="sidebar-right">
        <?php print $sidebar_right ?>
      </div>
    </div>
  <?php } ?>
  <div class="clearing">&nbsp;</div>
</div>

</div> <!-- CONTENT -->

<div id="footer">
  <?php print $footer_message ?>
</div>

</div> <!-- PAGE -->

<?php print $closure ?>
</body>
</html>
