#!/usr/bin/env python
#Usage: $0 uni0E01 > code.txt
#or:    $0 --all

import os
import sys
import dfont

# cvt value
#NEW VALUE ***
#    "headdia":          257,    #384
#    "headstem":         258,    #120
#    "hwidth_14":        256,    #896    =ko_kai
cvt_dict = {
    "w_1337":           57,     #1337
    "w_1290":           127,    #1290
    "w_1231":           75,     #1231
    "w_1180":           73,     #1180
    "w_1133":           60,     #1133
    "w_1120":           200,    #1120
    "w_1112":           228,    #1112
    "w_1081":           71,     #1081
    "w_1051":           225,    #1051
    "w_1024":           138,    #1024
    "w_973":            178,    #973
    "w_926":            275,    #926
    "w_866":            286,    #866
    "w_569":            58,     #569
    "w_522":            108,    #522
    "w_455":            109,    #455
    "w_397":            45,     #397
    "w_385":            44,     #385
    "w_291":            87,     #291
#
    "w_236":            159,    #236
    "w_195":            144,    #195
    "w_154":            85,     #154
#
    "base":             10,     #0
    "hstem":            13,         #358
    "hstem_curve":      144,        #195    =big curve hstem
    "hstem_thin":       54,         #246
#
    "vstem_236":        159,        #236    =3 spline, thinner
    "vstem_258":        161,        #258    =2 spline, thicker
    "vstem_thin":       85,         #154
    "vstem_small":      221,        #133 
    "vstem_tiny":       124,        #152
#
    "headstem":         30,         #127
    "headstem_plus_hole":   301,    #279
    "headstem_small":   36,         #113    =kho
    "headstem_small_plus_hole":   271,          #264
    "headstem_tiny":    158,        #106
    "headstem_tiny_plus_hole":    4,            #233
    "headstem_wan":     260,    #60
    "headstem_big":     16,     #172
    "headstem_sara":    59,     #88
    "headstem_sara_plus_hole":    94,    #193
    "sarastem":         30,         #127
#
    "headdia":          298,        #406
    "headdia_small":    198,        #377    =kho
    "headdia_tiny":     24,         #340
    "headdia_sara":     91,         #281
    "headhole":         131,        #152    
    "headneck_kho":     39,     #180    =kho
#
    "hwidth_a":         61,     #1085   =a
    "hwidth_ching":     275,    #926    =cho_ching
#
    "hnext_1":          58,         #569    =next spline of sho_sher
#
    "vheight":          179,        #1120   =normal height 
    "vheight_shoot":    202,        #1147   =overshoot height
    "vheight_hi":       49,     #1208   =ko 
    "vheight_hi_kho":   47,     #1204   =kho 
    "vheight_po":       163,        #1556   =po_pla, fo_fa
    "vheight_o":        197,        #1638   =sara_o, sara_i
    "vheight_lo":       152,        #29 
    "vheight_lu":       98,         #410    =lo_lu
    "vheight_below_do": 98,     #410
    "vheight_num":      275,        #926
    "vheight_sara1":    127,        #1290
#
    "head_diff":        131,    #254    =head of character: bo,po
    "beak_diff":        148,    #84     =beak of ko,tho
    "beak_diff_2":      38,     #340    =beak of ko,tho
#
    "front_001":        7,          #162
#
    "front_kai":        59,         #88     =front spacing of ko_kai
    "front_khai":       262,        #20     =front spacing of kho_khai
    "front_dek":        30,         #127
    "front_thahan":    38,         #37
#
    "front_khuad":      157,    #451    =front spacing of kho_khud
    "front_tahan":      38,     #340    =front spaceing of to_tahan
    "front_dek":        106,    #213    =front spaceing of do_dek
    "front_thong":      79,     #229    =front spaceing of to_thong
    "front_pung":       228,    #174    =front spaceing of po_pung
    "front_pan":        31,     #330    =front spacing of do_chada, po_pan
    "front_ma":         180,    #377    =front spaceing of mo_ma
    "front_ling":       1,      #184    =front spaceing of lo_ling, aw_ang
#
#special
    "special_1":        230,    #45
    "special_2":        88,     #20
}

######### PSUEDO-CODE ##########
pseudo_code_dict = {
    #ko_kai
    "uni0E01": """
srp0    26
mirp[rp0,min,rnd,grey]  front_kai 18
#mdrp[min,rnd,grey]  8
#mdrp[rp0,rnd,grey]  10
#mdrp[min,rnd,grey]  17
#srp0    18
mdrp[rp0,rnd,grey]  14
mirp[min,rnd,grey]  hstem  12
ip 17
ip 10
mirp[rp0,rnd,grey]  w_1081 25
mdrp[rnd,white] 27
mirp[min,rnd,grey]  hstem  1
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
alignrp    13
mirp[rp0,rnd,grey]  vheight_shoot    22
mirp[min,rnd,grey]  vstem_236  5
srp1    13
sloop 10
ip 19 8 18 9 17 10 15 12 2 25
IUP[y]
""",

    #kho_khai
    "uni0E02":  """
srp0    51
mirp[rp0,min,rnd,grey]  front_khai 19
mirp[min,rnd,grey]  headstem_small 48
mirp[rp0,rnd,grey]  headdia_small 13
mirp[min,rnd,grey]  headstem_small 42
mdrp[rp0,rnd,white] 7
mirp[rp0,rnd,grey]  w_236 25
mdrp[rp0,rnd,white] 34
mirp[rp0,min,rnd,grey] hstem 36
mdrp[rnd,white] 52
mirp[rp0,rnd,grey]  w_926 1
mirp[min,rnd,grey]  hstem 30
srp2    25
sloop   4
ip  4 5 28 27
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
mirp[rnd,grey]      vheight 36
mirp[min,rnd,grey]  vstem_236 31
mirp[rp0,rnd,grey]  vheight_shoot 22
mirp[min,rnd,grey]  vstem_small 10
mdrp[min,rnd,grey]  45
mdrp[rp0,rnd,grey]  16
mirp[min,rnd,grey]  headstem_small 39
srp1    31
sloop   6
ip  5 4 27 28 30 2
IUP[y]
""",

    #kho_khuad
    "uni0E03": """
srp0    57
mirp[rp0,min,rnd,grey] front_khai 24
mdrp[min,rnd,grey]  13
mdrp[min,rnd,grey]  54
mdrp[rp0,rnd,grey]  18
mirp[min,rnd,grey]  headstem_small 48
mdrp[rp0,rnd,white] 7
mirp[rp0,min,rnd,grey]  vstem_236 31
mdrp[rp0,rnd,white] 40
mirp[rp0,min,rnd,grey]  hstem 42
mdrp[rnd,white] 58
mirp[rp0,rnd,grey]  w_926 1
mirp[min,rnd,grey]  hstem 36
srp2    31
sloop   4
ip  4 5 34 33
srp1    13
srp2    7
sloop   6
ip  27 11 28 10 29 9
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[min,rnd,grey]  vstem_236   37
mirp[rnd,grey]  vheight 42
mirp[rp0,rnd,grey]  vheight_shoot   27
alignrp     29
mirp[min,rnd,grey]  sarastem 11
shp[rp2]    9
mdrp[rp0,min,rnd,grey]  28
mirp[rp0,min,rnd,grey]  sarastem 10
mdrp[rp0,rnd,white] 15
mdrp[min,rnd,grey]  13
mirp[min,rnd,grey]  headstem_small 51
mirp[rp0,rnd,grey]  headdia_small 21
mirp[min,rnd,grey]  headstem_small 45
srp1    9
srp2    37
sloop   8
ip  7 31 5 4 33 34 2 36
IUP[y]
""",

    #kho_kwai
    "uni0E04": """
SRP0                    52         ;Set Reference Point 0
MIRP[rp0,min,rnd,grey]  front_kai 33
mirp[rp0,min,rnd,grey]  hstem 8
mdrp[rp0,rnd,white]  11
mdrp[min,rnd,grey]  27
mdrp[rp0,min,rnd,grey]  30
mirp[min,rnd,grey]  hstem 29
srp0    33
mdrp[rp0,rnd,grey]  20
mirp[min,rnd,grey]  headstem 43
mirp[min,rnd,grey]  headstem_plus_hole 49
srp1    8
ip  14
ip  25
srp0    33
mirp[rp0,rnd,grey]  w_1290  39
mirp[min,rnd,grey]  hstem   1
mdrp[rnd,white] 53
IUP[x]
SVTCA[y-axis]
MDAP[rnd]                1
ALIGNRP                  29
MIRP[rp0,rnd,grey]       vheight_shoot  36
MIRP[min,rnd,grey]       vstem_236  5
MDRP[rp0,rnd,white]      17         
MIRP[min,rnd,grey]       headstem  46
MIRP[rp0,rnd,grey]       headdia  23
MIRP[min,rnd,grey]       headstem  40
srp0    29
mdrp[min,rnd,grey]  11
srp1    5
srp2    11
sloop 4
ip 33 8 2 39
IUP[y]                              
""",

    #kho_kon
    "uni0E05": """
srp0    55
mirp[rp0,min,rnd,grey]  front_kai  34
mirp[rp0,min,rnd,grey]  hstem   9
mdrp[rp0,rnd,white]  12
mdrp[min,rnd,grey]   28
mdrp[rp0,min,rnd,grey]  31
mirp[min,rnd,grey]  hstem 30
srp0    12
mdrp[rp0,rnd,white] 15
mdrp[min,rnd,grey]  26
srp0    34
mdrp[rp0,rnd,grey]  21
mirp[min,rnd,grey]  headstem 46
mirp[rnd,grey]  headstem_plus_hole 52
srp0    34
mirp[rp0,rnd,grey]  w_1290 42
sloop   7
ip  37 7 38 6 5 39 4
mirp[min,rnd,grey]  hstem 1
mdrp[rnd,white] 56
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
alignrp 30
mirp[rp0,rnd,grey]  vheight_shoot 39
alignrp 37
mirp[min,rnd,grey]  vstem_236 4
shp[rp2]    7
mdrp[rp0,min,rnd,grey]  5
mirp[min,rnd,grey]  headstem 38
mdrp[rp0,rnd,white]  18
mirp[min,rnd,grey]  headstem 49
mirp[rp0,rnd,grey]  headdia 24
mirp[min,rnd,grey]  headstem 43
mdrp[min,rnd,grey]  26
srp0    30
mdrp[min,rnd,grey]  12
srp1    5
srp2    12
sloop   4
ip  34  9   2   42
IUP[y]
""",

    #kho_rakang
    "uni0E06": """
srp0    78
mirp[rp0,min,rnd,grey]  front_khai 36
mdrp[min,rnd,grey]  25
mdrp[rp0,rnd,grey]  30
mirp[min,rnd,grey]  headstem 57
mirp[rnd,grey]  headstem_plus_hole 63
mdrp[rp0,rnd,white]  16
srp0    36
mdrp[rp0,rnd,grey]  43
mirp[min,rnd,grey]  vstem_236 19
srp0    36
mdrp[rp0,rnd,grey]  53
mirp[min,rnd,grey]  hstem 51
shp[rp2]    1
mdrp[rnd,white] 79
mirp[rp0,rnd,grey]  w_973 13
mirp[min,rnd,grey]  hstem 48
shp[rp2]    3
mdrp[rp0,rnd,grey]  9
mirp[min,rnd,grey]  headstem 75 
mirp[rnd,grey]  headstem_plus_hole 69 
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
mirp[min,rnd,grey]  vstem_258 51
mirp[rnd,grey]  vheight_lo  6
mirp[rnd,grey]  vheight 53
mirp[rp0,rnd,grey]  vheight_shoot 41
alignrp 39
mdrp[min,rnd,grey]  21
shp[rp2]    23
mdrp[rp0,rnd,grey]  40
mirp[rp0,min,rnd,grey]  headstem 22
mdrp[rp0,rnd,white]  27
mirp[min,rnd,grey]  headstem 60
mirp[rp0,rnd,grey]  headdia 33
mirp[min,rnd,grey]  headstem 54
srp0    6
mdrp[min,rnd,grey]  66
mdrp[rp0,rnd,grey]  12
mirp[min,rnd,grey]  headstem 72
mdrp[rp0,rnd,grey]  49
mdrp[rp0,rnd,grey]  3
srp1    21
srp2    49
sloop   4
ip   17 16 45 46
IUP[y]
""",

    #ngo_ngu
    "uni0E07": """
srp0    32
mirp[rp0,rnd,grey] front_khai 4
mdrp[rnd,grey] 5
mirp[rp0,rnd,grey]  w_926 19
mdrp[rnd,white]  33
mirp[rp0,min,rnd,grey]  hstem 8
mdrp[rnd,grey]  1
srp0 19
mdrp[rp0,rnd,grey]  14
mirp[min,rnd,grey]  headstem 29
mirp[rnd,grey]  headstem_plus_hole 23
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
mirp[min,rnd,grey]  vstem_258 8
mirp[rp0,rnd,grey]  vheight_shoot 17
sloop   2
ip  5 4
mdrp[rp0,rnd,grey]  11
mirp[min,rnd,grey]  headstem 20
mirp[rnd,grey]  headstem_plus_hole 26
IUP[y]
""",

    #jo_jan
    "uni0E08": """
srp0    44
mirp[rp0,min,rnd,grey] front_kai 22
mirp[rp0,rnd,grey]  w_1051 29
mdrp[rnd,grey]  45
mirp[rp0,rnd,grey]  hstem 16
mdrp[rp0,rnd,grey] 13
mdrp[rp0,rnd,grey]  1
mirp[min,rnd,grey]  hstem 0
srp0 13
mdrp[rp0,rnd,white]  12
mdrp[min,rnd,grey]  2
srp1    22
srp2    1
ip  7
mdap[rnd]   7
mirp[min,rnd,grey]  headstem 41
mirp[rnd,grey]  headstem_plus_hole 35
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[rnd,grey]  vstem_236  13
mirp[rp0,rnd,grey]  vheight_shoot 26
mirp[min,rnd,grey]  vstem_236 19
ip  23
ip  22
mdrp[rp0,rnd,white]  10
mirp[min,rnd,grey]  headstem 38
mirp[rp0,rnd,grey]  headdia 4
ip  2
ip  12
mirp[min,rnd,grey]  headstem 32
srp1    19
srp2    13
ip  14
ip  31
IUP[y]
""",

    #cho_ching
    "uni0E09": """
srp0    65
mirp[rp0,min,rnd,grey] front_kai 7
mdrp[rnd,grey]  22
mirp[min,rnd,grey]  headstem 50
mirp[rnd,grey]  headstem_plus_hole 44
mdrp[rp0,rnd,grey]  12
mirp[rp0,min,rnd,grey]  hstem 1
mirp[rp0,rnd,grey]  w_866 29
mirp[rp0,min,rnd,grey]  hstem 15
alignrp 39
mdrp[rp0,rnd,grey]  33
mirp[min,rnd,grey]  headstem 56
mirp[rnd,grey]  headstem_plus_hole 62
mdrp[rnd,white]  66
IUP[x]
SVTCA[y-axis]
mdap[rnd]   0
mirp[min,rnd,grey]  vstem_258 13
mdrp[rnd,grey]      39
mirp[rnd,grey]      vheight_lo  36
mirp[rp0,rnd,grey]  vheight_shoot  26
mirp[min,rnd,grey]  vstem_236 19
mdrp[rp0,min,rnd,white]  10
mdrp[rp0,rnd,grey]  4
mirp[min,rnd,grey]  headstem 41
mirp[rnd,grey]  headstem_plus_hole 47
srp0    36
mdrp[min,rnd,grey]  53
mdrp[rp0,rnd,grey]  30
alignrp 15
mdrp[min,rnd,grey]  59
IUP[y]
""",

    #cho_chang
    "uni0E0A": """
srp0    62
mdrp[rp0,min,rnd,grey]  19
mirp[min,rnd,grey]  headstem_small 59
mirp[rp0,rnd,grey]  headdia_small 13
mirp[min,rnd,grey]  headstem_small 53
mdrp[rp0,min,rnd,grey]  7
srp0    19
mdrp[rp0,rnd,grey]  25
mdrp[rnd,white] 37
srp0    19
mdrp[rp0,rnd,grey]  47
mirp[min,rnd,grey]  hstem 34
mdrp[rnd,white] 63
mdrp[rp0,rnd,grey]  42
mirp[min,rnd,grey]  hstem 41
srp0    47
mirp[rp0,rnd,grey]  w_926   1
mirp[min,rnd,grey]  hstem 30
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
mirp[min,rnd,grey]  vstem_236 31
mdrp[rnd,grey]      42
mirp[rp0,rnd,grey]  vheight_shoot 22
sloop 3
ip 38 45 37
mdrp[min,rnd,grey]  10
mdrp[rp0,rnd,grey]  16
mirp[min,rnd,grey]  headstem_small 50
mirp[rnd,grey]  headstem_small_plus_hole 56
IUP[y]
""",

    #so_zo
    "uni0E0B": """
srp0    68
mirp[rp0,min,rnd,grey] front_khai 24
mdrp[min,rnd,grey]  13
mdrp[rp0,rnd,grey]  18
mdrp[rnd,white]     4
mirp[min,rnd,grey]  headstem   59
mirp[rnd,grey]  headstem_plus_hole 65
srp0    24
mdrp[rp0,rnd,grey]  31
mdrp[rnd,white] 43
mirp[min,rnd,grey]  vstem_236 7
srp0    24
mdrp[rp0,rnd,grey]  53
mirp[min,rnd,grey]  hstem 40
ip  51
mirp[rp0,rnd,grey]  w_926 1
mirp[min,rnd,grey]  hstem 36
srp0    53
mdrp[rp0,rnd,grey]  48
mdrp[rnd,white] 69
mirp[min,rnd,grey]  hstem 47
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[min,rnd,grey]  vstem_236 37
mdrp[rnd,grey]  46
mirp[rp0,rnd,grey]  vheight_shoot   27
alignrp     29
sloop   3
ip  44 51 43
mirp[min,rnd,grey]  headstem 11
shp[rp2]    9
mdrp[rp0,min,rnd,grey]  28
mirp[min,rnd,grey]  headstem 10
mdrp[rp0,rnd,white]  15
mirp[min,rnd,grey]  headstem 62
mirp[rp0,rnd,grey]  headdia 21
mirp[min,rnd,grey]  headstem 56
srp1    11
srp2    37
sloop   6
ip  4 5 34 33 2 36
IUP[y]
""",

    #sho_sher
    "uni0E0C": """
srp0    75
mirp[rp0,min,rnd,grey] front_kai 38
#mdrp[min,rnd,grey]  19
#mdrp[rp0,rnd,grey]  21
#mdrp[min,rnd,grey]  37
#srp0    38
mdrp[rp0,rnd,grey]  34
mirp[min,rnd,grey]  hstem 23
ip  37
ip  21
mdrp[rp0,rnd,grey]  29
mirp[min,rnd,grey]  headstem 54
mirp[rnd,grey]  headstem_plus_hole 60
mdrp[rp0,rnd,white]  9
mirp[min,rnd,grey]  headstem 72
mirp[rnd,grey]  headstem_plus_hole 66
srp0    34
mirp[rp0,rnd,grey]  w_1133 45
alignrp 3
mirp[min,rnd,grey]  hstem 12
mirp[rp0,rnd,grey]  w_569 50
mdrp[min,rnd,grey]  76
mirp[min,rnd,grey]  hstem 48
shp[rp2]    1
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[rnd,grey]  vheight_lo  6
shp[rp2]    32
mirp[rnd,grey]  vheight 50
mirp[min,rnd,grey]  vstem_258 48
mirp[rp0,rnd,grey]  vheight_shoot 42
mirp[min,rnd,grey]  vstem_236 16
srp0    6
mdrp[min,rnd,grey]  3
mdrp[rp0,rnd,grey]  46
alignrp 12
srp0    32
mdrp[rp0,rnd,grey]  26
mirp[min,rnd,grey]  headstem 57
shp[rp2]    69
mirp[rnd,grey]  headstem_plus_hole 51
shp[rp2]    63
srp1    16
srp2    1
sloop   10
ip  39 19 38 37 20 21 35 23 13 45
IUP[y]
""",

    #yo_ying
    "uni0E0D": """
srp0    80
mirp[rp0,min,rnd,grey] front_kai 27
mdrp[rp0,rnd,grey]  23
mirp[min,rnd,grey]  hstem 12
ip  26
ip  10
mdrp[rp0,rnd,grey]  18
mirp[min,rnd,grey]  headstem 42
mirp[rnd,grey]  headstem_plus_hole 48
srp0    23
mirp[rp0,rnd,grey]  w_1081 34
mirp[min,rnd,grey]  hstem 1
ip  54
mirp[rp0,rnd,grey]  w_522 38
mirp[min,rnd,grey]  hstem 36
ip  65
ip  66
mdrp[rnd,white]  81
srp0    54
mirp[min,rnd,grey]  headstem_tiny 77
mirp[rp0,rnd,grey]  headdia_tiny 60
mirp[min,rnd,grey]  headstem_tiny 71
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[min,rnd,grey]  vstem_236 35
mirp[rnd,grey]  vheight_lo 21
mirp[rnd,grey]  vheight 38
mirp[rp0,rnd,grey]  vheight_shoot 31
mirp[min,rnd,grey]  vstem_236 5
srp0    21
mdrp[rp0,rnd,grey] 15
mirp[min,rnd,grey]  headstem 45
mirp[rnd,grey]  headstem_plus_hole 39
srp1    5
srp2    15
sloop   10
ip  28 27 8 26 9 10 24 12 2 34
srp0    1
mdrp[rp0,rnd,white] 57
mirp[min,rnd,grey]  headstem_tiny 74
mirp[rnd,grey]  headstem_tiny_plus_hole 68
mdrp[rp0,rnd,grey]  51
ip  65
ip  66
mirp[min,rnd,grey]  headstem_tiny 61
IUP[y]
""",

    #yo_ying
    "uni0E0D.descless": """
srp0    51
mirp[rp0,min,rnd,grey] front_kai 27
mdrp[rp0,rnd,grey]  23
mirp[min,rnd,grey]  hstem 12
ip  26
ip  10
mdrp[rp0,rnd,grey]  18
mirp[min,rnd,grey]  headstem 42
mirp[rnd,grey]  headstem_plus_hole 48
srp0    23
mirp[rp0,rnd,grey]  w_1081 34
mirp[min,rnd,grey]  hstem 1
ip  54
mirp[rp0,rnd,grey]  w_522 38
mirp[min,rnd,grey]  hstem 36
mdrp[rnd,white]  52
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[min,rnd,grey]  vstem_236 35
mirp[rnd,grey]  vheight_lo 21
mirp[rnd,grey]  vheight 38
mirp[rp0,rnd,grey]  vheight_shoot 31
mirp[min,rnd,grey]  vstem_236 5
srp0    21
mdrp[rp0,rnd,grey] 15
mirp[min,rnd,grey]  headstem 45
mirp[rnd,grey]  headstem_plus_hole 39
srp1    5
srp2    15
sloop   10
ip  28 27 8 26 9 10 24 12 2 34
IUP[y]
""",

    #do_chada
    "uni0E0E": """
srp0    72
mirp[rp0,rnd,white]  front_thahan 35
mirp[min,rnd,grey]  headstem 61
mirp[rnd,grey]  headstem_plus_hole 55
mdrp[rp0,rnd,grey]  29
sloop   4
ip  44 43 25 27
mirp[rp0,min,rnd,grey]  hstem 40
alignrp 8
#mdrp[rp0,rnd,grey]  44
#mdrp[min,rnd,grey]  25
#mdrp[rp0,rnd,grey]  27
#mdrp[min,rnd,grey]  43
srp0    40
mirp[rp0,rnd,grey]  w_1024 51
mdrp[rnd,white] 73
mirp[min,rnd,grey]  hstem 18
shp[rp2]    1
srp0    8
mirp[rp0,min,rnd,grey]  w_195 70
mdrp[rp0,rnd,white]  66
srp1    1
sloop 5
ip 13 14 15 16 3
IUP[x]
SVTCA[y-axis]
mdap[rnd]   72
mirp[rnd,grey]  vheight_lo 32
mirp[rnd,grey]  vheight_lu 1
shp[rp2]    5
mirp[rp0,rnd,grey]  vheight_shoot 48
sloop   10
ip  45 44 25 43 26 27 41 29 19 51
mirp[min,rnd,grey]  vstem_236   22
srp0    32
mdrp[rp0,rnd,grey]  38
mirp[min,rnd,grey]  headstem 58
mirp[rnd,grey]  headstem_plus_hole 52
srp0    5
mirp[rp0,min,rnd,grey]  vstem_tiny 64
mdrp[rp0,min,rnd,white]  68
mirp[rp0,min,rnd,grey]  vstem_tiny 11
srp1    5
sloop 7
ip 14 13 15 16 3 66 18
IUP[y]
""",

    #to_patak
    "uni0E0F": """
srp0    78
mirp[rp0,rnd,white]  front_thahan 41
mirp[min,rnd,grey]  headstem 67
mirp[rnd,grey]  headstem_plus_hole 61
mdrp[rp0,rnd,grey]  35
sloop   5
ip  50 49 31 33 11
mirp[rp0,min,rnd,grey]  hstem   46
#mdrp[rp0,rnd,grey]  50
#mdrp[min,rnd,grey]  31
#mdrp[rp0,rnd,grey]  33
#mdrp[min,rnd,grey]  49
#srp0    46
mirp[rp0,rnd,grey]  w_1024 57
mdrp[rnd,white] 79
mirp[min,rnd,grey]  hstem 24
shp[rp2]    1
srp0    11
mirp[rp0,min,rnd,grey]  vstem_tiny 76
mdrp[rp0,rnd,white]  72
srp1    24
sloop 11
ip 16 17 18 19 21 22 23 6 4 3 2
IUP[x]
SVTCA[y-axis]
mdap[rnd]   78
mirp[rnd,grey]  vheight_lo 38
mirp[rnd,grey]  vheight_lu 1
shp[rp2]    3
shp[rp2]    8
mirp[rp0,rnd,grey]  vheight_shoot 54
sloop   10
ip  51 50 31 49 32 33 47 35 25 57
mirp[min,rnd,grey]  vstem_236   28
srp0    38
mdrp[rp0,rnd,grey]  44
mirp[min,rnd,grey]  headstem 64
mirp[rnd,grey]  headstem_plus_hole 58
srp0    8
mirp[rp0,min,rnd,grey]  vstem_tiny 70
mdrp[rp0,min,rnd,white]  74
mirp[rp0,min,rnd,grey]  vstem_tiny 14
srp1    8
sloop 11
ip 16 17 18 19 21 22 23 24 72 6 2
IUP[y]
""",

    #tho_than
    "uni0E10": """
srp0    113
mirp[rp0,min,rnd,grey]  front_kai 19
mdrp[min,rnd,grey]  39
mirp[rp0,rnd,grey]  w_973 42
ip  7
alignrp 90
mirp[rp0,min,rnd,grey]  hstem   16
mdrp[rp0,min,rnd,white] 12
ip  13
mdrp[min,rnd,grey]  2
srp0    42
mdrp[rp0,rnd,grey]  30
mdrp[rnd,white] 114
srp0    42
mdrp[rp0,rnd,grey]  1
mirp[min,rnd,grey]  hstem 0
mdap[rnd]   7
alignrp 67
mirp[min,rnd,grey]  headstem 54
mirp[rnd,grey]  headstem_plus_hole 48
srp0    90
mirp[min,rnd,grey]  vstem_236 80
mdrp[rp0,rnd,grey]  84
mirp[min,rnd,grey]  headstem_tiny 102
mirp[rnd,grey]  headstem_tiny_plus_hole 96
srp0    67
mirp[rp0,min,rnd,grey]  headstem 111
mirp[rnd,white]  headstem 107
srp1    80
sloop   13
ip  72 73 74 75 76 77 78 79 58 59 60 61 62
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
mirp[min,rnd,grey]  vstem_236 13
mirp[rp0,rnd,grey]  vheight_shoot   22
mirp[min,rnd,grey]  vstem_236 37
mdrp[rp0,rnd,grey]  29
mirp[min,rnd,grey]  vstem_236 30
mdrp[rp0,min,rnd,white]  27
mirp[rp0,rnd,grey]  vstem_236 32
mdrp[rp0,rnd,white] 40
mirp[rp0,min,rnd,grey]  headstem 18
mdrp[rp0,rnd,white] 10
mirp[min,rnd,grey]  headstem 51
mirp[rp0,rnd,grey]  headdia 4
mirp[min,rnd,grey]  headstem 45
srp1    22
srp2    1
sloop   5
ip  20 19 39 14 44
srp0    1
mdrp[rp0,rnd,white]  87
mirp[min,rnd,grey]  headstem_tiny 99
mirp[rp0,rnd,grey]  headdia_tiny 81
mirp[min,rnd,grey]  headstem_tiny 93
mdrp[rp0,rnd,white] 80
alignrp 76
alignrp 105
mirp[rp0,rnd,grey]  headstem_tiny 57
alignrp 60
alignrp 64
srp0    105
mdrp[rp0,rnd,white] 109
mirp[min,rnd,grey]  headstem_tiny 70
srp2    64
sloop   7
ip  107 72 73 74 75 62 59
IUP[y]
""",

    #tho_than.descless
    "uni0E10.descless": """
srp0    57
mirp[rp0,min,rnd,grey]  front_kai 19
mdrp[min,rnd,grey]  39
mirp[rp0,rnd,grey]  w_973 42
ip  7
mirp[rp0,min,rnd,grey]  hstem   16
mdrp[rp0,min,rnd,white] 12
ip  13
mdrp[min,rnd,grey]  2
srp0    42
mdrp[rp0,rnd,grey]  30
srp0    42
mdrp[rp0,rnd,grey]  1
mirp[min,rnd,grey]  hstem 0
mdap[rnd]   7
mirp[min,rnd,grey]  headstem 54
mirp[rnd,grey]  headstem_plus_hole 48
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
mirp[min,rnd,grey]  vstem_236 13
mirp[rp0,rnd,grey]  vheight_shoot   22
mirp[min,rnd,grey]  vstem_236 37
mdrp[rp0,rnd,grey]  29
mirp[min,rnd,grey]  vstem_236 30
mdrp[rp0,min,rnd,white]  27
mirp[rp0,rnd,grey]  vstem_236 32
mdrp[rp0,rnd,white] 40
mirp[rp0,min,rnd,grey]  headstem 18
mdrp[rp0,rnd,white] 10
mirp[min,rnd,grey]  headstem 51
mirp[rp0,rnd,grey]  headdia 4
mirp[min,rnd,grey]  headstem 45
srp1    22
srp2    1
sloop   5
ip  20 19 39 14 44
srp0    1
IUP[y]
""",

    #to_nangmonto
    "uni0E11": """
srp0    70
mirp[rp0,min,rnd,grey]  front_khai 35
mdrp[min,rnd,grey]  24
mdrp[rp0,rnd,grey]  29
mirp[min,rnd,grey]  headstem_small 61
mirp[rnd,grey]  headstem_small_plus_hole 67
mdrp[rnd,white] 15
srp0    35
mdrp[rp0,rnd,grey]  42
mirp[min,rnd,grey]  vstem_236 18
mdrp[rp0,rnd,white] 53
mirp[rp0,min,rnd,grey]  headstem_small 6
mdrp[rp0,rnd,white] 1
mirp[rp0,min,rnd,grey]  hstem 57 
mdrp[rnd,white] 71
mirp[rp0,rnd,grey]  w_1120 12
mirp[min,rnd,grey]  hstem 48
shp[rp2]    11
IUP[x]
SVTCA[y-axis]
mdap[rnd]   12
alignrp 1
mirp[min,rnd,grey]  vstem_236 48
mirp[rp0,rnd,grey]  vheight_shoot   55
alignrp 38
alignrp 40
mirp[min,rnd,grey]  vstem_236 4
srp0    38
mirp[min,rnd,grey]  headstem 22
shp[rp2]    20
mdrp[rp0,min,rnd,white]  39
mirp[rp0,min,rnd,grey]  headstem 21
mdrp[rp0,rnd,white]  26
mirp[min,rnd,grey]  headstem_small 64
mirp[rp0,rnd,grey]  headdia_small 32
mirp[min,rnd,grey]  headstem_small 58
srp1    55
srp2    46
sloop   8
ip  15 16 44 45 50 51 8 9
IUP[y]
""",

    #to_putao
    "uni0E12": """
SRP0                80
MIRP[rp0,min,rnd,grey]   front_kai 42
MIRP[rp0,min,rnd,grey]   hstem  20
mdrp[rp0,rnd,white] 23
srp0    42
mdrp[rp0,rnd,grey]  39
mirp[min,rnd,grey]  hstem 38
srp0    20
mdrp[rp0,rnd,white] 29
mirp[min,rnd,grey]  headstem 65
mirp[rp0,rnd,grey]  headdia 35
mirp[min,rnd,grey]  headstem 59
mdrp[rp0,rnd,grey]  9
mirp[min,rnd,grey]  headstem 77
mirp[rnd,grey]  headstem_plus_hole 71
srp0    42
mirp[rp0,rnd,grey]  w_1290 50
alignrp 3
sloop   7
ip  45 46 47 15 16 17 18
mirp[min,rnd,grey]  hstem 12
mirp[rp0,rnd,grey]  w_569 55
mirp[min,rnd,grey]  hstem 53
shp[rp2]    1
mdrp[rnd,white] 81
IUP[x]
SVTCA[y-axis]
MDAP[rnd]           38
ALIGNRP             1
mirp[rnd,grey]      vheight_lo 6
mirp[rp0,rnd,grey]  vheight_shoot 45
alignrp     47
MIRP[min,rnd,grey]  vstem_236  18
shp[rp2]    15
mdrp[rp0,min,rnd,grey]  46
mdrp[min,rnd,grey]  17
srp0    45
mdrp[rp0,rnd,grey]  32
mirp[min,rnd,grey]  headstem 62
mirp[rp0,rnd,grey]  headdia 26
mirp[min,rnd,grey]  headstem 56
srp0    6
mdrp[min,rnd,grey]  68
mdrp[min,rnd,grey]  3
mdrp[rnd,grey]  74
mdrp[min,rnd,grey]  12
shp[rp2]    51
srp0    1
mirp[min,rnd,grey]  vstem_258 53
IUP[y]
""",

    #no_nen
    "uni0E13": """
srp0    75
mirp[rp0,min,rnd,grey] front_kai 27
#mdrp[min,rnd,grey]  8
#mdrp[rp0,rnd,grey]  10
#mdrp[min,rnd,grey]  26
#srp0    27
mdrp[rp0,rnd,grey]  23
mirp[min,rnd,grey]  hstem 12
mdrp[rp0,rnd,grey]  18
mirp[min,rnd,grey]  headstem 54
mirp[rnd,grey]  headstem_plus_hole 60
srp0    23
mirp[rp0,rnd,grey]  w_1081 34
alignrp 0
mirp[min,rnd,grey]  hstem 1
mirp[rp0,rnd,grey]  w_522 39
mirp[min,rnd,grey]  hstem 37
shp[rp2]    49
mdrp[rp0,rnd,grey]  43
mirp[min,rnd,grey]  headstem 66
mirp[rnd,grey]  headstem_plus_hole 72
mdrp[rnd,white]     76
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[min,rnd,grey]  vstem_258 35
mirp[rnd,grey]  vheight_lo 21
shp[rp2]    46
mirp[rnd,grey]  vheight 39
mirp[rp0,rnd,grey]  vheight_shoot 31
mirp[min,rnd,grey]  vstem_236 5
srp0    21
mdrp[rp0,rnd,grey]  15
mirp[min,rnd,grey]  headstem 57
shp[rp2]    69
mirp[rnd,grey]  headstem_plus_hole 51
shp[rp2]    63
mdrp[rp0,rnd,grey]  37
alignrp     40
mdrp[min,rnd,grey]  49
srp1    5
srp2    1
sloop   10
ip  26 27 28 8 9 10 24 12 2 34
IUP[y]
""",

    #do_dek
    "uni0E14": """
SRP0                     49
MIRP[rp0,min,rnd,grey]   front_kai 30
MIRP[rp0,min,rnd,grey]   hstem  8
mdrp[rp0,rnd,white] 11
srp0    30
mdrp[rp0,rnd,grey]  27
mirp[min,rnd,grey]  hstem 26
srp0    8
mdrp[rp0,rnd,white] 17
mirp[min,rnd,grey]  headstem 46
mirp[rnd,grey]  headstem_plus_hole 40
ip  14
srp0    30
mirp[rp0,rnd,grey]  w_1290 36
mirp[min,rnd,grey]  hstem 1
srp1    40
ip  23
mdrp[rnd,white] 50
IUP[x]
SVTCA[y-axis]
MDAP[rnd]           26
ALIGNRP             1
mirp[min,rnd,grey]  vstem_236 11
MIRP[rp0,rnd,grey]  vheight_shoot  33
MIRP[min,rnd,grey]  vstem_236  5
mdrp[rp0,rnd,grey]  20
mirp[min,rnd,grey]  headstem 43
mirp[rp0,rnd,grey]  headdia 14
mirp[min,rnd,grey]  headstem 37
IUP[y]
""",

    #to_tao
    "uni0E15": """
SRP0                52
MIRP[rp0,min,rnd,grey]   front_kai 31
MIRP[rp0,min,rnd,grey]   hstem  9
mdrp[rp0,rnd,white] 12
srp0    31
mdrp[rp0,rnd,grey]  28
mirp[min,rnd,grey]  hstem 27
srp0    9
mdrp[rp0,rnd,white] 18
mirp[min,rnd,grey]  headstem 49
mirp[rnd,grey]  headstem_plus_hole 43
ip  15
srp0    31
mirp[rp0,rnd,grey]  w_1290 39
sloop   7
ip  34 35 36 4 5 6 7
mirp[min,rnd,grey]  hstem 1
srp1    43
ip  24
mdrp[rnd,white] 53
IUP[x]
SVTCA[y-axis]
MDAP[rnd]           27
ALIGNRP             1
mirp[min,rnd,grey]  vstem_236 12
MIRP[rp0,rnd,grey]  vheight_shoot  34
alignrp 36
MIRP[min,rnd,grey]  vstem_236  7
shp[rp2]    4
mdrp[rp0,min,rnd,grey]  35
mdrp[min,rnd,grey]  6
srp0    34
mdrp[rp0,rnd,grey]  21
mirp[min,rnd,grey]  headstem 46
mirp[rp0,rnd,grey]  headdia 15
mirp[min,rnd,grey]  headstem 40
IUP[y]
""",

    #to_tung
    "uni0E16": """
srp0    47
mirp[rp0,min,rnd,grey] front_kai 27
mdrp[rp0,rnd,grey]  23
mirp[min,rnd,grey]  hstem 12
ip  26
ip  10
mirp[rp0,rnd,grey]  w_1081 34
mirp[min,rnd,grey]  hstem 1
mdrp[rnd,white]  48
srp0 23
mdrp[rp0,rnd,grey]  18
mirp[min,rnd,grey]  headstem 38
mirp[rnd,grey]  headstem_plus_hole 44
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[rnd,grey]  vheight_lo 21
mirp[rp0,rnd,grey]  vheight_shoot 31
mirp[min,rnd,grey]  vstem_236 5
srp0    21
mdrp[rp0,rnd,grey]  15
mirp[min,rnd,grey]  headstem    41
mirp[rnd,grey]  headstem_plus_hole 35
srp1    5
srp2    1
sloop   10
ip  28 8 27 9 26 10 2 34 24 12
IUP[y]
""",

    #tho_thahan
    "uni0E17": """
srp0    40
mirp[rp0,rnd,white]  front_thahan 14
mirp[min,rnd,grey]  headstem 37
mirp[rnd,grey]  headstem_plus_hole 31
mdrp[rp0,rnd,grey]  19
alignrp     7
mirp[rp0,min,rnd,grey]  hstem 8
mirp[rp0,rnd,grey]  w_1024 27
mirp[min,rnd,grey]  hstem 1
srp1   19
ip  21
ip  6
mdrp[rnd,white] 41
IUP[x]
SVTCA[y-axis]
mdap[rnd]  8
alignrp 1
mdrp[rnd,grey]  20
mirp[rp0,rnd,grey]  vheight_shoot 24
alignrp 17
mirp[min,rnd,grey]  vstem_258 4
srp0    17
mdrp[rp0,rnd,grey]  11
mirp[min,rnd,grey]  headstem 28
mirp[rnd,grey]  headstem_plus_hole 34
IUP[y]
""",

    #to_thong
    "uni0E18": """
srp0    37
mirp[rp0,min,rnd,grey] front_kai 12
mdrp[min,rnd,grey]  31
mdrp[rp0,rnd,grey]  1
mirp[min,rnd,grey]  hstem 3
mirp[rp0,rnd,grey]  w_926 34
mirp[min,rnd,grey]  hstem 7
mdrp[rp0,rnd,grey]  22
mdrp[rnd,white] 38
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[min,rnd,grey]  vstem_236 4
mirp[rp0,rnd,grey]  vheight_shoot 14
mirp[min,rnd,grey]  vstem_236 29
mdrp[rp0,rnd,grey]  21
mirp[min,rnd,grey]  vstem_236 22
srp0    14
mdrp[rp0,min,rnd,grey]  19
mirp[rp0,min,rnd,grey]  vstem_236 24
mdrp[rp0,rnd,white] 32
mirp[rp0,rnd,grey]  headstem 10
mdrp[rnd,white] 3
srp1    29
srp2    1
sloop   7
ip  11 12 31 8 7 34 35
IUP[y]
""",

    #no_nu
    "uni0E19": """
srp0    53
mirp[rp0,rnd,white]  front_thahan 7
mirp[min,rnd,grey]  headstem 38
mirp[rnd,grey]  headstem_plus_hole 32
mdrp[rp0,rnd,grey]  12
alignrp 0
mirp[rp0,min,rnd,grey]  hstem 1
mirp[rp0,rnd,grey]  w_926 17
mirp[rp0,min,rnd,grey]  hstem 15
shp[rp2]    27
mdrp[rp0,rnd,grey]  21
mirp[min,rnd,grey]  headstem 44
mirp[rnd,grey]  headstem_plus_hole 50
mdrp[rnd,white] 54
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[min,rnd,grey]  vstem_236 13
mirp[rnd,grey]  vheight_lo 24
mirp[rnd,grey]  vheight 17
mirp[rp0,rnd,grey]  vheight_shoot 10
mdrp[rp0,rnd,grey]  4
mirp[min,rnd,grey]  headstem 29
mirp[rnd,grey]  headstem_plus_hole 35
srp0    24
mdrp[min,rnd,grey]  27
mdrp[min,rnd,grey]  41
mdrp[rp0,rnd,grey]  18
mdrp[rnd,grey]  15
mdrp[min,rnd,grey]  47
IUP[y]
""",

    #bo_baimai
    "uni0E1A": """
srp0    29
mirp[rp0,rnd,white]  front_thahan 7
mirp[min,rnd,grey]  headstem 26
mirp[rnd,grey]  headstem_plus_hole 20
mdrp[rp0,rnd,grey]  12
mirp[rp0,min,rnd,grey]  hstem 1
mirp[rp0,rnd,grey]  w_1024 16
mirp[min,rnd,grey]  hstem 14
mdrp[rnd,white]  30
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[min,rnd,grey]  vstem_236 13
mirp[rnd,grey]  vheight 16
mirp[rp0,rnd,grey]  vheight_shoot 10
mdrp[rp0,rnd,grey]  4
mirp[min,rnd,grey]  headstem 17
mirp[rnd,grey]  headstem_plus_hole 23
IUP[y]
""",

    #po_pla
    "uni0E1B": """
srp0    29
mirp[rp0,rnd,white]  front_thahan 7
mirp[min,rnd,grey]  headstem 26
mirp[rnd,grey]  headstem_plus_hole 20
mdrp[rp0,rnd,grey]  12
mirp[rp0,min,rnd,grey]  hstem 1
mirp[rp0,rnd,grey]  w_1024 16
mirp[min,rnd,grey]  hstem 14
mdrp[rnd,white]  30
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[min,rnd,grey]  vstem_236 13
mirp[rnd,grey]  vheight_po 16
mirp[rp0,rnd,grey]  vheight_shoot 10
mdrp[rp0,rnd,grey]  4
mirp[min,rnd,grey]  headstem 17
mirp[rnd,grey]  headstem_plus_hole 23
IUP[y]
""",

    #po_pung
    "uni0E1C": """
srp0    34
mirp[rp0,min,rnd,grey]  front_dek 4
mirp[min,rnd,grey]  hstem 15
shp[rp2]    3
mdrp[rp0,rnd,grey]  10
mirp[min,rnd,grey]  headstem 25
mirp[rnd,grey]  headstem_plus_hole 31
srp0    4
mirp[rp0,rnd,grey]  w_1180 21
mirp[min,rnd,grey]  hstem   19
shp[rp2]    1
srp1    15
sloop   3
ip  17 18 2
IUP[x]
SVTCA[y-axis]
mdap[rnd]   0
alignrp     3
mdrp[min,rnd,grey]  19
shp[rp2]    16
mirp[rnd,grey]  vheight 21
mirp[rp0,rnd,grey]  vheight_shoot 7
mdrp[rp0,rnd,grey]  13
mirp[min,rnd,grey]  headstem 22
mirp[rnd,grey]  headstem_plus_hole 28
srp1    0
ip  17
ip  2
IUP[y]
""",

    #fo_fa
    "uni0E1D": """
srp0    34
mirp[rp0,min,rnd,grey]  front_dek 4
mirp[min,rnd,grey]  hstem 15
shp[rp2]    3
mdrp[rp0,rnd,grey]  10
mirp[min,rnd,grey]  headstem 25
mirp[rnd,grey]  headstem_plus_hole 31
srp0    4
mirp[rp0,rnd,grey]  w_1180 21
mdrp[rnd,white] 35
mirp[min,rnd,grey]  hstem   19
shp[rp2]    1
srp1    15
sloop   3
ip  17 18 2
IUP[x]
SVTCA[y-axis]
mdap[rnd]   0
alignrp     3
mdrp[min,rnd,grey]  19
shp[rp2]    16
mirp[rnd,grey]  vheight_po 21
mirp[rp0,rnd,grey]  vheight_shoot 7
mdrp[rp0,rnd,grey]  13
mirp[min,rnd,grey]  headstem 22
mirp[rnd,grey]  headstem_plus_hole 28
srp1    0
ip  17
ip  2
IUP[y]
""",

    #po_pan
    "uni0E1E": """
srp0    34
mirp[rp0,min,rnd,grey]  front_khai 10
mirp[min,rnd,grey]  headstem 31
mirp[rnd,grey]  headstem_plus_hole 25
mdrp[rp0,rnd,grey]  15
alignrp 3
mirp[rp0,min,rnd,grey]  hstem 4
mirp[rp0,rnd,grey]  w_1180 21
mirp[min,rnd,grey]  hstem   19
shp[rp2]    1
srp1    15
sloop   3
ip  17 18 2
mdrp[rnd,white]  35
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
alignrp     3
mdrp[min,rnd,grey]  19
shp[rp2]    16
mirp[min,rnd,grey]  vheight 21
shp[rp2]     18
ip  2
mirp[rp0,rnd,grey]  vheight_shoot 13
mdrp[rp0,rnd,grey]  7
mirp[min,rnd,grey]  headstem 22
mirp[rnd,grey]  headstem_plus_hole 28
IUP[y]
""",

    #fo_fun
    "uni0E1F": """
srp0    34
mirp[rp0,min,rnd,grey]  front_khai 10
mirp[min,rnd,grey]  headstem 31
mirp[rnd,grey]  headstem_plus_hole 25
mdrp[rp0,rnd,grey]  15
alignrp 3
mirp[rp0,min,rnd,grey]  hstem 4
mirp[rp0,rnd,grey]  w_1180 21
mirp[min,rnd,grey]  hstem   19
shp[rp2]    1
srp1    15
sloop   3
ip  17 18 2
mdrp[rnd,white]  35
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
alignrp     3
mdrp[min,rnd,grey]  19
shp[rp2]    16
mirp[min,rnd,grey]  vheight_po 21
shp[rp2]     18
ip  2
mirp[rp0,rnd,grey]  vheight_shoot 13
mdrp[rp0,rnd,grey]  7
mirp[min,rnd,grey]  headstem 22
mirp[rnd,grey]  headstem_plus_hole 28
IUP[y]
""",

    #po_sampao
    "uni0E20": """
srp0    47
mirp[rp0,rnd,white]  front_thahan 18
mirp[min,rnd,grey]  headstem 44
mirp[rnd,grey]  headstem_plus_hole 38
mdrp[rp0,rnd,grey]  12
sloop   4
ip  27 26 8 10
mirp[rp0,min,rnd,grey]  hstem 23
mirp[rp0,rnd,grey]  w_1024 34
mdrp[rnd,white] 48
mirp[min,rnd,grey]  hstem 1
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
mirp[rnd,grey]  vheight_lo 15
mirp[rp0,rnd,grey]  vheight_shoot 31
sloop   10
ip  28 27 8 26 9 10 24 12 2 34
mirp[min,rnd,grey]  vstem_236   5
srp0    15
mdrp[rp0,rnd,grey]  21
mirp[min,rnd,grey]  headstem 41
mirp[rnd,grey]  headstem_plus_hole 35
IUP[y]
""",

    #mo_ma
    "uni0E21": """
srp0    55
mirp[rp0,rnd,white]  front_thahan 9
alignrp 20
mirp[min,rnd,grey]  headstem 52
shp[rp2]    40
mirp[rnd,grey]  headstem_plus_hole 46
shp[rp2]    34
mdrp[rp0,rnd,grey]  25
alignrp 3
mirp[rp0,min,rnd,grey]  hstem 14
mirp[rp0,rnd,grey]  w_1024 30
mirp[min,rnd,grey]  hstem   28
shp[rp2]    1
mdrp[rnd,white]  56
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
mirp[rnd,grey]  vheight_lo 6
mirp[rnd,grey]  vheight 30
mirp[min,rnd,grey]  vstem_236 28
mirp[rp0,rnd,grey]  vheight_shoot 23
mdrp[rp0,rnd,grey]  17
mirp[min,rnd,grey]  headstem 31
mirp[rnd,grey]  headstem_plus_hole 37
srp0    6
mdrp[min,rnd,grey]  3
mdrp[rp0,rnd,grey]  12
mirp[min,rnd,grey]  headstem 49
mirp[rnd,grey]  headstem_plus_hole 43
mdrp[rnd,grey]  26
IUP[y]
""",

    #yo_yak
    "uni0E22": """
srp0    44
mirp[rp0,min,rnd,grey]  front_kai 8
mirp[min,rnd,grey]  vstem_258 19
mdrp[rp0,rnd,grey]  14
mirp[min,rnd,grey]  headstem 35
mirp[rnd,grey]  headstem_plus_hole 41
mdrp[rp0,rnd,white] 29
mirp[rp0,min,rnd,grey]  hstem 31
mdrp[rnd,white] 45
mirp[rp0,rnd,grey]  w_1051 1
mirp[min,rnd,grey]  hstem  28
ip  5
srp1    29
ip  24
IUP[x]
SVTCA[y-axis]
mdap[rnd] 1
mirp[rnd,grey]      vheight 31
mirp[min,rnd,grey]  vstem_236 28
mirp[rp0,rnd,grey]  vheight_shoot 11
mdrp[rp0,rnd,grey]  17
mirp[min,rnd,grey]  headstem 32
mirp[rnd,grey]  headstem_plus_hole 38
srp1    1
sloop   3
ip  5 23 24
IUP[y]
""",

    #ro_ruar
    "uni0E23": """
srp0    50
mirp[rp0,rnd,white]  front_thahan 12
mirp[min,rnd,grey]  vstem_258 32
mirp[rp0,rnd,grey]  w_866 35
mirp[min,rnd,grey]  hstem 8
mdrp[rp0,rnd,grey]  23
mdrp[rnd,white]  51
srp0    35
mdrp[rp0,rnd,grey]  3
mirp[min,rnd,grey]  headstem 47
mirp[rnd,grey]  headstem_plus_hole 41
IUP[x]
SVTCA[y-axis]
mdap[rnd]  50
mirp[rnd,grey]  vheight_lo 0
mirp[rp0,rnd,grey]  vheight_shoot 15
mirp[min,rnd,grey]  vstem_236 30
mdrp[rp0,rnd,grey]  22
mirp[min,rnd,grey]  vstem_236 23
srp0    15
mdrp[rp0,min,rnd,grey]  20
mirp[rp0,rnd,grey]  vstem_236 25
mdrp[rp0,rnd,white] 33
mirp[rp0,min,rnd,grey]  headstem 11
srp0    0
mdrp[rp0,rnd,grey]  6
mirp[min,rnd,grey]  headstem 44
mirp[rnd,grey]  headstem_plus_hole 38
srp1 30
srp2 50
sloop 3
ip 12 13 32
IUP[y]
""",

    #lo_ru
    "uni0E24": """
srp0    47
mirp[rp0,min,rnd,grey] front_kai 27
mdrp[rp0,rnd,grey]  23
mirp[min,rnd,grey]  hstem 12
ip  26
ip  10
mirp[rp0,rnd,grey]  w_1081 34
mirp[min,rnd,grey]  hstem 1
mdrp[rnd,white]  48
srp0 23
mdrp[rp0,rnd,grey]  18
mirp[min,rnd,grey]  headstem 38
mirp[rnd,grey]  headstem_plus_hole 44
IUP[x]
SVTCA[y-axis]
mdap[rnd]  47
mirp[rnd,grey]  vheight_lu 1
mirp[rnd,grey]  vheight_lo 21
mirp[rp0,rnd,grey]  vheight_shoot 31
mirp[min,rnd,grey]  vstem_236 5
srp0    21
mdrp[rp0,rnd,grey]  15
mirp[min,rnd,grey]  headstem    41
mirp[rnd,grey]  headstem_plus_hole 35
srp1    5
srp2    47
sloop   10
ip  28 8 27 9 26 10 2 34 24 12
IUP[y]
""",

    #lo_ling
    "uni0E25": """
srp0    52
mirp[rp0,min,rnd,grey] front_kai 18
mdrp[rnd,grey]  32
mirp[min,rnd,grey]  hstem 7
mirp[rp0,rnd,grey]  w_1120 39
mirp[min,rnd,grey]  hstem 25
shp[rp2]    1
mdrp[min,rnd,grey]  53
srp0    18
mdrp[rp0,rnd,grey]  13
mirp[min,rnd,grey]  headstem 43
mirp[rnd,grey]  headstem_plus_hole 49
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[rnd,grey]  vheight_lo 16
mdrp[min,rnd,grey]  25
mirp[rp0,rnd,grey]  vheight_shoot 36
mirp[min,rnd,grey]  vstem_236 29
mdrp[rp0,rnd,grey]  22
mirp[min,rnd,grey]  vstem_236  4
srp0    16
mirp[rp0,rnd,grey]  headdia 10
mirp[min,rnd,grey]  headstem 46
mirp[rnd,grey]  headstem_plus_hole 40
srp1    29
srp2    1
sloop   3
ip  19 26 39
IUP[y]
""",

    #ro_lu
    "uni0E26": """
srp0    47
mirp[rp0,rnd,white]  front_thahan 18
mirp[min,rnd,grey]  headstem 44
mirp[rnd,grey]  headstem_plus_hole 38
mdrp[rp0,rnd,grey]  12
sloop   4
ip  27 26 8 10
mirp[rp0,min,rnd,grey]  hstem 23
mirp[rp0,rnd,grey]  w_1024 34
mdrp[rnd,white] 48
mirp[min,rnd,grey]  hstem 1
IUP[x]
SVTCA[y-axis]
mdap[rnd]   47
mirp[rnd,grey]  vheight_lu 1
mirp[rnd,grey]  vheight_lo 15
mirp[rp0,rnd,grey]  vheight_shoot 31
sloop   10
ip  28 27 8 26 9 10 24 12 2 34
mirp[min,rnd,grey]  vstem_236   5
srp0    15
mdrp[rp0,rnd,grey]  21
mirp[min,rnd,grey]  headstem 41
mirp[rnd,grey]  headstem_plus_hole 35
IUP[y]
""",

    #wo_wan
    "uni0E27": """
srp0    37
mirp[rp0,rnd,white]  front_thahan 15
mirp[rp0,rnd,grey]  w_926 22
mirp[min,rnd,grey]  hstem 8
mdrp[rp0,rnd,grey]  3
mirp[min,rnd,grey]  headstem 34
mirp[rnd,grey]  headstem_plus_hole 28
IUP[x]
SVTCA[y-axis]
mdap[rnd]    37
mirp[rnd,grey]  vheight_lo 0
mirp[rp0,rnd,grey]  vheight_shoot 19
mirp[min,rnd,grey]  vstem_236   12
srp0    0
mdrp[rp0,rnd,grey]  6
mirp[min,rnd,grey]  headstem 31
mirp[rnd,grey]  headstem_plus_hole 25
srp1    12
srp2    37
sloop   2
ip  9 22
IUP[y]
""",

    #so_sala
    "uni0E28": """
SRP0                64         ;Set Reference Point 0
MIRP[rp0,min,rnd,grey]  front_kai 39
mirp[rp0,min,rnd,grey]  hstem 14
mdrp[rp0,rnd,white] 17
mdrp[min,rnd,grey]  33
mdrp[rp0,min,rnd,grey]  36
mirp[min,rnd,grey]  hstem 35
srp0    39
mdrp[rp0,rnd,grey]  26
mirp[min,rnd,grey]  headstem 55
mirp[rnd,grey]  headstem_plus_hole 61
srp1    14
ip  20
ip  31
srp0    39
mirp[rp0,rnd,grey]  w_1290  51
mirp[min,rnd,grey]  hstem   1
sloop 8
ip 4 6 7 9 44 46 47 49
mdrp[rnd,white]     65
IUP[x]
SVTCA[y-axis]
MDAP[rnd]           35
ALIGNRP             1
mdrp[min,rnd,grey]  17
MIRP[rp0,rnd,grey]  vheight_shoot  42
MIRP[min,rnd,grey]  vstem_236  11
sloop 8
ip 4 6 7 9 44 46 47 49
MDRP[rp0,rnd,white] 23
MIRP[min,rnd,grey]  headstem  58
MIRP[rp0,rnd,grey]  headdia  29
MIRP[min,rnd,grey]  headstem  52
IUP[y]             
""",

    #so_lusi
    "uni0E29": """
srp0    63
mirp[rp0,rnd,white]  front_thahan 7
mirp[min,rnd,grey]  headstem 48
mirp[rnd,grey]  headstem_plus_hole 42
mdrp[rp0,rnd,grey]  12
mirp[rp0,min,rnd,grey]  hstem 1
mirp[rp0,rnd,grey]  w_1120 32
alignrp     38
mirp[min,rnd,grey]  hstem 30
shp[rp2]    14  
srp1    12
sloop   4
ip  20 60 54 26
mdrp[rp0,rnd,grey]  36
ip  35
mdrp[rnd,white] 64
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
mirp[min,rnd,grey]  vstem_236 14
mirp[rnd,grey]  vheight 32
srp1    14
sloop   10 
ip  23 57 51 17 30 15 33 38 35 36
mirp[rp0,rnd,grey]  vheight_shoot 10
mdrp[rp0,rnd,grey]  4
mirp[min,rnd,grey]  headstem 39
mirp[rnd,grey]  headstem_plus_hole 45
IUP[y]
""",

    #so_sua
    "uni0E2A": """
srp0    64
mirp[rp0,min,rnd,grey] front_kai 18
mdrp[rnd,grey]  38
mirp[min,rnd,grey]  hstem 7
mirp[rp0,rnd,grey]  w_1120 51
mirp[min,rnd,grey]  hstem 25
shp[rp2]    1
sloop   8
ip  28 30 31 33 44 46 47 49
mdrp[min,rnd,grey]  65
srp0    18
mdrp[rp0,rnd,grey]  13
mirp[min,rnd,grey]  headstem 55
mirp[rnd,grey]  headstem_plus_hole 61
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[rnd,grey]  vheight_lo 16
mdrp[min,rnd,grey]  25
mirp[rp0,rnd,grey]  vheight_shoot 42
mdrp[rnd,grey]  46
mirp[min,rnd,grey]  vstem_236 35
srp1    46
sloop   7
ip  44 47 49 28 30 31 33
mdrp[rp0,rnd,grey]  22
mirp[min,rnd,grey]  vstem_236  4
srp0    16
mdrp[rp0,rnd,grey]  10
mirp[min,rnd,grey]  headstem 58
mirp[rnd,grey]  headstem_plus_hole 52
srp1    35
srp2    1
sloop   3
ip  19 26 51
IUP[y]
""",

    #ho_hip
    "uni0E2B": """
SRP0        62
mirp[rp0,min,rnd,white]  front_thahan 14
mirp[min,rnd,grey]  headstem 47
mirp[rnd,grey]  headstem_plus_hole 41
mdrp[rp0,rnd,grey]  19
alignrp     7
mirp[rp0,min,rnd,grey]  hstem 8
mirp[rp0,rnd,grey]  w_1024 37
mdrp[rnd,grey]  32
mdrp[rnd,white]  63
mirp[rp0,min,rnd,grey]  hstem 1
srp1    19
ip      21
ip      6
srp0    32
mdrp[min,rnd,grey]  35
mirp[min,rnd,grey]  headhole 53
mirp[rp0,rnd,grey]  w_455 26
mirp[min,rnd,grey]  headhole 59
mdrp[min,rnd,grey]  23
IUP[x]
SVTCA[y-axis]
mdap[rnd]   7
alignrp 1
mdrp[min,rnd,grey]  20
mirp[rp0,rnd,grey]  vheight_shoot 17
alignrp 29
sloop   5
ip  23 35 21 4 37
mdrp[rp0,rnd,grey]  11
mirp[min,rnd,grey]  headstem 38
shp[rp2]    50
mirp[rnd,grey]  headstem_plus_hole 44
shp[rp2]    56
IUP[y]
""",

    #lo_chula
    "uni0E2C": """
srp0    60
mirp[rp0,rnd,white]  front_thahan 10
mirp[min,rnd,grey]  headstem 45
mirp[rnd,grey]  headstem_plus_hole 45
mdrp[rp0,rnd,grey]  15
alignrp 3
mirp[rp0,min,rnd,grey]  hstem 4
mirp[rp0,rnd,grey]  w_1180 35
mirp[min,rnd,grey]  hstem   19
shp[rp2]    1
srp1    15
sloop   3
ip  17 18 2
mdrp[rp0,rnd,grey]  31
ip  28
ip  30
mdrp[rnd,white] 61
srp0    35
mdrp[rp0,rnd,grey]  23
mirp[min,rnd,grey]  headstem 57
mirp[rnd,grey]  headstem_plus_hole 51
IUP[x]
SVTCA[y-axis]
srp0    1
alignrp    3
mdrp[min,rnd,grey]  19
shp[rp2]   16
mdrp[rnd,grey]  26
mirp[rp0,rnd,grey]  vheight_shoot 13
mdrp[rp0,rnd,grey]  7
mirp[min,rnd,grey]  headstem 36
mirp[rnd,grey]  headstem_plus_hole 42
srp0    26
mdrp[rp0,rnd,grey]  20
sloop   4
ip  28 30 31 33
srp1    19
ip  18
ip  2
IUP[y]
""",

    #o_ang
    "uni0E2D": """
srp0    41
mirp[rp0,min,rnd,grey]  front_kai 1
alignrp 21
mirp[min,rnd,grey]  hstem   12
mirp[rp0,rnd,grey]  w_1051 28
mirp[min,rnd,grey]  hstem   14
srp1    13
ip  7
mdrp[rnd,white]      42
mdap[rnd]  7
mirp[min,rnd,grey]  headstem   32
mirp[rnd,grey]  headstem_plus_hole  38
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
mirp[min,rnd,grey]  vstem_236   14
mirp[rp0,rnd,grey]  vheight_shoot  25
mirp[min,rnd,grey]  vstem_236   18
mdrp[rp0,rnd,grey]  4
mdrp[rp0,rnd,grey]  10
mirp[min,rnd,grey]  headstem    29
mirp[rnd,grey]  headstem_plus_hole 35
srp1    18
srp2    1
sloop   5
ip  22 21 2 15 28
IUP[y]
""",

    #ho_nokhuk
    "uni0E2E": """
srp0    54
mirp[rp0,min,rnd,grey]  front_kai 1
alignrp 22
mirp[min,rnd,grey]  hstem   12
mirp[rp0,rnd,grey]  w_1051 33
mirp[min,rnd,grey]  hstem   14
sloop   5
ip 48 17 27 29 31
srp1    13
ip  7
mdrp[rp0,rnd,grey]  30
mdrp[rnd,white]  55
mdap[rnd]  7
mirp[min,rnd,grey]  headstem   37
mirp[rnd,grey]  headstem_plus_hole   43
srp0    22
mirp[min,rnd,grey]  vstem_236 52
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
mirp[rp0,min,rnd,grey]  vstem_236   14
mdrp[rp0,rnd,white] 10
mirp[min,rnd,grey]  headstem 34
mirp[rnd,grey]  headstem_plus_hole 40
srp0    1
mirp[rp0,rnd,grey]  vheight_shoot 25
mirp[rnd,grey]  w_153  50
sloop   4
ip  27 29 30 31
srp1    40
sloop   3
ip  46 19 4
IUP[y]
""",

    #paiyan
    "uni0E2F": """
srp0    36
mirp[rp0,rnd,white]  front_thahan 8
mdrp[min,rnd,grey]  17
mdrp[rp0,rnd,grey]  14
mirp[min,rnd,grey]  headstem 27
mirp[rnd,grey]  headstem_plus_hole 33
srp0    8
mirp[rp0,rnd,grey]  w_1051 23
mirp[min,rnd,grey]  hstem   1
shp[rp2]    22
mdrp[rnd,white] 37
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
mirp[rp0,rnd,grey]  vheight_shoot 11
alignrp 22
mirp[min,rnd,grey]  headstem 30
ip  23
mirp[rp0,rnd,grey]  headdia 17
mirp[min,rnd,grey]  headstem 24
mdrp[rp0,rnd,grey]  19
mirp[min,rnd,grey]  w_195 5
ip  2
IUP[y]
""",

    #sara_a
    "uni0E30": """
srp0    58
mirp[rp0,rnd,white]  front_thahan 3
alignrp 32
mdrp[rp0,rnd,grey]  9
alignrp 38
mirp[min,rnd,grey]  headstem 20
shp[rp2]    49
mirp[rnd,grey]  headstem_plus_hole 26
shp[rp2]    55
mdrp[rp0,rnd,grey]  11
alignrp 40
mdrp[rp0,rnd,grey]  14
alignrp 43
mdrp[rp0,rnd,grey]  15
alignrp 44
mdrp[rnd,white] 59
IUP[x]
SVTCA[y-axis]
MDAP[rnd]  58
mdrp[rp0,rnd,grey]  0
mirp[min,rnd,grey]  w_195   11
mdrp[rp0,rnd,grey]  15
mdrp[min,rnd,grey]  14
mdrp[rnd,white] 59
srp0    0
mdrp[rp0,rnd,grey]  6
mirp[min,rnd,grey]  headstem 23
mirp[rnd,grey]  headstem_plus_hole 17
srp0    58
mirp[rp0,rnd,grey]  vheight 35
mirp[min,rnd,grey]  headstem 52
mirp[rnd,grey]  headstem_plus_hole 46
mdrp[rp0,rnd,grey]  29
mirp[min,rnd,grey]  w_195   40
mdrp[rp0,rnd,grey]  44
mdrp[min,rnd,grey]  43
IUP[y]
""",

    #sara_maihanakat
    "uni0E31": """
mdap[rnd]   0
mdrp[rnd,grey]  15
mdrp[rp0,rnd,grey]  3
mdrp[rp0,rnd,grey]  9
mirp[min,rnd,grey]  headstem 20
mirp[rnd,grey]  headstem_plus_hole 26
IUP[x]
SVTCA[y-axis]
mdap[rnd]   29
mirp[rp0,min,rnd,grey]  vheight_sara1   0
mirp[rp0,min,rnd,grey]  w_154 11
mdrp[rp0,rnd,grey]  6
ip  14
ip  15
mirp[min,rnd,grey]  headstem 23
mirp[rnd,grey]  headstem_plus_hole 17
IUP[y]
""",

    #sara_aa
    "uni0E32": """
srp0    16
mirp[rp0,rnd,white]  front_tahan 8
mirp[rp0,min,rnd,grey]  w_926 15
mirp[min,rnd,grey]  hstem 1
mdrp[rnd,white]  17
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   1
mirp[rp0,rnd,grey]  vheight_shoot 12
mirp[min,rnd,grey]  vstem_236   5
srp1    5
srp2    1
ip  2
ip  15
IUP[y]
""",

    #sara_am
    #uni0E33: use sara_aa with nikahit
    
    #sara_i
    "uni0E34": """
mdap[rnd]   0
mirp[min,rnd,grey]  vstem_258 11
mirp[rp0,rnd,grey]  w_926 3
mirp[min,rnd,grey]  vstem_236 17
IUP[x]
SVTCA[y-axis]
mdap[rnd]   20
mirp[rp0,rnd,grey]  vheight_sara1   0
mdrp[rp0,rnd,white] 3
mirp[rp0,min,rnd,grey]  w_154 17
alignrp 4
ip  11
ip  10
mdrp[rp0,rnd,white]  14
mirp[min,rnd,grey]  w_154 7
IUP[y]
""",

    #sara_ii
    "uni0E35": """
mdap[rnd]   0
mirp[min,rnd,grey]  w_195 10
mirp[min,rnd,grey]  vstem_258 12
mirp[rp0,rnd,grey]  w_926 3
mirp[min,rnd,grey]  vstem_236 18
IUP[x]
SVTCA[y-axis]
mdap[rnd]   21
mirp[rp0,rnd,grey]  vheight_sara1   0
mdrp[rp0,rnd,white] 3
mirp[rp0,min,rnd,grey]  w_154 18
alignrp 4
ip  12
mdrp[rp0,rnd,white]  15
mirp[rp0,min,rnd,grey]  w_154 7
mirp[min,rnd,grey]  headstem 10
IUP[y]
""",

    #sara_ue
    "uni0E36": """
mdap[rnd]   0
mirp[min,rnd,grey]  vstem_258 21
mirp[rp0,rnd,grey]  w_926 3
mirp[min,rnd,grey]  vstem_236 27
srp0    21
mdrp[rp0,rnd,grey]  15
mdrp[min,rnd,grey]  18
mirp[min,rnd,grey]  headstem_tiny   33
mirp[rp0,rnd,grey]  headdia_tiny   9
mirp[min,rnd,grey]  headstem_tiny   39
IUP[x]
SVTCA[y-axis]
mdap[rnd]   42
mirp[rp0,rnd,grey]  vheight_sara1   0
mdrp[rp0,rnd,white] 3
mirp[rp0,min,rnd,grey]  w_154 27
alignrp 4
ip  21
ip  20
mdrp[rp0,rnd,white]  24
ip  18
mirp[min,rnd,grey]  w_154 7
ip  30
ip  9
mdap[rnd]   30
mirp[rnd,grey]  headstem 36
mirp[min,rnd,grey]  headstem_tiny_plus_hole 12
IUP[y]
""",

    #sara_uee
    "uni0E37": """
mdap[rnd]   0
mirp[rp0,min,rnd,grey]  w_195 15
mdrp[rp0,min,rnd,white] 12
mirp[min,rnd,grey]  w_195 10
srp0    0
mirp[min,rnd,grey]  vstem_258 17
mirp[rp0,rnd,grey]  w_926 3
mirp[min,rnd,grey]  vstem_236 23
IUP[x]
SVTCA[y-axis]
mdap[rnd]   26
mirp[rp0,rnd,grey]  vheight_sara1   0
mdrp[rp0,rnd,white] 3
mirp[rp0,min,rnd,grey]  w_154 23
alignrp 4
ip  17
mdrp[rp0,rnd,white]  20
mirp[rp0,min,rnd,grey]  w_154 7
ip  12
ip  14
mirp[min,rnd,grey]  headstem 10
shp[rp2]    15
IUP[y]
""",

    #sara_u
    "uni0E38": """
mdap[rnd]   1
mirp[rp0,rnd,grey]  vstem_236 13
mdrp[rp0,rnd,grey]  7
mirp[min,rnd,grey]  headstem_tiny 23
mirp[rnd,grey]  headstem_tiny_plus_hole 17
IUP[x]
SVTCA[y-axis]
mdap[rnd]   26
mdrp[rp0,min,rnd,white]  10
mdrp[rp0,rnd,grey]  4
mirp[min,rnd,grey]  headstem_tiny 14
mirp[rnd,grey]  headstem_tiny_plus_hole 20
mdrp[min,rnd,grey]  0
IUP[y]
""",

    #sara_uu
    "uni0E39": """
mdap[rnd]   0
mirp[rp0,rnd,grey]  w_195 16
mdrp[rp0,rnd,white] 14
mirp[rp0,rnd,grey]  w_195 1
srp0    14
mdrp[rp0,rnd,grey]  7
mirp[min,rnd,grey]  headstem_tiny 27
mirp[rnd,grey]  headstem_tiny_plus_hole 21
IUP[x]
SVTCA[y-axis]
mdap[rnd]   30
mdrp[rp0,rnd,white] 10
mdrp[rnd,grey]  16
mdrp[rp0,rnd,grey]  4
mdrp[rnd,grey]  14
mdrp[min,rnd,grey]  1
mirp[min,rnd,grey]  headstem_tiny 18
mirp[rnd,grey]  headstem_tiny_plus_hole 24
IUP[y]
""",

    #pinthu
    "uni0E3A": """
mdap[rnd]   9
mdrp[rp0,min,rnd,grey]  3
IUP[x]
SVTCA[y-axis]
mdap[rnd]   12
mdrp[rp0,rnd,white]  6
mdrp[rp0,min,rnd,grey]  0
IUP[y]
""",

    #thai_baht
    "uni0E3F": """
srp0    43
mirp[rp0,rnd,white]  3  3
mirp[min,rnd,grey]  22  34
shp[rp2]    23
mdrp[rp0,rnd,white] 21
sloop   3
alignrp 32 5 1
mirp[min,rnd,grey] w_154 31
sloop   3
shp[rp2] 42 7 20
srp0    3
mdrp[rp0,rnd,grey]  17
mirp[min,rnd,grey]  22  28
mdrp[rp0,rnd,grey]  11
mirp[min,rnd,grey]  22  39
IUP[x]
SVTCA[y-axis]
mdap[rnd]   20
alignrp 3
mdrp[min,rnd,grey]  1
mirp[min,rnd,grey]  185 25
shp[rp2]    24
mirp[rp0,rnd,grey]  141 4
alignrp     8
mdrp[min,rnd,grey]  6
mirp[min,rnd,grey]  185 42
shp[rp2]    34
mirp[rp0,rnd,grey]  190 31
alignrp     23
mirp[min,rnd,grey]  185 36
ip  14
IUP[y]
""",

    #sara_ae
    "uni0E40": """
srp0    25
mdrp[rp0,min,rnd,grey]  2
mirp[min,rnd,grey]  hstem 4
mdrp[rp0,rnd,grey]  10
mirp[min,rnd,grey]  headstem 16
mirp[rnd,grey]  headstem_plus_hole 22
mdrp[rnd,white]  26
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   25
mirp[rnd,grey]  vheight 4
mirp[rp0,rnd,grey]  vheight_lo 0
mdrp[rp0,rnd,grey]  7
mirp[min,rnd,grey]  headstem 19
mirp[rnd,grey]  headstem_plus_hole 13
IUP[y]
""",

    #sara_ae
    #use sara_a reference: uni0E40

    #sara_o
    "uni0E42": """
srp0    52
mirp[rp0,rnd,white]  front_khai 6
mdrp[min,rnd,grey]  28
mdrp[rnd,grey]  18
mdrp[rp0,rnd,grey]  2
mirp[min,rnd,grey]  hstem   31
mdrp[rp0,rnd,grey]  37
mdrp[rnd,white] 53
mirp[min,rnd,grey]  headstem 43
mirp[rnd,grey]  headstem_plus_hole 49
IUP[x]
SVTCA[y-axis]
mdap[rnd]   52
mirp[rnd,grey]  vheight_lo 0
mirp[rp0,rnd,grey]  vheight_o 10
mirp[min,rnd,grey]  vstem_236 25
mdrp[rp0,rnd,grey]  17
mirp[min,rnd,grey]  vstem_236 18
srp0    10
mdrp[rp0,min,rnd,grey]  15
mirp[rnd,grey]  vstem_236 20
srp0    0
mdrp[rp0,rnd,grey]  34
mirp[min,rnd,grey]  headstem   46
mirp[rnd,grey]  headstem_plus_hole   40
srp1    25
srp2    34
sloop   7
ip  7 6 28 5 29 3 31
IUP[y]
""",

    #sara_i_moun
    "uni0E43": """
srp0    66
mirp[rp0,rnd,white] front_khai 22
mdrp[min,rnd,grey]  13
mdrp[rp0,rnd,grey]  2
mirp[min,rnd,grey]  hstem 33
mdrp[rp0,rnd,grey]  39
mirp[min,rnd,grey]  headstem 45
mirp[rnd,grey]  headstem_plus_hole 51
mdrp[rnd,white]  67
srp0    22
mdrp[rp0,rnd,grey] 16
mirp[min,rnd,grey] headstem 57
mirp[rnd,grey] headstem_plus_hole 63
srp0    22
mdrp[rp0,rnd,grey] 28
mirp[min,rnd,grey] w_291 8
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   66
mirp[rnd,grey]  vheight_lo 0
mirp[rp0,rnd,grey]  vheight_o 25
mirp[rp0,min,rnd,grey]  w_154 11
mdrp[rp0,rnd,white]  13
mirp[min,rnd,grey]  headstem 60
mirp[rp0,rnd,grey]  headdia 19
mirp[min,rnd,grey]  headstem 54
srp0    0
mdrp[rp0,rnd,grey]  36
mirp[min,rnd,grey]  headstem 48
mirp[rnd,grey]  headstem_plus_hole 42
srp1    25
srp2    66
sloop   6
ip      6 5 30 31 3 33
IUP[y]
""",

    #sara_i_mlai
    "uni0E44": """
srp0    49
mirp[rp0,rnd,grey]  front_khai 14
mdrp[rp0,rnd,grey]  2
mirp[min,rnd,grey]  hstem 28
mdrp[rp0,rnd,grey]  34
mirp[min,rnd,grey]  headstem 40
mirp[rnd,grey]  headstem_plus_hole 46
mdrp[rnd,white]  50
srp0    14
mdrp[rp0,rnd,grey]  22
mirp[min,rnd,grey]  w_291 8
srp1 14
sloop 4
ip 15 12 17 11
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   49
mirp[rnd,grey]  vheight_lo 0
mirp[rp0,rnd,grey]  vheight_o 20
mdrp[rnd,grey]  15
mirp[min,rnd,grey]  w_195 9
mdrp[rp0,rnd,grey]  11
mirp[min,rnd,grey]  w_154   17
srp0    0
mdrp[rp0,rnd,grey]  31
mirp[min,rnd,grey]  headstem 43
mirp[rnd,grey]  headstem_plus_hole 37
IUP[y]
""",

    #lakkhangyao
    "uni0E45": """
srp0    16
mdrp[rp0,rnd,grey]  8
mirp[rp0,min,rnd,grey]  w_926 15
mirp[min,rnd,grey]  hstem 1
mdrp[rnd,white]  17
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   16
mirp[rnd,grey]  vheight_lu 1
mirp[rp0,rnd,grey]  vheight_shoot 12
mirp[min,rnd,grey]  vstem_236 5
IUP[y]
""",

    #maiyamok
    "uni0E46": """
srp0    39
mirp[rp0,min,rnd,grey]  front_kai 18
mdrp[min,rnd,grey]  9
mirp[rp0,rnd,grey]  w_1081 26
mirp[min,rnd,grey]  hstem 1
srp1    9
sloop   7
ip  21 22 23 4 5 6 7
mdrp[rnd,white]  40
srp0    18
mdrp[rp0,rnd,grey]  12
mirp[min,rnd,grey]  headstem  30
mirp[rnd,grey]  headstem_plus_hole  36
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   39
mirp[rnd,grey]  vheight_lu 1
mirp[rp0,rnd,grey]  vheight_shoot 21
alignrp 23
mirp[min,rnd,grey]  w_195 7
shp[rp2]    4
mdrp[rp0,min,rnd,grey]  22
mirp[rp0,min,rnd,grey]  w_154 5
mdrp[rp0,rnd,white]  9
mirp[min,rnd,grey]  headstem  33
mirp[rp0,rnd,grey]  headdia 15
mirp[min,rnd,grey]  headstem 27
IUP[y]
""",

    #maitaikhu
    "uni0E47": """
srp0    0
mdrp[rp0,min,rnd,grey]  11
mdrp[rnd,grey]  19
sloop   5
ip  14 15 22 23 18
mirp[min,rnd,grey]  w_195 26
mdrp[rp0,rnd,grey]  42
mirp[min,rnd,grey]  headstem_sara 48
mirp[rnd,grey]  headstem_sara_plus_hole 54
mirp[min,rnd,grey]  headdia_sara 35
srp1    26
sloop   5
ip  8 33 34 3 2
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   57
mirp[rp0,rnd,grey]  vheight_sara1    0
alignrp 8
mdrp[rp0,rnd,grey]  15
sloop   6
ip  22 39 31 5 28 35
mdrp[rnd,grey]  18
ip  19
mdap[rnd]   39
mirp[min,rnd,grey]  headstem_sara 51
mirp[rnd,grey]  headstem_sara_plus_hole 45
IUP[y]
""",

    #maiek
    "uni0E48": """
#no hinting
""",

    #maiek
    "uni0E48.low": """
srp0    0
mirp[min,rnd,grey]  w_195 2
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   5
mirp[rp0,rnd,grey]  vheight_sara1 0
mirp[min,rnd,grey]  w_385 2
IUP[y]
""",

    #maitho
    "uni0E49": """
#no hinting
""",

    #maitho
    "uni0E49.low": """
MDAP[rnd]   1
mdrp[min,rnd,grey]  20
ip  19
mdrp[min,rnd,grey]  16
ip  5
mdrp[rp0,rnd,grey]  14
mdrp[min,rnd,grey]  26
mdrp[rp0,rnd,grey]  8
mdrp[min,rnd,grey]  32
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   35
mirp[rp0,rnd,grey]  vheight_sara1 1
mdrp[min,rnd,grey]  2
mdrp[rp0,rnd,grey]  11
ip  19
ip  20
mdrp[min,rnd,grey]  29
mdrp[rp0,rnd,grey]  5
mdrp[min,rnd,grey]  23
IUP[y]
""",

    #maitri
    "uni0E4A": """
#no hinting
""",

    #maitri
    "uni0E4A.low": """
mdap[rnd]   0
mdrp[rp0,rnd,grey]  18
mdrp[min,rnd,grey]  9
srp1    0
sloop   8
ip  21 7 22 6 23 5 3 1
mdrp[min,rnd,grey]  44
mdrp[rp0,rnd,grey]  12
mdrp[min,rnd,grey]  38
srp0    1
mdrp[rnd,grey]  32  
sloop   3
ip  28 26 31
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   47
mirp[rp0,min,rnd,grey]  vheight_sara1   0
alignrp 15
mdrp[rp0,rnd,grey]  21
alignrp 23
sloop
ip  7 22 6 5 1 28 31 32
srp0    15
mdrp[min,rnd,grey]  35
mdrp[rp0,rnd,grey]  9
mdrp[min,rnd,grey]  41
IUP[y]
""",

    #maichattawa
    "uni0E4B": """
#no hinting
""",

    #maichattawa
    "uni0E4B.low": """
srp0    1
alignrp 5
mdrp[min,rnd,grey]  9
mirp[rp0,rnd,grey]  w_154 7
alignrp 11
mdrp[min,rnd,grey]  3
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   12
mirp[rp0,min,rnd,grey]  vheight_sara1 0
mdrp[rp0,rnd,grey]  8
alignrp 4
mirp[rp0,rnd,grey]  w_154 10
alignrp 2
mdrp[rp0,rnd,grey]  7
IUP[y]
""",

    #thanthakhat
    "uni0E4C": """
#no hinting
""",

    #thanthakhat
    "uni0E4C.low": """
srp0    0
mdrp[rnd,grey]  9
mdrp[rp0,rnd,grey]  3
mdrp[min,rnd,grey]  29
srp0    0
mdrp[rp0,rnd,grey]  17
mdrp[min,rnd,grey]  23
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   32
mirp[rp0,min,rnd,grey]  vheight_sara1 0
mdrp[rnd,grey]  9
mdrp[min,rnd,grey]  12
mdrp[rp0,rnd,grey]  6
mdrp[min,rnd,grey]  26
IUP[y]
""",

    #nikhahit
    "uni0E4D": """
MDAP[rnd]   0
mdrp[rp0,rnd,grey]  9
mirp[min,rnd,grey]  headstem 15
mirp[rp0,rnd,grey]  headdia 3
mirp[min,rnd,grey]  headstem 21
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   24
mirp[rp0,min,rnd,grey]  vheight_sara1    0
mirp[min,rnd,grey]  headstem 12
mirp[rp0,rnd,grey]  headdia 6
mirp[min,rnd,grey]  headstem 18
IUP[y]
""",

    #nikhahit
    "uni0E4D.high": """
MDAP[rnd]   0
mdrp[rp0,rnd,grey]  9
mdrp[min,rnd,grey]  15
mdrp[rp0,rnd,grey]  3
mdrp[min,rnd,grey]  21
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
mdrp[min,rnd,grey]  12
mdrp[rp0,rnd,grey]  6
mdrp[min,rnd,grey]  18
IUP[y]
""",

    #yamakkan
    "uni0E4E": """
SRP0    0
mdrp[rnd,grey]  15
ip  26
mdrp[rp0,rnd,grey]  4
mdrp[min,rnd,grey]  30
mdrp[rp0,rnd,grey]  10
mdrp[min,rnd,grey]  21
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   35
mirp[rp0,min,rnd,grey]  vheight_sara1    0
mdrp[min,rnd,grey]  33
mdrp[rp0,rnd,grey]  24
mdrp[min,rnd,grey]  26
ip  7
mdrp[rp0,rnd,grey]  13
mdrp[min,rnd,grey]  18
ip  15
ip  16
IUP[y]
""",

    #fongman
    "uni0E4F": """
SRP0    56
mdrp[rp0,min,rnd,grey]  5
mirp[rp0,min,rnd,grey]  w_195 29
mdrp[rnd,white] 35
srp0    5
mdrp[rp0,rnd,grey]  15
mirp[rp0,min,rnd,grey]  w_195 23
mdrp[rnd,white] 41
srp1    35
ip 53
ip 47
mdrp[rnd,white] 57
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   56
mirp[rp0,rnd,grey]  vheight_lo 0
mirp[rp0,min,rnd,grey]  w_195 20
mdrp[rnd,white] 32
srp0    0
mdrp[rp0,rnd,grey]  10
mirp[rp0,min,rnd,grey]  w_195 26
mdrp[rnd,white] 38
srp1    32
ip 44
ip 50
IUP[y]
""",

    #thaidigit_zero
    "uni0E50": """
SRP0    28
mirp[rp0,min,rnd,grey]  front_kai 4
mirp[min,rnd,grey]  vstem_258 25
mirp[rp0,rnd,grey]  w_1112 12
mirp[min,rnd,grey]  vstem_258 19
mdrp[rnd,white]  29
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   28
mirp[rnd,grey]  vheight_lo  0
mirp[rp0,rnd,grey]  vheight_num 8
mirp[min,rnd,grey]  vstem_236 22
srp0    0
mirp[min,rnd,grey]  vstem_236 16
IUP[y]
""",

    #thaidigit_one
    "uni0E51": """
SRP0    48
mirp[rp0,min,rnd,grey]  front_kai 3
mirp[min,rnd,grey]  vstem_258 22
mdrp[rp0,rnd,grey]  33
mdrp[rp0,rnd,grey]  27
mirp[min,rnd,grey]  headstem 45
mirp[rnd,grey]  headstem_plus_hole 39
srp0    3
mdrp[rp0,rnd,grey]  9
ip  13
ip  12
mirp[min,rnd,grey]  hstem 16
mdrp[rnd,white]  49
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   13
mdrp[rnd,grey]  12
mdrp[rnd,grey] 0
mirp[rp0,rnd,grey]  vheight_num 6
mirp[min,rnd,grey]  vstem_236 19
mdrp[rp0,rnd,grey]  30
mirp[min,rnd,grey]  headstem 42
mirp[rnd,grey]  headstem_plus_hole 36
IUP[y]
""",

    #thaidigit_two
    "uni0E52": """
SRP0    55
mirp[rp0,min,rnd,grey]  front_khai 7
mdrp[rp0,rnd,grey]  11
mirp[min,rnd,grey]  vstem_258  4
mdrp[rp0,rnd,white]  32
mdrp[rp0,rnd,grey]  26
mirp[min,rnd,grey]  headstem 46
mirp[rnd,grey]  headstem_plus_hole 52
srp0    11
mdrp[rp0,rnd,grey]  40
mirp[rp0,min,rnd,grey]  vstem_258 17
srp1    32
sloop 9
ip  35 36 37 19 20 21 23 14 0
mdrp[rnd,white]  56
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
mirp[min,rnd,grey]  vstem_236 14
mirp[rp0,rnd,grey]  vheight_num 35
alignrp 37
mirp[min,rnd,grey]  w_195 21
shp[rp2]    19
srp1    14
sloop   4
ip  23 49 43 29
mdrp[rp0,min,rnd,grey]  36
mirp[min,rnd,grey]  w_154 20
srp0    0
mdrp[rp0,rnd,grey]  8
mdrp[rnd,grey]  7
IUP[y]
""",

    #thaidigit_three
    "uni0E53": """
SRP0    56
mirp[rp0,min,rnd,grey]  front_kai 31
mirp[min,rnd,grey]  vstem_258 17
mdrp[min,rnd,grey]  19
mdrp[rp0,rnd,grey]  25
mirp[min,rnd,grey]  headstem 47
mirp[rnd,grey]  headstem_plus_hole 53
srp0    31
mdrp[rp0,rnd,grey]  41
ip  1
ip  0
mirp[min,rnd,grey]  vstem_258 4
srp1    17
sloop 3
ip  11 36 10
mdrp[rnd,white] 57
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   1
mirp[rnd,grey]  vheight_lo 28
mirp[rp0,rnd,grey]  vheight_num 38
alignrp 34
mirp[min,rnd,grey]  vstem_236 7
shp[rp2]    14
srp0    28
mdrp[rnd,grey]  19
mirp[min,rnd,grey]  headstem 44
mirp[rp0,rnd,grey]  headdia 22
mirp[min,rnd,grey]  headstem 50
srp2    14
ip  11
IUP[y]
""",

    #thaidigit_four
    "uni0E54": """
SRP0    55
mirp[rp0,min,rnd,grey]  front_kai 8
mirp[min,rnd,grey]  vstem_258 23
mdrp[rnd,grey]  30
mdrp[rp0,rnd,grey]  36
sloop 3
ip 28 39 3
mirp[min,rnd,grey]  headstem 46
mirp[rnd,grey]  headstem_plus_hole 52
srp0    8
mdrp[rp0,rnd,grey]  0
mdrp[rp0,rnd,grey]  16
mdrp[rnd,grey]  56
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   55
mirp[rp0,rnd,grey]  vheight_lo 0
alignrp 5
mirp[min,rnd,grey]  vstem_236 42
shp[rp2]    26
mirp[rp0,rnd,grey]  vheight_num 12
mirp[min,rnd,grey]  vstem_236 19
srp1    42
sloop   3
ip  33 49 43
mdrp[rp0,rnd,grey]  15
mirp[min,rnd,grey]  vstem_236 16
IUP[y]
""",

    #thaidigit_five
    "uni0E55": """
SRP0    76
mirp[rp0,min,rnd,grey]  front_kai 8
mirp[min,rnd,grey]  vstem_258 32
mdrp[rnd,grey]  39
mdrp[rp0,rnd,grey]  45
sloop 3
ip 37 48 3
mirp[min,rnd,grey]  headstem 55
mirp[rnd,grey]  headstem_plus_hole 61
srp0    8
mdrp[rp0,rnd,grey]  0
mdrp[rp0,rnd,grey]  25
mdrp[rnd,grey]  77
srp0    8
mdrp[rp0,rnd,grey]  13
mirp[min,rnd,grey]  headstem 73
mirp[rp0,rnd,grey]  headdia 19
ip  11
ip  21
mirp[min,rnd,grey]  headstem 67
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   76
mirp[rp0,rnd,grey]  vheight_lo 0
alignrp 5
mirp[min,rnd,grey]  vstem_236 51
shp[rp2]    35
mirp[rp0,rnd,grey]  vheight_num 21
mirp[min,rnd,grey]  vstem_236 28
srp1    51
sloop   3
ip  42 58 52
mdrp[rp0,rnd,grey]  24
mirp[min,rnd,grey]  vstem_236 25
srp0    21
mdrp[rp0,rnd,grey]  16
mirp[min,rnd,grey]  headstem 70
mirp[rnd,grey]  headstem_plus_hole 64
IUP[y]
""",

    #thaidigit_six
    "uni0E56": """
SRP0    48
mirp[rp0,min,rnd,grey]  front_khai 23
mdrp[rp0,rnd,grey]  3
sloop 3
ip  24 20 27
mdrp[rp0,rnd,grey]  9
ip  11
mirp[min,rnd,grey]  headstem 39
mirp[rnd,grey]  headstem_plus_hole 45
srp0    3
mdrp[rp0,rnd,grey]  33
mirp[min,rnd,grey]  vstem_258 14
mdrp[rnd,grey]  49
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   48
mirp[rnd,grey]  vheight_lo 0
mirp[min,rnd,grey]  vstem_236 11
mirp[rp0,rnd,grey]  vheight_num 30
mirp[min,rnd,grey]  vstem_236 17
ip  27
ip  20
mdrp[rp0,rnd,grey]  24
mirp[min,rnd,grey]  vstem_236 23
srp0    0
mdrp[rp0,rnd,grey]  6
mirp[min,rnd,grey]  headstem 42
mirp[rnd,grey]  headstem_plus_hole 36
IUP[y]
""",

    #thaidigit_seven
    "uni0E57": """
SRP0    69
mirp[rp0,min,rnd,grey]  front_kai 31
mirp[min,rnd,grey]  vstem_258 17
mdrp[min,rnd,grey]  19
mdrp[rp0,rnd,grey]  25
mirp[min,rnd,grey]  headstem 60
mirp[rnd,grey]  headstem_plus_hole 66
srp0    31
mdrp[rp0,rnd,grey]  41
sloop 3
ip  1 0 44
mirp[min,rnd,grey]  vstem_258 4
srp1    17
sloop 3
ip  11 36 10
mdrp[rp0,rnd,grey]  54
mdrp[rnd,white] 70
mirp[min,rnd,grey]  vstem_258 47
ip 50
ip 51
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   1
mdrp[min,rnd,grey]  44
mirp[rnd,grey]  vheight_lo 28
mirp[rp0,rnd,grey]  vheight_num 38
alignrp 34
mirp[min,rnd,grey]  vstem_236 7
shp[rp2]    14
mdrp[rnd,grey]  50
ip  51
srp0    28
mdrp[rnd,grey]  19
mirp[min,rnd,grey]  headstem 57
mirp[rp0,rnd,grey]  headdia 22
mirp[min,rnd,grey]  headstem 63
srp2    14
ip  11
IUP[y]
""",

    #thaidigit_eight
    "uni0E58": """
SRP0    53
mirp[rp0,min,rnd,grey]  front_kai 7
mirp[min,rnd,grey]  vstem_258 22
mdrp[rp0,rnd,grey]  38
sloop 5
ip 25 26 27 3 4
mirp[min,rnd,grey]  headstem 44
mirp[rp0,rnd,grey]  headdia 32
mirp[min,rnd,grey]  headstem 50
mdrp[rp0,rnd,grey]  15
mdrp[rnd,white] 54
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   53
mirp[rp0,rnd,grey]  vheight_lo 4
alignrp     0
mirp[min,rnd,grey]  vstem_236 25
shp[rp2]    3
mirp[rp0,rnd,grey]  vheight_num 11
mirp[min,rnd,grey]  vstem_236 18
srp1    25
ip  26
ip  27
mdrp[rp0,rnd,grey]  14
mirp[min,rnd,grey] vstem_258 15
srp0    0
mdrp[rp0,rnd,grey]  35
mirp[min,rnd,grey]  headstem 47
mirp[rnd,grey]  headstem_plus_hole 41
IUP[y]
""",

    #thaidigit_nine
    "uni0E59": """
SRP0    60
mirp[rp0,min,rnd,grey]  front_kai 21
mirp[min,rnd,grey]  vstem_258 7
mdrp[rnd,grey]  9
mdrp[rp0,rnd,grey]  15
mirp[min,rnd,grey]  headstem 51
mirp[rnd,grey]  headstem_plus_hole 57
srp0    21
mdrp[rp0,rnd,grey]  0
sloop 4
ip 27 33 40 45
mirp[min,rnd,grey]  vstem_258 1
mdrp[rp0,rnd,grey]  37
ip  36
mdrp[rnd,grey]  61
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   1
mirp[rnd,grey]  vheight_lo 18
mirp[rp0,rnd,grey]  vheight_num 30
alignrp 24
mirp[min,rnd,grey]  vstem_236 43
shp[rp2]    4
sloop 4
ip  27 33 45 40
mdrp[rp0,rnd,grey]  36
ip  37
IUP[y]
""",

#    #angkhankhu
    "uni0E5A": """
srp0    40
mirp[rp0,rnd,white]  front_thahan 8
mdrp[min,rnd,grey]  17
mdrp[rp0,rnd,grey]  14
mirp[min,rnd,grey]  headstem 27
mirp[rnd,grey]  headstem_plus_hole 33
srp0    8
mirp[rp0,rnd,grey]  w_1051 23
mirp[min,rnd,grey]  hstem   1
shp[rp2]    22
mdrp[rp0,min,rnd,grey]  37
mirp[rp0,min,rnd,grey]  hstem   39
mdrp[rnd,white] 41
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
alignrp    37
mirp[rp0,rnd,grey]  vheight_shoot 11
alignrp 22
mirp[min,rnd,grey]  headstem 30
sloop 3
ip  23 38 39
mirp[rp0,rnd,grey]  headdia 17
mirp[min,rnd,grey]  headstem 24
mdrp[rp0,rnd,grey]  19
mirp[min,rnd,grey]  w_195 5
ip  2
IUP[y]
""",

#    #khomut
    "uni0E5B": """
SRP0    73
mirp[rp0,min,rnd,grey]  front_kai 3
mirp[min,rnd,grey]  vstem_258 26
mdrp[rp0,rnd,grey]  32
sloop   3
ip  15 20 9
mdrp[rp0,rnd,grey]  46
sloop   11
ip  33 34 37 38 42 43 50 53 54 57 58
mdrp[rnd,white] 74
mdap[rnd]   15
mirp[min,rnd,grey]  headstem 70
mirp[rnd,grey]  headstem_plus_hole 64
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   73
mirp[rp0,rnd,grey]  vheight_lo  0
mirp[min,rnd,grey]  vstem_236 29
mirp[rp0,rnd,grey]  vheight_shoot 6
mirp[min,rnd,grey]  vstem_236 23
srp1    29
sloop   10
ip  20 12 32 33 34 57 58 54 50 46
mdap[rnd]   12
mdrp[rp0,rnd,grey]  18
mirp[min,rnd,grey]  headstem 67
mirp[rnd,grey]  headstem_plus_hole 61
mdap[rnd]   32
alignrp 37
alignrp 42
mdap[rnd]   33
alignrp 38
alignrp 43
mdap[rnd]   34
alignrp 39
mdap[rnd]   57
alignrp 53
mdap[rnd]   46
mirp[min,rnd,grey]  vstem_236 47
IUP[y]
""",

#    #CHAR_NAME
#    "uni0EXX": """
#SRP0    0
#
#IUP[x]
#SVTCA[y-axis]
#MDAP[rnd]   0
#
#IUP[y]
#""",


}

if __name__=="__main__":
    if sys.argv[1] == "--all":
        #$0 --all = ENCODE ALL CHARS
        sfd_file = os.path.basename(sys.argv[0]).split('.',1)[0] + '.sfd'
        print "Encoding all character in %s" % (sfd_file)
        dfont.inst_encode_all( sfd_file, pseudo_code_dict, cvt_dict )
    else:
        #$0 uni0E01 > x.txt = PRINT INSTRUCTION CODE OF uni0E01 TO x.txt
        print '\n'.join(dfont.inst_encode( pseudo_code_dict[sys.argv[1]], cvt_dict ))
