#!/usr/bin/env python
#Usage: $0 uni0E01 > code.txt
#or:    $0 --all

import os
import sys
import dfont

# cvt value
#NEW VALUE ***
#    "headdia":          257,    #384
#    "headstem":         258,    #120
#    "w_896":            256,    #896    =ko_kai
cvt_dict = {
    "w_1001":           71,     #1001   =
    "w_102":            9,      #102 
    "w_60":             260,    #60
#
    "base":             10,     #0
    "hstem":            8,      #184
    "hstem_curve":      18,     #195    =big curve hstem
#
    "vstem":            169,    #143    =straight vstem
    "vstem_curve":      185,    #156    =curve vstem
    "vstem":            96,     #154 
    "vstem_small":      27,     #135 
    "vstem_tiny":       9,      #102 
    "vstem_thick":      130,    #266 
    "headstem":         258,    #116
    "headstem_plus_hole":   259, #268
    "headstem_small":   11,     #113    =kho
    "headstem_small_plus_hole":   130,     #266    =kho
    "headstem_tiny":    148,    #84
    "headstem_wan":     260,    #60
    "sarastem":         90,     #127
#
    "headdia":          257,    #384
    "headdia_small":    180,    #377    =kho
    "headdia_plus":     261,    #442 
    "headdia_full":     157,    #451 
    "headdia_tiny":     0,      #309
    "headhole":         107,    #152    
    "headneck_kho":     39,     #180    =kho
#
    "hnext_1":          111,    #469    =next spline of sho_sher
    "hnext_2":          68,     #479    =next spline of yo_ying
#
    "vheight":          188,    #1120   =normal height 
    "vheight_shoot":    184,    #1147   =overshoot height
    "vheight_hi":       49,     #1208   =ko 
    "vheight_hi_kho":   47,     #1204   =kho 
    "vheight_po":       151,    #1556   =po_pla, fo_fa
    "vheight_o":        179,    #1638   =sara_o, sara_i
    "vheight_lo":       140,    #29 
    "vheight_lu":       176,    #410    =lo_lu
    "vheight_below_do": 176,    #410
    "vheight_num":      209,    #905
    "vheight_sara1":    250,    #1262
#
    "head_diff":        131,    #254    =head of character: bo,po
    "beak_diff":        148,    #84     =beak of ko,tho
    "beak_diff_2":      38,     #340    =beak of ko,tho
#
    "front_001":        25,     #211    =front spacing of tho
    "front_pung":       85,     #164
    "front_e":          131,    #254    =front spaceing of sara_e
#
    "front_khuad":      157,    #451    =front spacing of kho_khud
    "front_kwai":       100,    #205    =front spacing of kho_kwai, yo_yak
    "front_dek":        96,     #154    =front spaceing of do_dek
    "front_thong":      79,     #229    =front spaceing of to_thong
    "front_pung":       228,    #174    =front spaceing of po_pung
    "front_pan":        31,     #330    =front spacing of do_chada, po_pan
    "front_ma":         180,    #377    =front spaceing of mo_ma
    "front_ling":       1,      #184    =front spaceing of lo_ling, aw_ang
#
    "gap_51":           32,     #51
    "gap_84":           148,    #84
    "gap_102":          9,
    "gap_113":          11,     #113    =front spacing of ko_kai
    "gap_127":          90,
    "gap_164":          85,     #164
    "gap_186":          70,
    "gap_197":          194,    #197    =gap front/rear
    "gap_205":          100,    #205    =gap front/rear
    "gap_240":          24,    
    "gap_315":          207,
    "gap_340":          38,
#special
    "special_1":        230,    #45
    "special_2":        88,     #20
}

#NOTE PAD
#hd: headstem delta shift at 13-16 ppem
#f_deltap    x 12-4 x 13-4 x 14-1 x 15-1 x 16-1
#f_deltap    y1 14-1 y1 15-1 y1 16-1   y2 14+1 y2 15+1 y2 16+1
#f_deltap    x 12+4 x 13+4 x 14+1 x 15+1 x 16+1

#vd: vstem_curve delta shift at 18-25 ppem
#f_deltap    y 18+4 y 19+4 y 20+4 y 21+4 y 22+4 y 23+4 y 24+4 y 25+4    y 29+4 y 30+4 y 31+4 y 32+4 y 33+4 y 34+4 y 35+4

######### PSUEDO-CODE ##########
pseudo_code_dict = {
    #ko_kai
    "uni0E01": """
f_deltap    27 10+8   27 14-8   27 20-8   27 26+8
srp0                26
mirp[rp0,rnd,grey]  gap_197 14
mirp[min,rnd,grey]  hstem  12
mdrp[rp0,grey]  18
mdrp[min,rnd,grey]  8
srp0            12
mdrp[rp0,grey]  10
mdrp[min,rnd,grey]  17
#
srp0    27
mirp[rp0,rnd,grey]  gap_164 25
mirp[min,rnd,grey]  hstem  1
IUP[x]
SVTCA[y-axis]
mdap[rnd]           1
alignrp             13
mirp[rp0,rnd,grey]  vheight_shoot    22
mirp[min,rnd,grey]  vstem_curve  5
#tcurve
f_deltap    5 18+4 5 19+4 5 20+4 5 21+4 5 22+4 5 23+4 5 24+4 5 25+4    5 29+4 5 30+4 5 31+4 5 32+4 5 33+4 5 34+4 5 35+4
srp1                0
sloop               10
ip      19 8 18 9 17 10 2 25 15 12
IUP[y]
""",

    #kho_khai
    "uni0E02":  """
f_deltap    54 9+8    54 15-8   54 16-8   54 18+8   54 22+8
srp0                53
mdrp[rp0,rnd,grey]  15
mirp[min,rnd,grey]  headstem 44
mirp[rp0,rnd,grey]  headstem_plus_hole 50
mdrp[grey]  21
srp0    15
mdrp[rp0,rnd,grey]  27
f_deltap    27 13-4   27 15+2   27 16+3   27 17+2   27 18+4   27 19+4   27 20+4   27 21+8   27 22-3
mdrp[grey]  7
mdrp[rp0,rnd,grey]  1
mdap[rnd]   1
f_deltap    1 13-8   1 18-8   1 22-8   1 23-8   
mirp[min,rnd,grey]  hstem 32
#
srp0    54
mirp[rp0,rnd,grey]  gap_164 38
f_deltap    38 31-8   38 32+8
mirp[rp0,min,rnd,grey] hstem 36
f_deltap    7 12+2 9 12+4  15 12-4 15 13-2 15 14-1 15 15-1 15 16-1   12 13-2 12 14-4 12 15-8 12 16-8   27 13-3 27 15-2 27 16-2
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]           1
mirp[rnd,grey]      vheight 38
mirp[min,rnd,grey]  vstem 34
mirp[rp0,rnd,grey]  vheight_shoot 24
mirp[rp0,grey]  headstem 10
mdrp[rp0,rnd,white] 12
mdap[rnd]   12
mdrp[rp0,rnd,grey]  18
mirp[min,rnd,grey]  headstem 41
mirp[rnd,grey]      headstem_plus_hole 47
srp2    1
ip  3
ip  31
f_deltap    10 14+3   10 15+2   10 16+2
f_deltap    12 12+4 12 13+4   18 12+2 18 13+2 18 14+1 18 15+1 18 16+1
IUP[y]
""",

    #kho_khuad
    "uni0E03": """
f_deltap    58 10+8   58 12+8   58 16-8   58 17-8   58 19-8   58 33+8
srp0    57
mirp[rp0,rnd,grey] gap_51 24
mdrp[min,rnd,grey]  13
mdrp[rp0,rnd,grey]  18
f_deltap    18 13-8   18 23-8
mirp[min,rnd,grey]  headstem 48
mirp[rnd,grey]  headstem_plus_hole 54
srp0    24
mdrp[rp0,rnd,grey]  31
f_deltap    31 9+4   31 12+8   31 14+8   31 15+8   31 18+8    
mirp[grey]  vstem 7
srp1    13
sloop   6
ip  27 28 29 9 10 11
mdrp[rp0,rnd,grey]  1
mdap[rnd]   1
f_deltap    1 18-8   1 22-8   1 23-8   1 28-8   1 38-8
mirp[min,rnd,grey]  hstem 36
#
srp0    58
mirp[rp0,rnd,grey]  gap_164 42
mirp[rp0,min,rnd,grey]  hstem 40
f_deltap    18 14-1 18 15-1 18 16-1   24 11+2 24 12+2 24 13+2 24 14+2 24 15+2 24 16+2   7 16+3
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  0
mirp[min,rnd,grey]  vstem   38
mirp[rnd,grey]  vheight 42
mirp[rp0,rnd,grey]  vheight_shoot   27
alignrp     29
mirp[grey]  sarastem 11
shp[rp2]    9
mdrp[rp0,min,rnd,grey] 28
#mirp[rp0,rnd,grey] headstem 10
mirp[rp0,grey] headstem 10
mdrp[rp0,rnd,white] 15
mdap[rnd]   15
f_deltap    15 9+8   15 10+8   15 11+8   
mdrp[rnd,grey]  13
mirp[min,rnd,grey]  headstem 51
mirp[rp0,rnd,grey]  headdia 21
f_deltap    21 19+8   21 24+8   21 25+8   21 26+8   
mirp[min,rnd,grey]  headstem 45
srp2    1
ip  3
ip  35
f_deltap    15 14-1 15 15-1 15 16-1   21 14+1 21 15+1 21 16+1   28 16-3
IUP[y]
""",

    #kho_kwai
    "uni0E04": """
f_deltap    52 10+8   52 15-8   52 20-8   52 32+8
srp0                51
mirp[rp0,rnd,grey]  gap_102 32
mirp[min,rnd,grey]  hstem 8
mdrp[rp0,rnd,grey]  20
f_deltap    20 11-8   20 13-8   20 16-8   
mirp[min,rnd,grey]  headstem 42
mdrp[rp0,grey]  14
f_deltap    14 14-1
mdrp[min,rnd,grey]  48
mdap[rnd]   48
f_deltap    48 18+8   48 29+8   48 34+8
srp1    8
ip  25
ip  28
mdap[rnd]   28
mirp[min,rnd,grey]  hstem 29
srp2    8
ip  11
#
srp0    52
mirp[rp0,rnd,grey]  gap_164 38
mirp[min,rnd,grey]  hstem 1
f_deltap    20 12-4 20 13-4 20 14-1 20 15-1 20 16-1
IUP[x]
SVTCA[y-axis]
MDAP[rnd]           0
ALIGNRP             28 
MIRP[rp0,rnd,grey]  vheight_shoot  35     
MIRP[min,rnd,grey]  vstem_curve  5      
f_deltap    5 18+4 5 19+4 5 20+4 5 21+4 5 22+4 5 23+4 5 24+4 5 25+4   5 29+4   5 30+4   5 31+4   5 32+4   5 33+4   5 34+4   5 35+4   
MDRP[rp0,rnd,grey]  17         
srp1    28
ip  11
MIRP[min,rnd,grey]  headstem  45    
MIRP[rp0,rnd,grey]  headdia  23    
f_deltap    23 24+8   23 25+8   23 26+8   
MIRP[min,rnd,grey]  headstem  39    
f_deltap    11 12-8  11 13-8   11 14-8   11 15-8   11 16-8   11 18-8   
f_deltap    17 14-1 17 15-1 17 16-1   23 14+1 23 15+1 23 16+1
IUP[y]
""",

    #kho_kon
    "uni0E05": """
f_deltap    57 10+8   57 15-8   57 32+8
srp0                56
mirp[rp0,rnd,grey]  gap_102 35
mirp[min,rnd,grey]  hstem 11
mdrp[rp0,rnd,grey]  23
f_deltap    23 11-8   23 13-8   23 16-8   
mirp[min,rnd,grey]  headstem 47
mdrp[rp0,grey]  17
mdrp[min,rnd,grey]  53
mdap[rnd]   53
f_deltap    53 18+8
srp1    11
ip      28
ip      31
mdap[rnd]   31
mirp[min,rnd,grey]  hstem 32
srp2    11
ip      14
f_deltap    17 19-2   17 20-2   17 21-2
#
srp0    57
mirp[rp0,rnd,grey]  gap_164 43
mirp[min,rnd,grey]  hstem 1
srp1    11
sloop   7
ip      38 39 40 5 6 7 8
f_deltap    23 12-4 23 13-4 23 14-1 23 15-1 23 16-1
IUP[x]
#
SVTCA[y-axis]
MDAP[rnd]           31
ALIGNRP             0         
MIRP[rp0,rnd,grey]  vheight_shoot  38     
alignrp     40
MIRP[min,rnd,grey]  vstem_curve  8      
shp[rp2]    5
mdrp[rp0,grey]  39
mdrp[rp0,min,rnd,grey]  7
MDRP[rp0,rnd,white]  20         
mdap[rnd]   20
srp1    31
ip  11
MIRP[min,rnd,grey]  headstem  50    
MIRP[rp0,rnd,grey]  headdia  26    
f_deltap    26 24+8   26 25+8   26 26+8   
MIRP[min,rnd,grey]  headstem  44    
f_deltap    14 12-8  14 13-8   14 14-8   14 15-8   14 16-8   14 18-8   
f_deltap    20 14-1 20 15-1 20 16-1   26 14+1 26 15+1 26 16+1
IUP[y]
""",

    #kho_rakang
    "uni0E06": """
f_deltap    80 9+8   80 11+8   80 16-8   80 20-8
srp0    79
mirp[rp0,rnd,grey]  gap_51 37
mdrp[min,rnd,grey]  26
mdrp[rp0,rnd,grey]  31
mirp[min,rnd,grey]  headstem 58
mirp[rnd,grey]  headstem_plus_hole 64
srp0    37
mdrp[rp0,rnd,grey]  44
f_deltap    44 15+8   44 18+8   
mirp[grey]  vstem 20
srp1    26
sloop   6
ip      40 41 42 22 23 24
mdrp[rp0,rnd,grey]  14
mirp[rp0,min,rnd,grey]  hstem 49
alignrp     3
mdrp[rp0,rnd,grey]  9
f_deltap    9 12+8   9 16+8   
mirp[min,rnd,grey]  headstem 76
mirp[rnd,grey]  headstem_plus_hole 70
#
srp0    80
mirp[rp0,rnd,grey]  gap_164 54
mirp[min,rnd,grey]  hstem 52
shp[rp2]    1
f_deltap    31 12-4 31 13-4 31 14-1 31 15-1 31 16-1
f_deltap    37 13+2 37 14+2  37 15+2  37 16+1
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
mirp[min,rnd,grey]  vstem 52
mirp[rnd,grey]  vheight_lo  6
mirp[rnd,grey]  vheight 53
mirp[rp0,rnd,grey]  vheight_shoot 40
alignrp 42
mirp[min,rnd,grey]  sarastem 24
shp[rp2]    22
mdrp[rp0,min,rnd,grey]  41
mirp[rp0,grey]  headstem 23
mdrp[rp0,rnd,white]  28
mdap[rnd]   28
f_deltap    28 9+8   28 10+8   28 11+8   28 12+8   28 13+8   28 14+8   28 15+8   
mirp[min,rnd,grey]  headstem 61
mirp[rp0,rnd,grey]  headdia 34
f_deltap    34 19+8   
mirp[min,rnd,grey]  headstem 55
srp0    6
mdrp[min,rnd,grey]  67
mdrp[rp0,rnd,grey]  12
f_deltap    12 18-8
srp2    34
ip  16
ip  48
mirp[min,rnd,grey]  headstem 73
mdrp[rp0,rnd,grey]  50
mirp[min,rnd,grey]  vstem 3
f_deltap    28 14-1 28 15-1 28 16-1   34 14+1 34 15+1 34 16+1
f_deltap    41 16-4
IUP[y]
""",

    #ngo_ngu
    "uni0E07": """
f_deltap    33 9+8   33 22+8   33 23+8
#srp0    32
#mirp[rp0,rnd,grey]  gap_51 4
#mdrp[rnd,grey]  5
#
srp0    33
mirp[rp0,rnd,grey]  gap_164 19
mirp[rp0,min,rnd,grey]  hstem 8
mdrp[grey]  1
srp0    19
mirp[rp0,rnd,grey]  headdia_plus 14
f_deltap    14 12+4
mirp[min,rnd,grey]  headstem 29
mirp[rnd,grey]  headstem_plus_hole 23
f_deltap    14 12+4 14 13+4 14 14+1 14 15+1 14 16+1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   1
mirp[min,rnd,grey]  vstem_curve 8
mirp[rp0,rnd,grey]  vheight_shoot 17
mirp[min,rnd,grey]  headstem 26
mirp[rp0,rnd,grey]  headdia 11
f_deltap    11 13-4
mirp[min,rnd,grey]  headstem 20
f_deltap    17 14-1 17 15-1 17 16-1   11 14+1 11 15+1 11 16+1
IUP[y]
""",

    #jo_jan
    "uni0E08": """
f_deltap    45 9+8   45 10+8   45 11+8   45 13+8   45 17+8   45 25-8   45 28+8
srp0    44
mirp[rp0,rnd,grey]  gap_113 22
mdrp[rp0,rnd,grey]  7
mirp[min,rnd,grey]  headstem 41
mirp[rp0,rnd,grey]  headstem_plus_hole 35
f_deltap    35 12-4
mdrp[grey]  2
mdrp[grey]  12
f_deltap    2 12+4   12 13-1   2 14+2 3 14-3 12 14-1  2 15+3   12 15-2   2 16+4
#
srp0    45
mirp[rp0,rnd,grey]  gap_113 29
mirp[rp0,min,rnd,grey]  hstem 16
mdrp[grey]  13
srp1    12
ip  11
srp1    29
ip  0
srp0    0
mdrp[grey]  1
f_deltap    1 13+3   1 14+2   1 15+2   1 16+4
f_deltap    7 14+1 7 15+1 7 16+1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  1
mirp[grey]  vstem 13
mirp[rp0,rnd,grey]  vheight_shoot 26
mirp[min,rnd,grey]  vstem_curve 19
f_deltap    19 18+4 19 19+4 19 20+4 19 21+4 19 22+4 19 23+4 19 24+4 19 25+4   19 29+4   19 30+4   19 31+4   19 32+4   19 33+4   19 34+4   19 35+4   
mdrp[rp0,rnd,grey]  10
mirp[min,rnd,grey]  headstem 38
mirp[rp0,rnd,grey]  headdia 4
f_deltap    4 13-4   4 19+8   4 24+8  4 25+8  4 26+8
mirp[min,rnd,grey]  headstem 32
f_deltap    10 14-1 10 15-1 10 16-1   4 14+1 4 15+1 4 16+1
IUP[y]
f_deltap    13 12-2   2 13+4 13 13-2   2 14+3 13 14-4   2 15+3   13 15-2   2 16+4   13 16-2
""",

    #cho_ching
    "uni0E09": """
f_deltap    68 16+8   68 18+8   
srp0    67
mirp[rp0,rnd,grey] gap_340 1
f_deltap    1 11+8   1 15+8
ip  7
ip  22
mirp[min,rnd,grey]  hstem 12
SHP[rp2]    0
mdap[rnd]   7
mirp[min,rnd,grey]  headstem 52
mirp[rnd,grey]  headstem_plus_hole 46
#
srp0    68
mirp[rp0,rnd,grey]  gap_205 29
ip  33
mirp[min,rnd,grey]  hstem 15
mdap[rnd]   33
mirp[min,rnd,grey]  headstem 58
mirp[rp0,min,rnd,grey]  headdia 39
f_deltap    39 19+8   39 24+8
mirp[min,rnd,grey]  headstem 64
f_deltap    7 11+4  7 12+4 7 13+4 7 14+1 7 15+1 7 16+1
IUP[x]
SVTCA[y-axis]
mdap[rnd]   0
mirp[min,rnd,grey]  vstem_curve 13
mirp[rnd,grey]      vheight_lo  36
mirp[rp0,rnd,grey]  vheight_shoot  26
mirp[min,rnd,grey]  vstem_curve 19
f_deltap    19 18+4 19 19+4 19 20+4 19 21+4 19 22+4 19 23+4 19 24+4 19 25+4    19 29+4 19 30+4 19 31+4 19 32+4 19 33+4 19 34+4 19 35+4
mdrp[rp0,rnd,grey]  10
mirp[min,rnd,grey]  headstem 49
mirp[rp0,rnd,grey]  headdia 4
f_deltap    4 19+8
mirp[min,rnd,grey]  headstem 43
srp0    36
mirp[min,rnd,grey]  headstem 55
mdrp[rp0,rnd,grey]  30
mirp[min,rnd,grey]  headstem 61
srp0    36
mdrp[rp0,rnd,grey]  15
mirp[min,rnd,grey]  vstem_curve 41
srp1    19
sloop   3
ip  16 29 12
f_deltap    10 14-1 10 15-1 10 16-1   4 14+1 4 15+1 4 16+1
IUP[y]
""",

    #cho_chang
    "uni0E0A": """
f_deltap    63 9+8    63 12+8   63 14+8
srp0                62
mdrp[rp0,rnd,grey]  15
mirp[min,rnd,grey]  headstem 53
mirp[rp0,rnd,grey]  headstem_plus_hole 59
mdrp[grey]  21
srp0    15
mdrp[rp0,rnd,grey]  27
f_deltap    27 11+4  27 13-1   27 17+2   27 18+4   27 19+4   27 20+4   27 21+8   27 22-3
mdrp[grey]  7
f_deltap    7 15+2   7 16+2
mdrp[rp0,rnd,grey]  1
mdap[rnd]   1
f_deltap    1 11-8  1 13-8   1 18-8   1 22-8   1 23-8   
mirp[min,rnd,grey]  hstem 32
#
srp0    63
mdrp[rp0,rnd,white]  43
mirp[min,rnd,grey]  hstem 42
mdrp[rp0,rnd,white]  47
f_deltap    47 17+8   47 18+8   47 19+8   47 28+8
mirp[min,rnd,grey]  hstem 36
srp1    27
ip  39
srp0    39
mdrp[grey]  45
f_deltap    43 9+4 42 9+4  43 10+4 42 10+4  43 11+4 42 11+4   43 17+8 42 17+8
f_deltap    15 12-4 21 12-1   15 13-1 45 13-6   15 14-1 12 14-4 45 14-2   15 15-1 12 15-4 45 15-2   15 16-1 12 16-6 45 16-4
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]           0
mirp[min,rnd,grey]  vstem 34
mirp[rp0,rnd,grey]  vheight_shoot 24
sloop   3
ip  39 40 45
mdrp[min,rnd,grey]  42
mirp[rp0,grey]  headstem 10
mdrp[rp0,rnd,white] 12
mdap[rnd]   12
mdrp[rp0,rnd,grey]  18
mirp[min,rnd,grey]  headstem 50
mirp[rnd,grey]      headstem_plus_hole 56
srp2    1
ip  3
ip  31
f_deltap    10 14+3   10 15+2   10 16+2
f_deltap    18 9+4  18 10+8  18 11+4  18 12+1   18 13+1   18 14+1   18 15+1   18 16+1 24 16-1 
IUP[y]
""",

    #so_zo
    "uni0E0B": """
f_deltap    67 9+8   67 10+8   67 12+8   67 13+8   67 14+8   67 16+8
srp0    66
mdrp[rp0,rnd,grey]  18
mdrp[min,rnd,grey]  13
mirp[min,rnd,grey]  headstem 57
mirp[rp0,rnd,grey]  headstem_plus_hole 63
mdrp[grey]  24
srp0    18
mdrp[rp0,rnd,grey]  31
f_deltap    31 9+4   31 31+8
mirp[grey]  vstem 7
f_deltap    7 16+3
srp1    13
sloop   6
ip  27 28 29 9 10 11
mdrp[rp0,rnd,grey]  1
mdap[rnd]   1
f_deltap    1 14+8   1 15+8   1 18-8
mirp[min,rnd,grey]  hstem 36
#
srp0    67
mirp[rp0,rnd,white] gap_113  47
mirp[min,rnd,grey]  hstem 46
mdrp[rp0,rnd,grey]  51
f_deltap    51 17+8   51 18+8   51 29+8   51 31+8   51 39+8
mirp[min,rnd,grey]  hstem 40
srp1    31
ip  43
srp0    43
mdrp[grey]  49
f_deltap    18 12-4 18 13-4 18 14-1 18 15-1 18 16-1
f_deltap    47 9+4 46 9+4  47 10+4 46 10+4  47 11+4 46 11+4   47 17+8 46 17+8
f_deltap    49 16-4
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  0
mirp[min,rnd,grey]  vstem   38
mirp[rp0,rnd,grey]  vheight_shoot   27
alignrp     29
sloop   3
ip  43 44 49
mdrp[min,rnd,grey]  47
mirp[grey]  sarastem 11
shp[rp2]    9
mdrp[rp0,min,rnd,grey] 28
mirp[rp0,grey] headstem 10
mdrp[rp0,rnd,white] 15
mdap[rnd]   15
f_deltap    15 9+8   15 10+8   15 11+8   
mdrp[rnd,grey]  13
mirp[min,rnd,grey]  headstem 61
mirp[rp0,rnd,grey]  headdia 21
f_deltap    21 19+8   21 24+8   21 25+8   21 26+8   
mirp[min,rnd,grey]  headstem 54
srp2    1
ip  3
ip  35
f_deltap    15 14-1 15 15-1 15 16-1   21 14+1 21 15+1 21 16+1
f_deltap    28 14-2    28 15-2   28 16-2
IUP[y]
""",

    #sho_sher
    "uni0E0C": """
f_deltap    78 12+8
srp0    77
mirp[rp0,rnd,grey]  gap_197 36
mirp[rp0,min,rnd,grey]  hstem 25
mdrp[rp0,grey]  23
mdrp[min,rnd,grey]  39
srp0    36
mdrp[rp0,grey]  40
mdrp[min,rnd,grey]  21
srp0    36
mirp[rp0,rnd,grey]  headdia_plus 31
mirp[min,rnd,grey]  headstem 56
mirp[rnd,grey]  headstem_plus_hole 62 
#
srp0    78
mirp[rp0,rnd,grey]  gap_164 52
mirp[min,rnd,grey]  hstem 50
shp[rp2]    1
srp1    36
ip      14
#
mdap[rnd]   14
mirp[min,rnd,grey]  hstem 47
srp2    31
ip      11
mdap[rnd]   11
mirp[min,rnd,grey]  headstem 74
mirp[rp0,rnd,white] headdia 5
mirp[min,rnd,grey]  headstem 68
f_deltap    31 12-4 31 13-4 31 14-1 31 15-1 31 16-1   11 14+1 11 15+1 11 16+1
IUP[x]
SVTCA[y-axis]
mdap[rnd]  1
mirp[rnd,grey]  vheight_lo  8
shp[rp2]    34
mirp[rnd,grey]  vheight 52
mirp[min,rnd,grey]  vstem_curve 50
mirp[rp0,rnd,grey]  vheight_shoot 44
mirp[min,rnd,grey]  vstem_curve 18
f_deltap    18 18+4 18 19+4 18 20+4 18 21+4 18 22+4 18 23+4 18 24+4 18 25+4    18 29+4 18 30+4 18 31+4 18 32+4 18 33+4 18 34+4 18 35+4
srp0    8
mirp[min,rnd,grey] headstem 65
shp[rp2] 53
mirp[rp0,rnd,grey] headdia 14
alignrp 28
mirp[min,rnd,grey]  headstem 71
shp[rp2] 59
mdrp[rnd,grey]  48
mdrp[min,rnd,grey]  3
srp1    18
sloop   10
ip  41 21 40 22 39 23 15 47 37 25
f_deltap    28 14-1 28 15-1 28 16-1   34 14+1 34 15+1 34 16+1    14 14-1 14 15-1 14 16-1   8 14+1 8 15+1 8 16+1
IUP[y]
""",

    #yo_ying
    "uni0E0D": """
f_deltap    83 16+8
srp0    82
mirp[rp0,rnd,grey]  gap_197 23
mirp[rp0,min,rnd,grey]  hstem 12
mdrp[rp0,grey]  10
mdrp[min,rnd,grey]  26
srp0    23
mdrp[rp0,grey]  27
mdrp[min,rnd,grey]  8
srp0    23
mirp[rp0,rnd,grey]  headdia_plus 18
mirp[min,rnd,grey]  headstem 42
mirp[rnd,grey]  headstem_plus_hole 48
#
srp0    83
mirp[rp0,rnd,grey]  gap_164 38
mdrp[rnd,grey]  67
mirp[min,rnd,grey]  hstem 36
srp1    23
ip      1
#
mdap[rnd]   1
mdrp[rnd,grey]  54
mirp[min,rnd,grey]  hstem 34
#
srp0    54
mirp[min,rnd,grey]  headstem_tiny 79
mirp[rp0,rnd,grey]  headdia_tiny 60
mirp[min,rnd,grey]  headstem_tiny 73
f_deltap    18 12-4 18 13-4 18 14-1 18 15-1 18 16-1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  1
mirp[rnd,grey]  vheight_lo 21
mirp[rnd,grey]  vheight 38
mirp[min,rnd,grey]  vstem 35
mirp[rp0,rnd,grey]  vheight_shoot 31
mirp[min,rnd,grey]  vstem_curve 5
f_deltap    5 18+4 5 19+4 5 20+4 5 21+4 5 22+4 5 23+4 5 24+4 5 25+4    5 29+4 5 30+4 5 31+4 5 32+4 5 33+4 5 34+4 5 35+4
srp0    21
mirp[min,rnd,grey] headstem 39
mirp[rp0,rnd,grey] headdia 15
mirp[min,rnd,grey]  headstem 45
srp0    1
mdrp[rp0,min,rnd,grey] 57
mdrp[rnd,grey]  66
mirp[min,rnd,grey]  headstem_tiny 76
mdrp[rp0,rnd,grey]  51
mdrp[min,rnd,grey]  70
mdrp[min,rnd,grey]  63
srp1    5
srp2    1
sloop   10
ip  28 8 27 9 26 10 2 34 24 12
f_deltap    15 14-1 15 15-1 15 16-1   21 14+1 21 15+1 21 16+1
IUP[y]
""",

    #yo_ying
    "uni0E0D.descless": """
f_deltap    52 16+8
srp0    51
mirp[rp0,rnd,grey]  gap_197 23
mirp[rp0,min,rnd,grey]  hstem 12
mdrp[rp0,grey]  10
mdrp[min,rnd,grey]  26
srp0    23
mdrp[rp0,grey]  27
mdrp[min,rnd,grey]  8
srp0    23
mirp[rp0,rnd,grey]  headdia_plus 18
mirp[min,rnd,grey]  headstem 42
mirp[rnd,grey]  headstem_plus_hole 48
#
srp0    52
mirp[rp0,rnd,grey]  gap_164 38
mdrp[rnd,grey]  67
mirp[min,rnd,grey]  hstem 36
srp1    23
ip      1
#
mdap[rnd]   1
mirp[min,rnd,grey]  hstem 34
f_deltap    18 12-4 18 13-4 18 14-1 18 15-1 18 16-1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  1
mirp[rnd,grey]  vheight_lo 21
mirp[rnd,grey]  vheight 38
mirp[min,rnd,grey]  vstem 35
mirp[rp0,rnd,grey]  vheight_shoot 31
mirp[min,rnd,grey]  vstem_curve 5
f_deltap    5 18+4 5 19+4 5 20+4 5 21+4 5 22+4 5 23+4 5 24+4 5 25+4    5 29+4 5 30+4 5 31+4 5 32+4 5 33+4 5 34+4 5 35+4
srp0    21
mirp[min,rnd,grey] headstem 39
mirp[rp0,rnd,grey] headdia 15
mirp[min,rnd,grey]  headstem 45
srp1    5
srp2    1
sloop   10
ip  28 8 27 9 26 10 2 34 24 12
f_deltap    15 14-1 15 15-1 15 16-1   21 14+1 21 15+1 21 16+1
IUP[y]
""",

    #do_chada
    "uni0E0E": """
f_deltap    75 9+8   75 12+8   75 14+8   75 16-8   75 18-8   75 19-8   75 22+8   75 30-8   
srp0    74
mirp[rp0,rnd,white] gap_84 35
mirp[min,rnd,grey]  headstem 61
mirp[rnd,grey]  headstem_plus_hole 55
mirp[rp0,rnd,grey]  headdia_plus    29
mirp[rp0,min,rnd,grey]  hstem 40
mdrp[rp0,grey]  44
mdrp[min,rnd,grey]  25
srp0    29
mdrp[rp0,grey]  27
mdrp[min,rnd,grey]  43
#
srp0    75
mirp[rp0,rnd,white]  gap_164 51
f_deltap    51 33+8   51 36+8   
mirp[min,rnd,grey]  hstem 18
shp[rp2]    1
srp0    40
mdrp[rp0,rnd,grey]  8
mirp[min,rnd,grey]  sarastem 71
srp1    71
srp2    18
sloop   6
ip  66 13 14 3 16 15
f_deltap    35 12+4 35 13+4 35 14+1 35 15+1 35 16+1    8 14+2 8 15+2 8 16+2
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   74
mirp[rnd,grey]  vheight_lo 32
mirp[rnd,grey]  vheight_lu 1
shp[rp2]    5
mirp[rp0,rnd,grey]  vheight_shoot 48
mirp[min,rnd,grey]  vstem_curve   22
f_deltap    22 18+4 22 19+4 22 20+4 22 21+4 22 22+4 22 23+4 22 24+4 22 25+4    22 29+4 22 30+4 22 31+4 22 32+4 22 33+4 22 34+4 22 35+4
srp0    32
mirp[min,rnd,grey]  headstem 52
mirp[rp0,rnd,grey]  headdia 38
mirp[min,rnd,grey]  headstem 58
srp0    5
mirp[min,rnd,grey]  headstem   64
mdrp[rp0,rnd,grey]  11
mirp[min,rnd,grey]  headstem   68
sloop   6
ip  14 15 13 16 66 3
srp0    1
mdrp[grey]  18
srp1    22
srp2    32
sloop   10
ip  45 25 44 26 43 27 19 51 41 29
f_deltap    38 14-1 38 15-1 38 16-1   32 14+1 32 15+1 32 16+1    11 14-2 11 15-2 11 16-2   13 14-2 13 15-2 13 16-2   16 14-2 16 15-2 16 16-2   18 14-2 18 15-2 18 16-2   5 14+1 5 15+1 5 16+1
IUP[y]
""",

    #to_patak
    "uni0E0F": """
f_deltap    79 9+8   79 12+8   79 14+8   79 16-8   79 18-8   79 19-8   79 22+8   79 30-8   
srp0    78
mirp[rp0,rnd,grey]  gap_84 41
mirp[min,rnd,grey]  headstem 67
mirp[rnd,grey]  headstem_plus_hole 61
mirp[rp0,rnd,grey]  headdia_plus 35
mirp[rp0,min,rnd,grey]  hstem 46
mdrp[rp0,grey]  50
mdrp[min,rnd,grey]  31
srp0    35
mdrp[rp0,grey]  33
mdrp[min,rnd,grey]  49
#
srp0    79
mirp[rp0,rnd,grey]  gap_164 57
mirp[min,rnd,grey]  hstem 24
shp[rp2]    1
mdrp[rp0,rnd,grey]  11
mirp[min,rnd,grey]  headstem 76
srp1    76
srp2    24
sloop   12
ip  72 16 17 6 19 18 4 21 3 22 2 23
f_deltap    41 12+4 41 13+4 41 14+1 41 15+1 41 16+1    11 14+2 11 15+2 11 16+2
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   78
mirp[rnd,grey]  vheight_lo 38
mirp[rnd,grey]  vheight_lu 8
mirp[rp0,rnd,grey]  vheight_shoot 54
mirp[min,rnd,grey]  vstem_curve   28
f_deltap    28 18+4 28 19+4 28 20+4 28 21+4 28 22+4 28 23+4 28 24+4 28 25+4    28 29+4 28 30+4 28 31+4 28 32+4 28 33+4 28 34+4 28 35+4
srp0    38
mirp[min,rnd,grey]  headstem 58
mirp[rp0,rnd,grey]  headdia 44
mirp[min,rnd,grey]  headstem 64
srp0   8
alignrp 4
alignrp 1 
mirp[min,rnd,grey]  headstem   70
mdrp[rp0,rnd,grey]  14
sloop   9
ip  17 16 19 22 72 6 21 24 2
mirp[min,rnd,grey]  headstem   74
srp1    28
srp2    38
sloop   10
ip  51 31 50 32 49 33 25 57 47 35
f_deltap    44 14-1 44 15-1 44 16-1   36 14+1 36 15+1 36 16+1    14 14-2 14 15-2 14 16-2   8 14+1 8 15+1 8 16+1
IUP[y]
""",

    #tho_than
    "uni0E10": """
f_deltap    118 9+8   118 10+8   118 21-8
srp0    117
mirp[rp0,rnd,grey]  gap_164 7
mdrp[grey]  19
mirp[min,rnd,grey]  headstem 56
mirp[rp0,rnd,grey]  headstem_plus_hole 50
mdrp[grey]  12
f_deltap    12 18+2
srp0    19
mdrp[min,rnd,grey]  41
#
srp0    118
mirp[rp0,rnd,grey]  gap_164   44
mirp[min,rnd,grey]  hstem   16
mdrp[grey]  31
srp2    12
ip      0
mdap[rnd]   0
srp2    12
ip  11
ip  13
mdrp[grey]  1
f_deltap    2 18-2
#
srp0    44
mdrp[rp0,rnd,grey]  96
mdrp[min,rnd,grey]  85
mdrp[min,rnd,grey]  100
mdrp[rp0,rnd,grey]  91
mdrp[min,rnd,grey]  106
srp0    96
mdrp[rp0,min,rnd,grey]  70
mdrp[min,rnd,grey]  115
srp1    115
srp2    85
sloop   13
ip  111 75 77 65 80 78 63 82 62 83 61 84 60
f_deltap    7 12+4 7 13+4 7 14+1 7 15+1 7 16+1
IUP[x]
#
SVTCA[y-axis]                       
mdap[rnd]   1
mirp[grey]  vstem_curve 13
mirp[rp0,rnd,grey]  vheight_shoot   23
mirp[min,rnd,grey]  vstem_curve 38
f_deltap    38 18+4 38 19+4 38 20+4 38 21+4 38 22+4 38 23+4 38 24+4 38 25+4    38 29+4 38 30+4 38 31+4 38 32+4 38 33+4 38 34+4 38 35+4
mdrp[rp0,grey]  33
mdrp[grey]  30
ip  28
ip  31
#
srp0    23
mdrp[rp0,rnd,grey]  10
sloop   7
ip  20 41 19 42 18 16 44
mirp[min,rnd,grey]  headstem    53
mirp[rp0,rnd,grey]  headdia 4
f_deltap    4 19+8   4 24+8   4 25+8   4 26+8
mirp[min,rnd,grey]  headstem 47
#
srp0    1
mdrp[rp0,min,rnd,grey]  94
mdrp[min,rnd,grey]  103
mdrp[rp0,rnd,grey]  88
mdrp[min,rnd,grey]  97
mdrp[rp0,rnd,grey]  59
f_deltap    59 9+8   59 10+8   59 11+8   
alignrp 62
alignrp 67
srp0    67
mdrp[min,rnd,grey]  109
mdrp[rp0,rnd,grey]  73
mdrp[min,rnd,grey]  113
srp1    73
srp2    67
sloop   10
ip  77 75 78 111 80 83 65 82 85 61
f_deltap    10 14-1 10 15-1 10 16-1   4 14+1 4 15+1 4 16+1
f_deltap    13 14-2 13 15-2 13 16-2
IUP[y]
f_deltap    2 15+8 
""",

    #tho_than_descless
    "uni0E10.descless": """
f_deltap    60 9+8   60 10+8   60 21-8
srp0    59 
mirp[rp0,rnd,grey]  gap_164 7
mdrp[grey]  19
mirp[min,rnd,grey]  headstem 56
mirp[rp0,rnd,grey]  headstem_plus_hole 50
mdrp[grey]  12
f_deltap    12 18+2
srp0    19
mdrp[min,rnd,grey]  41
#
srp0    60
mirp[rp0,rnd,grey]  gap_164   44
mirp[min,rnd,grey]  hstem   16
mdrp[grey]  31
srp2    12
ip      0
mdap[rnd]   0
srp2    12
ip  11
ip  13
mdrp[grey]  1
f_deltap    2 18-2
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   1
mirp[grey]  vstem_curve 13
mirp[rp0,rnd,grey]  vheight_shoot   23
mirp[min,rnd,grey]  vstem_curve 38
f_deltap    38 18+4 38 19+4 38 20+4 38 21+4 38 22+4 38 23+4 38 24+4 38 25+4    38 29+4 38 30+4 38 31+4 38 32+4 38 33+4 38 34+4 38 35+4
mdrp[rp0,grey]  33
mdrp[grey]  30
ip  28
ip  31
#
srp0    23
mdrp[rp0,rnd,grey]  10
sloop   7
ip  20 41 19 42 18 16 44
mirp[min,rnd,grey]  headstem    53
mirp[rp0,rnd,grey]  headdia 4
f_deltap    4 19+8   4 24+8   4 25+8   4 26+8
mirp[min,rnd,grey]  headstem 47
#
IUP[y]
f_deltap    2 15+8
""",

    #tho_nangmontho
    "uni0E11": """
f_deltap    67 10+8   
srp0    66
mdrp[rp0,rnd,grey]  27
mdrp[min,rnd,grey]  22
mirp[min,rnd,grey]  headstem 57
mirp[rnd,grey]  headstem_plus_hole 63
mdrp[grey]  33
mdrp[rp0,rnd,grey]  40
f_deltap    40 15+8   40 17-6    40 19+4   40 20-3   
mirp[grey]  vstem 16
srp1    22
sloop   6
ip  36 20 37 19 38 18
mdrp[rp0,rnd,grey]  10
mdap[rnd]   10
f_deltap    10 14+8
mirp[min,rnd,grey]  hstem 45
shp[rp2]    9
mirp[min,rnd,grey]  hstem 1
#
srp0    67
mirp[rp0,rnd,grey]  gap_164 53
mirp[min,rnd,grey]  hstem 1
srp1    40
sloop   4
ip  48 49 6 7
f_deltap    27 12-4 27 13-4 27 14-1 27 15-1 27 16-1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   9
alignrp 1
mirp[min,rnd,grey]  vstem_curve 46
mirp[rp0,rnd,grey]  vheight_shoot   51
alignrp 36
alignrp 38
mirp[min,rnd,grey]  vstem_curve 4
f_deltap    4 18+4 4 19+4 4 20+4 4 21+4 4 22+4 4 23+4 4 24+4 4 25+4    4 29+4 4 30+4 4 31+4 4 32+4 4 33+4 4 34+4 4 35+4
srp0    36
mirp[grey]  sarastem 20
shp[rp2]    18
mdrp[rp0,min,rnd,grey]  37
mirp[rp0,grey]  headstem 19
mdrp[rp0,rnd,white]  24
mdap[rnd]   24
f_deltap    24 9+8   24 10+8   24 25-8   24 26-8   
mirp[min,rnd,grey]  headstem    60
mirp[rp0,rnd,grey]  headdia 30
f_deltap    30 19+8   30 24+8   30 25+8   30 26+8
mirp[min,rnd,grey]  headstem 54
srp2    9
ip  12
ip  44
f_deltap    24 14-1 24 15-1 24 16-1   30 14+1 30 15+1 30 16+1
IUP[y]
""",

    #to_putao
    "uni0E12": """
f_deltap    83 11+8   83 12+8
SRP0                82
mirp[rp0,rnd,white] gap_113 44
f_deltap    44 9-8
mdrp[grey]  41
mirp[rp0,min,rnd,grey]  hstem 22
mdrp[grey]  40
ip  25
srp0    44
mdrp[rp0,rnd,grey]  37
f_deltap    37 11-8   37 19+8   37 29-8   37 32-8   37 34-8   
mdrp[min,rnd,grey]  28
f_deltap    28 14-4 28 15-4 28 16+4
mirp[min,rnd,grey]  headstem 61
mirp[rp0,rnd,grey]  headdia 31
mirp[min,rnd,grey]  headstem 67
#
srp0    83
mirp[rp0,rnd,white] gap_164 57
mirp[min,rnd,grey]  hstem 55
shp[rp2]    1
srp1    44
ip  14
mdap[rnd]   14
srp2    22
sloop   7
ip      47 48 49 17 18 19 20
mirp[min,rnd,grey]  hstem 52
shp[rp2]    3
mdrp[rp0,rnd,grey]   11
f_deltap    11 17+8   11 18+8   11 19+8   11 26+8   11 29+8   
mirp[min,rnd,grey]  headstem 79
mirp[rp0,rnd,grey]  headdia 5
mirp[min,rnd,grey]  headstem 73
f_deltap    37 14-1 37 15-1 37 16-1   31 14+1 31 15+1 31 16+1   5 14-1 5 15-1 5 16-1   11 14+1 11 15+1 11 16+1
IUP[x]
#
SVTCA[y-axis]
MDAP[rnd]           1
alignrp     40
mirp[min,rnd,grey]  vstem 55
shp[rp2]    25
mirp[rnd,grey]  vheight_lo  8
mirp[rnd,grey]  vheight 57
mirp[rp0,rnd,grey]  vheight_shoot 47
alignrp     49
mirp[min,rnd,grey]  vstem_curve 20
mdrp[rp0,rnd,grey]  48
mdrp[rp0,grey]  19
mdrp[rp0,rnd,white] 34
mdap[rnd]   34
f_deltap    34 16-8
mirp[min,rnd,grey]  headstem 64
mirp[rp0,rnd,grey]  headdia 28
mirp[min,rnd,grey]  headstem 58
#
srp0    8
mirp[min,rnd,grey]  headstem 70
mirp[rp0,rnd,grey]  headdia 14
alignrp 53
mirp[min,rnd,grey]  headstem 76
srp0    53
mdrp[min,grey]  3
f_deltap    34 14-1 34 15-1 34 16-1   28 14+1 28 15+1 28 16+1   14 14-1 14 15-1 14 16-1   8 14+1 8 15+1 8 16+1
f_deltap    25 14-2 25 15-2 25 16-2
IUP[y]
""",

    #no_nane
    "uni0E13": """
srp0    77
mirp[rp0,rnd,grey]  gap_197 23
f_deltap    23 16-8
mirp[min,rnd,grey]  hstem 12
mdrp[rp0,grey]  10
mdrp[min,rnd,grey]  26
srp0    23
mdrp[rp0,grey]  27
mdrp[min,rnd,grey]  8
srp0    23
mirp[rp0,rnd,grey]  headdia_plus    18
f_deltap    18 12-4
mirp[min,rnd,grey]  headstem 56
mirp[rnd,grey]  headstem_plus_hole 62
#
srp0    78
mirp[rp0,rnd,grey]  gap_205 39
mirp[min,rnd,grey]  hstem 37
srp1    23
ip      1
mdrp[rp0,rnd,grey] 49
f_deltap    49 13+8
mirp[min,rnd,grey]  headstem 74
mirp[rp0,rnd,grey]  headdia 43
mirp[min,rnd,grey]  headstem 68
#
mdap[rnd]   1
mirp[min,rnd,grey]  hstem  34
shp[rp2]    0
f_deltap    18 12-4 18 13-4 18 14-1 18 15-1 18 16-1
f_deltap    43 14-1 43 15-1 43 16-1   49 14+1 49 15+1 49 16+1
IUP[x]
SVTCA[y-axis]
mdap[rnd]  0
mirp[min,rnd,grey]  vstem_curve 35
mirp[rnd,grey]  vheight_lo 21
shp[rp2]    46
mirp[rnd,grey]  vheight 39
mirp[rp0,rnd,grey]  vheight_shoot 31
mirp[min,rnd,grey]  vstem_curve 5
f_deltap    5 18+4 5 19+4 5 20+4 5 21+4 5 22+4 5 23+4 5 24+4 5 25+4    5 29+4 5 30+4 5 31+4 5 32+4 5 33+4 5 34+4 5 35+4
srp1    0
sloop   10
ip  28 8 27 9 26 10 2 34 24 12
srp0    21
mirp[min,rnd,grey] headstem 53
shp[rp2]    65
mirp[rp0,rnd,grey] headdia 15
alignrp     37
alignrp     40
mirp[min,rnd,grey] headstem 59
shp[rp2]    71
f_deltap    15 14-1 15 15-1 15 16-1   21 14+1 21 15+1 21 16+1    15 14-1 37 15-1 37 16-1   46 14+1 46 15+1 46 16+1
IUP[y]
""",

    #do_dek
    "uni0E14": """
f_deltap    50 9+8   50 10+8   50 12+8
SRP0    49
MIRP[rp0,rnd,grey]   gap_113 30
mdrp[grey]      27
mirp[rp0,min,rnd,grey]  hstem 8
mdrp[grey]      11
ip      26
srp0    30
mdrp[rp0,rnd,grey]  23
f_deltap    23 11-8   23 19+8   23 25+8   23 29-8   23 32-8   23 34-8   23 37-8
mdrp[grey]  14
mirp[min,rnd,grey]  headstem 40
mirp[rp0,rnd,grey]  headdia 17
mirp[min,rnd,grey]  headstem 46
#
srp0    50
mirp[rp0,rnd,grey]  gap_164 36
f_deltap    36 36+8   
mirp[min,rnd,grey]  hstem 1
f_deltap    23 14-1 23 15-1 23 16-1   17 14+1 17 15+1 17 16+1
IUP[x]
#
SVTCA[y-axis]
MDAP[rnd]   26
ALIGNRP     1
mirp[grey]  vstem 11
f_deltap    11 13-2  11 14-2  11 15-2 11 16-4  11 17-1
MIRP[rp0,rnd,grey]  vheight_shoot  33
MIRP[min,rnd,grey]  vstem_curve  5
f_deltap    5 18+4 5 19+4 5 20+4 5 21+4 5 22+4 5 23+4 5 24+4 5 25+4    5 29+4 5 30+4 5 31+4 5 32+4 5 33+4 5 34+4 5 35+4
mdrp[rp0,rnd,grey]      20
f_deltap    20 16-8
mirp[min,rnd,grey]      headstem 43
mirp[rp0,rnd,grey]      headdia 14
mirp[min,rnd,grey]      headstem 37
srp1    11
srp2    14
ip  24
f_deltap    20 14-1 20 15-1 20 16-1   14 14+1 14 15+1 14 16+1
IUP[y]
""",

    #to_tao
    "uni0E15": """
f_deltap    53 9+8   53 10+8   53 12+8
SRP0    52
MIRP[rp0,rnd,grey]   gap_113 31
mdrp[grey]      28
mirp[rp0,min,rnd,grey]  hstem 9
mdrp[grey]      12
ip      27
srp0    31
mdrp[rp0,rnd,grey]  24
f_deltap    24 11-8   24 19+8   24 25+8   24 29-8   24 32-8   24 34-8   24 37-8
mdrp[grey]  15
mirp[min,rnd,grey]  headstem 43
mirp[rp0,rnd,grey]  headdia 18
mirp[min,rnd,grey]  headstem 49
#
srp0    53
mirp[rp0,rnd,grey]  gap_164 39
f_deltap    39 36+8
mirp[min,rnd,grey]  hstem 1
srp1    9
sloop   7
ip  34 35 36 4 5 6 7
f_deltap    24 14-1 24 15-1 24 16-1   18 14+1 18 15+1 18 16+1
IUP[x]
#
SVTCA[y-axis]
MDAP[rnd]   27
ALIGNRP     1
mirp[grey]  vstem 12
f_deltap    12 13-2  12 14-2  12 15-2 12 16-4  12 17-1
MIRP[rp0,rnd,grey]  vheight_shoot  34
alignrp 36
MIRP[min,rnd,grey]  vstem_curve  7
f_deltap    7 18+4 7 19+4 7 20+4 7 21+4 7 22+4 7 23+4 7 24+4 7 25+4    7 29+4 7 30+4 7 31+4 7 32+4 7 33+4 7 34+4 7 35+4
shp[rp2]    4
mdrp[rp0,min,rnd,grey]  35
mdrp[rp0,grey]  6
mdrp[rp0,rnd,white]     21
mdap[rnd]   21
f_deltap    21 16-8
mirp[min,rnd,grey]      headstem 46
mirp[rp0,rnd,grey]      headdia 15
mirp[min,rnd,grey]      headstem 40
srp1    12
srp2    15
ip  25
f_deltap    21 14-1 21 15-1 21 16-1   15 14+1 15 15+1 15 16+1
IUP[y]
""",

    #to_tung
    "uni0E16": """
f_deltap    48 10+8   48 14-8   48 20-8   48 26+8
srp0                47
mirp[rp0,rnd,grey]  gap_197 23
mirp[min,rnd,grey]  hstem  12
mdrp[rp0,grey]  27
mdrp[min,rnd,grey]  8
srp0            12
mdrp[rp0,grey]  10
mdrp[min,rnd,grey]  26
srp0    23
mirp[rp0,rnd,grey]  headdia_plus 18
f_deltap    18 12-4
mirp[min,rnd,grey]  headstem 38
mirp[rnd,grey]  headstem_plus_hole 44
#
srp0    48
mirp[rp0,rnd,grey]  gap_164 34
mirp[min,rnd,grey]  hstem  1
f_deltap    18 12-4 18 13-4 18 14-1 18 15-1 18 16-1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]           1
mirp[rnd,grey]      vheight_lo  21
mirp[rp0,rnd,grey]  vheight_shoot    31
mirp[min,rnd,grey]  vstem_curve  5
f_deltap    5 18+4 5 19+4 5 20+4 5 21+4 5 22+4 5 23+4 5 24+4 5 25+4    5 29+4 5 30+4 5 31+4 5 32+4 5 33+4 5 34+4 5 35+4
srp1                1
sloop               10
ip      24 26 27 28 8 9 10 12 2 34
srp0    21
mirp[min,rnd,grey]  headstem 35
mirp[rp0,rnd,grey]  headdia 15
mirp[min,rnd,grey]  headstem 41
f_deltap    15 14-1 15 15-1 15 16-1   21 14+1 21 15+1 21 16+1
IUP[y]
""",

    #to_tahan
    "uni0E17": """
f_deltap    41 20-8  41 23-8  41 26-8
srp0    40
mirp[rp0,rnd,white]  gap_84 15
f_deltap    15 9-8   15 12-8   15 13-8
mirp[min,rnd,grey]  headstem 37
mirp[rnd,grey]  headstem_plus_hole 31
mirp[rp0,rnd,grey]  headdia_plus 20
mirp[min,rnd,grey]  hstem 9
mdrp[rp0,rnd,grey]  15
#
srp0    41
mirp[rp0,rnd,grey]  gap_164 27
f_deltap    27 23+8   27 26+8   27 32+8   27 36+8   
mirp[min,rnd,grey]  hstem 1
srp1   20
sloop   3
ip  8 23 6
f_deltap    15 12+4 15 13+4 15 14+1 15 15+1 15 16+1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  8
alignrp 1
mdrp[grey]  21
f_deltap    21 12-4 21 13-4 21 14-8 21 15-8 21 16-8
mirp[rp0,rnd,grey]  vheight_shoot 25
alignrp 18
mirp[min,rnd,grey]  vstem_curve 4
f_deltap    4 18+4 4 19+4 4 20+4 4 21+4 4 22+4 4 23+4 4 24+4 4 25+4    4 29+4 4 30+4 4 31+4 4 32+4 4 33+4 4 34+4 4 35+4
srp0    18
mirp[min,rnd,grey]  headstem 34
mirp[rp0,rnd,grey]  headdia 12
mirp[min,rnd,grey]  headstem 28
srp0    8
srp1    25
srp2    21
sloop   5
ip  20 23 6 2 27
f_deltap    18 14-1 18 15-1 18 16-1   12 14+1 12 15+1 12 16+1
IUP[y]
""",

    #to_thong
    "uni0E18": """
f_deltap    40 10+8   
srp0    39
mirp[rp0,min,rnd,grey] gap_205 1
f_deltap    1 15-8   1 17-8 
mirp[min,rnd,grey]  hstem 3
mdrp[rp0,grey]  11
mdrp[min,rnd,grey]  33
#
srp0    40
mirp[rp0,rnd,grey]  gap_164 36
mirp[min,rnd,grey]  hstem 7
mdrp[rp0,grey]  23
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  0
mirp[min,rnd,grey]  vstem 5
mirp[rp0,rnd,grey]  vheight_shoot 15
mdrp[grey]  20
mdrp[grey]  22
mirp[rp0,min,rnd,grey]  vstem_curve 30
f_deltap    30 18+4 30 19+4 30 20+4 30 21+4 30 22+4 30 23+4 30 24+4 30 25+4    30 29+4 30 30+4 30 31+4 30 32+4 30 33+4 30 34+4 30 35+4
srp2    0
sloop   3
ip  11 12 33
mdrp[grey]  23
mdrp[rp0,grey]  25
mdrp[grey]  3
IUP[y]
""",

    #no_nu
    "uni0E19": """
f_deltap     56 22+8 56 36-8   
srp0    55
mirp[rp0,rnd,white] gap_84 7
f_deltap    7 9-8   7 12-8   7 13-8   
mirp[min,rnd,grey]  headstem 40
mirp[rnd,grey]  headstem_plus_hole 34
mirp[rp0,rnd,grey]  headdia_plus 12
shp[rp2]    0
mirp[min,rnd,grey]  hstem 1
#
srp0    56
mirp[rp0,rnd,white]  gap_240 17
mirp[min,rnd,grey]  hstem 15
mdrp[rp0,rnd,grey]  21
mirp[min,rnd,grey]  headstem 46
mirp[rp0,rnd,grey]  headdia 27
mirp[min,rnd,grey]  headstem 52
f_deltap    7 12+4 7 13+4 7 14+1 7 15+1 7 16+1    21 14-1 21 15-1 21 16-1   27 14+1 27 15+1 27 16+1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  0
mirp[min,rnd,grey]  vstem_curve 13
mirp[rnd,grey]  vheight_lo 24
mirp[rnd,grey]  vheight 17
mirp[rp0,rnd,grey]  vheight_shoot 10
mirp[min,rnd,grey]  headstem 37
mirp[rp0,rnd,grey]  headdia 4
mirp[min,rnd,grey]  headstem 31
srp0    24
mirp[min,rnd,grey]  headstem 43
mirp[rp0,rnd,grey]  headdia 18
alignrp     15
mirp[min,rnd,grey]  headstem 49
mdrp[min,rnd,grey]  29
f_deltap    10 14-1 10 15-1 10 16-1   4 14+1 4 15+1 4 16+1    15 14-1 15 15-1 15 16-1   24 14+1 24 15+1 24 16+1
IUP[y]
""",

    #bo_baimai
    "uni0E1A": """
f_deltap    30 11+8   30 13-8   30 14+8  30 16-8
srp0    29
mirp[rp0,rnd,white] gap_84 7
f_deltap    7 9-8   7 12-8   7 13-8
mirp[min,rnd,grey]  headstem 26
mirp[rnd,grey]  headstem_plus_hole 20
mirp[rp0,rnd,grey]  headdia_plus 12
mirp[min,rnd,grey]  hstem 1
#
srp0    30
mirp[rp0,rnd,grey]  gap_164 16
mirp[min,rnd,grey]  hstem 14
f_deltap    7 12+4 7 13+4 7 14+1 7 15+1 7 16+1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  0
mirp[min,rnd,grey]  vstem 14
mirp[rnd,grey]  vheight 16
mirp[rp0,rnd,grey]  vheight_shoot 10
mirp[min,rnd,grey]  headstem 23
mirp[rp0,rnd,grey]  headdia 4
mirp[min,rnd,grey]  headstem 17
f_deltap    10 14-1 10 15-1 10 16-1   4 14+1 4 15+1 4 16+1
IUP[y]
""",

    #po_pla
    "uni0E1B": """
f_deltap    30 11+8   30 13-8   30 14+8  30 16-8
srp0    29
mirp[rp0,rnd,white] gap_84 7
f_deltap    7 9-8   7 12-8   7 13-8
mirp[min,rnd,grey]  headstem 26
mirp[rnd,grey]  headstem_plus_hole 20
mirp[rp0,rnd,grey]  headdia_plus 12
mirp[min,rnd,grey]  hstem 1
#
srp0    30
mirp[rp0,rnd,grey]  gap_164 16
mirp[min,rnd,grey]  hstem 14
f_deltap    7 12+4 7 13+4 7 14+1 7 15+1 7 16+1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  0
mirp[min,rnd,grey]  vstem 14
mirp[rnd,grey]  vheight_po 16
mirp[rp0,rnd,grey]  vheight_shoot 10
mirp[min,rnd,grey]  headstem 23
mirp[rp0,rnd,grey]  headdia 4
mirp[min,rnd,grey]  headstem 17
f_deltap    10 14-1 10 15-1 10 16-1   4 14+1 4 15+1 4 16+1
IUP[y]
""",

    #po_phung
    "uni0E1C": """
f_deltap    35 13-8   35 15-8   35 16-8   
srp0    34
mirp[rp0,rnd,grey]  gap_186 4
mirp[min,rnd,grey]  hstem 15
shp[rp2]    3
mirp[rp0,rnd,grey]  headdia_plus 10
f_deltap    10 12-4
mirp[min,rnd,grey]  headstem 25
mirp[rnd,grey]  headstem_plus_hole 31
#
srp0    35
mirp[rp0,rnd,grey]  gap_164 21
mirp[min,rnd,grey]  hstem   19
shp[rp2]    1
srp1    15
sloop 3
ip  17 2 18
f_deltap    10 12-4 10 13-4 10 14-1 10 15-1 10 16-1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   1
alignrp     3
mirp[rnd,grey]  vheight 21
mirp[rp0,rnd,grey]  vheight_shoot 7
mirp[min,rnd,grey]  headstem 28
mirp[rp0,rnd,grey]  headdia 13
f_deltap    13 13-4
mirp[min,rnd,grey]  headstem 22
mdrp[rp0,rnd,white] 17
mirp[min,rnd,grey]  vstem 2
srp2    0
ip  19
ip  16
f_deltap    7 14-1 7 15-1 7 16-1   13 14+1 13 15+1 13 16+1
IUP[y]
""",

    #fo_fa
    "uni0E1D": """
f_deltap    35 13-8   35 15-8   35 16-8   
srp0    34
mirp[rp0,rnd,grey]  gap_186 4
mirp[min,rnd,grey]  hstem 15
shp[rp2]    3
mirp[rp0,rnd,grey]  headdia_plus 10
f_deltap    10 12-4
mirp[min,rnd,grey]  headstem 25
mirp[rnd,grey]  headstem_plus_hole 31
#
srp0    35
mirp[rp0,rnd,grey]  gap_164 21
mirp[min,rnd,grey]  hstem   19
shp[rp2]    1
srp1    15
sloop 3
ip  17 2 18
f_deltap    10 12-4 10 13-4 10 14-1 10 15-1 10 16-1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   1
alignrp     3
mirp[rnd,grey]  vheight_po 21
mirp[rp0,rnd,grey]  vheight_shoot 7
mirp[min,rnd,grey]  headstem 28
mirp[rp0,rnd,grey]  headdia 13
f_deltap    13 13-4
mirp[min,rnd,grey]  headstem 22
mdrp[rp0,rnd,white] 17
mirp[min,rnd,grey]  vstem 2
srp2    0
ip  19
ip  16
f_deltap    7 14-1 7 15-1 7 16-1   13 14+1 13 15+1 13 16+1
IUP[y]
""",

    #po_pan
    "uni0E1E": """
f_deltap    35 9+8   35 10+8   35 12+8   35 15-8
srp0    34
mirp[rp0,rnd,white] gap_84 10
f_deltap    10 9-8   10 12-8   10 13-8
mirp[min,rnd,grey]  headstem 31
mirp[rnd,grey]  headstem_plus_hole 25
mirp[rp0,rnd,grey]  headdia_plus 15
mirp[min,rnd,grey]  hstem 4
#
srp0    35
mirp[rp0,rnd,grey]  gap_164 21
mirp[min,rnd,grey]  hstem   19
srp1    15
sloop   5
ip      3 1 17 2 18 
f_deltap    10 12+4 10 13+4 10 14+1 10 15+1 10 16+1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   1
alignrp     3
mdrp[grey]  19
shp[rp2]    16
mirp[rnd,grey]  vheight 21
mirp[rp0,rnd,grey]  vheight_shoot 13
ip  17
ip  2
mirp[min,rnd,grey]  headstem 28
mirp[rp0,rnd,grey]  headdia 7
mirp[min,rnd,grey]  headstem 22
f_deltap    13 14-1 13 15-1 13 16-1   7 14+1 7 15+1 7 16+1
IUP[y]
""",

    #fo_fun
    "uni0E1F": """
f_deltap    35 9+8   35 10+8   35 12+8   35 15-8
srp0    34
mirp[rp0,rnd,white] gap_84 10
f_deltap    10 9-8   10 12-8   10 13-8
mirp[min,rnd,grey]  headstem 31
mirp[rnd,grey]  headstem_plus_hole 25
mirp[rp0,rnd,grey]  headdia_plus 15
mirp[min,rnd,grey]  hstem 4
#
srp0    35
mirp[rp0,rnd,grey]  gap_164 21
mirp[min,rnd,grey]  hstem   19
srp1    15
sloop   5
ip      3 1 17 2 18
f_deltap    10 12+4 10 13+4 10 14+1 10 15+1 10 16+1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   1
alignrp     3
mdrp[grey]  19
shp[rp2]    16
mirp[rnd,grey]  vheight_po 21
mirp[rp0,rnd,grey]  vheight_shoot 13
ip  17
ip  2
mirp[min,rnd,grey]  headstem 28
mirp[rp0,rnd,grey]  headdia 7
mirp[min,rnd,grey]  headstem 22
f_deltap    13 14-1 13 15-1 13 16-1   7 14+1 7 15+1 7 16+1
IUP[y]
""",

    #po_sampao
    "uni0E20": """
f_deltap    48 13-8   48 16-8
srp0    47
mirp[rp0,rnd,white]  gap_84 18
f_deltap    18 9-8   18 12-8   18 13-8
mirp[min,rnd,grey]  headstem 44
mirp[rnd,grey]  headstem_plus_hole 38
mirp[rp0,rnd,grey]  headdia_plus 12
mirp[rp0,min,rnd,grey]  hstem 23
mdrp[rp0,grey]  27
mdrp[min,rnd,grey]  8
srp0    12
mdrp[rp0,grey]  10
mdrp[min,rnd,grey]  26
#
srp0    48
mirp[rp0,rnd,white]  gap_164 34
mirp[min,rnd,grey]  hstem   1
f_deltap    18 12+4 18 13+4 18 14+1 18 15+1 18 16+1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  1
mirp[rnd,grey]  vheight_lo 15
mirp[rp0,rnd,grey]  vheight_shoot 31
sloop   10
ip  28 8 27 9 26 10 2 34 24 12
mirp[min,rnd,grey]  vstem_curve   5
f_deltap    5 18+4 5 19+4 5 20+4 5 21+4 5 22+4 5 23+4 5 24+4 5 25+4    5 29+4 5 30+4 5 31+4 5 32+4 5 33+4 5 34+4 5 35+4
srp0    15
mirp[min,rnd,grey]  headstem 35
mirp[rp0,rnd,grey]  headdia 21
mirp[min,rnd,grey]  headstem 41
f_deltap    21 14-1 21 15-1 21 16-1   15 14+1 15 15+1 15 16+1
IUP[y]
""",

    #mo_ma
    "uni0E21": """
f_deltap    56 15-8
srp0    55
mirp[rp0,rnd,white]  gap_84 20
f_deltap    20 9-8 20 10-8   20 12-8 20 13-8 
alignrp 9
mirp[min,rnd,grey]  headstem 40
shp[rp2]    52
mirp[rnd,grey]  headstem_plus_hole 34
shp[rp2]    46
mirp[rp0,rnd,grey]  headdia_plus 25
shp[rp2]    3
mirp[min,rnd,grey]  hstem 14
#
srp0    56
mirp[rp0,rnd,white]  gap_164 30
mirp[min,rnd,grey]  hstem 28
shp[rp2]    1
f_deltap    20 12+4 20 13+4 20 14+1 20 15+1 20 16+1    9 12+4 9 13+4 9 14+1 9 15+1 9 16+1
IUP[x]
SVTCA[y-axis]
mdap[rnd]   1
mirp[min,rnd,grey]  vstem 28
mirp[rnd,grey]  vheight_lo 6
mirp[rnd,grey]  vheight 30
mirp[rp0,rnd,grey]  vheight_shoot 23
mirp[min,rnd,grey]  headstem 37
mirp[rp0,rnd,grey]  headdia 17
f_deltap    17 13-4
mirp[min,rnd,grey]  headstem 31
srp0    6
mdrp[min,rnd,grey]  43
mdrp[rp0,rnd,grey]  12
mdrp[min,rnd,grey]  49
mdrp[rp0,rnd,grey]  26
mdrp[min,rnd,grey]  3
f_deltap    23 14-1 23 15-1 23 16-1   17 14+1 17 15+1 17 16+1    12 14-1 12 15-1 12 16-1   6 14+1 6 15+1 6 16+1
IUP[y]
""",

    #yo_yak
    "uni0E22": """
f_deltap    47 9+8   47 15-8   47 16-8  47 21-8   
srp0    46
mirp[rp0,rnd,grey]  gap_186 1
mirp[min,rnd,grey]  hstem 29
ip  21
mdrp[grey]  4
mdrp[rp0,min,rnd,grey]  13
mdrp[grey]  25
mirp[min,rnd,grey]  headstem 37
mirp[rp0,rnd,grey]  headdia 19
mirp[min,rnd,grey]  headstem 43
srp0    1
mdrp[rp0,grey]  7
#
srp0    47
mirp[rp0,rnd,grey]  gap_164 33
mirp[min,rnd,grey]  hstem 31
f_deltap    13 14-1 13 15-1 13 16-1   19 14+1 19 15+1 19 16+1    
IUP[x]
SVTCA[y-axis]
mdap[rnd] 0
mirp[min,rnd,grey]  vstem 31
mirp[rnd,grey]      vheight 33
mirp[rp0,rnd,grey]  vheight_shoot 10
mdrp[rnd,grey]  19
f_deltap    19 14+5 22 14-5   19 15+8 22 15-8   19 16+7 22 16-4
mirp[min,rnd,grey]  headstem 40
mirp[rp0,rnd,grey]  headdia 16
mirp[min,rnd,grey]  headstem 34
srp2    30
ip      4
srp0    25
mdap[rnd]   25
f_deltap    25 12+8
mdrp[grey]  4
mdrp[min,rnd,grey]  26
f_deltap    26 15+1   26 16+1
f_deltap   10 14-1 10 15-1 10 16-1   16 14+1 16 15+1 16 16+1
IUP[y]
""",

    #ro_ruar
    "uni0E23": """
srp0    52
mirp[rp0,white]  gap_113 12
mirp[min,rnd,grey]  vstem   34
#
srp0    53
mirp[rp0,rnd,white]  gap_240 37
mirp[min,rnd,grey]  hstem 8
mdrp[grey]  24
mirp[rp0,rnd,grey]  headdia_plus 3
mirp[min,rnd,grey]  headstem 49
mirp[rnd,grey]  headstem_plus_hole 43
f_deltap    3 12+4 3 13+4 3 14+1 3 15+1 3 16+1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   52
mirp[rnd,grey]  vheight_lo  0
mirp[rp0,rnd,grey]  vheight_shoot 16
mirp[min,rnd,grey]  vstem_curve 31
f_deltap    31 18+4 31 19+4 31 20+4 31 21+4 31 22+4 31 23+4 31 24+4 31 25+4    31 29+4 31 30+4 31 31+4 31 32+4 31 33+4 31 34+4 31 35+4
srp0    0
mirp[min,rnd,grey]  headstem 40
mirp[rp0,rnd,grey]  headdia 6
mirp[min,rnd,grey]  headstem 46
srp1 31
srp2 6
sloop 7
ip 13 34 12 35 9 11 37
f_deltap    6 14-1 6 15-1 6 16-1   0 14+1 0 15+1 0 16+1
IUP[y]
""",

    #lo_lu
    "uni0E24": """
f_deltap    48 10+8   48 14-8   48 20-8   48 26+8
srp0                47
mirp[rp0,rnd,grey]  gap_197 23
mirp[min,rnd,grey]  hstem  12
mdrp[rp0,grey]  27
mdrp[min,rnd,grey]  8
srp0            12
mdrp[rp0,grey]  10
mdrp[min,rnd,grey]  26
srp0    23
mirp[rp0,rnd,grey]  headdia_plus 18
f_deltap    18 12-4
mirp[min,rnd,grey]  headstem 38
mirp[rnd,grey]  headstem_plus_hole 44
#
srp0    48
mirp[rp0,rnd,grey]  gap_164 34
mirp[min,rnd,grey]  hstem  1
f_deltap    18 12-4 18 13-4 18 14-1 18 15-1 18 16-1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]           47
mirp[rnd,grey]      vheight_lu  1
mirp[rnd,grey]      vheight_lo  21
mirp[rp0,rnd,grey]  vheight_shoot    31
mirp[min,rnd,grey]  vstem_curve  5
f_deltap    5 18+4 5 19+4 5 20+4 5 21+4 5 22+4 5 23+4 5 24+4 5 25+4    5 29+4 5 30+4 5 31+4 5 32+4 5 33+4 5 34+4 5 35+4
srp1                1
sloop               10
ip      24 26 27 28 8 9 10 12 2 34
srp0    21
mirp[min,rnd,grey]  headstem 35
mirp[rp0,rnd,grey]  headdia 15
mirp[min,rnd,grey]  headstem 41
f_deltap    15 14-1 15 15-1 15 16-1   21 14+1 21 15+1 21 16+1
IUP[y]
""",

    #lo_ling
    "uni0E25": """
f_deltap    52 9+8   52 11+8   52 18-8   52 20-8   52 30-8   52 33+8   
srp0    51
mirp[rp0,rnd,white] gap_127 17
mdrp[grey]  33
mirp[min,rnd,grey]  hstem 6
mirp[rp0,rnd,grey]  headdia_plus 12
mirp[min,rnd,grey]  headstem 42
mirp[rnd,grey]  headstem_plus_hole 48
#
srp0    52
mirp[rp0,rnd,grey]  gap_164 38
mirp[min,rnd,grey]  hstem 24
shp[rp2]    1
f_deltap    12 12-4 12 13-4 12 14-1 12 15-1 12 16-1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  1
mirp[rnd,grey]  vheight_lo 15
mdrp[min,rnd,grey]  24
mirp[rp0,rnd,grey]  vheight_shoot 35
mirp[min,rnd,grey]  vstem_curve 28
f_deltap    28 18+4 28 19+4 28 20+4 28 21+4 28 22+4 28 23+4 28 24+4 28 25+4    28 29+4 28 30+4 28 31+4 28 32+4 28 33+4 28 34+4 28 35+4
mdrp[rp0,rnd,grey]  21
mirp[min,rnd,grey]  vstem  4
f_deltap    4 20+4 4 21+4 4 22+4 4 23+4 4 24+4 4 25+4    4 29+4 4 30+4 4 31+4 4 32+4 4 33+4 4 34+4 4 35+4
srp0    15
mirp[min,rnd,grey]  headstem 39
mirp[rp0,rnd,grey]  headdia 9
mirp[min,rnd,grey]  headstem 45
srp1    28
srp2    0
sloop   4
ip  18 6 25 38
f_deltap    9 14-1 9 15-1 9 16-1   15 14+1 15 15+1 15 16+1
IUP[y]
""",

    #ro_ru
    "uni0E26": """
f_deltap    48 13-8   48 16-8
srp0    47
mirp[rp0,rnd,white]  gap_84 18
f_deltap    18 9-8   18 12-8   18 13-8
mirp[min,rnd,grey]  headstem 44
mirp[rnd,grey]  headstem_plus_hole 38
mirp[rp0,rnd,grey]  headdia_plus 12
mirp[rp0,min,rnd,grey]  hstem 23
mdrp[rp0,grey]  27
mdrp[min,rnd,grey]  8
srp0    12
mdrp[rp0,grey]  10
mdrp[min,rnd,grey]  26
#
srp0    48
mirp[rp0,rnd,white]  gap_164 34
mirp[min,rnd,grey]  hstem   1
f_deltap    18 12+4 18 13+4 18 14+1 18 15+1 18 16+1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  47
mirp[rnd,grey]  vheight_lu  1
mirp[rnd,grey]  vheight_lo 15
mirp[rp0,rnd,grey]  vheight_shoot 31
sloop   10
ip  28 8 27 9 26 10 2 34 24 12
mirp[min,rnd,grey]  vstem_curve   5
f_deltap    5 18+4 5 19+4 5 20+4 5 21+4 5 22+4 5 23+4 5 24+4 5 25+4    5 29+4 5 30+4 5 31+4 5 32+4 5 33+4 5 34+4 5 35+4
srp0    15
mirp[min,rnd,grey]  headstem 35
mirp[rp0,rnd,grey]  headdia 21
mirp[min,rnd,grey]  headstem 41
f_deltap    21 14-1 21 15-1 21 16-1   15 14+1 15 15+1 15 16+1
IUP[y]
""",

    #wo_wan
    "uni0E27": """
srp0    38
mirp[rp0,rnd,white]  gap_164 22
mdrp[grey]  15
mirp[min,rnd,grey]  hstem 8
mirp[rp0,rnd,grey]  headdia_plus 3
mirp[min,rnd,grey]  headstem 34
mirp[rnd,grey]  headstem_plus_hole 28
f_deltap    3 12+4 3 13+4 3 14+1 3 15+1 3 16+1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]    37
mirp[rnd,grey]  vheight_lo 0
mirp[rp0,rnd,grey]  vheight_shoot 19
ip  16
ip  15
mirp[min,rnd,grey]  vstem_curve   12
f_deltap    12 18+4 12 19+4 12 20+4 12 21+4 12 22+4 12 23+4 12 24+4 12 25+4    12 29+4 12 30+4 12 31+4 12 32+4 12 33+4 12 34+4 12 35+4
srp1    37
ip  9
ip  22
srp0    0
mirp[min,rnd,grey]  headstem 25
mirp[rp0,rnd,grey]  headdia 6
mirp[min,rnd,grey]  headstem 31
f_deltap    6 14-1 6 15-1 6 16-1   0 14+1 0 15+1 0 16+1
IUP[y]
""",

    #so_sala
    "uni0E28": """
f_deltap    64 10+8   64 12+8   64 23+8   64 32+8   64 36+8   
srp0                63
mirp[rp0,rnd,grey]  gap_102 38
mirp[min,rnd,grey]  hstem 14
mdrp[rp0,rnd,grey]  26
f_deltap    26 11-8   26 13-8   26 16-8   
mirp[min,rnd,grey]  headstem 54
mdrp[rp0,grey]  20
mdrp[min,rnd,grey]  60
mdap[rnd]   60
f_deltap    60 18+8   60 29+8   60 34+8
srp1    14
ip  31
ip  34
mdap[rnd]   34
mirp[min,rnd,grey]  hstem 35
srp2    14
ip  17
#
srp0    64
mirp[rp0,rnd,grey]  gap_164 50
f_deltap    50 34+8   50 36+8   
mirp[min,rnd,grey]  hstem 1
srp2    38
sloop   6
ip  6 7 43 45 46 48
f_deltap    26 12-4 26 13-4 26 14-1 26 15-1 26 16-1
srp1    6
srp2    1
ip      4
ip      9
mdap[rnd]   9
f_deltap    9 14+3 48 14-3   9 15+3 48 15-3   9 16+3 48 16-3
IUP[x]
#
SVTCA[y-axis]
MDAP[rnd]           0
ALIGNRP             34
MIRP[rp0,rnd,grey]  vheight_shoot  41
mdrp[min,rnd,grey]  45
MIRP[min,rnd,grey]  vstem_curve  11
f_deltap    11 18+4 11 19+4 11 20+4 11 21+4 11 22+4 11 23+4 11 24+4 11 25+4   11 29+4   11 30+4   11 31+4   11 32+4   11 33+4   11 34+4   11 35+4   
ip  43
ip  46
mdrp[grey]      9
MDRP[rp0,rnd,grey]  23
ip  7
srp1    34
ip  17
MIRP[min,rnd,grey]  headstem  57
MIRP[rp0,rnd,grey]  headdia  29    
f_deltap    29 24+8   29 25+8   29 26+8   
MIRP[min,rnd,grey]  headstem  51
f_deltap    17 14-8   17 15-8   17 16-8
f_deltap    23 14-1 23 15-1 23 16-1   29 14+1 29 15+1 29 16+1
mdap[rnd]   4
f_deltap    4 14+2 43 14-2   4 15+2 43 15-2   4 16+2 43 16-2  
IUP[y]
""",

    #so_lusi
    "uni0E29": """
f_deltap    65 18+8   65 27+8   65 30+8   65 36+8   65 37+8   65 45+8
srp0    64
mirp[rp0,rnd,grey]  gap_315 1
f_deltap    1 11-8   1 16+8   1 17-8   
mirp[min,rnd,grey]  hstem 12
mdrp[rp0,rnd,grey]  7
mirp[min,rnd,grey]  headstem 49
mirp[rnd,grey]  headstem_plus_hole 43
#
srp0    65
mirp[rp0,rnd,grey]  gap_205 33
alignrp 39
mdrp[grey]  37
mirp[min,rnd,grey]  hstem 31
shp[rp2]    14
srp1    12
ip  20
mdap[rnd]   20
mirp[min,rnd,grey]  headstem_tiny 61
mirp[rp0,rnd,grey]  headdia_tiny 26
mirp[min,rnd,grey]  headstem_tiny 55
f_deltap    7 12+4 7 13+4 7 14+1 7 15+1 7 16+1    26 14-1 26 15-1 26 16-1   20 14+1 20 15+1 20 16+1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  0
mirp[min,rnd,grey]  vstem 14
mirp[rnd,grey]  vheight 33
mirp[rp0,rnd,grey]  vheight_shoot 10
ip  23
mirp[min,rnd,grey]  headstem 46
mirp[rp0,rnd,grey]  headdia 4
mirp[min,rnd,grey]  headstem 40
mdap[rnd]   23
mirp[min,rnd,grey]  headstem_tiny 58
mdrp[rp0,rnd,grey]  17
sloop   7
ip  28 31 15 34 36 37 39
mdrp[min,rnd,grey]  52
f_deltap    10 14-1 10 15-1 10 16-1   4 14+1 4 15+1 4 16+1
IUP[y]
""",

    #so_sua
    "uni0E2A": """
f_deltap    64 9+8   64 15-8   64 16-8   64 17+8   64 19+8   64 20+8   64 29+8   64 30+8   64 33-8
srp0    63
mirp[rp0,rnd,white] gap_127 17
mdrp[grey]  37
mirp[min,rnd,grey]  hstem 6
mirp[rp0,rnd,grey]  headdia_plus 12
f_deltap    12 12-4
mirp[min,rnd,grey]  headstem 54
mirp[rnd,grey]  headstem_plus_hole 60
#
srp0    64
mirp[rp0,rnd,grey]  gap_186 50
mirp[min,rnd,grey]  hstem 24
shp[rp2]    1
srp2    18
sloop   6
ip  29 30 43 45 46 48
mdrp[grey]  27
mdrp[grey]  32
f_deltap    12 12-4 12 13-4 12 14-1 12 15-1 12 16-1
mdap[rnd]   32
f_deltap    48 16-4
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  1
mirp[rnd,grey]  vheight_lo 15
mdrp[grey]  24
f_deltap    24 13-4 24 16-4
mirp[rp0,rnd,grey]  vheight_shoot 41
mirp[rp0,min,rnd,grey]  vstem_curve 34
f_deltap    34 18+4 34 19+4 34 20+4 34 21+4 34 22+4 34 23+4 34 24+4 34 25+4    34 29+4 34 30+4 34 31+4 34 32+4 34 33+4 34 34+4 34 35+4
mdrp[grey]  32
mdrp[grey]  27
srp0    41
mdrp[rp0,rnd,grey]  21
sloop   6
ip  29 30 43 45 46 48
mirp[min,rnd,grey]  vstem  4
f_deltap    4 20+4 4 21+4 4 22+4 4 23+4 4 24+4 4 25+4    4 29+4 4 30+4 4 31+4 4 32+4 4 33+4 4 34+4 4 35+4
srp0    15
mirp[min,rnd,grey]  headstem 51
mirp[rp0,rnd,grey]  headdia 9
f_deltap    13 9+4
mirp[min,rnd,grey]  headstem 57
srp1    28
srp2    0
sloop   4
ip  18 6 25 50
f_deltap    9 14-1 9 15-1 9 16-1   15 14+1 15 15+1 15 16+1
mdap[rnd]   27
IUP[y]
""",

    #ho_hib
    "uni0E2B": """
f_deltap    65 20-8  65 23-8  65 26-8
srp0    64
mirp[rp0,rnd,white]  gap_84 15
f_deltap    15 9-8   15 12-8   15 13-8
mirp[min,rnd,grey]  headstem 49
mirp[rnd,grey]  headstem_plus_hole 43
mirp[rp0,rnd,grey]  headdia_plus 20
alignrp     8
mirp[min,rnd,grey]  hstem 9
#
srp0    65
mirp[rp0,rnd,grey]  gap_164 39
f_deltap    39 23+8   39 26+8   39 32+8   39 36+8
alignrp     34
mirp[min,rnd,grey]  hstem 1
srp1   20
ip   23
ip   6
srp0    34
mdrp[grey]  37
mirp[min,rnd,grey]  headstem 55
mirp[rp0,rnd,grey]  headdia 28
mirp[min,rnd,grey]  headstem 61
mdrp[grey]  25
f_deltap    15 12+4 15 13+4 15 14+1 15 15+1 15 16+1    28 14+1 28 15+1 28 16+1    34 14-1 34 15-1 34 16-1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]  8
alignrp 1
mdrp[min,rnd,grey]  21
mirp[rp0,rnd,grey]  vheight_shoot 18
alignrp 31
mirp[min,rnd,grey]  headstem 46
shp[rp2]    58
mirp[rp0,rnd,grey]  headdia 12
f_deltap    12 13-4
mirp[min,rnd,grey]  headstem 40
shp[rp2]    52
srp0    52
mdrp[grey]  4
ip  25
ip  37
f_deltap    18 14-1 18 15-1 18 16-1   12 14+1 12 15+1 12 16+1   31 14-1 31 15-1 31 16-1
f_deltap    21 14-2 21 15-2 21 16-4
IUP[y]
""",

    #lo_jula
    "uni0E2C": """
f_deltap    62 10+8   62 12-8   62 17+8   62 23+8   62 33-8   62 37+8
srp0    61
mirp[rp0,rnd,white] gap_84 10
f_deltap    10 9-8   10 12-8   10 13-8
mirp[min,rnd,grey]  headstem 46
mirp[rnd,grey]  headstem_plus_hole 40
mirp[rp0,rnd,grey]  headdia_plus 15
mirp[min,rnd,grey]  hstem 4
#
srp0    62
mirp[rp0,rnd,grey]  gap_205 36
alignrp 30
mdrp[grey]  34
mirp[min,rnd,grey]  hstem   19
srp1    15
sloop   5
ip      1 2 3 17 18
srp0    30
mirp[min,rnd,grey]  headstem 52
mirp[rp0,rnd,grey]  headdia 24
mirp[min,rnd,grey]  headstem 58
f_deltap    10 12+4 10 13+4 10 14+1 10 15+1 10 16+1    30 14-1 30 15-1 30 16-1   24 14+1 24 15+1 24 16+1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   1
alignrp     3
mirp[rp0,rnd,grey]  vheight_shoot 13
ip  17
ip  2
mdrp[min,rnd,grey]  27
mirp[min,rnd,grey]  headstem 43
mirp[rp0,rnd,grey]  headdia 7
mirp[min,rnd,grey]  headstem 37
srp0    27
mirp[min,rnd,grey]  headstem 55
mirp[rp0,rnd,grey]  headdia 21
sloop   4
ip  31 33 34 36
mirp[min,rnd,grey]  headstem 49
srp1    17
srp2    0
ip  16
ip  19
f_deltap    13 14-1 13 15-1 13 16-1   7 14+1 7 15+1 7 16+1    27 14-1 27 15-1 27 16-1   21 14+1 21 15+1 21 16+1
IUP[y]
""",

    #aw_ang
    "uni0E2D": """
f_deltap    42 9+8   42 11+8   42 16-8   42 19-8   42 21-8   
srp0    41
mirp[rp0,rnd,white] gap_127 1
mdrp[grey]  21
mirp[min,rnd,grey]  hstem 12
mirp[rp0,rnd,grey]  headdia_plus 7
mirp[min,rnd,grey]  headstem   32
mirp[rnd,grey]  headstem_plus_hole 38
#
srp0    42
mirp[rp0,rnd,white]  gap_164 28
mirp[min,rnd,grey]  hstem 14
f_deltap     7 12-4  7 13-4 7 14-1 7 15-1 7 16-1
IUP[x]
#
SVTCA[y-axis]
MDAP[rnd]   0
mirp[min,rnd,grey]  vstem   14
mirp[rp0,rnd,grey]  vheight_shoot  25
mirp[min,rnd,grey]  vstem_curve   18
f_deltap    18 18+4 18 19+4 18 20+4 18 21+4 18 22+4 18 23+4 18 24+4 18 25+4    18 29+4 18 30+4 18 31+4 18 32+4 18 33+4 18 34+4 18 35+4
mdrp[rp0,rnd,grey]  4
mirp[min,rnd,grey]  headstem    35
mirp[rp0,rnd,grey]  headdia 10
f_deltap    10 13-4
mirp[min,rnd,grey]  headstem    29
srp1    18
srp2    13
sloop   5
ip  22 21 2 15 28
f_deltap    4 14-1 4 15-1 4 16-1   10 14+1 10 15+1 10 16+1
IUP[y]
""",

    #ho_nokhuk
    "uni0E2E": """
f_deltap    56 9+8   56 16-8   56 17-8  56 19-8   56 21-8   
srp0    55
mirp[rp0,rnd,white]  gap_127 1
mdrp[grey]  22
mirp[rp0,min,rnd,grey]  hstem   12
mdrp[grey]  52
srp0    1
mirp[rp0,rnd,grey]  headdia_plus 7
mirp[min,rnd,grey]  headstem   36
mirp[rnd,grey]  headstem_plus_hole 42
#
srp0    56
mirp[rp0,rnd,white]  gap_164 32
mirp[min,rnd,grey]  hstem 14
srp2    22
sloop 5
ip 47 27 30 28 29
f_deltap     7 12-4  7 13-4 7 14-1 7 15-1 7 16-1
f_deltap    47 12+4 30 12-4   47 13+4 30 13-2  47 14+4 30 14-2   47 15+4 30 15-2   47 16+6
srp1    47
srp2    14
ip  17
IUP[x]
#
SVTCA[y-axis]
MDAP[rnd]   0
mirp[min,rnd,grey]  vstem   14
mirp[rp0,rnd,grey]  vheight_shoot 25
mirp[rnd,grey]  vstem  49
f_deltap    49 20+8 49 21+8 49 22+4 49 23+4 49 24+4 49 25+4    49 34+8 49 35+8
mdrp[rp0,rnd,white]  4
f_deltap    4 12-8   
sloop   8
ip  45 47 27 28 29 30 19 17
mirp[min,rnd,grey]  headstem    39
mirp[rp0,rnd,grey]  headdia 10
mirp[min,rnd,grey]  headstem    33
f_deltap    4 14-1 4 15-1 4 16-1   10 14+1 10 15+1 10 16+1
f_deltap    19 13+4   45 14-2    45 15-2   45 16-2   19 17+4
f_deltap    17 14+3   17 15+2   17 16+2
IUP[y]
""",

    #paiyal
    "uni0E2F": """
f_deltap    36 9+8   36 11+8   
srp0    35
mirp[rp0,rnd,white]  gap_113 8
mirp[min,rnd,grey]  headstem 32
mirp[rp0,rnd,grey]  headdia 14
mirp[min,rnd,grey]  headstem 26
#
srp0    36
mirp[rp0,rnd,white]  gap_186 22
mirp[min,rnd,grey]  hstem 1
shp[rp2]    21
f_deltap     14 14-1 14 15-1 14 16-1   8 14+1 8 15+1 8 16+1   
srp0    21
mdrp[grey]  19
mdrp[grey]  4
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   0
mirp[rp0,rnd,grey]  vheight_shoot 21
alignrp 11
mdrp[min,rnd,grey]  2
mdrp[grey]  20
srp0    11
mirp[min,rnd,grey]  headstem 29
mirp[rnd,grey]  headstem_plus_hole 23
mirp[rp0,rnd,grey]  headdia 17
mirp[grey]  vstem 5
f_deltap     11 14-1 11 15-1 11 16-1
IUP[y]
""",

    #sara_a
    "uni0E30": """
srp0    60
mirp[rp0,rnd,white]  gap_102 3
alignrp 21
mirp[min,rnd,grey]  headstem 45
shp[rp2]    57
mirp[rp0,rnd,grey]  headdia 9
alignrp 27
mirp[min,rnd,grey]  headstem 39
shp[rp2]    51
mdrp[rp0,grey]  11
alignrp 29
#
srp0    61
mdrp[rp0,rnd,white]  15
alignrp     33
mdrp[grey]  14
shp[rp2]    32
f_deltap    3 9+4 21 9+4   3 13-4 21 13-4 45 13-2 57 13-2    11 17-4 11 29-4    11 19-4 29 19-4   
f_deltap    3 14+1 3 15+1 3 16+1   9 14-1 9 15-1 9 16-1   21 14+1 21 15+1 21 16+1   27 14-1 27 15-1 27 16-1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   0
mdrp[rp0,rnd,grey]  11
mdrp[rp0,rnd,grey]  6
mdrp[grey]  14
mirp[min,rnd,grey]  headstem 42
mirp[rnd,grey]  headstem_plus_hole 36
srp0    14
mdrp[grey]  15
#
srp0    0
mirp[rp0,rnd,grey]  vheight 24
mdrp[grey]  32
mirp[min,rnd,grey]  headstem 54
mirp[rnd,grey]  headstem_plus_hole 48
mdrp[rp0,rnd,grey]  29
mdrp[min,rnd,grey]  18
srp0    32
mdrp[grey]  33
f_deltap    11 9-4 29 9-4   6 10-8 14 10-8 18 10+8 29 10+8   6 11-8 14 11-8 18 11+8 29 11+8   6 12-4 24 12-4   0 13+2 18 13+2   0 16+4 18 16+4    36 26-8 48 26-8
f_deltap    6 14-1 6 15-1 6 16-1  24 14-1 24 15-1 24 16-1
IUP[y]
""",

    #sara_maihanakat
    "uni0E31": """
mdap[rnd]   0
mdrp[rnd,grey]  15
mdrp[rnd,grey]  11
mdrp[rp0,rnd,grey]  3
mirp[min,rnd,grey]  headstem 27
mirp[rp0,rnd,grey]  headdia 9
mirp[min,rnd,grey]  headstem 21
IUP[x]
SVTCA[y-axis]
mdap[rnd]   30
mirp[rp0,min,rnd,grey]  vheight_sara1   0
mirp[rp0,min,rnd,grey]  vstem_small 11
mdrp[rp0,rnd,grey]  14
mirp[min,rnd,grey]  vstem_curve 15
srp0    0
mdrp[min,rnd,grey]  18
mdrp[rp0,rnd,grey]  6
mirp[min,rnd,grey]  headstem 24
IUP[y]
""",

    #sara_aa
    "uni0E32": """
srp0    16
mirp[grey]  gap_51 8
#
srp0    17
mirp[rp0,rnd,white]  gap_164 15
mirp[min,rnd,grey]  hstem 1
IUP[x]
#
SVTCA[y-axis]
MDAP[rnd]   1
mirp[rp0,rnd,grey]  vheight_shoot 12
mdrp[grey]  9
mirp[rp0,min,rnd,grey]  vstem_curve   5
f_deltap    5 18+4 5 19+4 5 20+4 5 21+4 5 22+4 5 23+4 5 24+4 5 25+4    5 29+4 5 30+4 5 31+4 5 32+4 5 33+4 5 34+4 5 35+4
mdrp[grey]  8
srp1    5
srp2    1
ip  2
ip  2
IUP[y]
""",

    #sara_am
    #uni0E33: use sara_aa with nikahit
    
    #sara_i
    "uni0E34": """
mdap[rnd]   0
mirp[grey]  w_102 14
mdrp[rp0,rnd,white]  4
mirp[grey]  w_102 20
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   2
f_deltap    2 12+8   2 13+8   2 14+8   2 16+8   
mdrp[rp0,rnd,grey]   17
ip  12
mdrp[rnd,grey]  8
f_deltap    17 12+2   17 13+2   17 14+2 12 14-2  17 15+2 12 15-2   17 16+2 12 16-2
IUP[y]
""",

    #sara_ii
    "uni0E35": """
mdap[rnd]   0
mirp[grey]  w_102 16
mirp[min,rnd,grey]  sarastem 12
mdrp[rp0,rnd,white]  4
mirp[grey]  w_102 22
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   2
f_deltap    2 12+8   2 13+8   2 14+8   2 16+8
mdrp[rp0,rnd,grey]   19
ip  14
mdrp[rp0,rnd,grey]  8
mdrp[min,rnd,grey]  12
f_deltap    19 12+2   19 13+2   19 14+2 12 14-2  19 15+2 12 15-2   19 16+2 12 16-2
IUP[y]
""",

    #sara_ue
    "uni0E36": """
mdap[rnd]   0
mirp[grey]  w_102 24
mdrp[rnd,grey]  16
mdrp[rp0,rnd,white]  4
mirp[grey]  w_102 30
srp0    16
mdrp[min,rnd,grey]  35
mdrp[rp0,rnd,grey]  10
mdrp[min,rnd,grey]  41
f_deltap    16 9+4   16 13+4 35 13+4    16 14+6 35 14+8 10 14+2   16 15+6 35 15+8 10 15+2    16 16+6 35 16+8 10 16+2
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   2
f_deltap    2 12+8   2 13+8   2 14+8   2 16+8
mdrp[rp0,rnd,grey]   27
ip  22
mdrp[rp0,rnd,grey]  8
mdrp[rp0,min,rnd,grey]  13
mdrp[min,rnd,grey]  38
mdrp[rnd,grey]  32
mdrp[grey]  19
f_deltap    27 12+2   27 13+2   27 14+2 22 14-2  27 15+2 22 15-2   27 16+2 22 16-2
f_deltap    13 13+4 38 13+4   12 14+8 19 14-6   12 15+6 19 15-6   12 16+6 19 16-6   13 17+2 13 18+2 13 19+2 13 20+2 13 21+2 13 22+2
f_deltap    12 14+4
IUP[y]
""",

    #sara_uee
    "uni0E37": """
mdap[rnd]   0
mirp[grey]  w_102 20
mirp[rp0,min,rnd,grey]  sarastem 16
mdrp[rp0,min,rnd,white] 13
mirp[min,rnd,grey]  sarastem 11
srp0    0
mdrp[rp0,rnd,white]  4
mirp[grey]  w_102 26
f_deltap 13 9-1 0 9-1  13 10-1 0 10-1  13 11-1 0 11-1  13 12-1 0 12-1  13 13-1 0 13-1  13 14-1 0 14-1  13 15-1 0 15-1  13 16-1 0 16-1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   2
f_deltap    2 12+8   2 13+8   2 14+8   2 16+8
mdrp[rp0,rnd,grey]   23
ip  18
mdrp[rp0,rnd,grey]  8
mdrp[rp0,min,rnd,grey]  11
f_deltap    23 12+2   23 13+2   23 14+2 18 14-2  23 15+2 18 15-2   23 16+2 18 16-2
alignrp 16
IUP[y]
""",

    #sara_u
    "uni0E38": """
mdap[rnd]   12
mirp[rp0,min,rnd,grey]  vstem_curve   1
mdrp[rp0,rnd,grey]  7
mirp[min,rnd,grey]  headstem_tiny 22
mdrp[min,rnd,grey]  16
f_deltap    12 9-1 12 10-1 12 11-1 12 12-1 12 13-1 12 14-1   12 15-1   12 16-1 7 16+4   
IUP[x]
SVTCA[y-axis]
mdap[rnd]   25
mirp[rp0,min,rnd,grey]  vstem_tiny 10
mirp[min,rnd,grey]  headstem_tiny 19
mdrp[rp0,rnd,grey]  4
mirp[min,rnd,grey]  headstem_tiny 13
mdrp[min,rnd,grey]  0
IUP[y]
""",

    #sara_uu
    "uni0E39": """
mdap[rnd]   16
mirp[rp0,min,rnd,grey]  vstem_curve 14
mdrp[rp0,rnd,white]  12
mirp[rp0,rnd,grey]  vstem_curve 1
mdrp[rp0,rnd,grey]  7
mirp[min,rnd,grey]  headstem_tiny 26
mdrp[rnd,grey]  20
f_deltap    14 9+1   14 10+1 1 10+1   14 11+1 1 11+1   14 12+1 1 12+1   14 13+1 1 13+1   14 14+1 1 14+1   14 15+1 1 15+1   14 16+1 1 16+1 7 16+4  
IUP[x]
SVTCA[y-axis]
mdap[rnd]   29
mirp[rp0,min,rnd,grey]  vstem_tiny 10
alignrp 16
mirp[min,rnd,grey]  headstem_tiny 23
mdrp[rp0,rnd,grey]  4
f_deltap    4 10+8   4 11+8
mirp[min,rnd,grey]  headstem_tiny 17
mdrp[rp0,min,rnd,grey]  1
mirp[min,rnd,grey]  headstem 13
f_deltap    1 9+1   1 10+1   1 11+1   1 12+1   1 13+1   1 14+1   1 15+1   1 16+1   
IUP[y]
""",

    #pinthu
    "uni0E3A": """
mdap[rnd]   9
mdrp[rp0,min,rnd,grey]  3
IUP[x]
SVTCA[y-axis]
mdap[rnd]   12
mirp[rp0,min,rnd,grey]  vstem_tiny 6
mdrp[rp0,min,rnd,grey]  0
IUP[y]
""",

    #thai_baht
    "uni0E3F": """
f_deltap    50 9+8   50 10+8   
srp0    49
mirp[rp0,rnd,white]  gap_197 3
mdrp[min,rnd,grey]  25
shp[rp2]    38
#
srp0    50
mirp[rp0,rnd,white]  gap_164 18
mdrp[min,rnd,grey]  31
mdrp[rp0,rnd,grey]  12
mdrp[min,rnd,grey]  44
srp1    25
ip  23
mdap[rnd]   23
alignrp 1
alignrp 36
alignrp 5
mdrp[rp0,min,rnd,grey]  35
alignrp 48
alignrp 7
alignrp 22
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   22
alignrp 3
mdrp[min,rnd,grey]  1
mdrp[min,rnd,grey]  27
shp[rp2]    26
mdrp[rp0,rnd,grey]  8
alignrp     4
mdrp[min,rnd,grey]  6
mdrp[min,rnd,grey]  48
shp[rp2]    38
srp2    27
ip      40
mdap[rnd]   40
alignrp 39
mdrp[min,rnd,grey]  35
shp[rp2]    25
ip  15
IUP[y]
""",

    #sara_e
    "uni0E40": """
#srp0    25
srp0    26
mirp[rp0,rnd,white] gap_102 10
mirp[min,rnd,grey]  headstem 16
mirp[rnd,grey]  headstem_plus_hole 22
mirp[rp0,rnd,grey]  headdia_plus 2
mirp[min,rnd,grey]  hstem 4
f_deltap    10 12-4 10 13-4 10 14-1 10 15-1 10 16-1
IUP[x]
#
SVTCA[y-axis]
MDAP[rnd]   25
mirp[min,rnd,grey]  vheight 4
mirp[rp0,rnd,grey]  vheight_lo 0
mirp[min,rnd,grey]  headstem 13
mirp[rp0,rnd,grey]  headdia 7
mirp[min,rnd,grey]  headstem 19
f_deltap    7 14-1 7 15-1 7 16-1   0 14+1 0 15+1 0 16+1
IUP[y]
""",

    #sara_ae
    #use sara_a reference: uni0E40

    #sara_o
    "uni0E42": """
#srp0    52
#mirp[rp0,white]  gap_51 6
#mdrp[min,rnd,grey]  28
#
srp0    53
mirp[rp0,rnd,white] gap_102 37
mirp[min,rnd,grey]  headstem 43
mirp[rnd,grey]  headstem_plus_hole 49
mirp[rp0,rnd,grey]  headdia_plus 2
mirp[min,rnd,grey]  hstem   31
mdrp[rnd,grey]  18
mdrp[rp0,rnd,grey]  6
mdrp[min,rnd,grey]  28
f_deltap    37 12-4 37 13-4 37 14-1 37 15-1 37 16-1
IUP[x]
#
SVTCA[y-axis]
mdap[rnd]   52
mirp[rnd,grey]  vheight_lo 0
mirp[rp0,rnd,grey]  vheight_o 10
mirp[min,rnd,grey]  vstem_curve 25
f_deltap    25 18+4 25 19+4 25 20+4 25 21+4 25 22+4 25 23+4 25 24+4 25 25+4    25 29+4 25 30+4 25 31+4 25 32+4 25 33+4 25 34+4 25 35+4
mdrp[rp0,rnd,grey]  6
mdrp[grey]  7
mdrp[grey]  28
srp0    0
mirp[min,rnd,grey]  headstem   40
mirp[rp0,rnd,grey]  headdia 34
mirp[min,rnd,grey]  headstem   46
f_deltap    34 14-1 34 15-1 34 16-1   0 14+1 0 15+1 0 16+1
IUP[y]
""",

    #sara_i_moun
    "uni0E43": """
#srp0    64
#mirp[rp0,rnd,white] gap_51 20
#
srp0    65
mirp[rp0,rnd,white] gap_102 37
mirp[min,rnd,grey]  headstem 43
mirp[rnd,grey]  headstem_plus_hole 49
mirp[rp0,rnd,grey]  headdia_plus 2
mirp[min,rnd,grey]  hstem 31
#
mdrp[rp0,rnd,grey]  14
mdrp[rnd,grey]  11
mirp[min,rnd,grey]  headstem 55
mdrp[rp0,rnd,grey]  61
mdrp[grey]  20
srp0    14
mdrp[rp0,rnd,white]  8
mirp[grey]  vstem_curve 26
f_deltap    37 12-4 37 13-4 37 14-1 37 15-1 37 16-1   26 9+4   20 12+6 20 15+1 20 16+1   14 15-1 14 16-1   10 16+8  26 16-3 
IUP[x]
#
SVTCA[y-axis]
MDAP[rnd]   64
mdrp[rnd,grey]  11
mirp[rp0,rnd,grey]  vheight_lo 0
mirp[min,rnd,grey]  headstem 40
mirp[rp0,rnd,grey]  headdia 34
mirp[min,rnd,grey]  headstem 46
srp0    11
mirp[grey]  headstem 23
mirp[min,rnd,grey]  headstem 56
mdrp[rp0,rnd,grey]  17
mirp[min,rnd,grey]  headstem 52
f_deltap    34 14-1 34 15-1 34 16-1   0 14+1 0 15+1 0 16+1
IUP[y]
""",

    #sara_i_mlai
    "uni0E44": """
srp0    37
mdrp[rp0,rnd,white] 9
#
srp0    38
mirp[rp0,rnd,white] gap_102 22
mirp[min,rnd,grey]  headstem 28
mirp[rnd,grey]  headstem_plus_hole 34
mirp[rp0,rnd,grey]  headdia_plus 2
alignrp 15
mirp[min,rnd,grey]  hstem 16
srp2    9
sloop 4
ip 10 6 13 5
f_deltap    22 12-4 22 13-4 22 14-1 22 15-1 22 16-1
IUP[x]
#
SVTCA[y-axis]
MDAP[rnd]   37
mirp[rnd,grey]  vheight_o 16
mirp[rp0,rnd,grey]  vheight_lo 0
mirp[min,rnd,grey]  headstem 25
mirp[rp0,rnd,grey]  headdia 19
mirp[min,rnd,grey]  headstem 31
srp0    16
mirp[min,rnd,grey]  vstem_curve 3
srp2    37
sloop   4
ip  10 9 13 5
f_deltap    19 14-1 19 15-1 19 16-1   0 14+1 0 15+1 0 16+1
IUP[y]
""",

    #lakkhangyao
    "uni0E45": """
#srp0    16
#mirp[grey]  gap_51 8
#
srp0    17
mirp[rp0,rnd,white]  gap_315 15
mirp[min,rnd,grey]  hstem 1
IUP[x]
#
SVTCA[y-axis]
MDAP[rnd]   16
mirp[rnd,grey]  vheight_lu 1
mirp[rp0,rnd,grey]  vheight_shoot 12
mdrp[grey]  9
mirp[rp0,min,rnd,grey]  vstem_curve   5
f_deltap    5 18+4 5 19+4 5 20+4 5 21+4 5 22+4 5 23+4 5 24+4 5 25+4    5 29+4 5 30+4 5 31+4 5 32+4 5 33+4 5 34+4 5 35+4
mdrp[grey]  8
srp1    5
srp2    1
ip  2
ip  2
IUP[y]
""",

    #maiyamok
    "uni0E46": """
f_deltap    39 9+8   39 10+8   39 11+8   
srp0    38
mirp[rp0,rnd,white]  gap_113 19
mdrp[min,rnd,grey]  8
mdrp[min,rnd,grey]  35
mdrp[rp0,rnd,grey]  13
mirp[min,rnd,grey]  headstem    29
#
srp0    39
mirp[rp0,rnd,white]  gap_186 25
mirp[min,rnd,grey]  hstem 1
srp1    8
sloop   6
ip  21 6 22 5 23 4
f_deltap    13 14-1 13 15-1 13 16-1   19 14+1 19 15+1 19 16+1
IUP[x]
#
SVTCA[y-axis]
MDAP[rnd]   38
mirp[rnd,grey]  vheight_lu 1
mirp[rp0,rnd,grey]  vheight_shoot 21
alignrp 23
ip 2
ip 25
mirp[min,rnd,grey]  vstem_curve   6
shp[rp2]    4
mdrp[rp0,rnd,grey]  22
mirp[min,rnd,grey]  vstem   5
mdrp[rp0,rnd,white]  10
mirp[min,rnd,grey]  headstem    32
mirp[rp0,rnd,grey]  headdia 16
mirp[min,rnd,grey]  headstem    26
f_deltap    10 14-1 10 15-1 10 16-1   16 14+1 16 15+1 16 16+1
IUP[y]
""",

    #maitaikhu
    "uni0E47": """
mdap[rnd]  44
mdrp[rnd,grey]  19
mirp[min,rnd,grey]  headstem_wan 50
mdrp[rp0,rnd,grey]  38
mirp[min,rnd,grey]  headstem_wan 56
#
mdap[rnd]   11
mirp[min,rnd,grey]  sarastem 26
srp1    38
ip  28
ip  5
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
f_deltap    0 9+8   0 12+8   0 14+8   
alignrp     8
mdrp[min,rnd,grey]  36
mdrp[min,rnd,grey]  47
mdrp[rp0,rnd,grey]  41
mirp[min,rnd,grey]  headstem_wan 53
srp0    8
mdrp[min,rnd,grey]  28
mdrp[rp0,rnd,grey]  5
mirp[min,rnd,grey]  vstem_tiny 31
mdrp[rp0,rnd,grey]  23
mirp[rp0,rnd,grey]  vstem_tiny 14
mdrp[rp0,rnd,grey]  18
mdrp[grey]  19
f_deltap    31 11-4   23 12+2 31 12-4 41 12-4   23 13+2 31 13-4  23 14+2 31 14-4   23 15+2   23 16+2   23 17+2  23 18+2 
IUP[y]
""",

    #maiek
    "uni0E48": """
MDAP[rnd]   0
mdrp[min,rnd,grey]  2
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
f_deltap    0 9+8   0 12+8   0 14+8   0 15+8   0 16+8
f_deltap    0 9+8   0 12+8   0 14+8   0 15+8   0 16+8
mdrp[min,rnd,grey]  2
IUP[y]
""",

    #maiek
    "uni0E48.low": """
MDAP[rnd]   0
mirp[min,rnd,grey]  vstem_curve 2
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
f_deltap    0 9+8   0 12+8   0 14+8   0 15+8   0 16+8
mirp[min,rnd,grey]  headdia_tiny 2
IUP[y]
""",

    #maitho
    "uni0E49": """
MDAP[rnd]   22
mdrp[rp0,rnd,grey]  8
mdrp[min,rnd,grey]  14
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
f_deltap    0 9+8   0 12+8   0 14+8   0 15+8   0 16+8
f_deltap    0 9+8   0 12+8   0 14+8   0 15+8   0 16+8
mdrp[min,rnd,grey]  17
shp[rp2]    2
mdrp[rp0,rnd,grey]  11
mdrp[rp0,rnd,grey]  21
mdrp[grey]  22
IUP[y]
""",

    #maitho
    "uni0E49.low": """
MDAP[rnd]   22
mdrp[rp0,rnd,grey]  8
alignrp     1
mirp[min,rnd,grey]  headstem_wan 34
mdrp[rp0,rnd,grey]  14
f_deltap    14 9+4 14 10+4 14 11+4  14 15+4  14 16+2  14 17+4 14 18+4 
mdrp[min,rnd,grey]  5
mirp[min,rnd,grey]  headstem_wan 27
f_deltap 14 12-1 7 12+1   14 13-1 7 13+1   14 14-1 7 14+1   28 15+2 34 15-2   28 16+2 34 16-2
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
f_deltap    0 9+8   0 12+8   0 14+8   0 15+8   0 16+8
mirp[min,rnd,grey]  vstem_tiny 17
shp[rp2]    2
shp[rp2]    18
mdrp[rp0,rnd,grey]  5
mirp[min,rnd,grey]  headstem_wan 25
mdrp[rp0,rnd,grey]  11
f_deltap    11 12+4  11 17+4 
mirp[min,rnd,grey]  headstem_wan 31
srp0    0
mdrp[rp0,rnd,grey]  21
f_deltap    0 9+1 0 10+1 0 11+1   0 12+1 18 12-2    0 13+1 18 13-2 5 13+3   0 14+1 18 14-2 5 14+3    0 15+1 18 15-2 25 15-2 31 15+2   0 16+1 18 16-2 25 16-2 31 16+2
IUP[y]
""",

    #maitri
    "uni0E4A": """
mdap[rnd]   35
mdrp[rp0,rnd,grey]  30
mdrp[rp0,rnd,grey]  22
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
f_deltap    0 9+8   0 12+8   0 14+8   0 15+8   0 16+8
f_deltap    0 9+8   0 12+8   0 14+8   0 15+8   0 16+8
alignrp 20
mdrp[rp0,rnd,grey]  26
alignrp 28
mdrp[min,rnd,grey]  35
IUP[y]
""",

    #maitri
    "uni0E4A.low": """
mdap[rnd]   36
mdrp[grey]  35
mdrp[rp0,rnd,grey]  31
mdrp[grey]  5
mdrp[rp0,rnd,grey]  23
mdrp[grey]  11
srp1    5
sloop   7
ip  26 9 27 8 28 7 17
mdap[rnd]   17
mdrp[min,rnd,grey]  41
mdrp[rnd,grey]  47
f_deltap    17 16-4 36 16-1
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
f_deltap    0 9+8   0 12+8   0 14+8   0 15+8   0 16+8
alignrp     20
mdrp[grey]  33
mdrp[min,rnd,grey]  2
mdrp[rp0,rnd,grey]  26
alignrp 28
mdrp[min,rnd,grey]  35
mdrp[min,rnd,grey]  27
mdrp[rp0,min,rnd,grey]  9
shp[rp2]    7
mdrp[grey]  8
srp0    20
mdrp[min,rnd,grey]  38
mdrp[rp0,rnd,grey]  14
mdrp[min,rnd,grey]  44
f_deltap    14 13-6    14 14-4   14 15-4    14 16-4  
IUP[y]
""",

    #maichattawa
    "uni0E4B": """
mdap[rnd]   0
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   11
f_deltap    11 9+8   11 12+8   11 14+8   11 15+8   11 16+8
f_deltap    11 9+8   11 12+8   11 14+8   11 15+8   11 16+8
IUP[y]
""",

    #maichattawa
    "uni0E4B.low": """
mdap[rnd]   0
alignrp 8
mdrp[grey]  10
mirp[rp0,rnd,grey]  vstem 2
alignrp 6
mdrp[grey]  4
IUP[x]
SVTCA[y-axis]
mdap[rnd]   11
f_deltap    11 9+8   11 12+8   11 14+8   11 15+8   11 16+8
alignrp 3
mdrp[grey]  0
mirp[rp0,rnd,grey]  vstem 8
alignrp 4
mdrp[grey]  7
IUP[y]
""",

    #thanthakhat
    "uni0E4C": """
mdap[rnd]   3
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
f_deltap    0 9+8   0 12+8   0 14+8   0 15+8   0 16+8
f_deltap    0 9+8   0 12+8   0 14+8   0 15+8   0 16+8
mdrp[rp0,rnd,grey]  6
IUP[y]
""",

    #thanthakhat
    "uni0E4C.low": """
mdap[rnd]   11
mdrp[grey]  10
mdrp[rp0,rnd,grey]  3
mirp[min,rnd,grey]  headstem_tiny 29
mdrp[rp0,rnd,grey]  17
f_deltap    17 16+6
mirp[min,rnd,grey]  headstem_tiny 23
f_deltap    3 11-2  3 12-4  3 13+1  3 15-2  
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
f_deltap    0 9+8   0 12+8   0 14+8   0 15+8   0 16+8
mirp[min,rnd,grey]  headstem_tiny 20
mdrp[rp0,rnd,grey]  6
mirp[min,rnd,grey]  sarastem 26
shp[rp2]    15
mdrp[rp0,min,rnd,grey]  10
mdrp[grey]  11
f_deltap    6 9-1 6 10-1 6 11-1 6 12-1 6 13-1 6 14-1 6 15-1 6 16-2
IUP[y]
""",

    #nikhahit
    "uni0E4D": """
MDAP[rnd]   9
mirp[min,rnd,grey]  headstem 15
mirp[rp0,rnd,grey]  headdia 3
mirp[min,rnd,grey]  headstem 21
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
f_deltap    0 9+8   0 12+8   0 14+8
mirp[min,rnd,grey]  headstem 12
mirp[rp0,rnd,grey]  headdia 6
mirp[min,rnd,grey]  headstem 18
IUP[y]
""",

    #nikhahit
    "uni0E4D.high": """
MDAP[rnd]   9
mdrp[min,rnd,grey]  15
mdrp[rp0,rnd,grey]  3
mdrp[min,rnd,grey]  21
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
f_deltap    0 9+8   0 12+8   0 14+8
f_deltap    0 9+8   0 12+8   0 14+8
mdrp[min,rnd,grey]  12
mdrp[rp0,rnd,grey]  6
mdrp[min,rnd,grey]  18
IUP[y]
""",

    #yamakkan
    "uni0E4E": """
SRP0    0
mdrp[rp0,rnd,grey]  4
mirp[min,rnd,grey]  sarastem 27
mdrp[rp0,rnd,grey]  10
mirp[min,rnd,grey]  sarastem 20
srp0    0
mdrp[rnd,grey]  16
mdrp[grey]  24
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
f_deltap    0 9+8   0 12+8   0 14+8
mirp[min,rnd,grey]  headstem    29
mdrp[rp0,rnd,grey]  23
mirp[min,rnd,grey]  headstem    25
ip  7
mdrp[rp0,rnd,grey]  13
mirp[min,rnd,grey]  headstem    18
#mdrp[rp0,rnd,grey]  15
#mirp[min,rnd,grey]  headstem    16
IUP[y]
""",

    #fongman
    "uni0E4F": """
SRP0    56
mirp[rp0,min,rnd,grey]  gap_102 5
mdrp[min,rnd,grey]  29
mdrp[rp0,rnd,grey]  35
mdrp[min,rnd,grey]  53
mdrp[rp0,rnd,grey]  41
mdrp[min,rnd,grey]  47
mdrp[rp0,rnd,grey]  15
mdrp[min,rnd,grey]  23
mdrp[rnd,white]  57
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   56
mirp[rp0,rnd,grey]  vheight_lo 0
mdrp[min,rnd,grey]  20
mdrp[rp0,rnd,grey]  32
mdrp[min,rnd,grey]  44
mdrp[rp0,rnd,grey]  38
mdrp[min,rnd,grey]  50
mdrp[rp0,rnd,grey]  10
mdrp[min,rnd,grey]  26
IUP[y]
""",

    #thaidigit_zero
    "uni0E50": """
SRP0    24
mirp[rp0,min,rnd,grey]  headhole    3
mirp[min,rnd,grey]  hstem   21
mirp[rp0,rnd,grey]  w_956    9
mirp[min,rnd,grey]  hstem   15
mdrp[rnd,white]  25
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   24
mirp[rnd,grey]  vheight_lo  0
mirp[rp0,rnd,grey]  vheight_num 6
mirp[min,rnd,grey]  vstem_curve 18
srp0    0
mirp[min,rnd,grey]  vstem_curve 12
IUP[y]
""",

    #thaidigit_one
    "uni0E51": """
SRP0    48
mirp[rp0,min,rnd,grey]  headhole    3
mirp[min,rnd,grey]  hstem   22
mdrp[rp0,min,rnd,grey]  27
mdrp[rnd,grey]  25
mirp[min,rnd,grey]  headstem 45
mdrp[rp0,min,rnd,grey]  33
mirp[min,rnd,grey]  headstem 39
mdrp[rp0,min,rnd,grey]  16
mirp[rp0,min,rnd,grey]  hstem 9
mdrp[rnd,white]  49
mdrp[rp0,rnd,grey]  12
mdrp[rnd,grey]  13
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   48
mirp[rp0,rnd,grey]  vheight_num 6
mirp[min,rnd,grey]  vstem_curve 19
srp0    48
mirp[rp0,rnd,grey]  vheight_lo  13
mdrp[min,rnd,grey]  12
srp0    48
mirp[rp0,min,rnd,grey]  special_1 0
mirp[min,rnd,grey]  vstem 25
mdrp[min,rnd,grey]  36
mdrp[rp0,rnd,grey]  30
mirp[min,rnd,grey]  headstem 42
IUP[y]
""",

    #thaidigit_two
    "uni0E52": """
SRP0    50
mirp[rp0,min,rnd,grey]  headhole    3
mirp[rp0,min,rnd,grey]  hstem   8
mdrp[rp0,min,rnd,grey]  30
mdrp[rnd,grey]  19
mdrp[min,rnd,grey]  47
mdrp[rp0,min,rnd,grey]  24
mirp[min,rnd,grey]  headstem 41
mdrp[rp0,min,rnd,grey]  13
mirp[rp0,min,rnd,grey]  hstem 36
mdrp[rnd,white]  51
srp1    3
srp2    8
sloop   4
ip  5 6 1 10
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   0
mirp[min,rnd,grey]  vstem 11
mirp[rp0,rnd,grey]  vheight_num 32
alignrp 34
mirp[min,rnd,grey]  vstem_curve 17
shp[rp2]    15
mdrp[rp0,min,rnd,grey]  33
mirp[rp0,min,rnd,grey]  vstem 16
mdrp[rp0,rnd,grey]  21
mirp[min,rnd,grey]  headstem 44
mirp[rp0,rnd,grey]  headdia 27
mirp[min,rnd,grey]  headstem 38
srp0    0
mdrp[rp0,rnd,grey]  6
mdrp[min,rnd,grey]  5
IUP[y]
""",

    #thaidigit_three
    "uni0E53": """
SRP0    52
mirp[rp0,min,rnd,grey]  headhole    28
mirp[min,rnd,grey]  hstem   16
srp0    28
mdrp[min,rnd,grey]  49
mdrp[rp0,min,rnd,grey]  22
mirp[min,rnd,grey]  headstem 43
mdrp[rp0,rnd,grey]  10
mirp[rp0,min,rnd,grey]  hstem 9
mdrp[rp0,min,rnd,grey]  3
mirp[rp0,min,rnd,grey]  hstem 38
mdrp[rnd,white]  53
mdrp[rp0,rnd,grey]  0
mirp[min,rnd,grey]  hstem 1
srp1    10
srp2    9
ip  33
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   1
mirp[rnd,grey]  vheight_lo 25
mirp[rp0,rnd,grey]  vheight_num 35
alignrp 31
mirp[min,rnd,grey]  vstem_curve 6
shp[rp2]    13
mdrp[rp0,min,rnd,grey]  33
mdrp[min,rnd,grey]  10
srp0    25
mirp[min,rnd,grey]  headstem 40
mirp[rp0,rnd,grey]  headdia 19
mirp[min,rnd,grey]  headstem 46
mdrp[rnd,grey]  17
IUP[y]
""",

    #thaidigit_four
    "uni0E54": """
SRP0    51
mirp[rp0,min,rnd,grey]  headhole    7
mirp[rp0,min,rnd,grey]  hstem   20
mdrp[rp0,min,rnd,grey]  27
mdrp[min,rnd,grey]  25
mdrp[min,rnd,grey]  48
mdrp[rp0,rnd,grey]  33
mirp[min,rnd,grey]  headstem 42
mdrp[min,rnd,grey]  36
srp0    25
mdrp[rp0,min,rnd,grey]  2
mdrp[rp0,min,rnd,grey]  0
mdrp[rnd,grey]  14
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   51
mirp[rp0,rnd,grey]  special_2 0
alignrp 4
mdrp[rp0,min,rnd,grey]  38
mdrp[rp0,rnd,grey]  36
mdrp[min,rnd,grey]  39
mdrp[rp0,rnd,grey]  30
mirp[min,rnd,grey]  headstem 45
srp0 4
mirp[rp0,min,rnd,grey]  vstem_curve 23
mdrp[rnd,grey]  25
srp0    51
mirp[rp0,rnd,grey]  vheight_num 10
mirp[min,rnd,grey]  vstem_curve 16
mdrp[rp0,rnd,grey]  13
mdrp[min,rnd,grey]  14
IUP[y]
""",

    #thaidigit_five
    "uni0E55": """
SRP0    73
mirp[rp0,min,rnd,grey]  headhole    7
mirp[rp0,min,rnd,grey]  hstem   30
mdrp[rp0,min,rnd,grey]  37
mdrp[min,rnd,grey]  35
mdrp[min,rnd,grey]  58
mdrp[rp0,rnd,grey]  43
mirp[min,rnd,grey]  headstem 52
mdrp[min,rnd,grey]  46
srp0    35
mdrp[rp0,min,rnd,grey]  2
mdrp[rp0,min,rnd,grey]  0
mdrp[rnd,grey]  24
srp0    7
mdrp[rp0,rnd,grey]  10
mdrp[rp0,rnd,grey]  12
mirp[min,rnd,grey]  headstem 70
mirp[rp0,rnd,grey]  headdia 18
mirp[min,rnd,grey]  headstem 64
mdrp[min,rnd,grey]  20
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   73
mirp[rp0,rnd,grey]  special_2 0
alignrp 4
mdrp[rp0,min,rnd,grey]  48
mdrp[rp0,rnd,grey]  46
mdrp[min,rnd,grey]  49
mdrp[rp0,rnd,grey]  40
mirp[min,rnd,grey]  headstem 55
srp0 4
mirp[rp0,min,rnd,grey]  vstem_curve 33
mdrp[rnd,grey]  35
srp0    73
mirp[rp0,rnd,grey]  vheight_num 20
mirp[min,rnd,grey]  vstem_curve 26
mdrp[rp0,rnd,grey]  23
mdrp[min,rnd,grey]  24
srp0    26
mdrp[min,rnd,grey]  61
mdrp[rp0,rnd,grey]  15
mirp[min,rnd,grey]  headstem    67
srp0    61
mdrp[rnd,grey]  10
IUP[y]
""",

    #thaidigit_six
    "uni0E56": """
SRP0    44
mirp[rp0,min,rnd,grey]  special_1 21
mdrp[min,rnd,grey]  22
mdrp[rp0,rnd,grey]  19
mirp[rp0,rnd,grey]  w_852   29
mirp[min,rnd,grey]  hstem   14
mdrp[rnd,white]  45
srp0    19
mdrp[rp0,rnd,grey]  3
mirp[min,rnd,grey]  headstem 41
mirp[rp0,rnd,grey]  headdia 9
mirp[min,rnd,grey]  headstem 35
mdrp[rnd,grey]  11
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   44
mirp[rnd,grey]  vheight_lo 0
mirp[rp0,rnd,grey]  vheight_num 26
mirp[min,rnd,grey]  vstem_curve 17
mdrp[rp0,rnd,grey]  24
mdrp[min,rnd,grey]  19
mdrp[rp0,rnd,grey]  22
mdrp[min,rnd,grey]  21
srp0    0
mirp[min,rnd,grey]  vstem_curve 11
mdrp[min,rnd,grey]  32
mdrp[rp0,rnd,grey]  6
mirp[min,rnd,grey]  headstem 38
IUP[y]
""",

    #thaidigit_seven
    "uni0E57": """
SRP0    61
mirp[rp0,min,rnd,grey]  headhole    28
mirp[min,rnd,grey]  hstem   16
mdrp[min,rnd,grey]  58
mdrp[rp0,rnd,grey]  22
mirp[min,rnd,grey]  headstem 52
mdrp[rp0,rnd,grey]  10
mirp[rp0,min,rnd,grey]  hstem 9
mdrp[rp0,min,rnd,grey]  3
mdrp[min,rnd,grey]  1
mirp[rp0,min,rnd,grey]  hstem 38
mdrp[rnd,grey]  40
mdrp[rp0,min,rnd,grey]  42
mirp[min,rnd,grey]  vstem_curve 46
mdrp[min,rnd,grey]  44
mdrp[rnd,white]  62
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   1
mirp[rnd,grey]  vheight_lo 25
mirp[rp0,rnd,grey]  vheight_num 35
alignrp 31
mirp[min,rnd,grey]  vstem_curve 6
shp[rp2]    13
mdrp[rp0,min,rnd,grey]  33
mdrp[min,rnd,grey]  10
srp0    25
mirp[min,rnd,grey]  headstem 49
mirp[rp0,rnd,grey]  headdia 19
mirp[min,rnd,grey]  headstem 55
mdrp[rnd,grey]  17
srp0    1
mirp[rp0,min,rnd,grey]  vstem_curve 40
mdrp[rp0,rnd,grey]  44
mdrp[min,rnd,grey]  45
IUP[y]
""",

    #thaidigit_eight
    "uni0E58": """
SRP0    52
mirp[rp0,min,rnd,grey]  headhole    6
mirp[rp0,min,rnd,grey]  hstem   19
mdrp[rp0,min,rnd,grey]  23
mdrp[rp0,min,rnd,grey]  24
mdrp[rp0,min,rnd,grey]  31
mdrp[min,rnd,grey]  28
mirp[min,rnd,grey]  headstem 49
mdrp[rp0,rnd,grey]  37
mdrp[min,rnd,grey]  43
mdrp[min,rnd,grey]  13
srp1    19
srp2    24
sloop   3
ip  22 3 2
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   52
mirp[rp0,rnd,grey]  special_2 3
alignrp 0
mdrp[min,rnd,grey]  22
mdrp[rp0,min,rnd,grey]  2
mdrp[min,rnd,grey]  23
mdrp[min,rnd,grey]  24
srp0    0
mirp[rp0,min,rnd,grey]  vstem_curve 26
mdrp[rnd,grey]  28
srp0    0
mdrp[min,rnd,grey]  40
mdrp[rp0,rnd,grey]  34
mirp[min,rnd,grey]  headstem 46
srp0    0
mirp[rp0,rnd,grey]  vheight_num 9
mirp[min,rnd,grey]  vstem_curve 15
mdrp[rp0,rnd,grey]  12
mdrp[min,rnd,grey]  13
IUP[y]
""",

    #thaidigit_nine
    "uni0E59": """
SRP0    59
mirp[rp0,min,rnd,grey]  headhole    26
mirp[rp0,min,rnd,grey]  hstem   9
mdrp[rp0,min,rnd,grey]  20
mdrp[rp0,min,rnd,grey]  3
mdrp[rp0,min,rnd,grey]  1
mirp[rp0,min,rnd,grey]  hstem 0
mdrp[rp0,rnd,grey]  41
mdrp[rp0,rnd,grey]  40
ip  35
mdrp[rp0,rnd,grey]  38
mdrp[min,rnd,grey]  37
alignrp 60
srp0    20
mirp[min,rnd,grey]  headstem 49
mirp[rp0,rnd,grey]  headdia 14
mirp[min,rnd,grey]  headstem 56
srp1    3
srp2    41
sloop   3
ip  31 45 35
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   1
mirp[rnd,grey]  vheight_lo 23
mirp[rp0,rnd,grey]  vheight_num 33
alignrp 29
mirp[min,rnd,grey]  vstem_curve 43
shp[rp2]    6
mdrp[rp0,rnd,grey]  31
alignrp 35
mdrp[min,rnd,grey]  45
srp0    35
mdrp[rp0,rnd,grey]  37
mdrp[min,rnd,grey]  38
srp0    23
mdrp[min,rnd,grey]  12
mdrp[min,rnd,grey]  47
mdrp[rp0,rnd,grey]  17
mirp[min,rnd,grey]  headstem 53
IUP[y]
""",

#    #angkhankhu
    "uni0E5A": """
SRP0    35
mdrp[rp0,min,rnd,grey]  7
mirp[rp0,rnd,grey]  w_956 1
alignrp 17
mirp[rp0,min,rnd,grey]  hstem 18
mirp[rp0,rnd,grey]  headstem_tiny 20
mirp[rp0,min,rnd,grey]  hstem 22
mdrp[rnd,white]  36
srp0    7
mirp[min,rnd,grey]  headstem 32
mirp[rp0,rnd,grey]  headdia 13
mirp[min,rnd,grey]  headstem 26
mdrp[min,rnd,grey]  15
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   1
alignrp 20
mirp[rp0,rnd,grey]  vheight_shoot 10
alignrp 17
mirp[min,rnd,grey]  headstem 29
mdrp[rp0,rnd,grey]  4
mdrp[min,rnd,grey]  23
mdrp[min,rnd,grey]  15
mdrp[min,rnd,grey]  2
srp1    17
sloop 3
ip 18 21 22
IUP[y]
""",

#    #khomut
    "uni0E5B": """
SRP0    70
mirp[rp0,min,rnd,grey]  headhole    3
mirp[rp0,min,rnd,grey]  hstem   26
mdrp[rp0,min,rnd,grey]  15
mirp[min,rnd,grey]  headstem   67
mdrp[rp0,min,rnd,grey]  9
mdrp[min,rnd,grey]  61
mdrp[min,rnd,grey]  20
mdrp[rp0,min,rnd,grey]  32
mdrp[min,rnd,grey]  33
mdrp[rp0,min,rnd,grey]  55
mdrp[min,rnd,grey]  54
mdrp[rp0,min,rnd,grey]  34
mdrp[rp0,min,rnd,grey]  37
mdrp[min,rnd,grey]  38
mdrp[rp0,min,rnd,grey]  52
mdrp[min,rnd,grey]  51
mdrp[rp0,min,rnd,grey]  39
mdrp[rp0,min,rnd,grey]  42
mdrp[min,rnd,grey]  43
mdrp[rp0,min,rnd,grey]  49
mdrp[rp0,min,rnd,grey]  46
mdrp[min,rnd,grey]  71
IUP[x]
SVTCA[y-axis]
MDAP[rnd]   70
mirp[rp0,rnd,grey]  vheight_lo  0
mirp[rp0,min,rnd,grey]  vstem_curve 29
mdrp[rp0,min,rnd,grey]  12
mirp[min,rnd,grey]  headstem 58
mirp[rp0,rnd,grey]  headdia 18
mdrp[min,rnd,grey]  20
mirp[min,rnd,grey]  headstem 64
mdrp[rp0,min,rnd,grey]  23
mirp[min,rnd,grey]  vstem_curve 6
srp0    0
mdrp[rp0,min,rnd,grey]  55
alignrp     52
alignrp     49
alignrp     45
mdrp[min,rnd,grey]  54
shp[rp2]    51
mdrp[rp0,min,rnd,grey]  32
alignrp 37
alignrp 42
mdrp[rp0,min,rnd,grey]  33
alignrp 38
alignrp 43
srp0    45
mdrp[min,rnd,grey]  46
IUP[y]
""",


#    #CHAR_NAME
#    "uni0EXX": """
#SRP0    0
#
#IUP[x]
#SVTCA[y-axis]
#MDAP[rnd]   0
#
#IUP[y]
#""",


}

if __name__=="__main__":
    if sys.argv[1] == "--all":
        #$0 --all = ENCODE ALL CHARS
        sfd_file = os.path.basename(sys.argv[0]).split('.',1)[0] + '.sfd'
        print "Encoding all character in %s" % (sfd_file)
        dfont.inst_encode_all( sfd_file, pseudo_code_dict, cvt_dict )
    else:
        #$0 uni0E01 > x.txt = PRINT INSTRUCTION CODE OF uni0E01 TO x.txt
        print '\n'.join(dfont.inst_encode( pseudo_code_dict[sys.argv[1]], cvt_dict ))
