#!/usr/bin/env python
import sys
import os
import dfont
from dttcmd import *

#pseudo_file = 'pseudo_code.txt'
#inst_file = 'inst.txt'
#

if __name__ == "__main__":
    filename = os.path.splitext(os.path.basename(sys.argv[0]))[0]
    mod_filename = filename.replace('-','_')
    sfd_file = filename + '.sfd'


    if '-a' in sys.argv:
        #-a: USE CODE FROM AUTO-INSTUCTION IN FILE inst_$0
        sys.argv.remove('-a')
        exec "from inst_%s import *" % (mod_filename,)
    elif '-mod' in sys.argv:
        #-mod: USE CODE FROM MODIFIED AUTO-INSTUCTION mod_$0
        sys.argv.remove('-mod')
        exec "from mod_%s import *" % (mod_filename,)
    else:
        #default: USE MANUAL INSTRUCTION CODE
        exec "from man_%s import *" % (mod_filename,)

        
    if '-d' in sys.argv:
        #$0 -d = DECODE CONTENT IN inst_file TO pseudo_file AND EDIT IT
        gedit_pseudo(cvt_dict,func_arg_list)
    elif '--all' in sys.argv:    #find&replace in sfd file
        #$0 --all = ENCODE ALL CHARS
        print "Encoding all character in %s" % (sfd_file)
        dfont.inst_encode_all( sfd_file, pseudo_code_dict, cvt_dict )
    elif '-b' in sys.argv:   #both pseudo code & instructed code
        sys.argv.remove('-b')
        txt = pseudo_code_dict[sys.argv[1]]
        gedit(txt,cvt_dict,1)
    else:           #instructed code
        txt = pseudo_code_dict[sys.argv[1]]
        gedit(txt,cvt_dict)
