#!/usr/bin/env python
import os
import sys
import dfont

#----------------------------------------
#   common routine
#----------------------------------------

def ix():
    """print iup[x]"""
    return """
IUP[x]
#
"""


def iy():
    """print iup[y]"""
    return """
IUP[y]
#
"""


def sx():
    return """
#
SVTCA[x-axis]
"""

def sy():
    """print svtca[y-axis]"""
    return """
#
SVTCA[y-axis]
"""


def srp0(s):
    return """
SRP0                %s
""" % (s,)

def alignrp(s):
    return """
ALIGNRP             %s
""" % (s,)

def shprp2(s):
    return """
SHP[rp2]            %s
""" % (s,)

def f_add(s,dstr,direction="+"):
    if dstr:
        if type(dstr) == type(''):
            return f_dstr(s,dstr,direction)
        elif type(dstr) == type({}):
            return f_dstr_dict(dstr,direction)
    else:
        return ""


#---GENERATE FUNCTION OF SHORT COMMAND---
#'mdap', 'mdapn', 'mdapr', 'mdrp0b', 'mdrp0g', 'mdrp0mb', 'mdrp0mg', 'mdrp0mnb', 'mdrp0mng', 'mdrp0mnw', 'mdrp0mrb', 'mdrp0mrg', 'mdrp0mrw', 'mdrp0mw', 'mdrp0nb', 'mdrp0ng', 'mdrp0nw', 'mdrp0rb', 'mdrp0rg', 'mdrp0rw', 'mdrp0w', 'mdrpb', 'mdrpg', 'mdrpmb', 'mdrpmg', 'mdrpmnb', 'mdrpmng', 'mdrpmnw', 'mdrpmrb', 'mdrpmrg', 'mdrpmrw', 'mdrpmw', 'mdrpnb', 'mdrpng', 'mdrpnw', 'mdrprb', 'mdrprg', 'mdrprw', 'mdrpw', 'miap', 'miapn', 'miapr', 'mirp0b', 'mirp0g', 'mirp0mb', 'mirp0mg', 'mirp0mnb', 'mirp0mng', 'mirp0mnw', 'mirp0mrb', 'mirp0mrg', 'mirp0mrw', 'mirp0mw', 'mirp0nb', 'mirp0ng', 'mirp0nw', 'mirp0rb', 'mirp0rg', 'mirp0rw', 'mirp0w', 'mirpb', 'mirpg', 'mirpmb', 'mirpmg', 'mirpmnb', 'mirpmng', 'mirpmnw', 'mirpmrb', 'mirpmrg', 'mirpmrw', 'mirpmw', 'mirpnb', 'mirpng', 'mirpnw', 'mirprb', 'mirprg', 'mirprw', 'mirpw'
#
#usage: mdrp0rg(0)
#output:MDRP[rp0,rnd,grey]      0
#
for i in dfont.short_cmd_dict.keys():
    if i[:2] in ['MD']:     #move direct require 2 arguments
        exec '''
def %s(s,dstr="",direction="+"):
    return """
%s      %s """ %s (s,) + f_add(s,dstr,direction)
''' % (i.lower(), dfont.short_cmd_dict[i], '%s','%', )
    else:                   #move indirect require 3 arguments
        exec '''
def %s(cvt,s,dstr="",direction="+"):
    return """
%s      %s %s """ %s (cvt,s,) + f_add(s,dstr,direction)
''' % (i.lower(), dfont.short_cmd_dict[i], '%s','%s','%', )



def mdap(s,dstr=""):
    return """
MDAP[rnd]           %s
""" % (s,) + f_add(s,dstr)



def f_ip(li):
    """add interpolate from list"""
    if type(li) not in [ type([]),type(()) ]:
        raise "Error in f_ip, variable type must be list (or tuple)."

    if not li:
        return ""

    n = len(li)
    if n < 3:
        temp = '\n'.join( ["IP        %s" % (e,) for e in li] )
    else:
        t = " ".join( ["%s " % l for l in li] )
        temp = """
SLOOP       %s
IP          %s
""" % (n, t,)
    return temp


def add_ip(s1,s2, li):
    """interpolate from srp1,srp2"""
    if not li:
        return ""

    return pl("""
SRP1        %s              #s1
SRP2        %s              #s2
""" % (s1,s2,)
        , f_ip(li)
        )

def ip_round(s1,s2,s3,ds=""):
    """interpolate point 3 from 1,2 and round"""
    return pl(add_ip(s1,s2,[s3]), mdapr(s3,ds))
       

def ax(s):
    return "#ax#" + s.strip() + '\n'

def ay(s):
    return "#ay#" + s.strip() + '\n'

#----------------------------------------
def pl(*l):
    return '\n'.join(l)

def packline(*l):
    #use comment '#ax#' to append the line after IUP[x]
    #and comment '#ay#' to append the line after IUP[y]
    #*** no line-break before ***
    lax = []
    lay = []
    lcode = []
    for linegroup in l:
        line = linegroup.split('\n')
        i = 0
        while i < len(line):
            line[i] = line[i].strip()
            if line[i]:
                if line[i][:4].lower() == '#ax#':
                    lax.append(line[i][4:])
                    while i+1<len(line) and (line[i+1]=='' or line[i+1][0] == '#') and line[i+1][:4].lower() not in ['#ax#','#ay#']:
                        lax.append(line[i+1])
                        i += 1
                elif line[i][:4].lower() == '#ay#':
                    lay.append(line[i][4:])
                    while i+1<len(line) and (line[i+1]=='' or line[i+1][0] == '#') and line[i+1][:4].lower() not in ['#ax#','#ay#']:
                        lay.append(line[i+1])
                        i += 1
                else:
                    lcode.append(line[i])
                if line[i][:6].upper() == 'IUP[X]':
                    for x in lax:
                        lcode.append(x)
                        lax = []
                elif line[i][:6].upper() == 'IUP[Y]':
                    for y in lay:
                        lcode.append(y)
                        lay = []
            i += 1
    if [l for l in lax if l]:
        lcode.append('#code remain in x:')
        lcode.extend(lax)
    if [l for l in lay if l]:
        lcode.append('#code remain in y:')
        lcode.extend(lay)
    return '\n'.join([ line for line in lcode if line ])

#------------------------------------------------
def swap_dstr(dstr):
    return dstr.replace('+','*').replace('-','+').replace('*','-')

def f_dstr(s,dstr="",direction="+",aip=""):
    """render deltap string"""
    #dstr = "9-5 10-4 11-4 12-3 13-3 14-2 15-2 16-2"
    #aip = "#ax#"   #or "#ay#" (insert after interpolate in x or y direction)
    #return "f_deltap %s 9-5 %s 10-4 ..."
    if not dstr:
        return ""
    if direction == "-":
        #inverse delta string
        dstr = swap_dstr(dstr)
    ld = [i for i in dstr.split(' ') if i]
    t = "%s" % (s,)
    fstr = " ".join([ "%s %s " % (t,i) for i in ld if i ]).strip()
    if fstr:
        fstr = "\n%sf_deltap " % (aip,) + fstr
    return fstr

def f_dstr_dict(dstr_dict={},direction="+",aip=""):
    if direction == "-":
        #inverse delta string
        for i,j in dstr_dict.iteritems():
            dstr_dict[i] = swap_dstr(j)
    ld = []
    for i,j in dstr_dict.iteritems():
        if j:
            ls = [k for k in j.split(' ') if k]
            t = " %s " % (i,)
            ld.append( " ".join([ " %s %s " % (t,m) for m in ls if m ]).strip() )

    fstr = " ".join(ld)
    if fstr:
        fstr = "\n%sf_deltap " % (aip,) + fstr
    return fstr
            

#------------------------------------------------
#   univeral routine

def gen_alignrp(l,a=1):
    if a == 1:
        cmd = "ALIGNRP"
    else:
        cmd = "SHP[rp2]"
    if type(l) != type(1): #use tuple to use alignrp or shp[rp2]
        return l[0],'\n'.join(["%s %s" % (cmd,i,) for i in l[1:]])
    else:
        return l,""
        
def ip_front_stem(f0, f1,fstemw,f2, rx, dsf="", fround=71):
    f1,addf1 = gen_alignrp(f1)
    f2,addf2 = gen_alignrp(f2,2)
    return pl(""
        , srp0(rx)
        , mdrp0mw(f1)
        , mirpmw(fstemw,f2)
        , add_ip(f0,f2,[f1])
        ,'SROUND %s' % (fround,)
        , mdapr(f1,dsf)
        ,'RTG'
        , addf1
        , mirpmb(fstemw,f2)
        , addf2
        )

def ip_middle_stem(f0, m1,mstemw,m2, r0, dsm="", mround=71):
    m1,addm1 = gen_alignrp(m1)
    m2,addm2 = gen_alignrp(m2,2)
    return pl(""
        ,'SROUND %s' % (mround,)
        , ip_round(f0,r0,m1)
        ,'RTG'
        , addm1
        , mirpmb(mstemw,m2)
        , addm2
        )

def u_x2(f0,f1,fstemw,f2, r1,rstemw,r2,r0, dsf="",fround=71): # 2 stem
    # universal routine for create point walk in x-direction
    # f0 -> f1 = front gap
    # f1 -> f2 = stem width
    # r0 -> r1 = rear gap
    # r1 -> r2 = rear stem width
    # process path walk from back (with at least 1 pixel gap)
    # to front (may be zero gap)
    #
    # fround: use to round front stem
    # ko_kai = 70
    # kho_khai = 74
    #
    # use tuple to align multiple points.
    # ex: u_x(f0,f1,f2, 24,(5,8),12)
    # generated:
    #   MDAP[rnd] 24
    #   MDRP[rp0,min,rnd,white]   5
    #   MDRP[rp0,min,rnd,grey]    12
    #   MIRP[min,black]           5
    #   SHP[rp2]                  8
    #   ...
    r1,addr1 = gen_alignrp(r1)
    r2,addr2 = gen_alignrp(r2,2)
    r0,addr0 = gen_alignrp(r0)
    return pl(""
        , mdapr(r0)
        , addr0
        , mdrp0mw(r2)
        #LEFT MOST=68, RIGHT MOST=74
        ,'SROUND 70'
        , mirp0mw(rstemw,r1)
        , mdapr(r1)
        , addr1
        , mirpmb(rstemw,r2)
        , addr2
#
        , ip_front_stem(f0, f1,fstemw,f2, r2, dsf=dsf, fround=fround)
        )

def u_x1(f0, r1,rstemw,r2,r0, dsf="",fround=72):  #1 stem (i,j,f,t)
    # universal routine for create point walk in x-direction
    # r0 -> r1 = rear gap
    # r1 -> r2 = rear stem width (rstemw)
    # process path walk from back (with at least 1 pixel gap)
    # to front (may be zero gap)
    r1,addr1 = gen_alignrp(r1)
    r2,addr2 = gen_alignrp(r2,2)
    return pl(""
        , mdapr(r0)
        , mdrp0mw(r2)
        , mirp0mb(rstemw,r1,dsf)
        , 'SROUND %s' % (fround,)
        , mdapr(r1)
        , 'RTG'
        , addr1
        , mirpmb(rstemw,r2)
        , addr2
        )

def u_x1f(f0, f1,fstemw,f2, r1,r0, dsf="",fround=70):  #1.5 stem (E,F)
    f1,addf1 = gen_alignrp(f1)
    f2,addf2 = gen_alignrp(f2,2)
    r1,addr1 = gen_alignrp(r1)
    return pl(""
        , mdapr(r0)
        , mdrp0mrw(r1)
        , addr1
#
        , mdrp0mw(f1)
        , mirpmw(fstemw,f2)
        , add_ip(f0,f2,[f1])
        , 'SROUND %s' % (fround,)
        , mdapr(f1,dsf)
        , 'RTG'
        , addf1
        , mirpmb(fstemw,f2)
        , addf2
        )

def u_x3(f0,f1,fstemw,f2, m1,mstemw,m2, r1,rstemw,r2,r0, dsf=""): # 3 stem
    f1,addf1 = gen_alignrp(f1)
    f2,addf2 = gen_alignrp(f2,2)
    m1,addm1 = gen_alignrp(m1)
    m2,addm2 = gen_alignrp(m2,2)
    r1,addr1 = gen_alignrp(r1)
    r2,addr2 = gen_alignrp(r2,2)
    return pl(""
        , mdapr(r0)
        , mdrp0mw(r2)
        , 'SROUND 74'
        , mirp0mrw(rstemw,r1)
        , mdapr(r1)
        , addr1
        , mirpmb(rstemw,r2)
        , addr2
#
        , srp0(r2)
        , mdrp0mw(f1)
        , mirpmw(fstemw,f2)
        , add_ip(f0,f2,[f1])
        , 'SROUND 70'
        , mdapr(f1,dsf)
        , 'RTG'
        , addf1
        , mirpmb(fstemw,f2)
        , addf2
#
        , 'SROUND 70'
        , ip_round(f1,r1,m1)
        , 'RTG'
        , addm1
        , mirpmb(mstemw,m2)
        , addm2
        )


#----------------------------------------
#   implement routine
#----------------------------------------
pseudo_file = 'pseudo_code.txt'
inst_file = 'inst.txt'

#----------------------------------------
#   code
#----------------------------------------
def gedit(txt,cvt_dict,gen_pseudo=False):
    """invoke gedit"""
    os.system('killall gedit')
    if gen_pseudo:
        f = open(pseudo_file,'w')
        #strip blank line
        lt = [i.strip() for i in txt.split('\n')]
        txt = '\n'.join([i for i in lt if i])
        f.write(txt)
        f.close()
        os.system('gedit %s &' % (pseudo_file,))
    f = open(inst_file,'w')
    f.write('\n'.join(dfont.inst_encode(txt, cvt_dict )))
    f.close()
    os.system('gedit %s &' % (inst_file,))
    return

def gedit_pseudo(cvt_dict,func_arg_list):
    """gedit pseudo code"""
    os.system('killall gedit')
    os.system('gedit %s' % (inst_file,))
    txt = open(inst_file).read()
    txt = '\n'.join(dfont.inst_decode(txt,cvt_dict,func_arg_list))
    f = open(pseudo_file,'w')
    f.write(txt)
    f.close()
    os.system('gedit %s &' % (pseudo_file,))


