#!/usr/bin/env python
from dttcmd import *

func_arg_list = [[2, 0], [1, 0], [3, 1], [1, 1], [4, 0], [0, 1], [0, 1], [0, 1], [3, 0], [3, 0], [2, 0], [1, 0], [1, 0], [4, 0], [3, 0], [5, 0], [2, 0], [2, 0], [2, 0], [3, 0], [0, 0]]

cvt_dict = {
    'evheight_lu' : 0,   #  -417    ;eng vheight p,q
    'tvheight_lu' : 0,   #  -417    ;eng vheight p,q
    'vbase' : 1,   #  0            ;all vbase
    'tvheight_num' : 2,   #  908    ;thai vheight number
    'evheight' : 3,   #  1062       ;eng vheight normal
    'tvheight' : 4,   #  1140       ;thai vheight normal
    'ecvheight' : 5,   #  1450      ;eng capital vheight normal
    'estemtc' : 6,   #  160         ;eng stem thick - curve
    'tstemtc' : 6,   #  160         ;thai stem thick - curve
    'cvt_7' : 7,   #  112
    'stemt_sara' : 7,   #  112      ;stem thick of sara
    'cvt_8' : 8,   #  124
    'headstem' : 9,   #  130        ;head stem width/thick
    'stemw_sara' : 9,   #  130      ;stem width of sara
    'estemt' : 10,   #  148         ;eng stem thick
    'tstemt' : 10,   #  148         ;thai stem thick
    'cvt_11' : 11,   #  164
    'cvt_12' : 12,   #  168
    'ecstemt' : 13,   #  173        ;eng cap stem thick
    'ecstemw' : 14,   #  180        ;eng cap stem width
    'headstem_thick' : 15,   #  160 ;head stem - thick
    'estemw' : 16,   #  180         ;eng stem width
    'tstemw' : 16,   #  180         ;thai stem width
    'cvt_17' : 17,   #  175
    'cvt_18' : 18,   #  191
    'cvt_19' : 19,   #  193
    'cvt_20' : 20,   #  201
    'cvt_21' : 21,   #  197
    'cvt_22' : 22,   #  138
    'cvt_23' : 23,   #  144
    'cvt_24' : 24,   #  178
    'cvt_25' : 25,   #  152
    'cvt_26' : 26,   #  156
    'cvt_27' : 27,   #  154
    'cvt_28' : 28,   #  103
    'head_sara_stem' : 28,   #  103
    'cvt_29' : 29,   #  142
    'cvt_30' : 30,   #  122
#USER LAND
    'evbase_shoot' : 31,   #  24
    'tvbase_shoot' : 31,   #  24
    'tvheight_num_shoot':32,# 936
    'evheight_shoot':33,    # 1088
    'tvheight_shoot':34,    # 1166
    'ecvheight_shoot':35,   # 1482
    'headstemplushole':36, # 300
    'headdia':37, # 430
    'tvheight_po': 38,  # 1477
    'head_sara': 39,    # 334
    }

#PUT THESE LINE IN THE BOTTOM OF CODE
#   #----- MODIFY pseudo_code_dict BY -----------
#   #----- SUBSTITUTE FUNCTION IN TEXT FORM -----
#   #----- TO REAL pseudo_code ------------------
#   from dttcmd import *
#   self_func = []
#   for i in dir():
#       if callable(eval(i)): self_func.append(i)
#   
#   
#   for i in pseudo_code_dict.keys():
#       p_list = pseudo_code_dict[i].sp_listit('\n')
#       for j in range(len(p_list)):
#           if '(' in p_list[j]:
#               if p_list[j].sp_listit('(',1)[0] in self_func:
#                   l = [n for n in range(len(p_list[j])) if p_list[j][n] == ')']
#                   t = p_list[j][:l[-1]+1]
#                   p_list[j] = p_list[j].rep_listace(t, eval(t))
#       pseudo_code_dict[i] = '\n'.join(p_list)

#----------------------------------------
#   code
#----------------------------------------


#----------------------------------------

#---GENERATE STEM FUNCTION---
#predefine delta string of stem (put before gen_cvt_func)
#ds_headstem = "9-4 30-4 31-4 32-4 33-4 34-4 "
#ds_headstemplushole = "9-4 30+4 31+4 32-4 33-4 34-4 "
#ds_headsara = "9-4 "
#
ds_headstem = "9-4 24-4 25-4 26-4 27-4 28-4 40-8 "
ds_headdia = "9-8 12-8 13-8 17-8 18-8 22-8 23-8 27-8 28-8 31-8 32-8 36-8 37-8 "
ds_headstemplushole = "18-8 24-4 25-4 26-4 27-4 28-4 31-8 32-8 "
ds_head_sara = "15+8 "
ds_head_sara_stem = "9-4 "
ds_estemw = ds_tstemw = "12-1 13-1 14-2 15-2 16-2 "
ds_estemt = ds_tstemt = "14-1 15-1 16-2 "
ds_estemt_thin = ds_tstemt_thin = "14-2 15-2 16-3 " #EXTRA FOR THIN
ds_estemtc = ds_tstemtc = "14-1 15-2 16-3 "
ds_estemt_thin = ds_tstemtc_thin = "14-2 15-3 16-3 " #EXTRA FOR THIN


gen_cvt_func_dict = {
    #[min,black]
    'mb':   ['estem*','tstem*','stem*'],
    #[min,rnd,grey]
    'mrg':  ['headstem*','head_sara_stem','head_sara'],
    }

for arg,cvt_list in gen_cvt_func_dict.iteritems():
    new_list = []
    for i in cvt_list:
        if i[-1]=='*':
            c = i.strip('*')
            n = len(c)
            l = [x for x in cvt_dict.keys() if x[:n]==c]
            new_list.extend(l)
        else:
            new_list.append(i)
        
    for i in new_list:
        for j in ['1','1m','2','2m']:   #1=forward/bottomup, #2=reverse/topdown
            if j[-1] == 'm':    #m=move rp0
                cmd = 'mirp0'+arg
            else:
                cmd = 'mirp'+arg
            if j[0] == '1': #1=forward/bottomup, #2=reverse/topdown
                direction = '+'
            else:
                direction = '-'
            #AUTO GENERATE delta string
            try:
                exec "a = ds_%s " % (i,)
            except:
                exec "ds_%s = ''" % (i,)
            #GEN FUNC
            exec '''def %s_%s(s,direction="%s"):
    return %s("%s",s,ds_%s,direction,)
''' % (i,j,direction,cmd,i,i,)

            #GEN EXTRA FUNC FOR THIN OF estemt, tstemt
            #USE IN UPPER STEM OF kho_khai, kho_kwai
            #***PREDEFINE: ds_estemt_thin
            if i in ['estemt','estemtc','tstemt','tstemtc']:
                #AUTO GENERATE delta string
                try:
                    exec "a = ds_%s_thin " % (i,)
                except:
                    exec "ds_%s_thin = ''" % (i,)
                #GEN FUNC
                exec '''def %s_thin_%s(s,direction="%s"):
    return %s("%s",s,ds_%s_thin,direction,)
''' % (i,j,direction,cmd,i,i,)


#EXAMPLE OF CVT FUNCTION DEFINED:
#
#def estemw_1(s): = """
#   MIRP[rnd,black]    estemw s
#   f_dstr(s,"ds_estemw")
#   """
#
#def estemw_2(s): = """
#   MIRP[rnd,black]    estemw s
#   f_dstr(s,"ds_estemw",direction="-")
#   """

#----------------------------------------
#DRY HEAD
#ENABLE DRY HEAD FOR BOOK
ds_dryhead = "14+3 15+3 16+3 "
def dh1(*l): #dry head
    d = {}
    for s in l:
        d[s-1] = ds_dryhead
        d[s+1] = swap_dstr(ds_dryhead)
    return f_dstr_dict(d)
#    return f_dstr_dict({
#        s-1: "15+4 16+3 17+3 18+3 ",
#        s+1: "15-4 16-3 17-3 18-3 " })

def dh2(*l): #dry head
    d = {}
    for s in l:
        d[s-1] = swap_dstr(ds_dryhead)
        d[s+1] = ds_dryhead
    return f_dstr_dict(d)
#    return f_dstr_dict({
#        s-1: "15-4 16-3 17-3 18-3 ",
#        s+1: "15+4 16+3 17+3 18+3 " })

def dh11(s): #dry 1 point +
    return f_dstr(s,ds_dryhead)

def dh12(s): #dry 1 point -
    return f_dstr(s,ds_dryhead,direction='-')


#DISABLE DRY HEAD FOR BOLD
#def dh1(*l):
#    return ""
#def dh2(*l):
#    return ""
#def dh11(s):
#    return ""
#def dh12(s):
#    return ""



#----------------------------------------
def dx(s,x):
    return """
SHPIX   %s %s
""" % (x,s)

#================================================
def vbc1(s,li=[]):
    return pl(""
        , mirp0rg("vbase_shoot",s)
        , f_ip(li)
        )

def tvbc(s,li=[]):  #thai vbase curve
    return pl(""
        , mirp0rg("tvbase_shoot",s)
        , f_ip(li)
        )

def tvblu(s,li=[]):
    return pl(""
        , mirprg("tvheight_lu",s)
        , f_ip(li)
        )

def tvblum(s,li=[]):
    return pl(""
        , mirp0rg("tvheight_lu",s)
        , f_ip(li)
        )

def tvtc2(s,li=[]): #thai vtop curve
    return pl(""
        , mirp0rg("tvheight_shoot",s,"")
        , f_ip(li)
        )

def tvt2(s,li=[]):
    return pl(""
        , mirprg("tvheight",s,"15+8 17+8 22+8 24+8 26+8 29+8 31+8 33+8 35+8 36+8 38+8 40+8 42+8 ")
        , f_ip(li)
        )

def vt2m(s,li=[]):
    return pl(""
        , mirp0rg("vheight",s,ds_vheight)
        , f_ip(li)
        )

def tvtpo(s,li=[]):
    return pl(""
        , mirprg("tvheight_po",s)
        , f_ip(li)
        )

def vtpom(s,li=[]):
    return pl(""
        , mirp0rg("vheight_po",s)
        , f_ip(li)
        )

def tvtsara(s):
    return mdapr(s,"12+8 15+8 ")

def tvtwanayuk(s):
    return mdapr(s,"12+8 15+8 17+8 ")


ds_tvheight_num = "10+8 19+8 21+8 28+8 30+8 32+8 37+8 39+8 41+8 "
def tvtn(s, li=[]):
    return pl(""
        , mirp0rg("tvheight_num",s,ds_tvheight_num)
        , f_ip(li)
        )

def tvtnc(s, li=[]):
    return pl(""
        , mirp0rg("tvheight_num_shoot",s)
        , f_ip(li)
        )

def head_0(s,li,direction="+",ss=-1,l1s=-1,l2s=-1,dia="headdia"):
    exec "ds = ds_%s" % (dia,)
    if direction == "-":
        l1 = li[1]
        l2 = li[0]
        temp = l1s
        l1s = l2s
        l2s = temp
        ds = swap_dstr(ds)
        if dia == "head_sara":
            stem1 = head_sara_stem_2(l1)
            stem2 = head_sara_stem_1(l2)
        else:
            stem1 = headstem_2(l1)
            stem2 = headstem_1(l2)
    else:
        l1 = li[0]
        l2 = li[1]
        if dia == "head_sara":
            stem1 = head_sara_stem_1(l1)
            stem2 = head_sara_stem_2(l2)
        else:
            stem1 = headstem_1(l1)
            stem2 = headstem_2(l2)
    if len(li)>2:
        ip = f_ip(li[2:])
    else:
        ip = ""
    if ss >= 0:
        add_ss = alignrp(ss)
    else:
        add_ss = ""
    if l1s >= 0:
        add_l1s = shprp2(l1s)
    else:
        add_l1s = ""
    if l2s >= 0:
        add_l2s = shprp2(l2s)
    else:
        add_l2s = ""
    return pl(""
        , stem1
        , add_l1s
        , mirp0rg(dia,s,ds)
        , add_ss
        , ip
        , stem2
        , add_l2s
        )

def head1(s,li,ss=-1,l1s=-1,l2s=-1):
    #left to right
    return head_0(s,li,direction="+",ss=ss,l1s=l1s,l2s=l2s)

def head2(s,li,ss=-1,l1s=-1,l2s=-1):
    #right to left
    return head_0(s,li,direction="-",ss=ss,l1s=l1s,l2s=l2s)

def headsara1(s,li,ss=-1,l1s=-1,l2s=-1,dia="head_sara"):
    #left to right
    return head_0(s,li,direction="+",ss=ss,l1s=l1s,l2s=l2s,dia=dia)

def headsara2(s,li,ss=-1,l1s=-1,l2s=-1,dia="head_sara"):
    #right to left
    return head_0(s,li,direction="-",ss=ss,l1s=l1s,l2s=l2s,dia=dia)


def xhead0(s2,s3,direction="+",s2s=-1,s3s=-1):
    add2 = add3 = ""
    if s2s >=0 : add2 = shprp2(s2s)
    if s3s >=0 : add3 = shprp2(s3s)
    return pl(""
        , headstem_1(s2,direction=direction)
        , add2
        , headstemplushole_1(s3,direction=direction)
        , add3
        )


def xhead1(s1,s2,s3,dstr="11+8 12+8 13+8 26+8 27+8 28+8 ",direction="+",s1s=-1,s2s=-1,s3s=-1):
    add1 = ""
    if s1s >=0 : add1 = alignrp(s1s)
    return pl(""
        , mdrp0rg(s1,dstr)
        , add1
        , xhead0(s2,s3,direction,s2s,s3s)
        )

def xhead2(s1,s2,s3,dstr="12-8 13-8 16-8 25-8 26-8 ",direction="-"):
    return xhead1(s1,s2,s3,dstr,direction)


#================================================
def v_notch_ko_kai(s1,s1s,s2):
    return pl(""
        , mdrp0rg(s1,"23+8 ")
        , alignrp(s1s)
        , stem_notch_1(s2)
        , dx(s2,-8)
        )

def v_head_kho_khai(s1,li1, s2, s3,s4, li4, add1=""):
    return pl(""
        , tvtc2(s1,li1)
        , add1
        , tstemt_thin_2(s2)
        , mdrp0rg(s3)
        , head2(s4,li4)
        )

def v_head_kho_khuat(s1,s1s,li1, s2,s2s, s3,s4, s5,s6,li6 , add1=""):
    return pl(""
        , tvtc2(s1, li1)
        , alignrp(s1s)
        , add1
        , tstemt_2(s2)
        , shprp2(s2s)
        , mdrp0mrg(s3,"9-3 10-3 11-3 12-3 17-3 18-3 19-3 20-3 21-3 ")
        , mdrpb(s4)
        , mdrp0rg(s5)
        , mdapr(s5)
        , head2(s6,li6)
        )

def v_top_kho_khwai(s1,li1,s2, s3,s4,li4,add1=""):
    if len(li4) > 3:
        add4 = f_dstr_dict({
            li4[2]:"14+2 15+2 16+2 ",
            li4[3]:"14-4 15-4 16-4 ",
            })
    else:
        add4 = ""
    return pl(""
        , tvtc2(s1,li1)
        , add1
        , tstemtc_thin_2(s2)
        , mdrp0rw(s3)
        , head2(s4,li4)
        , add4
        )

def v_top_kho_khon(s1,s1s,li1, s2,s2s, s3,s4, s5,s6,li6):
    if len(li6) > 3:
        add6 = f_dstr_dict({
            li6[2]:"14+2 15+2 16+2 ",
            li6[3]:"14-4 15-4 16-4 ",
            })
    else:
        add6 = ""
    return pl(""
        , tvtc2(s1,li1)
        , alignrp(s1s)
        , tstemt_2(s2)
        , shprp2(s2s)
        , mdrp0rg(s3,"9-8 10-8 12-3 13-3 14-3 15-3 16-3 17-3 ")
        , stemt_sara_2(s4)
        , mdrp0mrw(s5)
        , mdapr(s5)
        , head2(s6,li6)
        , add6
        )
        
def v_top_ro_rua(s1,li1, s2, s3,s4,s5,s6):
    return pl(""
        , tvtc2(s1,li1)
        , tstemtc_thin_2(s2)
        , mdrp0rg(s3,"9-4 10-4 11-4 12+4 13+4 ")
        , tstemt_1(s4)
        , srp0(s1)
        , mdrp0g(s5)
        , tstemt_2(s6)
        )

#================================================
def hs1(s,ds="9-8 "):    #start point #1 forward
    #ko_kai, kho_khwai
    return mdapr(s,ds)

def hs2(s,ds="9-8 14-8 "):    #start point #2 reverse
    #kho_khai, cho_chan
    return mdapr(s,ds)

def hw1(s,li=[],ds="11+8 23+8 26+8 "): 
    #make width #1  forward
    #move from front stem of ko_kai to rear stem
    return pl(""
        , mirp0rg("w_316",s,ds)
        , f_ip(li)
        )

def hw2(s,li=[],ds="11-8 12-8 "): 
    #make width #2  reverse
    return pl(""
        , mirp0rg("w_362",s,ds)
        , f_ip(li)
        )

def hw3(s,li=[],ds="17-8 "): 
    #make width #3 forward, pho_samphao
    return pl(""
        , mirp0rg("w_266",s,ds)
        , f_ip(li)
        )

def hw4(s,li=[],ds="11+8 "): 
    #make width #4 forward
    return pl(""
        , mirp0rg("w_214",s,ds)
        , f_ip(li)
        )

def hw5(s,li=[],ds="9-8 11+8 12+8 15+8 17-8 26+8 33+8 "): 
    #make width #5 forward, tho_thahan
    return pl(""
        , mirp0rg("w_285",s,ds)
        , f_ip(li)
        )

def tg_0(s0,s1,s2,ds=""):  #thai gap
    return pl(""
        , srp0(s0)
        , mdrp0rg(s1,ds)
        , tstemw_1(s2)
        )


def tgf_148(s0,s1,s2):  #thai front gap
    return tg_0(s0,s1,s2,"9-8 10-8 ")

def tgf_112(s0,s1,s2):  #thai front gap
    return tg_0(s0,s1,s2,"9-8 10-8 11-8 ")

def tgf_162(s0,s1,s2):  #thai front gap
    return tg_0(s0,s1,s2,"9-8 10-8 ")


def tgr_112(s0,s1,s2):  #thai rear gap
    return tg_0(s0,s1,s2,"9-8 10-8 17-8 ")

def tgr_140(s0,s1,s2):  #thai rear gap
    return tg_0(s0,s1,s2,"9-8 16+8 ")

def tgr_160(s0,s1,s2):
    return tg_0(s0,s1,s2,"16+8 ")


def hf1(s0,s1,s2,s3,s4,s5,s1s=-1,s2s=-1,s3s=-1,s4s=-1,s5s=-1,dstr1="9-8 10-8 11-8 19+8 ",add1=""):
    #front h for tho_thahan, po_pan, no_nu, etc.
    if s1s >= 0:
        add1 = pl(alignrp(s1s), add1)
    if s2s >= 0:
        add2 = shprp2(s2s)
    else:
        add2 = ""
    add3 = xhead1(s3,s4,s5,s1s=s3s,s2s=s4s,s3s=s5s) 
    return pl(""
        , srp0(s0)
        , mdrp0rw(s1,dstr1)
        , add1
        , tstemw_1(s2)
        , add2
        , add3
        )

def hf_ko_kai(s0, s1,s2, s3,s4, s5,s6):
    return pl(""
        , tgf_162(s0,s1,s2)
        , mdrp0g(s3,"9+4 10+4 14+4 15+4 16+4 17+4 18+4 ")
        , mdrpg(s4)
        , srp0(s2)
        , mdrpg(s5)
        , add_ip(s3,s2,[s6])
        , dx(s6,-8)
        )


def hf_kho_khai(s0,s1,t1, s2,li):
    return pl(""
        , srp0(s0)
        , mdrp0rw(s1,"15+8 16+8 17+8 18+8 19+8 ")
        , tstemw_1(t1)
        #, head1(s2,li)
        , mirp0rg('headdia',s2,ds_headdia)
        , xhead0(li[1],li[0],direction='-')
        )

def hr_kho_khai(s0,s1,s2,s3,s4,s5,s6,add1="",add6=""):
    return pl(""
        , tgr_160(s0,s1,s2)
        , add1
        , mdrp0rg(s3,"13-8 ")
        , tstemw_1(s4)
        , mdrp0rg(s5,"10+8 11+8 13+8 14+8 15+8 16+8 ")
        , tstemw_1(s6)
        , add6
        )

def hr_cho_chang(s0,s1,s2, t11,t12, s3,s4,s5,s6, i56, s7):
    return hr_kho_khai(s0,s1,s2,s3,s4,s5,s6,
            add1=pl(""
                , mdrp0mrg(t11)
                , tstemw_1(t12)
                , srp0(s1)
                ),
            add6=pl(""
                , f_ip([i56])
                , srp0(s6)
                , mdrpg(s7,"13-4 14-8 15-8 16-8 ")
                )
            )

def hf_kho_khwai(s0, s1,s2, s3,s4, i4, s5,s6,li6,ds5="15-8 16-8 28-8 29-8 "):
    return pl(""
        , tgf_112(s0,s1,s2)
        , mdrp0rg(s3,"10-8 ")
        , tstemw_1(s4)
        , add_ip(s2,s4,[i4])
        , srp0(s1)
        , mdrp0rg(s5,ds5)
        , head1(s6,li6)
        )

def hr_no_nu(s0, s1,s2, s3,s4,li):
    return pl(""
        , srp0(s0)
        , mdrp0rg(s1,"9-8 10-8 11-8 22+8 27+8 ")
        , tstemw_1(s2)
        , mdrp0rg(s3,"14-8 15-8 16-8 20-8 21-8 22-8 25-8 26-8 27-8 30-8 31-8 ")
        , head2(s4,li)
        )

def hf_pho_samphao(s0, s1,s2, s3,s4,s5, s6,s7,s8,s9):
    return pl(""
        , hf1(s0, s1,s2, s3,s4,s5)
        , srp0(s1)
        , mdrp0g(s6)
        , mdrpg(s7)
        , srp0(s2)
        , mdrp0g(s8)
        , mdrpg(s9)
        )

#================================================
pseudo_code_dict = {

    'uni0E01':      #KO KAI
        packline(""
        , hf_ko_kai(25, 14,12, 18,17, 10,8)
        , tgr_140(26, 1,24)
        , add_ip(14,24,[5,21])
        , ix()
        #y
        , sy()
        , mdap(1)
        , alignrp(13)
        , tvtc2(21,[15,12,2,24, 18,8,17,9,10])
        , tstemt_2(5)
        , iy()
        ),

    'uni0E02':    #KHO KHAI
        packline(""
        , hf_kho_khai(44, 19,10, 13, [41,35])
        , hr_kho_khai(45, 29,31, 1,28, 4,25)
        , ix()
        , dh2(16)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(28)
        , tvt2(31)
        , v_head_kho_khai(22,[2,27,4,25], 7, 10,16,[32,38])
        , iy()
        , dh2(13)
        ),

    'uni0E03':    #KHO KHUAT
        packline(""
        , hf_kho_khai(50, 23,12, 17, [47,41])
        , hr_kho_khai(51, 35,37, 1,34, 4,31)
        , add_ip(23,31, [26,27,28, 7,8,9])
        , ix()
        , dh1(14)
        , dh2(20)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(34)
        , tvt2(37)
        , v_head_kho_khuat(28,26,[4,31,2,33], 7,9, 8,27, 14,20,[38,44])
        , iy()
        , dh2(17)
        ),

    'uni0E04':    #KHO KHWAI
        packline(""
        , hf_kho_khwai(55, 36,8, 30,29, 11, 14,20,[52,46,26])
        , tgr_140(56,1,42)
        , add_ip(36,42,[39,5])
        , ix()
        , dh1(17)
        , dh2(23)
        #y
        , sy()
        , mdap(1)
        , alignrp(29)
        , v_top_kho_khwai(39,[36,8,11,2,42],5, 17,23,[43,49,26,14])
        , dx(26,12)
        , dx(11,-16)
        , iy()
        , dh2(20)
        ),

    'uni0E05':    #KHO KHON
        packline(""
        , hf_kho_khwai(55, 36,8, 30,29, 11, 14,20,[52,46,26])
        , tgr_140(56,1,42)
        , add_ip(36,42,[38,39,40,4,5,6])
        , ix()
        , dh1(17)
        , dh2(23)
        #y
        , sy()
        , mdap(1)
        , alignrp(29)
        , v_top_kho_khon(40,38,[36,8,11,2,42],4,6, 5,39, 17,23,[43,49,26,14])
        , dx(26,12)
        , dx(11,-16)
        , iy()
        , dh2(20)
        ),

    'uni0E06':    #KHO RAKHANG
        packline(""
        , hf_kho_khai(74,35,24, 29,[59,53])
        , tgr_160(75,47,49)
        , alignrp(1)
        , mdrp0rg(13,"24+8 ")
        , tstemw_1(45)
        , shprp2(2)
        , xhead1(8,71,65)
        , srp0(13)
        , mdrp0rg(16,"15+8 ")
        , tstemw_1(43)
        , add_ip(35,43,[38,39,40,19,20,21])
        , ix()
        , dh1(26,11)
        , dh2(32,5)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(47)
        , tvt2(49)
        , v_head_kho_khuat(40,38,[16,43,14,45], 19,21, 20,39, 26,32,[50,56])
        , srp0(1)
        , tvbc(5)
        , head1(11,[62,68, 46,2])
        , iy()
        , dh2(29)
        , dh1(8)
        ),

    'uni0E07':    #NGO NGU
        packline(""
        , mdapr(4)
        #
        , tgr_140(41,12,24)
        , xhead1(18,37,31)
        , add_ip(4,24,[0,9,3])
        , srp0(3)
        , tstemw_1(6)
        , ix()
        , dh1(21)
        , dh2(15)
        #y
        , sy()
        , mdapr(40)
        , tvtc2(21,[4,12,25])
        , head2(15,[28,34])
        , srp0(40)
        , tvbc(0)
        , tstemtc_1(9)
        , mdapr(4)
        , iy()
        , dh1(18)
        ),

    'uni0E08':    #CHO CHAN
        packline(""
        , mdapr(30)
        , mdrpg(29)
        #
        , tgr_140(53, 22,36)
        , tstemw_1(36)
        , mdrp0rg(3)
        , tstemw_1(15)
        , xhead1(9,49,43)
        , add_ip(3,36,[0,19])
        , add_ip(30,36,[26,33])
        , ix()
        , dh1(12)
        , dh2(6)
        #y
        , sy()
        , mdap(52)
        , tvtc2(33,[29,3,16,22,37,23,36])
        , tstemt_2(26)
        , mdrp0rg(12,"12-8 ")
        , head2(6,[40,46])
        , srp0(52)
        , tvbc(0)
        , tstemt_1(19)
        , mdapr(29)
        , iy()
        , dh1(9)
        ),

    'uni0E09':    #CHO CHING
        packline(""
        , mdapr(1,"9-8 10-8 11-8 12-8 13-8 ")
        , tstemw_1(14)
        , shprp2(0)
        , xhead1(7,51,45)
        , mdrprg(24)
        #
        , hr_no_nu(67, 16,31, 35,41,[63,57])
        , ix()
        , dh1(10)
        , dh2(4,38)
        #y
        , sy()
        , mdap(0)
        , tstemt_1(15)
        , tvtc2(27,[17,31,23])
        , tstemt_2(20)
        , mdapr(23)
        , mdrp0mrw(10)
        , head2(4,[42,48])
        , srp0(0)
        , tvbc(38)
        , head1(32,[54,60,41,16])
        , iy()
        , dh1(7)
        , dh2(35)
        ),

    'uni0E0A':    #CHO CHANG
        packline(""
        , hf_kho_khai(56, 19,10, 13, [53,47])
        , hr_cho_chang(57, 37,36, 28,30, 1,42, 4,25,40, 34)
        , dx(34,-8)
        , ix()
        , dh2(16)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(43)
        , v_head_kho_khai(22,[2,42,38,36,4,25,40,34], 7, 10,16,[44,50],
            add1=mdrpmrg(30))
        , f_dstr(25,"14-3 15-3 16-3 ")
        , iy()
        , dh2(13)
        ),

    'uni0E0B':    #SO SO
        packline(""
        , hf_kho_khai(62, 23,12, 17, [59,53])
        , hr_cho_chang(63, 43,42, 34,36, 1,49, 4,31,46, 40)
        , add_ip(23,31, [26,27,28,7,8,9])
        , dx(40,-8)
        , ix()
        , dh1(14)
        , dh2(20)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(49)
        , v_head_kho_khuat(28,26,[2,48,44,42,4,31,46,40], 7,9, 8,27, 14,20,[50,56],
            add1=mdrpmrg(36))
        , f_dstr(31,"14-3 15-3 16-3 ")
        , iy()
        , dh2(17)
        ),

    'uni0E0C':    #CHO_CHOE
        packline(""
        , hf_ko_kai(73, 34,22, 38,37, 20,18)
        , srp0(34)
        , xhead2(28,52,58)
        #
        #, hr_cho_choe(74, 46,1,48, 11,44, 8,2,[70,64])
        , tgr_160(74, 46,48)
        , alignrp(1)
        , ip_round(34,46,11)
        , tstemw_1(44)
        , ip_round(28,11,8,"13+8 ")
        , head1(2,[70,64])
        #
        , add_ip(38,44,[41,15])
        , ix()
        , dh1(25)
        , dh2(31,5)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(46)
        , tvt2(48)
        , tvtc2(41,[35,37,38,18,19,20, 12,44])
        , tstemt_2(15)
        , srp0(1)
        , tvbc(31)
        , alignrp(5)
        , head1(25,[49,55,11,2],ss=45,l1s=61,l2s=67) 
        , f_dstr(2,"14+3 15+3 16+3 ")
        , iy()
        , dh1(8)
        , dh2(28)
        ),

    'uni0E0D.descless':    #YO YING
        packline(""
        , hf_ko_kai(51, 24,12, 28,27, 10,8)
        , srp0(24)
        , xhead2(18,42,48)
        #
        , tgr_160(52,36,38)
        , ip_round(24,36,1)
        , tstemw_1(34)
        #
        , add_ip(28,34,[31,5])
        , ix()
        , dh1(15)
        , dh2(21)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(35)
        , tvt2(38)
        , tvtc2(31,[25,27,28, 8,9,10,12, 2,34])
        , tstemt_2(5)
        , srp0(1)
        , tvbc(21)
        , head1(15,[39,45])
        , iy()
        , dh2(18)
        ),

    'desc.uni0E0D':
        packline(""
        , mdapr(17)
        , mdrp0rg(4)
        , headsara1(10,[29,23])
        , ix()
        #y
        , sy()
        , mdap(32)
        , mdrp0mrw(7)
        , mdrprg(17)
        , headsara2(2,[20,26])
        , srp0(7)
        , mdrp0rg(0)
        , stemt_sara_1(13)
        , iy()
        ),

    'uni0E0E':    #DO CHADA
        packline(""
        , hf_pho_samphao(76, 43,31, 38,63,57, 47,46, 29,27)
        , tgr_160(77, 20,53)
        , alignrp(1)
        , mdrprg(68)
        , f_ip([13,18,3])
        , mdrp0rg(8)
        , stemw_sara_1(73)
        , add_ip(47,53,[50,24])
        , dx(68,8)
        , dx(18,-8)
        , ix()
        , dh1(41,11)
        , dh2(35,5)
        #y
        , sy()
        , mdap(76)
        , tvtc2(50,[44,46,47, 27,28,29,31, 21,53])
        , tstemt_2(24)
        , srp0(76)
        , tvbc(35)
        , head1(41,[54,60])
        , srp0(76)
        , tvblum(5)
        , alignrp(1)
        , stemt_sara_1(66)
        , mdrp0rg(11)
        , f_ip([13,68,3,18,20])
        , stemt_sara_2(70)
        , dx(3,8)
        , dx(13,-8)
        , iy()
        , dh1(38,8)
        ),

    'uni0E0F':    #TO PATAK
        packline(""
        , hf_pho_samphao(82, 49,37, 44,69,63, 53,52, 35,33)
        , tgr_160(83, 26,59)
        , alignrp(1)
        , mdrprg(74)
        , f_ip([16,21,23,24,2,3,6])
        , mdrp0rg(11)
        , stemw_sara_1(80)
        , add_ip(53,59,[56,30])
        , dx(74,8)
        , dx(21,-8)
        , ix()
        , dh1(47,14)
        , dh2(41,8)
        #y
        , sy()
        , mdap(82)
        , tvtc2(56,[50,52,53, 33,34,35,37, 27,59])
        , tstemt_2(30)
        , srp0(82)
        , tvbc(41)
        , head1(47,[60,66])
        , srp0(82)
        , tvblum(8)
        , alignrp(4)
        , alignrp(1)
        , stemt_sara_1(72)
        , mdrp0rg(14)
        , f_ip([16,11,23,24,2,6])
        , stemt_sara_2(76)
        , dx(6,8)
        , dx(16,-8)
        , iy()
        , dh1(44,11)
        ),

    'uni0E10.descless':    #THO THAN
        packline(""
        , mdapr(26)
        , tstemw_1(48)
        #
        , srp0(65)
        , mdrpmrw(36)
        , add_ip(26,36,[29,42,39,32,22])
        , mdapr(22)
        , tstemw_1(48)
        , mdrp0rg(3)
        , tstemw_1(15)
        , xhead1(9,61,55)
        , ix()
        , dh1(12)
        , dh2(6)
        #y
        , sy()
        , mdapr(64)
        , v_top_ro_rua(29,[26,48,46,25,23,48,12], 42, 39,32,35,36)
        , mdapr(12)
        , head2(6,[52,58])
        , srp0(64)
        , tvbc(0)
        , tstemt_1(19)
        , iy()
        , dh1(9)
        ),

    'desc.uni0E10':
        packline(""
        , mdap(38)
        , stemw_sara_2(26)
        , headsara2(32,[48,42])
        , mdrp0rg(21)
        , add_ip(21,26,[23,24,25,1,2,3,4])
        , headsara2(11,[58,53,16,6])
        , ix()
        #y
        , sy()
        , mdap(61)
        , mdrp0mrw(35)
        , headsara2(29,[39,45])
        , mdrp0rg(1)
        , alignrp(4)
        , alignrp(8)
        , stemt_sara_1(26)
        , shprp2(23)
        , headsara1(14,[51,55])
        , iy()
        ),

    'uni0E11':    #THO NANGMONTHO
        packline(""
        , hf_kho_khai(59,30,19, 24, [56,50])
        , tgr_140(60,1,46)
        , add_ip(30,1,[8])
        , mdapr(8,"14+8 ")
        , add_ip(8,1,[42,7])
        , tstemw_1(40)
        , mdrp0rg(11)
        , tstemw_1(38)
        , srp0(42)
        , stemw_sara_1(6)
        , add_ip(30,38, [33,34,35, 14,15,16])
        , ix()
        , dh1(21)
        , dh2(27)
        #y
        , sy()
        , mdap(1)
        , alignrp(7)
        , tstemt_1(41)
        , v_head_kho_khuat(35,33,[9,40,11,38,42,6,2,46], 14,16, 15,34, 21,27,[47,53], add1=pl( alignrp(44), tstemt_2(4)))
        , iy()
        , dh2(24)
        ),

    'uni0E12':    #THO PHUTHAO
        packline(""
        , hf_kho_khwai(80, 45,18, 39,38,23, 29,35,[65,59],
            ds5="9+8 17+8 18+8 ")
#
        , tgr_160(81, 53,55)
        , alignrp(1)
        , ip_round(39,53,11,"10+8 ")
        , tstemw_1(51)
        , ip_round(39,11,8)
        , head1(2,[77,71])
        , add_ip(45,51,[47,48,49,14,15,16])
        , ix()
        , dh1(32)
        , dh2(5)
        , f_dstr(27,ds_dryhead)
        #y
        , sy()
        , mdap(1)
        , alignrp(38)
        , tstemt_1(23)
        , shprp2(53)
        , tvt2(55)
        , v_top_kho_khon(49,47,[45,18,12,51], 14,16, 15,48, 32,26,[56,62])
        , srp0(1)
        , tvbc(5)
        , head1(11,[68,74,52,2])
        , f_dstr(2,"15+4 16+6 ")
        , iy()
        , dh1(29,8)
        , dh2(35)
        ),

    'uni0E13':    #NO NEN
        packline(""
        , hf_ko_kai(73, 24,12, 28,27, 10,8)
        , srp0(24)
        , xhead2(18,52,58)
        #
        , hr_no_nu(74,36,38, 42,48,[70,64])
        , srp0(36)
        , ip_round(24,36,1)
        , tstemw_1(34)
        , shprp2(0)
        , add_ip(28,34,[31,5])
        , ix()
        , dh1(15)
        , dh2(21,45)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(35)
        , tvt2(38)
        , tvtc2(31,[25,37,28,8,9,10,12,2,34])
        , tstemt_2(5)
        , srp0(1)
        , tvbc(21)
        , alignrp(45)
        , head1(15,[49,55,36,48], ss=39,l1s=61,l2s=67)
        , iy()
        , dh2(18,42)
        ),

    'uni0E14':    #DO DEK
        packline(""
        , hf_kho_khwai(54, 35,8, 29,28,13, 19,25,[51,45,16])
        , tgr_140(55, 1,41)
        , add_ip(35,41,[38,5])
        , ix()
        , dh1(22)
        , f_dstr(17,ds_dryhead)
        #y
        , sy()
        , mdap(1)
        , alignrp(28)
        , tstemt_1(13)
        , v_top_kho_khwai(38,[35,8,2,41],5,22,16,[42,48])
        , iy()
        , dh1(19)
        , dh2(25)
        ),

    'uni0E15':    #TO TAO
        packline(""
        , hf_kho_khwai(54, 35,8, 29,28,13, 19,25,[51,45,16])
        , tgr_140(55, 1,41)
        , add_ip(35,41,[37,38,39,4,5,6])
        , ix()
        , dh1(22)
        , f_dstr(17,ds_dryhead)
        #y
        , sy()
        , mdap(1)
        , alignrp(28)
        , tstemt_1(13)
        , v_top_kho_khon(39,37,[35,8,2,41], 4,6, 5,38, 22,16,[42,48])
        , iy()
        , dh1(19)
        , dh2(25)
        ),

    'uni0E16':      #THO THUNG
        packline(""
        , hf_ko_kai(47, 24,12, 28,27, 10,8)
        , srp0(24)
        , xhead2(18,38,44)
        , tgr_140(48,1,34)
        , ix()
        , dh1(15)
        , dh2(21)
        #y
        , sy()
        , mdap(1)
        , tvtc2(31,[25,27,28,8,9,10,12,2,34])
        , tstemt_2(5)
        , srp0(1)
        , tvbc(21)
        , head1(15,[35,41])
        , iy()
        , dh2(18)
        ),

    'uni0E17':      #THO THAHAN
        packline(""
        , hf1(43, 10,22, 16,40,34, s2s=9)
        , tgr_140(44, 1,30)
        , add_ip(10,30,[8])
        , srp0(8)
        , stemw_sara_2(24)
        , ix()
        , dh1(19)
        , dh2(13)
        #y
        , sy()
        , mdap(1)
        , alignrp(9)
        , tvtc2(19,[23,24,8,2,30])
        , alignrp(27)
        , tstemt_2(5)
        , head2(13,[31,37])
        , f_dstr(23,"14-4 15-5 16-6 ")
        , iy()
        , dh1(16)
        ),

    'uni0E18':      #THO THONG
        packline(""
        , mdap(9,"19+8 ")
        , tstemw_1(28)
        , mdrp0rg(1,"21-8 22-8 23-8 ")
        , tstemw_1(3)
        #
        , srp0(33)
        , mdrp0mrw(19)
        , tgr_160(33,5,31)
        , add_ip(9,19,[12,25,22,15])
        , ix()
        #y
        , sy()
        , mdap(1)
        , tstemt_1(4)
        , v_top_ro_rua(12,[9,28,29,8,6,31,2], 25,22,15,18,19)
        , mdapr(2)
        , iy()
        ),

    'uni0E19':      #NO NU
        packline(""
        , hf1(52,1,13,7,37,31, s2s=0)
        , hr_no_nu(53, 15,17, 21,27,[49,43])
        , ix()
        , dh1(10)
        , dh2(24,4)
        #y
        , sy()
        , mdap(0)
        , tstemt_1(14)
        , tvt2(17)
        , tvtc2(10)
        , head2(4,[28,34])
        , srp0(0)
        , tvbc(24)
        , head1(18,[40,46,15,27])
#        , f_dstr(27,"15+4 16+4 ")
        , iy()
        , dh1(7)
        , dh2(21)
        ),  

    'uni0E1A':      #BO BAIMAI
        packline(""
        , hf1(30, 1,13,7,27,21)
        , tgr_160(31, 15,17)
        , ix()
        , dh1(10)
        , dh2(4)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(14)
        , tvt2(17)
        , tvtc2(10)
        , head2(4,[18,24])
        , iy()
        , dh1(7)
        ),

    'uni0E1B':      #PO PLA
        packline(""
        , hf1(30, 1,13,7,27,21)
        , tgr_160(31, 15,17)
        , ix()
        , dh1(10)
        , dh2(4)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(14)
        , tvtpo(17)
        , tvtc2(10)
        , head2(4,[18,24])
        , iy()
        , dh1(7)
        ),

    'uni0E1C':      #PHO PHUNG
        packline(""
        , tgf_148(35,4,16)
        , shprp2(3)
        , xhead2(11,26,32)
        #
        , tgr_160(36,20,22)
        , add_ip(4,22,[3,2,1,18,19,2])
        , ix()
        , dh1(8)
        , dh2(14)
        #y  
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvt2(22)
        , tvtc2(8,[17])
        , head2(14,[23,29])
        , add_ip(14,1,[18,2])
        , f_dstr(17,"14-4 15-5 16-6 ")
        , srp0(17)
        , alignrp(20)
        , iy()
        , dh2(11)
        ),  

    'uni0E1D':      #FO FA
        packline(""
        , tgf_148(35,4,16)
        , shprp2(3)
        , xhead2(11,26,32)
        #
        , tgr_160(36,20,22)
        , add_ip(4,22,[3,2,1,18,19,2])
        , ix()
        , dh1(8)
        , dh2(14)
        #y  
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvtpo(22)
        , tvtc2(8,[17])
        , head2(14,[23,29])
        , add_ip(14,1,[18,2])
        , f_dstr(17,"14-4 15-5 16-6 ")
        , srp0(17)
        , alignrp(20)
        , iy()
        , dh2(11)
        ),  

    'uni0E1E':      #PHO PHAN
        packline(""
        , hf1(35,4,16,10,32,26,s2s=3)
        , tgr_160(36,20,22)
        , alignrp(1)
        , add_ip(16,20,[18,19,2])
        , ix()
        , dh1(13)
        , dh2(7)
        #y
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvt2(22)
        , tvtc2(13,[2,17,18,19,20])
        , head2(7,[23,29])
        , iy()
        , dh1(10)
        , f_dstr(2,"14+3 15+3 16+6 ")
        ),

    'uni0E1F':      #FO FAN
        packline(""
        , hf1(35,4,16,10,32,26,s2s=3)
        , tgr_160(36,20,22)
        , alignrp(1)
        , add_ip(16,20,[18,19,2])
        , ix()
        , dh1(13)
        , dh2(7)
        #y
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvtpo(22)
        , tvtc2(13,[2,17,18,19,20])
        , head2(7,[23,29])
        , iy()
        , dh1(10)
        , f_dstr(2,"14+3 15+3 16+6 ")
        ),

    'uni0E20':    #PHO SAMPHAO
        packline(""
        , hf_pho_samphao(47, 24,12, 19,44,38, 28,27, 10,8)
        , tgr_160(48,1,34)
        , add_ip(28,34,[31,5])
        , ix()
        , dh1(22)
        , dh2(16)
        #y
        , sy()
        , mdap(1)
        , tvtc2(31,[25,27,28, 8,9,10,12, 2,34])
        , tstemt_2(5)
        , srp0(1)
        , tvbc(16)
        , head1(22,[35,41])
        , iy()
        , dh1(19)
        ),

    'uni0E21':      #MO MA
        packline(""
        , hf1(54, 13,25,19,39,33,s2s=2,s3s=8,s4s=51,s5s=45)
        , tgr_160(55, 27,29)
        , alignrp(1)
        , ix()
        , dh1(22,11)
        , dh2(16,5)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(27)
        , tvt2(29)
        , tvtc2(22)
        , head2(16,[30,36])
        , srp0(1)
        , tvbc(5)
        , head1(11,[42,48,26,2])
        , iy()
        , dh1(19,8)
        , f_dstr(2,"14+3 15+3 16+3 ")
        ),
    
    'uni0E22':    #YO YAK
        packline(""
        , mdapr(1,"9-8 10-8 11-8 ")
        , alignrp(8)
        , tstemw_1(27)
        , shprp2(19)
        , mdrprg(24)
        , f_ip([5])
        , xhead2(14,35,41,dstr="12-8 13-8 15-8 16-8 23-8 ")
        #
        , tgr_160(45,29,31)
        , ix()
        , dh1(11)
        , dh2(17)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(28)
        , tvt2(31)
        , tvtc2(11)
        , head2(17,[32,38,19])
        , mdrp0mrg(23)
        , tstemt_2(24)
        , f_ip([5])
        , iy()
        , dh2(14)
        ),

    'uni0E23':    #RO RUA
        packline(""
        , mdapr(12)
        , tstemw_1(31)
        , srp0(51)
        , mdrp0mrw(22)
        , add_ip(12,22,[15,28,25,18,8])
        , mdapr(8)
        , tstemw_1(34)
        , xhead1(3,47,41)
        , ix() 
        , dh1(6)
        , dh11(1), dh12(37)
        #y
        , sy() 
        , mdap(50)
        , v_top_ro_rua(15,[12,31,32,11,9,34], 28, 25,18,21,22)
        , srp0(50)
        , tvbc(0)
        , head1(6,[38,44])
        , iy()
        , dh1(3)
        ),  

    'uni0E24':      #RU
        packline(""
        , hf_ko_kai(47, 24,12, 28,27, 10,8)
        , srp0(24)
        , xhead2(18,38,44)
        , tgr_140(48,1,34)
        , ix()
        #y
        , sy()
        , mdap(47)
        , tvtc2(31,[25,27,28,8,9,10,12,2,34])
        , tstemt_2(5)
        , srp0(47)
        , tvbc(21)
        , head1(15,[35,41])
        , srp0(47)
        , tvblu(1)
        , iy()
        , dh2(18)
        ),

    'uni0E25':      #LO LING
        packline(""
        , tgf_162(54,20,8)
        , mdrprg(35)
        , xhead2(14,45,51)
        #
        , tgr_140(55,1,41)
        , alignrp(27)
        , add_ip(7,27,[24,5])
        , add_ip(35,41,[38,31])
        , ix()
        , dh1(11)
        , dh2(17)
        #y
        , sy()
        , mdap(1)
        , tvtc2(38,[21,8,28,41,7,24,34])
        , tstemt_2(31)
        , mdapr(34)
        , mdapr(24)
        , tstemt_2(5)
        , srp0(1)
        , tvbc(17)
        , head1(11,[42,48])
        , iy()
        , dh2(14)
        ),

    'uni0E26':    #LU
        packline(""
        , hf_pho_samphao(47, 24,12, 19,44,38, 28,27, 10,8)
        , tgr_160(48,1,34)
        , add_ip(28,34,[31,5])
        , ix()
        , dh1(22)
        , dh2(16)
        #y
        , sy()
        , mdap(47)
        , tvtc2(31,[25,27,28, 8,9,10,12, 2,34])
        , tstemt_2(5)
        , srp0(47)
        , tvbc(16)
        , head1(22,[35,41])
        , srp0(47)
        , tvblu(1)
        , iy()
        , dh1(19)
        ),

    'uni0E27':    #WO WAEN
        packline(""
        , mdapr(16)
        , tgr_140(39,8,22)
        , xhead1(3,35,29)
        , add_ip(16,22,[19,12])
        , ix()
        , dh1(6)
        , dh11(1), dh12(23)
        #y
        , sy()
        , mdap(38)
        , tvtc2(19,[9,22,15])
        , tstemt_2(12)
        , mdapr(15)
        , srp0(38)
        , tvbc(0)
        , head1(6,[26,32])
        , iy()
        , dh1(3)
        ),  

    'uni0E28':    #SO SALA
        packline(""
        , hf_kho_khwai(67, 42,14, 36,35,17, 20,26,[64,58,32])
        , tgr_140(68,1,54)
        , mdrp0rg(49)
        , mdrpg(50)
        , add_ip(42,54,[45,11,9,47,4,52])
        , dx(9,8)
        , dx(52,-8)
        , ix()
        , dh1(23)
        , dh2(29)
        #y
        , sy()
        , mdap(1)
        , alignrp(35)
        , v_top_kho_khwai(45,[42,14,2,54,47,9,52,4,17], 11, 23,29,[55,61,32,20],add1=mdrpmrg(50))
        , dx(32,8)
        , dx(17,-16)
        , dx(4,8)
        , dx(47,-8)
        , iy()
        , dh2(26)
        , f_dstr_dict({47:"14-4 15-4 16-4 ", 4:"14+4 15+4 16+4 "})
        ),

    'uni0E29':      #SO RUSI
        packline(""
        , hf1(65, 1,13,7,50,44)
        #
        , tgr_160(66, 15,40)
        , alignrp(32)
        , shprp2(34)
        , mdrp0mrw(27)
        , mdrprg(21)
        , f_ip([62,56,30])
        , ix()
        , dh1(10,24)
        , dh2(4)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(14)
        , tvt2(34)
        , tvtc2(10,[24])
        , head2(4,[41,47])
        , mdapr(24)
        , mdrp0rg(18)
        , f_ip([53,59,30,32,16,40,35])
        , dx(16,8)
        , dx(35,-8)
        , iy()
        , dh1(7,21)
        ),

    'uni0E2A':      #SO SUA
        packline(""
        , tgf_162(66,20,8)
        , mdrprg(41)
        , xhead2(14,57,63)
        #
        , tgr_140(67,1,53)
        , alignrp(27)
        , mdrp0rg(48)
        , mdrpg(49)
        , add_ip(8,27,[24,5])
        , add_ip(41,53,[44,37,35,46,51,30])
        , dx(35,8)
        , dx(51,-8)
        , ix()
        , dh1(11)
        , dh2(17)
        #y
        , sy()
        , mdap(1)
        , tvtc2(44,[21,8,28,53,8,24,40,27])
        , mdrpmrg(49)
        , tstemt_2(37)
        , mdapr(40)
        , mdapr(24)
        , tstemt_2(5)
        , srp0(1)
        , tvbc(17)
        , head1(11,[54,60])
        , dx(30,8)
        , dx(46,-8)
        , iy()
        , dh2(14)
        , f_dstr_dict({46:"14-4 15-4 16-4 ", 30:"14+4 15+4 16+4 "})
        ),

    'uni0E2B':      #HO HIP
        packline(""
        , hf1(61, 8,20, 14,46,40, s2s=7)
        , tgr_140(62, 1,36)
        , mdrp0rg(32)
        , head2(26,[58,52,24,34,4])
        , add_ip(8,36,[6])
        , srp0(6)
        , stemw_sara_2(22)
        , f_dstr(26,"9-8 ")
        , ix()
        , dh1(17,29)
        , dh2(11)
        #y
        , sy()
        , mdap(1)
        , alignrp(7)
        , tvtc2(17,[21,22,6,2,36])
        , alignrp(29)
        , head2(11,[37,43],l1s=49,l2s=55)
        , srp0(49)
        , tstemt_2(4)
        , f_ip([24,34])
        , f_dstr(21,"14-4 15-5 16-6 ")
        , iy()
        , dh1(14,26)
        , dh2(32)
        ),

    'uni0E2C':      #LO CHULA
        packline(""
        , hf1(64, 4,16,10,49,43,s2s=3)
        , tgr_160(65, 20,39)
        , alignrp(1)
        , xhead1(26,61,55)
        , add_ip(16,20,[18,19,2])
        , ix()
        , dh1(13,29)
        , dh2(7,23)
        #y
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvtc2(13,[2,17,18,19,20])
        , head2(7,[40,46])
        , srp0(1)
        , mirp0rg("ecvheight_shoot",29)
        , head2(23,[52,58,39,32])
        , iy()
        , dh1(10,26)
        , f_dstr(2,"14+3 15+3 16+6 ")
        ),

    'uni0E2D':      #O ANG
        packline(""
        , tgf_162(42,1,13)
        , mdrprg(23)
        , xhead2(8,33,39)
        #
        , tgr_140(43,15,29)
        , add_ip(23,29,[26,19])
        , ix()
        , dh1(5)
        , dh2(11)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(14)
        , tvtc2(26,[22,16,29])
        , tstemt_2(19)
        , mdapr(22)
        , mdrp0mrw(5)
        , head2(11,[30,36])
        , iy()
        , dh2(8)
        ),  

    'uni0E2E':      #HO NOKHUK
        packline(""
        , mdapr(1,"9-8 10-8 11-8 ")
        , alignrp(23)
        , tstemw_1(13)
        , xhead2(8,39,45)
        , srp0(23)
        , tstemw_1(55)
        #
        , tgr_140(58,15,35)
        , add_ip(23,35,[26,52,48,20,50,28,33,18])
        , dx(50,24)
        , dx(33,-16)
        , ix()
        , dh1(5)
        , dh2(11)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(14)
        , tvtc2(26,[16,35])
        , tstemt_2(52)
        , mdrp0rg(20)
        , f_ip([28,50,33,18])
        , stemt_sara_1(48)
        , mdrp0mrw(5)
        , head2(11,[36,42])
        , iy()
        , dh2(8)
        ),

    'uni0E2F':      #PAIYAN NOI
        packline(""
        , tgr_160(37,1,23)
        , alignrp(22)
        , mdrp0rg(8)
        , f_ip([5,19])
        , head1(14,[33,27,17])
        , ix()  
        , dh1(11)
        #y  
        , sy()
        , mdap(1)
        , tvt2(23)
        , tvtc2(11,[2])
        , head2(17,[24,30])
        , mdrp0rg(19)
        , tstemt_2(5)
        , iy()
        , dh2(14)
        ),  

    'uni0E30':      #SARA A
        packline(""
        , mdap(3,"9-8 10-8 11-8 ")
        , alignrp(33)
        , mdrprg(15)
        , shprp2(45)
        , head1(9,[27,21],ss=39,l1s=57,l2s=51)
        , ix()
        , dh1(36,6)
        #y  
        , sy()
        , mdapr(0)
        , tstemt_1(11)
        , xhead2(6,24,18,dstr="11-8 16-8 ")
        , mdrprg(14)
        #
        , mdapr(30,"11+8 ")
        , tstemt_1(41)
        , xhead2(36,54,48,dstr="11-8 16-8 ")
        , mdrprg(44)
        , iy()
        , dh1(3,33)
        , dh2(39,9)
        ),

    'uni0E31':      #MAI HAN-AKAT
        packline(""
        , mdap(3)
        , mdrprg(15)
        , head1(9,[27,21])
        , ix()
        , dh1(6)
        #y  
        , sy()
        , tvtsara(0)
        , tstemt_1(11)
        , xhead2(6,24,18)
        , mdrprg(14)
        , iy()
        , dh1(3)
        , dh2(9)
        ),

    'uni0E32':    #SARA AA
        packline(""
        , mdapr(9)
        , tgr_140(16,1,15)
        , add_ip(9,15,[12,5])
        , ix()
        #y
        , sy()
        , mdap(1)
        , tvtc2(12,[8,2,15])
        , tstemt_2(5)
        , mdapr(8)
        , iy()
        ),  

    'uni0E34':    #SARA I
        packline(""
        , mdap(0)
        , tstemw_2(9)
        , mdrp0rg(3)
        , tstemw_1(15)
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , mirp0rg("tstemw",15)
        , f_ip([3,9])
        , mdrp0rw(12)
        , stemw_sara_1(6)
        , iy()
        ),
    
    'uni0E35':    #SARA II
        packline(""
        , mdap(0)
        , tstemw_2(12)
        , tstemtc_2(10)
        , mdrp0rg(3)
        , tstemw_1(18)
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , mirp0rg("tstemw",18)
        , f_ip([3,12])
        , mdrp0rw(15)
        , stemw_sara_1m(6)
        , mdrpmrg(11)
        , mdapr(11)
        , iy()
        ),
    
    'uni0E36':    #SARA UE
        packline(""
        , mdap(0)
        , tstemw_2(19)
        , mdrp0mrg(14)
        , headsara2(8,[37,31])
        , srp0(0)
        , mdrp0rg(3)
        , tstemw_1(25)
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , mirp0rg("tstemw",25)
        , f_ip([3,19])
        , mdrp0mrg(22)
        , stemw_sara_1m(6)
        , mdrp0rw(11)
        , mdapr(11)
        , headsara2(17,[28,34])
        , iy()
        ),

    'uni0E37':    #SARA UUE
        packline(""
        , mdap(0)
        , tstemw_2(16)
        , tstemt_2m(14)
        , mdrp0mrg(11)
        , mdapr(11)
        , tstemt_2(9)
        , srp0(0)
        , mdrp0rg(3)
        , tstemw_1(22)
        , ix()
        #y  
        , sy()   
        , tvtsara(0)
        , mirp0rg("tstemw",22)
        , f_ip([3,16])
        , mdrp0rw(19)
        , f_ip([11,13])
        , stemw_sara_1m(6)
        , mdrpmrg(10)
        , mdapr(10)
        , shprp2(15)
        , iy()
        ),  

    'uni0E38':    #SARA U
        packline(""
        , mdapr(13)
        , stemw_sara_2(1)
        , mdrpmrg(7)
        , f_ip([23,17])
        , ix()
        #y  
        , sy()
        , mdap(26) 
        , mdrp0mrw(10)
        , head_sara_2m(4)
        , f_ip([14,20])
        , mdrpmrg(1)
        , iy()
        ),  

    'uni0E39':    #SARA UU
        packline(""
        , mdap(17)
        , stemw_sara_2m(15)
        , mdrp0mrw(13)
        , mdapr(13)
        , stemw_sara_2(1)
        , mdrpmrg(7)
        , f_ip([27,21])
        , ix() 
        #y  
        , sy()
        , mdap(30)
        , mdrp0mrw(10)
        , mdrprg(17)
        , mdrp0rg(4)
        , alignrp(14)
        , f_ip([24,18])
        , stemt_sara_2(1)
        , iy()
        ),

    'uni0E3A':    #PHINTHU
        packline(""
        , mdap(9)
        , mdrpmrg(3)
        , ix() 
        #y  
        , sy()
        , mdap(12)
        , mdrp0mrw(6)
        , mdrpmrg(0)
        , iy() 
        ),

#    'uni0E3F':    #THAI CURRENCY SYMBOL BAHT
#        packline(""
#        , mdap(9,"11-8 12-8 13-8 14-8 ")
#        , tstemw_1(54)
#        , shprp2(50)
#        , mdrprg(6)
#        , shprp2(13)
#        #
#        , mdrp0rg(52,"11+8 ")
#        , alignrp(48)
#        , alignrp(2)
#        , alignrp(16)
#        , tstemw_1(64)
#        , shprp2(47)
#        , shprp2(36)
#        , shprp2(21)
#        #
#        , mdrp0rg(60)
#        , f_ip([29])
#        , tstemw_1(32)
#        , mdrp0rg(43,"12+8 ")
#        , tstemw_1(26)
#        , ix() 
#        #y  
#        , sy()
#        , mdap(3)
#        , alignrp(36)
#        , mdrprg(0)
#        , tstemt_1(52)
#        , shprp2(56)
#        , shprp2(9)
#        #
#        , mdrp0rg(53)
#        , f_ip([60,32])
#        , alignrp(64)
#        , tstemt_1(48)
#        , f_ip([29])
#        , shprp2(39)
#        #
#        , mdrp0rg(16)
#        , f_ip([43,26])
#        , alignrp(22)
#        , mdrprg(19)
#        , tstemt_2(49)
#        , shprp2(10)
#        , shprp2(47)
#        , iy() 
#        ), 
#
#MODIFY AUTO-INSTUCTION: uni0E3F
    'uni0E3F':    #THAI CURRENCY SYMBOL BAHT
        """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   3 1 0     ;PUSH Bytes
CALL            0 1 3      ;CALL function
                           #--- PUSHB_1   21        ;PUSH Bytes
SHP[rp1]        21         ;SHift Point using reference point
                           #--- PUSHB_2   26 13     ;PUSH Bytes
MIRP[min,black] ecstemt 26 ;Move Indirect Relative Point
                           #--- PUSHB_1   27        ;PUSH Bytes
SHP[rp2]        27         ;SHift Point using reference point
                           #--- PUSHB_3   3 26 10   ;PUSH Bytes
CALL            10 26 3    ;CALL function
                           #--- PUSHB_4   64 3 0 9  ;PUSH Bytes
CALL            9 0 3 64   ;CALL function
                           #--- PUSHB_1   25        ;PUSH Bytes
MDAP[rnd]       25         ;Move Direct Absolute Point
                           #--- PUSHB_1   33        ;PUSH Bytes
SHP[rp1]        33         ;SHift Point using reference point
                           #--- PUSHB_2   39 13     ;PUSH Bytes
MIRP[min,black] ecstemt 39 ;Move Indirect Relative Point
                           #--- PUSHB_1   40        ;PUSH Bytes
SHP[rp2]        40         ;SHift Point using reference point
                           #--- PUSHB_1   38        ;PUSH Bytes
MDAP[rnd]       38         ;Move Direct Absolute Point
                           #--- PUSHB_1   46        ;PUSH Bytes
SHP[rp1]        46         ;SHift Point using reference point
                           #--- PUSHB_2   4 13      ;PUSH Bytes
MIRP[min,black] ecstemt 4  ;Move Indirect Relative Point
                           #--- PUSHB_1   8         ;PUSH Bytes
SHP[rp2]        8          ;SHift Point using reference point
                           #--- PUSHB_3   4 38 10   ;PUSH Bytes
CALL            10 38 4    ;CALL function
                           #--- PUSHB_4   64 4 7 9  ;PUSH Bytes
CALL            9 7 4 64   ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   49        ;PUSH Bytes
MDAP[rnd]       49         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
f_deltap 3 9-8
                           #--- PUSHB_2   26 16     ;PUSH Bytes
MIRP[min,black] estemw 26  ;Move Indirect Relative Point
                           #--- PUSHB_1   38        ;PUSH Bytes
SHP[rp2]        38         ;SHift Point using reference point
                           #--- PUSHB_1   26        ;PUSH Bytes
SRP0            26         ;Set Reference Point 0
                           #--- PUSHB_2   1 1       ;PUSH Bytes
CALL            1 1        ;CALL function
                           #--- PUSHB_3   5 23 36   ;PUSH Bytes
SHP[rp2]        36         ;SHift Point using reference point
SHP[rp2]        23         ;SHift Point using reference point
SHP[rp2]        5          ;SHift Point using reference point
                           #--- PUSHB_5   0 15 0 71 4 ;PUSH Bytes
CALL            4 71 0 15 0 ;CALL function
                           #--- PUSHB_3   7 34 47   ;PUSH Bytes
SHP[rp2]        47         ;SHift Point using reference point
SHP[rp2]        34         ;SHift Point using reference point
SHP[rp2]        7          ;SHift Point using reference point
                           #--- PUSHB_1   0         ;PUSH Bytes
SRP0            0          ;Set Reference Point 0
                           #--- PUSHB_2   30 1      ;PUSH Bytes
CALL            1 30       ;CALL function
                           #--- PUSHB_2   18 16     ;PUSH Bytes
MIRP[min,black] estemw 18  ;Move Indirect Relative Point
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- DUP       #43       ;DUPlicate top stack element
MDRP[rp0,rnd,white] 43         ;Move Direct Relative Point
SRP1            43         ;Set Reference Point 1
                           #--- PUSHB_2   12 16     ;PUSH Bytes
MIRP[min,black] estemw 12  ;Move Indirect Relative Point
                           #--- PUSHB_2   50 1      ;PUSH Bytes
CALL            1 50       ;CALL function
                           #--- PUSHB_2   43 0      ;PUSH Bytes
SRP1            0          ;Set Reference Point 1
SRP2            43         ;Set Reference Point 2
                           #--- PUSHB_1   15        ;PUSH Bytes
IP              15         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   25 26     ;PUSH Bytes
SRP1            26         ;Set Reference Point 1
SRP2            25         ;Set Reference Point 2
                           #--- PUSHB_1   18        ;PUSH Bytes
IP              18         ;Interpolate Point
                           #--- PUSHB_1   39        ;PUSH Bytes
SRP1            39         ;Set Reference Point 1
                           #--- PUSHB_1   15        ;PUSH Bytes
IP              15         ;Interpolate Point
                           #--- PUSHB_1   38        ;PUSH Bytes
SRP2            38         ;Set Reference Point 2
                           #--- PUSHB_1   12        ;PUSH Bytes
IP              12         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
        """,

    'uni0E40':    #SARA E
        packline(""
        , mdap(3)
        , tstemw_1(5)
        , xhead2(11,17,23)
        , ix()
        , dh1(8)
        , dh11(1), dh12(13)
        #y  
        , sy()
        , mdap(26)
        , tvt2(5)
        , tvbc(0)
        , head1(8,[14,20])
        , iy()
        , dh2(11)
        ),

    'uni0E42':    #SARA O
        packline(""
        , mdap(3)
        , tstemw_1(33)
        , xhead2(39,45,51)
        , srp0(3)
        , mdrp0rg(7)
        , tstemw_1(30)
        , mdrprg(19)
        , f_ip([10,27,15,22])
        , ix()
        , dh1(36)
        , dh11(1), dh12(41)
        #y  
        , sy()
        , mdap(54)
        , tvbc(0)
        , head1(36,[42,48])
        #
        , mdap(10)
        , tstemt_2(27)
        , mdrp0rg(22,"9-4 10-4 11-4 12+4 13+4 ")
        , tstemt_1(15)
        , add_ip(10,0,[7,30,6,31,4,33])
        , iy()   
        , dh2(39)
        ),

    'uni0E43':    #SARA AI MAI MUAN
        packline(""
        , mdap(3)
        , tstemw_1(34)
        , xhead2(40,46,52)
        , mdapr(23)
        , headstem_1(64)
        , mdrp0rg(17)
        , headstem_2(58)
        , mdrp0mrw(9)
        , tstemw_1(29)
        , ix()
        , dh1(37)
        , dh2(20)
        , dh11(1), dh12(42)
        #y  
        , sy()
        , mdap(67)
        , tvbc(0) 
        , head1(37,[43,49])
        #
        , mdap(26)
        , tstemt_2m(12)
        , mdrp0rg(14,"11+8 12+8 13+8 14+8 15+8 16+8 ")
        , headstem_2(61)
        , mdrp0rg(20,"11-8 15-8 16-8 ")
        , headstem_1(55)
        , iy()
        , dh2(17,40)
        ),

    'uni0E44':    #SARA AI MAIMALAI
        packline(""
        , mdap(3)
        , tstemw_1(27)
        , xhead2(33,39,45)
        , srp0(3)
        , mdrprg(15)
        , f_ip([16,19,12,21,9,24,7])
        , ix()
        , dh1(30)
        , dh11(1), dh12(35)
        #y  
        , sy()
        , mdap(48)
        , tvbc(0)
        , head1(30,[36,42])
        #
        , mdap(24)
        , tstemtc_2(7)
        , mdrprg(16)
        , mdrp0rg(12)
        , tstemt_1(19)
        , iy()
        , dh2(33)
        ),

    'uni0E45':    #LAKKHANGYAO
        packline(""
        , mdapr(9)
        , tgr_160(16,1,15)
        , add_ip(9,15,[12,5])
        , ix()
        #y
        , sy()
        , mdap(16)
        , tvtc2(12,[8,2,15])
        , tstemt_2(5)
        , mdapr(8)
        , srp0(16)
        , tvblu(1)
        , iy()
        ),

    'uni0E46':    #MAIYAMOK
        packline(""
        , mdapr(1,"9-8 13+8 ")
        , tstemt_1(25)
        , mdrp0rg(19)
        , head1(13,[35,29])
        , add_ip(19,25,[21,22,23,4,5,6])
        , ix()
        , dh1(10)
        , dh2(16)
        #y
        , sy()
        , mdap(38)
        , tvtc2(21,[2,25])
        , alignrp(23)
        , tstemt_2(6)
        , shprp2(4)
        , mdrp0rg(5,"9-8 10-8 12-3 13-3 14-3 15-3 16-3 17-3 ")
        , tstemt_1(22)
        , mdrp0rg(10)
        , mdapr(10)
        , head2(16,[26,32])
        #
        , srp0(38)
        , tvblu(1)
        , iy()
        , dh2(13)
        ),

    'uni0E47':    #MAITAIKHU
        packline(""
        , mdap(41)
        , mdrprg(17)
        , mdrprg(35,"10-8 16+8 ")
        , f_ip([53,47])
        , mdrp0rg(10)
        , f_ip([26,29,5,3])
        , stemw_sara_1(23)
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , alignrp(7)
        , stemt_sara_1(26)
        , mdrprg(38,"9-4 10-4 15-8 16-8 ")
        , f_ip([44,50,32,3,29])
        , mdrp0mrg(20)
        , stemt_sara_1m(13)
        , mdrpmrg(16)
        , iy()
        ),

    'uni0E47.high':    #MAITAIKHU
        packline(""
        , mdap(41)
        , mdrprg(17)
        , mdrprg(35)
        , f_ip([53,47])
        , mdrp0rg(10)
        , f_ip([23,26,29,5,3])
        , ix()
        #y
        , sy()
        , tvtwanayuk(0)
        , alignrp(7)
        , mdrprg(38)
        , f_ip([44,50,32,3,29,26])
        , mdrprg(13)
        , f_ip([20])
        , iy()
        ),

    'uni0E48':    #MAI EK
        packline(""
        , mdap(0)
        , tstemt_2(1)
        , ix()
        #y
        , sy()
        , tvtwanayuk(0)
        , mdrpmg(3)
        , iy()
        ),

    'uni0E48.low':    #MAI EK
        packline(""
        , mdap(0)
        , tstemw_2(1)
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , mdrpmg(3)
        , iy()
        ),

    'uni0E49':    #MAI THO
        packline(""
        , mdap(15)
        , mdrprg(22)
        , mdrprg(2)
        , f_ip([9,34,28,6,18])
        , ix()
        #y
        , sy()
        , tvtwanayuk(0)
        , mdrp0rg(6)
        , f_ip([3,18])
        , mdrp0rg(12)
        , f_ip([31,25,21])
        , iy()
        ),

    'uni0E49.low':    #MAI THO
        packline(""
        , mdap(15)
        , mdrprg(22)
        , headsara2(9,[34,28,6,18])
        , mdrprg(2)
        , ix()
        , dh1(12)
        , f_dstr_dict({19:"15+5 16+5 ", 7:"15+6 16+6 "}) 
        #y
        , sy()
        , tvtsara(0)
        , stemt_sara_1(3)
        , shprp2(18)
        , mdrp0rg(6)
        , mdrprg(21)
        , headsara1(12,[25,31])
        , iy()
        , dh1(9)
        , dh2(15)
        ),

    'uni0E4A':    #MAI TRI
        packline(""
        , mdap(29)
        , stemt_sara_2(4)
        , mdrprg(37)
        , mdrp0rg(21)
        , f_ip([24,25,26,6,7,8])
        , stemt_sara_2(10)
        , mdrprg(15,"12-8 ")
        , f_ip([50,44])
        , ix()
        #y
        , sy()
        , tvtwanayuk(1)
        , alignrp(18)
        , stemt_sara_1(2)
        , shprp2(32)
        , mdrprg(12,"11-8 12-8 13-8 14-8 16-8 ")
        , f_ip([41,47])
        , mdrp0rg(24)
        , alignrp(26)
        , mdrprg(36)
        , stemt_sara_2(8)
        , shprp2(6)
        , iy()
        , dx(25,-16)
        ),

    'uni0E4A.low':    #MAI TRI
        packline(""
        , mdap(29)
        , stemw_sara_2(4)
        , mdrprg(37)
        , mdrp0rg(21)
        , f_ip([24,25,26,6,7,8])
        , stemw_sara_2(10)
        , mdrprg(15,"15-8 16-8 ")
        , f_ip([50,44])
        , ix()
#        , dh1(12)
#        , dh2(18)
        #y
        , sy()
        , tvtsara(1)
        , alignrp(18)
        , stemt_sara_1(2)
        , shprp2(32)
        , mdrprg(12,"11-8 12-8 13-8 14-8 16-8 ")
        , f_ip([41,47])
        , mdrp0rg(24)
        , alignrp(26)
        , mdrprg(36)
        , stemt_sara_2(8)
        , shprp2(6)
        , iy()
#        , dh1(21)
#        , dh2(15)
        , dx(25,-16)
        ),

    'uni0E4B':    #MAI CHATTAWA
        packline(""
        , mdap(10)
        , mdrp0rg(11)
        , alignrp(7)
        , stemt_sara_2m(1)
        , alignrp(5)
        , mdrprg(3)
        , ix()
        #y  
        , sy()
        , tvtwanayuk(0)
        , mdrp0rg(11)
        , alignrp(2)
        , stemt_sara_1m(8)
        , alignrp(5)
        , mdrprg(7)
        , iy()
        ),

    'uni0E4B.low':    #MAI CHATTAWA
        packline(""
        , mdap(10)
        , mdrp0rg(11)
        , alignrp(7)
        , stemw_sara_2m(1)
        , alignrp(5)
        , mdrprg(3)
        , ix()
        #y  
        , sy()
        , tvtsara(0)
        , mdrp0rg(11)
        , alignrp(2)
        , stemw_sara_1m(8)
        , alignrp(5)
        , mdrprg(7)
        , iy()
        ),

    'uni0E4C':    #THANTHAKAT
        packline(""
        , mdap(17)
        , mdrprg(11)
        , mdrprg(3)
        , f_ip([29,23])
        , ix()
        #y  
        , sy()
        , tvtwanayuk(0)
        , mdrp0rg(6)
        , f_ip([20,26])
        , mdrpmrg(10)
        , stemt_sara_2(14)
        , iy()
        ),

    'uni0E4C.low':    #THANTHAKAT
        packline(""
        , mdap(18)
        , mdrprg(12)
        , headsara2(3,[30,24])
        , ix()
        #y  
        , sy()
        , tvtsara(0)
        , headsara1(6,[21,27])
        , mdrpmrg(11)
        , stemt_sara_2(15)
        , iy()
        ),

    'uni0E4D':    #NIKHAHIT
        packline(""
        , mdap(9)
        , head2(3,[21,15])
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , head1(6,[12,18])
        , iy()
        ),

    'uni0E4D.high':    #NIKHAHIT
        packline(""
        , mdap(9)
        , mdrprg(8)
        , f_ip([21,15])
        , ix()
        #y
        , sy()
        , tvtwanayuk(0)
        , mdrprg(6)
        , f_ip([12,18])
        , iy()
        ),

    'uni0E4E':    #YAMAKKAN
        packline(""
        , mdap(15)
        , mdrp0rg(9)
        , f_ip([24,33,7])
        , stemw_sara_1(20)
        , mdrp0rg(4)
        , stemw_sara_1(29)
        , ix()
        #
        , sy()
        , tvtsara(0)
        , stemt_sara_1(33)
        , mdrp0rg(12)
        , f_ip([24])
        , stemt_sara_2(17)
        , mdapr(24)
        , stemt_sara_2(25)
        , f_ip([7])
        , iy()
        ),

    'uni0E4F':    #FONGMAN
        packline(""
        , mdapr(3) 
        , tstemw_1m(21)
        , mdrpmrw(27)
        , srp0(3)
        , mdrp0rg(9)
        , tstemw_2m(15)
        , mdrpmrw(33)
        , add_ip(27,33,[45,39])
        , ix()
        #y  
        , sy()
        , mdapr(0) 
        , tstemw_1m(12)
        , mdrpmrw(24)
        , srp0(0)
        , mdrp0rg(6)
        , tstemw_2m(18)
        , mdrpmrw(30)
        , add_ip(30,24,[36,42])
        , iy()
        ),

    'uni0E50':    #THAI DIGIT ZERO
        packline(""
        , tgf_112(24,3,21)
        , tgr_112(25,15,9)
        , ix()
        #y  
        , sy()
        , mdap(24)
        , tvtnc(6)
        , tstemt_2(18)
        , srp0(24)
        , tvbc(0)
        , tstemt_1(12)
        , iy()
        ),

    'uni0E51':    #THAI DIGIT ONE
        packline(""
        , tgf_112(48,3,22)
        , tgr_112(49,16,9)
        , ip_round(3,16,33)
        , mdapr(33)
        , mdrprg(13)
        , head2(27,[45,39])
        , ix()
        , dh1(30)
        #y  
        , sy()
        , mdapr(13)
        , tstemtc_2(12)
        , tvtnc(6,[0,3,22,16,9])
        , tstemtc_2(19)
        , mdapr(0)
        , tstemtc_1(25)
        , mdrp0rg(30)
        , xhead0(42,36,direction='-')
        , iy()
        , dh1(27)
        , dh2(33)
        ),

    'uni0E52':    #THAI DIGIT TWO
        packline(""
        , tgf_162(54,4,12)
        , mdrp0rg(35,"9+8 10+8 ")
        , tstemw_1(24)
        , head1(29,[51,45])
        #
        , tgr_140(55,17,41)
        , add_ip(35,41,[37,38,39,20,21,22])
        , ix()
        , dh1(26)
        , dh2(32)
        #y  
        , sy()
        , mdap(0)
        , tstemt_1(16)
        , tvtnc(39)
        , alignrp(37)
        , mdrpmrg(9)
        , tstemt_2(20)
        , shprp2(22)
        , mdrp0mrg(21,"9-3 10-3 11-3 12-3 17-3 18-3 19-3 20-3 21-3 ")
        , mdrpb(38)
        , mdrp0rg(26)
        , mdapr(26)
        , head2(32,[42,48])
        , iy()
        , dh2(29)
        ),

    'uni0E53':    #THAI DIGIT THREE
        packline(""
        , tgf_112(62,35,17)
        , xhead2(26,53,59)
        #
        , tgr_112(63,4,47)
        , ip_round(35,4,11)
        , tstemw_1(10)
        , f_ip([41])
        , ix()
        , dh1(23)
        , dh2(29)
        #y  
        , sy()
        , mdap(1)
        , tvtnc(44,[35,17,41,4,47,11])
        , alignrp(38)
        , tstemt_2(7)
        , shprp2(14)
        , mdapr(11)
        , srp0(1)
        , tvbc(29)
        , head1(23,[50,56])
        , iy()
        , dh2(26)
        ),


    'uni0E54':    #THAI DIGIT FOUR
        packline(""
        , tgf_112(58,10,25)
        , mdapr(18)
        , ip_round(25,18,39)
        , mdapr(39)
        , mdrprg(45)
        , head2(33,[55,49,30,42])
        , ix()
        , dh1(36)
        #y  
        , sy()
        , mdap(0)
        , tstemt_1(45)
        , tvtn(14,[10,25])
        , mdrprg(17)
        , tstemt_2m(21)
        , mdrp0mrw(36)
        , mdapr(36)
        , head2(42,[46,52])
        , srp0(0)
        , tvbc(7)
        , tstemtc_1(28)
        , iy()
        , dh1(33)
        , dh2(39)
        ),

    'uni0E55':    #THAI DIGIT FIVE
        packline(""
        , tgf_112(80,10,35)
        , mdapr(28)
        , ip_round(35,28,49)
        , mdapr(49)
        , mdrprg(55)
        , head2(43,[65,59,40,52])
        , mdrp0rg(21)
        , head2(15,[77,71])
        , ix()
        , dh1(46,18)
        #y  
        , sy()
        , mdap(0)
        , tstemt_1(55)
        , tvtn(23,[10,35])
        , alignrp(13)
        , mdrprg(27)
        , xhead2(18,74,68,dstr="18-8 32-8 38+8 ")
        , srp0(23)
        , tstemt_2m(31)
        , mdrp0mrw(46)
        , mdapr(46)
        , head2(52,[56,62])
        , srp0(0)
        , tvbc(7)
        , tstemtc_1(38)
        , iy()
        , dh1(43,15)
        , dh2(49,21)
        ),

    'uni0E56':    #THAI DIGIT SIX
        packline(""
        , mdap(27)
        , stemt_sara_1(34)
        , mdrp0rg(30)
        , mdrpg(31)
        , srp0(27)
        , mdrp0rg(6)
        , head1(12,[52,46])
        #
        , tgr_112(56,20,40)
        , ix()
        , dh1(9)
        #y  
        , sy()
        , mdap(55)
        , tvtnc(37,[26,34]) 
        , tstemt_2(23)
        , mdrp0rg(31)
        , mdrpg(30)
        , srp0(55)
        , tvbc(0)
        , tstemt_1(17)
        , mdrp0rg(3)
        , head1(9,[43,49])
        , iy()
        , dh1(6)
        , dh2(12)
        ),

    'uni0E57':    #THAI DIGIT SEVEN
        packline(""
        , mdap(35)
        , tstemw_1(18)
        , xhead2(26,63,69)
        #
        , tgr_140(73,54,56)
        , ip_round(35,54,5)
        , tstemw_1(47)
        , ip_round(35,5,12)
        , tstemw_1(11)
        , f_ip([41])
        , ix()
        , dh1(23)
        , dh2(29)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(50)
        , f_ip([2])
        , tvtnc(44,[35,18,41,5,17])
        , alignrp(38)
        , mdrprg(56)
        , tstemt_2(8)
        , shprp2(15)
        , srp0(1)
        , tvbc(29)
        , head1(23,[60,66])
        , ip_round(23,15,12)
        , iy()
        , dh2(26)
        ),

    'uni0E58':    #THAI DIGIT EIGHT
        packline(""
        , mdapr(4)
        , tstemw_1(19)
        #
        , mdapr(12)
        , mdrp0rg(44)
        , head2(38,[65,69])
        , ip_round(19,38,24)
        , stemt_sara_1(54)
        , add_ip(54,38,[27,52,29,50])
        , ix()  
        , dh1(41)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(22)
        , tvtn(8,[4,19])
        , mdrprg(11)
        , tstemt_2(15)
        , ip_round(15,22,41)
        , head2(35,[56,62])
        , srp0(1)
        , tvbc(47)
        , tstemt_1(32)
        , mdrp0rg(27)
        , tstemt_2(52)
        , iy()
        , dh1(38)
        ),

    'uni0E59':    #THAI DIGIT NINE
        packline(""
        , tgf_112(69,25,8)
        , xhead2(16,60,66)
        , f_ip([31])
        , mdapr(1,"9-8 14+8 15+8 ")
        , mdrpg(2)
        , tstemw_1m(0)
        , mdrpg(56)
        , add_ip(2,56,[31])
        , mdapr(43)
        , add_ip(56,43,[34,51,39,46])
        , ix()  
        , dh1(13)
        , dh2(19)
        #y  
        , sy()
        , mdap(1)
        , tvtnc(34,[25,8,2,56])
        , alignrp(28)
        , mdrprg(42)
        , tstemt_2(51)
        , shprp2(5)
        , mdrp0rg(46)
        , tstemt_1(39)
        , srp0(1)
        , tvbc(19)
        , head1(13,[57,63])
        , iy()
        , dh1(16)
        ),

    'uni0E5A':      #ANGKHANKHU
        packline(""
        , srp0(40)
        , mdrp0rg(8,"9-8 10-8 17-8 ")   #gap_112
        , head1(14,[33,27,17])
        , tgr_160(41,37,39)
        , mdrp0rg(1,"9-8 10-8 11-8 ")
        , alignrp(22)
        , tstemw_1(23)
        , ix()
        , dh1(19)
        #y  
        , sy()
        , mdap(1)
        , alignrp(37)
        , tvt2(23)
        , shprp2(39)
        , tvtc2(11,[2])
        , head2(17,[24,30])
        , mdrp0rg(19)
        , tstemt_2(5)
        , iy()
        , dh2(14)
        ),

    'uni0E5B':      #KHOMUT
        packline(""
        , tgf_112(88,3,29)
        , mdrp0rg(15)
        , head1(23,[85,79])
        , tstemtc_1(9)
        , mdapr(56)
        , add_ip(9,56,[55,35,73,41,67,47,61])
        , ix()
        , dh1(18)
        , dh2(12)
        #y  
        , sy()
        , mdapr(6)
        , tstemt_2(26)
        , mdapr(88)
        , tvbc(0)
        , tstemt_1m(32)
        , mdrp0mrw(12) 
        , mdapr(12)
        , head1(18,[76,82])
        , add_ip(26,32,[38,44,50,41,47,73,67,61,70,64,55])
        , mdapr(55)
        , tstemt_2(58)
        , iy()
        , dh1(15)
        ),

    }



#++++++++++++++++++++++++++++++

#----- MODIFY pseudo_code_dict BY -----------
#----- SUBSTITUTE FUNCTION IN TEXT FORM -----
#----- TO REAL pseudo_code ------------------
from dttcmd import *

self_func = []
for i in dir():
    if callable(eval(i)): self_func.append(i)

for i in pseudo_code_dict.keys():
    p_list = pseudo_code_dict[i].split('\n')
    for j in range(len(p_list)):
        if '(' in p_list[j]:
            if p_list[j].sp_listit('(',1)[0] in self_func:
                l = [n for n in range(len(p_list[j])) if p_list[j][n] == ')']
                t = p_list[j][:l[-1]+1]
                p_list[j] = p_list[j].rep_listace(t, eval(t))
    pseudo_code_dict[i] = '\n'.join(p_list)
