#!/usr/bin/env python

func_arg_list = [[2, 0], [1, 0], [3, 1], [1, 1], [4, 0], [0, 1], [0, 1], [0, 1], [3, 0], [3, 0], [2, 0], [1, 0], [1, 0], [4, 0], [3, 0], [5, 0], [2, 0], [2, 0], [2, 0], [3, 0], [0, 0]]

cvt_dict = {
    'evheight_lu' : 0,   #  -417    ;eng vheight p,q
    'vbase' : 1,   #  0            ;all vbase
    'tvheight_num' : 2,   #  908    ;thai vheight number
    'evheight' : 3,   #  1062       ;eng vheight normal
    'tvheight' : 4,   #  1140       ;thai vheight normal
    'ecvheight' : 5,   #  1450      ;eng capital vheight normal
    'estemtc' : 6,   #  160         ;eng stem thick - curve
    'cvt_7' : 7,   #  112
    'cvt_8' : 8,   #  124
    'headstem' : 9,   #  130        ;head stem width/thick
    'estemt' : 10,   #  148          ;eng stem thick
    'cvt_11' : 11,   #  164
    'cvt_12' : 12,   #  168
    'ecstemt' : 13,   #  173        ;eng cap stem thick
    'ecstemw' : 14,   #  180        ;eng cap stem width
    'headstem_thick' : 15,   #  160 ;head stem - thick
    'estemw' : 16,   #  180         ;eng stem width
    'cvt_17' : 17,   #  175
    'cvt_18' : 18,   #  191
    'cvt_19' : 19,   #  193
    'cvt_20' : 20,   #  201
    'cvt_21' : 21,   #  197
    'cvt_22' : 22,   #  138
    'cvt_23' : 23,   #  144
    'cvt_24' : 24,   #  178
    'cvt_25' : 25,   #  152
    'cvt_26' : 26,   #  156
    'cvt_27' : 27,   #  154
    'cvt_28' : 28,   #  103
    'cvt_29' : 29,   #  142
    'cvt_30' : 30,   #  122
    'cvt_31' : 31,   #  24
    'cvt_32' : 32,   #  932
    'cvt_33' : 33,   #  1088
    'cvt_34' : 34,   #  1166
    'cvt_35' : 35,   #  1482
    'cvt_36' : 36,   #  300
    'cvt_37' : 37,   #  430
    'cvt_38' : 38,   #  1477
    'cvt_39' : 39,   #  334
    'cvt_40' : 40,   #  0
    'cvt_41' : 41,   #  101
    }


def gf_148(s):
    return f_dstr(s,"9-8 10-8 ")

def gf_160(s):
    return f_dstr(s,"9-8 10-8 11-8 20-8 ")

def gfx(s):
    return f_dstr(s,"9-8 ")


def grx(s0,s1,s2):
    return """
SRP0    %s
MDRP[rp0,min,rnd,white] %s
MDRP[rp0,min,rnd,grey]  %s
MIRP[min,black]         estemw %s
""" % (s0,s1,s2,s1,)

def ipr(s1,s2,s3):
    return """
SRP1    %s
SRP2    %s
IP      %s
MDAP[rnd]   %s
""" % (s1,s2,s3,s3,)


pseudo_fpgm = """
                           #--- PUSHB_1   0         ;PUSH Bytes
FDEF            0          ;Function DEFinition
                           #--- PUSHB_1   0         ;PUSH Bytes
SZP0            0          ;Set Zone Pointer 0
MPPEM                      ;Measure Pixels Per EM
                           #--- PUSHB_1   42        ;PUSH Bytes
LT              42 &_MPPEM_1 ; Less Than
IF              &_LT_1     ;   IF test
                           #--- PUSHB_1   74        ;PUSH Bytes
SROUND          74         ;Super ROUND
EIF                        ;    End IF
                           #--- PUSHB_1   0         ;PUSH Bytes
SWAP            0 &_arg_1  ;SWAP the top two elements on the stack
MIAP[rnd]       &_SWAP_1 &_SWAP_2 ;Move Indirect Absolute Point
RTG                        ;Round To Grid
                           #--- PUSHB_1   6         ;PUSH Bytes
CALL            6          ;CALL function
IF              &_f6_retval_1 ;   IF test
RTDG                       ;Round To Double Grid
EIF                        ;    End IF
MPPEM                      ;Measure Pixels Per EM
                           #--- PUSHB_1   42        ;PUSH Bytes
LT              42 &_MPPEM_1 ; Less Than
IF              &_LT_1     ;   IF test
RDTG                       ;Round Down To Grid
EIF                        ;    End IF
DUP             &_arg_2    ;DUPlicate top stack element
MDRP[rp0,rnd,grey] &_DUP_1    ;Move Direct Relative Point
                           #--- PUSHB_1   1         ;PUSH Bytes
SZP0            1          ;Set Zone Pointer 0
MDAP[no-rnd]    &_DUP_2    ;Move Direct Absolute Point
RTG                        ;Round To Grid
ENDF                       ;END Function definition
#ARG_COUNT=2:
#RET_COUNT=0: 
#------------------

                           #--- PUSHB_1   1         ;PUSH Bytes
FDEF            1          ;Function DEFinition
DUP             &_arg_1    ;DUPlicate top stack element
MDRP[rp0,min,white] &_DUP_1    ;Move Direct Relative Point
                           #--- PUSHB_1   12        ;PUSH Bytes
CALL            12 &_DUP_2 ;CALL function
ENDF                       ;END Function definition
#ARG_COUNT=1:
#RET_COUNT=0: 
#------------------

                           #--- PUSHB_1   2         ;PUSH Bytes
FDEF            2          ;Function DEFinition
MPPEM                      ;Measure Pixels Per EM
GT              &_MPPEM_1 &_arg_1 ;Greater Than
IF              &_GT_1     ;   IF test
RCVT            &_arg_2    ;Read Control Value Table entry
SWAP            &_RCVT_1 &_arg_3 ;SWAP the top two elements on the stack
EIF                        ;    End IF
POP             &_SWAP_1   ;POP top stack element
ENDF                       ;END Function definition
#ARG_COUNT=3:
#RET_COUNT=1: &_SWAP_2
#------------------
#STACK_REMAIN=RETURN : &_f2_retval_1
#------------------

                           #--- PUSHB_1   3         ;PUSH Bytes
FDEF            3          ;Function DEFinition
ROUND[Black]    &_arg_1    ;ROUND value
RTG                        ;Round To Grid
DUP             &_ROUND_1  ;DUPlicate top stack element
                           #--- PUSHB_1   64        ;PUSH Bytes
LT              64 &_DUP_1 ; Less Than
IF              &_LT_1     ;   IF test
POP             &_DUP_2    ;POP top stack element
                           #--- PUSHB_1   64        ;PUSH Bytes
EIF                        ;    End IF
ENDF                       ;END Function definition
#ARG_COUNT=1:
#RET_COUNT=1: 64
#------------------
#STACK_REMAIN=RETURN : &_f3_retval_1
#------------------

                           #--- PUSHB_1   4         ;PUSH Bytes
FDEF            4          ;Function DEFinition
                           #--- PUSHB_1   6         ;PUSH Bytes
CALL            6          ;CALL function
IF              &_f6_retval_1 ;   IF test
POP             &_arg_1    ;POP top stack element
SWAP            &_arg_2 &_arg_3 ;SWAP the top two elements on the stack
POP             &_SWAP_1   ;POP top stack element
ROFF                       ; Round OFF
IF              &_SWAP_2   ;   IF test
MDRP[rp0,min,rnd,black] &_arg_4    ;Move Direct Relative Point
ELSE                       ;ELSE clause
MDRP[min,rnd,black] &_arg_4    ;Move Direct Relative Point
EIF                        ;    End IF
ELSE                       ;ELSE clause
MPPEM                      ;Measure Pixels Per EM
GT              &_MPPEM_1 &_arg_1 ;Greater Than
IF              &_GT_1     ;   IF test
IF              &_arg_2    ;   IF test
MIRP[rp0,min,rnd,black] &_arg_3 &_arg_4 ;Move Indirect Relative Point
ELSE                       ;ELSE clause
MIRP[min,rnd,black] &_arg_3 &_arg_4 ;Move Indirect Relative Point
EIF                        ;    End IF
ELSE                       ;ELSE clause
SWAP            &_arg_2 &_arg_3 ;SWAP the top two elements on the stack
POP             &_SWAP_1   ;POP top stack element
                           #--- PUSHB_1   5         ;PUSH Bytes
CALL            5          ;CALL function
IF              &_f5_retval_1 ;   IF test
                           #--- PUSHB_1   70        ;PUSH Bytes
SROUND          70         ;Super ROUND
EIF                        ;    End IF
IF              &_SWAP_2   ;   IF test
MDRP[rp0,min,rnd,black] &_arg_4    ;Move Direct Relative Point
ELSE                       ;ELSE clause
MDRP[min,rnd,black] &_arg_4    ;Move Direct Relative Point
EIF                        ;    End IF
EIF                        ;    End IF
EIF                        ;    End IF
RTG                        ;Round To Grid
ENDF                       ;END Function definition
#ARG_COUNT=4:
#RET_COUNT=0: 
#------------------

                           #--- PUSHB_1   5         ;PUSH Bytes
FDEF            5          ;Function DEFinition
GFV                        ;Get Freedom Vector
NOT             &_GFV_1    ;logical NOT
AND             &_NOT_1 &_GFV_2 ;logical AND
ENDF                       ;END Function definition
#ARG_COUNT=0:
#RET_COUNT=1: &_AND_1
#------------------
#STACK_REMAIN=RETURN : &_f5_retval_1
#------------------

                           #--- PUSHB_1   6         ;PUSH Bytes
FDEF            6          ;Function DEFinition
                           #--- PUSHB_2   34 1      ;PUSH Bytes
GETINFO         1          ;GET INFOrmation
LT              &_GETINFO_1 34 ; Less Than
IF              &_LT_1     ;   IF test
                           #--- PUSHB_1   32        ;PUSH Bytes
GETINFO         32         ;GET INFOrmation
NOT             &_GETINFO_1 ;logical NOT
NOT             &_NOT_1    ;logical NOT
ELSE                       ;ELSE clause
                           #--- PUSHB_1   0         ;PUSH Bytes
EIF                        ;    End IF
ENDF                       ;END Function definition
#ARG_COUNT=0:
#RET_COUNT=1: &_NOT_1
#------------------
#STACK_REMAIN=RETURN : &_f6_retval_1
#------------------

                           #--- PUSHB_1   7         ;PUSH Bytes
FDEF            7          ;Function DEFinition
                           #--- PUSHB_2   36 1      ;PUSH Bytes
GETINFO         1          ;GET INFOrmation
LT              &_GETINFO_1 36 ; Less Than
IF              &_LT_1     ;   IF test
                           #--- PUSHB_1   64        ;PUSH Bytes
GETINFO         64         ;GET INFOrmation
NOT             &_GETINFO_1 ;logical NOT
NOT             &_NOT_1    ;logical NOT
ELSE                       ;ELSE clause
                           #--- PUSHB_1   0         ;PUSH Bytes
EIF                        ;    End IF
ENDF                       ;END Function definition
#ARG_COUNT=0:
#RET_COUNT=1: &_NOT_1
#------------------
#STACK_REMAIN=RETURN : &_f7_retval_1
#------------------

                           #--- PUSHB_1   8         ;PUSH Bytes
FDEF            8          ;Function DEFinition
SRP2            &_arg_1    ;Set Reference Point 2
SRP1            &_arg_2    ;Set Reference Point 1
DUP             &_arg_3    ;DUPlicate top stack element
IP              &_DUP_1    ;Interpolate Point
MDAP[rnd]       &_DUP_2    ;Move Direct Absolute Point
ENDF                       ;END Function definition
#ARG_COUNT=3:
#RET_COUNT=0: 
#------------------

                           #--- PUSHB_1   9         ;PUSH Bytes
FDEF            9          ;Function DEFinition
DUP             &_arg_1    ;DUPlicate top stack element
RDTG                       ;Round Down To Grid
                           #--- PUSHB_1   6         ;PUSH Bytes
CALL            6          ;CALL function
IF              &_f6_retval_1 ;   IF test
MDRP[rnd,grey]  &_DUP_1    ;Move Direct Relative Point
ELSE                       ;ELSE clause
MDRP[min,rnd,black] &_DUP_2    ;Move Direct Relative Point
EIF                        ;    End IF
DUP             &_DUP_2    ;DUPlicate top stack element
                           #--- PUSHB_1   3         ;PUSH Bytes
CINDEX          3          ;Copy the INDEXed element to the top of the stack
MD[grid]        &_CINDEX_1 &_DUP_1 ;Measure Distance
SWAP            &_MD_1 &_DUP_2 ;SWAP the top two elements on the stack
DUP             &_SWAP_1   ;DUPlicate top stack element
                           #--- PUSHB_1   4         ;PUSH Bytes
MINDEX          4          ;Move the INDEXed element to the top of the stack
MD[orig]        &_DUP_1 &_DUP_2 ;Measure Distance
                           #--- PUSHB_1   0         ;PUSH Bytes
LT              0 &_MD_1   ; Less Than
IF              &_LT_1     ;   IF test
ROLL            &_SWAP_2 &_arg_2 &_arg_3 ;ROLL the top three stack elements
NEG             &_ROLL_1   ;    NEGate
ROLL            &_NEG_1 &_ROLL_2 &_ROLL_3 ;ROLL the top three stack elements
SUB             &_ROLL_1 &_ROLL_2 ;  SUBtract
DUP             &_SUB_1    ;DUPlicate top stack element
                           #--- PUSHB_1   0         ;PUSH Bytes
LT              0 &_DUP_1  ; Less Than
IF              &_LT_1     ;   IF test
SHPIX           &_DUP_2 &_ROLL_3 ;SHift point by a PIXel amount
ELSE                       ;ELSE clause
POP             &_arg_4    ;POP top stack element
POP             &_arg_5    ;POP top stack element
EIF                        ;    End IF
ELSE                       ;ELSE clause
ROLL            &_arg_2 &_arg_3 &_arg_4 ;ROLL the top three stack elements
ROLL            &_ROLL_1 &_ROLL_2 &_ROLL_3 ;ROLL the top three stack elements
SUB             &_ROLL_1 &_ROLL_2 ;  SUBtract
DUP             &_SUB_1    ;DUPlicate top stack element
                           #--- PUSHB_1   0         ;PUSH Bytes
GT              0 &_DUP_1  ;Greater Than
IF              &_GT_1     ;   IF test
SHPIX           &_DUP_2 &_ROLL_3 ;SHift point by a PIXel amount
ELSE                       ;ELSE clause
POP             &_arg_5    ;POP top stack element
POP             &_arg_6    ;POP top stack element
EIF                        ;    End IF
EIF                        ;    End IF
RTG                        ;Round To Grid
ENDF                       ;END Function definition
#ARG_COUNT=3:
#RET_COUNT=0: 
#------------------

                           #--- PUSHB_1   10        ;PUSH Bytes
FDEF            10         ;Function DEFinition
                           #--- PUSHB_1   6         ;PUSH Bytes
CALL            6          ;CALL function
IF              &_f6_retval_1 ;   IF test
POP             &_arg_1    ;POP top stack element
SRP0            &_arg_2    ;Set Reference Point 0
ELSE                       ;ELSE clause
SRP0            &_arg_1    ;Set Reference Point 0
POP             &_arg_2    ;POP top stack element
EIF                        ;    End IF
ENDF                       ;END Function definition
#ARG_COUNT=2:
#RET_COUNT=0: 
#------------------

                           #--- PUSHB_1   11        ;PUSH Bytes
FDEF            11         ;Function DEFinition
DUP             &_arg_1    ;DUPlicate top stack element
MDRP[rp0,white] &_DUP_1    ;Move Direct Relative Point
                           #--- PUSHB_1   12        ;PUSH Bytes
CALL            12 &_DUP_2 ;CALL function
ENDF                       ;END Function definition
#ARG_COUNT=1:
#RET_COUNT=0: 
#------------------

                           #--- PUSHB_1   12        ;PUSH Bytes
FDEF            12         ;Function DEFinition
DUP             &_arg_1    ;DUPlicate top stack element
MDAP[rnd]       &_DUP_1    ;Move Direct Absolute Point
                           #--- PUSHB_1   7         ;PUSH Bytes
CALL            7          ;CALL function
NOT             &_f7_retval_1 ;logical NOT
IF              &_NOT_1    ;   IF test
DUP             &_DUP_2    ;DUPlicate top stack element
DUP             &_DUP_1    ;DUPlicate top stack element
GC[orig]        &_DUP_1    ;Get Coordinate projected onto the projection vector
SWAP            &_GC_1 &_DUP_2 ;SWAP the top two elements on the stack
GC[cur]         &_SWAP_1   ;Get Coordinate projected onto the projection vector
SUB             &_GC_1 &_SWAP_2 ;  SUBtract
ROUND[White]    &_SUB_1    ;ROUND value
DUP             &_ROUND_1  ;DUPlicate top stack element
IF              &_DUP_1    ;   IF test
DUP             &_DUP_2    ;DUPlicate top stack element
ABS             &_DUP_1    ;ABSolute value
DIV             &_ABS_1 &_DUP_2 ;    DIVide
SHPIX           &_DIV_1 &_DUP_2 ;SHift point by a PIXel amount
ELSE                       ;ELSE clause
POP             &_arg_2    ;POP top stack element
POP             &_arg_3    ;POP top stack element
EIF                        ;    End IF
ELSE                       ;ELSE clause
POP             &_arg_2    ;POP top stack element
EIF                        ;    End IF
ENDF                       ;END Function definition
#ARG_COUNT=1:
#RET_COUNT=0: 
#------------------

                           #--- PUSHB_1   13        ;PUSH Bytes
FDEF            13         ;Function DEFinition
SRP2            &_arg_1    ;Set Reference Point 2
SRP1            &_arg_2    ;Set Reference Point 1
DUP             &_arg_3    ;DUPlicate top stack element
DUP             &_DUP_1    ;DUPlicate top stack element
IP              &_DUP_1    ;Interpolate Point
MDAP[rnd]       &_DUP_2    ;Move Direct Absolute Point
DUP             &_DUP_2    ;DUPlicate top stack element
ROLL            &_DUP_1 &_DUP_2 &_arg_4 ;ROLL the top three stack elements
DUP             &_ROLL_1   ;DUPlicate top stack element
GC[orig]        &_DUP_1    ;Get Coordinate projected onto the projection vector
ROLL            &_GC_1 &_DUP_2 &_ROLL_2 ;ROLL the top three stack elements
GC[cur]         &_ROLL_1   ;Get Coordinate projected onto the projection vector
SUB             &_GC_1 &_ROLL_2 ;  SUBtract
SWAP            &_SUB_1 &_ROLL_3 ;SWAP the top two elements on the stack
ROLL            &_SWAP_1 &_SWAP_2 &_ROLL_3 ;ROLL the top three stack elements
DUP             &_ROLL_1   ;DUPlicate top stack element
ROLL            &_DUP_1 &_DUP_2 &_ROLL_2 ;ROLL the top three stack elements
SWAP            &_ROLL_1 &_ROLL_2 ;SWAP the top two elements on the stack
MD[orig]        &_SWAP_1 &_SWAP_2 ;Measure Distance
                           #--- PUSHB_1   0         ;PUSH Bytes
LT              0 &_MD_1   ; Less Than
IF              &_LT_1     ;   IF test
SWAP            &_ROLL_3 &_ROLL_3 ;SWAP the top two elements on the stack
                           #--- PUSHB_1   0         ;PUSH Bytes
GT              0 &_SWAP_1 ;Greater Than
IF              &_GT_1     ;   IF test
                           #--- PUSHB_1   64        ;PUSH Bytes
SHPIX           64 &_SWAP_2 ;SHift point by a PIXel amount
ELSE                       ;ELSE clause
POP             &_arg_5    ;POP top stack element
EIF                        ;    End IF
ELSE                       ;ELSE clause
SWAP            &_arg_5 &_arg_6 ;SWAP the top two elements on the stack
                           #--- PUSHB_1   0         ;PUSH Bytes
LT              0 &_SWAP_1 ; Less Than
IF              &_LT_1     ;   IF test
                           #--- PUSHB_1   64        ;PUSH Bytes
NEG             64         ;    NEGate
SHPIX           &_NEG_1 &_SWAP_2 ;SHift point by a PIXel amount
ELSE                       ;ELSE clause
POP             &_arg_7    ;POP top stack element
EIF                        ;    End IF
EIF                        ;    End IF
ENDF                       ;END Function definition
#ARG_COUNT=4:
#RET_COUNT=0: 
#------------------

                           #--- PUSHB_1   14        ;PUSH Bytes
FDEF            14         ;Function DEFinition
                           #--- PUSHB_1   6         ;PUSH Bytes
CALL            6          ;CALL function
IF              &_f6_retval_1 ;   IF test
RTDG                       ;Round To Double Grid
MDRP[rp0,rnd,white] &_arg_1    ;Move Direct Relative Point
RTG                        ;Round To Grid
POP             &_arg_2    ;POP top stack element
POP             &_arg_3    ;POP top stack element
ELSE                       ;ELSE clause
DUP             &_arg_1    ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
ROLL            &_DUP_2 &_arg_2 &_arg_3 ;ROLL the top three stack elements
MPPEM                      ;Measure Pixels Per EM
GT              &_MPPEM_1 &_ROLL_1 ;Greater Than
IF              &_GT_1     ;   IF test
DUP             &_ROLL_2   ;DUPlicate top stack element
ROLL            &_DUP_1 &_DUP_2 &_ROLL_3 ;ROLL the top three stack elements
SWAP            &_ROLL_1 &_ROLL_2 ;SWAP the top two elements on the stack
MD[grid]        &_SWAP_1 &_SWAP_2 ;Measure Distance
DUP             &_MD_1     ;DUPlicate top stack element
                           #--- PUSHB_1   0         ;PUSH Bytes
NEQ             0 &_DUP_1  ; Not EQual
IF              &_NEQ_1    ;   IF test
SHPIX           &_DUP_2 &_ROLL_3 ;SHift point by a PIXel amount
ELSE                       ;ELSE clause
POP             &_arg_4    ;POP top stack element
POP             &_arg_5    ;POP top stack element
EIF                        ;    End IF
ELSE                       ;ELSE clause
POP             &_arg_4    ;POP top stack element
POP             &_arg_5    ;POP top stack element
EIF                        ;    End IF
EIF                        ;    End IF
ENDF                       ;END Function definition
#ARG_COUNT=3:
#RET_COUNT=0: 
#------------------

                           #--- PUSHB_1   15        ;PUSH Bytes
FDEF            15         ;Function DEFinition
SWAP            &_arg_1 &_arg_2 ;SWAP the top two elements on the stack
DUP             &_SWAP_1   ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
DUP             &_DUP_2    ;DUPlicate top stack element
MDAP[rnd]       &_DUP_1    ;Move Direct Absolute Point
                           #--- PUSHB_1   7         ;PUSH Bytes
CALL            7          ;CALL function
NOT             &_f7_retval_1 ;logical NOT
IF              &_NOT_1    ;   IF test
SWAP            &_DUP_2 &_SWAP_2 ;SWAP the top two elements on the stack
DUP             &_SWAP_1   ;DUPlicate top stack element
IF              &_DUP_1    ;   IF test
MPPEM                      ;Measure Pixels Per EM
GTEQ            &_MPPEM_1 &_DUP_2 ;Greater Than or EQual
ELSE                       ;ELSE clause
POP             &_GTEQ_1   ;POP top stack element
                           #--- PUSHB_1   1         ;PUSH Bytes
EIF                        ;    End IF
IF              &_GTEQ_1   ;   IF test
ROLL            &_SWAP_2 &_arg_3 &_arg_4 ;ROLL the top three stack elements
                           #--- PUSHB_1   4         ;PUSH Bytes
MINDEX          4          ;Move the INDEXed element to the top of the stack
MD[grid]        &_ROLL_1 &_ROLL_2 ;Measure Distance
SWAP            &_MD_1 &_ROLL_3 ;SWAP the top two elements on the stack
ROLL            &_SWAP_1 &_SWAP_2 &_arg_5 ;ROLL the top three stack elements
SWAP            &_ROLL_1 &_ROLL_2 ;SWAP the top two elements on the stack
DUP             &_SWAP_1   ;DUPlicate top stack element
ROLL            &_DUP_1 &_DUP_2 &_SWAP_2 ;ROLL the top three stack elements
MD[grid]        &_ROLL_1 &_ROLL_2 ;Measure Distance
ROLL            &_MD_1 &_ROLL_3 &_ROLL_3 ;ROLL the top three stack elements
SWAP            &_ROLL_1 &_ROLL_2 ;SWAP the top two elements on the stack
SUB             &_SWAP_1 &_SWAP_2 ;  SUBtract
SHPIX           &_SUB_1 &_ROLL_3 ;SHift point by a PIXel amount
ELSE                       ;ELSE clause
POP             &_arg_3    ;POP top stack element
POP             &_arg_4    ;POP top stack element
POP             &_arg_5    ;POP top stack element
POP             &_arg_6    ;POP top stack element
EIF                        ;    End IF
ELSE                       ;ELSE clause
POP             1          ;POP top stack element
POP             &_SWAP_2   ;POP top stack element
POP             &_arg_3    ;POP top stack element
POP             &_arg_4    ;POP top stack element
POP             &_arg_5    ;POP top stack element
EIF                        ;    End IF
ENDF                       ;END Function definition
#ARG_COUNT=5:
#RET_COUNT=0: 
#------------------

                           #--- PUSHB_1   16        ;PUSH Bytes
FDEF            16         ;Function DEFinition
DUP             &_arg_1    ;DUPlicate top stack element
MDRP[rp0,min,white] &_DUP_1    ;Move Direct Relative Point
                           #--- PUSHB_1   18        ;PUSH Bytes
CALL            18 &_DUP_2 &_arg_2 ;CALL function
ENDF                       ;END Function definition
#ARG_COUNT=2:
#RET_COUNT=0: 
#------------------

                           #--- PUSHB_1   17        ;PUSH Bytes
FDEF            17         ;Function DEFinition
DUP             &_arg_1    ;DUPlicate top stack element
MDRP[rp0,white] &_DUP_1    ;Move Direct Relative Point
                           #--- PUSHB_1   18        ;PUSH Bytes
CALL            18 &_DUP_2 &_arg_2 ;CALL function
ENDF                       ;END Function definition
#ARG_COUNT=2:
#RET_COUNT=0: 
#------------------

                           #--- PUSHB_1   18        ;PUSH Bytes
FDEF            18         ;Function DEFinition
DUP             &_arg_1    ;DUPlicate top stack element
MDAP[rnd]       &_DUP_1    ;Move Direct Absolute Point
                           #--- PUSHB_1   7         ;PUSH Bytes
CALL            7          ;CALL function
NOT             &_f7_retval_1 ;logical NOT
IF              &_NOT_1    ;   IF test
DUP             &_DUP_2    ;DUPlicate top stack element
DUP             &_DUP_1    ;DUPlicate top stack element
GC[orig]        &_DUP_1    ;Get Coordinate projected onto the projection vector
SWAP            &_GC_1 &_DUP_2 ;SWAP the top two elements on the stack
GC[cur]         &_SWAP_1   ;Get Coordinate projected onto the projection vector
SUB             &_GC_1 &_SWAP_2 ;  SUBtract
ROUND[White]    &_SUB_1    ;ROUND value
ROLL            &_ROUND_1 &_DUP_2 &_arg_2 ;ROLL the top three stack elements
DUP             &_ROLL_1   ;DUPlicate top stack element
GC[orig]        &_DUP_1    ;Get Coordinate projected onto the projection vector
SWAP            &_GC_1 &_DUP_2 ;SWAP the top two elements on the stack
GC[cur]         &_SWAP_1   ;Get Coordinate projected onto the projection vector
SWAP            &_GC_1 &_SWAP_2 ;SWAP the top two elements on the stack
SUB             &_SWAP_1 &_SWAP_2 ;  SUBtract
ROUND[White]    &_SUB_1    ;ROUND value
ADD             &_ROUND_1 &_ROLL_2 ;       ADD
DUP             &_ADD_1    ;DUPlicate top stack element
IF              &_DUP_1    ;   IF test
DUP             &_DUP_2    ;DUPlicate top stack element
ABS             &_DUP_1    ;ABSolute value
DIV             &_ABS_1 &_DUP_2 ;    DIVide
SHPIX           &_DIV_1 &_ROLL_3 ;SHift point by a PIXel amount
ELSE                       ;ELSE clause
POP             &_arg_3    ;POP top stack element
POP             &_arg_4    ;POP top stack element
EIF                        ;    End IF
ELSE                       ;ELSE clause
POP             &_arg_2    ;POP top stack element
POP             &_arg_3    ;POP top stack element
EIF                        ;    End IF
ENDF                       ;END Function definition
#ARG_COUNT=2:
#RET_COUNT=0: 
#------------------

                           #--- PUSHB_1   19        ;PUSH Bytes
FDEF            19         ;Function DEFinition
DUP             &_arg_1    ;DUPlicate top stack element
ROLL            &_DUP_1 &_DUP_2 &_arg_2 ;ROLL the top three stack elements
DUP             &_ROLL_1   ;DUPlicate top stack element
ROLL            &_DUP_1 &_DUP_2 &_ROLL_2 ;ROLL the top three stack elements
SDPVTL[orthog]  &_ROLL_1 &_ROLL_2 ;Set Dual Projection Vector To Line
DUP             &_ROLL_3   ;DUPlicate top stack element
                           #--- PUSHB_1   3         ;PUSH Bytes
CINDEX          3          ;Copy the INDEXed element to the top of the stack
MD[orig]        &_CINDEX_1 &_DUP_1 ;Measure Distance
ABS             &_MD_1     ;ABSolute value
SWAP            &_ABS_1 &_DUP_2 ;SWAP the top two elements on the stack
ROLL            &_SWAP_1 &_SWAP_2 &_ROLL_3 ;ROLL the top three stack elements
SPVTL[orthog]   &_ROLL_1 &_ROLL_2 ;Set Projection Vector To Line
                           #--- PUSHB_1   32        ;PUSH Bytes
LT              32 &_ROLL_3 ; Less Than
IF              &_LT_1     ;   IF test
ALIGNRP         &_arg_3    ;ALIGN to Reference Point
ELSE                       ;ELSE clause
MDRP[grey]      &_arg_3    ;Move Direct Relative Point
EIF                        ;    End IF
ENDF                       ;END Function definition
#ARG_COUNT=3:
#RET_COUNT=0: 
#------------------

ENDF                       ;END Function definition
#ARG_COUNT=0:
#RET_COUNT=0: 
#------------------
"""



pseudo_code_dict = {
    '.notdef': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_5   4 7 0 20 4 ;PUSH Bytes
CALL            4 20 0 7 4 ;CALL function
                           #--- PUSHB_1   7         ;PUSH Bytes
MDAP[rnd]       7          ;Move Direct Absolute Point
                           #--- PUSHB_5   1 7 0 20 4 ;PUSH Bytes
CALL            4 20 0 7 1 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_1   0         ;PUSH Bytes
MDRP[rp0,rnd,white] 0          ;Move Direct Relative Point
                           #--- PUSHB_5   4 15 0 20 4 ;PUSH Bytes
CALL            4 20 0 15 4 ;CALL function
                           #--- PUSHB_1   4         ;PUSH Bytes
SRP0            4          ;Set Reference Point 0
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
                           #--- PUSHB_5   3 15 0 20 4 ;PUSH Bytes
CALL            4 20 0 15 3 ;CALL function
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'A': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   5 1 0     ;PUSH Bytes
CALL            0 1 5      ;CALL function
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_5   3 10 5 6 13 ;PUSH Bytes
CALL            13 6 5 10 3 ;CALL function
                           #--- PUSHB_2   3 13      ;PUSH Bytes
MIRP[min,black] ecstemt 3  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   11        ;PUSH Bytes
MDAP[rnd]       11         ;Move Direct Absolute Point
                           #--- PUSHB_2   12 1      ;PUSH Bytes
CALL            1 12       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   6 10      ;PUSH Bytes
SRP1            10         ;Set Reference Point 1
SRP2            6          ;Set Reference Point 2
                           #--- PUSHB_1   9         ;PUSH Bytes
IP              9          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'B': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_2   23 13     ;PUSH Bytes
MIRP[min,black] ecstemt 23 ;Move Indirect Relative Point
                           #--- PUSHB_3   2 5 0     ;PUSH Bytes
CALL            0 5 2      ;CALL function
                           #--- PUSHB_2   31 13     ;PUSH Bytes
MIRP[min,black] ecstemt 31 ;Move Indirect Relative Point
                           #--- PUSHB_5   32 22 1 2 13 ;PUSH Bytes
CALL            13 2 1 22 32 ;CALL function
                           #--- PUSHB_2   32 13     ;PUSH Bytes
MIRP[min,black] ecstemt 32 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   33        ;PUSH Bytes
MDAP[rnd]       33         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_2   23 16     ;PUSH Bytes
MIRP[min,black] estemw 23  ;Move Indirect Relative Point
                           #--- PUSHB_1   31        ;PUSH Bytes
SHP[rp2]        31         ;SHift Point using reference point
                           #--- PUSHB_1   23        ;PUSH Bytes
SRP0            23         ;Set Reference Point 0
                           #--- PUSHB_2   18 1      ;PUSH Bytes
CALL            1 18       ;CALL function
                           #--- PUSHB_5   12 16 0 31 4 ;PUSH Bytes
CALL            4 31 0 16 12 ;CALL function
                           #--- PUSHB_1   27        ;PUSH Bytes
DUP             27         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   6 16      ;PUSH Bytes
MIRP[min,black] estemw 6   ;Move Indirect Relative Point
                           #--- PUSHB_2   34 1      ;PUSH Bytes
CALL            1 34       ;CALL function
                           #--- PUSHB_2   27 23     ;PUSH Bytes
SRP1            23         ;Set Reference Point 1
SRP2            27         ;Set Reference Point 2
                           #--- PUSHB_1   9         ;PUSH Bytes
IP              9          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   22 23     ;PUSH Bytes
SRP1            23         ;Set Reference Point 1
SRP2            22         ;Set Reference Point 2
                           #--- PUSHB_1   12        ;PUSH Bytes
IP              12         ;Interpolate Point
                           #--- PUSHB_1   32        ;PUSH Bytes
SRP1            32         ;Set Reference Point 1
                           #--- PUSHB_1   9         ;PUSH Bytes
IP              9          ;Interpolate Point
                           #--- PUSHB_1   31        ;PUSH Bytes
SRP2            31         ;Set Reference Point 2
                           #--- PUSHB_1   6         ;PUSH Bytes
IP              6          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'C': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   19 14     ;PUSH Bytes
MIRP[min,black] ecstemw 19 ;Move Indirect Relative Point
                           #--- PUSHB_3   19 0 10   ;PUSH Bytes
CALL            10 0 19    ;CALL function
                           #--- PUSHB_4   64 19 22 9 ;PUSH Bytes
CALL            9 22 19 64 ;CALL function
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_2   13 14     ;PUSH Bytes
MIRP[min,black] ecstemw 13 ;Move Indirect Relative Point
                           #--- PUSHB_3   13 6 10   ;PUSH Bytes
CALL            10 6 13    ;CALL function
                           #--- PUSHB_4   64 13 10 9 ;PUSH Bytes
CALL            9 10 13 64 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   26        ;PUSH Bytes
MDAP[rnd]       26         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   16 16     ;PUSH Bytes
MIRP[min,black] estemw 16  ;Move Indirect Relative Point
                           #--- PUSHB_1   16        ;PUSH Bytes
SRP0            16         ;Set Reference Point 0
                           #--- PUSHB_2   22 1      ;PUSH Bytes
CALL            1 22       ;CALL function
                           #--- PUSHB_2   23 16     ;PUSH Bytes
MIRP[min,black] estemw 23  ;Move Indirect Relative Point
                           #--- PUSHB_1   10        ;PUSH Bytes
DUP             10         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   9 16      ;PUSH Bytes
MIRP[min,black] estemw 9   ;Move Indirect Relative Point
                           #--- PUSHB_2   27 1      ;PUSH Bytes
CALL            1 27       ;CALL function
                           #--- PUSHB_2   10 16     ;PUSH Bytes
SRP1            16         ;Set Reference Point 1
SRP2            10         ;Set Reference Point 2
                           #--- PUSHB_3   6 0 19    ;PUSH Bytes
IP              19         ;Interpolate Point
IP              0          ;Interpolate Point
IP              6          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   13 19     ;PUSH Bytes
SRP1            19         ;Set Reference Point 1
SRP2            13         ;Set Reference Point 2
                           #--- PUSHB_1   3         ;PUSH Bytes
IP              3          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'D': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_2   17 13     ;PUSH Bytes
MIRP[min,black] ecstemt 17 ;Move Indirect Relative Point
                           #--- PUSHB_3   2 5 0     ;PUSH Bytes
CALL            0 5 2      ;CALL function
                           #--- PUSHB_2   16 13     ;PUSH Bytes
MIRP[min,black] ecstemt 16 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   18        ;PUSH Bytes
MDAP[rnd]       18         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_2   17 16     ;PUSH Bytes
MIRP[min,black] estemw 17  ;Move Indirect Relative Point
                           #--- PUSHB_1   17        ;PUSH Bytes
SRP0            17         ;Set Reference Point 0
                           #--- PUSHB_2   12 1      ;PUSH Bytes
CALL            1 12       ;CALL function
                           #--- PUSHB_2   6 16      ;PUSH Bytes
MIRP[min,black] estemw 6   ;Move Indirect Relative Point
                           #--- PUSHB_2   19 1      ;PUSH Bytes
CALL            1 19       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   16 17     ;PUSH Bytes
SRP1            17         ;Set Reference Point 1
SRP2            16         ;Set Reference Point 2
                           #--- PUSHB_1   6         ;PUSH Bytes
IP              6          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'E': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_2   10 13     ;PUSH Bytes
MIRP[min,black] ecstemt 10 ;Move Indirect Relative Point
                           #--- PUSHB_3   2 5 0     ;PUSH Bytes
CALL            0 5 2      ;CALL function
                           #--- PUSHB_2   5 13      ;PUSH Bytes
MIRP[min,black] ecstemt 5  ;Move Indirect Relative Point
                           #--- PUSHB_5   6 9 1 2 13 ;PUSH Bytes
CALL            13 2 1 9 6 ;CALL function
                           #--- PUSHB_2   6 13      ;PUSH Bytes
MIRP[min,black] ecstemt 6  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   12        ;PUSH Bytes
MDAP[rnd]       12         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_2   10 16     ;PUSH Bytes
MIRP[min,black] estemw 10  ;Move Indirect Relative Point
                           #--- PUSHB_1   5         ;PUSH Bytes
SHP[rp2]        5          ;SHift Point using reference point
                           #--- PUSHB_3   10 1 10   ;PUSH Bytes
CALL            10 1 10    ;CALL function
                           #--- PUSHB_4   64 10 0 9 ;PUSH Bytes
CALL            9 0 10 64  ;CALL function
                           #--- PUSHB_1   3         ;PUSH Bytes
SHP[rp2]        3          ;SHift Point using reference point
                           #--- PUSHB_4   64 10 8 9 ;PUSH Bytes
CALL            9 8 10 64  ;CALL function
                           #--- PUSHB_2   13 1      ;PUSH Bytes
CALL            1 13       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'F': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   2 5 0     ;PUSH Bytes
CALL            0 5 2      ;CALL function
                           #--- PUSHB_2   5 13      ;PUSH Bytes
MIRP[min,black] ecstemt 5  ;Move Indirect Relative Point
                           #--- PUSHB_5   6 9 1 2 13 ;PUSH Bytes
CALL            13 2 1 9 6 ;CALL function
                           #--- PUSHB_2   6 13      ;PUSH Bytes
MIRP[min,black] ecstemt 6  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   10        ;PUSH Bytes
MDAP[rnd]       10         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_1   5         ;PUSH Bytes
SHP[rp2]        5          ;SHift Point using reference point
                           #--- PUSHB_3   0 1 10    ;PUSH Bytes
CALL            10 1 0     ;CALL function
                           #--- PUSHB_4   64 0 4 9  ;PUSH Bytes
CALL            9 4 0 64   ;CALL function
                           #--- PUSHB_4   64 0 8 9  ;PUSH Bytes
CALL            9 8 0 64   ;CALL function
                           #--- PUSHB_2   11 1      ;PUSH Bytes
CALL            1 11       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'G': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   19 14     ;PUSH Bytes
MIRP[min,black] ecstemw 19 ;Move Indirect Relative Point
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_2   13 14     ;PUSH Bytes
MIRP[min,black] ecstemw 13 ;Move Indirect Relative Point
                           #--- PUSHB_3   13 6 10   ;PUSH Bytes
CALL            10 6 13    ;CALL function
                           #--- PUSHB_4   64 13 10 9 ;PUSH Bytes
CALL            9 10 13 64 ;CALL function
                           #--- PUSHB_5   24 25 0 6 13 ;PUSH Bytes
CALL            13 6 0 25 24 ;CALL function
                           #--- PUSHB_2   24 13     ;PUSH Bytes
MIRP[min,black] ecstemt 24 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   30        ;PUSH Bytes
MDAP[rnd]       30         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   16 16     ;PUSH Bytes
MIRP[min,black] estemw 16  ;Move Indirect Relative Point
                           #--- PUSHB_1   16        ;PUSH Bytes
SRP0            16         ;Set Reference Point 0
                           #--- PUSHB_2   22 1      ;PUSH Bytes
CALL            1 22       ;CALL function
                           #--- PUSHB_2   27 16     ;PUSH Bytes
MIRP[min,black] estemw 27  ;Move Indirect Relative Point
                           #--- PUSHB_3   22 27 10  ;PUSH Bytes
CALL            10 27 22   ;CALL function
                           #--- PUSHB_4   64 22 24 9 ;PUSH Bytes
CALL            9 24 22 64 ;CALL function
                           #--- PUSHB_1   27        ;PUSH Bytes
SRP0            27         ;Set Reference Point 0
                           #--- PUSHB_1   9         ;PUSH Bytes
DUP             9          ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   10 16     ;PUSH Bytes
MIRP[min,black] estemw 10  ;Move Indirect Relative Point
                           #--- PUSHB_1   10        ;PUSH Bytes
MDAP[rnd]       10         ;Move Direct Absolute Point
                           #--- PUSHB_2   9 16      ;PUSH Bytes
MIRP[min,black] estemw 9   ;Move Indirect Relative Point
                           #--- PUSHB_2   31 1      ;PUSH Bytes
CALL            1 31       ;CALL function
                           #--- PUSHB_2   10 16     ;PUSH Bytes
SRP1            16         ;Set Reference Point 1
SRP2            10         ;Set Reference Point 2
                           #--- PUSHB_3   6 0 19    ;PUSH Bytes
IP              19         ;Interpolate Point
IP              0          ;Interpolate Point
IP              6          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   25 24     ;PUSH Bytes
SRP1            24         ;Set Reference Point 1
SRP2            25         ;Set Reference Point 2
                           #--- PUSHB_2   16 3      ;PUSH Bytes
IP              3          ;Interpolate Point
IP              16         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'H': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   5 1 0     ;PUSH Bytes
CALL            0 1 5      ;CALL function
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_1   10        ;PUSH Bytes
SHP[rp1]        10         ;SHift Point using reference point
                           #--- PUSHB_5   8 3 5 6 13 ;PUSH Bytes
CALL            13 6 5 3 8 ;CALL function
                           #--- PUSHB_2   8 13      ;PUSH Bytes
MIRP[min,black] ecstemt 8  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   12        ;PUSH Bytes
MDAP[rnd]       12         ;Move Direct Absolute Point
                           #--- PUSHB_1   5         ;PUSH Bytes
MDRP[rp0,rnd,white] 5          ;Move Direct Relative Point
                           #--- PUSHB_2   4 16      ;PUSH Bytes
MIRP[min,black] estemw 4   ;Move Indirect Relative Point
                           #--- PUSHB_1   7         ;PUSH Bytes
SHP[rp2]        7          ;SHift Point using reference point
                           #--- PUSHB_1   4         ;PUSH Bytes
SRP0            4          ;Set Reference Point 0
                           #--- PUSHB_2   1 1       ;PUSH Bytes
CALL            1 1        ;CALL function
                           #--- PUSHB_1   9         ;PUSH Bytes
SHP[rp2]        9          ;SHift Point using reference point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_2   13 1      ;PUSH Bytes
CALL            1 13       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'I': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_2   2 6       ;PUSH Bytes
MIRP[min,black] estemtc 2  ;Move Indirect Relative Point
                           #--- PUSHB_1   10        ;PUSH Bytes
SHP[rp2]        10         ;SHift Point using reference point
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_2   5 6       ;PUSH Bytes
MIRP[min,black] estemtc 5  ;Move Indirect Relative Point
                           #--- PUSHB_1   8         ;PUSH Bytes
SHP[rp2]        8          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   12        ;PUSH Bytes
MDAP[rnd]       12         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   10 16     ;PUSH Bytes
MIRP[min,black] estemw 10  ;Move Indirect Relative Point
                           #--- PUSHB_3   10 3 10   ;PUSH Bytes
CALL            10 3 10    ;CALL function
                           #--- PUSHB_4   64 10 0 9 ;PUSH Bytes
CALL            9 0 10 64  ;CALL function
                           #--- PUSHB_1   7         ;PUSH Bytes
SHP[rp2]        7          ;SHift Point using reference point
                           #--- PUSHB_3   3 10 10   ;PUSH Bytes
CALL            10 10 3    ;CALL function
                           #--- PUSHB_4   64 3 1 9  ;PUSH Bytes
CALL            9 1 3 64   ;CALL function
                           #--- PUSHB_1   5         ;PUSH Bytes
SHP[rp2]        5          ;SHift Point using reference point
                           #--- PUSHB_2   13 1      ;PUSH Bytes
CALL            1 13       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'J': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   7 14      ;PUSH Bytes
MIRP[min,black] ecstemw 7  ;Move Indirect Relative Point
                           #--- PUSHB_3   7 0 10    ;PUSH Bytes
CALL            10 0 7     ;CALL function
                           #--- PUSHB_4   64 7 3 9  ;PUSH Bytes
CALL            9 3 7 64   ;CALL function
                           #--- PUSHB_3   13 5 0    ;PUSH Bytes
CALL            0 5 13     ;CALL function
                           #--- PUSHB_2   12 13     ;PUSH Bytes
MIRP[min,black] ecstemt 12 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   18        ;PUSH Bytes
MDAP[rnd]       18         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   4 16      ;PUSH Bytes
MIRP[min,black] estemw 4   ;Move Indirect Relative Point
                           #--- PUSHB_1   4         ;PUSH Bytes
SRP0            4          ;Set Reference Point 0
                           #--- PUSHB_2   10 1      ;PUSH Bytes
CALL            1 10       ;CALL function
                           #--- PUSHB_2   15 16     ;PUSH Bytes
MIRP[min,black] estemw 15  ;Move Indirect Relative Point
                           #--- PUSHB_3   10 15 10  ;PUSH Bytes
CALL            10 15 10   ;CALL function
                           #--- PUSHB_4   64 10 12 9 ;PUSH Bytes
CALL            9 12 10 64 ;CALL function
                           #--- PUSHB_2   19 1      ;PUSH Bytes
CALL            1 19       ;CALL function
                           #--- PUSHB_2   10 4      ;PUSH Bytes
SRP1            4          ;Set Reference Point 1
SRP2            10         ;Set Reference Point 2
                           #--- PUSHB_1   0         ;PUSH Bytes
IP              0          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'K': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   5 1 0     ;PUSH Bytes
CALL            0 1 5      ;CALL function
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_1   9         ;PUSH Bytes
SHP[rp1]        9          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   12        ;PUSH Bytes
MDAP[rnd]       12         ;Move Direct Absolute Point
                           #--- PUSHB_1   5         ;PUSH Bytes
MDRP[rp0,rnd,white] 5          ;Move Direct Relative Point
                           #--- PUSHB_2   4 16      ;PUSH Bytes
MIRP[min,black] estemw 4   ;Move Indirect Relative Point
                           #--- PUSHB_1   7         ;PUSH Bytes
SHP[rp2]        7          ;SHift Point using reference point
                           #--- PUSHB_2   13 1      ;PUSH Bytes
CALL            1 13       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   6 5       ;PUSH Bytes
SRP1            5          ;Set Reference Point 1
SRP2            6          ;Set Reference Point 2
                           #--- PUSHB_2   2 8       ;PUSH Bytes
IP              8          ;Interpolate Point
IP              2          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'L': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_2   4 13      ;PUSH Bytes
MIRP[min,black] ecstemt 4  ;Move Indirect Relative Point
                           #--- PUSHB_3   2 5 0     ;PUSH Bytes
CALL            0 5 2      ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   6         ;PUSH Bytes
MDAP[rnd]       6          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_2   4 16      ;PUSH Bytes
MIRP[min,black] estemw 4   ;Move Indirect Relative Point
                           #--- PUSHB_3   4 1 10    ;PUSH Bytes
CALL            10 1 4     ;CALL function
                           #--- PUSHB_4   64 4 0 9  ;PUSH Bytes
CALL            9 0 4 64   ;CALL function
                           #--- PUSHB_2   7 1       ;PUSH Bytes
CALL            1 7        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'M': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   7 1 0     ;PUSH Bytes
CALL            0 1 7      ;CALL function
                           #--- PUSHB_2   0 3       ;PUSH Bytes
SHP[rp1]        3          ;SHift Point using reference point
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_3   8 5 0     ;PUSH Bytes
CALL            0 5 8      ;CALL function
                           #--- PUSHB_1   11        ;PUSH Bytes
SHP[rp1]        11         ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   13        ;PUSH Bytes
MDAP[rnd]       13         ;Move Direct Absolute Point
                           #--- PUSHB_1   7         ;PUSH Bytes
MDRP[rp0,rnd,white] 7          ;Move Direct Relative Point
                           #--- PUSHB_2   6 16      ;PUSH Bytes
MIRP[min,black] estemw 6   ;Move Indirect Relative Point
                           #--- PUSHB_1   9         ;PUSH Bytes
SHP[rp2]        9          ;SHift Point using reference point
                           #--- PUSHB_1   6         ;PUSH Bytes
SRP0            6          ;Set Reference Point 0
                           #--- PUSHB_2   1 1       ;PUSH Bytes
CALL            1 1        ;CALL function
                           #--- PUSHB_1   11        ;PUSH Bytes
SHP[rp2]        11         ;SHift Point using reference point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_2   14 1      ;PUSH Bytes
CALL            1 14       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   8 7       ;PUSH Bytes
SRP1            7          ;Set Reference Point 1
SRP2            8          ;Set Reference Point 2
                           #--- PUSHB_3   2 5 10    ;PUSH Bytes
IP              10         ;Interpolate Point
IP              5          ;Interpolate Point
IP              2          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'N': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   4 1 0     ;PUSH Bytes
CALL            0 1 4      ;CALL function
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_3   5 5 0     ;PUSH Bytes
CALL            0 5 5      ;CALL function
                           #--- PUSHB_1   8         ;PUSH Bytes
SHP[rp1]        8          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   10        ;PUSH Bytes
MDAP[rnd]       10         ;Move Direct Absolute Point
                           #--- PUSHB_1   4         ;PUSH Bytes
MDRP[rp0,rnd,white] 4          ;Move Direct Relative Point
                           #--- PUSHB_2   3 16      ;PUSH Bytes
MIRP[min,black] estemw 3   ;Move Indirect Relative Point
                           #--- PUSHB_1   3         ;PUSH Bytes
SRP0            3          ;Set Reference Point 0
                           #--- PUSHB_2   7 1       ;PUSH Bytes
CALL            1 7        ;CALL function
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_2   11 1      ;PUSH Bytes
CALL            1 11       ;CALL function
                           #--- PUSHB_2   3 4       ;PUSH Bytes
SRP1            4          ;Set Reference Point 1
SRP2            3          ;Set Reference Point 2
                           #--- PUSHB_1   6         ;PUSH Bytes
IP              6          ;Interpolate Point
                           #--- PUSHB_1   7         ;PUSH Bytes
SRP1            7          ;Set Reference Point 1
                           #--- PUSHB_1   1         ;PUSH Bytes
IP              1          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   5 4       ;PUSH Bytes
SRP1            4          ;Set Reference Point 1
SRP2            5          ;Set Reference Point 2
                           #--- PUSHB_2   2 7       ;PUSH Bytes
IP              7          ;Interpolate Point
IP              2          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'NULL': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   7 1 0     ;PUSH Bytes
CALL            0 1 7      ;CALL function
                           #--- PUSHB_2   8 14      ;PUSH Bytes
MIRP[min,black] ecstemw 8  ;Move Indirect Relative Point
                           #--- PUSHB_3   3 5 0     ;PUSH Bytes
CALL            0 5 3      ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   10        ;PUSH Bytes
MDAP[rnd]       10         ;Move Direct Absolute Point
                           #--- PUSHB_1   2         ;PUSH Bytes
MDRP[rp0,rnd,white] 2          ;Move Direct Relative Point
                           #--- PUSHB_1   7         ;PUSH Bytes
SHP[rp2]        7          ;SHift Point using reference point
                           #--- PUSHB_2   5 16      ;PUSH Bytes
MIRP[min,black] estemw 5   ;Move Indirect Relative Point
                           #--- PUSHB_2   5 16      ;PUSH Bytes
MIRP[min,black] estemw 5   ;Move Indirect Relative Point
                           #--- PUSHB_1   6         ;PUSH Bytes
SHP[rp2]        6          ;SHift Point using reference point
                           #--- PUSHB_2   11 1      ;PUSH Bytes
CALL            1 11       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   3 8       ;PUSH Bytes
SRP1            8          ;Set Reference Point 1
SRP2            3          ;Set Reference Point 2
                           #--- PUSHB_1   0         ;PUSH Bytes
IP              0          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'O': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   18 14     ;PUSH Bytes
MIRP[min,black] ecstemw 18 ;Move Indirect Relative Point
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_2   12 14     ;PUSH Bytes
MIRP[min,black] ecstemw 12 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   24        ;PUSH Bytes
MDAP[rnd]       24         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   15 16     ;PUSH Bytes
MIRP[min,black] estemw 15  ;Move Indirect Relative Point
                           #--- PUSHB_1   15        ;PUSH Bytes
SRP0            15         ;Set Reference Point 0
                           #--- PUSHB_2   21 1      ;PUSH Bytes
CALL            1 21       ;CALL function
                           #--- PUSHB_2   9 16      ;PUSH Bytes
MIRP[min,black] estemw 9   ;Move Indirect Relative Point
                           #--- PUSHB_2   25 1      ;PUSH Bytes
CALL            1 25       ;CALL function
                           #--- PUSHB_2   21 15     ;PUSH Bytes
SRP1            15         ;Set Reference Point 1
SRP2            21         ;Set Reference Point 2
                           #--- PUSHB_1   0         ;PUSH Bytes
IP              0          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   12 18     ;PUSH Bytes
SRP1            18         ;Set Reference Point 1
SRP2            12         ;Set Reference Point 2
                           #--- PUSHB_2   3 9       ;PUSH Bytes
IP              9          ;Interpolate Point
IP              3          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'P': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   2 5 0     ;PUSH Bytes
CALL            0 5 2      ;CALL function
                           #--- PUSHB_2   18 13     ;PUSH Bytes
MIRP[min,black] ecstemt 18 ;Move Indirect Relative Point
                           #--- PUSHB_5   10 19 1 2 13 ;PUSH Bytes
CALL            13 2 1 19 10 ;CALL function
                           #--- PUSHB_2   10 13     ;PUSH Bytes
MIRP[min,black] ecstemt 10 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   20        ;PUSH Bytes
MDAP[rnd]       20         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_1   18        ;PUSH Bytes
SHP[rp2]        18         ;SHift Point using reference point
                           #--- PUSHB_1   0         ;PUSH Bytes
SRP0            0          ;Set Reference Point 0
                           #--- PUSHB_2   14 1      ;PUSH Bytes
CALL            1 14       ;CALL function
                           #--- PUSHB_2   6 16      ;PUSH Bytes
MIRP[min,black] estemw 6   ;Move Indirect Relative Point
                           #--- PUSHB_2   21 1      ;PUSH Bytes
CALL            1 21       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   18 19     ;PUSH Bytes
SRP1            19         ;Set Reference Point 1
SRP2            18         ;Set Reference Point 2
                           #--- PUSHB_1   6         ;PUSH Bytes
IP              6          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'Q': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_1   20        ;PUSH Bytes
SHP[rp1]        20         ;SHift Point using reference point
                           #--- PUSHB_2   44 14     ;PUSH Bytes
MIRP[min,black] ecstemw 44 ;Move Indirect Relative Point
                           #--- PUSHB_1   14        ;PUSH Bytes
SHP[rp2]        14         ;SHift Point using reference point
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_2   35 14     ;PUSH Bytes
MIRP[min,black] ecstemw 35 ;Move Indirect Relative Point
                           #--- PUSHB_5   50 26 0 6 13 ;PUSH Bytes
CALL            13 6 0 26 50 ;CALL function
                           #--- PUSHB_2   50 14     ;PUSH Bytes
MIRP[min,black] ecstemw 50 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   55        ;PUSH Bytes
MDAP[rnd]       55         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   38 16     ;PUSH Bytes
MIRP[min,black] estemw 38  ;Move Indirect Relative Point
                           #--- PUSHB_1   38        ;PUSH Bytes
SRP0            38         ;Set Reference Point 0
                           #--- PUSHB_2   32 1      ;PUSH Bytes
CALL            1 32       ;CALL function
                           #--- PUSHB_2   9 16      ;PUSH Bytes
MIRP[min,black] estemw 9   ;Move Indirect Relative Point
                           #--- PUSHB_2   56 1      ;PUSH Bytes
CALL            1 56       ;CALL function
                           #--- PUSHB_2   32 38     ;PUSH Bytes
SRP1            38         ;Set Reference Point 1
SRP2            32         ;Set Reference Point 2
                           #--- PUSHB_5   0 23 6 47 53 ;PUSH Bytes
                           #--- DEPTH     #5        ;DEPTH of the stack
SLOOP           5          ;Set LOOP variable
IP              53 47 6 23 0 ;Interpolate Point
                           #--- PUSHB_1   9         ;PUSH Bytes
SRP1            9          ;Set Reference Point 1
                           #--- PUSHB_3   12 14 20  ;PUSH Bytes
IP              20         ;Interpolate Point
IP              14         ;Interpolate Point
IP              12         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   44 0      ;PUSH Bytes
SRP1            0          ;Set Reference Point 1
SRP2            44         ;Set Reference Point 2
                           #--- PUSHB_2   17 23     ;PUSH Bytes
IP              23         ;Interpolate Point
IP              17         ;Interpolate Point
                           #--- PUSHB_1   50        ;PUSH Bytes
SRP1            50         ;Set Reference Point 1
                           #--- PUSHB_3   12 16 41  ;PUSH Bytes
IP              41         ;Interpolate Point
IP              16         ;Interpolate Point
IP              12         ;Interpolate Point
                           #--- PUSHB_1   26        ;PUSH Bytes
SRP2            26         ;Set Reference Point 2
                           #--- PUSHB_1   29        ;PUSH Bytes
IP              29         ;Interpolate Point
                           #--- PUSHB_1   35        ;PUSH Bytes
SRP1            35         ;Set Reference Point 1
                           #--- PUSHB_4   3 9 32 38 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
IP              38 32 9 3  ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'R': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   5 1 0     ;PUSH Bytes
CALL            0 1 5      ;CALL function
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_2   21 13     ;PUSH Bytes
MIRP[min,black] ecstemt 21 ;Move Indirect Relative Point
                           #--- PUSHB_5   3 22 5 6 13 ;PUSH Bytes
CALL            13 6 5 22 3 ;CALL function
                           #--- PUSHB_2   3 13      ;PUSH Bytes
MIRP[min,black] ecstemt 3  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   23        ;PUSH Bytes
MDAP[rnd]       23         ;Move Direct Absolute Point
                           #--- PUSHB_1   5         ;PUSH Bytes
MDRP[rp0,rnd,white] 5          ;Move Direct Relative Point
                           #--- PUSHB_2   4 16      ;PUSH Bytes
MIRP[min,black] estemw 4   ;Move Indirect Relative Point
                           #--- PUSHB_1   21        ;PUSH Bytes
SHP[rp2]        21         ;SHift Point using reference point
                           #--- PUSHB_1   4         ;PUSH Bytes
SRP0            4          ;Set Reference Point 0
                           #--- PUSHB_2   17 1      ;PUSH Bytes
CALL            1 17       ;CALL function
                           #--- PUSHB_2   10 16     ;PUSH Bytes
MIRP[min,black] estemw 10  ;Move Indirect Relative Point
                           #--- PUSHB_2   24 1      ;PUSH Bytes
CALL            1 24       ;CALL function
                           #--- PUSHB_2   17 4      ;PUSH Bytes
SRP1            4          ;Set Reference Point 1
SRP2            17         ;Set Reference Point 2
                           #--- PUSHB_2   2 13      ;PUSH Bytes
IP              13         ;Interpolate Point
IP              2          ;Interpolate Point
                           #--- PUSHB_1   10        ;PUSH Bytes
SRP1            10         ;Set Reference Point 1
                           #--- PUSHB_1   1         ;PUSH Bytes
IP              1          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   22 3      ;PUSH Bytes
SRP1            3          ;Set Reference Point 1
SRP2            22         ;Set Reference Point 2
                           #--- PUSHB_1   13        ;PUSH Bytes
IP              13         ;Interpolate Point
                           #--- PUSHB_1   21        ;PUSH Bytes
SRP1            21         ;Set Reference Point 1
                           #--- PUSHB_1   10        ;PUSH Bytes
IP              10         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'S': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   7 14      ;PUSH Bytes
MIRP[min,black] ecstemw 7  ;Move Indirect Relative Point
                           #--- PUSHB_3   7 0 10    ;PUSH Bytes
CALL            10 0 7     ;CALL function
                           #--- PUSHB_4   64 7 3 9  ;PUSH Bytes
CALL            9 3 7 64   ;CALL function
                           #--- PUSHB_3   20 5 0    ;PUSH Bytes
CALL            0 5 20     ;CALL function
                           #--- PUSHB_2   27 14     ;PUSH Bytes
MIRP[min,black] ecstemw 27 ;Move Indirect Relative Point
                           #--- PUSHB_3   27 20 10  ;PUSH Bytes
CALL            10 20 27   ;CALL function
                           #--- PUSHB_4   64 27 24 9 ;PUSH Bytes
CALL            9 24 27 64 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   40        ;PUSH Bytes
MDAP[rnd]       40         ;Move Direct Absolute Point
                           #--- PUSHB_1   17        ;PUSH Bytes
MDRP[rp0,rnd,white] 17         ;Move Direct Relative Point
                           #--- PUSHB_2   30 16     ;PUSH Bytes
MIRP[min,black] estemw 30  ;Move Indirect Relative Point
                           #--- PUSHB_1   3         ;PUSH Bytes
DUP             3          ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   4 16      ;PUSH Bytes
MIRP[min,black] estemw 4   ;Move Indirect Relative Point
                           #--- PUSHB_1   30        ;PUSH Bytes
SRP0            30         ;Set Reference Point 0
                           #--- PUSHB_2   10 1      ;PUSH Bytes
CALL            1 10       ;CALL function
                           #--- PUSHB_2   37 16     ;PUSH Bytes
MIRP[min,black] estemw 37  ;Move Indirect Relative Point
                           #--- PUSHB_1   24        ;PUSH Bytes
DUP             24         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   23 16     ;PUSH Bytes
MIRP[min,black] estemw 23  ;Move Indirect Relative Point
                           #--- PUSHB_2   41 1      ;PUSH Bytes
CALL            1 41       ;CALL function
                           #--- PUSHB_1   54        ;PUSH Bytes
SMD             54         ;Set Minimum Distance
                           #--- PUSHB_2   14 13     ;PUSH Bytes
SDPVTL[orthog]  13 14      ;Set Dual Projection Vector To Line
                           #--- PUSHB_1   14        ;PUSH Bytes
MDAP[no-rnd]    14         ;Move Direct Absolute Point
                           #--- PUSHB_1   13        ;PUSH Bytes
MDRP[grey]      13         ;Move Direct Relative Point
                           #--- PUSHB_2   33 18     ;PUSH Bytes
MIRP[rp0,min,black] cvt_18 33  ;Move Indirect Relative Point
                           #--- PUSHB_1   34        ;PUSH Bytes
MDRP[grey]      34         ;Move Direct Relative Point
SPVTCA[x-axis]             ;Set Projection Vector To Coordinate Axis
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_4   13 14 33 34 ;PUSH Bytes
MDAP[no-rnd]    34         ;Move Direct Absolute Point
MDAP[no-rnd]    33         ;Move Direct Absolute Point
MDAP[no-rnd]    14         ;Move Direct Absolute Point
MDAP[no-rnd]    13         ;Move Direct Absolute Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_4   13 14 33 34 ;PUSH Bytes
MDAP[no-rnd]    34         ;Move Direct Absolute Point
MDAP[no-rnd]    33         ;Move Direct Absolute Point
MDAP[no-rnd]    14         ;Move Direct Absolute Point
MDAP[no-rnd]    13         ;Move Direct Absolute Point
                           #--- PUSHB_1   64        ;PUSH Bytes
SMD             64         ;Set Minimum Distance
                           #--- PUSHB_2   24 30     ;PUSH Bytes
SRP1            30         ;Set Reference Point 1
SRP2            24         ;Set Reference Point 2
                           #--- PUSHB_3   0 7 20    ;PUSH Bytes
IP              20         ;Interpolate Point
IP              7          ;Interpolate Point
IP              0          ;Interpolate Point
                           #--- PUSHB_2   23 10     ;PUSH Bytes
SRP1            10         ;Set Reference Point 1
SRP2            23         ;Set Reference Point 2
                           #--- PUSHB_1   22        ;PUSH Bytes
IP              22         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   27 7      ;PUSH Bytes
SRP1            7          ;Set Reference Point 1
SRP2            27         ;Set Reference Point 2
                           #--- PUSHB_2   17 37     ;PUSH Bytes
IP              37         ;Interpolate Point
IP              17         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'T': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   4 5 0     ;PUSH Bytes
CALL            0 5 4      ;CALL function
                           #--- PUSHB_2   3 13      ;PUSH Bytes
MIRP[min,black] ecstemt 3  ;Move Indirect Relative Point
                           #--- PUSHB_1   6         ;PUSH Bytes
SHP[rp2]        6          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_3   0 1 10    ;PUSH Bytes
CALL            10 1 0     ;CALL function
                           #--- PUSHB_4   64 0 6 9  ;PUSH Bytes
CALL            9 6 0 64   ;CALL function
                           #--- PUSHB_3   1 0 10    ;PUSH Bytes
CALL            10 0 1     ;CALL function
                           #--- PUSHB_4   64 1 3 9  ;PUSH Bytes
CALL            9 3 1 64   ;CALL function
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'U': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   9 14      ;PUSH Bytes
MIRP[min,black] ecstemw 9  ;Move Indirect Relative Point
                           #--- PUSHB_3   4 5 0     ;PUSH Bytes
CALL            0 5 4      ;CALL function
                           #--- PUSHB_1   13        ;PUSH Bytes
SHP[rp1]        13         ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   18        ;PUSH Bytes
MDAP[rnd]       18         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   6 16      ;PUSH Bytes
MIRP[min,black] estemw 6   ;Move Indirect Relative Point
                           #--- PUSHB_1   6         ;PUSH Bytes
SRP0            6          ;Set Reference Point 0
                           #--- PUSHB_2   12 1      ;PUSH Bytes
CALL            1 12       ;CALL function
                           #--- PUSHB_2   15 16     ;PUSH Bytes
MIRP[min,black] estemw 15  ;Move Indirect Relative Point
                           #--- PUSHB_2   19 1      ;PUSH Bytes
CALL            1 19       ;CALL function
                           #--- PUSHB_2   12 6      ;PUSH Bytes
SRP1            6          ;Set Reference Point 1
SRP2            12         ;Set Reference Point 2
                           #--- PUSHB_1   0         ;PUSH Bytes
IP              0          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'V': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   2 5 0     ;PUSH Bytes
CALL            0 5 2      ;CALL function
                           #--- PUSHB_1   5         ;PUSH Bytes
SHP[rp1]        5          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   7         ;PUSH Bytes
MDAP[rnd]       7          ;Move Direct Absolute Point
                           #--- PUSHB_2   8 1       ;PUSH Bytes
CALL            1 8        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   2 1       ;PUSH Bytes
SRP1            1          ;Set Reference Point 1
SRP2            2          ;Set Reference Point 2
                           #--- PUSHB_1   4         ;PUSH Bytes
IP              4          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'W': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   4 1 0     ;PUSH Bytes
CALL            0 1 4      ;CALL function
                           #--- PUSHB_3   0 1 3     ;PUSH Bytes
SHP[rp1]        3          ;SHift Point using reference point
SHP[rp1]        1          ;SHift Point using reference point
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_3   5 5 0     ;PUSH Bytes
CALL            0 5 5      ;CALL function
                           #--- PUSHB_5   6 8 9 11 12 ;PUSH Bytes
                           #--- DEPTH     #5        ;DEPTH of the stack
SLOOP           5          ;Set LOOP variable
SHP[rp1]        12 11 9 8 6 ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   13        ;PUSH Bytes
MDAP[rnd]       13         ;Move Direct Absolute Point
                           #--- PUSHB_2   14 1      ;PUSH Bytes
CALL            1 14       ;CALL function
                           #--- PUSHB_1   54        ;PUSH Bytes
SMD             54         ;Set Minimum Distance
                           #--- PUSHB_2   5 4       ;PUSH Bytes
SDPVTL[orthog]  4 5        ;Set Dual Projection Vector To Line
                           #--- PUSHB_1   5         ;PUSH Bytes
MDAP[no-rnd]    5          ;Move Direct Absolute Point
                           #--- PUSHB_1   7         ;PUSH Bytes
MDAP[no-rnd]    7          ;Move Direct Absolute Point
                           #--- PUSHB_1   5         ;PUSH Bytes
SRP0            5          ;Set Reference Point 0
                           #--- PUSHB_2   6 19      ;PUSH Bytes
MIRP[rp0,min,black] cvt_19 6   ;Move Indirect Relative Point
                           #--- PUSHB_1   7         ;PUSH Bytes
SRP0            7          ;Set Reference Point 0
                           #--- PUSHB_2   4 19      ;PUSH Bytes
MIRP[rp0,min,black] cvt_19 4   ;Move Indirect Relative Point
                           #--- PUSHB_2   7 8       ;PUSH Bytes
SDPVTL[orthog]  8 7        ;Set Dual Projection Vector To Line
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[no-rnd]    8          ;Move Direct Absolute Point
                           #--- PUSHB_2   6 7       ;PUSH Bytes
SFVTL[parallel] 7 6        ;Set Freedom Vector To Line
                           #--- PUSHB_1   7         ;PUSH Bytes
MDRP[grey]      7          ;Move Direct Relative Point
SFVTCA[y-axis]             ;Set Freedom Vector To Coordinate Axis
                           #--- PUSHB_2   2 20      ;PUSH Bytes
MIRP[rp0,min,black] cvt_20 2   ;Move Indirect Relative Point
SFVTCA[x-axis]             ;Set Freedom Vector To Coordinate Axis
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[grey]      3          ;Move Direct Relative Point
                           #--- PUSHB_2   2 1       ;PUSH Bytes
SDPVTL[orthog]  1 2        ;Set Dual Projection Vector To Line
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[no-rnd]    1          ;Move Direct Absolute Point
                           #--- PUSHB_2   3 2       ;PUSH Bytes
SFVTL[parallel] 2 3        ;Set Freedom Vector To Line
                           #--- PUSHB_1   2         ;PUSH Bytes
MDRP[grey]      2          ;Move Direct Relative Point
SFVTCA[x-axis]             ;Set Freedom Vector To Coordinate Axis
                           #--- PUSHB_2   10 20     ;PUSH Bytes
MIRP[rp0,min,black] cvt_20 10  ;Move Indirect Relative Point
                           #--- PUSHB_1   9         ;PUSH Bytes
MDRP[grey]      9          ;Move Direct Relative Point
                           #--- PUSHB_2   10 11     ;PUSH Bytes
SDPVTL[orthog]  11 10      ;Set Dual Projection Vector To Line
                           #--- PUSHB_1   11        ;PUSH Bytes
MDAP[no-rnd]    11         ;Move Direct Absolute Point
                           #--- PUSHB_1   0         ;PUSH Bytes
MDAP[no-rnd]    0          ;Move Direct Absolute Point
                           #--- PUSHB_1   11        ;PUSH Bytes
SRP0            11         ;Set Reference Point 0
                           #--- PUSHB_2   12 21     ;PUSH Bytes
MIRP[rp0,min,black] cvt_21 12  ;Move Indirect Relative Point
                           #--- PUSHB_2   9 10      ;PUSH Bytes
SFVTL[parallel] 10 9       ;Set Freedom Vector To Line
                           #--- PUSHB_1   0         ;PUSH Bytes
SRP0            0          ;Set Reference Point 0
                           #--- PUSHB_2   10 21     ;PUSH Bytes
MIRP[rp0,min,black] cvt_21 10  ;Move Indirect Relative Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   2 7 10    ;PUSH Bytes
MDAP[no-rnd]    10         ;Move Direct Absolute Point
MDAP[no-rnd]    7          ;Move Direct Absolute Point
MDAP[no-rnd]    2          ;Move Direct Absolute Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- NPUSHB    13 0 1 2 3 4 5 6 7 8 9 10 11 12 ;PUSH N Bytes
MDAP[no-rnd]    12         ;Move Direct Absolute Point
MDAP[no-rnd]    11         ;Move Direct Absolute Point
MDAP[no-rnd]    10         ;Move Direct Absolute Point
MDAP[no-rnd]    9          ;Move Direct Absolute Point
MDAP[no-rnd]    8          ;Move Direct Absolute Point
MDAP[no-rnd]    7          ;Move Direct Absolute Point
MDAP[no-rnd]    6          ;Move Direct Absolute Point
MDAP[no-rnd]    5          ;Move Direct Absolute Point
MDAP[no-rnd]    4          ;Move Direct Absolute Point
MDAP[no-rnd]    3          ;Move Direct Absolute Point
MDAP[no-rnd]    2          ;Move Direct Absolute Point
MDAP[no-rnd]    1          ;Move Direct Absolute Point
MDAP[no-rnd]    0          ;Move Direct Absolute Point
                           #--- PUSHB_1   64        ;PUSH Bytes
SMD             64         ;Set Minimum Distance
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'X': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   4 1 0     ;PUSH Bytes
CALL            0 1 4      ;CALL function
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_1   9         ;PUSH Bytes
SHP[rp1]        9          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   12        ;PUSH Bytes
MDAP[rnd]       12         ;Move Direct Absolute Point
                           #--- PUSHB_2   13 1      ;PUSH Bytes
CALL            1 13       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   6 4       ;PUSH Bytes
SRP1            4          ;Set Reference Point 1
SRP2            6          ;Set Reference Point 2
                           #--- PUSHB_2   2 8       ;PUSH Bytes
IP              8          ;Interpolate Point
IP              2          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'Y': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   3 5 0     ;PUSH Bytes
CALL            0 5 3      ;CALL function
                           #--- PUSHB_1   6         ;PUSH Bytes
SHP[rp1]        6          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   9         ;PUSH Bytes
MDAP[rnd]       9          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_2   10 1      ;PUSH Bytes
CALL            1 10       ;CALL function
                           #--- PUSHB_2   0 1       ;PUSH Bytes
SRP1            1          ;Set Reference Point 1
SRP2            0          ;Set Reference Point 2
                           #--- PUSHB_1   5         ;PUSH Bytes
IP              5          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   3 1       ;PUSH Bytes
SRP1            1          ;Set Reference Point 1
SRP2            3          ;Set Reference Point 2
                           #--- PUSHB_1   5         ;PUSH Bytes
IP              5          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'Z': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_2   8 13      ;PUSH Bytes
MIRP[min,black] ecstemt 8  ;Move Indirect Relative Point
                           #--- PUSHB_3   5 5 0     ;PUSH Bytes
CALL            0 5 5      ;CALL function
                           #--- PUSHB_2   4 13      ;PUSH Bytes
MIRP[min,black] ecstemt 4  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   10        ;PUSH Bytes
MDAP[rnd]       10         ;Move Direct Absolute Point
                           #--- PUSHB_2   11 1      ;PUSH Bytes
CALL            1 11       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   4 8       ;PUSH Bytes
SRP1            8          ;Set Reference Point 1
SRP2            4          ;Set Reference Point 2
                           #--- PUSHB_2   2 7       ;PUSH Bytes
IP              7          ;Interpolate Point
IP              2          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'a': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   6 1 0     ;PUSH Bytes
CALL            0 1 6      ;CALL function
                           #--- PUSHB_2   34 10     ;PUSH Bytes
MIRP[min,black] estemt 34  ;Move Indirect Relative Point
                           #--- PUSHB_3   27 3 0    ;PUSH Bytes
CALL            0 3 27     ;CALL function
                           #--- PUSHB_2   20 6      ;PUSH Bytes
MIRP[min,black] estemtc 20 ;Move Indirect Relative Point
                           #--- PUSHB_5   16 38 6 27 13 ;PUSH Bytes
CALL            13 27 6 38 16 ;CALL function
                           #--- PUSHB_2   16 10     ;PUSH Bytes
MIRP[min,black] estemt 16  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   47        ;PUSH Bytes
MDAP[rnd]       47         ;Move Direct Absolute Point
                           #--- PUSHB_1   9         ;PUSH Bytes
MDRP[rp0,rnd,white] 9          ;Move Direct Relative Point
                           #--- PUSHB_2   44 16     ;PUSH Bytes
MIRP[min,black] estemw 44  ;Move Indirect Relative Point
                           #--- PUSHB_1   44        ;PUSH Bytes
#SRP0            44         ;Set Reference Point 0
#                           #--- PUSHB_2   37 1      ;PUSH Bytes
#CALL            1 37       ;CALL function
#                           #--- PUSHB_2   3 16      ;PUSH Bytes
#SHP[rp2]        16         ;SHift Point using reference point
#SHP[rp2]        3          ;SHift Point using reference point
#                           #--- PUSHB_2   31 16     ;PUSH Bytes
#MIRP[min,black] estemw 31  ;Move Indirect Relative Point
#                           #--- PUSHB_2   48 1      ;PUSH Bytes
#CALL            1 48       ;CALL function
#                           #--- PUSHB_1   54        ;PUSH Bytes
srp0    48
mdrp[rp0,min,rnd,white] 31
mdrp[rp0,min,rnd,grey] 37
alignrp 16
mirp[min,black] estemw 31
#
SMD             54         ;Set Minimum Distance
                           #--- PUSHB_2   11 14     ;PUSH Bytes
SDPVTL[orthog]  14 11      ;Set Dual Projection Vector To Line
                           #--- PUSHB_1   11        ;PUSH Bytes
MDAP[no-rnd]    11         ;Move Direct Absolute Point
                           #--- PUSHB_1   14        ;PUSH Bytes
MDRP[grey]      14         ;Move Direct Relative Point
                           #--- PUSHB_2   41 23     ;PUSH Bytes
MIRP[rp0,min,black] cvt_23 41  ;Move Indirect Relative Point
                           #--- PUSHB_1   40        ;PUSH Bytes
MDRP[grey]      40         ;Move Direct Relative Point
                           #--- PUSHB_1   11        ;PUSH Bytes
SRP0            11         ;Set Reference Point 0
                           #--- PUSHB_4   12 11 14 19 ;PUSH Bytes
CALL            19 14 11 12 ;CALL function
                           #--- PUSHB_3   12 11 14  ;PUSH Bytes
DUP             14         ;DUPlicate top stack element
ROLL            &_DUP_1 &_DUP_2 11 ;ROLL the top three stack elements
DUP             &_ROLL_1   ;DUPlicate top stack element
ROLL            &_DUP_1 &_DUP_2 &_ROLL_2 ;ROLL the top three stack elements
SWAP            &_ROLL_1 &_ROLL_2 ;SWAP the top two elements on the stack
SPVTL[parallel] &_SWAP_1 &_SWAP_2 ;Set Projection Vector To Line
SFVTPV                     ;Set Freedom Vector To Projection Vector
SRP1            &_ROLL_3   ;Set Reference Point 1
SRP2            &_ROLL_3   ;Set Reference Point 2
IP              12         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_4   12 14 40 41 ;PUSH Bytes
MDAP[no-rnd]    41         ;Move Direct Absolute Point
MDAP[no-rnd]    40         ;Move Direct Absolute Point
MDAP[no-rnd]    14         ;Move Direct Absolute Point
MDAP[no-rnd]    12         ;Move Direct Absolute Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_4   12 14 40 41 ;PUSH Bytes
MDAP[no-rnd]    41         ;Move Direct Absolute Point
MDAP[no-rnd]    40         ;Move Direct Absolute Point
MDAP[no-rnd]    14         ;Move Direct Absolute Point
MDAP[no-rnd]    12         ;Move Direct Absolute Point
                           #--- PUSHB_1   64        ;PUSH Bytes
SMD             64         ;Set Minimum Distance
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   44 9      ;PUSH Bytes
SRP1            9          ;Set Reference Point 1
SRP2            44         ;Set Reference Point 2
                           #--- PUSHB_1   24        ;PUSH Bytes
IP              24         ;Interpolate Point
                           #--- PUSHB_1   37        ;PUSH Bytes
SRP1            37         ;Set Reference Point 1
                           #--- PUSHB_3   6 23 27   ;PUSH Bytes
IP              27         ;Interpolate Point
IP              23         ;Interpolate Point
IP              6          ;Interpolate Point
                           #--- PUSHB_1   31        ;PUSH Bytes
SRP2            31         ;Set Reference Point 2
                           #--- PUSHB_1   1         ;PUSH Bytes
IP              1          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   38 34     ;PUSH Bytes
SRP1            34         ;Set Reference Point 1
SRP2            38         ;Set Reference Point 2
                           #--- PUSHB_3   9 31 3    ;PUSH Bytes
IP              3          ;Interpolate Point
IP              31         ;Interpolate Point
IP              9          ;Interpolate Point
                           #--- PUSHB_2   20 16     ;PUSH Bytes
SRP1            16         ;Set Reference Point 1
SRP2            20         ;Set Reference Point 2
                           #--- PUSHB_3   23 24 30  ;PUSH Bytes
IP              30         ;Interpolate Point
IP              24         ;Interpolate Point
IP              23         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'acute': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_5   2 14 0 11 4 ;PUSH Bytes
CALL            4 11 0 14 2 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_5   3 16 0 10 4 ;PUSH Bytes
CALL            4 10 0 16 3 ;CALL function
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'afii00208': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   2 6       ;PUSH Bytes
MIRP[min,black] estemtc 2  ;Move Indirect Relative Point
                           #--- PUSHB_2   2 6       ;PUSH Bytes
MIRP[min,black] estemtc 2  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'afii299': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   4 4 0     ;PUSH Bytes
CALL            0 4 4      ;CALL function
                           #--- PUSHB_5   7 7 0 20 4 ;PUSH Bytes
CALL            4 20 0 7 7 ;CALL function
                           #--- PUSHB_3   4 7 10    ;PUSH Bytes
CALL            10 7 4     ;CALL function
                           #--- PUSHB_4   64 4 6 9  ;PUSH Bytes
CALL            9 6 4 64   ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   11        ;PUSH Bytes
MDAP[rnd]       11         ;Move Direct Absolute Point
                           #--- PUSHB_1   6         ;PUSH Bytes
MDRP[rp0,rnd,white] 6          ;Move Direct Relative Point
                           #--- PUSHB_5   5 15 0 20 4 ;PUSH Bytes
CALL            4 20 0 15 5 ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   7 4       ;PUSH Bytes
SRP1            4          ;Set Reference Point 1
SRP2            7          ;Set Reference Point 2
                           #--- PUSHB_1   0         ;PUSH Bytes
IP              0          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'afii300': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   3 4 0     ;PUSH Bytes
CALL            0 4 3      ;CALL function
                           #--- PUSHB_5   9 7 0 20 4 ;PUSH Bytes
CALL            4 20 0 7 9 ;CALL function
                           #--- PUSHB_3   3 9 10    ;PUSH Bytes
CALL            10 9 3     ;CALL function
                           #--- PUSHB_4   64 3 1 9  ;PUSH Bytes
CALL            9 1 3 64   ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   11        ;PUSH Bytes
MDAP[rnd]       11         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_5   0 15 0 20 4 ;PUSH Bytes
CALL            4 20 0 15 0 ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   9 3       ;PUSH Bytes
SRP1            3          ;Set Reference Point 1
SRP2            9          ;Set Reference Point 2
                           #--- PUSHB_1   6         ;PUSH Bytes
IP              6          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'afii61664': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   2         ;PUSH Bytes
MDRP[rp0,rnd,white] 2          ;Move Direct Relative Point
                           #--- PUSHB_5   1 15 0 20 4 ;PUSH Bytes
CALL            4 20 0 15 1 ;CALL function
                           #--- PUSHB_5   1 15 0 20 4 ;PUSH Bytes
CALL            4 20 0 15 1 ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'ampersand': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   49 6      ;PUSH Bytes
MIRP[min,black] estemtc 49 ;Move Indirect Relative Point
                           #--- PUSHB_1   38        ;PUSH Bytes
MDAP[rnd]       38         ;Move Direct Absolute Point
                           #--- PUSHB_2   12 10     ;PUSH Bytes
MIRP[min,black] estemt 12  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   53        ;PUSH Bytes
MDAP[rnd]       53         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   46 16     ;PUSH Bytes
MIRP[min,black] estemw 46  ;Move Indirect Relative Point
                           #--- PUSHB_4   9 46 3 8  ;PUSH Bytes
CALL            8 3 46 9   ;CALL function
                           #--- PUSHB_2   40 16     ;PUSH Bytes
MIRP[min,black] estemw 40  ;Move Indirect Relative Point
                           #--- PUSHB_1   46        ;PUSH Bytes
SRP0            46         ;Set Reference Point 0
                           #--- PUSHB_2   35 1      ;PUSH Bytes
CALL            1 35       ;CALL function
                           #--- PUSHB_2   15 16     ;PUSH Bytes
MIRP[min,black] estemw 15  ;Move Indirect Relative Point
                           #--- PUSHB_1   15        ;PUSH Bytes
SRP0            15         ;Set Reference Point 0
                           #--- PUSHB_2   21 1      ;PUSH Bytes
CALL            1 21       ;CALL function
                           #--- PUSHB_2   22 16     ;PUSH Bytes
MIRP[min,black] estemw 22  ;Move Indirect Relative Point
                           #--- PUSHB_2   54 1      ;PUSH Bytes
CALL            1 54       ;CALL function
                           #--- PUSHB_2   40 46     ;PUSH Bytes
SRP1            46         ;Set Reference Point 1
SRP2            40         ;Set Reference Point 2
                           #--- PUSHB_1   6         ;PUSH Bytes
IP              6          ;Interpolate Point
                           #--- PUSHB_1   35        ;PUSH Bytes
SRP1            35         ;Set Reference Point 1
                           #--- PUSHB_4   0 18 43 49 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
IP              49 43 18 0 ;Interpolate Point
                           #--- PUSHB_1   15        ;PUSH Bytes
SRP2            15         ;Set Reference Point 2
                           #--- PUSHB_3   19 29 52  ;PUSH Bytes
IP              52         ;Interpolate Point
IP              29         ;Interpolate Point
IP              19         ;Interpolate Point
                           #--- PUSHB_2   22 21     ;PUSH Bytes
SRP1            21         ;Set Reference Point 1
SRP2            22         ;Set Reference Point 2
                           #--- PUSHB_2   24 27     ;PUSH Bytes
IP              27         ;Interpolate Point
IP              24         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   49 0      ;PUSH Bytes
SRP1            0          ;Set Reference Point 1
SRP2            49         ;Set Reference Point 2
                           #--- PUSHB_1   26        ;PUSH Bytes
IP              26         ;Interpolate Point
                           #--- PUSHB_1   38        ;PUSH Bytes
SRP1            38         ;Set Reference Point 1
                           #--- PUSHB_7   3 9 15 24 29 32 43 ;PUSH Bytes
                           #--- DEPTH     #7        ;DEPTH of the stack
SLOOP           7          ;Set LOOP variable
IP              43 32 29 24 15 9 3 ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'asciicircum': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   2 9       ;PUSH Bytes
MIRP[min,black] headstem 2 ;Move Indirect Relative Point
                           #--- PUSHB_2   2 9       ;PUSH Bytes
MIRP[min,black] headstem 2 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'asciitilde': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   5         ;PUSH Bytes
MDAP[rnd]       5          ;Move Direct Absolute Point
                           #--- PUSHB_2   12 14     ;PUSH Bytes
MIRP[min,black] ecstemw 12 ;Move Indirect Relative Point
                           #--- PUSHB_1   20        ;PUSH Bytes
SHP[rp2]        20         ;SHift Point using reference point
                           #--- PUSHB_4   17 12 5 8 ;PUSH Bytes
CALL            8 5 12 17  ;CALL function
                           #--- PUSHB_2   0 14      ;PUSH Bytes
MIRP[min,black] ecstemw 0  ;Move Indirect Relative Point
                           #--- PUSHB_1   8         ;PUSH Bytes
SHP[rp2]        8          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   24        ;PUSH Bytes
MDAP[rnd]       24         ;Move Direct Absolute Point
                           #--- PUSHB_2   25 1      ;PUSH Bytes
CALL            1 25       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   5 0       ;PUSH Bytes
SRP1            0          ;Set Reference Point 1
SRP2            5          ;Set Reference Point 2
                           #--- PUSHB_1   21        ;PUSH Bytes
IP              21         ;Interpolate Point
                           #--- PUSHB_2   12 17     ;PUSH Bytes
SRP1            17         ;Set Reference Point 1
SRP2            12         ;Set Reference Point 2
                           #--- PUSHB_1   9         ;PUSH Bytes
IP              9          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'asterisk': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_5   14 14 0 7 4 ;PUSH Bytes
CALL            4 7 0 14 14 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   25        ;PUSH Bytes
MDAP[rnd]       25         ;Move Direct Absolute Point
                           #--- PUSHB_1   14        ;PUSH Bytes
MDRP[rp0,rnd,white] 14         ;Move Direct Relative Point
                           #--- PUSHB_2   15 15     ;PUSH Bytes
MIRP[min,black] headstem_thick 15 ;Move Indirect Relative Point
                           #--- PUSHB_2   26 1      ;PUSH Bytes
CALL            1 26       ;CALL function
                           #--- PUSHB_2   15 14     ;PUSH Bytes
SRP1            14         ;Set Reference Point 1
SRP2            15         ;Set Reference Point 2
                           #--- PUSHB_3   2 12 17   ;PUSH Bytes
IP              17         ;Interpolate Point
IP              12         ;Interpolate Point
IP              2          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   14 4      ;PUSH Bytes
SRP1            4          ;Set Reference Point 1
SRP2            14         ;Set Reference Point 2
                           #--- PUSHB_1   2         ;PUSH Bytes
IP              2          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'at': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   18 1 0    ;PUSH Bytes
CALL            0 1 18     ;CALL function
                           #--- PUSHB_2   54 11     ;PUSH Bytes
MIRP[min,black] cvt_11 54  ;Move Indirect Relative Point
                           #--- PUSHB_1   35        ;PUSH Bytes
SHP[rp2]        35         ;SHift Point using reference point
                           #--- PUSHB_1   54        ;PUSH Bytes
SRP0            54         ;Set Reference Point 0
                           #--- PUSHB_2   12 14     ;PUSH Bytes
MIRP[min,black] ecstemw 12 ;Move Indirect Relative Point
                           #--- PUSHB_3   24 3 0    ;PUSH Bytes
CALL            0 3 24     ;CALL function
                           #--- PUSHB_1   28        ;PUSH Bytes
SHP[rp1]        28         ;SHift Point using reference point
                           #--- PUSHB_2   60 6      ;PUSH Bytes
MIRP[min,black] estemtc 60 ;Move Indirect Relative Point
                           #--- PUSHB_1   0         ;PUSH Bytes
MDAP[rnd]       0          ;Move Direct Absolute Point
                           #--- PUSHB_2   47 6      ;PUSH Bytes
MIRP[min,black] estemtc 47 ;Move Indirect Relative Point
                           #--- PUSHB_3   47 0 10   ;PUSH Bytes
CALL            10 0 47    ;CALL function
                           #--- PUSHB_4   64 47 51 9 ;PUSH Bytes
CALL            9 51 47 64 ;CALL function
                           #--- PUSHB_1   41        ;PUSH Bytes
MDAP[rnd]       41         ;Move Direct Absolute Point
                           #--- PUSHB_2   6 6       ;PUSH Bytes
MIRP[min,black] estemtc 6  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   66        ;PUSH Bytes
MDAP[rnd]       66         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   44 15     ;PUSH Bytes
MIRP[min,black] headstem_thick 44 ;Move Indirect Relative Point
                           #--- PUSHB_1   44        ;PUSH Bytes
SRP0            44         ;Set Reference Point 0
                           #--- PUSHB_2   21 1      ;PUSH Bytes
CALL            1 21       ;CALL function
                           #--- PUSHB_2   63 16     ;PUSH Bytes
MIRP[min,black] estemw 63  ;Move Indirect Relative Point
                           #--- PUSHB_1   63        ;PUSH Bytes
SRP0            63         ;Set Reference Point 0
                           #--- PUSHB_2   38 1      ;PUSH Bytes
CALL            1 38       ;CALL function
                           #--- PUSHB_2   9 15      ;PUSH Bytes
MIRP[min,black] headstem_thick 9 ;Move Indirect Relative Point
                           #--- PUSHB_2   67 1      ;PUSH Bytes
CALL            1 67       ;CALL function
                           #--- PUSHB_2   38 63     ;PUSH Bytes
SRP1            63         ;Set Reference Point 1
SRP2            38         ;Set Reference Point 2
                           #--- PUSHB_8   6 0 12 18 24 41 47 57 ;PUSH Bytes
                           #--- DEPTH     #8        ;DEPTH of the stack
SLOOP           8          ;Set LOOP variable
IP              57 47 41 24 18 12 0 6 ;Interpolate Point
                           #--- PUSHB_1   9         ;PUSH Bytes
SRP1            9          ;Set Reference Point 1
                           #--- PUSHB_1   50        ;PUSH Bytes
IP              50         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   54 18     ;PUSH Bytes
SRP1            18         ;Set Reference Point 1
SRP2            54         ;Set Reference Point 2
                           #--- PUSHB_1   15        ;PUSH Bytes
IP              15         ;Interpolate Point
                           #--- PUSHB_1   60        ;PUSH Bytes
SRP1            60         ;Set Reference Point 1
                           #--- PUSHB_8   9 21 32 3 38 44 57 63 ;PUSH Bytes
                           #--- DEPTH     #8        ;DEPTH of the stack
SLOOP           8          ;Set LOOP variable
IP              63 57 44 38 3 32 21 9 ;Interpolate Point
                           #--- PUSHB_1   24        ;PUSH Bytes
SRP2            24         ;Set Reference Point 2
                           #--- PUSHB_1   27        ;PUSH Bytes
IP              27         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'b': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   13 1 0    ;PUSH Bytes
CALL            0 1 13     ;CALL function
                           #--- PUSHB_2   17 6      ;PUSH Bytes
MIRP[min,black] estemtc 17 ;Move Indirect Relative Point
                           #--- PUSHB_3   2 5 0     ;PUSH Bytes
CALL            0 5 2      ;CALL function
                           #--- PUSHB_3   7 3 0     ;PUSH Bytes
CALL            0 3 7      ;CALL function
                           #--- PUSHB_2   23 6      ;PUSH Bytes
MIRP[min,black] estemtc 23 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   29        ;PUSH Bytes
MDAP[rnd]       29         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
f_deltap 1 9-8 1 10-8 1 11-8 1 20-8 
                           #--- PUSHB_2   26 16     ;PUSH Bytes
MIRP[min,black] estemw 26  ;Move Indirect Relative Point
                           #--- PUSHB_2   0 3       ;PUSH Bytes
SHP[rp2]        3          ;SHift Point using reference point
SHP[rp2]        0          ;SHift Point using reference point
                           #--- PUSHB_1   26        ;PUSH Bytes
SRP0            26         ;Set Reference Point 0
                           #--- PUSHB_2   20 1      ;PUSH Bytes
#CALL            1 20       ;CALL function
#                           #--- PUSHB_2   10 16     ;PUSH Bytes
#MIRP[min,black] estemw 10  ;Move Indirect Relative Point
#                           #--- PUSHB_2   30 1      ;PUSH Bytes
#CALL            1 30       ;CALL function
srp0 30
mdrp[rp0,min,rnd,white] 10
mdrp[rp0,min,rnd,grey] 20
mirp[min,black] estemw 10
                           #--- PUSHB_2   20 26     ;PUSH Bytes
SRP1            26         ;Set Reference Point 1
SRP2            20         ;Set Reference Point 2
                           #--- PUSHB_2   7 13      ;PUSH Bytes
IP              13         ;Interpolate Point
IP              7          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   23 17     ;PUSH Bytes
SRP1            17         ;Set Reference Point 1
SRP2            23         ;Set Reference Point 2
                           #--- PUSHB_2   10 16     ;PUSH Bytes
IP              16         ;Interpolate Point
IP              10         ;Interpolate Point
                           #--- PUSHB_1   7         ;PUSH Bytes
SRP1            7          ;Set Reference Point 1
                           #--- PUSHB_1   4         ;PUSH Bytes
IP              4          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'backslash': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   2         ;PUSH Bytes
MDRP[rp0,rnd,white] 2          ;Move Direct Relative Point
                           #--- PUSHB_5   0 16 0 8 4 ;PUSH Bytes
CALL            4 8 0 16 0 ;CALL function
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
                           #--- PUSHB_1   54        ;PUSH Bytes
SMD             54         ;Set Minimum Distance
                           #--- PUSHB_2   3 0       ;PUSH Bytes
SDPVTL[orthog]  0 3        ;Set Dual Projection Vector To Line
                           #--- PUSHB_1   0         ;PUSH Bytes
SRP0            0          ;Set Reference Point 0
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[grey]      3          ;Move Direct Relative Point
                           #--- PUSHB_2   1 22      ;PUSH Bytes
MIRP[rp0,min,black] cvt_22 1   ;Move Indirect Relative Point
SFVTCA[y-axis]             ;Set Freedom Vector To Coordinate Axis
                           #--- PUSHB_1   2         ;PUSH Bytes
MDRP[grey]      2          ;Move Direct Relative Point
SPVTCA[y-axis]             ;Set Projection Vector To Coordinate Axis
                           #--- PUSHB_2   2 3       ;PUSH Bytes
MDAP[no-rnd]    3          ;Move Direct Absolute Point
MDAP[no-rnd]    2          ;Move Direct Absolute Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   1 3       ;PUSH Bytes
MDAP[no-rnd]    3          ;Move Direct Absolute Point
MDAP[no-rnd]    1          ;Move Direct Absolute Point
                           #--- PUSHB_1   64        ;PUSH Bytes
SMD             64         ;Set Minimum Distance
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'bar': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_2   0 15      ;PUSH Bytes
MIRP[min,black] headstem_thick 0 ;Move Indirect Relative Point
                           #--- PUSHB_2   0 15      ;PUSH Bytes
MIRP[min,black] headstem_thick 0 ;Move Indirect Relative Point
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'braceleft': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   33 6      ;PUSH Bytes
MIRP[min,black] estemtc 33 ;Move Indirect Relative Point
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_2   9 11      ;PUSH Bytes
MIRP[min,black] cvt_11 9   ;Move Indirect Relative Point
                           #--- PUSHB_1   19        ;PUSH Bytes
MDAP[rnd]       19         ;Move Direct Absolute Point
                           #--- PUSHB_2   16 6      ;PUSH Bytes
MIRP[min,black] estemtc 16 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   35        ;PUSH Bytes
MDAP[rnd]       35         ;Move Direct Absolute Point
                           #--- PUSHB_1   12        ;PUSH Bytes
MDRP[rp0,rnd,white] 12         ;Move Direct Relative Point
                           #--- PUSHB_1   4         ;PUSH Bytes
SHP[rp2]        4          ;SHift Point using reference point
                           #--- PUSHB_2   23 15     ;PUSH Bytes
MIRP[min,black] headstem_thick 23 ;Move Indirect Relative Point
                           #--- PUSHB_1   29        ;PUSH Bytes
SHP[rp2]        29         ;SHift Point using reference point
                           #--- PUSHB_3   23 12 10  ;PUSH Bytes
CALL            10 12 23   ;CALL function
                           #--- PUSHB_4   64 23 0 9 ;PUSH Bytes
CALL            9 0 23 64  ;CALL function
                           #--- PUSHB_1   17        ;PUSH Bytes
SHP[rp2]        17         ;SHift Point using reference point
                           #--- PUSHB_2   36 1      ;PUSH Bytes
CALL            1 36       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   8 33      ;PUSH Bytes
SRP1            33         ;Set Reference Point 1
SRP2            8          ;Set Reference Point 2
                           #--- PUSHB_2   4 29      ;PUSH Bytes
IP              29         ;Interpolate Point
IP              4          ;Interpolate Point
                           #--- PUSHB_1   9         ;PUSH Bytes
SRP1            9          ;Set Reference Point 1
                           #--- PUSHB_1   26        ;PUSH Bytes
IP              26         ;Interpolate Point
                           #--- PUSHB_1   19        ;PUSH Bytes
SRP2            19         ;Set Reference Point 2
                           #--- PUSHB_2   13 23     ;PUSH Bytes
IP              23         ;Interpolate Point
IP              13         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'braceright': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   2         ;PUSH Bytes
MDAP[rnd]       2          ;Move Direct Absolute Point
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_2   3 6       ;PUSH Bytes
MIRP[min,black] estemtc 3  ;Move Indirect Relative Point
                           #--- PUSHB_1   30        ;PUSH Bytes
MDAP[rnd]       30         ;Move Direct Absolute Point
                           #--- PUSHB_2   29 11     ;PUSH Bytes
MIRP[min,black] cvt_11 29  ;Move Indirect Relative Point
                           #--- PUSHB_1   20        ;PUSH Bytes
MDAP[rnd]       20         ;Move Direct Absolute Point
                           #--- PUSHB_1   18        ;PUSH Bytes
SHP[rp1]        18         ;SHift Point using reference point
                           #--- PUSHB_2   21 6      ;PUSH Bytes
MIRP[min,black] estemtc 21 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   37        ;PUSH Bytes
MDAP[rnd]       37         ;Move Direct Absolute Point
                           #--- PUSHB_1   14        ;PUSH Bytes
MDRP[rp0,rnd,white] 14         ;Move Direct Relative Point
                           #--- PUSHB_1   7         ;PUSH Bytes
SHP[rp2]        7          ;SHift Point using reference point
                           #--- PUSHB_2   26 15     ;PUSH Bytes
MIRP[min,black] headstem_thick 26 ;Move Indirect Relative Point
                           #--- PUSHB_1   33        ;PUSH Bytes
SHP[rp2]        33         ;SHift Point using reference point
                           #--- PUSHB_3   14 26 10  ;PUSH Bytes
CALL            10 26 14   ;CALL function
                           #--- PUSHB_4   64 14 2 9 ;PUSH Bytes
CALL            9 2 14 64  ;CALL function
                           #--- PUSHB_1   20        ;PUSH Bytes
SHP[rp2]        20         ;SHift Point using reference point
                           #--- PUSHB_2   38 1      ;PUSH Bytes
CALL            1 38       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   30 3      ;PUSH Bytes
SRP1            3          ;Set Reference Point 1
SRP2            30         ;Set Reference Point 2
                           #--- PUSHB_2   9 34      ;PUSH Bytes
IP              34         ;Interpolate Point
IP              9          ;Interpolate Point
                           #--- PUSHB_1   29        ;PUSH Bytes
SRP1            29         ;Set Reference Point 1
                           #--- PUSHB_1   11        ;PUSH Bytes
IP              11         ;Interpolate Point
                           #--- PUSHB_1   20        ;PUSH Bytes
SRP2            20         ;Set Reference Point 2
                           #--- PUSHB_2   14 25     ;PUSH Bytes
IP              25         ;Interpolate Point
IP              14         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'bracketleft': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   2 5 0     ;PUSH Bytes
CALL            0 5 2      ;CALL function
                           #--- PUSHB_2   5 10      ;PUSH Bytes
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   6 10      ;PUSH Bytes
MIRP[min,black] estemt 6   ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_5   0 16 0 11 4 ;PUSH Bytes
CALL            4 11 0 16 0 ;CALL function
                           #--- PUSHB_1   3         ;PUSH Bytes
SHP[rp2]        3          ;SHift Point using reference point
                           #--- PUSHB_2   6 16      ;PUSH Bytes
MIRP[min,black] estemw 6   ;Move Indirect Relative Point
                           #--- PUSHB_5   0 16 0 11 4 ;PUSH Bytes
CALL            4 11 0 16 0 ;CALL function
                           #--- PUSHB_1   4         ;PUSH Bytes
SHP[rp2]        4          ;SHift Point using reference point
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'bracketright': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_2   5 10      ;PUSH Bytes
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   2 10      ;PUSH Bytes
MIRP[min,black] estemt 2   ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_1   5         ;PUSH Bytes
SHP[rp2]        5          ;SHift Point using reference point
                           #--- PUSHB_5   0 16 0 11 4 ;PUSH Bytes
CALL            4 11 0 16 0 ;CALL function
                           #--- PUSHB_1   0         ;PUSH Bytes
SRP0            0          ;Set Reference Point 0
                           #--- PUSHB_2   3 16      ;PUSH Bytes
MIRP[min,black] estemw 3   ;Move Indirect Relative Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDAP[rnd]       3          ;Move Direct Absolute Point
                           #--- PUSHB_1   0         ;PUSH Bytes
SRP0            0          ;Set Reference Point 0
                           #--- PUSHB_5   1 16 0 11 4 ;PUSH Bytes
CALL            4 11 0 16 1 ;CALL function
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'brokenbar': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_1   5         ;PUSH Bytes
MDRP[rp0,rnd,white] 5          ;Move Direct Relative Point
                           #--- PUSHB_1   1         ;PUSH Bytes
SHP[rp2]        1          ;SHift Point using reference point
                           #--- PUSHB_2   4 15      ;PUSH Bytes
MIRP[min,black] headstem_thick 4 ;Move Indirect Relative Point
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp2]        0          ;SHift Point using reference point
                           #--- PUSHB_2   4 15      ;PUSH Bytes
MIRP[min,black] headstem_thick 4 ;Move Indirect Relative Point
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'bullet': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   3         ;PUSH Bytes
MDAP[rnd]       3          ;Move Direct Absolute Point
                           #--- PUSHB_5   9 14 0 7 4 ;PUSH Bytes
CALL            4 7 0 14 9 ;CALL function
                           #--- PUSHB_5   9 14 0 7 4 ;PUSH Bytes
CALL            4 7 0 14 9 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   12        ;PUSH Bytes
MDAP[rnd]       12         ;Move Direct Absolute Point
                           #--- PUSHB_1   6         ;PUSH Bytes
MDRP[rp0,rnd,white] 6          ;Move Direct Relative Point
                           #--- PUSHB_5   0 16 0 7 4 ;PUSH Bytes
CALL            4 7 0 16 0 ;CALL function
                           #--- PUSHB_5   0 16 0 7 4 ;PUSH Bytes
CALL            4 7 0 16 0 ;CALL function
                           #--- PUSHB_2   13 1      ;PUSH Bytes
CALL            1 13       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'c': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   19 6      ;PUSH Bytes
MIRP[min,black] estemtc 19 ;Move Indirect Relative Point
                           #--- PUSHB_3   6 3 0     ;PUSH Bytes
CALL            0 3 6      ;CALL function
                           #--- PUSHB_2   13 6      ;PUSH Bytes
MIRP[min,black] estemtc 13 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   26        ;PUSH Bytes
MDAP[rnd]       26         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   16 16     ;PUSH Bytes
MIRP[min,black] estemw 16  ;Move Indirect Relative Point
                           #--- PUSHB_1   16        ;PUSH Bytes
#SRP0            16         ;Set Reference Point 0
#                           #--- PUSHB_2   22 1      ;PUSH Bytes
#CALL            1 22       ;CALL function
#                           #--- PUSHB_1   10        ;PUSH Bytes
#SHP[rp2]        10         ;SHift Point using reference point
#                           #--- PUSHB_2   23 16     ;PUSH Bytes
#MIRP[min,black] estemw 23  ;Move Indirect Relative Point
#                           #--- PUSHB_1   9         ;PUSH Bytes
#SHP[rp2]        9          ;SHift Point using reference point
#                           #--- PUSHB_2   27 1      ;PUSH Bytes
#CALL            1 27       ;CALL function
srp0    27
mdrp[rp0,min,rnd,white] 23
mdrp[rp0,min,rnd,grey]  22
alignrp     10
mirp[min,black] estemw  23
shp[rp2]    9
#
                           #--- PUSHB_2   22 16     ;PUSH Bytes
SRP1            16         ;Set Reference Point 1
SRP2            22         ;Set Reference Point 2
                           #--- PUSHB_2   6 0       ;PUSH Bytes
IP              0          ;Interpolate Point
IP              6          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   13 19     ;PUSH Bytes
SRP1            19         ;Set Reference Point 1
SRP2            13         ;Set Reference Point 2
                           #--- PUSHB_5   9 3 10 22 23 ;PUSH Bytes
                           #--- DEPTH     #5        ;DEPTH of the stack
SLOOP           5          ;Set LOOP variable
IP              23 22 10 3 9 ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'cedilla': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   6 0 0     ;PUSH Bytes
CALL            0 0 6      ;CALL function
                           #--- PUSHB_2   14 10     ;PUSH Bytes
MIRP[min,black] estemt 14  ;Move Indirect Relative Point
                           #--- PUSHB_1   9         ;PUSH Bytes
DUP             9          ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   10 6      ;PUSH Bytes
MIRP[min,black] estemtc 10 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   21        ;PUSH Bytes
MDAP[rnd]       21         ;Move Direct Absolute Point
                           #--- PUSHB_1   17        ;PUSH Bytes
MDRP[rp0,rnd,white] 17         ;Move Direct Relative Point
                           #--- PUSHB_2   3 15      ;PUSH Bytes
MIRP[min,black] headstem_thick 3 ;Move Indirect Relative Point
                           #--- PUSHB_2   22 1      ;PUSH Bytes
CALL            1 22       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'cent': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   28 1 0    ;PUSH Bytes
CALL            0 1 28     ;CALL function
                           #--- PUSHB_1   2         ;PUSH Bytes
SHP[rp1]        2          ;SHift Point using reference point
                           #--- PUSHB_2   20 10     ;PUSH Bytes
MIRP[min,black] estemt 20  ;Move Indirect Relative Point
                           #--- PUSHB_1   29        ;PUSH Bytes
SHP[rp2]        29         ;SHift Point using reference point
                           #--- PUSHB_3   28 20 10  ;PUSH Bytes
CALL            10 20 28   ;CALL function
                           #--- PUSHB_4   64 28 1 9 ;PUSH Bytes
CALL            9 1 28 64  ;CALL function
                           #--- PUSHB_3   9 5 0     ;PUSH Bytes
CALL            0 5 9      ;CALL function
                           #--- PUSHB_5   8 30 1 9 13 ;PUSH Bytes
CALL            13 9 1 30 8 ;CALL function
                           #--- PUSHB_1   19        ;PUSH Bytes
SHP[rp1]        19         ;SHift Point using reference point
                           #--- PUSHB_2   8 10      ;PUSH Bytes
MIRP[min,black] estemt 8   ;Move Indirect Relative Point
                           #--- PUSHB_1   11        ;PUSH Bytes
SHP[rp2]        11         ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   36        ;PUSH Bytes
MDAP[rnd]       36         ;Move Direct Absolute Point
                           #--- PUSHB_1   5         ;PUSH Bytes
MDRP[rp0,rnd,white] 5          ;Move Direct Relative Point
                           #--- PUSHB_2   33 16     ;PUSH Bytes
MIRP[min,black] estemw 33  ;Move Indirect Relative Point
                           #--- PUSHB_1   33        ;PUSH Bytes
SRP0            33         ;Set Reference Point 0
                           #--- PUSHB_2   1 1       ;PUSH Bytes
CALL            1 1        ;CALL function
                           #--- PUSHB_2   8 29      ;PUSH Bytes
SHP[rp2]        29         ;SHift Point using reference point
SHP[rp2]        8          ;SHift Point using reference point
                           #--- PUSHB_5   0 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 0 ;CALL function
                           #--- PUSHB_2   10 19     ;PUSH Bytes
SHP[rp2]        19         ;SHift Point using reference point
SHP[rp2]        10         ;SHift Point using reference point
                           #--- PUSHB_3   0 1 10    ;PUSH Bytes
CALL            10 1 0     ;CALL function
                           #--- PUSHB_4   64 0 25 9 ;PUSH Bytes
CALL            9 25 0 64  ;CALL function
                           #--- PUSHB_1   14        ;PUSH Bytes
SHP[rp2]        14         ;SHift Point using reference point
                           #--- PUSHB_2   37 1      ;PUSH Bytes
CALL            1 37       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   20 28     ;PUSH Bytes
SRP1            28         ;Set Reference Point 1
SRP2            20         ;Set Reference Point 2
                           #--- PUSHB_1   25        ;PUSH Bytes
IP              25         ;Interpolate Point
                           #--- PUSHB_1   30        ;PUSH Bytes
SRP1            30         ;Set Reference Point 1
                           #--- PUSHB_5   5 16 15 23 24 ;PUSH Bytes
                           #--- DEPTH     #5        ;DEPTH of the stack
SLOOP           5          ;Set LOOP variable
IP              24 23 15 16 5 ;Interpolate Point
                           #--- PUSHB_1   8         ;PUSH Bytes
SRP2            8          ;Set Reference Point 2
                           #--- PUSHB_1   14        ;PUSH Bytes
IP              14         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'colon': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_5   2 14 0 30 4 ;PUSH Bytes
CALL            4 30 0 14 2 ;CALL function
                           #--- PUSHB_3   6 3 0     ;PUSH Bytes
CALL            0 3 6      ;CALL function
                           #--- PUSHB_5   5 14 0 30 4 ;PUSH Bytes
CALL            4 30 0 14 5 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_1   5         ;PUSH Bytes
SHP[rp2]        5          ;SHift Point using reference point
                           #--- PUSHB_5   0 16 0 30 4 ;PUSH Bytes
CALL            4 30 0 16 0 ;CALL function
                           #--- PUSHB_1   4         ;PUSH Bytes
SHP[rp2]        4          ;SHift Point using reference point
                           #--- PUSHB_5   0 16 0 30 4 ;PUSH Bytes
CALL            4 30 0 16 0 ;CALL function
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'comma': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   5 1 0     ;PUSH Bytes
CALL            0 1 5      ;CALL function
                           #--- PUSHB_5   6 14 0 30 4 ;PUSH Bytes
CALL            4 30 0 14 6 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   11        ;PUSH Bytes
MDAP[rnd]       11         ;Move Direct Absolute Point
                           #--- PUSHB_1   5         ;PUSH Bytes
MDRP[rp0,rnd,white] 5          ;Move Direct Relative Point
                           #--- PUSHB_5   8 16 0 30 4 ;PUSH Bytes
CALL            4 30 0 16 8 ;CALL function
                           #--- PUSHB_1   8         ;PUSH Bytes
SRP0            8          ;Set Reference Point 0
                           #--- PUSHB_5   4 15 0 20 4 ;PUSH Bytes
CALL            4 20 0 15 4 ;CALL function
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_2   12 1      ;PUSH Bytes
CALL            1 12       ;CALL function
                           #--- PUSHB_2   4 5       ;PUSH Bytes
SRP1            5          ;Set Reference Point 1
SRP2            4          ;Set Reference Point 2
                           #--- PUSHB_1   0         ;PUSH Bytes
IP              0          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'copyright': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   30 4 0    ;PUSH Bytes
CALL            0 4 30     ;CALL function
                           #--- PUSHB_2   38 10     ;PUSH Bytes
MIRP[min,black] estemt 38  ;Move Indirect Relative Point
                           #--- PUSHB_3   33 3 0    ;PUSH Bytes
CALL            0 3 33     ;CALL function
                           #--- PUSHB_2   34 14     ;PUSH Bytes
MIRP[min,black] ecstemw 34 ;Move Indirect Relative Point
                           #--- PUSHB_1   0         ;PUSH Bytes
MDAP[rnd]       0          ;Move Direct Absolute Point
                           #--- PUSHB_2   12 7      ;PUSH Bytes
MIRP[min,black] cvt_7 12   ;Move Indirect Relative Point
                           #--- PUSHB_1   24        ;PUSH Bytes
MDAP[rnd]       24         ;Move Direct Absolute Point
                           #--- PUSHB_2   44 10     ;PUSH Bytes
MIRP[min,black] estemt 44  ;Move Indirect Relative Point
                           #--- PUSHB_4   49 44 24 8 ;PUSH Bytes
CALL            8 24 44 49 ;CALL function
                           #--- PUSHB_2   48 14     ;PUSH Bytes
MIRP[min,black] ecstemw 48 ;Move Indirect Relative Point
                           #--- PUSHB_1   18        ;PUSH Bytes
MDAP[rnd]       18         ;Move Direct Absolute Point
                           #--- PUSHB_2   6 7       ;PUSH Bytes
MIRP[min,black] cvt_7 6    ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   52        ;PUSH Bytes
MDAP[rnd]       52         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_5   21 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 21 ;CALL function
                           #--- PUSHB_1   21        ;PUSH Bytes
SRP0            21         ;Set Reference Point 0
                           #--- PUSHB_2   27 1      ;PUSH Bytes
CALL            1 27       ;CALL function
                           #--- PUSHB_2   41 16     ;PUSH Bytes
MIRP[min,black] estemw 41  ;Move Indirect Relative Point
                           #--- PUSHB_1   41        ;PUSH Bytes
SRP0            41         ;Set Reference Point 0
                           #--- PUSHB_2   15 1      ;PUSH Bytes
CALL            1 15       ;CALL function
                           #--- PUSHB_5   9 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 9 ;CALL function
                           #--- PUSHB_2   53 1      ;PUSH Bytes
CALL            1 53       ;CALL function
                           #--- PUSHB_2   15 41     ;PUSH Bytes
SRP1            41         ;Set Reference Point 1
SRP2            15         ;Set Reference Point 2
                           #--- PUSHB_8   6 0 12 18 24 30 33 48 ;PUSH Bytes
                           #--- DEPTH     #8        ;DEPTH of the stack
SLOOP           8          ;Set LOOP variable
IP              48 33 30 24 18 12 0 6 ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   34 48     ;PUSH Bytes
SRP1            48         ;Set Reference Point 1
SRP2            34         ;Set Reference Point 2
                           #--- PUSHB_6   9 15 21 3 27 41 ;PUSH Bytes
                           #--- DEPTH     #6        ;DEPTH of the stack
SLOOP           6          ;Set LOOP variable
IP              41 27 3 21 15 9 ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'currency': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   11 4 0    ;PUSH Bytes
CALL            0 4 11     ;CALL function
                           #--- PUSHB_1   17        ;PUSH Bytes
SHP[rp1]        17         ;SHift Point using reference point
                           #--- PUSHB_1   0         ;PUSH Bytes
MDAP[rnd]       0          ;Move Direct Absolute Point
                           #--- PUSHB_2   36 9      ;PUSH Bytes
MIRP[min,black] headstem 36 ;Move Indirect Relative Point
                           #--- PUSHB_1   30        ;PUSH Bytes
MDAP[rnd]       30         ;Move Direct Absolute Point
                           #--- PUSHB_2   14 9      ;PUSH Bytes
MIRP[min,black] headstem 14 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   40        ;PUSH Bytes
MDAP[rnd]       40         ;Move Direct Absolute Point
                           #--- PUSHB_1   7         ;PUSH Bytes
MDRP[rp0,rnd,white] 7          ;Move Direct Relative Point
                           #--- PUSHB_5   33 15 0 71 4 ;PUSH Bytes
CALL            4 71 0 15 33 ;CALL function
                           #--- PUSHB_1   33        ;PUSH Bytes
SRP0            33         ;Set Reference Point 0
                           #--- PUSHB_2   39 1      ;PUSH Bytes
CALL            1 39       ;CALL function
                           #--- PUSHB_5   21 15 0 71 4 ;PUSH Bytes
CALL            4 71 0 15 21 ;CALL function
                           #--- PUSHB_2   41 1      ;PUSH Bytes
CALL            1 41       ;CALL function
                           #--- PUSHB_2   33 7      ;PUSH Bytes
SRP1            7          ;Set Reference Point 1
SRP2            33         ;Set Reference Point 2
                           #--- PUSHB_2   5 9       ;PUSH Bytes
IP              9          ;Interpolate Point
IP              5          ;Interpolate Point
                           #--- PUSHB_1   39        ;PUSH Bytes
SRP1            39         ;Set Reference Point 1
                           #--- PUSHB_4   2 12 16 26 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
IP              26 16 12 2 ;Interpolate Point
                           #--- PUSHB_1   21        ;PUSH Bytes
SRP2            21         ;Set Reference Point 2
                           #--- PUSHB_2   19 23     ;PUSH Bytes
IP              23         ;Interpolate Point
IP              19         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   36 0      ;PUSH Bytes
SRP1            0          ;Set Reference Point 1
SRP2            36         ;Set Reference Point 2
                           #--- PUSHB_2   2 26      ;PUSH Bytes
IP              26         ;Interpolate Point
IP              2          ;Interpolate Point
                           #--- PUSHB_1   30        ;PUSH Bytes
SRP1            30         ;Set Reference Point 1
                           #--- PUSHB_4   5 9 19 23 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
IP              23 19 9 5  ;Interpolate Point
                           #--- PUSHB_1   14        ;PUSH Bytes
SRP2            14         ;Set Reference Point 2
                           #--- PUSHB_2   12 16     ;PUSH Bytes
IP              16         ;Interpolate Point
IP              12         ;Interpolate Point
                           #--- PUSHB_1   11        ;PUSH Bytes
SRP1            11         ;Set Reference Point 1
                           #--- PUSHB_2   10 18     ;PUSH Bytes
IP              18         ;Interpolate Point
IP              10         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'd': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   5 1 0     ;PUSH Bytes
CALL            0 1 5      ;CALL function
                           #--- PUSHB_2   17 6      ;PUSH Bytes
MIRP[min,black] estemtc 17 ;Move Indirect Relative Point
                           #--- PUSHB_3   15 5 0    ;PUSH Bytes
CALL            0 5 15     ;CALL function
                           #--- PUSHB_3   11 3 0    ;PUSH Bytes
CALL            0 3 11     ;CALL function
                           #--- PUSHB_2   23 6      ;PUSH Bytes
MIRP[min,black] estemtc 23 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   29        ;PUSH Bytes
MDAP[rnd]       29         ;Move Direct Absolute Point
                           #--- PUSHB_1   8         ;PUSH Bytes
MDRP[rp0,rnd,white] 8          ;Move Direct Relative Point
                           #--- PUSHB_2   26 16     ;PUSH Bytes
MIRP[min,black] estemw 26  ;Move Indirect Relative Point
                           #--- PUSHB_1   26        ;PUSH Bytes
#SRP0            26         ;Set Reference Point 0
#                           #--- PUSHB_2   20 1      ;PUSH Bytes
#CALL            1 20       ;CALL function
#                           #--- PUSHB_2   1 14      ;PUSH Bytes
#SHP[rp2]        14         ;SHift Point using reference point
#SHP[rp2]        1          ;SHift Point using reference point
#                           #--- PUSHB_2   0 16      ;PUSH Bytes
#MIRP[min,black] estemw 0   ;Move Indirect Relative Point
#                           #--- PUSHB_2   30 1      ;PUSH Bytes
#CALL            1 30       ;CALL function
#                           #--- PUSHB_2   20 26     ;PUSH Bytes
srp0    30
mdrp[rp0,min,rnd,white] 0
mdrp[rp0,min,rnd,grey]  20
alignrp 14
alignrp 1
mirp[min,black] estemw  0
#
SRP1            26         ;Set Reference Point 1
SRP2            20         ;Set Reference Point 2
                           #--- PUSHB_2   5 11      ;PUSH Bytes
IP              11         ;Interpolate Point
IP              5          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   23 17     ;PUSH Bytes
SRP1            17         ;Set Reference Point 1
SRP2            23         ;Set Reference Point 2
                           #--- PUSHB_2   8 2       ;PUSH Bytes
IP              2          ;Interpolate Point
IP              8          ;Interpolate Point
                           #--- PUSHB_1   11        ;PUSH Bytes
SRP1            11         ;Set Reference Point 1
                           #--- PUSHB_1   14        ;PUSH Bytes
IP              14         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'dagger': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   6 4 0     ;PUSH Bytes
CALL            0 4 6      ;CALL function
                           #--- PUSHB_1   10        ;PUSH Bytes
SHP[rp1]        10         ;SHift Point using reference point
                           #--- PUSHB_2   5 9       ;PUSH Bytes
MIRP[min,black] headstem 5 ;Move Indirect Relative Point
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp2]        0          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   12        ;PUSH Bytes
MDAP[rnd]       12         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_1   7         ;PUSH Bytes
SHP[rp2]        7          ;SHift Point using reference point
                           #--- PUSHB_5   2 15 0 45 4 ;PUSH Bytes
CALL            4 45 0 15 2 ;CALL function
                           #--- PUSHB_1   9         ;PUSH Bytes
SHP[rp2]        9          ;SHift Point using reference point
                           #--- PUSHB_2   13 1      ;PUSH Bytes
CALL            1 13       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'daggerdbl': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   5         ;PUSH Bytes
MDAP[rnd]       5          ;Move Direct Absolute Point
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_2   6 9       ;PUSH Bytes
MIRP[min,black] headstem 6 ;Move Indirect Relative Point
                           #--- PUSHB_1   18        ;PUSH Bytes
SHP[rp2]        18         ;SHift Point using reference point
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_1   16        ;PUSH Bytes
SHP[rp1]        16         ;SHift Point using reference point
                           #--- PUSHB_2   11 8      ;PUSH Bytes
MIRP[min,black] cvt_8 11   ;Move Indirect Relative Point
                           #--- PUSHB_1   14        ;PUSH Bytes
SHP[rp2]        14         ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   20        ;PUSH Bytes
MDAP[rnd]       20         ;Move Direct Absolute Point
                           #--- PUSHB_1   4         ;PUSH Bytes
MDRP[rp0,rnd,white] 4          ;Move Direct Relative Point
                           #--- PUSHB_2   7 11      ;PUSH Bytes
SHP[rp2]        11         ;SHift Point using reference point
SHP[rp2]        7          ;SHift Point using reference point
                           #--- PUSHB_5   1 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 1 ;CALL function
                           #--- PUSHB_2   13 17     ;PUSH Bytes
SHP[rp2]        17         ;SHift Point using reference point
SHP[rp2]        13         ;SHift Point using reference point
                           #--- PUSHB_2   21 1      ;PUSH Bytes
CALL            1 21       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'degree': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   11 2 0    ;PUSH Bytes
CALL            0 2 11     ;CALL function
                           #--- PUSHB_2   0 10      ;PUSH Bytes
MIRP[min,black] estemt 0   ;Move Indirect Relative Point
                           #--- PUSHB_1   17        ;PUSH Bytes
MDAP[rnd]       17         ;Move Direct Absolute Point
                           #--- PUSHB_2   6 10      ;PUSH Bytes
MIRP[min,black] estemt 6   ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   23        ;PUSH Bytes
MDAP[rnd]       23         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   20 15     ;PUSH Bytes
MIRP[min,black] headstem_thick 20 ;Move Indirect Relative Point
                           #--- PUSHB_1   20        ;PUSH Bytes
SRP0            20         ;Set Reference Point 0
                           #--- PUSHB_2   14 1      ;PUSH Bytes
CALL            1 14       ;CALL function
                           #--- PUSHB_2   9 15      ;PUSH Bytes
MIRP[min,black] headstem_thick 9 ;Move Indirect Relative Point
                           #--- PUSHB_2   24 1      ;PUSH Bytes
CALL            1 24       ;CALL function
                           #--- PUSHB_2   14 20     ;PUSH Bytes
SRP1            20         ;Set Reference Point 1
SRP2            14         ;Set Reference Point 2
                           #--- PUSHB_1   0         ;PUSH Bytes
IP              0          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   17 11     ;PUSH Bytes
SRP1            11         ;Set Reference Point 1
SRP2            17         ;Set Reference Point 2
                           #--- PUSHB_2   9 3       ;PUSH Bytes
IP              3          ;Interpolate Point
IP              9          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'desc.uni0E0D': """
                           #--- NPUSHB    17 11 23 1 23 28 111 10 1 10 39 4 29 1 29 28 4 17 ;PUSH N Bytes
MDAP[rnd]       17         ;Move Direct Absolute Point
MDRP[rp0,rnd,grey] 4          ;Move Direct Relative Point
MIRP[min,rnd,grey] cvt_28 29  ;Move Indirect Relative Point
DELTAP1         1 29 4     ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_39 10  ;Move Indirect Relative Point
DELTAP1         1 10 111   ;DELTA exception P1
MIRP[min,rnd,grey] cvt_28 23  ;Move Indirect Relative Point
DELTAP1         1 23 11    ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    22 13 7 0 7 4 20 1 20 28 96 2 1 2 39 11 26 1 26 28 17 7 32 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       32         ;Move Direct Absolute Point
MDRP[rp0,min,rnd,white] 7          ;Move Direct Relative Point
MDRP[rnd,grey]  17         ;Move Direct Relative Point
MIRP[min,rnd,grey] cvt_28 26  ;Move Indirect Relative Point
DELTAP1         1 26 11    ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_39 2   ;Move Indirect Relative Point
DELTAP1         1 2 96     ;DELTA exception P1
MIRP[min,rnd,grey] cvt_28 20  ;Move Indirect Relative Point
DELTAP1         1 20 4     ;DELTA exception P1
SRP0            7          ;Set Reference Point 0
MDRP[rp0,rnd,grey] 0          ;Move Direct Relative Point
MIRP[min,black] cvt_7 13   ;Move Indirect Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'desc.uni0E10': """
                           #--- NPUSHB    46 4 58 1 58 28 6 16 96 11 1 11 39 11 53 1 53 28 4 3 2 1 25 24 23 7 26 21 21 4 48 1 48 28 96 32 1 32 39 11 42 1 42 28 26 9 38 ;PUSH N Bytes
MDAP[rnd]       38         ;Move Direct Absolute Point
MIRP[min,black] headstem 26 ;Move Indirect Relative Point
MIRP[min,rnd,grey] cvt_28 42  ;Move Indirect Relative Point
DELTAP1         1 42 11    ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_39 32  ;Move Indirect Relative Point
DELTAP1         1 32 96    ;DELTA exception P1
MIRP[min,rnd,grey] cvt_28 48  ;Move Indirect Relative Point
DELTAP1         1 48 4     ;DELTA exception P1
MDRP[rp0,rnd,grey] 21         ;Move Direct Relative Point
SRP1            21         ;Set Reference Point 1
SRP2            26         ;Set Reference Point 2
SLOOP           7          ;Set LOOP variable
IP              23 24 25 1 2 3 4 ;Interpolate Point
MIRP[min,rnd,grey] cvt_28 53  ;Move Indirect Relative Point
DELTAP1         1 53 11    ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_39 11  ;Move Indirect Relative Point
DELTAP1         1 11 96    ;DELTA exception P1
IP              16         ;Interpolate Point
IP              6          ;Interpolate Point
MIRP[min,rnd,grey] cvt_28 58  ;Move Indirect Relative Point
DELTAP1         1 58 4     ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    38 11 55 1 55 28 111 14 1 14 39 4 51 1 51 28 23 26 7 8 4 1 4 39 1 39 28 96 29 1 29 39 11 45 1 45 28 35 61 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       61         ;Move Direct Absolute Point
MDRP[rp0,min,rnd,white] 35         ;Move Direct Relative Point
MIRP[min,rnd,grey] cvt_28 45  ;Move Indirect Relative Point
DELTAP1         1 45 11    ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_39 29  ;Move Indirect Relative Point
DELTAP1         1 29 96    ;DELTA exception P1
MIRP[min,rnd,grey] cvt_28 39  ;Move Indirect Relative Point
DELTAP1         1 39 4     ;DELTA exception P1
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
ALIGNRP         4          ;ALIGN to Reference Point
ALIGNRP         8          ;ALIGN to Reference Point
MIRP[min,black] cvt_7 26   ;Move Indirect Relative Point
SHP[rp2]        23         ;SHift Point using reference point
MIRP[min,rnd,grey] cvt_28 51  ;Move Indirect Relative Point
DELTAP1         1 51 4     ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_39 14  ;Move Indirect Relative Point
DELTAP1         1 14 111   ;DELTA exception P1
MIRP[min,rnd,grey] cvt_28 55  ;Move Indirect Relative Point
DELTAP1         1 55 11    ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'dieresis': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   5         ;PUSH Bytes
MDAP[rnd]       5          ;Move Direct Absolute Point
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_2   6 14      ;PUSH Bytes
MIRP[min,black] ecstemw 6  ;Move Indirect Relative Point
                           #--- PUSHB_1   2         ;PUSH Bytes
SHP[rp2]        2          ;SHift Point using reference point
                           #--- PUSHB_2   6 14      ;PUSH Bytes
MIRP[min,black] ecstemw 6  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_1   5         ;PUSH Bytes
MDRP[rp0,rnd,white] 5          ;Move Direct Relative Point
                           #--- PUSHB_5   4 16 0 31 4 ;PUSH Bytes
CALL            4 31 0 16 4 ;CALL function
                           #--- PUSHB_1   4         ;PUSH Bytes
SRP0            4          ;Set Reference Point 0
                           #--- PUSHB_2   1 1       ;PUSH Bytes
CALL            1 1        ;CALL function
                           #--- PUSHB_5   0 16 0 31 4 ;PUSH Bytes
CALL            4 31 0 16 0 ;CALL function
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'dollar': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   2 1 0     ;PUSH Bytes
CALL            0 1 2      ;CALL function
                           #--- PUSHB_1   34        ;PUSH Bytes
SHP[rp1]        34         ;SHift Point using reference point
                           #--- PUSHB_2   9 10      ;PUSH Bytes
MIRP[min,black] estemt 9   ;Move Indirect Relative Point
                           #--- PUSHB_1   46        ;PUSH Bytes
SHP[rp2]        46         ;SHift Point using reference point
                           #--- PUSHB_3   2 9 10    ;PUSH Bytes
CALL            10 9 2     ;CALL function
                           #--- PUSHB_4   64 2 1 9  ;PUSH Bytes
CALL            9 1 2 64   ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   49        ;PUSH Bytes
MDAP[rnd]       49         ;Move Direct Absolute Point
                           #--- PUSHB_1   13        ;PUSH Bytes
MDRP[rp0,rnd,white] 13         ;Move Direct Relative Point
                           #--- PUSHB_2   38 16     ;PUSH Bytes
MIRP[min,black] estemw 38  ;Move Indirect Relative Point
                           #--- PUSHB_1   5         ;PUSH Bytes
DUP             5          ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   6 16      ;PUSH Bytes
MIRP[min,black] estemw 6   ;Move Indirect Relative Point
                           #--- PUSHB_1   38        ;PUSH Bytes
SRP0            38         ;Set Reference Point 0
                           #--- PUSHB_2   1 1       ;PUSH Bytes
CALL            1 1        ;CALL function
                           #--- PUSHB_3   9 16 35   ;PUSH Bytes
SHP[rp2]        35         ;SHift Point using reference point
SHP[rp2]        16         ;SHift Point using reference point
SHP[rp2]        9          ;SHift Point using reference point
                           #--- PUSHB_5   0 15 0 71 4 ;PUSH Bytes
CALL            4 71 0 15 0 ;CALL function
                           #--- PUSHB_3   18 26 45  ;PUSH Bytes
SHP[rp2]        45         ;SHift Point using reference point
SHP[rp2]        26         ;SHift Point using reference point
SHP[rp2]        18         ;SHift Point using reference point
                           #--- PUSHB_1   0         ;PUSH Bytes
SRP0            0          ;Set Reference Point 0
                           #--- PUSHB_2   42 1      ;PUSH Bytes
CALL            1 42       ;CALL function
                           #--- PUSHB_2   31 16     ;PUSH Bytes
MIRP[min,black] estemw 31  ;Move Indirect Relative Point
                           #--- PUSHB_1   23        ;PUSH Bytes
DUP             23         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   22 16     ;PUSH Bytes
MIRP[min,black] estemw 22  ;Move Indirect Relative Point
                           #--- PUSHB_2   50 1      ;PUSH Bytes
CALL            1 50       ;CALL function
                           #--- PUSHB_2   23 0      ;PUSH Bytes
SRP1            0          ;Set Reference Point 1
SRP2            23         ;Set Reference Point 2
                           #--- PUSHB_1   28        ;PUSH Bytes
IP              28         ;Interpolate Point
                           #--- PUSHB_2   22 42     ;PUSH Bytes
SRP1            42         ;Set Reference Point 1
SRP2            22         ;Set Reference Point 2
                           #--- PUSHB_1   21        ;PUSH Bytes
IP              21         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'dottedcircle': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   100 4 0   ;PUSH Bytes
CALL            0 4 100    ;CALL function
                           #--- PUSHB_2   96 8      ;PUSH Bytes
MIRP[min,black] cvt_8 96   ;Move Indirect Relative Point
                           #--- PUSHB_1   96        ;PUSH Bytes
SRP0            96         ;Set Reference Point 0
                           #--- PUSHB_1   15        ;PUSH Bytes
DUP             15         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   11 8      ;PUSH Bytes
MIRP[min,black] cvt_8 11   ;Move Indirect Relative Point
                           #--- PUSHB_3   17 4 0    ;PUSH Bytes
CALL            0 4 17     ;CALL function
                           #--- PUSHB_3   23 3 0    ;PUSH Bytes
CALL            0 3 23     ;CALL function
                           #--- PUSHB_2   19 8      ;PUSH Bytes
MIRP[min,black] cvt_8 19   ;Move Indirect Relative Point
                           #--- PUSHB_3   102 3 0   ;PUSH Bytes
CALL            0 3 102    ;CALL function
                           #--- PUSHB_1   56        ;PUSH Bytes
MDAP[rnd]       56         ;Move Direct Absolute Point
                           #--- PUSHB_2   60 8      ;PUSH Bytes
MIRP[min,black] cvt_8 60   ;Move Indirect Relative Point
                           #--- PUSHB_4   51 60 56 8 ;PUSH Bytes
CALL            8 56 60 51 ;CALL function
                           #--- PUSHB_2   55 8      ;PUSH Bytes
MIRP[min,black] cvt_8 55   ;Move Indirect Relative Point
                           #--- PUSHB_1   60        ;PUSH Bytes
SRP0            60         ;Set Reference Point 0
                           #--- PUSHB_1   44        ;PUSH Bytes
DUP             44         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   40 8      ;PUSH Bytes
MIRP[min,black] cvt_8 40   ;Move Indirect Relative Point
                           #--- PUSHB_1   64        ;PUSH Bytes
MDAP[rnd]       64         ;Move Direct Absolute Point
                           #--- PUSHB_2   68 8      ;PUSH Bytes
MIRP[min,black] cvt_8 68   ;Move Indirect Relative Point
                           #--- PUSHB_1   39        ;PUSH Bytes
DUP             39         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   35 8      ;PUSH Bytes
MIRP[min,black] cvt_8 35   ;Move Indirect Relative Point
                           #--- PUSHB_1   31        ;PUSH Bytes
MDAP[rnd]       31         ;Move Direct Absolute Point
                           #--- PUSHB_1   72        ;PUSH Bytes
SHP[rp1]        72         ;SHift Point using reference point
                           #--- PUSHB_2   27 8      ;PUSH Bytes
MIRP[min,black] cvt_8 27   ;Move Indirect Relative Point
                           #--- PUSHB_1   75        ;PUSH Bytes
SHP[rp2]        75         ;SHift Point using reference point
                           #--- PUSHB_1   111       ;PUSH Bytes
MDAP[rnd]       111        ;Move Direct Absolute Point
                           #--- PUSHB_1   86        ;PUSH Bytes
SHP[rp1]        86         ;SHift Point using reference point
                           #--- PUSHB_2   107 8     ;PUSH Bytes
MIRP[min,black] cvt_8 107  ;Move Indirect Relative Point
                           #--- PUSHB_1   82        ;PUSH Bytes
SHP[rp2]        82         ;SHift Point using reference point
                           #--- PUSHB_1   95        ;PUSH Bytes
MDAP[rnd]       95         ;Move Direct Absolute Point
                           #--- PUSHB_2   91 8      ;PUSH Bytes
MIRP[min,black] cvt_8 91   ;Move Indirect Relative Point
                           #--- PUSHB_1   0         ;PUSH Bytes
DUP             0          ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   4 8       ;PUSH Bytes
MIRP[min,black] cvt_8 4    ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   112       ;PUSH Bytes
MDAP[rnd]       112        ;Move Direct Absolute Point
                           #--- PUSHB_1   25        ;PUSH Bytes
MDRP[rp0,rnd,white] 25         ;Move Direct Relative Point
                           #--- PUSHB_5   29 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 29 ;CALL function
                           #--- PUSHB_1   29        ;PUSH Bytes
SRP0            29         ;Set Reference Point 0
                           #--- PUSHB_2   33 11     ;PUSH Bytes
CALL            11 33      ;CALL function
                           #--- PUSHB_1   1         ;PUSH Bytes
SHP[rp2]        1          ;SHift Point using reference point
                           #--- PUSHB_5   37 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 37 ;CALL function
                           #--- PUSHB_1   5         ;PUSH Bytes
SHP[rp2]        5          ;SHift Point using reference point
                           #--- PUSHB_4   109 37 33 8 ;PUSH Bytes
CALL            8 33 37 109 ;CALL function
                           #--- PUSHB_5   105 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 105 ;CALL function
                           #--- PUSHB_1   105       ;PUSH Bytes
MDAP[rnd]       105        ;Move Direct Absolute Point
                           #--- PUSHB_5   109 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 109 ;CALL function
                           #--- PUSHB_1   37        ;PUSH Bytes
SRP0            37         ;Set Reference Point 0
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
                           #--- PUSHB_5   13 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 13 ;CALL function
                           #--- PUSHB_1   42        ;PUSH Bytes
DUP             42         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_5   46 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 46 ;CALL function
                           #--- PUSHB_1   13        ;PUSH Bytes
SRP0            13         ;Set Reference Point 0
                           #--- PUSHB_2   49 1      ;PUSH Bytes
CALL            1 49       ;CALL function
                           #--- PUSHB_1   16        ;PUSH Bytes
SHP[rp2]        16         ;SHift Point using reference point
                           #--- PUSHB_5   53 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 53 ;CALL function
                           #--- PUSHB_1   20        ;PUSH Bytes
SHP[rp2]        20         ;SHift Point using reference point
                           #--- PUSHB_1   53        ;PUSH Bytes
SRP0            53         ;Set Reference Point 0
                           #--- PUSHB_2   98 1      ;PUSH Bytes
CALL            1 98       ;CALL function
                           #--- PUSHB_5   102 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 102 ;CALL function
                           #--- PUSHB_1   102       ;PUSH Bytes
SRP0            102        ;Set Reference Point 0
                           #--- PUSHB_2   89 1      ;PUSH Bytes
CALL            1 89       ;CALL function
                           #--- PUSHB_5   93 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 93 ;CALL function
                           #--- PUSHB_4   62 93 89 8 ;PUSH Bytes
CALL            8 89 93 62 ;CALL function
                           #--- PUSHB_5   58 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 58 ;CALL function
                           #--- PUSHB_1   58        ;PUSH Bytes
MDAP[rnd]       58         ;Move Direct Absolute Point
                           #--- PUSHB_5   62 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 62 ;CALL function
                           #--- PUSHB_1   89        ;PUSH Bytes
SRP0            89         ;Set Reference Point 0
                           #--- PUSHB_1   66        ;PUSH Bytes
DUP             66         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_5   70 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 70 ;CALL function
                           #--- PUSHB_1   93        ;PUSH Bytes
SRP0            93         ;Set Reference Point 0
                           #--- PUSHB_2   74 11     ;PUSH Bytes
CALL            11 74      ;CALL function
                           #--- PUSHB_5   78 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 78 ;CALL function
                           #--- PUSHB_2   113 1     ;PUSH Bytes
CALL            1 113      ;CALL function
                           #--- PUSHB_2   29 105    ;PUSH Bytes
SRP1            105        ;Set Reference Point 1
SRP2            29         ;Set Reference Point 2
                           #--- PUSHB_4   27 31 107 111 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
IP              111 107 31 27 ;Interpolate Point
                           #--- PUSHB_2   37 109    ;PUSH Bytes
SRP1            109        ;Set Reference Point 1
SRP2            37         ;Set Reference Point 2
                           #--- PUSHB_2   4 35      ;PUSH Bytes
IP              35         ;Interpolate Point
IP              4          ;Interpolate Point
                           #--- PUSHB_2   13 46     ;PUSH Bytes
SRP1            46         ;Set Reference Point 1
SRP2            13         ;Set Reference Point 2
                           #--- PUSHB_1   11        ;PUSH Bytes
IP              11         ;Interpolate Point
                           #--- PUSHB_2   53 49     ;PUSH Bytes
SRP1            49         ;Set Reference Point 1
SRP2            53         ;Set Reference Point 2
                           #--- PUSHB_1   19        ;PUSH Bytes
IP              19         ;Interpolate Point
                           #--- PUSHB_2   66 62     ;PUSH Bytes
SRP1            62         ;Set Reference Point 1
SRP2            66         ;Set Reference Point 2
                           #--- PUSHB_1   95        ;PUSH Bytes
IP              95         ;Interpolate Point
                           #--- PUSHB_1   93        ;PUSH Bytes
SRP1            93         ;Set Reference Point 1
                           #--- PUSHB_3   80 81 91  ;PUSH Bytes
IP              91         ;Interpolate Point
IP              81         ;Interpolate Point
IP              80         ;Interpolate Point
                           #--- PUSHB_1   70        ;PUSH Bytes
SRP2            70         ;Set Reference Point 2
                           #--- PUSHB_2   68 87     ;PUSH Bytes
IP              87         ;Interpolate Point
IP              68         ;Interpolate Point
                           #--- PUSHB_1   78        ;PUSH Bytes
SRP1            78         ;Set Reference Point 1
                           #--- PUSHB_4   76 83 84 85 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
IP              85 84 83 76 ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   56 55     ;PUSH Bytes
SRP1            55         ;Set Reference Point 1
SRP2            56         ;Set Reference Point 2
                           #--- PUSHB_2   48 53     ;PUSH Bytes
IP              53         ;Interpolate Point
IP              48         ;Interpolate Point
                           #--- PUSHB_1   40        ;PUSH Bytes
SRP1            40         ;Set Reference Point 1
                           #--- PUSHB_1   49        ;PUSH Bytes
IP              49         ;Interpolate Point
                           #--- PUSHB_1   51        ;PUSH Bytes
SRP2            51         ;Set Reference Point 2
                           #--- PUSHB_1   62        ;PUSH Bytes
IP              62         ;Interpolate Point
                           #--- PUSHB_1   60        ;PUSH Bytes
SRP1            60         ;Set Reference Point 1
                           #--- PUSHB_2   42 58     ;PUSH Bytes
IP              58         ;Interpolate Point
IP              42         ;Interpolate Point
                           #--- PUSHB_2   68 39     ;PUSH Bytes
SRP1            39         ;Set Reference Point 1
SRP2            68         ;Set Reference Point 2
                           #--- PUSHB_2   37 70     ;PUSH Bytes
IP              70         ;Interpolate Point
IP              37         ;Interpolate Point
                           #--- PUSHB_2   4 95      ;PUSH Bytes
SRP1            95         ;Set Reference Point 1
SRP2            4          ;Set Reference Point 2
                           #--- PUSHB_3   6 89 93   ;PUSH Bytes
IP              93         ;Interpolate Point
IP              89         ;Interpolate Point
IP              6          ;Interpolate Point
                           #--- PUSHB_2   23 96     ;PUSH Bytes
SRP1            96         ;Set Reference Point 1
SRP2            23         ;Set Reference Point 2
                           #--- PUSHB_2   13 8      ;PUSH Bytes
IP              8          ;Interpolate Point
IP              13         ;Interpolate Point
                           #--- PUSHB_1   11        ;PUSH Bytes
SRP1            11         ;Set Reference Point 1
                           #--- PUSHB_4   9 16 21 98 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
IP              98 21 16 9 ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'e': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   16 6      ;PUSH Bytes
MIRP[min,black] estemtc 16 ;Move Indirect Relative Point
                           #--- PUSHB_3   6 3 0     ;PUSH Bytes
CALL            0 3 6      ;CALL function
                           #--- PUSHB_2   26 6      ;PUSH Bytes
MIRP[min,black] estemtc 26 ;Move Indirect Relative Point
                           #--- PUSHB_5   29 13 0 6 13 ;PUSH Bytes
CALL            13 6 0 13 29 ;CALL function
                           #--- PUSHB_1   11        ;PUSH Bytes
SHP[rp1]        11         ;SHift Point using reference point
                           #--- PUSHB_2   29 10     ;PUSH Bytes
MIRP[min,black] estemt 29  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   30        ;PUSH Bytes
MDAP[rnd]       30         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   13 16     ;PUSH Bytes
MIRP[min,black] estemw 13  ;Move Indirect Relative Point
                           #--- PUSHB_1   29        ;PUSH Bytes
SHP[rp2]        29         ;SHift Point using reference point
                           #--- PUSHB_1   13        ;PUSH Bytes
#SRP0            13         ;Set Reference Point 0
#                           #--- PUSHB_2   23 1      ;PUSH Bytes
#CALL            1 23       ;CALL function
#                           #--- PUSHB_2   9 16      ;PUSH Bytes
#MIRP[min,black] estemw 9   ;Move Indirect Relative Point
#                           #--- PUSHB_2   11 20     ;PUSH Bytes
#SHP[rp2]        20         ;SHift Point using reference point
#SHP[rp2]        11         ;SHift Point using reference point
#                           #--- PUSHB_2   31 1      ;PUSH Bytes
#CALL            1 31       ;CALL function
#                           #--- PUSHB_2   23 13     ;PUSH Bytes
srp0    48
mdrp[rp0,min,rnd,white] 11
mdrp[rp0,min,rnd,grey]  23
mirp[min,black] estemw  11
#
SRP1            13         ;Set Reference Point 1
SRP2            23         ;Set Reference Point 2
                           #--- PUSHB_4   0 6 16 26 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
IP              26 16 6 0  ;Interpolate Point
                           #--- PUSHB_1   9         ;PUSH Bytes
SRP1            9          ;Set Reference Point 1
                           #--- PUSHB_1   19        ;PUSH Bytes
IP              19         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   13 16     ;PUSH Bytes
SRP1            16         ;Set Reference Point 1
SRP2            13         ;Set Reference Point 2
                           #--- PUSHB_2   19 20     ;PUSH Bytes
IP              20         ;Interpolate Point
IP              19         ;Interpolate Point
                           #--- PUSHB_1   29        ;PUSH Bytes
SRP1            29         ;Set Reference Point 1
                           #--- PUSHB_2   9 3       ;PUSH Bytes
IP              3          ;Interpolate Point
IP              9          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'eight': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   36 14     ;PUSH Bytes
MIRP[min,black] ecstemw 36 ;Move Indirect Relative Point
                           #--- PUSHB_3   12 5 0    ;PUSH Bytes
CALL            0 5 12     ;CALL function
                           #--- PUSHB_2   30 14     ;PUSH Bytes
MIRP[min,black] ecstemw 30 ;Move Indirect Relative Point
                           #--- PUSHB_5   24 42 0 12 13 ;PUSH Bytes
CALL            13 12 0 42 24 ;CALL function
                           #--- PUSHB_2   24 14     ;PUSH Bytes
MIRP[min,black] ecstemw 24 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   48        ;PUSH Bytes
MDAP[rnd]       48         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   45 16     ;PUSH Bytes
MIRP[min,black] estemw 45  ;Move Indirect Relative Point
                           #--- PUSHB_1   9         ;PUSH Bytes
DUP             9          ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   33 16     ;PUSH Bytes
MIRP[min,black] estemw 33  ;Move Indirect Relative Point
                           #--- PUSHB_1   45        ;PUSH Bytes
SRP0            45         ;Set Reference Point 0
                           #--- PUSHB_2   39 1      ;PUSH Bytes
CALL            1 39       ;CALL function
                           #--- PUSHB_2   21 16     ;PUSH Bytes
MIRP[min,black] estemw 21  ;Move Indirect Relative Point
                           #--- PUSHB_1   27        ;PUSH Bytes
DUP             27         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   15 16     ;PUSH Bytes
MIRP[min,black] estemw 15  ;Move Indirect Relative Point
                           #--- PUSHB_2   49 1      ;PUSH Bytes
CALL            1 49       ;CALL function
                           #--- PUSHB_2   27 33     ;PUSH Bytes
SRP1            33         ;Set Reference Point 1
SRP2            27         ;Set Reference Point 2
                           #--- PUSHB_6   0 12 18 6 36 42 ;PUSH Bytes
                           #--- DEPTH     #6        ;DEPTH of the stack
SLOOP           6          ;Set LOOP variable
IP              42 36 6 18 12 0 ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   42 36     ;PUSH Bytes
SRP1            36         ;Set Reference Point 1
SRP2            42         ;Set Reference Point 2
                           #--- PUSHB_2   21 3      ;PUSH Bytes
IP              3          ;Interpolate Point
IP              21         ;Interpolate Point
                           #--- PUSHB_1   24        ;PUSH Bytes
SRP1            24         ;Set Reference Point 1
                           #--- PUSHB_2   18 6      ;PUSH Bytes
IP              6          ;Interpolate Point
IP              18         ;Interpolate Point
                           #--- PUSHB_1   30        ;PUSH Bytes
SRP2            30         ;Set Reference Point 2
                           #--- PUSHB_2   9 15      ;PUSH Bytes
IP              15         ;Interpolate Point
IP              9          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'ellipsis': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   9 1 0     ;PUSH Bytes
CALL            0 1 9      ;CALL function
                           #--- PUSHB_2   0 4       ;PUSH Bytes
SHP[rp1]        4          ;SHift Point using reference point
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_5   10 14 0 19 4 ;PUSH Bytes
CALL            4 19 0 14 10 ;CALL function
                           #--- PUSHB_2   2 6       ;PUSH Bytes
SHP[rp2]        6          ;SHift Point using reference point
SHP[rp2]        2          ;SHift Point using reference point
                           #--- PUSHB_3   9 1 0     ;PUSH Bytes
CALL            0 1 9      ;CALL function
                           #--- PUSHB_5   10 14 0 19 4 ;PUSH Bytes
CALL            4 19 0 14 10 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   12        ;PUSH Bytes
MDAP[rnd]       12         ;Move Direct Absolute Point
                           #--- PUSHB_1   9         ;PUSH Bytes
MDRP[rp0,rnd,white] 9          ;Move Direct Relative Point
                           #--- PUSHB_5   8 16 0 31 4 ;PUSH Bytes
CALL            4 31 0 16 8 ;CALL function
                           #--- PUSHB_1   8         ;PUSH Bytes
SRP0            8          ;Set Reference Point 0
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
                           #--- PUSHB_5   4 16 0 31 4 ;PUSH Bytes
CALL            4 31 0 16 4 ;CALL function
                           #--- PUSHB_1   4         ;PUSH Bytes
SRP0            4          ;Set Reference Point 0
                           #--- PUSHB_2   1 1       ;PUSH Bytes
CALL            1 1        ;CALL function
                           #--- PUSHB_5   0 16 0 31 4 ;PUSH Bytes
CALL            4 31 0 16 0 ;CALL function
                           #--- PUSHB_2   13 1      ;PUSH Bytes
CALL            1 13       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'emdash': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   2 6       ;PUSH Bytes
MIRP[min,black] estemtc 2  ;Move Indirect Relative Point
                           #--- PUSHB_2   2 6       ;PUSH Bytes
MIRP[min,black] estemtc 2  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'endash': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   2 6       ;PUSH Bytes
MIRP[min,black] estemtc 2  ;Move Indirect Relative Point
                           #--- PUSHB_2   2 6       ;PUSH Bytes
MIRP[min,black] estemtc 2  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'enspace': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   3 3 0     ;PUSH Bytes
CALL            0 3 3      ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   2         ;PUSH Bytes
MDRP[rp0,rnd,white] 2          ;Move Direct Relative Point
                           #--- PUSHB_5   1 16 0 7 4 ;PUSH Bytes
CALL            4 7 0 16 1 ;CALL function
                           #--- PUSHB_5   1 16 0 7 4 ;PUSH Bytes
CALL            4 7 0 16 1 ;CALL function
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'exclamdbl': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   2 9       ;PUSH Bytes
MIRP[min,black] headstem 2 ;Move Indirect Relative Point
                           #--- PUSHB_2   2 9       ;PUSH Bytes
MIRP[min,black] headstem 2 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'f': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   4 3 0     ;PUSH Bytes
CALL            0 3 4      ;CALL function
                           #--- PUSHB_1   18        ;PUSH Bytes
SHP[rp1]        18         ;SHift Point using reference point
                           #--- PUSHB_2   3 10      ;PUSH Bytes
MIRP[min,black] estemt 3   ;Move Indirect Relative Point
                           #--- PUSHB_1   20        ;PUSH Bytes
SHP[rp2]        20         ;SHift Point using reference point
                           #--- PUSHB_1   14        ;PUSH Bytes
MDAP[rnd]       14         ;Move Direct Absolute Point
                           #--- PUSHB_2   9 6       ;PUSH Bytes
MIRP[min,black] estemtc 9  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   22        ;PUSH Bytes
MDAP[rnd]       22         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
gfx(1)
                           #--- PUSHB_1   5         ;PUSH Bytes
SHP[rp2]        5          ;SHift Point using reference point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_1   17        ;PUSH Bytes
SHP[rp2]        17         ;SHift Point using reference point
                           #--- PUSHB_3   0 1 10    ;PUSH Bytes
CALL            10 1 0     ;CALL function
                           #--- PUSHB_4   64 0 20 9 ;PUSH Bytes
CALL            9 20 0 64  ;CALL function
                           #--- PUSHB_3   1 0 10    ;PUSH Bytes
CALL            10 0 1     ;CALL function
                           #--- PUSHB_4   64 1 3 9  ;PUSH Bytes
CALL            9 3 1 64   ;CALL function
                           #--- PUSHB_2   23 1      ;PUSH Bytes
CALL            1 23       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   14 4      ;PUSH Bytes
SRP1            4          ;Set Reference Point 1
SRP2            14         ;Set Reference Point 2
                           #--- PUSHB_1   12        ;PUSH Bytes
IP              12         ;Interpolate Point
                           #--- PUSHB_1   9         ;PUSH Bytes
SRP1            9          ;Set Reference Point 1
                           #--- PUSHB_1   11        ;PUSH Bytes
IP              11         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'five': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   7 14      ;PUSH Bytes
MIRP[min,black] ecstemw 7  ;Move Indirect Relative Point
                           #--- PUSHB_3   7 0 10    ;PUSH Bytes
CALL            10 0 7     ;CALL function
                           #--- PUSHB_4   64 7 3 9  ;PUSH Bytes
CALL            9 3 7 64   ;CALL function
                           #--- PUSHB_3   17 5 0    ;PUSH Bytes
CALL            0 5 17     ;CALL function
                           #--- PUSHB_2   20 13     ;PUSH Bytes
MIRP[min,black] ecstemt 20 ;Move Indirect Relative Point
                           #--- PUSHB_5   23 13 0 17 13 ;PUSH Bytes
CALL            13 17 0 13 23 ;CALL function
                           #--- PUSHB_2   23 14     ;PUSH Bytes
MIRP[min,black] ecstemw 23 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   29        ;PUSH Bytes
MDAP[rnd]       29         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   4 16      ;PUSH Bytes
MIRP[min,black] estemw 4   ;Move Indirect Relative Point
                           #--- PUSHB_1   4         ;PUSH Bytes
SRP0            4          ;Set Reference Point 0
                           #--- PUSHB_2   10 1      ;PUSH Bytes
CALL            1 10       ;CALL function
                           #--- PUSHB_2   26 16     ;PUSH Bytes
MIRP[min,black] estemw 26  ;Move Indirect Relative Point
                           #--- PUSHB_2   30 1      ;PUSH Bytes
CALL            1 30       ;CALL function
                           #--- PUSHB_2   4 3       ;PUSH Bytes
SRP1            3          ;Set Reference Point 1
SRP2            4          ;Set Reference Point 2
                           #--- PUSHB_2   16 17     ;PUSH Bytes
IP              17         ;Interpolate Point
IP              16         ;Interpolate Point
                           #--- PUSHB_1   10        ;PUSH Bytes
SRP1            10         ;Set Reference Point 1
                           #--- PUSHB_5   0 15 20 21 23 ;PUSH Bytes
                           #--- DEPTH     #5        ;DEPTH of the stack
SLOOP           5          ;Set LOOP variable
IP              23 21 20 15 0 ;Interpolate Point
                           #--- PUSHB_1   26        ;PUSH Bytes
SRP2            26         ;Set Reference Point 2
                           #--- PUSHB_2   18 19     ;PUSH Bytes
IP              19         ;Interpolate Point
IP              18         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   13 7      ;PUSH Bytes
SRP1            7          ;Set Reference Point 1
SRP2            13         ;Set Reference Point 2
                           #--- PUSHB_3   15 16 26  ;PUSH Bytes
IP              26         ;Interpolate Point
IP              16         ;Interpolate Point
IP              15         ;Interpolate Point
                           #--- PUSHB_1   23        ;PUSH Bytes
SRP1            23         ;Set Reference Point 1
                           #--- PUSHB_1   21        ;PUSH Bytes
IP              21         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'four': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   5 5 0     ;PUSH Bytes
CALL            0 5 5      ;CALL function
                           #--- PUSHB_5   3 13 1 5 13 ;PUSH Bytes
CALL            13 5 1 13 3 ;CALL function
                           #--- PUSHB_1   7         ;PUSH Bytes
SHP[rp1]        7          ;SHift Point using reference point
                           #--- PUSHB_2   3 13      ;PUSH Bytes
MIRP[min,black] ecstemt 3  ;Move Indirect Relative Point
                           #--- PUSHB_1   9         ;PUSH Bytes
SHP[rp2]        9          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   14        ;PUSH Bytes
MDAP[rnd]       14         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_1   11        ;PUSH Bytes
SHP[rp2]        11         ;SHift Point using reference point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_1   6         ;PUSH Bytes
SHP[rp2]        6          ;SHift Point using reference point
                           #--- PUSHB_3   0 1 10    ;PUSH Bytes
CALL            10 1 0     ;CALL function
                           #--- PUSHB_4   64 0 9 9  ;PUSH Bytes
CALL            9 9 0 64   ;CALL function
                           #--- PUSHB_3   1 0 10    ;PUSH Bytes
CALL            10 0 1     ;CALL function
                           #--- PUSHB_4   64 1 3 9  ;PUSH Bytes
CALL            9 3 1 64   ;CALL function
                           #--- PUSHB_2   15 1      ;PUSH Bytes
CALL            1 15       ;CALL function
                           #--- PUSHB_2   0 1       ;PUSH Bytes
SRP1            1          ;Set Reference Point 1
SRP2            0          ;Set Reference Point 2
                           #--- PUSHB_1   5         ;PUSH Bytes
IP              5          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   13 3      ;PUSH Bytes
SRP1            3          ;Set Reference Point 1
SRP2            13         ;Set Reference Point 2
                           #--- PUSHB_1   4         ;PUSH Bytes
IP              4          ;Interpolate Point
                           #--- PUSHB_1   5         ;PUSH Bytes
SRP1            5          ;Set Reference Point 1
                           #--- PUSHB_1   12        ;PUSH Bytes
IP              12         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'fraction': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   2 1 0     ;PUSH Bytes
CALL            0 1 2      ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'g': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   13 1 0    ;PUSH Bytes
CALL            0 1 13     ;CALL function
                           #--- PUSHB_2   28 6      ;PUSH Bytes
MIRP[min,black] estemtc 28 ;Move Indirect Relative Point
                           #--- PUSHB_3   23 3 0    ;PUSH Bytes
CALL            0 3 23     ;CALL function
                           #--- PUSHB_3   19 3 0    ;PUSH Bytes
CALL            0 3 19     ;CALL function
                           #--- PUSHB_2   34 6      ;PUSH Bytes
MIRP[min,black] estemtc 34 ;Move Indirect Relative Point
                           #--- PUSHB_1   0         ;PUSH Bytes
MDAP[rnd]       0          ;Move Direct Absolute Point
                           #--- PUSHB_2   7 6       ;PUSH Bytes
MIRP[min,black] estemtc 7  ;Move Indirect Relative Point
                           #--- PUSHB_3   7 0 10    ;PUSH Bytes
CALL            10 0 7     ;CALL function
                           #--- PUSHB_4   64 7 3 9  ;PUSH Bytes
CALL            9 3 7 64   ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   40        ;PUSH Bytes
MDAP[rnd]       40         ;Move Direct Absolute Point
                           #--- PUSHB_1   16        ;PUSH Bytes
MDRP[rp0,rnd,white] 16         ;Move Direct Relative Point
                           #--- PUSHB_2   37 16     ;PUSH Bytes
MIRP[min,black] estemw 37  ;Move Indirect Relative Point
                           #--- PUSHB_1   37        ;PUSH Bytes
SRP0            37         ;Set Reference Point 0
                           #--- PUSHB_1   4         ;PUSH Bytes
DUP             4          ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   3 16      ;PUSH Bytes
MIRP[min,black] estemw 3   ;Move Indirect Relative Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDAP[rnd]       3          ;Move Direct Absolute Point
                           #--- PUSHB_2   4 16      ;PUSH Bytes
MIRP[min,black] estemw 4   ;Move Indirect Relative Point
                           #--- PUSHB_1   37        ;PUSH Bytes
#SRP0            37         ;Set Reference Point 0
#                           #--- PUSHB_2   10 1      ;PUSH Bytes
#CALL            1 10       ;CALL function
#                           #--- PUSHB_2   22 31     ;PUSH Bytes
#SHP[rp2]        31         ;SHift Point using reference point
#SHP[rp2]        22         ;SHift Point using reference point
#                           #--- PUSHB_2   25 16     ;PUSH Bytes
#MIRP[min,black] estemw 25  ;Move Indirect Relative Point
#                           #--- PUSHB_2   41 1      ;PUSH Bytes
#CALL            1 41       ;CALL function
srp0    41
mdrp[rp0,min,rnd,white] 25
mdrp[rp0,min,rnd,grey]  10
alignrp 31
alignrp 22
mirp[min,black] estemw  25
#
                           #--- PUSHB_2   10 4      ;PUSH Bytes
SRP1            4          ;Set Reference Point 1
SRP2            10         ;Set Reference Point 2
                           #--- PUSHB_5   0 13 19 28 34 ;PUSH Bytes
                           #--- DEPTH     #5        ;DEPTH of the stack
SLOOP           5          ;Set LOOP variable
IP              34 28 19 13 0 ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   28 13     ;PUSH Bytes
SRP1            13         ;Set Reference Point 1
SRP2            28         ;Set Reference Point 2
                           #--- PUSHB_1   10        ;PUSH Bytes
IP              10         ;Interpolate Point
                           #--- PUSHB_1   34        ;PUSH Bytes
SRP1            34         ;Set Reference Point 1
                           #--- PUSHB_2   16 22     ;PUSH Bytes
IP              22         ;Interpolate Point
IP              16         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'grave': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   3 5 0     ;PUSH Bytes
CALL            0 5 3      ;CALL function
                           #--- PUSHB_5   1 14 0 15 4 ;PUSH Bytes
CALL            4 15 0 14 1 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   2         ;PUSH Bytes
MDRP[rp0,rnd,white] 2          ;Move Direct Relative Point
                           #--- PUSHB_5   0 16 0 11 4 ;PUSH Bytes
CALL            4 11 0 16 0 ;CALL function
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'greater': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   25 1 0    ;PUSH Bytes
CALL            0 1 25     ;CALL function
                           #--- PUSHB_5   26 14 0 30 4 ;PUSH Bytes
CALL            4 30 0 14 26 ;CALL function
                           #--- PUSHB_1   9         ;PUSH Bytes
MDAP[rnd]       9          ;Move Direct Absolute Point
                           #--- PUSHB_2   16 11     ;PUSH Bytes
MIRP[min,black] cvt_11 16  ;Move Indirect Relative Point
                           #--- PUSHB_3   9 16 10   ;PUSH Bytes
CALL            10 16 9    ;CALL function
                           #--- PUSHB_4   64 9 13 9 ;PUSH Bytes
CALL            9 13 9 64  ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   28        ;PUSH Bytes
MDAP[rnd]       28         ;Move Direct Absolute Point
                           #--- PUSHB_1   13        ;PUSH Bytes
MDRP[rp0,rnd,white] 13         ;Move Direct Relative Point
                           #--- PUSHB_2   12 16     ;PUSH Bytes
MIRP[min,black] estemw 12  ;Move Indirect Relative Point
                           #--- PUSHB_1   12        ;PUSH Bytes
SRP0            12         ;Set Reference Point 0
                           #--- PUSHB_2   25 1      ;PUSH Bytes
CALL            1 25       ;CALL function
                           #--- PUSHB_1   1         ;PUSH Bytes
SHP[rp2]        1          ;SHift Point using reference point
                           #--- PUSHB_5   24 16 0 30 4 ;PUSH Bytes
CALL            4 30 0 16 24 ;CALL function
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_1   24        ;PUSH Bytes
SRP0            24         ;Set Reference Point 0
                           #--- PUSHB_2   6 1       ;PUSH Bytes
CALL            1 6        ;CALL function
                           #--- PUSHB_2   19 16     ;PUSH Bytes
MIRP[min,black] estemw 19  ;Move Indirect Relative Point
                           #--- PUSHB_2   29 1      ;PUSH Bytes
CALL            1 29       ;CALL function
                           #--- PUSHB_2   12 13     ;PUSH Bytes
SRP1            13         ;Set Reference Point 1
SRP2            12         ;Set Reference Point 2
                           #--- PUSHB_1   14        ;PUSH Bytes
IP              14         ;Interpolate Point
                           #--- PUSHB_2   0 25      ;PUSH Bytes
SRP1            25         ;Set Reference Point 1
SRP2            0          ;Set Reference Point 2
                           #--- PUSHB_2   9 16      ;PUSH Bytes
IP              16         ;Interpolate Point
IP              9          ;Interpolate Point
                           #--- PUSHB_1   24        ;PUSH Bytes
SRP1            24         ;Set Reference Point 1
                           #--- PUSHB_1   3         ;PUSH Bytes
IP              3          ;Interpolate Point
                           #--- PUSHB_1   6         ;PUSH Bytes
SRP2            6          ;Set Reference Point 2
                           #--- PUSHB_2   4 22      ;PUSH Bytes
IP              22         ;Interpolate Point
IP              4          ;Interpolate Point
                           #--- PUSHB_1   19        ;PUSH Bytes
SRP1            19         ;Set Reference Point 1
                           #--- PUSHB_1   21        ;PUSH Bytes
IP              21         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   9 26      ;PUSH Bytes
SRP1            26         ;Set Reference Point 1
SRP2            9          ;Set Reference Point 2
                           #--- PUSHB_2   0 19      ;PUSH Bytes
IP              19         ;Interpolate Point
IP              0          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'guillemotleft': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   10 4 0    ;PUSH Bytes
CALL            0 4 10     ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   14        ;PUSH Bytes
MDAP[rnd]       14         ;Move Direct Absolute Point
                           #--- PUSHB_2   15 1      ;PUSH Bytes
CALL            1 15       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'guilsinglleft': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   7         ;PUSH Bytes
MDAP[rnd]       7          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_5   6 16 0 8 4 ;PUSH Bytes
CALL            4 8 0 16 6 ;CALL function
                           #--- PUSHB_1   4         ;PUSH Bytes
SHP[rp2]        4          ;SHift Point using reference point
                           #--- PUSHB_2   8 1       ;PUSH Bytes
CALL            1 8        ;CALL function
                           #--- PUSHB_2   6 1       ;PUSH Bytes
SRP1            1          ;Set Reference Point 1
SRP2            6          ;Set Reference Point 2
                           #--- PUSHB_3   0 3 5     ;PUSH Bytes
IP              5          ;Interpolate Point
IP              3          ;Interpolate Point
IP              0          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'guilsinglright': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   7         ;PUSH Bytes
MDAP[rnd]       7          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_1   4         ;PUSH Bytes
SHP[rp2]        4          ;SHift Point using reference point
                           #--- PUSHB_5   0 16 0 8 4 ;PUSH Bytes
CALL            4 8 0 16 0 ;CALL function
                           #--- PUSHB_2   8 1       ;PUSH Bytes
CALL            1 8        ;CALL function
                           #--- PUSHB_2   0 1       ;PUSH Bytes
SRP1            1          ;Set Reference Point 1
SRP2            0          ;Set Reference Point 2
                           #--- PUSHB_1   3         ;PUSH Bytes
IP              3          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'h': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   10 1 0    ;PUSH Bytes
CALL            0 1 10     ;CALL function
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_3   11 5 0    ;PUSH Bytes
CALL            0 5 11     ;CALL function
                           #--- PUSHB_3   16 3 0    ;PUSH Bytes
CALL            0 3 16     ;CALL function
                           #--- PUSHB_2   5 6       ;PUSH Bytes
MIRP[min,black] estemtc 5  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   20        ;PUSH Bytes
MDAP[rnd]       20         ;Move Direct Absolute Point
                           #--- PUSHB_1   11        ;PUSH Bytes
MDRP[rp0,rnd,white] 11         ;Move Direct Relative Point
gf_160(11)
                           #--- PUSHB_2   13 15     ;PUSH Bytes
MIRP[min,black] headstem_thick 13 ;Move Indirect Relative Point
                           #--- PUSHB_1   8         ;PUSH Bytes
SHP[rp2]        8          ;SHift Point using reference point
                           #--- PUSHB_1   13        ;PUSH Bytes
#SRP0            13         ;Set Reference Point 0
#                           #--- PUSHB_2   1 1       ;PUSH Bytes
#CALL            1 1        ;CALL function
#                           #--- PUSHB_2   0 16      ;PUSH Bytes
#MIRP[min,black] estemw 0   ;Move Indirect Relative Point
#                           #--- PUSHB_2   21 1      ;PUSH Bytes
#CALL            1 21       ;CALL function
grx(21,0,1)
                           #--- PUSHB_2   1 13      ;PUSH Bytes
SRP1            13         ;Set Reference Point 1
SRP2            1          ;Set Reference Point 2
                           #--- PUSHB_1   16        ;PUSH Bytes
IP              16         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   5 10      ;PUSH Bytes
SRP1            10         ;Set Reference Point 1
SRP2            5          ;Set Reference Point 2
                           #--- PUSHB_1   13        ;PUSH Bytes
IP              13         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'hyphen': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   2 14      ;PUSH Bytes
MIRP[min,black] ecstemw 2  ;Move Indirect Relative Point
                           #--- PUSHB_2   2 14      ;PUSH Bytes
MIRP[min,black] ecstemw 2  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_2   1 1       ;PUSH Bytes
CALL            1 1        ;CALL function
                           #--- PUSHB_5   0 16 0 8 4 ;PUSH Bytes
CALL            4 8 0 16 0 ;CALL function
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'i': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_5   5 14 0 30 4 ;PUSH Bytes
CALL            4 30 0 14 5 ;CALL function
                           #--- PUSHB_3   2 3 0     ;PUSH Bytes
CALL            0 3 2      ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
gf_148(1)
                           #--- PUSHB_1   5         ;PUSH Bytes
SHP[rp2]        5          ;SHift Point using reference point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_1   4         ;PUSH Bytes
SHP[rp2]        4          ;SHift Point using reference point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'j': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 0 0     ;PUSH Bytes
CALL            0 0 0      ;CALL function
                           #--- PUSHB_2   5 6       ;PUSH Bytes
MIRP[min,black] estemtc 5  ;Move Indirect Relative Point
                           #--- PUSHB_3   16 5 0    ;PUSH Bytes
CALL            0 5 16     ;CALL function
                           #--- PUSHB_5   15 14 0 30 4 ;PUSH Bytes
CALL            4 30 0 14 15 ;CALL function
                           #--- PUSHB_3   9 3 0     ;PUSH Bytes
CALL            0 3 9      ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   18        ;PUSH Bytes
MDAP[rnd]       18         ;Move Direct Absolute Point
                           #--- PUSHB_1   8         ;PUSH Bytes
MDRP[rp0,rnd,white] 8          ;Move Direct Relative Point
gf_148(8)
                           #--- PUSHB_1   15        ;PUSH Bytes
SHP[rp2]        15         ;SHift Point using reference point
                           #--- PUSHB_2   11 16     ;PUSH Bytes
MIRP[min,black] estemw 11  ;Move Indirect Relative Point
                           #--- PUSHB_1   14        ;PUSH Bytes
SHP[rp2]        14         ;SHift Point using reference point
                           #--- PUSHB_2   19 1      ;PUSH Bytes
CALL            1 19       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   5 0       ;PUSH Bytes
SRP1            0          ;Set Reference Point 1
SRP2            5          ;Set Reference Point 2
                           #--- PUSHB_1   2         ;PUSH Bytes
IP              2          ;Interpolate Point
                           #--- PUSHB_1   9         ;PUSH Bytes
SRP1            9          ;Set Reference Point 1
                           #--- PUSHB_1   3         ;PUSH Bytes
IP              3          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'k': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   5 1 0     ;PUSH Bytes
CALL            0 1 5      ;CALL function
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_3   9 3 0     ;PUSH Bytes
CALL            0 3 9      ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   12        ;PUSH Bytes
MDAP[rnd]       12         ;Move Direct Absolute Point
                           #--- PUSHB_1   5         ;PUSH Bytes
MDRP[rp0,rnd,white] 5          ;Move Direct Relative Point
gf_160(5)
                           #--- PUSHB_2   4 16      ;PUSH Bytes
MIRP[min,black] estemw 4   ;Move Indirect Relative Point
                           #--- PUSHB_1   7         ;PUSH Bytes
SHP[rp2]        7          ;SHift Point using reference point
                           #--- PUSHB_2   13 1      ;PUSH Bytes
CALL            1 13       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   9 5       ;PUSH Bytes
SRP1            5          ;Set Reference Point 1
SRP2            9          ;Set Reference Point 2
                           #--- PUSHB_2   2 8       ;PUSH Bytes
IP              8          ;Interpolate Point
IP              2          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'l': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   2 5 0     ;PUSH Bytes
CALL            0 5 2      ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
gf_160(1)
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'less': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   2 12      ;PUSH Bytes
MIRP[min,black] cvt_12 2   ;Move Indirect Relative Point
                           #--- PUSHB_1   5         ;PUSH Bytes
MDAP[rnd]       5          ;Move Direct Absolute Point
                           #--- PUSHB_2   6 12      ;PUSH Bytes
MIRP[min,black] cvt_12 6   ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'logicalnot': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   3         ;PUSH Bytes
MDAP[rnd]       3          ;Move Direct Absolute Point
                           #--- PUSHB_2   4 6       ;PUSH Bytes
MIRP[min,black] estemtc 4  ;Move Indirect Relative Point
                           #--- PUSHB_3   3 4 10    ;PUSH Bytes
CALL            10 4 3     ;CALL function
                           #--- PUSHB_4   64 3 1 9  ;PUSH Bytes
CALL            9 1 3 64   ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   6         ;PUSH Bytes
MDAP[rnd]       6          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_3   1 0 10    ;PUSH Bytes
CALL            10 0 1     ;CALL function
                           #--- PUSHB_4   64 1 3 9  ;PUSH Bytes
CALL            9 3 1 64   ;CALL function
                           #--- PUSHB_2   7 1       ;PUSH Bytes
CALL            1 7        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'm': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   19 1 0    ;PUSH Bytes
CALL            0 1 19     ;CALL function
                           #--- PUSHB_2   0 9       ;PUSH Bytes
SHP[rp1]        9          ;SHift Point using reference point
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_3   20 3 0    ;PUSH Bytes
CALL            0 3 20     ;CALL function
                           #--- PUSHB_3   25 3 0    ;PUSH Bytes
CALL            0 3 25     ;CALL function
                           #--- PUSHB_1   30        ;PUSH Bytes
SHP[rp1]        30         ;SHift Point using reference point
                           #--- PUSHB_2   14 6      ;PUSH Bytes
MIRP[min,black] estemtc 14 ;Move Indirect Relative Point
                           #--- PUSHB_1   5         ;PUSH Bytes
SHP[rp2]        5          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   34        ;PUSH Bytes
MDAP[rnd]       34         ;Move Direct Absolute Point
                           #--- PUSHB_1   19        ;PUSH Bytes
MDRP[rp0,rnd,white] 19         ;Move Direct Relative Point
gf_148(19)
                           #--- PUSHB_2   18 16     ;PUSH Bytes
MIRP[min,black] estemw 18  ;Move Indirect Relative Point
                           #--- PUSHB_2   22 15     ;PUSH Bytes
MIRP[min,black] headstem_thick 22 ;Move Indirect Relative Point
                           #--- PUSHB_1   18        ;PUSH Bytes
SRP0            18         ;Set Reference Point 0
                           #--- PUSHB_2   10 1      ;PUSH Bytes
#CALL            1 10       ;CALL function
#                           #--- PUSHB_2   9 16      ;PUSH Bytes
#MIRP[min,black] estemw 9   ;Move Indirect Relative Point
#                           #--- PUSHB_1   9         ;PUSH Bytes
#SRP0            9          ;Set Reference Point 0
#                           #--- PUSHB_2   1 1       ;PUSH Bytes
#CALL            1 1        ;CALL function
#                           #--- PUSHB_2   0 16      ;PUSH Bytes
#MIRP[min,black] estemw 0   ;Move Indirect Relative Point
#                           #--- PUSHB_2   35 1      ;PUSH Bytes
#CALL            1 35       ;CALL function
#                           #--- PUSHB_2   10 18     ;PUSH Bytes
grx(35,0,1)
ipr(19,1,10)
mirp[min,black] estemw 9
#
SRP1            18         ;Set Reference Point 1
SRP2            10         ;Set Reference Point 2
                           #--- PUSHB_1   25        ;PUSH Bytes
IP              25         ;Interpolate Point
                           #--- PUSHB_1   9         ;PUSH Bytes
SRP1            9          ;Set Reference Point 1
                           #--- PUSHB_1   27        ;PUSH Bytes
IP              27         ;Interpolate Point
                           #--- PUSHB_1   1         ;PUSH Bytes
SRP2            1          ;Set Reference Point 2
                           #--- PUSHB_1   30        ;PUSH Bytes
IP              30         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   14 19     ;PUSH Bytes
SRP1            19         ;Set Reference Point 1
SRP2            14         ;Set Reference Point 2
                           #--- PUSHB_2   22 27     ;PUSH Bytes
IP              27         ;Interpolate Point
IP              22         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'macron': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   2 9       ;PUSH Bytes
MIRP[min,black] headstem 2 ;Move Indirect Relative Point
                           #--- PUSHB_2   2 9       ;PUSH Bytes
MIRP[min,black] headstem 2 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'minute': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   2         ;PUSH Bytes
MDAP[rnd]       2          ;Move Direct Absolute Point
                           #--- PUSHB_5   3 14 0 7 4 ;PUSH Bytes
CALL            4 7 0 14 3 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   2         ;PUSH Bytes
MDRP[rp0,rnd,white] 2          ;Move Direct Relative Point
                           #--- PUSHB_5   0 16 0 10 4 ;PUSH Bytes
CALL            4 10 0 16 0 ;CALL function
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   3 2       ;PUSH Bytes
SRP1            2          ;Set Reference Point 1
SRP2            3          ;Set Reference Point 2
                           #--- PUSHB_1   0         ;PUSH Bytes
IP              0          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'mu': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   14 1 0    ;PUSH Bytes
CALL            0 1 14     ;CALL function
                           #--- PUSHB_3   19 1 0    ;PUSH Bytes
CALL            0 1 19     ;CALL function
                           #--- PUSHB_2   7 14      ;PUSH Bytes
MIRP[min,black] ecstemw 7  ;Move Indirect Relative Point
                           #--- PUSHB_3   19 7 10   ;PUSH Bytes
CALL            10 7 19    ;CALL function
                           #--- PUSHB_4   64 19 1 9 ;PUSH Bytes
CALL            9 1 19 64  ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   23        ;PUSH Bytes
MDAP[rnd]       23         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_1   3         ;PUSH Bytes
SHP[rp2]        3          ;SHift Point using reference point
                           #--- PUSHB_1   0         ;PUSH Bytes
SRP0            0          ;Set Reference Point 0
                           #--- PUSHB_2   10 1      ;PUSH Bytes
CALL            1 10       ;CALL function
                           #--- PUSHB_2   13 16     ;PUSH Bytes
MIRP[min,black] estemw 13  ;Move Indirect Relative Point
                           #--- PUSHB_1   13        ;PUSH Bytes
SRP0            13         ;Set Reference Point 0
                           #--- PUSHB_2   14 16     ;PUSH Bytes
MIRP[min,black] estemw 14  ;Move Indirect Relative Point
                           #--- PUSHB_1   14        ;PUSH Bytes
MDAP[rnd]       14         ;Move Direct Absolute Point
                           #--- PUSHB_2   24 1      ;PUSH Bytes
CALL            1 24       ;CALL function
                           #--- PUSHB_2   10 0      ;PUSH Bytes
SRP1            0          ;Set Reference Point 1
SRP2            10         ;Set Reference Point 2
                           #--- PUSHB_1   19        ;PUSH Bytes
IP              19         ;Interpolate Point
                           #--- PUSHB_1   14        ;PUSH Bytes
SRP1            14         ;Set Reference Point 1
                           #--- PUSHB_1   16        ;PUSH Bytes
IP              16         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   7 14      ;PUSH Bytes
SRP1            14         ;Set Reference Point 1
SRP2            7          ;Set Reference Point 2
                           #--- PUSHB_3   15 16 22  ;PUSH Bytes
IP              22         ;Interpolate Point
IP              16         ;Interpolate Point
IP              15         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'n': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   10 1 0    ;PUSH Bytes
CALL            0 1 10     ;CALL function
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_3   11 3 0    ;PUSH Bytes
CALL            0 3 11     ;CALL function
                           #--- PUSHB_3   16 3 0    ;PUSH Bytes
CALL            0 3 16     ;CALL function
                           #--- PUSHB_2   5 6       ;PUSH Bytes
MIRP[min,black] estemtc 5  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   20        ;PUSH Bytes
MDAP[rnd]       20         ;Move Direct Absolute Point
                           #--- PUSHB_1   10        ;PUSH Bytes
MDRP[rp0,rnd,white] 10         ;Move Direct Relative Point
gf_148(10)
                           #--- PUSHB_2   9 16      ;PUSH Bytes
MIRP[min,black] estemw 9   ;Move Indirect Relative Point
                           #--- PUSHB_1   12        ;PUSH Bytes
SHP[rp2]        12         ;SHift Point using reference point
                           #--- PUSHB_1   9         ;PUSH Bytes
#SRP0            9          ;Set Reference Point 0
#                           #--- PUSHB_2   1 1       ;PUSH Bytes
#CALL            1 1        ;CALL function
#                           #--- PUSHB_2   0 16      ;PUSH Bytes
#MIRP[min,black] estemw 0   ;Move Indirect Relative Point
#                           #--- PUSHB_2   21 1      ;PUSH Bytes
#CALL            1 21       ;CALL function
grx(21,0,1)
                           #--- PUSHB_2   1 9       ;PUSH Bytes
SRP1            9          ;Set Reference Point 1
SRP2            1          ;Set Reference Point 2
                           #--- PUSHB_1   16        ;PUSH Bytes
IP              16         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   5 10      ;PUSH Bytes
SRP1            10         ;Set Reference Point 1
SRP2            5          ;Set Reference Point 2
                           #--- PUSHB_1   13        ;PUSH Bytes
IP              13         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'nine': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   7 14      ;PUSH Bytes
MIRP[min,black] ecstemw 7  ;Move Indirect Relative Point
                           #--- PUSHB_3   7 0 10    ;PUSH Bytes
CALL            10 0 7     ;CALL function
                           #--- PUSHB_4   64 7 3 9  ;PUSH Bytes
CALL            9 3 7 64   ;CALL function
                           #--- PUSHB_1   13        ;PUSH Bytes
MDAP[rnd]       13         ;Move Direct Absolute Point
                           #--- PUSHB_2   25 14     ;PUSH Bytes
MIRP[min,black] ecstemw 25 ;Move Indirect Relative Point
                           #--- PUSHB_1   31        ;PUSH Bytes
MDAP[rnd]       31         ;Move Direct Absolute Point
                           #--- PUSHB_2   19 14     ;PUSH Bytes
MIRP[min,black] ecstemw 19 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   37        ;PUSH Bytes
MDAP[rnd]       37         ;Move Direct Absolute Point
                           #--- PUSHB_1   16        ;PUSH Bytes
MDRP[rp0,rnd,white] 16         ;Move Direct Relative Point
                           #--- PUSHB_2   34 16     ;PUSH Bytes
MIRP[min,black] estemw 34  ;Move Indirect Relative Point
                           #--- PUSHB_1   4         ;PUSH Bytes
SHP[rp2]        4          ;SHift Point using reference point
                           #--- PUSHB_1   34        ;PUSH Bytes
SRP0            34         ;Set Reference Point 0
                           #--- PUSHB_2   3 16      ;PUSH Bytes
MIRP[min,black] estemw 3   ;Move Indirect Relative Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDAP[rnd]       3          ;Move Direct Absolute Point
                           #--- PUSHB_1   34        ;PUSH Bytes
SRP0            34         ;Set Reference Point 0
                           #--- PUSHB_2   10 1      ;PUSH Bytes
CALL            1 10       ;CALL function
                           #--- PUSHB_2   22 16     ;PUSH Bytes
MIRP[min,black] estemw 22  ;Move Indirect Relative Point
                           #--- PUSHB_2   38 1      ;PUSH Bytes
CALL            1 38       ;CALL function
                           #--- PUSHB_2   10 34     ;PUSH Bytes
SRP1            34         ;Set Reference Point 1
SRP2            10         ;Set Reference Point 2
                           #--- PUSHB_4   0 13 19 28 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
IP              28 19 13 0 ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   25 13     ;PUSH Bytes
SRP1            13         ;Set Reference Point 1
SRP2            25         ;Set Reference Point 2
                           #--- PUSHB_1   10        ;PUSH Bytes
IP              10         ;Interpolate Point
                           #--- PUSHB_1   31        ;PUSH Bytes
SRP1            31         ;Set Reference Point 1
                           #--- PUSHB_2   22 16     ;PUSH Bytes
IP              16         ;Interpolate Point
IP              22         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'numbersign': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   5 1 0     ;PUSH Bytes
CALL            0 1 5      ;CALL function
                           #--- PUSHB_3   0 1 4     ;PUSH Bytes
SHP[rp1]        4          ;SHift Point using reference point
SHP[rp1]        1          ;SHift Point using reference point
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_3   14 5 0    ;PUSH Bytes
CALL            0 5 14     ;CALL function
                           #--- PUSHB_3   15 18 19  ;PUSH Bytes
SHP[rp1]        19         ;SHift Point using reference point
SHP[rp1]        18         ;SHift Point using reference point
SHP[rp1]        15         ;SHift Point using reference point
                           #--- PUSHB_3   12 3 0    ;PUSH Bytes
CALL            0 3 12     ;CALL function
                           #--- PUSHB_4   13 16 17 20 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
SHP[rp1]        20 17 16 13 ;SHift Point using reference point
                           #--- PUSHB_2   11 14     ;PUSH Bytes
MIRP[min,black] ecstemw 11 ;Move Indirect Relative Point
                           #--- PUSHB_4   10 23 30 31 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
SHP[rp2]        31 30 23 10 ;SHift Point using reference point
                           #--- PUSHB_5   7 8 5 12 13 ;PUSH Bytes
CALL            13 12 5 8 7 ;CALL function
                           #--- PUSHB_4   9 24 28 29 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
SHP[rp1]        29 28 24 9 ;SHift Point using reference point
                           #--- PUSHB_2   7 14      ;PUSH Bytes
MIRP[min,black] ecstemw 7  ;Move Indirect Relative Point
                           #--- PUSHB_4   2 3 6 27  ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
SHP[rp2]        27 6 3 2   ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   32        ;PUSH Bytes
MDAP[rnd]       32         ;Move Direct Absolute Point
                           #--- PUSHB_2   33 1      ;PUSH Bytes
CALL            1 33       ;CALL function
                           #--- PUSHB_1   54        ;PUSH Bytes
SMD             54         ;Set Minimum Distance
                           #--- PUSHB_2   5 14      ;PUSH Bytes
SDPVTL[orthog]  14 5       ;Set Dual Projection Vector To Line
                           #--- PUSHB_1   5         ;PUSH Bytes
MDAP[no-rnd]    5          ;Move Direct Absolute Point
                           #--- PUSHB_1   15        ;PUSH Bytes
MDAP[no-rnd]    15         ;Move Direct Absolute Point
                           #--- PUSHB_1   5         ;PUSH Bytes
SRP0            5          ;Set Reference Point 0
                           #--- PUSHB_2   4 17      ;PUSH Bytes
MIRP[rp0,min,black] cvt_17 4   ;Move Indirect Relative Point
                           #--- PUSHB_1   15        ;PUSH Bytes
SRP0            15         ;Set Reference Point 0
                           #--- PUSHB_2   14 17     ;PUSH Bytes
MIRP[rp0,min,black] cvt_17 14  ;Move Indirect Relative Point
                           #--- PUSHB_2   1 18      ;PUSH Bytes
SDPVTL[orthog]  18 1       ;Set Dual Projection Vector To Line
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[no-rnd]    1          ;Move Direct Absolute Point
                           #--- PUSHB_1   19        ;PUSH Bytes
MDAP[no-rnd]    19         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
SRP0            1          ;Set Reference Point 0
                           #--- PUSHB_2   0 13      ;PUSH Bytes
MIRP[rp0,min,black] ecstemt 0  ;Move Indirect Relative Point
                           #--- PUSHB_1   19        ;PUSH Bytes
SRP0            19         ;Set Reference Point 0
                           #--- PUSHB_2   18 13     ;PUSH Bytes
MIRP[rp0,min,black] ecstemt 18 ;Move Indirect Relative Point
                           #--- PUSHB_1   1         ;PUSH Bytes
SRP0            1          ;Set Reference Point 0
                           #--- PUSHB_4   2 1 18 19 ;PUSH Bytes
CALL            19 18 1 2  ;CALL function
                           #--- PUSHB_1   4         ;PUSH Bytes
SRP0            4          ;Set Reference Point 0
                           #--- PUSHB_4   3 4 15 19 ;PUSH Bytes
CALL            19 15 4 3  ;CALL function
                           #--- PUSHB_1   5         ;PUSH Bytes
SRP0            5          ;Set Reference Point 0
                           #--- PUSHB_4   6 5 14 19 ;PUSH Bytes
CALL            19 14 5 6  ;CALL function
                           #--- PUSHB_4   9 5 14 19 ;PUSH Bytes
CALL            19 14 5 9  ;CALL function
                           #--- PUSHB_4   10 5 14 19 ;PUSH Bytes
CALL            19 14 5 10 ;CALL function
                           #--- PUSHB_4   13 5 14 19 ;PUSH Bytes
CALL            19 14 5 13 ;CALL function
                           #--- PUSHB_1   4         ;PUSH Bytes
SRP0            4          ;Set Reference Point 0
                           #--- PUSHB_4   16 4 15 19 ;PUSH Bytes
CALL            19 15 4 16 ;CALL function
                           #--- PUSHB_1   1         ;PUSH Bytes
SRP0            1          ;Set Reference Point 0
                           #--- PUSHB_4   17 1 18 19 ;PUSH Bytes
CALL            19 18 1 17 ;CALL function
                           #--- PUSHB_1   0         ;PUSH Bytes
SRP0            0          ;Set Reference Point 0
                           #--- PUSHB_4   20 0 19 19 ;PUSH Bytes
CALL            19 19 0 20 ;CALL function
                           #--- PUSHB_4   23 0 19 19 ;PUSH Bytes
CALL            19 19 0 23 ;CALL function
                           #--- PUSHB_4   24 0 19 19 ;PUSH Bytes
CALL            19 19 0 24 ;CALL function
                           #--- PUSHB_4   27 0 19 19 ;PUSH Bytes
CALL            19 19 0 27 ;CALL function
                           #--- PUSHB_1   4         ;PUSH Bytes
SRP0            4          ;Set Reference Point 0
                           #--- PUSHB_4   28 4 15 19 ;PUSH Bytes
CALL            19 15 4 28 ;CALL function
                           #--- PUSHB_1   1         ;PUSH Bytes
SRP0            1          ;Set Reference Point 0
                           #--- PUSHB_4   29 1 18 19 ;PUSH Bytes
CALL            19 18 1 29 ;CALL function
                           #--- PUSHB_4   30 1 18 19 ;PUSH Bytes
CALL            19 18 1 30 ;CALL function
                           #--- PUSHB_1   4         ;PUSH Bytes
SRP0            4          ;Set Reference Point 0
                           #--- PUSHB_4   31 4 15 19 ;PUSH Bytes
CALL            19 15 4 31 ;CALL function
SPVTCA[x-axis]             ;Set Projection Vector To Coordinate Axis
                           #--- NPUSHB    24 0 1 2 3 4 5 6 9 10 13 14 15 16 17 18 19 20 23 24 27 28 29 30 31 ;PUSH N Bytes
MDAP[no-rnd]    31         ;Move Direct Absolute Point
MDAP[no-rnd]    30         ;Move Direct Absolute Point
MDAP[no-rnd]    29         ;Move Direct Absolute Point
MDAP[no-rnd]    28         ;Move Direct Absolute Point
MDAP[no-rnd]    27         ;Move Direct Absolute Point
MDAP[no-rnd]    24         ;Move Direct Absolute Point
MDAP[no-rnd]    23         ;Move Direct Absolute Point
MDAP[no-rnd]    20         ;Move Direct Absolute Point
MDAP[no-rnd]    19         ;Move Direct Absolute Point
MDAP[no-rnd]    18         ;Move Direct Absolute Point
MDAP[no-rnd]    17         ;Move Direct Absolute Point
MDAP[no-rnd]    16         ;Move Direct Absolute Point
MDAP[no-rnd]    15         ;Move Direct Absolute Point
MDAP[no-rnd]    14         ;Move Direct Absolute Point
MDAP[no-rnd]    13         ;Move Direct Absolute Point
MDAP[no-rnd]    10         ;Move Direct Absolute Point
MDAP[no-rnd]    9          ;Move Direct Absolute Point
MDAP[no-rnd]    6          ;Move Direct Absolute Point
MDAP[no-rnd]    5          ;Move Direct Absolute Point
MDAP[no-rnd]    4          ;Move Direct Absolute Point
MDAP[no-rnd]    3          ;Move Direct Absolute Point
MDAP[no-rnd]    2          ;Move Direct Absolute Point
MDAP[no-rnd]    1          ;Move Direct Absolute Point
MDAP[no-rnd]    0          ;Move Direct Absolute Point
                           #--- PUSHB_1   64        ;PUSH Bytes
SMD             64         ;Set Minimum Distance
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'o': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   12 6      ;PUSH Bytes
MIRP[min,black] estemtc 12 ;Move Indirect Relative Point
                           #--- PUSHB_3   6 3 0     ;PUSH Bytes
CALL            0 3 6      ;CALL function
                           #--- PUSHB_2   18 6      ;PUSH Bytes
MIRP[min,black] estemtc 18 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   24        ;PUSH Bytes
MDAP[rnd]       24         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   21 16     ;PUSH Bytes
MIRP[min,black] estemw 21  ;Move Indirect Relative Point
                           #--- PUSHB_1   21        ;PUSH Bytes
#SRP0            21         ;Set Reference Point 0
#                           #--- PUSHB_2   15 1      ;PUSH Bytes
#CALL            1 15       ;CALL function
#                           #--- PUSHB_2   9 16      ;PUSH Bytes
#MIRP[min,black] estemw 9   ;Move Indirect Relative Point
#                           #--- PUSHB_2   25 1      ;PUSH Bytes
#CALL            1 25       ;CALL function
grx(25,9,15)
                           #--- PUSHB_2   15 21     ;PUSH Bytes
SRP1            21         ;Set Reference Point 1
SRP2            15         ;Set Reference Point 2
                           #--- PUSHB_2   6 0       ;PUSH Bytes
IP              0          ;Interpolate Point
IP              6          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   18 12     ;PUSH Bytes
SRP1            12         ;Set Reference Point 1
SRP2            18         ;Set Reference Point 2
                           #--- PUSHB_2   9 3       ;PUSH Bytes
IP              3          ;Interpolate Point
IP              9          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'one': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   9 5 0     ;PUSH Bytes
CALL            0 5 9      ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   11        ;PUSH Bytes
MDAP[rnd]       11         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_1   9         ;PUSH Bytes
SHP[rp2]        9          ;SHift Point using reference point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_2   12 1      ;PUSH Bytes
CALL            1 12       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'ordfeminine': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   5         ;PUSH Bytes
MDAP[rnd]       5          ;Move Direct Absolute Point
                           #--- PUSHB_2   38 6      ;PUSH Bytes
MIRP[min,black] estemtc 38 ;Move Indirect Relative Point
                           #--- PUSHB_1   17        ;PUSH Bytes
MDAP[rnd]       17         ;Move Direct Absolute Point
                           #--- PUSHB_2   25 6      ;PUSH Bytes
MIRP[min,black] estemtc 25 ;Move Indirect Relative Point
                           #--- PUSHB_3   17 25 10  ;PUSH Bytes
CALL            10 25 17   ;CALL function
                           #--- PUSHB_4   64 17 20 9 ;PUSH Bytes
CALL            9 20 17 64 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   41        ;PUSH Bytes
MDAP[rnd]       41         ;Move Direct Absolute Point
                           #--- PUSHB_1   8         ;PUSH Bytes
MDRP[rp0,rnd,white] 8          ;Move Direct Relative Point
                           #--- PUSHB_2   35 16     ;PUSH Bytes
MIRP[min,black] estemw 35  ;Move Indirect Relative Point
                           #--- PUSHB_1   35        ;PUSH Bytes
SRP0            35         ;Set Reference Point 0
                           #--- PUSHB_2   1 1       ;PUSH Bytes
CALL            1 1        ;CALL function
                           #--- PUSHB_2   13 30     ;PUSH Bytes
SHP[rp2]        30         ;SHift Point using reference point
SHP[rp2]        13         ;SHift Point using reference point
                           #--- PUSHB_2   0 15      ;PUSH Bytes
MIRP[min,black] headstem_thick 0 ;Move Indirect Relative Point
                           #--- PUSHB_2   42 1      ;PUSH Bytes
CALL            1 42       ;CALL function
                           #--- PUSHB_1   54        ;PUSH Bytes
SMD             54         ;Set Minimum Distance
                           #--- PUSHB_2   11 13     ;PUSH Bytes
SDPVTL[orthog]  13 11      ;Set Dual Projection Vector To Line
SFVTCA[y-axis]             ;Set Freedom Vector To Coordinate Axis
                           #--- PUSHB_1   13        ;PUSH Bytes
MDAP[no-rnd]    13         ;Move Direct Absolute Point
SFVTCA[x-axis]             ;Set Freedom Vector To Coordinate Axis
                           #--- PUSHB_1   11        ;PUSH Bytes
MDRP[grey]      11         ;Move Direct Relative Point
SFVTCA[y-axis]             ;Set Freedom Vector To Coordinate Axis
                           #--- PUSHB_2   30 22     ;PUSH Bytes
MIRP[rp0,min,black] cvt_22 30  ;Move Indirect Relative Point
SFVTCA[x-axis]             ;Set Freedom Vector To Coordinate Axis
                           #--- PUSHB_1   32        ;PUSH Bytes
MDRP[grey]      32         ;Move Direct Relative Point
SPVTCA[x-axis]             ;Set Projection Vector To Coordinate Axis
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_4   11 13 30 32 ;PUSH Bytes
MDAP[no-rnd]    32         ;Move Direct Absolute Point
MDAP[no-rnd]    30         ;Move Direct Absolute Point
MDAP[no-rnd]    13         ;Move Direct Absolute Point
MDAP[no-rnd]    11         ;Move Direct Absolute Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   11 32     ;PUSH Bytes
MDAP[no-rnd]    32         ;Move Direct Absolute Point
MDAP[no-rnd]    11         ;Move Direct Absolute Point
                           #--- PUSHB_1   64        ;PUSH Bytes
SMD             64         ;Set Minimum Distance
                           #--- PUSHB_2   35 8      ;PUSH Bytes
SRP1            8          ;Set Reference Point 1
SRP2            35         ;Set Reference Point 2
                           #--- PUSHB_3   20 21 22  ;PUSH Bytes
IP              22         ;Interpolate Point
IP              21         ;Interpolate Point
IP              20         ;Interpolate Point
                           #--- PUSHB_1   1         ;PUSH Bytes
SRP1            1          ;Set Reference Point 1
                           #--- PUSHB_1   17        ;PUSH Bytes
IP              17         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   38 5      ;PUSH Bytes
SRP1            5          ;Set Reference Point 1
SRP2            38         ;Set Reference Point 2
                           #--- PUSHB_2   0 2       ;PUSH Bytes
IP              2          ;Interpolate Point
IP              0          ;Interpolate Point
                           #--- PUSHB_2   25 17     ;PUSH Bytes
SRP1            17         ;Set Reference Point 1
SRP2            25         ;Set Reference Point 2
                           #--- PUSHB_1   22        ;PUSH Bytes
IP              22         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'p': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   13 1 0    ;PUSH Bytes
CALL            0 1 13     ;CALL function
                           #--- PUSHB_2   17 6      ;PUSH Bytes
MIRP[min,black] estemtc 17 ;Move Indirect Relative Point
                           #--- PUSHB_3   1 0 0     ;PUSH Bytes
CALL            0 0 1      ;CALL function
                           #--- PUSHB_3   2 3 0     ;PUSH Bytes
CALL            0 3 2      ;CALL function
                           #--- PUSHB_3   7 3 0     ;PUSH Bytes
CALL            0 3 7      ;CALL function
                           #--- PUSHB_2   23 6      ;PUSH Bytes
MIRP[min,black] estemtc 23 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   29        ;PUSH Bytes
MDAP[rnd]       29         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
gf_160(1)
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_2   3 26      ;PUSH Bytes
SHP[rp2]        26         ;SHift Point using reference point
SHP[rp2]        3          ;SHift Point using reference point
                           #--- PUSHB_1   0         ;PUSH Bytes
#SRP0            0          ;Set Reference Point 0
#                           #--- PUSHB_2   20 1      ;PUSH Bytes
#CALL            1 20       ;CALL function
#                           #--- PUSHB_2   10 16     ;PUSH Bytes
#MIRP[min,black] estemw 10  ;Move Indirect Relative Point
#                           #--- PUSHB_2   30 1      ;PUSH Bytes
#CALL            1 30       ;CALL function
grx(30,10,20)
                           #--- PUSHB_2   20 0      ;PUSH Bytes
SRP1            0          ;Set Reference Point 1
SRP2            20         ;Set Reference Point 2
                           #--- PUSHB_2   7 13      ;PUSH Bytes
IP              13         ;Interpolate Point
IP              7          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   17 13     ;PUSH Bytes
SRP1            13         ;Set Reference Point 1
SRP2            17         ;Set Reference Point 2
                           #--- PUSHB_1   16        ;PUSH Bytes
IP              16         ;Interpolate Point
                           #--- PUSHB_1   23        ;PUSH Bytes
SRP1            23         ;Set Reference Point 1
                           #--- PUSHB_2   10 4      ;PUSH Bytes
IP              4          ;Interpolate Point
IP              10         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'paragraph': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   14        ;PUSH Bytes
MDAP[rnd]       14         ;Move Direct Absolute Point
                           #--- PUSHB_2   9 9       ;PUSH Bytes
MIRP[min,black] headstem 9 ;Move Indirect Relative Point
                           #--- PUSHB_3   14 9 10   ;PUSH Bytes
CALL            10 9 14    ;CALL function
                           #--- PUSHB_4   64 14 1 9 ;PUSH Bytes
CALL            9 1 14 64  ;CALL function
                           #--- PUSHB_1   11        ;PUSH Bytes
SHP[rp2]        11         ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   15        ;PUSH Bytes
MDAP[rnd]       15         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_5   0 15 0 58 4 ;PUSH Bytes
CALL            4 58 0 15 0 ;CALL function
                           #--- PUSHB_1   0         ;PUSH Bytes
SRP0            0          ;Set Reference Point 0
                           #--- PUSHB_5   5 16 0 7 4 ;PUSH Bytes
CALL            4 7 0 16 5 ;CALL function
                           #--- PUSHB_1   5         ;PUSH Bytes
MDAP[rnd]       5          ;Move Direct Absolute Point
                           #--- PUSHB_1   0         ;PUSH Bytes
SRP0            0          ;Set Reference Point 0
                           #--- PUSHB_2   12 1      ;PUSH Bytes
CALL            1 12       ;CALL function
                           #--- PUSHB_5   11 15 0 58 4 ;PUSH Bytes
CALL            4 58 0 15 11 ;CALL function
                           #--- PUSHB_2   16 1      ;PUSH Bytes
CALL            1 16       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'parenleft': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   14        ;PUSH Bytes
MDAP[rnd]       14         ;Move Direct Absolute Point
                           #--- PUSHB_1   4         ;PUSH Bytes
MDRP[rp0,rnd,white] 4          ;Move Direct Relative Point
                           #--- PUSHB_2   11 16     ;PUSH Bytes
MIRP[min,black] estemw 11  ;Move Indirect Relative Point
                           #--- PUSHB_2   15 1      ;PUSH Bytes
CALL            1 15       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'parenright': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   16        ;PUSH Bytes
MDAP[rnd]       16         ;Move Direct Absolute Point
                           #--- PUSHB_1   5         ;PUSH Bytes
MDRP[rp0,rnd,white] 5          ;Move Direct Relative Point
                           #--- PUSHB_2   13 16     ;PUSH Bytes
MIRP[min,black] estemw 13  ;Move Indirect Relative Point
                           #--- PUSHB_2   17 1      ;PUSH Bytes
CALL            1 17       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'percent': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   47 1 0    ;PUSH Bytes
CALL            0 1 47     ;CALL function
                           #--- PUSHB_4   20 47 0 14 ;PUSH Bytes
CALL            14 0 47 20 ;CALL function
                           #--- PUSHB_2   12 8      ;PUSH Bytes
MIRP[min,black] cvt_8 12   ;Move Indirect Relative Point
                           #--- PUSHB_1   18        ;PUSH Bytes
MDAP[rnd]       18         ;Move Direct Absolute Point
                           #--- PUSHB_2   6 8       ;PUSH Bytes
MIRP[min,black] cvt_8 6    ;Move Indirect Relative Point
                           #--- PUSHB_4   25 6 18 8 ;PUSH Bytes
CALL            8 18 6 25  ;CALL function
                           #--- PUSHB_2   34 8      ;PUSH Bytes
MIRP[min,black] cvt_8 34   ;Move Indirect Relative Point
                           #--- PUSHB_1   40        ;PUSH Bytes
MDAP[rnd]       40         ;Move Direct Absolute Point
                           #--- PUSHB_2   30 8      ;PUSH Bytes
MIRP[min,black] cvt_8 30   ;Move Indirect Relative Point
                           #--- PUSHB_1   48        ;PUSH Bytes
SHP[rp2]        48         ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   50        ;PUSH Bytes
MDAP[rnd]       50         ;Move Direct Absolute Point
                           #--- PUSHB_1   27        ;PUSH Bytes
MDRP[rp0,rnd,white] 27         ;Move Direct Relative Point
                           #--- PUSHB_2   43 15     ;PUSH Bytes
MIRP[min,black] headstem_thick 43 ;Move Indirect Relative Point
                           #--- PUSHB_1   43        ;PUSH Bytes
SRP0            43         ;Set Reference Point 0
                           #--- PUSHB_2   37 1      ;PUSH Bytes
CALL            1 37       ;CALL function
                           #--- PUSHB_2   33 15     ;PUSH Bytes
MIRP[min,black] headstem_thick 33 ;Move Indirect Relative Point
                           #--- PUSHB_1   33        ;PUSH Bytes
SRP0            33         ;Set Reference Point 0
                           #--- PUSHB_2   3 1       ;PUSH Bytes
CALL            1 3        ;CALL function
                           #--- PUSHB_2   21 15     ;PUSH Bytes
MIRP[min,black] headstem_thick 21 ;Move Indirect Relative Point
                           #--- PUSHB_1   21        ;PUSH Bytes
SRP0            21         ;Set Reference Point 0
                           #--- PUSHB_2   15 1      ;PUSH Bytes
CALL            1 15       ;CALL function
                           #--- PUSHB_2   9 15      ;PUSH Bytes
MIRP[min,black] headstem_thick 9 ;Move Indirect Relative Point
                           #--- PUSHB_2   51 1      ;PUSH Bytes
CALL            1 51       ;CALL function
                           #--- PUSHB_2   37 43     ;PUSH Bytes
SRP1            43         ;Set Reference Point 1
SRP2            37         ;Set Reference Point 2
                           #--- PUSHB_4   25 24 30 47 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
IP              47 30 24 25 ;Interpolate Point
                           #--- PUSHB_1   33        ;PUSH Bytes
SRP1            33         ;Set Reference Point 1
                           #--- PUSHB_1   46        ;PUSH Bytes
IP              46         ;Interpolate Point
                           #--- PUSHB_2   21 3      ;PUSH Bytes
SRP1            3          ;Set Reference Point 1
SRP2            21         ;Set Reference Point 2
                           #--- PUSHB_1   48        ;PUSH Bytes
IP              48         ;Interpolate Point
                           #--- PUSHB_1   15        ;PUSH Bytes
SRP1            15         ;Set Reference Point 1
                           #--- PUSHB_5   6 0 12 18 49 ;PUSH Bytes
                           #--- DEPTH     #5        ;DEPTH of the stack
SLOOP           5          ;Set LOOP variable
IP              49 18 12 0 6 ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   18 12     ;PUSH Bytes
SRP1            12         ;Set Reference Point 1
SRP2            18         ;Set Reference Point 2
                           #--- PUSHB_4   3 9 15 21 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
IP              21 15 9 3  ;Interpolate Point
                           #--- PUSHB_2   40 34     ;PUSH Bytes
SRP1            34         ;Set Reference Point 1
SRP2            40         ;Set Reference Point 2
                           #--- PUSHB_2   33 27     ;PUSH Bytes
IP              27         ;Interpolate Point
IP              33         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'period': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_5   2 14 0 30 4 ;PUSH Bytes
CALL            4 30 0 14 2 ;CALL function
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_5   2 14 0 30 4 ;PUSH Bytes
CALL            4 30 0 14 2 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_5   0 16 0 30 4 ;PUSH Bytes
CALL            4 30 0 16 0 ;CALL function
                           #--- PUSHB_5   0 16 0 30 4 ;PUSH Bytes
CALL            4 30 0 16 0 ;CALL function
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'periodcentered': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_5   2 14 0 15 4 ;PUSH Bytes
CALL            4 15 0 14 2 ;CALL function
                           #--- PUSHB_5   2 14 0 15 4 ;PUSH Bytes
CALL            4 15 0 14 2 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_5   0 16 0 18 4 ;PUSH Bytes
CALL            4 18 0 16 0 ;CALL function
                           #--- PUSHB_5   0 16 0 18 4 ;PUSH Bytes
CALL            4 18 0 16 0 ;CALL function
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'perthousand': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   13 1 0    ;PUSH Bytes
CALL            0 1 13     ;CALL function
                           #--- PUSHB_4   20 13 16 14 ;PUSH Bytes
CALL            14 16 13 20 ;CALL function
                           #--- PUSHB_1   51        ;PUSH Bytes
SHP[rp1]        51         ;SHift Point using reference point
                           #--- PUSHB_2   39 9      ;PUSH Bytes
MIRP[min,black] headstem 39 ;Move Indirect Relative Point
                           #--- PUSHB_1   63        ;PUSH Bytes
SHP[rp2]        63         ;SHift Point using reference point
                           #--- PUSHB_1   45        ;PUSH Bytes
MDAP[rnd]       45         ;Move Direct Absolute Point
                           #--- PUSHB_1   69        ;PUSH Bytes
SHP[rp1]        69         ;SHift Point using reference point
                           #--- PUSHB_2   22 9      ;PUSH Bytes
MIRP[min,black] headstem 22 ;Move Indirect Relative Point
                           #--- PUSHB_1   57        ;PUSH Bytes
SHP[rp2]        57         ;SHift Point using reference point
                           #--- PUSHB_4   28 22 45 8 ;PUSH Bytes
CALL            8 45 22 28 ;CALL function
                           #--- PUSHB_2   0 9       ;PUSH Bytes
MIRP[min,black] headstem 0 ;Move Indirect Relative Point
                           #--- PUSHB_1   34        ;PUSH Bytes
MDAP[rnd]       34         ;Move Direct Absolute Point
                           #--- PUSHB_2   6 9       ;PUSH Bytes
MIRP[min,black] headstem 6 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   75        ;PUSH Bytes
MDAP[rnd]       75         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   37 16     ;PUSH Bytes
MIRP[min,black] estemw 37  ;Move Indirect Relative Point
                           #--- PUSHB_1   37        ;PUSH Bytes
SRP0            37         ;Set Reference Point 0
                           #--- PUSHB_2   31 1      ;PUSH Bytes
CALL            1 31       ;CALL function
                           #--- PUSHB_2   9 16      ;PUSH Bytes
MIRP[min,black] estemw 9   ;Move Indirect Relative Point
                           #--- PUSHB_1   9         ;PUSH Bytes
SRP0            9          ;Set Reference Point 0
                           #--- PUSHB_2   19 1      ;PUSH Bytes
CALL            1 19       ;CALL function
                           #--- PUSHB_2   48 16     ;PUSH Bytes
MIRP[min,black] estemw 48  ;Move Indirect Relative Point
                           #--- PUSHB_1   48        ;PUSH Bytes
SRP0            48         ;Set Reference Point 0
                           #--- PUSHB_2   42 1      ;PUSH Bytes
CALL            1 42       ;CALL function
                           #--- PUSHB_2   25 16     ;PUSH Bytes
MIRP[min,black] estemw 25  ;Move Indirect Relative Point
                           #--- PUSHB_1   25        ;PUSH Bytes
SRP0            25         ;Set Reference Point 0
                           #--- PUSHB_2   54 1      ;PUSH Bytes
CALL            1 54       ;CALL function
                           #--- PUSHB_2   72 16     ;PUSH Bytes
MIRP[min,black] estemw 72  ;Move Indirect Relative Point
                           #--- PUSHB_1   72        ;PUSH Bytes
SRP0            72         ;Set Reference Point 0
                           #--- PUSHB_2   66 1      ;PUSH Bytes
CALL            1 66       ;CALL function
                           #--- PUSHB_2   60 16     ;PUSH Bytes
MIRP[min,black] estemw 60  ;Move Indirect Relative Point
                           #--- PUSHB_2   76 1      ;PUSH Bytes
CALL            1 76       ;CALL function
                           #--- PUSHB_2   31 37     ;PUSH Bytes
SRP1            37         ;Set Reference Point 1
SRP2            31         ;Set Reference Point 2
                           #--- PUSHB_2   0 13      ;PUSH Bytes
IP              13         ;Interpolate Point
IP              0          ;Interpolate Point
                           #--- PUSHB_1   9         ;PUSH Bytes
SRP1            9          ;Set Reference Point 1
                           #--- PUSHB_1   12        ;PUSH Bytes
IP              12         ;Interpolate Point
                           #--- PUSHB_2   48 19     ;PUSH Bytes
SRP1            19         ;Set Reference Point 1
SRP2            48         ;Set Reference Point 2
                           #--- PUSHB_1   14        ;PUSH Bytes
IP              14         ;Interpolate Point
                           #--- PUSHB_1   42        ;PUSH Bytes
SRP1            42         ;Set Reference Point 1
                           #--- PUSHB_3   16 22 15  ;PUSH Bytes
IP              15         ;Interpolate Point
IP              22         ;Interpolate Point
IP              16         ;Interpolate Point
                           #--- PUSHB_2   66 72     ;PUSH Bytes
SRP1            72         ;Set Reference Point 1
SRP2            66         ;Set Reference Point 2
                           #--- PUSHB_2   57 51     ;PUSH Bytes
IP              51         ;Interpolate Point
IP              57         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   0 39      ;PUSH Bytes
SRP1            39         ;Set Reference Point 1
SRP2            0          ;Set Reference Point 2
                           #--- PUSHB_6   19 48 54 60 66 72 ;PUSH Bytes
                           #--- DEPTH     #6        ;DEPTH of the stack
SLOOP           6          ;Set LOOP variable
IP              72 66 60 54 48 19 ;Interpolate Point
                           #--- PUSHB_2   34 22     ;PUSH Bytes
SRP1            22         ;Set Reference Point 1
SRP2            34         ;Set Reference Point 2
                           #--- PUSHB_4   3 9 31 37 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
IP              37 31 9 3  ;Interpolate Point
                           #--- PUSHB_1   6         ;PUSH Bytes
SRP1            6          ;Set Reference Point 1
                           #--- PUSHB_2   14 15     ;PUSH Bytes
IP              15         ;Interpolate Point
IP              14         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'plus': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   3         ;PUSH Bytes
MDAP[rnd]       3          ;Move Direct Absolute Point
                           #--- PUSHB_1   10        ;PUSH Bytes
SHP[rp1]        10         ;SHift Point using reference point
                           #--- PUSHB_2   4 12      ;PUSH Bytes
MIRP[min,black] cvt_12 4   ;Move Indirect Relative Point
                           #--- PUSHB_1   8         ;PUSH Bytes
SHP[rp2]        8          ;SHift Point using reference point
                           #--- PUSHB_3   3 4 10    ;PUSH Bytes
CALL            10 4 3     ;CALL function
                           #--- PUSHB_4   64 3 1 9  ;PUSH Bytes
CALL            9 1 3 64   ;CALL function
                           #--- PUSHB_3   4 3 10    ;PUSH Bytes
CALL            10 3 4     ;CALL function
                           #--- PUSHB_4   64 4 6 9  ;PUSH Bytes
CALL            9 6 4 64   ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   12        ;PUSH Bytes
MDAP[rnd]       12         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_1   5         ;PUSH Bytes
SHP[rp2]        5          ;SHift Point using reference point
                           #--- PUSHB_2   0 15      ;PUSH Bytes
MIRP[min,black] headstem_thick 0 ;Move Indirect Relative Point
                           #--- PUSHB_1   7         ;PUSH Bytes
SHP[rp2]        7          ;SHift Point using reference point
                           #--- PUSHB_3   0 1 10    ;PUSH Bytes
CALL            10 1 0     ;CALL function
                           #--- PUSHB_4   64 0 10 9 ;PUSH Bytes
CALL            9 10 0 64  ;CALL function
                           #--- PUSHB_3   1 0 10    ;PUSH Bytes
CALL            10 0 1     ;CALL function
                           #--- PUSHB_4   64 1 3 9  ;PUSH Bytes
CALL            9 3 1 64   ;CALL function
                           #--- PUSHB_2   13 1      ;PUSH Bytes
CALL            1 13       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'plusminus': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   2 6       ;PUSH Bytes
MIRP[min,black] estemtc 2  ;Move Indirect Relative Point
                           #--- PUSHB_1   14        ;PUSH Bytes
SHP[rp2]        14         ;SHift Point using reference point
                           #--- PUSHB_1   5         ;PUSH Bytes
MDAP[rnd]       5          ;Move Direct Absolute Point
                           #--- PUSHB_1   12        ;PUSH Bytes
SHP[rp1]        12         ;SHift Point using reference point
                           #--- PUSHB_2   6 6       ;PUSH Bytes
MIRP[min,black] estemtc 6  ;Move Indirect Relative Point
                           #--- PUSHB_1   10        ;PUSH Bytes
SHP[rp2]        10         ;SHift Point using reference point
                           #--- PUSHB_3   6 5 10    ;PUSH Bytes
CALL            10 5 6     ;CALL function
                           #--- PUSHB_4   64 6 8 9  ;PUSH Bytes
CALL            9 8 6 64   ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   16        ;PUSH Bytes
MDAP[rnd]       16         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_1   7         ;PUSH Bytes
SHP[rp2]        7          ;SHift Point using reference point
                           #--- PUSHB_2   14 15     ;PUSH Bytes
MIRP[min,black] headstem_thick 14 ;Move Indirect Relative Point
                           #--- PUSHB_1   9         ;PUSH Bytes
SHP[rp2]        9          ;SHift Point using reference point
                           #--- PUSHB_3   14 3 10   ;PUSH Bytes
CALL            10 3 14    ;CALL function
                           #--- PUSHB_4   64 14 0 9 ;PUSH Bytes
CALL            9 0 14 64  ;CALL function
                           #--- PUSHB_1   11        ;PUSH Bytes
SHP[rp2]        11         ;SHift Point using reference point
                           #--- PUSHB_3   3 14 10   ;PUSH Bytes
CALL            10 14 3    ;CALL function
                           #--- PUSHB_4   64 3 1 9  ;PUSH Bytes
CALL            9 1 3 64   ;CALL function
                           #--- PUSHB_1   5         ;PUSH Bytes
SHP[rp2]        5          ;SHift Point using reference point
                           #--- PUSHB_2   17 1      ;PUSH Bytes
CALL            1 17       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'q': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   5 1 0     ;PUSH Bytes
CALL            0 1 5      ;CALL function
                           #--- PUSHB_2   17 6      ;PUSH Bytes
MIRP[min,black] estemtc 17 ;Move Indirect Relative Point
                           #--- PUSHB_3   1 0 0     ;PUSH Bytes
CALL            0 0 1      ;CALL function
                           #--- PUSHB_3   15 3 0    ;PUSH Bytes
CALL            0 3 15     ;CALL function
                           #--- PUSHB_3   11 3 0    ;PUSH Bytes
CALL            0 3 11     ;CALL function
                           #--- PUSHB_2   23 6      ;PUSH Bytes
MIRP[min,black] estemtc 23 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   29        ;PUSH Bytes
MDAP[rnd]       29         ;Move Direct Absolute Point
                           #--- PUSHB_1   8         ;PUSH Bytes
MDRP[rp0,rnd,white] 8          ;Move Direct Relative Point
                           #--- PUSHB_2   26 16     ;PUSH Bytes
MIRP[min,black] estemw 26  ;Move Indirect Relative Point
                           #--- PUSHB_1   26        ;PUSH Bytes
#SRP0            26         ;Set Reference Point 0
#                           #--- PUSHB_2   1 1       ;PUSH Bytes
#CALL            1 1        ;CALL function
#                           #--- PUSHB_2   14 20     ;PUSH Bytes
#SHP[rp2]        20         ;SHift Point using reference point
#SHP[rp2]        14         ;SHift Point using reference point
#                           #--- PUSHB_2   0 16      ;PUSH Bytes
#MIRP[min,black] estemw 0   ;Move Indirect Relative Point
#                           #--- PUSHB_2   30 1      ;PUSH Bytes
#CALL            1 30       ;CALL function
grx(30,0,1)
alignrp 20
alignrp 14
                           #--- PUSHB_2   1 26      ;PUSH Bytes
SRP1            26         ;Set Reference Point 1
SRP2            1          ;Set Reference Point 2
                           #--- PUSHB_2   5 11      ;PUSH Bytes
IP              11         ;Interpolate Point
IP              5          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   17 5      ;PUSH Bytes
SRP1            5          ;Set Reference Point 1
SRP2            17         ;Set Reference Point 2
                           #--- PUSHB_1   2         ;PUSH Bytes
IP              2          ;Interpolate Point
                           #--- PUSHB_1   23        ;PUSH Bytes
SRP1            23         ;Set Reference Point 1
                           #--- PUSHB_2   8 14      ;PUSH Bytes
IP              14         ;Interpolate Point
IP              8          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'quotedbl': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   3 5 0     ;PUSH Bytes
CALL            0 5 3      ;CALL function
                           #--- PUSHB_1   9         ;PUSH Bytes
SHP[rp1]        9          ;SHift Point using reference point
                           #--- PUSHB_5   1 14 0 9 4 ;PUSH Bytes
CALL            4 9 0 14 1 ;CALL function
                           #--- PUSHB_1   6         ;PUSH Bytes
SHP[rp2]        6          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   12        ;PUSH Bytes
MDAP[rnd]       12         ;Move Direct Absolute Point
                           #--- PUSHB_1   2         ;PUSH Bytes
MDRP[rp0,rnd,white] 2          ;Move Direct Relative Point
                           #--- PUSHB_2   5 16      ;PUSH Bytes
MIRP[min,black] estemw 5   ;Move Indirect Relative Point
                           #--- PUSHB_4   0 5 2 8   ;PUSH Bytes
CALL            8 2 5 0    ;CALL function
                           #--- PUSHB_5   1 15 0 20 4 ;PUSH Bytes
CALL            4 20 0 15 1 ;CALL function
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_5   0 15 0 20 4 ;PUSH Bytes
CALL            4 20 0 15 0 ;CALL function
                           #--- PUSHB_1   5         ;PUSH Bytes
SRP0            5          ;Set Reference Point 0
                           #--- PUSHB_2   8 1       ;PUSH Bytes
CALL            1 8        ;CALL function
                           #--- PUSHB_2   11 16     ;PUSH Bytes
MIRP[min,black] estemw 11  ;Move Indirect Relative Point
                           #--- PUSHB_4   6 11 8 8  ;PUSH Bytes
CALL            8 8 11 6   ;CALL function
                           #--- PUSHB_5   7 15 0 20 4 ;PUSH Bytes
CALL            4 20 0 15 7 ;CALL function
                           #--- PUSHB_1   7         ;PUSH Bytes
MDAP[rnd]       7          ;Move Direct Absolute Point
                           #--- PUSHB_5   6 15 0 20 4 ;PUSH Bytes
CALL            4 20 0 15 6 ;CALL function
                           #--- PUSHB_2   13 1      ;PUSH Bytes
CALL            1 13       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'quotedblbase': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   6         ;PUSH Bytes
MDAP[rnd]       6          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
SHP[rp1]        1          ;SHift Point using reference point
                           #--- PUSHB_5   7 14 0 8 4 ;PUSH Bytes
CALL            4 8 0 14 7 ;CALL function
                           #--- PUSHB_1   3         ;PUSH Bytes
SHP[rp2]        3          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   7 6       ;PUSH Bytes
SRP1            6          ;Set Reference Point 1
SRP2            7          ;Set Reference Point 2
                           #--- PUSHB_1   0         ;PUSH Bytes
IP              0          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'quotedblleft': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   5         ;PUSH Bytes
MDAP[rnd]       5          ;Move Direct Absolute Point
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp1]        0          ;SHift Point using reference point
                           #--- PUSHB_5   7 14 0 8 4 ;PUSH Bytes
CALL            4 8 0 14 7 ;CALL function
                           #--- PUSHB_1   2         ;PUSH Bytes
SHP[rp2]        2          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   7 5       ;PUSH Bytes
SRP1            5          ;Set Reference Point 1
SRP2            7          ;Set Reference Point 2
                           #--- PUSHB_1   6         ;PUSH Bytes
IP              6          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'quotedblright': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   6         ;PUSH Bytes
MDAP[rnd]       6          ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
SHP[rp1]        1          ;SHift Point using reference point
                           #--- PUSHB_5   7 14 0 8 4 ;PUSH Bytes
CALL            4 8 0 14 7 ;CALL function
                           #--- PUSHB_1   3         ;PUSH Bytes
SHP[rp2]        3          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   7 6       ;PUSH Bytes
SRP1            6          ;Set Reference Point 1
SRP2            7          ;Set Reference Point 2
                           #--- PUSHB_1   0         ;PUSH Bytes
IP              0          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'quoteleft': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_5   3 14 0 8 4 ;PUSH Bytes
CALL            4 8 0 14 3 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   2         ;PUSH Bytes
MDRP[rp0,rnd,white] 2          ;Move Direct Relative Point
                           #--- PUSHB_5   0 16 0 11 4 ;PUSH Bytes
CALL            4 11 0 16 0 ;CALL function
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   3 1       ;PUSH Bytes
SRP1            1          ;Set Reference Point 1
SRP2            3          ;Set Reference Point 2
                           #--- PUSHB_1   2         ;PUSH Bytes
IP              2          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'quotereversed': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   2         ;PUSH Bytes
MDAP[rnd]       2          ;Move Direct Absolute Point
                           #--- PUSHB_5   3 14 0 8 4 ;PUSH Bytes
CALL            4 8 0 14 3 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   2         ;PUSH Bytes
MDRP[rp0,rnd,white] 2          ;Move Direct Relative Point
                           #--- PUSHB_5   0 16 0 11 4 ;PUSH Bytes
CALL            4 11 0 16 0 ;CALL function
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   3 2       ;PUSH Bytes
SRP1            2          ;Set Reference Point 1
SRP2            3          ;Set Reference Point 2
                           #--- PUSHB_1   0         ;PUSH Bytes
IP              0          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'quoteright': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   2         ;PUSH Bytes
MDAP[rnd]       2          ;Move Direct Absolute Point
                           #--- PUSHB_5   3 14 0 8 4 ;PUSH Bytes
CALL            4 8 0 14 3 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   2         ;PUSH Bytes
MDRP[rp0,rnd,white] 2          ;Move Direct Relative Point
                           #--- PUSHB_5   0 16 0 11 4 ;PUSH Bytes
CALL            4 11 0 16 0 ;CALL function
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   3 2       ;PUSH Bytes
SRP1            2          ;Set Reference Point 1
SRP2            3          ;Set Reference Point 2
                           #--- PUSHB_1   0         ;PUSH Bytes
IP              0          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'quotesinglbase': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   2         ;PUSH Bytes
MDAP[rnd]       2          ;Move Direct Absolute Point
                           #--- PUSHB_5   3 14 0 8 4 ;PUSH Bytes
CALL            4 8 0 14 3 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_1   2         ;PUSH Bytes
MDRP[rp0,rnd,white] 2          ;Move Direct Relative Point
                           #--- PUSHB_5   0 16 0 11 4 ;PUSH Bytes
CALL            4 11 0 16 0 ;CALL function
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   3 2       ;PUSH Bytes
SRP1            2          ;Set Reference Point 1
SRP2            3          ;Set Reference Point 2
                           #--- PUSHB_1   0         ;PUSH Bytes
IP              0          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'quotesingle': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   3 5 0     ;PUSH Bytes
CALL            0 5 3      ;CALL function
                           #--- PUSHB_5   1 14 0 8 4 ;PUSH Bytes
CALL            4 8 0 14 1 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   6         ;PUSH Bytes
MDAP[rnd]       6          ;Move Direct Absolute Point
                           #--- PUSHB_1   2         ;PUSH Bytes
MDRP[rp0,rnd,white] 2          ;Move Direct Relative Point
                           #--- PUSHB_5   5 16 0 30 4 ;PUSH Bytes
CALL            4 30 0 16 5 ;CALL function
                           #--- PUSHB_5   5 16 0 30 4 ;PUSH Bytes
CALL            4 30 0 16 5 ;CALL function
                           #--- PUSHB_4   1 5 2 8   ;PUSH Bytes
CALL            8 2 5 1    ;CALL function
                           #--- PUSHB_5   0 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 0 ;CALL function
                           #--- PUSHB_2   7 1       ;PUSH Bytes
CALL            1 7        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'r': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   2 3 0     ;PUSH Bytes
CALL            0 3 2      ;CALL function
                           #--- PUSHB_3   7 3 0     ;PUSH Bytes
CALL            0 3 7      ;CALL function
                           #--- PUSHB_2   12 6      ;PUSH Bytes
MIRP[min,black] estemtc 12 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   16        ;PUSH Bytes
MDAP[rnd]       16         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
gf_148(1)
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_1   3         ;PUSH Bytes
SHP[rp2]        3          ;SHift Point using reference point
                           #--- PUSHB_2   17 1      ;PUSH Bytes
CALL            1 17       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   12 1      ;PUSH Bytes
SRP1            1          ;Set Reference Point 1
SRP2            12         ;Set Reference Point 2
                           #--- PUSHB_1   10        ;PUSH Bytes
IP              10         ;Interpolate Point
                           #--- PUSHB_1   2         ;PUSH Bytes
SRP1            2          ;Set Reference Point 1
                           #--- PUSHB_2   4 9       ;PUSH Bytes
IP              9          ;Interpolate Point
IP              4          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    's': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   7 6       ;PUSH Bytes
MIRP[min,black] estemtc 7  ;Move Indirect Relative Point
                           #--- PUSHB_3   7 0 10    ;PUSH Bytes
CALL            10 0 7     ;CALL function
                           #--- PUSHB_4   64 7 3 9  ;PUSH Bytes
CALL            9 3 7 64   ;CALL function
                           #--- PUSHB_3   18 3 0    ;PUSH Bytes
CALL            0 3 18     ;CALL function
                           #--- PUSHB_2   25 6      ;PUSH Bytes
MIRP[min,black] estemtc 25 ;Move Indirect Relative Point
                           #--- PUSHB_3   25 18 10  ;PUSH Bytes
CALL            10 18 25   ;CALL function
                           #--- PUSHB_4   64 25 21 9 ;PUSH Bytes
CALL            9 21 25 64 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   36        ;PUSH Bytes
MDAP[rnd]       36         ;Move Direct Absolute Point
                           #--- PUSHB_1   15        ;PUSH Bytes
mdrp[rp0,rnd,white] 3
mirp[min,black] estemw 4
mdrp[rp0,rnd,white] 15
mirp[min,black] estemw 28
#MDRP[rp0,rnd,white] 15         ;Move Direct Relative Point
#                           #--- PUSHB_2   28 16     ;PUSH Bytes
#MIRP[min,black] estemw 28  ;Move Indirect Relative Point
#                           #--- PUSHB_1   3         ;PUSH Bytes
#DUP             3          ;DUPlicate top stack element
#MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
#SRP1            &_DUP_2    ;Set Reference Point 1
#                           #--- PUSHB_2   4 16      ;PUSH Bytes
#MIRP[min,black] estemw 4   ;Move Indirect Relative Point
#                           #--- PUSHB_1   28        ;PUSH Bytes
#SRP0            28         ;Set Reference Point 0
#                           #--- PUSHB_2   10 1      ;PUSH Bytes
#CALL            1 10       ;CALL function
#                           #--- PUSHB_2   33 16     ;PUSH Bytes
#MIRP[min,black] estemw 33  ;Move Indirect Relative Point
#                           #--- PUSHB_1   22        ;PUSH Bytes
#DUP             22         ;DUPlicate top stack element
#MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
#SRP1            &_DUP_2    ;Set Reference Point 1
#                           #--- PUSHB_2   21 16     ;PUSH Bytes
#MIRP[min,black] estemw 21  ;Move Indirect Relative Point
#                           #--- PUSHB_2   37 1      ;PUSH Bytes
#CALL            1 37       ;CALL function
grx(37,33,10)
mdrp[rp0,rnd,white] 22
mirp[min,black] estemw 21
#                           #--- PUSHB_1   54        ;PUSH Bytes
#SMD             54         ;Set Minimum Distance
#                           #--- PUSHB_2   14 11     ;PUSH Bytes
#SDPVTL[orthog]  11 14      ;Set Dual Projection Vector To Line
#                           #--- PUSHB_1   14        ;PUSH Bytes
#MDAP[no-rnd]    14         ;Move Direct Absolute Point
#                           #--- PUSHB_1   11        ;PUSH Bytes
#MDRP[grey]      11         ;Move Direct Relative Point
#                           #--- PUSHB_2   29 12     ;PUSH Bytes
#MIRP[rp0,min,black] cvt_12 29  ;Move Indirect Relative Point
#                           #--- PUSHB_1   32        ;PUSH Bytes
#MDRP[grey]      32         ;Move Direct Relative Point
#                           #--- PUSHB_1   14        ;PUSH Bytes
#SRP0            14         ;Set Reference Point 0
#                           #--- PUSHB_4   12 14 11 19 ;PUSH Bytes
#CALL            19 11 14 12 ;CALL function
#                           #--- PUSHB_4   13 14 11 19 ;PUSH Bytes
#CALL            19 11 14 13 ;CALL function
#                           #--- PUSHB_1   29        ;PUSH Bytes
#SRP0            29         ;Set Reference Point 0
#                           #--- PUSHB_4   30 29 32 19 ;PUSH Bytes
#CALL            19 32 29 30 ;CALL function
#                           #--- PUSHB_4   31 29 32 19 ;PUSH Bytes
#CALL            19 32 29 31 ;CALL function
#                           #--- PUSHB_3   30 29 32  ;PUSH Bytes
#DUP             32         ;DUPlicate top stack element
#ROLL            &_DUP_1 &_DUP_2 29 ;ROLL the top three stack elements
#DUP             &_ROLL_1   ;DUPlicate top stack element
#ROLL            &_DUP_1 &_DUP_2 &_ROLL_2 ;ROLL the top three stack elements
#SWAP            &_ROLL_1 &_ROLL_2 ;SWAP the top two elements on the stack
#SPVTL[parallel] &_SWAP_1 &_SWAP_2 ;Set Projection Vector To Line
#SFVTPV                     ;Set Freedom Vector To Projection Vector
#SRP1            &_ROLL_3   ;Set Reference Point 1
#SRP2            &_ROLL_3   ;Set Reference Point 2
#IP              30         ;Interpolate Point
#                           #--- PUSHB_1   31        ;PUSH Bytes
#IP              31         ;Interpolate Point
#                           #--- PUSHB_3   13 14 11  ;PUSH Bytes
#SRP1            11         ;Set Reference Point 1
#SRP2            14         ;Set Reference Point 2
#IP              13         ;Interpolate Point
#                           #--- PUSHB_1   12        ;PUSH Bytes
#IP              12         ;Interpolate Point
srp1    38
srp2    33
ip  30
ip  31
srp1    15
srp2    10
ip  13
ip  12
#SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
#                           #--- PUSHB_4   12 13 30 31 ;PUSH Bytes
#MDAP[no-rnd]    31         ;Move Direct Absolute Point
#MDAP[no-rnd]    30         ;Move Direct Absolute Point
#MDAP[no-rnd]    13         ;Move Direct Absolute Point
#MDAP[no-rnd]    12         ;Move Direct Absolute Point
#SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
#                           #--- PUSHB_4   12 13 30 31 ;PUSH Bytes
#MDAP[no-rnd]    31         ;Move Direct Absolute Point
#MDAP[no-rnd]    30         ;Move Direct Absolute Point
#MDAP[no-rnd]    13         ;Move Direct Absolute Point
#MDAP[no-rnd]    12         ;Move Direct Absolute Point
#                           #--- PUSHB_1   64        ;PUSH Bytes
#SMD             64         ;Set Minimum Distance
#SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
#                           #--- PUSHB_2   15 3      ;PUSH Bytes
#SRP1            3          ;Set Reference Point 1
#SRP2            15         ;Set Reference Point 2
#                           #--- PUSHB_1   2         ;PUSH Bytes
#IP              2          ;Interpolate Point
#                           #--- PUSHB_2   22 28     ;PUSH Bytes
#SRP1            28         ;Set Reference Point 1
#SRP2            22         ;Set Reference Point 2
#                           #--- PUSHB_3   0 7 18    ;PUSH Bytes
#IP              18         ;Interpolate Point
#IP              7          ;Interpolate Point
#IP              0          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   25 7      ;PUSH Bytes
#SRP1            7          ;Set Reference Point 1
#SRP2            25         ;Set Reference Point 2
#                           #--- PUSHB_2   15 33     ;PUSH Bytes
#IP              33         ;Interpolate Point
#IP              15         ;Interpolate Point
srp1    18
srp2    0
ip  12
srp0    12
mirp[min,grey]  estemtc 30
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'second': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   2         ;PUSH Bytes
MDAP[rnd]       2          ;Move Direct Absolute Point
                           #--- PUSHB_1   5         ;PUSH Bytes
SHP[rp1]        5          ;SHift Point using reference point
                           #--- PUSHB_5   3 14 0 7 4 ;PUSH Bytes
CALL            4 7 0 14 3 ;CALL function
                           #--- PUSHB_1   7         ;PUSH Bytes
SHP[rp2]        7          ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   3 2       ;PUSH Bytes
SRP1            2          ;Set Reference Point 1
SRP2            3          ;Set Reference Point 2
                           #--- PUSHB_1   4         ;PUSH Bytes
IP              4          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'section': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   14        ;PUSH Bytes
MDAP[rnd]       14         ;Move Direct Absolute Point
                           #--- PUSHB_2   22 11     ;PUSH Bytes
MIRP[min,black] cvt_11 22  ;Move Indirect Relative Point
                           #--- PUSHB_3   22 14 10  ;PUSH Bytes
CALL            10 14 22   ;CALL function
                           #--- PUSHB_4   64 22 19 9 ;PUSH Bytes
CALL            9 19 22 64 ;CALL function
                           #--- PUSHB_1   50        ;PUSH Bytes
MDAP[rnd]       50         ;Move Direct Absolute Point
                           #--- PUSHB_2   42 11     ;PUSH Bytes
MIRP[min,black] cvt_11 42  ;Move Indirect Relative Point
                           #--- PUSHB_3   50 42 10  ;PUSH Bytes
CALL            10 42 50   ;CALL function
                           #--- PUSHB_4   64 50 47 9 ;PUSH Bytes
CALL            9 47 50 64 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   70        ;PUSH Bytes
MDAP[rnd]       70         ;Move Direct Absolute Point
                           #--- PUSHB_1   32        ;PUSH Bytes
MDRP[rp0,rnd,white] 32         ;Move Direct Relative Point
                           #--- PUSHB_2   10 16     ;PUSH Bytes
MIRP[min,black] estemw 10  ;Move Indirect Relative Point
                           #--- PUSHB_1   39        ;PUSH Bytes
DUP             39         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   53 16     ;PUSH Bytes
MIRP[min,black] estemw 53  ;Move Indirect Relative Point
                           #--- PUSHB_1   10        ;PUSH Bytes
SRP0            10         ;Set Reference Point 0
                           #--- PUSHB_2   3 1       ;PUSH Bytes
CALL            1 3        ;CALL function
                           #--- PUSHB_2   60 16     ;PUSH Bytes
MIRP[min,black] estemw 60  ;Move Indirect Relative Point
                           #--- PUSHB_1   60        ;PUSH Bytes
SRP0            60         ;Set Reference Point 0
                           #--- PUSHB_1   67        ;PUSH Bytes
DUP             67         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   25 16     ;PUSH Bytes
MIRP[min,black] estemw 25  ;Move Indirect Relative Point
                           #--- PUSHB_1   25        ;PUSH Bytes
MDAP[rnd]       25         ;Move Direct Absolute Point
                           #--- PUSHB_2   67 16     ;PUSH Bytes
MIRP[min,black] estemw 67  ;Move Indirect Relative Point
                           #--- PUSHB_2   71 1      ;PUSH Bytes
CALL            1 71       ;CALL function
                           #--- PUSHB_1   54        ;PUSH Bytes
SMD             54         ;Set Minimum Distance
                           #--- PUSHB_2   30 28     ;PUSH Bytes
SDPVTL[orthog]  28 30      ;Set Dual Projection Vector To Line
                           #--- PUSHB_1   30        ;PUSH Bytes
MDAP[no-rnd]    30         ;Move Direct Absolute Point
                           #--- PUSHB_1   28        ;PUSH Bytes
MDRP[grey]      28         ;Move Direct Relative Point
                           #--- PUSHB_2   13 17     ;PUSH Bytes
MIRP[rp0,min,black] cvt_17 13  ;Move Indirect Relative Point
                           #--- PUSHB_1   0         ;PUSH Bytes
MDRP[grey]      0          ;Move Direct Relative Point
                           #--- PUSHB_2   7 6       ;PUSH Bytes
SDPVTL[orthog]  6 7        ;Set Dual Projection Vector To Line
                           #--- PUSHB_1   7         ;PUSH Bytes
MDAP[no-rnd]    7          ;Move Direct Absolute Point
                           #--- PUSHB_1   6         ;PUSH Bytes
MDRP[grey]      6          ;Move Direct Relative Point
                           #--- PUSHB_2   56 13     ;PUSH Bytes
MIRP[rp0,min,black] ecstemt 56 ;Move Indirect Relative Point
                           #--- PUSHB_1   58        ;PUSH Bytes
MDRP[grey]      58         ;Move Direct Relative Point
                           #--- PUSHB_1   30        ;PUSH Bytes
SRP0            30         ;Set Reference Point 0
                           #--- PUSHB_4   29 30 28 19 ;PUSH Bytes
CALL            19 28 30 29 ;CALL function
                           #--- PUSHB_1   56        ;PUSH Bytes
SRP0            56         ;Set Reference Point 0
                           #--- PUSHB_4   57 56 58 19 ;PUSH Bytes
CALL            19 58 56 57 ;CALL function
                           #--- PUSHB_3   29 30 28  ;PUSH Bytes
DUP             28         ;DUPlicate top stack element
ROLL            &_DUP_1 &_DUP_2 30 ;ROLL the top three stack elements
DUP             &_ROLL_1   ;DUPlicate top stack element
ROLL            &_DUP_1 &_DUP_2 &_ROLL_2 ;ROLL the top three stack elements
SWAP            &_ROLL_1 &_ROLL_2 ;SWAP the top two elements on the stack
SPVTL[parallel] &_SWAP_1 &_SWAP_2 ;Set Projection Vector To Line
SFVTPV                     ;Set Freedom Vector To Projection Vector
SRP1            &_ROLL_3   ;Set Reference Point 1
SRP2            &_ROLL_3   ;Set Reference Point 2
IP              29         ;Interpolate Point
                           #--- PUSHB_3   57 56 58  ;PUSH Bytes
SRP1            58         ;Set Reference Point 1
SRP2            56         ;Set Reference Point 2
IP              57         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_8   0 6 7 13 28 29 56 57 ;PUSH Bytes
MDAP[no-rnd]    57         ;Move Direct Absolute Point
MDAP[no-rnd]    56         ;Move Direct Absolute Point
MDAP[no-rnd]    29         ;Move Direct Absolute Point
MDAP[no-rnd]    28         ;Move Direct Absolute Point
MDAP[no-rnd]    13         ;Move Direct Absolute Point
MDAP[no-rnd]    7          ;Move Direct Absolute Point
MDAP[no-rnd]    6          ;Move Direct Absolute Point
MDAP[no-rnd]    0          ;Move Direct Absolute Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_8   0 6 7 13 28 29 56 57 ;PUSH Bytes
MDAP[no-rnd]    57         ;Move Direct Absolute Point
MDAP[no-rnd]    56         ;Move Direct Absolute Point
MDAP[no-rnd]    29         ;Move Direct Absolute Point
MDAP[no-rnd]    28         ;Move Direct Absolute Point
MDAP[no-rnd]    13         ;Move Direct Absolute Point
MDAP[no-rnd]    7          ;Move Direct Absolute Point
MDAP[no-rnd]    6          ;Move Direct Absolute Point
MDAP[no-rnd]    0          ;Move Direct Absolute Point
                           #--- PUSHB_1   64        ;PUSH Bytes
SMD             64         ;Set Minimum Distance
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   10 39     ;PUSH Bytes
SRP1            39         ;Set Reference Point 1
SRP2            10         ;Set Reference Point 2
                           #--- PUSHB_2   17 19     ;PUSH Bytes
IP              19         ;Interpolate Point
IP              17         ;Interpolate Point
                           #--- PUSHB_1   53        ;PUSH Bytes
SRP1            53         ;Set Reference Point 1
                           #--- PUSHB_2   35 36     ;PUSH Bytes
IP              36         ;Interpolate Point
IP              35         ;Interpolate Point
                           #--- PUSHB_1   25        ;PUSH Bytes
SRP2            25         ;Set Reference Point 2
                           #--- PUSHB_2   42 50     ;PUSH Bytes
IP              50         ;Interpolate Point
IP              42         ;Interpolate Point
                           #--- PUSHB_1   3         ;PUSH Bytes
SRP1            3          ;Set Reference Point 1
                           #--- PUSHB_2   63 64     ;PUSH Bytes
IP              64         ;Interpolate Point
IP              63         ;Interpolate Point
                           #--- PUSHB_1   67        ;PUSH Bytes
SRP2            67         ;Set Reference Point 2
                           #--- PUSHB_2   45 47     ;PUSH Bytes
IP              47         ;Interpolate Point
IP              45         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   22 14     ;PUSH Bytes
SRP1            14         ;Set Reference Point 1
SRP2            22         ;Set Reference Point 2
                           #--- PUSHB_1   17        ;PUSH Bytes
IP              17         ;Interpolate Point
                           #--- PUSHB_1   50        ;PUSH Bytes
SRP1            50         ;Set Reference Point 1
                           #--- PUSHB_2   36 67     ;PUSH Bytes
IP              67         ;Interpolate Point
IP              36         ;Interpolate Point
                           #--- PUSHB_1   42        ;PUSH Bytes
SRP2            42         ;Set Reference Point 2
                           #--- PUSHB_1   45        ;PUSH Bytes
IP              45         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'semicolon': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   5 1 0     ;PUSH Bytes
CALL            0 1 5      ;CALL function
                           #--- PUSHB_5   6 14 0 30 4 ;PUSH Bytes
CALL            4 30 0 14 6 ;CALL function
                           #--- PUSHB_3   13 3 0    ;PUSH Bytes
CALL            0 3 13     ;CALL function
                           #--- PUSHB_5   12 14 0 30 4 ;PUSH Bytes
CALL            4 30 0 14 12 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   15        ;PUSH Bytes
MDAP[rnd]       15         ;Move Direct Absolute Point
                           #--- PUSHB_1   5         ;PUSH Bytes
MDRP[rp0,rnd,white] 5          ;Move Direct Relative Point
                           #--- PUSHB_1   12        ;PUSH Bytes
SHP[rp2]        12         ;SHift Point using reference point
                           #--- PUSHB_5   8 16 0 30 4 ;PUSH Bytes
CALL            4 30 0 16 8 ;CALL function
                           #--- PUSHB_1   11        ;PUSH Bytes
SHP[rp2]        11         ;SHift Point using reference point
                           #--- PUSHB_1   8         ;PUSH Bytes
SRP0            8          ;Set Reference Point 0
                           #--- PUSHB_5   4 15 0 20 4 ;PUSH Bytes
CALL            4 20 0 15 4 ;CALL function
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_2   16 1      ;PUSH Bytes
CALL            1 16       ;CALL function
                           #--- PUSHB_2   4 5       ;PUSH Bytes
SRP1            5          ;Set Reference Point 1
SRP2            4          ;Set Reference Point 2
                           #--- PUSHB_1   0         ;PUSH Bytes
IP              0          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'seven': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_2   5 13      ;PUSH Bytes
MIRP[min,black] ecstemt 5  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   11        ;PUSH Bytes
MDAP[rnd]       11         ;Move Direct Absolute Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
                           #--- PUSHB_2   0 16      ;PUSH Bytes
MIRP[min,black] estemw 0   ;Move Indirect Relative Point
                           #--- PUSHB_3   0 1 10    ;PUSH Bytes
CALL            10 1 0     ;CALL function
                           #--- PUSHB_4   64 0 8 9  ;PUSH Bytes
CALL            9 8 0 64   ;CALL function
                           #--- PUSHB_3   1 0 10    ;PUSH Bytes
CALL            10 0 1     ;CALL function
                           #--- PUSHB_4   64 1 5 9  ;PUSH Bytes
CALL            9 5 1 64   ;CALL function
                           #--- PUSHB_2   12 1      ;PUSH Bytes
CALL            1 12       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   5 1       ;PUSH Bytes
SRP1            1          ;Set Reference Point 1
SRP2            5          ;Set Reference Point 2
                           #--- PUSHB_1   8         ;PUSH Bytes
IP              8          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'six': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   25 14     ;PUSH Bytes
MIRP[min,black] ecstemw 25 ;Move Indirect Relative Point
                           #--- PUSHB_3   6 5 0     ;PUSH Bytes
CALL            0 5 6      ;CALL function
                           #--- PUSHB_2   13 14     ;PUSH Bytes
MIRP[min,black] ecstemw 13 ;Move Indirect Relative Point
                           #--- PUSHB_3   13 6 10   ;PUSH Bytes
CALL            10 6 13    ;CALL function
                           #--- PUSHB_4   64 13 10 9 ;PUSH Bytes
CALL            9 10 13 64 ;CALL function
                           #--- PUSHB_5   19 31 0 6 13 ;PUSH Bytes
CALL            13 6 0 31 19 ;CALL function
                           #--- PUSHB_2   19 14     ;PUSH Bytes
MIRP[min,black] ecstemw 19 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   37        ;PUSH Bytes
MDAP[rnd]       37         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   16 16     ;PUSH Bytes
MIRP[min,black] estemw 16  ;Move Indirect Relative Point
                           #--- PUSHB_1   16        ;PUSH Bytes
SRP0            16         ;Set Reference Point 0
                           #--- PUSHB_2   28 1      ;PUSH Bytes
CALL            1 28       ;CALL function
                           #--- PUSHB_2   22 16     ;PUSH Bytes
MIRP[min,black] estemw 22  ;Move Indirect Relative Point
                           #--- PUSHB_2   38 1      ;PUSH Bytes
CALL            1 38       ;CALL function
                           #--- PUSHB_2   28 16     ;PUSH Bytes
SRP1            16         ;Set Reference Point 1
SRP2            28         ;Set Reference Point 2
                           #--- PUSHB_5   6 10 0 19 34 ;PUSH Bytes
                           #--- DEPTH     #5        ;DEPTH of the stack
SLOOP           5          ;Set LOOP variable
IP              34 19 0 10 6 ;Interpolate Point
                           #--- PUSHB_1   22        ;PUSH Bytes
SRP1            22         ;Set Reference Point 1
                           #--- PUSHB_2   8 9       ;PUSH Bytes
IP              9          ;Interpolate Point
IP              8          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   31 25     ;PUSH Bytes
SRP1            25         ;Set Reference Point 1
SRP2            31         ;Set Reference Point 2
                           #--- PUSHB_2   3 22      ;PUSH Bytes
IP              22         ;Interpolate Point
IP              3          ;Interpolate Point
                           #--- PUSHB_1   19        ;PUSH Bytes
SRP1            19         ;Set Reference Point 1
                           #--- PUSHB_1   16        ;PUSH Bytes
IP              16         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'slash': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   2 5 0     ;PUSH Bytes
CALL            0 5 2      ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   4         ;PUSH Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
                           #--- PUSHB_2   5 1       ;PUSH Bytes
CALL            1 5        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'sterling': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_2   32 13     ;PUSH Bytes
MIRP[min,black] ecstemt 32 ;Move Indirect Relative Point
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_5   2 14 0 30 4 ;PUSH Bytes
CALL            4 30 0 14 2 ;CALL function
                           #--- PUSHB_3   15 5 0    ;PUSH Bytes
CALL            0 5 15     ;CALL function
                           #--- PUSHB_5   16 14 0 30 4 ;PUSH Bytes
CALL            4 30 0 14 16 ;CALL function
                           #--- PUSHB_1   12        ;PUSH Bytes
DUP             12         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   20 12     ;PUSH Bytes
MIRP[min,black] cvt_12 20  ;Move Indirect Relative Point
                           #--- PUSHB_5   6 7 1 15 13 ;PUSH Bytes
CALL            13 15 1 7 6 ;CALL function
                           #--- PUSHB_1   24        ;PUSH Bytes
SHP[rp1]        24         ;SHift Point using reference point
                           #--- PUSHB_2   6 9       ;PUSH Bytes
MIRP[min,black] headstem 6 ;Move Indirect Relative Point
                           #--- PUSHB_1   26        ;PUSH Bytes
SHP[rp2]        26         ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   34        ;PUSH Bytes
MDAP[rnd]       34         ;Move Direct Absolute Point
                           #--- PUSHB_1   5         ;PUSH Bytes
MDRP[rp0,rnd,white] 5          ;Move Direct Relative Point
                           #--- PUSHB_1   8         ;PUSH Bytes
SHP[rp2]        8          ;SHift Point using reference point
                           #--- PUSHB_2   28 16     ;PUSH Bytes
MIRP[min,black] estemw 28  ;Move Indirect Relative Point
                           #--- PUSHB_1   23        ;PUSH Bytes
SHP[rp2]        23         ;SHift Point using reference point
                           #--- PUSHB_3   28 5 10   ;PUSH Bytes
CALL            10 5 28    ;CALL function
                           #--- PUSHB_4   64 28 0 9 ;PUSH Bytes
CALL            9 0 28 64  ;CALL function
                           #--- PUSHB_4   64 28 26 9 ;PUSH Bytes
CALL            9 26 28 64 ;CALL function
                           #--- PUSHB_3   5 28 10   ;PUSH Bytes
CALL            10 28 5    ;CALL function
                           #--- PUSHB_4   64 5 1 9  ;PUSH Bytes
CALL            9 1 5 64   ;CALL function
                           #--- PUSHB_4   64 5 6 9  ;PUSH Bytes
CALL            9 6 5 64   ;CALL function
                           #--- PUSHB_2   35 1      ;PUSH Bytes
CALL            1 35       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   2 32      ;PUSH Bytes
SRP1            32         ;Set Reference Point 1
SRP2            2          ;Set Reference Point 2
                           #--- PUSHB_1   31        ;PUSH Bytes
IP              31         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    't': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   17 6      ;PUSH Bytes
MIRP[min,black] estemtc 17 ;Move Indirect Relative Point
                           #--- PUSHB_3   6 3 0     ;PUSH Bytes
CALL            0 3 6      ;CALL function
                           #--- PUSHB_1   10        ;PUSH Bytes
SHP[rp1]        10         ;SHift Point using reference point
                           #--- PUSHB_2   5 10      ;PUSH Bytes
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
                           #--- PUSHB_1   12        ;PUSH Bytes
SHP[rp2]        12         ;SHift Point using reference point
                           #--- PUSHB_3   6 5 10    ;PUSH Bytes
CALL            10 5 6     ;CALL function
                           #--- PUSHB_4   64 6 9 9  ;PUSH Bytes
CALL            9 9 6 64   ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   22        ;PUSH Bytes
MDAP[rnd]       22         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
gfx(3)
                           #--- PUSHB_1   7         ;PUSH Bytes
SHP[rp2]        7          ;SHift Point using reference point
                           #--- PUSHB_2   14 16     ;PUSH Bytes
MIRP[min,black] estemw 14  ;Move Indirect Relative Point
                           #--- PUSHB_1   9         ;PUSH Bytes
SHP[rp2]        9          ;SHift Point using reference point
                           #--- PUSHB_3   14 3 10   ;PUSH Bytes
CALL            10 3 14    ;CALL function
                           #--- PUSHB_4   64 14 12 9 ;PUSH Bytes
CALL            9 12 14 64 ;CALL function
                           #--- PUSHB_3   3 14 10   ;PUSH Bytes
CALL            10 14 3    ;CALL function
                           #--- PUSHB_4   64 3 5 9  ;PUSH Bytes
CALL            9 5 3 64   ;CALL function
                           #--- PUSHB_2   23 1      ;PUSH Bytes
CALL            1 23       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   17 0      ;PUSH Bytes
SRP1            0          ;Set Reference Point 1
SRP2            17         ;Set Reference Point 2
                           #--- PUSHB_1   20        ;PUSH Bytes
IP              20         ;Interpolate Point
                           #--- PUSHB_1   5         ;PUSH Bytes
SRP1            5          ;Set Reference Point 1
                           #--- PUSHB_1   19        ;PUSH Bytes
IP              19         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'three': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   0 1 0     ;PUSH Bytes
CALL            0 1 0      ;CALL function
                           #--- PUSHB_2   7 14      ;PUSH Bytes
MIRP[min,black] ecstemw 7  ;Move Indirect Relative Point
                           #--- PUSHB_3   7 0 10    ;PUSH Bytes
CALL            10 0 7     ;CALL function
                           #--- PUSHB_4   64 7 3 9  ;PUSH Bytes
CALL            9 3 7 64   ;CALL function
                           #--- PUSHB_3   31 5 0    ;PUSH Bytes
CALL            0 5 31     ;CALL function
                           #--- PUSHB_2   24 14     ;PUSH Bytes
MIRP[min,black] ecstemw 24 ;Move Indirect Relative Point
                           #--- PUSHB_5   18 13 0 31 13 ;PUSH Bytes
CALL            13 31 0 13 18 ;CALL function
                           #--- PUSHB_2   18 9      ;PUSH Bytes
MIRP[min,black] headstem 18 ;Move Indirect Relative Point
                           #--- PUSHB_4   28 0 31 8 ;PUSH Bytes
CALL            8 31 0 28  ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   43        ;PUSH Bytes
MDAP[rnd]       43         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_2   4 16      ;PUSH Bytes
MIRP[min,black] estemw 4   ;Move Indirect Relative Point
                           #--- PUSHB_1   28        ;PUSH Bytes
DUP             28         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   27 16     ;PUSH Bytes
MIRP[min,black] estemw 27  ;Move Indirect Relative Point
                           #--- PUSHB_1   4         ;PUSH Bytes
SRP0            4          ;Set Reference Point 0
                           #--- PUSHB_2   10 1      ;PUSH Bytes
CALL            1 10       ;CALL function
                           #--- PUSHB_2   40 16     ;PUSH Bytes
MIRP[min,black] estemw 40  ;Move Indirect Relative Point
                           #--- PUSHB_1   21        ;PUSH Bytes
DUP             21         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   34 16     ;PUSH Bytes
MIRP[min,black] estemw 34  ;Move Indirect Relative Point
                           #--- PUSHB_2   44 1      ;PUSH Bytes
CALL            1 44       ;CALL function
                           #--- PUSHB_2   21 27     ;PUSH Bytes
SRP1            27         ;Set Reference Point 1
SRP2            21         ;Set Reference Point 2
                           #--- PUSHB_6   7 13 0 15 31 37 ;PUSH Bytes
                           #--- DEPTH     #6        ;DEPTH of the stack
SLOOP           6          ;Set LOOP variable
IP              37 31 15 0 13 7 ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   13 7      ;PUSH Bytes
SRP1            7          ;Set Reference Point 1
SRP2            13         ;Set Reference Point 2
                           #--- PUSHB_2   15 40     ;PUSH Bytes
IP              40         ;Interpolate Point
IP              15         ;Interpolate Point
                           #--- PUSHB_1   18        ;PUSH Bytes
SRP1            18         ;Set Reference Point 1
                           #--- PUSHB_1   37        ;PUSH Bytes
IP              37         ;Interpolate Point
                           #--- PUSHB_2   24 28     ;PUSH Bytes
SRP1            28         ;Set Reference Point 1
SRP2            24         ;Set Reference Point 2
                           #--- PUSHB_2   21 34     ;PUSH Bytes
IP              34         ;Interpolate Point
IP              21         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'two': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_2   28 13     ;PUSH Bytes
MIRP[min,black] ecstemt 28 ;Move Indirect Relative Point
                           #--- PUSHB_3   18 5 0    ;PUSH Bytes
CALL            0 5 18     ;CALL function
                           #--- PUSHB_2   11 14     ;PUSH Bytes
MIRP[min,black] ecstemw 11 ;Move Indirect Relative Point
                           #--- PUSHB_3   11 18 10  ;PUSH Bytes
CALL            10 18 11   ;CALL function
                           #--- PUSHB_4   64 11 15 9 ;PUSH Bytes
CALL            9 15 11 64 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   30        ;PUSH Bytes
MDAP[rnd]       30         ;Move Direct Absolute Point
                           #--- PUSHB_1   15        ;PUSH Bytes
MDRP[rp0,rnd,white] 15         ;Move Direct Relative Point
                           #--- PUSHB_2   14 16     ;PUSH Bytes
MIRP[min,black] estemw 14  ;Move Indirect Relative Point
                           #--- PUSHB_1   14        ;PUSH Bytes
SRP0            14         ;Set Reference Point 0
                           #--- PUSHB_2   8 1       ;PUSH Bytes
CALL            1 8        ;CALL function
                           #--- PUSHB_2   21 16     ;PUSH Bytes
MIRP[min,black] estemw 21  ;Move Indirect Relative Point
                           #--- PUSHB_1   0         ;PUSH Bytes
SHP[rp2]        0          ;SHift Point using reference point
                           #--- PUSHB_2   31 1      ;PUSH Bytes
CALL            1 31       ;CALL function
                           #--- PUSHB_2   8 14      ;PUSH Bytes
SRP1            14         ;Set Reference Point 1
SRP2            8          ;Set Reference Point 2
                           #--- PUSHB_4   4 18 24 28 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
IP              28 24 18 4 ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   11 28     ;PUSH Bytes
SRP1            28         ;Set Reference Point 1
SRP2            11         ;Set Reference Point 2
                           #--- PUSHB_2   4 21      ;PUSH Bytes
IP              21         ;Interpolate Point
IP              4          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'u': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   1 1 0     ;PUSH Bytes
CALL            0 1 1      ;CALL function
                           #--- PUSHB_3   5 1 0     ;PUSH Bytes
CALL            0 1 5      ;CALL function
                           #--- PUSHB_2   14 6      ;PUSH Bytes
MIRP[min,black] estemtc 14 ;Move Indirect Relative Point
                           #--- PUSHB_3   9 3 0     ;PUSH Bytes
CALL            0 3 9      ;CALL function
                           #--- PUSHB_1   18        ;PUSH Bytes
SHP[rp1]        18         ;SHift Point using reference point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   20        ;PUSH Bytes
MDAP[rnd]       20         ;Move Direct Absolute Point
                           #--- PUSHB_1   8         ;PUSH Bytes
MDRP[rp0,rnd,white] 8          ;Move Direct Relative Point
gfx(8)
                           #--- PUSHB_2   11 16     ;PUSH Bytes
MIRP[min,black] estemw 11  ;Move Indirect Relative Point
                           #--- PUSHB_1   11        ;PUSH Bytes
#SRP0            11         ;Set Reference Point 0
#                           #--- PUSHB_2   17 1      ;PUSH Bytes
#CALL            1 17       ;CALL function
#                           #--- PUSHB_1   1         ;PUSH Bytes
#SHP[rp2]        1          ;SHift Point using reference point
#                           #--- PUSHB_2   0 16      ;PUSH Bytes
#MIRP[min,black] estemw 0   ;Move Indirect Relative Point
#                           #--- PUSHB_2   21 1      ;PUSH Bytes
#CALL            1 21       ;CALL function
grx(21,0,17)
alignrp 1
                           #--- PUSHB_2   17 11     ;PUSH Bytes
SRP1            11         ;Set Reference Point 1
SRP2            17         ;Set Reference Point 2
                           #--- PUSHB_1   5         ;PUSH Bytes
IP              5          ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   9 14      ;PUSH Bytes
SRP1            14         ;Set Reference Point 1
SRP2            9          ;Set Reference Point 2
                           #--- PUSHB_1   2         ;PUSH Bytes
IP              2          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'underscoredbl': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   5 0 0     ;PUSH Bytes
CALL            0 0 5      ;CALL function
                           #--- PUSHB_2   6 9       ;PUSH Bytes
MIRP[min,black] headstem 6 ;Move Indirect Relative Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   2 9       ;PUSH Bytes
MIRP[min,black] headstem 2 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'uni00A0': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   5 1 0     ;PUSH Bytes
CALL            0 1 5      ;CALL function
                           #--- PUSHB_3   6 3 0     ;PUSH Bytes
CALL            0 3 6      ;CALL function
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_5   2 14 0 30 4 ;PUSH Bytes
CALL            4 30 0 14 2 ;CALL function
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   8         ;PUSH Bytes
MDAP[rnd]       8          ;Move Direct Absolute Point
                           #--- PUSHB_1   6         ;PUSH Bytes
MDRP[rp0,rnd,white] 6          ;Move Direct Relative Point
                           #--- PUSHB_2   7 15      ;PUSH Bytes
MIRP[min,black] headstem_thick 7 ;Move Indirect Relative Point
                           #--- PUSHB_4   31 6 1 14 ;PUSH Bytes
CALL            14 1 6 31  ;CALL function
                           #--- PUSHB_1   5         ;PUSH Bytes
SHP[rp1]        5          ;SHift Point using reference point
                           #--- PUSHB_5   0 16 0 31 4 ;PUSH Bytes
CALL            4 31 0 16 0 ;CALL function
                           #--- PUSHB_1   4         ;PUSH Bytes
SHP[rp2]        4          ;SHift Point using reference point
                           #--- PUSHB_2   9 1       ;PUSH Bytes
CALL            1 9        ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'uni00AD': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   0         ;PUSH Bytes
MDAP[rnd]       0          ;Move Direct Absolute Point
                           #--- PUSHB_2   12 7      ;PUSH Bytes
MIRP[min,black] cvt_7 12   ;Move Indirect Relative Point
                           #--- PUSHB_1   27        ;PUSH Bytes
MDAP[rnd]       27         ;Move Direct Absolute Point
                           #--- PUSHB_2   46 8      ;PUSH Bytes
MIRP[min,black] cvt_8 46   ;Move Indirect Relative Point
                           #--- PUSHB_3   27 46 10  ;PUSH Bytes
CALL            10 46 27   ;CALL function
                           #--- PUSHB_4   64 27 29 9 ;PUSH Bytes
CALL            9 29 27 64 ;CALL function
                           #--- PUSHB_1   24        ;PUSH Bytes
SHP[rp2]        24         ;SHift Point using reference point
                           #--- PUSHB_1   45        ;PUSH Bytes
MDAP[rnd]       45         ;Move Direct Absolute Point
                           #--- PUSHB_2   31 8      ;PUSH Bytes
MIRP[min,black] cvt_8 31   ;Move Indirect Relative Point
                           #--- PUSHB_1   18        ;PUSH Bytes
MDAP[rnd]       18         ;Move Direct Absolute Point
                           #--- PUSHB_2   6 7       ;PUSH Bytes
MIRP[min,black] cvt_7 6    ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   47        ;PUSH Bytes
MDAP[rnd]       47         ;Move Direct Absolute Point
                           #--- PUSHB_1   3         ;PUSH Bytes
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
                           #--- PUSHB_5   21 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 21 ;CALL function
                           #--- PUSHB_1   21        ;PUSH Bytes
SRP0            21         ;Set Reference Point 0
                           #--- PUSHB_2   29 1      ;PUSH Bytes
CALL            1 29       ;CALL function
                           #--- PUSHB_2   28 15     ;PUSH Bytes
MIRP[min,black] headstem_thick 28 ;Move Indirect Relative Point
                           #--- PUSHB_1   45        ;PUSH Bytes
SHP[rp2]        45         ;SHift Point using reference point
                           #--- PUSHB_1   28        ;PUSH Bytes
SRP0            28         ;Set Reference Point 0
                           #--- PUSHB_2   41 1      ;PUSH Bytes
CALL            1 41       ;CALL function
                           #--- PUSHB_2   34 16     ;PUSH Bytes
MIRP[min,black] estemw 34  ;Move Indirect Relative Point
                           #--- PUSHB_1   34        ;PUSH Bytes
SRP0            34         ;Set Reference Point 0
                           #--- PUSHB_2   15 1      ;PUSH Bytes
CALL            1 15       ;CALL function
                           #--- PUSHB_5   9 15 0 32 4 ;PUSH Bytes
CALL            4 32 0 15 9 ;CALL function
                           #--- PUSHB_2   48 1      ;PUSH Bytes
CALL            1 48       ;CALL function
                           #--- PUSHB_2   41 28     ;PUSH Bytes
SRP1            28         ;Set Reference Point 1
SRP2            41         ;Set Reference Point 2
                           #--- PUSHB_4   0 26 12 37 ;PUSH Bytes
                           #--- DEPTH     #4        ;DEPTH of the stack
SLOOP           4          ;Set LOOP variable
IP              37 12 26 0 ;Interpolate Point
                           #--- PUSHB_1   34        ;PUSH Bytes
SRP1            34         ;Set Reference Point 1
                           #--- PUSHB_1   25        ;PUSH Bytes
IP              25         ;Interpolate Point
                           #--- PUSHB_1   15        ;PUSH Bytes
SRP2            15         ;Set Reference Point 2
                           #--- PUSHB_1   24        ;PUSH Bytes
IP              24         ;Interpolate Point
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   46 27     ;PUSH Bytes
SRP1            27         ;Set Reference Point 1
SRP2            46         ;Set Reference Point 2
                           #--- PUSHB_3   21 15 37  ;PUSH Bytes
IP              37         ;Interpolate Point
IP              15         ;Interpolate Point
IP              21         ;Interpolate Point
                           #--- PUSHB_1   45        ;PUSH Bytes
SRP1            45         ;Set Reference Point 1
                           #--- PUSHB_1   34        ;PUSH Bytes
IP              34         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'uni00B2': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_3   15 5 0    ;PUSH Bytes
CALL            0 5 15     ;CALL function
                           #--- PUSHB_2   14 14     ;PUSH Bytes
MIRP[min,black] ecstemw 14 ;Move Indirect Relative Point
                           #--- PUSHB_1   18        ;PUSH Bytes
DUP             18         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   10 10     ;PUSH Bytes
MIRP[min,black] estemt 10  ;Move Indirect Relative Point
                           #--- PUSHB_1   1         ;PUSH Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
                           #--- PUSHB_2   26 10     ;PUSH Bytes
MIRP[min,black] estemt 26  ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   28        ;PUSH Bytes
MDAP[rnd]       28         ;Move Direct Absolute Point
                           #--- PUSHB_1   7         ;PUSH Bytes
MDRP[rp0,rnd,white] 7          ;Move Direct Relative Point
                           #--- PUSHB_2   21 16     ;PUSH Bytes
MIRP[min,black] estemw 21  ;Move Indirect Relative Point
                           #--- PUSHB_3   21 7 10   ;PUSH Bytes
CALL            10 7 21    ;CALL function
                           #--- PUSHB_4   64 21 0 9 ;PUSH Bytes
CALL            9 0 21 64  ;CALL function
                           #--- PUSHB_3   7 21 10   ;PUSH Bytes
CALL            10 21 7    ;CALL function
                           #--- PUSHB_4   64 7 1 9  ;PUSH Bytes
CALL            9 1 7 64   ;CALL function
                           #--- PUSHB_1   14        ;PUSH Bytes
SHP[rp2]        14         ;SHift Point using reference point
                           #--- PUSHB_2   29 1      ;PUSH Bytes
CALL            1 29       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   14 26     ;PUSH Bytes
SRP1            26         ;Set Reference Point 1
SRP2            14         ;Set Reference Point 2
                           #--- PUSHB_3   2 7 21    ;PUSH Bytes
IP              21         ;Interpolate Point
IP              7          ;Interpolate Point
IP              2          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'uni00B3': """
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   0         ;PUSH Bytes
MDAP[rnd]       0          ;Move Direct Absolute Point
                           #--- PUSHB_2   8 9       ;PUSH Bytes
MIRP[min,black] headstem 8 ;Move Indirect Relative Point
                           #--- PUSHB_1   3         ;PUSH Bytes
DUP             3          ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   4 13      ;PUSH Bytes
MIRP[min,black] ecstemt 4  ;Move Indirect Relative Point
                           #--- PUSHB_1   15        ;PUSH Bytes
MDAP[rnd]       15         ;Move Direct Absolute Point
                           #--- PUSHB_2   16 9      ;PUSH Bytes
MIRP[min,black] headstem 16 ;Move Indirect Relative Point
                           #--- PUSHB_1   23        ;PUSH Bytes
MDAP[rnd]       23         ;Move Direct Absolute Point
                           #--- PUSHB_2   31 9      ;PUSH Bytes
MIRP[min,black] headstem 31 ;Move Indirect Relative Point
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_1   44        ;PUSH Bytes
MDAP[rnd]       44         ;Move Direct Absolute Point
                           #--- PUSHB_1   11        ;PUSH Bytes
MDRP[rp0,rnd,white] 11         ;Move Direct Relative Point
                           #--- PUSHB_2   41 16     ;PUSH Bytes
MIRP[min,black] estemw 41  ;Move Indirect Relative Point
                           #--- PUSHB_1   41        ;PUSH Bytes
SRP0            41         ;Set Reference Point 0
                           #--- PUSHB_1   34        ;PUSH Bytes
DUP             34         ;DUPlicate top stack element
MDRP[rp0,rnd,white] &_DUP_1    ;Move Direct Relative Point
SRP1            &_DUP_2    ;Set Reference Point 1
                           #--- PUSHB_2   20 16     ;PUSH Bytes
MIRP[min,black] estemw 20  ;Move Indirect Relative Point
                           #--- PUSHB_1   20        ;PUSH Bytes
MDAP[rnd]       20         ;Move Direct Absolute Point
                           #--- PUSHB_2   34 16     ;PUSH Bytes
MIRP[min,black] estemw 34  ;Move Indirect Relative Point
                           #--- PUSHB_3   20 34 10  ;PUSH Bytes
CALL            10 34 20   ;CALL function
                           #--- PUSHB_4   64 20 15 9 ;PUSH Bytes
CALL            9 15 20 64 ;CALL function
                           #--- PUSHB_2   45 1      ;PUSH Bytes
CALL            1 45       ;CALL function
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
                           #--- PUSHB_2   15 4      ;PUSH Bytes
SRP1            4          ;Set Reference Point 1
SRP2            15         ;Set Reference Point 2
                           #--- PUSHB_2   11 41     ;PUSH Bytes
IP              41         ;Interpolate Point
IP              11         ;Interpolate Point
                           #--- PUSHB_1   16        ;PUSH Bytes
SRP1            16         ;Set Reference Point 1
                           #--- PUSHB_2   37 38     ;PUSH Bytes
IP              38         ;Interpolate Point
IP              37         ;Interpolate Point
                           #--- PUSHB_1   23        ;PUSH Bytes
SRP2            23         ;Set Reference Point 2
                           #--- PUSHB_3   26 27 34  ;PUSH Bytes
IP              34         ;Interpolate Point
IP              27         ;Interpolate Point
IP              26         ;Interpolate Point
                           #--- PUSHB_1   31        ;PUSH Bytes
SRP1            31         ;Set Reference Point 1
                           #--- PUSHB_1   28        ;PUSH Bytes
IP              28         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E01': """
                           #--- NPUSHB    25 21 5 24 14 118 24 102 24 86 24 71 24 55 24 5 24 16 127 1 0 1 2 1 26 8 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    42 8 12 18 10 12 17 155 18 139 18 123 18 107 18 91 18 27 18 11 18 7 18 118 12 102 12 86 12 71 12 55 12 5 12 16 16 14 0 14 2 14 25 ;PUSH N Bytes
SRP0            25         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 14         ;Move Direct Relative Point
DELTAP1         2 14 0 14 16 ;DELTA exception P1
MIRP[min,black] estemw 12  ;Move Indirect Relative Point
DELTAP1         5 12 55 12 71 12 86 12 102 12 118 ;DELTA exception P1
MDRP[rp0,grey]  18         ;Move Direct Relative Point
DELTAP1         7 18 11 18 27 18 91 18 107 18 123 18 139 18 155 ;DELTA exception P1
MDRP[grey]      17         ;Move Direct Relative Point
SRP0            12         ;Set Reference Point 0
MDRP[grey]      10         ;Move Direct Relative Point
SRP1            18         ;Set Reference Point 1
SRP2            12         ;Set Reference Point 2
IP              8          ;Interpolate Point
SHPIX           -8 8       ;SHift point by a PIXel amount
SRP0            26         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 127 ;DELTA exception P1
MIRP[min,black] estemw 24  ;Move Indirect Relative Point
DELTAP1         5 24 55 24 71 24 86 24 102 24 118 ;DELTA exception P1
SRP1            14         ;Set Reference Point 1
SRP2            24         ;Set Reference Point 2
IP              5          ;Interpolate Point
IP              21         ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    23 121 5 104 5 88 5 3 5 10 10 9 17 8 18 24 2 12 15 9 21 34 13 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         13         ;ALIGN to Reference Point
MIRP[rp0,rnd,grey] cvt_34 21  ;Move Indirect Relative Point
SLOOP           9          ;Set LOOP variable
IP              15 12 2 24 18 8 17 9 10 ;Interpolate Point
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
DELTAP1         3 5 88 5 104 5 121 ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E02': """
                           #--- NPUSHB    75 117 15 101 15 85 15 122 17 106 17 90 17 6 118 25 102 25 86 25 71 25 55 25 5 25 16 127 4 111 4 95 4 79 4 47 4 31 4 6 4 118 28 102 28 86 28 71 28 55 28 5 28 16 64 1 1 1 118 31 102 31 86 31 71 31 55 31 5 31 16 127 29 1 29 45 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 41 6 251 41 159 41 2 41 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 35 5 251 35 11 35 2 35 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    45 13 6 224 13 208 13 144 13 128 13 64 13 48 13 0 13 7 13 37 118 10 102 10 86 10 71 10 55 10 5 10 16 175 19 159 19 143 19 127 19 111 19 5 19 44 ;PUSH N Bytes
SRP0            44         ;Set Reference Point 0
MDRP[rp0,rnd,white] 19         ;Move Direct Relative Point
DELTAP1         5 19 111 19 127 19 143 19 159 19 175 ;DELTA exception P1
MIRP[min,black] estemw 10  ;Move Indirect Relative Point
DELTAP1         5 10 55 10 71 10 86 10 102 10 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_37 13  ;Move Indirect Relative Point
DELTAP1         7 13 0 13 48 13 64 13 128 13 144 13 208 13 224 ;DELTA exception P1
DELTAP2         6 13 288 13 304 13 352 13 368 13 432 13 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 35 ;Move Indirect Relative Point
DELTAP1         2 35 11 35 251 ;DELTA exception P1
DELTAP2         5 35 267 35 283 35 299 35 315 35 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 41  ;Move Indirect Relative Point
DELTAP1         2 41 159 41 251 ;DELTA exception P1
DELTAP2         6 41 267 41 283 41 299 41 315 41 367 41 383 ;DELTA exception P2
SRP0            45         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 29         ;Move Direct Relative Point
DELTAP1         1 29 127   ;DELTA exception P1
MIRP[min,black] estemw 31  ;Move Indirect Relative Point
DELTAP1         5 31 55 31 71 31 86 31 102 31 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         1 1 64     ;DELTA exception P1
MIRP[min,black] estemw 28  ;Move Indirect Relative Point
DELTAP1         5 28 55 28 71 28 86 28 102 28 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 4          ;Move Direct Relative Point
DELTAP1         6 4 31 4 47 4 79 4 95 4 111 4 127 ;DELTA exception P1
MIRP[min,black] estemw 25  ;Move Indirect Relative Point
DELTAP1         5 25 55 25 71 25 86 25 102 25 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 17 90 17 106 17 122 15 85 15 101 15 117 ;DELTA exception P1
                           #--- NPUSHB    13 122 14 106 14 90 14 117 12 101 12 85 12 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 32 5 244 32 4 32 2 32 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 16 6 239 16 223 16 159 16 143 16 79 16 63 16 15 16 7 16 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    26 38 5 251 38 11 38 2 38 9 10 122 7 105 7 89 7 3 7 10 25 4 27 2 4 22 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   31 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    23 31 8 255 31 223 31 143 31 111 31 4 31 4 118 28 103 28 87 28 3 28 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 28  ;Move Indirect Relative Point
DELTAP1         3 28 87 28 103 28 118 ;DELTA exception P1
MIRP[rnd,grey]  tvheight 31 ;Move Indirect Relative Point
DELTAP1         4 31 111 31 143 31 223 31 255 ;DELTA exception P1
DELTAP2         8 31 287 31 335 31 367 31 399 31 431 31 447 31 479 31 511 ;DELTA exception P2
DELTAP3         1 31 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 22  ;Move Indirect Relative Point
SLOOP           4          ;Set LOOP variable
IP              2 27 4 25  ;Interpolate Point
MIRP[min,black] estemt 7   ;Move Indirect Relative Point
DELTAP1         3 7 89 7 105 7 122 ;DELTA exception P1
MDRP[rp0,rnd,grey] 10         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 38 ;Move Indirect Relative Point
DELTAP1         2 38 11 38 251 ;DELTA exception P1
DELTAP2         5 38 267 38 283 38 299 38 315 38 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 16  ;Move Indirect Relative Point
DELTAP1         7 16 15 16 63 16 79 16 143 16 159 16 223 16 239 ;DELTA exception P1
DELTAP2         6 16 303 16 319 16 367 16 383 16 447 16 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 32 ;Move Indirect Relative Point
DELTAP1         2 32 4 32 244 ;DELTA exception P1
DELTAP2         5 32 260 32 276 32 292 32 308 32 496 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 12 85 12 101 12 117 14 90 14 106 14 122 ;DELTA exception P1
""",

    'uni0E03': """
                           #--- NPUSHB    97 122 21 106 21 90 21 117 19 101 19 85 19 6 117 15 101 15 85 15 122 13 106 13 90 13 6 9 8 7 28 27 26 6 31 23 118 31 102 31 86 31 71 31 55 31 5 31 16 127 4 111 4 95 4 79 4 47 4 31 4 6 4 118 34 102 34 86 34 71 34 55 34 5 34 16 64 1 1 1 118 37 102 37 86 37 71 37 55 37 5 37 16 127 35 1 35 51 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 47 6 251 47 159 47 2 47 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 41 5 251 41 11 41 2 41 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    45 17 6 224 17 208 17 144 17 128 17 64 17 48 17 0 17 7 17 37 118 12 102 12 86 12 71 12 55 12 5 12 16 175 23 159 23 143 23 127 23 111 23 5 23 50 ;PUSH N Bytes
SRP0            50         ;Set Reference Point 0
MDRP[rp0,rnd,white] 23         ;Move Direct Relative Point
DELTAP1         5 23 111 23 127 23 143 23 159 23 175 ;DELTA exception P1
MIRP[min,black] estemw 12  ;Move Indirect Relative Point
DELTAP1         5 12 55 12 71 12 86 12 102 12 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_37 17  ;Move Indirect Relative Point
DELTAP1         7 17 0 17 48 17 64 17 128 17 144 17 208 17 224 ;DELTA exception P1
DELTAP2         6 17 288 17 304 17 352 17 368 17 432 17 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 41 ;Move Indirect Relative Point
DELTAP1         2 41 11 41 251 ;DELTA exception P1
DELTAP2         5 41 267 41 283 41 299 41 315 41 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 47  ;Move Indirect Relative Point
DELTAP1         2 47 159 47 251 ;DELTA exception P1
DELTAP2         6 47 267 47 283 47 299 47 315 47 367 47 383 ;DELTA exception P2
SRP0            51         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 35         ;Move Direct Relative Point
DELTAP1         1 35 127   ;DELTA exception P1
MIRP[min,black] estemw 37  ;Move Indirect Relative Point
DELTAP1         5 37 55 37 71 37 86 37 102 37 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         1 1 64     ;DELTA exception P1
MIRP[min,black] estemw 34  ;Move Indirect Relative Point
DELTAP1         5 34 55 34 71 34 86 34 102 34 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 4          ;Move Direct Relative Point
DELTAP1         6 4 31 4 47 4 79 4 95 4 111 4 127 ;DELTA exception P1
MIRP[min,black] estemw 31  ;Move Indirect Relative Point
DELTAP1         5 31 55 31 71 31 86 31 102 31 118 ;DELTA exception P1
SRP1            23         ;Set Reference Point 1
SRP2            31         ;Set Reference Point 2
SLOOP           6          ;Set LOOP variable
IP              26 27 28 7 8 9 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 13 90 13 106 13 122 15 85 15 101 15 117 ;DELTA exception P1
DELTAP1         6 19 85 19 101 19 117 21 90 21 106 21 122 ;DELTA exception P1
                           #--- NPUSHB    13 122 18 106 18 90 18 117 16 101 16 85 16 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 38 5 244 38 4 38 2 38 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 20 6 239 20 223 20 159 20 143 20 79 20 63 20 15 20 7 20 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    50 44 5 251 44 11 44 2 44 9 14 14 27 197 8 181 8 165 8 149 8 133 8 53 8 37 8 21 8 5 8 9 8 9 121 7 104 7 88 7 3 7 10 26 33 2 31 4 4 28 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   37 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    23 37 8 255 37 223 37 143 37 111 37 4 37 4 118 34 103 34 87 34 3 34 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 34  ;Move Indirect Relative Point
DELTAP1         3 34 87 34 103 34 118 ;DELTA exception P1
MIRP[rnd,grey]  tvheight 37 ;Move Indirect Relative Point
DELTAP1         4 37 111 37 143 37 223 37 255 ;DELTA exception P1
DELTAP2         8 37 287 37 335 37 367 37 399 37 431 37 447 37 479 37 511 ;DELTA exception P2
DELTAP3         1 37 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 28  ;Move Indirect Relative Point
SLOOP           4          ;Set LOOP variable
IP              4 31 2 33  ;Interpolate Point
ALIGNRP         26         ;ALIGN to Reference Point
MIRP[min,black] estemt 7   ;Move Indirect Relative Point
DELTAP1         3 7 88 7 104 7 121 ;DELTA exception P1
SHP[rp2]        9          ;SHift Point using reference point
MDRP[rp0,min,rnd,grey] 8          ;Move Direct Relative Point
DELTAP1         9 8 5 8 21 8 37 8 53 8 133 8 149 8 165 8 181 8 197 ;DELTA exception P1
MDRP[black]     27         ;Move Direct Relative Point
MDRP[rp0,rnd,grey] 14         ;Move Direct Relative Point
MDAP[rnd]       14         ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 44 ;Move Indirect Relative Point
DELTAP1         2 44 11 44 251 ;DELTA exception P1
DELTAP2         5 44 267 44 283 44 299 44 315 44 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 20  ;Move Indirect Relative Point
DELTAP1         7 20 15 20 63 20 79 20 143 20 159 20 223 20 239 ;DELTA exception P1
DELTAP2         6 20 303 20 319 20 367 20 383 20 447 20 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 38 ;Move Indirect Relative Point
DELTAP1         2 38 4 38 244 ;DELTA exception P1
DELTAP2         5 38 260 38 276 38 292 38 308 38 496 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 16 85 16 101 16 117 18 90 18 106 18 122 ;DELTA exception P1
""",

    'uni0E04': """
                           #--- NPUSHB    50 117 22 101 22 85 22 122 24 106 24 90 24 6 117 18 101 18 85 18 122 16 106 16 90 16 6 5 39 42 36 118 42 102 42 86 42 71 42 55 42 5 42 16 127 1 0 1 2 1 56 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    10 46 5 251 46 11 46 2 46 9 26 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 20 6 224 20 208 20 144 20 128 20 64 20 48 20 0 20 7 20 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 52 5 244 52 4 52 2 52 9 ;PUSH N Bytes
                           #--- PUSHW_1   320       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- NPUSHB    51 14 2 112 14 96 14 2 14 36 11 29 8 118 29 102 29 86 29 71 29 55 29 5 29 16 16 30 1 30 118 8 102 8 86 8 71 8 55 8 5 8 16 32 36 16 36 0 36 3 36 55 ;PUSH N Bytes
SRP0            55         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 36         ;Move Direct Relative Point
DELTAP1         3 36 0 36 16 36 32 ;DELTA exception P1
MIRP[min,black] estemw 8   ;Move Indirect Relative Point
DELTAP1         5 8 55 8 71 8 86 8 102 8 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 30         ;Move Direct Relative Point
DELTAP1         1 30 16    ;DELTA exception P1
MIRP[min,black] estemw 29  ;Move Indirect Relative Point
DELTAP1         5 29 55 29 71 29 86 29 102 29 118 ;DELTA exception P1
SRP1            8          ;Set Reference Point 1
SRP2            29         ;Set Reference Point 2
IP              11         ;Interpolate Point
SRP0            36         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 14         ;Move Direct Relative Point
DELTAP1         2 14 96 14 112 ;DELTA exception P1
DELTAP2         2 14 304 14 320 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 52 ;Move Indirect Relative Point
DELTAP1         2 52 4 52 244 ;DELTA exception P1
DELTAP2         5 52 260 52 276 52 292 52 308 52 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 20  ;Move Indirect Relative Point
DELTAP1         7 20 0 20 48 20 64 20 128 20 144 20 208 20 224 ;DELTA exception P1
DELTAP2         6 20 288 20 304 20 352 20 368 20 432 20 448 ;DELTA exception P2
IP              26         ;Interpolate Point
MIRP[min,rnd,grey] headstem 46 ;Move Indirect Relative Point
DELTAP1         2 46 11 46 251 ;DELTA exception P1
DELTAP2         5 46 267 46 283 46 299 46 315 46 511 ;DELTA exception P2
SRP0            56         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 127 ;DELTA exception P1
MIRP[min,black] estemw 42  ;Move Indirect Relative Point
DELTAP1         5 42 55 42 71 42 86 42 102 42 118 ;DELTA exception P1
SRP1            36         ;Set Reference Point 1
SRP2            42         ;Set Reference Point 2
IP              39         ;Interpolate Point
IP              5          ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 16 90 16 106 16 122 18 85 18 101 18 117 ;DELTA exception P1
DELTAP1         6 24 90 24 106 24 122 22 85 22 101 22 117 ;DELTA exception P1
                           #--- NPUSHB    14 122 21 106 21 90 21 117 19 101 19 85 19 6 11 ;PUSH N Bytes
                           #--- PUSHW_1   -16       ;PUSH Words
                           #--- NPUSHB    15 26 12 116 14 100 14 84 14 121 26 105 26 89 26 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    11 43 5 244 43 4 43 2 43 9 14 26 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 23 6 239 23 223 23 159 23 143 23 79 23 63 23 15 23 7 23 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    29 49 5 251 49 11 49 2 49 9 17 122 5 106 5 89 5 3 5 6 42 2 11 8 36 5 39 34 29 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         29         ;ALIGN to Reference Point
MIRP[rp0,rnd,grey] cvt_34 39  ;Move Indirect Relative Point
SLOOP           5          ;Set LOOP variable
IP              36 8 11 2 42 ;Interpolate Point
MIRP[min,black] estemtc 5  ;Move Indirect Relative Point
DELTAP1         3 5 89 5 106 5 122 ;DELTA exception P1
MDRP[rp0,rnd,white] 17         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 49 ;Move Indirect Relative Point
DELTAP1         2 49 11 49 251 ;DELTA exception P1
DELTAP2         5 49 267 49 283 49 299 49 315 49 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 23  ;Move Indirect Relative Point
DELTAP1         7 23 15 23 63 23 79 23 143 23 159 23 223 23 239 ;DELTA exception P1
DELTAP2         6 23 303 23 319 23 367 23 383 23 447 23 463 ;DELTA exception P2
IP              26         ;Interpolate Point
IP              14         ;Interpolate Point
MIRP[min,rnd,grey] headstem 43 ;Move Indirect Relative Point
DELTAP1         2 43 4 43 244 ;DELTA exception P1
DELTAP2         5 43 260 43 276 43 292 43 308 43 496 ;DELTA exception P2
DELTAP1         6 26 89 26 105 26 121 14 84 14 100 14 116 ;DELTA exception P1
SHPIX           12 26      ;SHift point by a PIXel amount
SHPIX           -16 11     ;SHift point by a PIXel amount
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 19 85 19 101 19 117 21 90 21 106 21 122 ;DELTA exception P1
""",

    'uni0E05': """
                           #--- NPUSHB    55 117 22 101 22 85 22 122 24 106 24 90 24 6 117 18 101 18 85 18 122 16 106 16 90 16 6 6 5 4 40 39 38 6 42 36 118 42 102 42 86 42 71 42 55 42 5 42 16 127 1 0 1 2 1 56 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    10 46 5 251 46 11 46 2 46 9 26 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 20 6 224 20 208 20 144 20 128 20 64 20 48 20 0 20 7 20 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 52 5 244 52 4 52 2 52 9 ;PUSH N Bytes
                           #--- PUSHW_1   320       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- NPUSHB    51 14 2 112 14 96 14 2 14 36 11 29 8 118 29 102 29 86 29 71 29 55 29 5 29 16 16 30 1 30 118 8 102 8 86 8 71 8 55 8 5 8 16 32 36 16 36 0 36 3 36 55 ;PUSH N Bytes
SRP0            55         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 36         ;Move Direct Relative Point
DELTAP1         3 36 0 36 16 36 32 ;DELTA exception P1
MIRP[min,black] estemw 8   ;Move Indirect Relative Point
DELTAP1         5 8 55 8 71 8 86 8 102 8 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 30         ;Move Direct Relative Point
DELTAP1         1 30 16    ;DELTA exception P1
MIRP[min,black] estemw 29  ;Move Indirect Relative Point
DELTAP1         5 29 55 29 71 29 86 29 102 29 118 ;DELTA exception P1
SRP1            8          ;Set Reference Point 1
SRP2            29         ;Set Reference Point 2
IP              11         ;Interpolate Point
SRP0            36         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 14         ;Move Direct Relative Point
DELTAP1         2 14 96 14 112 ;DELTA exception P1
DELTAP2         2 14 304 14 320 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 52 ;Move Indirect Relative Point
DELTAP1         2 52 4 52 244 ;DELTA exception P1
DELTAP2         5 52 260 52 276 52 292 52 308 52 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 20  ;Move Indirect Relative Point
DELTAP1         7 20 0 20 48 20 64 20 128 20 144 20 208 20 224 ;DELTA exception P1
DELTAP2         6 20 288 20 304 20 352 20 368 20 432 20 448 ;DELTA exception P2
IP              26         ;Interpolate Point
MIRP[min,rnd,grey] headstem 46 ;Move Indirect Relative Point
DELTAP1         2 46 11 46 251 ;DELTA exception P1
DELTAP2         5 46 267 46 283 46 299 46 315 46 511 ;DELTA exception P2
SRP0            56         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 127 ;DELTA exception P1
MIRP[min,black] estemw 42  ;Move Indirect Relative Point
DELTAP1         5 42 55 42 71 42 86 42 102 42 118 ;DELTA exception P1
SRP1            36         ;Set Reference Point 1
SRP2            42         ;Set Reference Point 2
SLOOP           6          ;Set LOOP variable
IP              38 39 40 4 5 6 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 16 90 16 106 16 122 18 85 18 101 18 117 ;DELTA exception P1
DELTAP1         6 24 90 24 106 24 122 22 85 22 101 22 117 ;DELTA exception P1
                           #--- NPUSHB    14 122 21 106 21 90 21 117 19 101 19 85 19 6 11 ;PUSH N Bytes
                           #--- PUSHW_1   -16       ;PUSH Words
                           #--- NPUSHB    15 26 12 116 14 100 14 84 14 121 26 105 26 89 26 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    11 43 5 244 43 4 43 2 43 9 14 26 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 23 6 239 23 223 23 159 23 143 23 79 23 63 23 15 23 7 23 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    52 49 5 251 49 11 49 2 49 9 17 17 39 7 133 5 117 5 101 5 85 5 69 5 53 5 16 5 0 5 8 5 6 121 4 104 4 88 4 3 4 10 38 42 2 11 8 36 5 40 34 29 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         29         ;ALIGN to Reference Point
MIRP[rp0,rnd,grey] cvt_34 40  ;Move Indirect Relative Point
SLOOP           5          ;Set LOOP variable
IP              36 8 11 2 42 ;Interpolate Point
ALIGNRP         38         ;ALIGN to Reference Point
MIRP[min,black] estemt 4   ;Move Indirect Relative Point
DELTAP1         3 4 88 4 104 4 121 ;DELTA exception P1
SHP[rp2]        6          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 5          ;Move Direct Relative Point
DELTAP1         8 5 0 5 16 5 53 5 69 5 85 5 101 5 117 5 133 ;DELTA exception P1
MIRP[min,black] cvt_7 39   ;Move Indirect Relative Point
MDRP[rp0,min,rnd,white] 17         ;Move Direct Relative Point
MDAP[rnd]       17         ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 49 ;Move Indirect Relative Point
DELTAP1         2 49 11 49 251 ;DELTA exception P1
DELTAP2         5 49 267 49 283 49 299 49 315 49 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 23  ;Move Indirect Relative Point
DELTAP1         7 23 15 23 63 23 79 23 143 23 159 23 223 23 239 ;DELTA exception P1
DELTAP2         6 23 303 23 319 23 367 23 383 23 447 23 463 ;DELTA exception P2
IP              26         ;Interpolate Point
IP              14         ;Interpolate Point
MIRP[min,rnd,grey] headstem 43 ;Move Indirect Relative Point
DELTAP1         2 43 4 43 244 ;DELTA exception P1
DELTAP2         5 43 260 43 276 43 292 43 308 43 496 ;DELTA exception P2
DELTAP1         6 26 89 26 105 26 121 14 84 14 100 14 116 ;DELTA exception P1
SHPIX           12 26      ;SHift point by a PIXel amount
SHPIX           -16 11     ;SHift point by a PIXel amount
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 19 85 19 101 19 117 21 90 21 106 21 122 ;DELTA exception P1
""",

    'uni0E06': """
                           #--- NPUSHB    77 117 31 101 31 85 31 122 6 106 6 90 6 117 4 101 4 85 4 122 33 106 33 90 33 12 117 12 101 12 85 12 117 27 101 27 85 27 122 10 106 10 90 10 122 25 106 25 90 25 12 21 20 19 40 39 38 6 43 35 118 43 102 43 86 43 71 43 55 43 5 43 16 111 16 1 16 13 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 65 6 244 65 144 65 2 65 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   71        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   71        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   71        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   71        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 71 5 244 71 4 71 2 71 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   8         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   8         ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    47 8 3 79 8 63 8 47 8 3 8 2 118 45 102 45 86 45 71 45 55 45 5 45 16 255 13 1 13 1 118 49 102 49 86 49 71 49 55 49 5 49 16 127 47 1 47 75 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 59 6 251 59 159 59 2 59 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 53 5 251 53 11 53 2 53 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    45 29 6 224 29 208 29 144 29 128 29 64 29 48 29 0 29 7 29 37 118 24 102 24 86 24 71 24 55 24 5 24 16 175 35 159 35 143 35 127 35 111 35 5 35 74 ;PUSH N Bytes
SRP0            74         ;Set Reference Point 0
MDRP[rp0,rnd,white] 35         ;Move Direct Relative Point
DELTAP1         5 35 111 35 127 35 143 35 159 35 175 ;DELTA exception P1
MIRP[min,black] estemw 24  ;Move Indirect Relative Point
DELTAP1         5 24 55 24 71 24 86 24 102 24 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_37 29  ;Move Indirect Relative Point
DELTAP1         7 29 0 29 48 29 64 29 128 29 144 29 208 29 224 ;DELTA exception P1
DELTAP2         6 29 288 29 304 29 352 29 368 29 432 29 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 53 ;Move Indirect Relative Point
DELTAP1         2 53 11 53 251 ;DELTA exception P1
DELTAP2         5 53 267 53 283 53 299 53 315 53 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 59  ;Move Indirect Relative Point
DELTAP1         2 59 159 59 251 ;DELTA exception P1
DELTAP2         6 59 267 59 283 59 299 59 315 59 367 59 383 ;DELTA exception P2
SRP0            75         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 47         ;Move Direct Relative Point
DELTAP1         1 47 127   ;DELTA exception P1
MIRP[min,black] estemw 49  ;Move Indirect Relative Point
DELTAP1         5 49 55 49 71 49 86 49 102 49 118 ;DELTA exception P1
ALIGNRP         1          ;ALIGN to Reference Point
MDRP[rp0,rnd,grey] 13         ;Move Direct Relative Point
DELTAP1         1 13 255   ;DELTA exception P1
MIRP[min,black] estemw 45  ;Move Indirect Relative Point
DELTAP1         5 45 55 45 71 45 86 45 102 45 118 ;DELTA exception P1
SHP[rp2]        2          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 8          ;Move Direct Relative Point
DELTAP1         3 8 47 8 63 8 79 ;DELTA exception P1
DELTAP2         3 8 287 8 303 8 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 71 ;Move Indirect Relative Point
DELTAP1         2 71 4 71 244 ;DELTA exception P1
DELTAP2         5 71 260 71 276 71 292 71 308 71 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 65  ;Move Indirect Relative Point
DELTAP1         2 65 144 65 244 ;DELTA exception P1
DELTAP2         6 65 260 65 276 65 292 65 308 65 352 65 368 ;DELTA exception P2
SRP0            13         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 16         ;Move Direct Relative Point
DELTAP1         1 16 111   ;DELTA exception P1
MIRP[min,black] estemw 43  ;Move Indirect Relative Point
DELTAP1         5 43 55 43 71 43 86 43 102 43 118 ;DELTA exception P1
SRP1            35         ;Set Reference Point 1
SRP2            43         ;Set Reference Point 2
SLOOP           6          ;Set LOOP variable
IP              38 39 40 19 20 21 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 25 90 25 106 25 122 10 90 10 106 10 122 27 85 27 101 27 117 12 85 12 101 12 117 ;DELTA exception P1
DELTAP1         12 33 90 33 106 33 122 4 85 4 101 4 117 6 90 6 106 6 122 31 85 31 101 31 117 ;DELTA exception P1
                           #--- NPUSHB    26 122 7 106 7 90 7 117 9 101 9 85 9 6 122 30 106 30 90 30 117 28 101 28 85 28 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   68        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   68        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   68        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   68        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    11 68 5 251 68 11 68 2 68 9 2 46 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 11 6 224 11 208 11 144 11 128 11 64 11 48 11 0 11 7 11 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    12 62 5 244 62 4 62 2 62 9 5 31 1 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 50 5 244 50 4 50 2 50 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 32 6 239 32 223 32 159 32 143 32 79 32 63 32 15 32 7 32 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    50 56 5 251 56 11 56 2 56 9 26 26 39 197 20 181 20 165 20 149 20 133 20 53 20 37 20 21 20 5 20 9 20 21 121 19 104 19 88 19 3 19 10 38 45 14 43 16 4 40 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   49 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    23 49 8 255 49 223 49 143 49 111 49 4 49 4 118 47 103 47 87 47 3 47 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 47  ;Move Indirect Relative Point
DELTAP1         3 47 87 47 103 47 118 ;DELTA exception P1
MIRP[rnd,grey]  tvheight 49 ;Move Indirect Relative Point
DELTAP1         4 49 111 49 143 49 223 49 255 ;DELTA exception P1
DELTAP2         8 49 287 49 335 49 367 49 399 49 431 49 447 49 479 49 511 ;DELTA exception P2
DELTAP3         1 49 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 40  ;Move Indirect Relative Point
SLOOP           4          ;Set LOOP variable
IP              16 43 14 45 ;Interpolate Point
ALIGNRP         38         ;ALIGN to Reference Point
MIRP[min,black] estemt 19  ;Move Indirect Relative Point
DELTAP1         3 19 88 19 104 19 121 ;DELTA exception P1
SHP[rp2]        21         ;SHift Point using reference point
MDRP[rp0,min,rnd,grey] 20         ;Move Direct Relative Point
DELTAP1         9 20 5 20 21 20 37 20 53 20 133 20 149 20 165 20 181 20 197 ;DELTA exception P1
MDRP[black]     39         ;Move Direct Relative Point
MDRP[rp0,rnd,grey] 26         ;Move Direct Relative Point
MDAP[rnd]       26         ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 56 ;Move Indirect Relative Point
DELTAP1         2 56 11 56 251 ;DELTA exception P1
DELTAP2         5 56 267 56 283 56 299 56 315 56 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 32  ;Move Indirect Relative Point
DELTAP1         7 32 15 32 63 32 79 32 143 32 159 32 223 32 239 ;DELTA exception P1
DELTAP2         6 32 303 32 319 32 367 32 383 32 447 32 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 50 ;Move Indirect Relative Point
DELTAP1         2 50 4 50 244 ;DELTA exception P1
DELTAP2         5 50 260 50 276 50 292 50 308 50 496 ;DELTA exception P2
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 5   ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 62 ;Move Indirect Relative Point
DELTAP1         2 62 4 62 244 ;DELTA exception P1
DELTAP2         5 62 260 62 276 62 292 62 308 62 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 11  ;Move Indirect Relative Point
DELTAP1         7 11 0 11 48 11 64 11 128 11 144 11 208 11 224 ;DELTA exception P1
DELTAP2         6 11 288 11 304 11 352 11 368 11 432 11 448 ;DELTA exception P2
IP              46         ;Interpolate Point
IP              2          ;Interpolate Point
MIRP[min,rnd,grey] headstem 68 ;Move Indirect Relative Point
DELTAP1         2 68 11 68 251 ;DELTA exception P1
DELTAP2         5 68 267 68 283 68 299 68 315 68 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 28 85 28 101 28 117 30 90 30 106 30 122 ;DELTA exception P1
DELTAP1         6 9 85 9 101 9 117 7 90 7 106 7 122 ;DELTA exception P1
""",

    'uni0E07': """
                           #--- NPUSHB    46 117 14 101 14 85 14 122 16 106 16 90 16 6 117 22 101 22 85 22 122 20 106 20 90 20 6 118 6 102 6 86 6 71 6 55 6 5 6 16 3 3 9 0 3 24 4 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 31 6 244 31 144 31 2 31 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 37 5 244 37 4 37 2 37 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    31 18 3 79 18 63 18 47 18 3 18 118 24 102 24 86 24 71 24 55 24 5 24 16 127 12 0 12 2 12 41 4 ;PUSH N Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
SRP0            41         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 12         ;Move Direct Relative Point
DELTAP1         2 12 0 12 127 ;DELTA exception P1
MIRP[min,black] estemw 24  ;Move Indirect Relative Point
DELTAP1         5 24 55 24 71 24 86 24 102 24 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 18         ;Move Direct Relative Point
DELTAP1         3 18 47 18 63 18 79 ;DELTA exception P1
DELTAP2         3 18 287 18 303 18 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 37 ;Move Indirect Relative Point
DELTAP1         2 37 4 37 244 ;DELTA exception P1
DELTAP2         5 37 260 37 276 37 292 37 308 37 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 31  ;Move Indirect Relative Point
DELTAP1         2 31 144 31 244 ;DELTA exception P1
DELTAP2         6 31 260 31 276 31 292 31 308 31 352 31 368 ;DELTA exception P2
SRP1            4          ;Set Reference Point 1
SRP2            24         ;Set Reference Point 2
SLOOP           3          ;Set LOOP variable
IP              0 9 3      ;Interpolate Point
SRP0            3          ;Set Reference Point 0
MIRP[min,black] estemw 6   ;Move Indirect Relative Point
DELTAP1         5 6 55 6 71 6 86 6 102 6 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 20 90 20 106 20 122 22 85 22 101 22 117 ;DELTA exception P1
DELTAP1         6 16 90 16 106 16 122 14 85 14 101 14 117 ;DELTA exception P1
                           #--- NPUSHB    26 117 19 101 19 85 19 122 17 106 17 90 17 6 4 117 9 102 9 87 9 3 9 6 0 31 40 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   28        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   28        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   28        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   28        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 28 5 244 28 4 28 2 28 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 15 6 239 15 223 15 159 15 143 15 79 15 63 15 15 15 7 15 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    16 34 5 251 34 11 34 2 34 9 25 12 4 3 21 34 40 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       40         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 21  ;Move Indirect Relative Point
SLOOP           3          ;Set LOOP variable
IP              4 12 25    ;Interpolate Point
MIRP[min,rnd,grey] headstem 34 ;Move Indirect Relative Point
DELTAP1         2 34 11 34 251 ;DELTA exception P1
DELTAP2         5 34 267 34 283 34 299 34 315 34 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 15  ;Move Indirect Relative Point
DELTAP1         7 15 15 15 63 15 79 15 143 15 159 15 223 15 239 ;DELTA exception P1
DELTAP2         6 15 303 15 319 15 367 15 383 15 447 15 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 28 ;Move Indirect Relative Point
DELTAP1         2 28 4 28 244 ;DELTA exception P1
DELTAP2         5 28 260 28 276 28 292 28 308 28 496 ;DELTA exception P2
SRP0            40         ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 0   ;Move Indirect Relative Point
MIRP[min,black] estemtc 9  ;Move Indirect Relative Point
DELTAP1         3 9 87 9 102 9 117 ;DELTA exception P1
MDAP[rnd]       4          ;Move Direct Absolute Point
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 17 90 17 106 17 122 19 85 19 101 19 117 ;DELTA exception P1
""",

    'uni0E08': """
                           #--- NPUSHB    34 122 7 106 7 90 7 117 5 101 5 85 5 6 117 13 101 13 85 13 122 11 106 11 90 11 6 33 26 36 30 19 0 36 3 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 43 6 244 43 144 43 2 43 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 49 5 244 49 4 49 2 49 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    59 9 3 79 9 63 9 47 9 3 9 118 15 102 15 86 15 71 15 55 15 5 15 16 3 118 36 102 36 86 36 71 36 55 36 5 36 16 118 36 102 36 86 36 71 36 55 36 5 36 16 127 22 0 22 2 22 53 29 30 ;PUSH N Bytes
MDAP[rnd]       30         ;Move Direct Absolute Point
MDRP[grey]      29         ;Move Direct Relative Point
SRP0            53         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 22         ;Move Direct Relative Point
DELTAP1         2 22 0 22 127 ;DELTA exception P1
MIRP[min,black] estemw 36  ;Move Indirect Relative Point
DELTAP1         5 36 55 36 71 36 86 36 102 36 118 ;DELTA exception P1
MIRP[min,black] estemw 36  ;Move Indirect Relative Point
DELTAP1         5 36 55 36 71 36 86 36 102 36 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 3          ;Move Direct Relative Point
MIRP[min,black] estemw 15  ;Move Indirect Relative Point
DELTAP1         5 15 55 15 71 15 86 15 102 15 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 9          ;Move Direct Relative Point
DELTAP1         3 9 47 9 63 9 79 ;DELTA exception P1
DELTAP2         3 9 287 9 303 9 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 49 ;Move Indirect Relative Point
DELTAP1         2 49 4 49 244 ;DELTA exception P1
DELTAP2         5 49 260 49 276 49 292 49 308 49 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 43  ;Move Indirect Relative Point
DELTAP1         2 43 144 43 244 ;DELTA exception P1
DELTAP2         6 43 260 43 276 43 292 43 308 43 352 43 368 ;DELTA exception P2
SRP1            3          ;Set Reference Point 1
SRP2            36         ;Set Reference Point 2
IP              0          ;Interpolate Point
IP              19         ;Interpolate Point
SRP1            30         ;Set Reference Point 1
SRP2            36         ;Set Reference Point 2
IP              26         ;Interpolate Point
IP              33         ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 11 90 11 106 11 122 13 85 13 101 13 117 ;DELTA exception P1
DELTAP1         6 5 85 5 101 5 117 7 90 7 106 7 122 ;DELTA exception P1
                           #--- NPUSHB    26 117 10 101 10 85 10 122 8 106 8 90 8 6 29 118 19 103 19 87 19 3 19 10 0 31 52 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 40 5 244 40 4 40 2 40 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 6 6 239 6 223 6 159 6 143 6 79 6 63 6 15 6 7 6 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    33 46 5 251 46 11 46 2 46 9 48 12 1 12 121 26 104 26 88 26 3 26 10 36 23 37 22 16 3 29 7 33 34 52 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       52         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 33  ;Move Indirect Relative Point
SLOOP           7          ;Set LOOP variable
IP              29 3 16 22 37 23 36 ;Interpolate Point
MIRP[min,black] estemt 26  ;Move Indirect Relative Point
DELTAP1         3 26 88 26 104 26 121 ;DELTA exception P1
MDRP[rp0,rnd,grey] 12         ;Move Direct Relative Point
DELTAP1         1 12 48    ;DELTA exception P1
MIRP[min,rnd,grey] headstem 46 ;Move Indirect Relative Point
DELTAP1         2 46 11 46 251 ;DELTA exception P1
DELTAP2         5 46 267 46 283 46 299 46 315 46 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 6   ;Move Indirect Relative Point
DELTAP1         7 6 15 6 63 6 79 6 143 6 159 6 223 6 239 ;DELTA exception P1
DELTAP2         6 6 303 6 319 6 367 6 383 6 447 6 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 40 ;Move Indirect Relative Point
DELTAP1         2 40 4 40 244 ;DELTA exception P1
DELTAP2         5 40 260 40 276 40 292 40 308 40 496 ;DELTA exception P2
SRP0            52         ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 0   ;Move Indirect Relative Point
MIRP[min,black] estemt 19  ;Move Indirect Relative Point
DELTAP1         3 19 87 19 103 19 118 ;DELTA exception P1
MDAP[rnd]       29         ;Move Direct Absolute Point
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 8 90 8 106 8 122 10 85 10 101 10 117 ;DELTA exception P1
""",

    'uni0E09': """
                           #--- NPUSHB    38 117 37 101 37 85 37 122 5 106 5 90 5 117 3 101 3 85 3 122 39 106 39 90 39 12 117 11 101 11 85 11 122 9 106 9 90 9 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 63 5 244 63 4 63 2 63 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 41 6 239 41 223 41 159 41 143 41 79 41 63 41 15 41 7 41 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 57 5 251 57 11 57 2 57 9 ;PUSH N Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   336       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    29 35 5 208 35 192 35 176 35 112 35 96 35 80 35 6 35 118 31 102 31 86 31 71 31 55 31 5 31 16 ;PUSH N Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    14 16 1 223 16 32 16 16 16 0 16 4 16 67 24 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 45 6 244 45 144 45 2 45 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 51 5 244 51 4 51 2 51 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    36 7 3 79 7 63 7 47 7 3 7 0 118 14 102 14 86 14 71 14 55 14 5 14 16 64 1 48 1 32 1 16 1 0 1 5 1 ;PUSH N Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
DELTAP1         5 1 0 1 16 1 32 1 48 1 64 ;DELTA exception P1
MIRP[min,black] estemw 14  ;Move Indirect Relative Point
DELTAP1         5 14 55 14 71 14 86 14 102 14 118 ;DELTA exception P1
SHP[rp2]        0          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 7          ;Move Direct Relative Point
DELTAP1         3 7 47 7 63 7 79 ;DELTA exception P1
DELTAP2         3 7 287 7 303 7 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 51 ;Move Indirect Relative Point
DELTAP1         2 51 4 51 244 ;DELTA exception P1
DELTAP2         5 51 260 51 276 51 292 51 308 51 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 45  ;Move Indirect Relative Point
DELTAP1         2 45 144 45 244 ;DELTA exception P1
DELTAP2         6 45 260 45 276 45 292 45 308 45 352 45 368 ;DELTA exception P2
MDRP[rnd,grey]  24         ;Move Direct Relative Point
SRP0            67         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 16         ;Move Direct Relative Point
DELTAP1         4 16 0 16 16 16 32 16 223 ;DELTA exception P1
DELTAP2         1 16 303   ;DELTA exception P2
MIRP[min,black] estemw 31  ;Move Indirect Relative Point
DELTAP1         5 31 55 31 71 31 86 31 102 31 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 35         ;Move Direct Relative Point
DELTAP1         6 35 80 35 96 35 112 35 176 35 192 35 208 ;DELTA exception P1
DELTAP2         5 35 256 35 272 35 288 35 336 35 352 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 57 ;Move Indirect Relative Point
DELTAP1         2 57 11 57 251 ;DELTA exception P1
DELTAP2         5 57 267 57 283 57 299 57 315 57 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 41  ;Move Indirect Relative Point
DELTAP1         7 41 15 41 63 41 79 41 143 41 159 41 223 41 239 ;DELTA exception P1
DELTAP2         6 41 303 41 319 41 367 41 383 41 447 41 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 63 ;Move Indirect Relative Point
DELTAP1         2 63 4 63 244 ;DELTA exception P1
DELTAP2         5 63 260 63 276 63 292 63 308 63 496 ;DELTA exception P2
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 9 90 9 106 9 122 11 85 11 101 11 117 ;DELTA exception P1
DELTAP1         12 39 90 39 106 39 122 3 85 3 101 3 117 5 90 5 106 5 122 37 85 37 101 37 117 ;DELTA exception P1
                           #--- NPUSHB    26 122 36 106 36 90 36 117 34 101 34 85 34 6 122 6 106 6 90 6 117 8 101 8 85 8 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    11 60 5 251 60 11 60 2 60 9 16 41 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 32 6 224 32 208 32 144 32 128 32 64 32 48 32 0 32 7 32 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    12 54 5 244 54 4 54 2 54 9 38 31 0 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 42 5 244 42 4 42 2 42 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 4 6 239 4 223 4 159 4 143 4 79 4 63 4 15 4 7 4 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    36 48 5 251 48 11 48 2 48 9 10 23 121 20 104 20 88 20 3 20 10 23 31 17 3 27 34 118 15 103 15 87 15 3 15 10 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
MIRP[min,black] estemt 15  ;Move Indirect Relative Point
DELTAP1         3 15 87 15 103 15 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_34 27  ;Move Indirect Relative Point
SLOOP           3          ;Set LOOP variable
IP              17 31 23   ;Interpolate Point
MIRP[min,black] estemt 20  ;Move Indirect Relative Point
DELTAP1         3 20 88 20 104 20 121 ;DELTA exception P1
MDAP[rnd]       23         ;Move Direct Absolute Point
MDRP[rp0,min,rnd,white] 10         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 48 ;Move Indirect Relative Point
DELTAP1         2 48 11 48 251 ;DELTA exception P1
DELTAP2         5 48 267 48 283 48 299 48 315 48 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 4   ;Move Indirect Relative Point
DELTAP1         7 4 15 4 63 4 79 4 143 4 159 4 223 4 239 ;DELTA exception P1
DELTAP2         6 4 303 4 319 4 367 4 383 4 447 4 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 42 ;Move Indirect Relative Point
DELTAP1         2 42 4 42 244 ;DELTA exception P1
DELTAP2         5 42 260 42 276 42 292 42 308 42 496 ;DELTA exception P2
SRP0            0          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 38  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 54 ;Move Indirect Relative Point
DELTAP1         2 54 4 54 244 ;DELTA exception P1
DELTAP2         5 54 260 54 276 54 292 54 308 54 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 32  ;Move Indirect Relative Point
DELTAP1         7 32 0 32 48 32 64 32 128 32 144 32 208 32 224 ;DELTA exception P1
DELTAP2         6 32 288 32 304 32 352 32 368 32 432 32 448 ;DELTA exception P2
IP              41         ;Interpolate Point
IP              16         ;Interpolate Point
MIRP[min,rnd,grey] headstem 60 ;Move Indirect Relative Point
DELTAP1         2 60 11 60 251 ;DELTA exception P1
DELTAP2         5 60 267 60 283 60 299 60 315 60 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 8 85 8 101 8 117 6 90 6 106 6 122 ;DELTA exception P1
DELTAP1         6 34 85 34 101 34 117 36 90 36 106 36 122 ;DELTA exception P1
""",

    'uni0E0A': """
                           #--- NPUSHB    14 117 15 101 15 85 15 122 17 106 17 90 17 6 34 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    89 112 34 96 34 80 34 68 34 4 34 25 40 118 25 102 25 86 25 71 25 55 25 5 25 16 127 4 111 4 95 4 79 4 47 4 31 4 6 4 118 42 102 42 86 42 71 42 55 42 5 42 16 64 1 1 1 37 118 30 102 30 86 30 71 30 55 30 5 30 16 28 118 36 102 36 86 36 71 36 55 36 5 36 16 127 37 1 37 57 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 53 6 251 53 159 53 2 53 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 47 5 251 47 11 47 2 47 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    45 13 6 224 13 208 13 144 13 128 13 64 13 48 13 0 13 7 13 37 118 10 102 10 86 10 71 10 55 10 5 10 16 175 19 159 19 143 19 127 19 111 19 5 19 56 ;PUSH N Bytes
SRP0            56         ;Set Reference Point 0
MDRP[rp0,rnd,white] 19         ;Move Direct Relative Point
DELTAP1         5 19 111 19 127 19 143 19 159 19 175 ;DELTA exception P1
MIRP[min,black] estemw 10  ;Move Indirect Relative Point
DELTAP1         5 10 55 10 71 10 86 10 102 10 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_37 13  ;Move Indirect Relative Point
DELTAP1         7 13 0 13 48 13 64 13 128 13 144 13 208 13 224 ;DELTA exception P1
DELTAP2         6 13 288 13 304 13 352 13 368 13 432 13 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 47 ;Move Indirect Relative Point
DELTAP1         2 47 11 47 251 ;DELTA exception P1
DELTAP2         5 47 267 47 283 47 299 47 315 47 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 53  ;Move Indirect Relative Point
DELTAP1         2 53 159 53 251 ;DELTA exception P1
DELTAP2         6 53 267 53 283 53 299 53 315 53 367 53 383 ;DELTA exception P2
SRP0            57         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 37         ;Move Direct Relative Point
DELTAP1         1 37 127   ;DELTA exception P1
MIRP[min,black] estemw 36  ;Move Indirect Relative Point
DELTAP1         5 36 55 36 71 36 86 36 102 36 118 ;DELTA exception P1
MDRP[rp0,min,rnd,grey] 28         ;Move Direct Relative Point
MIRP[min,black] estemw 30  ;Move Indirect Relative Point
DELTAP1         5 30 55 30 71 30 86 30 102 30 118 ;DELTA exception P1
SRP0            37         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         1 1 64     ;DELTA exception P1
MIRP[min,black] estemw 42  ;Move Indirect Relative Point
DELTAP1         5 42 55 42 71 42 86 42 102 42 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 4          ;Move Direct Relative Point
DELTAP1         6 4 31 4 47 4 79 4 95 4 111 4 127 ;DELTA exception P1
MIRP[min,black] estemw 25  ;Move Indirect Relative Point
DELTAP1         5 25 55 25 71 25 86 25 102 25 118 ;DELTA exception P1
IP              40         ;Interpolate Point
SRP0            25         ;Set Reference Point 0
MDRP[grey]      34         ;Move Direct Relative Point
DELTAP1         4 34 68 34 80 34 96 34 112 ;DELTA exception P1
SHPIX           -8 34      ;SHift point by a PIXel amount
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 17 90 17 106 17 122 15 85 15 101 15 117 ;DELTA exception P1
                           #--- NPUSHB    20 122 14 106 14 90 14 117 12 101 12 85 12 6 117 25 101 25 85 25 3 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 44 5 244 44 4 44 2 44 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 16 6 239 16 223 16 159 16 143 16 79 16 63 16 15 16 7 16 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    41 50 5 251 50 11 50 2 50 9 10 122 7 105 7 89 7 3 7 10 30 34 40 25 4 36 38 42 2 8 22 34 118 43 103 43 87 43 3 43 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 43  ;Move Indirect Relative Point
DELTAP1         3 43 87 43 103 43 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_34 22  ;Move Indirect Relative Point
SLOOP           8          ;Set LOOP variable
IP              2 42 38 36 4 25 40 34 ;Interpolate Point
MDRP[min,rnd,grey] 30         ;Move Direct Relative Point
MIRP[min,black] estemt 7   ;Move Indirect Relative Point
DELTAP1         3 7 89 7 105 7 122 ;DELTA exception P1
MDRP[rp0,rnd,grey] 10         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 50 ;Move Indirect Relative Point
DELTAP1         2 50 11 50 251 ;DELTA exception P1
DELTAP2         5 50 267 50 283 50 299 50 315 50 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 16  ;Move Indirect Relative Point
DELTAP1         7 16 15 16 63 16 79 16 143 16 159 16 223 16 239 ;DELTA exception P1
DELTAP2         6 16 303 16 319 16 367 16 383 16 447 16 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 44 ;Move Indirect Relative Point
DELTAP1         2 44 4 44 244 ;DELTA exception P1
DELTAP2         5 44 260 44 276 44 292 44 308 44 496 ;DELTA exception P2
DELTAP1         3 25 85 25 101 25 117 ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 12 85 12 101 12 117 14 90 14 106 14 122 ;DELTA exception P1
""",

    'uni0E0B': """
                           #--- NPUSHB    27 122 21 106 21 90 21 117 19 101 19 85 19 6 117 15 101 15 85 15 122 13 106 13 90 13 6 40 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    98 9 8 7 28 27 26 6 31 23 112 40 96 40 80 40 68 40 4 40 31 46 118 31 102 31 86 31 71 31 55 31 5 31 16 127 4 111 4 95 4 79 4 47 4 31 4 6 4 118 49 102 49 86 49 71 49 55 49 5 49 16 64 1 1 1 43 118 36 102 36 86 36 71 36 55 36 5 36 16 34 118 42 102 42 86 42 71 42 55 42 5 42 16 127 43 1 43 63 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 59 6 251 59 159 59 2 59 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 53 5 251 53 11 53 2 53 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    45 17 6 224 17 208 17 144 17 128 17 64 17 48 17 0 17 7 17 37 118 12 102 12 86 12 71 12 55 12 5 12 16 175 23 159 23 143 23 127 23 111 23 5 23 62 ;PUSH N Bytes
SRP0            62         ;Set Reference Point 0
MDRP[rp0,rnd,white] 23         ;Move Direct Relative Point
DELTAP1         5 23 111 23 127 23 143 23 159 23 175 ;DELTA exception P1
MIRP[min,black] estemw 12  ;Move Indirect Relative Point
DELTAP1         5 12 55 12 71 12 86 12 102 12 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_37 17  ;Move Indirect Relative Point
DELTAP1         7 17 0 17 48 17 64 17 128 17 144 17 208 17 224 ;DELTA exception P1
DELTAP2         6 17 288 17 304 17 352 17 368 17 432 17 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 53 ;Move Indirect Relative Point
DELTAP1         2 53 11 53 251 ;DELTA exception P1
DELTAP2         5 53 267 53 283 53 299 53 315 53 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 59  ;Move Indirect Relative Point
DELTAP1         2 59 159 59 251 ;DELTA exception P1
DELTAP2         6 59 267 59 283 59 299 59 315 59 367 59 383 ;DELTA exception P2
SRP0            63         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 43         ;Move Direct Relative Point
DELTAP1         1 43 127   ;DELTA exception P1
MIRP[min,black] estemw 42  ;Move Indirect Relative Point
DELTAP1         5 42 55 42 71 42 86 42 102 42 118 ;DELTA exception P1
MDRP[rp0,min,rnd,grey] 34         ;Move Direct Relative Point
MIRP[min,black] estemw 36  ;Move Indirect Relative Point
DELTAP1         5 36 55 36 71 36 86 36 102 36 118 ;DELTA exception P1
SRP0            43         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         1 1 64     ;DELTA exception P1
MIRP[min,black] estemw 49  ;Move Indirect Relative Point
DELTAP1         5 49 55 49 71 49 86 49 102 49 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 4          ;Move Direct Relative Point
DELTAP1         6 4 31 4 47 4 79 4 95 4 111 4 127 ;DELTA exception P1
MIRP[min,black] estemw 31  ;Move Indirect Relative Point
DELTAP1         5 31 55 31 71 31 86 31 102 31 118 ;DELTA exception P1
IP              46         ;Interpolate Point
SRP0            31         ;Set Reference Point 0
MDRP[grey]      40         ;Move Direct Relative Point
DELTAP1         4 40 68 40 80 40 96 40 112 ;DELTA exception P1
SRP1            23         ;Set Reference Point 1
SRP2            31         ;Set Reference Point 2
SLOOP           6          ;Set LOOP variable
IP              26 27 28 7 8 9 ;Interpolate Point
SHPIX           -8 40      ;SHift point by a PIXel amount
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 13 90 13 106 13 122 15 85 15 101 15 117 ;DELTA exception P1
DELTAP1         6 19 85 19 101 19 117 21 90 21 106 21 122 ;DELTA exception P1
                           #--- NPUSHB    20 122 18 106 18 90 18 117 16 101 16 85 16 6 117 31 101 31 85 31 3 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 50 5 244 50 4 50 2 50 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 20 6 239 20 223 20 159 20 143 20 79 20 63 20 15 20 7 20 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    65 56 5 251 56 11 56 2 56 9 14 14 27 197 8 181 8 165 8 149 8 133 8 53 8 37 8 21 8 5 8 9 8 9 121 7 104 7 88 7 3 7 10 36 26 40 46 31 4 42 44 48 2 8 28 34 118 49 103 49 87 49 3 49 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 49  ;Move Indirect Relative Point
DELTAP1         3 49 87 49 103 49 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_34 28  ;Move Indirect Relative Point
SLOOP           8          ;Set LOOP variable
IP              2 48 44 42 4 31 46 40 ;Interpolate Point
ALIGNRP         26         ;ALIGN to Reference Point
MDRP[min,rnd,grey] 36         ;Move Direct Relative Point
MIRP[min,black] estemt 7   ;Move Indirect Relative Point
DELTAP1         3 7 88 7 104 7 121 ;DELTA exception P1
SHP[rp2]        9          ;SHift Point using reference point
MDRP[rp0,min,rnd,grey] 8          ;Move Direct Relative Point
DELTAP1         9 8 5 8 21 8 37 8 53 8 133 8 149 8 165 8 181 8 197 ;DELTA exception P1
MDRP[black]     27         ;Move Direct Relative Point
MDRP[rp0,rnd,grey] 14         ;Move Direct Relative Point
MDAP[rnd]       14         ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 56 ;Move Indirect Relative Point
DELTAP1         2 56 11 56 251 ;DELTA exception P1
DELTAP2         5 56 267 56 283 56 299 56 315 56 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 20  ;Move Indirect Relative Point
DELTAP1         7 20 15 20 63 20 79 20 143 20 159 20 223 20 239 ;DELTA exception P1
DELTAP2         6 20 303 20 319 20 367 20 383 20 447 20 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 50 ;Move Indirect Relative Point
DELTAP1         2 50 4 50 244 ;DELTA exception P1
DELTAP2         5 50 260 50 276 50 292 50 308 50 496 ;DELTA exception P2
DELTAP1         3 31 85 31 101 31 117 ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 16 85 16 101 16 117 18 90 18 106 18 122 ;DELTA exception P1
""",

    'uni0E0C': """
                           #--- NPUSHB    42 117 30 101 30 85 30 122 6 106 6 90 6 117 4 101 4 85 4 122 32 106 32 90 32 12 117 26 101 26 85 26 122 24 106 24 90 24 6 15 41 44 38 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 64 5 251 64 11 64 2 64 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   2         ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   2         ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   2         ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   2         ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   2         ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 2 6 224 2 208 2 144 2 128 2 64 2 48 2 0 2 7 2 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   70        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   70        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   70        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   70        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    52 70 5 244 70 4 70 2 70 9 79 8 1 8 8 11 28 118 44 102 44 86 44 71 44 55 44 5 44 16 11 11 46 34 1 118 48 102 48 86 48 71 48 55 48 5 48 16 127 46 1 46 74 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 58 6 251 58 159 58 2 58 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 52 5 251 52 11 52 2 52 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   28        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    12 28 2 112 28 64 28 48 28 3 28 34 18 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    42 18 22 38 20 22 37 155 38 139 38 123 38 107 38 91 38 27 38 11 38 7 38 118 22 102 22 86 22 71 22 55 22 5 22 16 16 34 0 34 2 34 73 ;PUSH N Bytes
SRP0            73         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 34         ;Move Direct Relative Point
DELTAP1         2 34 0 34 16 ;DELTA exception P1
MIRP[min,black] estemw 22  ;Move Indirect Relative Point
DELTAP1         5 22 55 22 71 22 86 22 102 22 118 ;DELTA exception P1
MDRP[rp0,grey]  38         ;Move Direct Relative Point
DELTAP1         7 38 11 38 27 38 91 38 107 38 123 38 139 38 155 ;DELTA exception P1
MDRP[grey]      37         ;Move Direct Relative Point
SRP0            22         ;Set Reference Point 0
MDRP[grey]      20         ;Move Direct Relative Point
SRP1            38         ;Set Reference Point 1
SRP2            22         ;Set Reference Point 2
IP              18         ;Interpolate Point
SHPIX           -8 18      ;SHift point by a PIXel amount
SRP0            34         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 28         ;Move Direct Relative Point
DELTAP1         3 28 48 28 64 28 112 ;DELTA exception P1
DELTAP2         2 28 256 28 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 52 ;Move Indirect Relative Point
DELTAP1         2 52 11 52 251 ;DELTA exception P1
DELTAP2         5 52 267 52 283 52 299 52 315 52 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 58  ;Move Indirect Relative Point
DELTAP1         2 58 159 58 251 ;DELTA exception P1
DELTAP2         6 58 267 58 283 58 299 58 315 58 367 58 383 ;DELTA exception P2
SRP0            74         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 46         ;Move Direct Relative Point
DELTAP1         1 46 127   ;DELTA exception P1
MIRP[min,black] estemw 48  ;Move Indirect Relative Point
DELTAP1         5 48 55 48 71 48 86 48 102 48 118 ;DELTA exception P1
ALIGNRP         1          ;ALIGN to Reference Point
SRP1            34         ;Set Reference Point 1
SRP2            46         ;Set Reference Point 2
IP              11         ;Interpolate Point
MDAP[rnd]       11         ;Move Direct Absolute Point
MIRP[min,black] estemw 44  ;Move Indirect Relative Point
DELTAP1         5 44 55 44 71 44 86 44 102 44 118 ;DELTA exception P1
SRP1            28         ;Set Reference Point 1
SRP2            11         ;Set Reference Point 2
IP              8          ;Interpolate Point
MDAP[rnd]       8          ;Move Direct Absolute Point
DELTAP1         1 8 79     ;DELTA exception P1
MIRP[min,rnd,grey] headstem 70 ;Move Indirect Relative Point
DELTAP1         2 70 4 70 244 ;DELTA exception P1
DELTAP2         5 70 260 70 276 70 292 70 308 70 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 2   ;Move Indirect Relative Point
DELTAP1         7 2 0 2 48 2 64 2 128 2 144 2 208 2 224 ;DELTA exception P1
DELTAP2         6 2 288 2 304 2 352 2 368 2 432 2 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 64 ;Move Indirect Relative Point
DELTAP1         2 64 11 64 251 ;DELTA exception P1
DELTAP2         5 64 267 64 283 64 299 64 315 64 511 ;DELTA exception P2
SRP1            38         ;Set Reference Point 1
SRP2            44         ;Set Reference Point 2
IP              41         ;Interpolate Point
IP              15         ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 24 90 24 106 24 122 26 85 26 101 26 117 ;DELTA exception P1
DELTAP1         12 32 90 32 106 32 122 4 85 4 101 4 117 6 90 6 106 6 122 30 85 30 101 30 117 ;DELTA exception P1
                           #--- NPUSHB    34 122 29 106 29 90 29 117 27 101 27 85 27 6 122 7 106 7 90 7 117 9 101 9 85 9 6 122 2 106 2 90 2 3 67 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    12 55 5 251 55 11 55 2 55 9 2 11 45 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    20 25 6 224 25 208 25 144 25 128 25 64 25 48 25 0 25 7 25 37 61 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    33 49 5 244 49 4 49 2 49 9 5 31 31 1 121 15 104 15 88 15 3 15 10 44 12 20 19 18 38 37 35 8 41 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   48 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    23 48 8 255 48 223 48 143 48 111 48 4 48 4 118 46 103 46 87 46 3 46 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 46  ;Move Indirect Relative Point
DELTAP1         3 46 87 46 103 46 118 ;DELTA exception P1
MIRP[rnd,grey]  tvheight 48 ;Move Indirect Relative Point
DELTAP1         4 48 111 48 143 48 223 48 255 ;DELTA exception P1
DELTAP2         8 48 287 48 335 48 367 48 399 48 431 48 447 48 479 48 511 ;DELTA exception P2
DELTAP3         1 48 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 41  ;Move Indirect Relative Point
SLOOP           8          ;Set LOOP variable
IP              35 37 38 18 19 20 12 44 ;Interpolate Point
MIRP[min,black] estemt 15  ;Move Indirect Relative Point
DELTAP1         3 15 88 15 104 15 121 ;DELTA exception P1
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 31  ;Move Indirect Relative Point
ALIGNRP         5          ;ALIGN to Reference Point
MIRP[min,rnd,grey] headstem 49 ;Move Indirect Relative Point
DELTAP1         2 49 4 49 244 ;DELTA exception P1
DELTAP2         5 49 260 49 276 49 292 49 308 49 496 ;DELTA exception P2
SHP[rp2]        61         ;SHift Point using reference point
MIRP[rp0,rnd,grey] cvt_37 25  ;Move Indirect Relative Point
DELTAP1         7 25 0 25 48 25 64 25 128 25 144 25 208 25 224 ;DELTA exception P1
DELTAP2         6 25 288 25 304 25 352 25 368 25 432 25 448 ;DELTA exception P2
ALIGNRP         45         ;ALIGN to Reference Point
IP              11         ;Interpolate Point
IP              2          ;Interpolate Point
MIRP[min,rnd,grey] headstem 55 ;Move Indirect Relative Point
DELTAP1         2 55 11 55 251 ;DELTA exception P1
DELTAP2         5 55 267 55 283 55 299 55 315 55 511 ;DELTA exception P2
SHP[rp2]        67         ;SHift Point using reference point
DELTAP1         3 2 90 2 106 2 122 ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 9 85 9 101 9 117 7 90 7 106 7 122 ;DELTA exception P1
DELTAP1         6 27 85 27 101 27 117 29 90 29 106 29 122 ;DELTA exception P1
""",

    'uni0E0D': """
                           #--- NPUSHB    51 122 6 106 6 90 6 122 36 106 36 90 36 117 34 101 34 85 34 117 4 101 4 85 4 12 122 10 106 10 90 10 117 12 101 12 85 12 117 42 101 42 85 42 122 40 106 40 90 40 12 18 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    39 68 8 24 50 53 47 73 9 8 3 18 13 3 68 1 118 53 102 53 86 53 71 53 55 53 5 53 16 127 20 1 20 77 27 29 31 46 47 43 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 57 6 244 57 144 57 2 57 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 63 5 244 63 4 63 2 63 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    34 38 3 79 38 63 38 47 38 3 38 118 31 102 31 86 31 71 31 55 31 5 31 16 175 43 32 43 16 43 0 43 4 43 76 ;PUSH N Bytes
SRP0            76         ;Set Reference Point 0
MDRP[rp0,rnd,white] 43         ;Move Direct Relative Point
DELTAP1         4 43 0 43 16 43 32 43 175 ;DELTA exception P1
MIRP[min,black] estemw 31  ;Move Indirect Relative Point
DELTAP1         5 31 55 31 71 31 86 31 102 31 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 38         ;Move Direct Relative Point
DELTAP1         3 38 47 38 63 38 79 ;DELTA exception P1
DELTAP2         3 38 287 38 303 38 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 63 ;Move Indirect Relative Point
DELTAP1         2 63 4 63 244 ;DELTA exception P1
DELTAP2         5 63 260 63 276 63 292 63 308 63 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 57  ;Move Indirect Relative Point
DELTAP1         2 57 144 57 244 ;DELTA exception P1
DELTAP2         6 57 260 57 276 57 292 57 308 57 352 57 368 ;DELTA exception P2
SRP0            43         ;Set Reference Point 0
MDRP[rp0,grey]  47         ;Move Direct Relative Point
MDRP[grey]      46         ;Move Direct Relative Point
SRP0            31         ;Set Reference Point 0
MDRP[rp0,grey]  29         ;Move Direct Relative Point
MDRP[grey]      27         ;Move Direct Relative Point
SRP0            77         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 20         ;Move Direct Relative Point
DELTAP1         1 20 127   ;DELTA exception P1
MIRP[min,black] estemw 53  ;Move Indirect Relative Point
DELTAP1         5 53 55 53 71 53 86 53 102 53 118 ;DELTA exception P1
ALIGNRP         1          ;ALIGN to Reference Point
MDRP[rnd,grey]  68         ;Move Direct Relative Point
SLOOP           3          ;Set LOOP variable
IP              13 18 3    ;Interpolate Point
MDRP[rp0,rnd,grey] 8          ;Move Direct Relative Point
MIRP[min,black] headstem 73 ;Move Indirect Relative Point
SRP1            47         ;Set Reference Point 1
SRP2            53         ;Set Reference Point 2
IP              50         ;Interpolate Point
IP              24         ;Interpolate Point
SHPIX           8 68       ;SHift point by a PIXel amount
SHPIX           -8 18      ;SHift point by a PIXel amount
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 40 90 40 106 40 122 42 85 42 101 42 117 12 85 12 101 12 117 10 90 10 106 10 122 ;DELTA exception P1
DELTAP1         12 4 85 4 101 4 117 34 85 34 101 34 117 36 90 36 106 36 122 6 90 6 106 6 122 ;DELTA exception P1
                           #--- NPUSHB    26 117 39 101 39 85 39 122 37 106 37 90 37 122 7 106 7 90 7 117 9 101 9 85 9 12 13 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    17 3 8 70 7 20 18 3 68 13 5 11 66 7 1 5 0 76 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 60 5 251 60 11 60 2 60 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 41 6 224 41 208 41 144 41 128 41 64 41 48 41 0 41 7 41 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    34 54 5 244 54 4 54 2 54 9 35 31 76 121 24 104 24 88 24 3 24 10 53 21 31 29 28 27 47 46 44 9 50 34 76 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       76         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 50  ;Move Indirect Relative Point
SLOOP           9          ;Set LOOP variable
IP              44 46 47 27 28 29 31 21 53 ;Interpolate Point
MIRP[min,black] estemt 24  ;Move Indirect Relative Point
DELTAP1         3 24 88 24 104 24 121 ;DELTA exception P1
SRP0            76         ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 35  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 54 ;Move Indirect Relative Point
DELTAP1         2 54 4 54 244 ;DELTA exception P1
DELTAP2         5 54 260 54 276 54 292 54 308 54 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 41  ;Move Indirect Relative Point
DELTAP1         7 41 0 41 48 41 64 41 128 41 144 41 208 41 224 ;DELTA exception P1
DELTAP2         6 41 288 41 304 41 352 41 368 41 432 41 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 60 ;Move Indirect Relative Point
DELTAP1         2 60 11 60 251 ;DELTA exception P1
DELTAP2         5 60 267 60 283 60 299 60 315 60 511 ;DELTA exception P2
SRP0            76         ;Set Reference Point 0
MIRP[rp0,rnd,grey] evheight_lu 5 ;Move Indirect Relative Point
ALIGNRP         1          ;ALIGN to Reference Point
MIRP[min,black] cvt_7 66   ;Move Indirect Relative Point
MDRP[rp0,rnd,grey] 11         ;Move Direct Relative Point
SLOOP           5          ;Set LOOP variable
IP              13 68 3 18 20 ;Interpolate Point
MIRP[min,black] cvt_7 70   ;Move Indirect Relative Point
SHPIX           8 3        ;SHift point by a PIXel amount
SHPIX           -8 13      ;SHift point by a PIXel amount
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 9 85 9 101 9 117 7 90 7 106 7 122 37 90 37 106 37 122 39 85 39 101 39 117 ;DELTA exception P1
""",

    'uni0E0D.descless': """
                           #--- NPUSHB    65 122 22 106 22 90 22 117 20 101 20 85 20 6 122 14 106 14 90 14 117 16 101 16 85 16 6 5 31 34 28 118 34 102 34 86 34 71 34 55 34 5 34 16 1 1 36 24 118 38 102 38 86 38 71 38 55 38 5 38 16 127 36 1 36 52 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 48 6 251 48 159 48 2 48 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 42 5 251 42 11 42 2 42 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    12 18 2 112 18 64 18 48 18 3 18 24 8 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    42 8 12 28 10 12 27 155 28 139 28 123 28 107 28 91 28 27 28 11 28 7 28 118 12 102 12 86 12 71 12 55 12 5 12 16 16 24 0 24 2 24 51 ;PUSH N Bytes
SRP0            51         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 24         ;Move Direct Relative Point
DELTAP1         2 24 0 24 16 ;DELTA exception P1
MIRP[min,black] estemw 12  ;Move Indirect Relative Point
DELTAP1         5 12 55 12 71 12 86 12 102 12 118 ;DELTA exception P1
MDRP[rp0,grey]  28         ;Move Direct Relative Point
DELTAP1         7 28 11 28 27 28 91 28 107 28 123 28 139 28 155 ;DELTA exception P1
MDRP[grey]      27         ;Move Direct Relative Point
SRP0            12         ;Set Reference Point 0
MDRP[grey]      10         ;Move Direct Relative Point
SRP1            28         ;Set Reference Point 1
SRP2            12         ;Set Reference Point 2
IP              8          ;Interpolate Point
SHPIX           -8 8       ;SHift point by a PIXel amount
SRP0            24         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 18         ;Move Direct Relative Point
DELTAP1         3 18 48 18 64 18 112 ;DELTA exception P1
DELTAP2         2 18 256 18 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 42 ;Move Indirect Relative Point
DELTAP1         2 42 11 42 251 ;DELTA exception P1
DELTAP2         5 42 267 42 283 42 299 42 315 42 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 48  ;Move Indirect Relative Point
DELTAP1         2 48 159 48 251 ;DELTA exception P1
DELTAP2         6 48 267 48 283 48 299 48 315 48 367 48 383 ;DELTA exception P2
SRP0            52         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 36         ;Move Direct Relative Point
DELTAP1         1 36 127   ;DELTA exception P1
MIRP[min,black] estemw 38  ;Move Indirect Relative Point
DELTAP1         5 38 55 38 71 38 86 38 102 38 118 ;DELTA exception P1
SRP1            24         ;Set Reference Point 1
SRP2            36         ;Set Reference Point 2
IP              1          ;Interpolate Point
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemw 34  ;Move Indirect Relative Point
DELTAP1         5 34 55 34 71 34 86 34 102 34 118 ;DELTA exception P1
SRP1            28         ;Set Reference Point 1
SRP2            34         ;Set Reference Point 2
IP              31         ;Interpolate Point
IP              5          ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 16 85 16 101 16 117 14 90 14 106 14 122 ;DELTA exception P1
DELTAP1         6 20 85 20 101 20 117 22 90 22 106 22 122 ;DELTA exception P1
                           #--- NPUSHB    13 122 19 106 19 90 19 117 17 101 17 85 17 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 45 5 251 45 11 45 2 45 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 15 6 224 15 208 15 144 15 128 15 64 15 48 15 0 15 7 15 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    33 39 5 244 39 4 39 2 39 9 21 31 1 121 5 104 5 88 5 3 5 10 34 2 12 10 9 8 28 27 25 9 31 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   38 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    23 38 8 255 38 223 38 143 38 111 38 4 38 4 118 35 103 35 87 35 3 35 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 35  ;Move Indirect Relative Point
DELTAP1         3 35 87 35 103 35 118 ;DELTA exception P1
MIRP[rnd,grey]  tvheight 38 ;Move Indirect Relative Point
DELTAP1         4 38 111 38 143 38 223 38 255 ;DELTA exception P1
DELTAP2         8 38 287 38 335 38 367 38 399 38 431 38 447 38 479 38 511 ;DELTA exception P2
DELTAP3         1 38 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 31  ;Move Indirect Relative Point
SLOOP           9          ;Set LOOP variable
IP              25 27 28 8 9 10 12 2 34 ;Interpolate Point
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
DELTAP1         3 5 88 5 104 5 121 ;DELTA exception P1
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 21  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 39 ;Move Indirect Relative Point
DELTAP1         2 39 4 39 244 ;DELTA exception P1
DELTAP2         5 39 260 39 276 39 292 39 308 39 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 15  ;Move Indirect Relative Point
DELTAP1         7 15 0 15 48 15 64 15 128 15 144 15 208 15 224 ;DELTA exception P1
DELTAP2         6 15 288 15 304 15 352 15 368 15 432 15 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 45 ;Move Indirect Relative Point
DELTAP1         2 45 11 45 251 ;DELTA exception P1
DELTAP2         5 45 267 45 283 45 299 45 315 45 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 17 85 17 101 17 117 19 90 19 106 19 122 ;DELTA exception P1
""",

    'uni0E0F': """
                           #--- NPUSHB    51 117 7 101 7 85 7 122 42 106 42 90 42 122 9 106 9 90 9 117 40 101 40 85 40 12 117 15 101 15 85 15 122 46 106 46 90 46 122 13 106 13 90 13 117 48 101 48 85 48 12 21 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    43 74 8 30 56 59 53 80 9 11 6 3 2 24 23 21 16 7 74 1 118 59 102 59 86 59 71 59 55 59 5 59 16 127 26 1 26 83 33 35 37 52 53 49 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 63 6 244 63 144 63 2 63 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   69        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   69        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   69        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   69        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 69 5 244 69 4 69 2 69 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    34 44 3 79 44 63 44 47 44 3 44 118 37 102 37 86 37 71 37 55 37 5 37 16 175 49 32 49 16 49 0 49 4 49 82 ;PUSH N Bytes
SRP0            82         ;Set Reference Point 0
MDRP[rp0,rnd,white] 49         ;Move Direct Relative Point
DELTAP1         4 49 0 49 16 49 32 49 175 ;DELTA exception P1
MIRP[min,black] estemw 37  ;Move Indirect Relative Point
DELTAP1         5 37 55 37 71 37 86 37 102 37 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 44         ;Move Direct Relative Point
DELTAP1         3 44 47 44 63 44 79 ;DELTA exception P1
DELTAP2         3 44 287 44 303 44 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 69 ;Move Indirect Relative Point
DELTAP1         2 69 4 69 244 ;DELTA exception P1
DELTAP2         5 69 260 69 276 69 292 69 308 69 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 63  ;Move Indirect Relative Point
DELTAP1         2 63 144 63 244 ;DELTA exception P1
DELTAP2         6 63 260 63 276 63 292 63 308 63 352 63 368 ;DELTA exception P2
SRP0            49         ;Set Reference Point 0
MDRP[rp0,grey]  53         ;Move Direct Relative Point
MDRP[grey]      52         ;Move Direct Relative Point
SRP0            37         ;Set Reference Point 0
MDRP[rp0,grey]  35         ;Move Direct Relative Point
MDRP[grey]      33         ;Move Direct Relative Point
SRP0            83         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 26         ;Move Direct Relative Point
DELTAP1         1 26 127   ;DELTA exception P1
MIRP[min,black] estemw 59  ;Move Indirect Relative Point
DELTAP1         5 59 55 59 71 59 86 59 102 59 118 ;DELTA exception P1
ALIGNRP         1          ;ALIGN to Reference Point
MDRP[rnd,grey]  74         ;Move Direct Relative Point
SLOOP           7          ;Set LOOP variable
IP              16 21 23 24 2 3 6 ;Interpolate Point
MDRP[rp0,rnd,grey] 11         ;Move Direct Relative Point
MIRP[min,black] headstem 80 ;Move Indirect Relative Point
SRP1            53         ;Set Reference Point 1
SRP2            59         ;Set Reference Point 2
IP              56         ;Interpolate Point
IP              30         ;Interpolate Point
SHPIX           8 74       ;SHift point by a PIXel amount
SHPIX           -8 21      ;SHift point by a PIXel amount
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 48 85 48 101 48 117 13 90 13 106 13 122 46 90 46 106 46 122 15 85 15 101 15 117 ;DELTA exception P1
DELTAP1         12 40 85 40 101 40 117 9 90 9 106 9 122 42 90 42 106 42 122 7 85 7 101 7 117 ;DELTA exception P1
                           #--- NPUSHB    26 117 45 101 45 85 45 117 12 101 12 85 12 122 43 106 43 90 43 122 10 106 10 90 10 12 16 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    19 6 8 76 7 6 2 24 23 11 16 6 14 72 7 1 4 8 0 82 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   66        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   66        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   66        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   66        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 66 5 251 66 11 66 2 66 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 47 6 224 47 208 47 144 47 128 47 64 47 48 47 0 47 7 47 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    34 60 5 244 60 4 60 2 60 9 41 31 82 121 30 104 30 88 30 3 30 10 59 27 37 35 34 33 53 52 50 9 56 34 82 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       82         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 56  ;Move Indirect Relative Point
SLOOP           9          ;Set LOOP variable
IP              50 52 53 33 34 35 37 27 59 ;Interpolate Point
MIRP[min,black] estemt 30  ;Move Indirect Relative Point
DELTAP1         3 30 88 30 104 30 121 ;DELTA exception P1
SRP0            82         ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 41  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 60 ;Move Indirect Relative Point
DELTAP1         2 60 4 60 244 ;DELTA exception P1
DELTAP2         5 60 260 60 276 60 292 60 308 60 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 47  ;Move Indirect Relative Point
DELTAP1         7 47 0 47 48 47 64 47 128 47 144 47 208 47 224 ;DELTA exception P1
DELTAP2         6 47 288 47 304 47 352 47 368 47 432 47 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 66 ;Move Indirect Relative Point
DELTAP1         2 66 11 66 251 ;DELTA exception P1
DELTAP2         5 66 267 66 283 66 299 66 315 66 511 ;DELTA exception P2
SRP0            82         ;Set Reference Point 0
MIRP[rp0,rnd,grey] evheight_lu 8 ;Move Indirect Relative Point
ALIGNRP         4          ;ALIGN to Reference Point
ALIGNRP         1          ;ALIGN to Reference Point
MIRP[min,black] cvt_7 72   ;Move Indirect Relative Point
MDRP[rp0,rnd,grey] 14         ;Move Direct Relative Point
SLOOP           6          ;Set LOOP variable
IP              16 11 23 24 2 6 ;Interpolate Point
MIRP[min,black] cvt_7 76   ;Move Indirect Relative Point
SHPIX           8 6        ;SHift point by a PIXel amount
SHPIX           -8 16      ;SHift point by a PIXel amount
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 10 90 10 106 10 122 43 90 43 106 43 122 12 85 12 101 12 117 45 85 45 101 45 117 ;DELTA exception P1
""",

    'uni0E10': """
                           #--- NPUSHB    96 122 28 106 28 90 28 117 26 101 26 85 26 6 117 22 101 22 85 22 122 20 106 20 90 20 6 16 15 14 35 34 33 6 38 30 6 9 42 118 38 102 38 86 38 71 38 55 38 5 38 16 11 118 40 102 40 86 40 71 40 55 40 5 40 16 7 42 1 8 95 8 1 8 8 1 30 118 46 102 46 86 46 71 46 55 46 5 46 16 127 1 0 1 2 1 60 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 56 6 251 56 159 56 2 56 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 50 5 251 50 11 50 2 50 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    45 24 6 224 24 208 24 144 24 128 24 64 24 48 24 0 24 7 24 37 118 19 102 19 86 19 71 19 55 19 5 19 16 175 30 159 30 143 30 127 30 111 30 5 30 59 ;PUSH N Bytes
SRP0            59         ;Set Reference Point 0
MDRP[rp0,rnd,white] 30         ;Move Direct Relative Point
DELTAP1         5 30 111 30 127 30 143 30 159 30 175 ;DELTA exception P1
MIRP[min,black] estemw 19  ;Move Indirect Relative Point
DELTAP1         5 19 55 19 71 19 86 19 102 19 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_37 24  ;Move Indirect Relative Point
DELTAP1         7 24 0 24 48 24 64 24 128 24 144 24 208 24 224 ;DELTA exception P1
DELTAP2         6 24 288 24 304 24 352 24 368 24 432 24 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 50 ;Move Indirect Relative Point
DELTAP1         2 50 11 50 251 ;DELTA exception P1
DELTAP2         5 50 267 50 283 50 299 50 315 50 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 56  ;Move Indirect Relative Point
DELTAP1         2 56 159 56 251 ;DELTA exception P1
DELTAP2         6 56 267 56 283 56 299 56 315 56 367 56 383 ;DELTA exception P2
SRP0            60         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 127 ;DELTA exception P1
MIRP[min,black] estemw 46  ;Move Indirect Relative Point
DELTAP1         5 46 55 46 71 46 86 46 102 46 118 ;DELTA exception P1
SRP1            30         ;Set Reference Point 1
SRP2            1          ;Set Reference Point 2
IP              8          ;Interpolate Point
MDAP[rnd]       8          ;Move Direct Absolute Point
DELTAP1         1 8 95     ;DELTA exception P1
SRP1            8          ;Set Reference Point 1
SRP2            1          ;Set Reference Point 2
IP              42         ;Interpolate Point
IP              7          ;Interpolate Point
MIRP[min,black] estemw 40  ;Move Indirect Relative Point
DELTAP1         5 40 55 40 71 40 86 40 102 40 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 11         ;Move Direct Relative Point
MIRP[min,black] estemw 38  ;Move Indirect Relative Point
DELTAP1         5 38 55 38 71 38 86 38 102 38 118 ;DELTA exception P1
SRP0            42         ;Set Reference Point 0
MIRP[min,black] headstem 6 ;Move Indirect Relative Point
SRP1            30         ;Set Reference Point 1
SRP2            38         ;Set Reference Point 2
SLOOP           6          ;Set LOOP variable
IP              33 34 35 14 15 16 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 20 90 20 106 20 122 22 85 22 101 22 117 ;DELTA exception P1
DELTAP1         6 26 85 26 101 26 117 28 90 28 106 28 122 ;DELTA exception P1
                           #--- NPUSHB    13 117 23 101 23 85 23 122 25 106 25 90 25 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 47 5 244 47 4 47 2 47 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 27 6 239 27 223 27 159 27 143 27 79 27 63 27 15 27 7 27 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    75 53 5 251 53 11 53 2 53 9 21 21 34 197 15 181 15 165 15 149 15 133 15 53 15 37 15 21 15 5 15 9 15 16 121 14 104 14 88 14 3 14 10 121 4 104 4 88 4 3 4 10 44 33 46 2 6 42 38 11 40 9 8 35 34 118 41 103 41 87 41 3 41 10 7 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         7          ;ALIGN to Reference Point
MIRP[min,black] estemt 41  ;Move Indirect Relative Point
DELTAP1         3 41 87 41 103 41 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_34 35  ;Move Indirect Relative Point
SLOOP           8          ;Set LOOP variable
IP              9 40 11 38 42 6 2 46 ;Interpolate Point
ALIGNRP         33         ;ALIGN to Reference Point
ALIGNRP         44         ;ALIGN to Reference Point
MIRP[min,black] estemt 4   ;Move Indirect Relative Point
DELTAP1         3 4 88 4 104 4 121 ;DELTA exception P1
MIRP[min,black] estemt 14  ;Move Indirect Relative Point
DELTAP1         3 14 88 14 104 14 121 ;DELTA exception P1
SHP[rp2]        16         ;SHift Point using reference point
MDRP[rp0,min,rnd,grey] 15         ;Move Direct Relative Point
DELTAP1         9 15 5 15 21 15 37 15 53 15 133 15 149 15 165 15 181 15 197 ;DELTA exception P1
MDRP[black]     34         ;Move Direct Relative Point
MDRP[rp0,rnd,grey] 21         ;Move Direct Relative Point
MDAP[rnd]       21         ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 53 ;Move Indirect Relative Point
DELTAP1         2 53 11 53 251 ;DELTA exception P1
DELTAP2         5 53 267 53 283 53 299 53 315 53 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 27  ;Move Indirect Relative Point
DELTAP1         7 27 15 27 63 27 79 27 143 27 159 27 223 27 239 ;DELTA exception P1
DELTAP2         6 27 303 27 319 27 367 27 383 27 447 27 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 47 ;Move Indirect Relative Point
DELTAP1         2 47 4 47 244 ;DELTA exception P1
DELTAP2         5 47 260 47 276 47 292 47 308 47 496 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 25 90 25 106 25 122 23 85 23 101 23 117 ;DELTA exception P1
""",

    'uni0E10.descless': """
                           #--- NPUSHB    26 122 7 106 7 90 7 117 5 101 5 85 5 6 117 13 101 13 85 13 122 11 106 11 90 11 6 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 55 6 244 55 144 55 2 55 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 61 5 244 61 4 61 2 61 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    62 9 3 79 9 63 9 47 9 3 9 118 15 102 15 86 15 71 15 55 15 5 15 16 3 118 48 102 48 86 48 71 48 55 48 5 48 16 22 22 32 39 42 29 5 36 26 36 65 118 48 102 48 86 48 71 48 55 48 5 48 16 26 ;PUSH N Bytes
MDAP[rnd]       26         ;Move Direct Absolute Point
MIRP[min,black] estemw 48  ;Move Indirect Relative Point
DELTAP1         5 48 55 48 71 48 86 48 102 48 118 ;DELTA exception P1
SRP0            65         ;Set Reference Point 0
MDRP[min,rnd,white] 36         ;Move Direct Relative Point
SRP1            26         ;Set Reference Point 1
SRP2            36         ;Set Reference Point 2
SLOOP           5          ;Set LOOP variable
IP              29 42 39 32 22 ;Interpolate Point
MDAP[rnd]       22         ;Move Direct Absolute Point
MIRP[min,black] estemw 48  ;Move Indirect Relative Point
DELTAP1         5 48 55 48 71 48 86 48 102 48 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 3          ;Move Direct Relative Point
MIRP[min,black] estemw 15  ;Move Indirect Relative Point
DELTAP1         5 15 55 15 71 15 86 15 102 15 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 9          ;Move Direct Relative Point
DELTAP1         3 9 47 9 63 9 79 ;DELTA exception P1
DELTAP2         3 9 287 9 303 9 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 61 ;Move Indirect Relative Point
DELTAP1         2 61 4 61 244 ;DELTA exception P1
DELTAP2         5 61 260 61 276 61 292 61 308 61 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 55  ;Move Indirect Relative Point
DELTAP1         2 55 144 55 244 ;DELTA exception P1
DELTAP2         6 55 260 55 276 55 292 55 308 55 352 55 368 ;DELTA exception P2
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 11 90 11 106 11 122 13 85 13 101 13 117 ;DELTA exception P1
DELTAP1         6 5 85 5 101 5 117 7 90 7 106 7 122 ;DELTA exception P1
                           #--- NPUSHB    25 117 10 101 10 85 10 122 8 106 8 90 8 6 118 19 103 19 87 19 3 19 10 0 31 64 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 52 5 244 52 4 52 2 52 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 6 6 239 6 223 6 159 6 143 6 79 6 63 6 15 6 7 6 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    62 58 5 251 58 11 58 2 58 9 12 121 36 104 36 88 36 3 36 10 35 29 118 32 103 32 87 32 3 32 10 75 39 59 39 36 39 20 39 4 39 5 39 122 42 106 42 89 42 3 42 6 12 48 23 25 46 48 26 7 29 34 64 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       64         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 29  ;Move Indirect Relative Point
SLOOP           7          ;Set LOOP variable
IP              26 48 46 25 23 48 12 ;Interpolate Point
MIRP[min,black] estemtc 42 ;Move Indirect Relative Point
DELTAP1         3 42 89 42 106 42 122 ;DELTA exception P1
MDRP[rp0,rnd,grey] 39         ;Move Direct Relative Point
DELTAP1         5 39 4 39 20 39 36 39 59 39 75 ;DELTA exception P1
MIRP[min,black] estemt 32  ;Move Indirect Relative Point
DELTAP1         3 32 87 32 103 32 118 ;DELTA exception P1
SRP0            29         ;Set Reference Point 0
MDRP[rp0,grey]  35         ;Move Direct Relative Point
MIRP[min,black] estemt 36  ;Move Indirect Relative Point
DELTAP1         3 36 88 36 104 36 121 ;DELTA exception P1
MDAP[rnd]       12         ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 58 ;Move Indirect Relative Point
DELTAP1         2 58 11 58 251 ;DELTA exception P1
DELTAP2         5 58 267 58 283 58 299 58 315 58 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 6   ;Move Indirect Relative Point
DELTAP1         7 6 15 6 63 6 79 6 143 6 159 6 223 6 239 ;DELTA exception P1
DELTAP2         6 6 303 6 319 6 367 6 383 6 447 6 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 52 ;Move Indirect Relative Point
DELTAP1         2 52 4 52 244 ;DELTA exception P1
DELTAP2         5 52 260 52 276 52 292 52 308 52 496 ;DELTA exception P2
SRP0            64         ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 0   ;Move Indirect Relative Point
MIRP[min,black] estemt 19  ;Move Indirect Relative Point
DELTAP1         3 19 87 19 103 19 118 ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 8 90 8 106 8 122 10 85 10 101 10 117 ;DELTA exception P1
""",

    'uni0E12': """
                           #--- NPUSHB    42 122 27 106 27 90 27 3 122 6 106 6 90 6 117 4 101 4 85 4 6 122 31 106 31 90 31 117 33 101 33 85 33 6 16 15 14 49 48 47 6 51 45 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   71        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   71        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   71        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   71        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 71 5 251 71 11 71 2 71 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   2         ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   2         ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   2         ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   2         ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   2         ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 2 6 224 2 208 2 144 2 128 2 64 2 48 2 0 2 7 2 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   77        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   77        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   77        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   77        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    52 77 5 244 77 4 77 2 77 9 8 8 11 39 118 51 102 51 86 51 71 51 55 51 5 51 16 31 11 1 11 11 53 39 1 118 55 102 55 86 55 71 55 55 55 5 55 16 127 53 1 53 81 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 59 5 251 59 11 59 2 59 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 35 6 224 35 208 35 144 35 128 35 64 35 48 35 0 35 7 35 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    60 65 5 244 65 4 65 2 65 9 159 29 143 29 15 29 3 29 45 23 38 18 118 38 102 38 86 38 71 38 55 38 5 38 16 16 39 1 39 118 18 102 18 86 18 71 18 55 18 5 18 16 32 45 16 45 0 45 3 45 80 ;PUSH N Bytes
SRP0            80         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 45         ;Move Direct Relative Point
DELTAP1         3 45 0 45 16 45 32 ;DELTA exception P1
MIRP[min,black] estemw 18  ;Move Indirect Relative Point
DELTAP1         5 18 55 18 71 18 86 18 102 18 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 39         ;Move Direct Relative Point
DELTAP1         1 39 16    ;DELTA exception P1
MIRP[min,black] estemw 38  ;Move Indirect Relative Point
DELTAP1         5 38 55 38 71 38 86 38 102 38 118 ;DELTA exception P1
SRP1            18         ;Set Reference Point 1
SRP2            38         ;Set Reference Point 2
IP              23         ;Interpolate Point
SRP0            45         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 29         ;Move Direct Relative Point
DELTAP1         3 29 15 29 143 29 159 ;DELTA exception P1
MIRP[min,rnd,grey] headstem 65 ;Move Indirect Relative Point
DELTAP1         2 65 4 65 244 ;DELTA exception P1
DELTAP2         5 65 260 65 276 65 292 65 308 65 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 35  ;Move Indirect Relative Point
DELTAP1         7 35 0 35 48 35 64 35 128 35 144 35 208 35 224 ;DELTA exception P1
DELTAP2         6 35 288 35 304 35 352 35 368 35 432 35 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 59 ;Move Indirect Relative Point
DELTAP1         2 59 11 59 251 ;DELTA exception P1
DELTAP2         5 59 267 59 283 59 299 59 315 59 511 ;DELTA exception P2
SRP0            81         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 53         ;Move Direct Relative Point
DELTAP1         1 53 127   ;DELTA exception P1
MIRP[min,black] estemw 55  ;Move Indirect Relative Point
DELTAP1         5 55 55 55 71 55 86 55 102 55 118 ;DELTA exception P1
ALIGNRP         1          ;ALIGN to Reference Point
SRP1            39         ;Set Reference Point 1
SRP2            53         ;Set Reference Point 2
IP              11         ;Interpolate Point
MDAP[rnd]       11         ;Move Direct Absolute Point
DELTAP1         1 11 31    ;DELTA exception P1
MIRP[min,black] estemw 51  ;Move Indirect Relative Point
DELTAP1         5 51 55 51 71 51 86 51 102 51 118 ;DELTA exception P1
SRP1            39         ;Set Reference Point 1
SRP2            11         ;Set Reference Point 2
IP              8          ;Interpolate Point
MDAP[rnd]       8          ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 77 ;Move Indirect Relative Point
DELTAP1         2 77 4 77 244 ;DELTA exception P1
DELTAP2         5 77 260 77 276 77 292 77 308 77 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 2   ;Move Indirect Relative Point
DELTAP1         7 2 0 2 48 2 64 2 128 2 144 2 208 2 224 ;DELTA exception P1
DELTAP2         6 2 288 2 304 2 352 2 368 2 432 2 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 71 ;Move Indirect Relative Point
DELTAP1         2 71 11 71 251 ;DELTA exception P1
DELTAP2         5 71 267 71 283 71 299 71 315 71 511 ;DELTA exception P2
SRP1            45         ;Set Reference Point 1
SRP2            51         ;Set Reference Point 2
SLOOP           6          ;Set LOOP variable
IP              47 48 49 14 15 16 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 33 85 33 101 33 117 31 90 31 106 31 122 ;DELTA exception P1
DELTAP1         6 4 85 4 101 4 117 6 90 6 106 6 122 ;DELTA exception P1
DELTAP1         3 27 90 27 106 27 122 ;DELTA exception P1
                           #--- NPUSHB    43 122 36 106 36 90 36 117 34 101 34 85 34 6 122 7 106 7 90 7 117 30 101 30 85 30 122 28 106 28 90 28 117 9 101 9 85 9 12 125 2 107 2 2 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   74        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   74        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   74        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   74        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    11 74 5 251 74 11 74 2 74 9 2 52 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 11 6 224 11 208 11 144 11 128 11 64 11 48 11 0 11 7 11 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   68        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   68        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   68        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   68        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    12 68 5 244 68 4 68 2 68 9 5 31 1 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 56 5 244 56 4 56 2 56 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 26 6 239 26 223 26 159 26 143 26 79 26 63 26 15 26 7 26 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    49 62 5 251 62 11 62 2 62 9 32 32 48 7 133 15 117 15 101 15 85 15 69 15 53 15 16 15 0 15 8 15 16 121 14 104 14 88 14 3 14 10 47 51 12 18 45 4 49 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   55 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    25 55 8 255 55 223 55 143 55 111 55 4 55 4 53 118 23 103 23 87 23 3 23 10 38 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         38         ;ALIGN to Reference Point
MIRP[min,black] estemt 23  ;Move Indirect Relative Point
DELTAP1         3 23 87 23 103 23 118 ;DELTA exception P1
SHP[rp2]        53         ;SHift Point using reference point
MIRP[rnd,grey]  tvheight 55 ;Move Indirect Relative Point
DELTAP1         4 55 111 55 143 55 223 55 255 ;DELTA exception P1
DELTAP2         8 55 287 55 335 55 367 55 399 55 431 55 447 55 479 55 511 ;DELTA exception P2
DELTAP3         1 55 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 49  ;Move Indirect Relative Point
SLOOP           4          ;Set LOOP variable
IP              45 18 12 51 ;Interpolate Point
ALIGNRP         47         ;ALIGN to Reference Point
MIRP[min,black] estemt 14  ;Move Indirect Relative Point
DELTAP1         3 14 88 14 104 14 121 ;DELTA exception P1
SHP[rp2]        16         ;SHift Point using reference point
MDRP[rp0,rnd,grey] 15         ;Move Direct Relative Point
DELTAP1         8 15 0 15 16 15 53 15 69 15 85 15 101 15 117 15 133 ;DELTA exception P1
MIRP[min,black] cvt_7 48   ;Move Indirect Relative Point
MDRP[rp0,min,rnd,white] 32         ;Move Direct Relative Point
MDAP[rnd]       32         ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 62 ;Move Indirect Relative Point
DELTAP1         2 62 11 62 251 ;DELTA exception P1
DELTAP2         5 62 267 62 283 62 299 62 315 62 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 26  ;Move Indirect Relative Point
DELTAP1         7 26 15 26 63 26 79 26 143 26 159 26 223 26 239 ;DELTA exception P1
DELTAP2         6 26 303 26 319 26 367 26 383 26 447 26 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 56 ;Move Indirect Relative Point
DELTAP1         2 56 4 56 244 ;DELTA exception P1
DELTAP2         5 56 260 56 276 56 292 56 308 56 496 ;DELTA exception P2
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 5   ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 68 ;Move Indirect Relative Point
DELTAP1         2 68 4 68 244 ;DELTA exception P1
DELTAP2         5 68 260 68 276 68 292 68 308 68 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 11  ;Move Indirect Relative Point
DELTAP1         7 11 0 11 48 11 64 11 128 11 144 11 208 11 224 ;DELTA exception P1
DELTAP2         6 11 288 11 304 11 352 11 368 11 432 11 448 ;DELTA exception P2
IP              52         ;Interpolate Point
IP              2          ;Interpolate Point
MIRP[min,rnd,grey] headstem 74 ;Move Indirect Relative Point
DELTAP1         2 74 11 74 251 ;DELTA exception P1
DELTAP2         5 74 267 74 283 74 299 74 315 74 511 ;DELTA exception P2
DELTAP1         2 2 107 2 125 ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 9 85 9 101 9 117 28 90 28 106 28 122 30 85 30 101 30 117 7 90 7 106 7 122 ;DELTA exception P1
DELTAP1         6 34 85 34 101 34 117 36 90 36 106 36 122 ;DELTA exception P1
""",

    'uni0E13': """
                           #--- NPUSHB    61 122 22 106 22 90 22 122 46 106 46 90 46 117 20 101 20 85 20 117 44 101 44 85 44 12 122 14 106 14 90 14 117 16 101 16 85 16 6 5 31 34 28 0 118 34 102 34 86 34 71 34 55 34 5 34 16 1 1 36 24 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   70        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   70        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   70        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   70        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 70 5 244 70 4 70 2 70 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 48 6 239 48 223 48 159 48 143 48 79 48 63 48 15 48 7 48 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 64 5 251 64 11 64 2 64 9 ;PUSH N Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   336       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    29 42 5 208 42 192 42 176 42 112 42 96 42 80 42 6 42 118 38 102 38 86 38 71 38 55 38 5 38 16 ;PUSH N Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    13 36 1 223 36 32 36 16 36 0 36 4 36 74 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 58 6 251 58 159 58 2 58 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 52 5 251 52 11 52 2 52 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    12 18 2 112 18 64 18 48 18 3 18 24 8 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    42 8 12 28 10 12 27 155 28 139 28 123 28 107 28 91 28 27 28 11 28 7 28 118 12 102 12 86 12 71 12 55 12 5 12 16 16 24 0 24 2 24 73 ;PUSH N Bytes
SRP0            73         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 24         ;Move Direct Relative Point
DELTAP1         2 24 0 24 16 ;DELTA exception P1
MIRP[min,black] estemw 12  ;Move Indirect Relative Point
DELTAP1         5 12 55 12 71 12 86 12 102 12 118 ;DELTA exception P1
MDRP[rp0,grey]  28         ;Move Direct Relative Point
DELTAP1         7 28 11 28 27 28 91 28 107 28 123 28 139 28 155 ;DELTA exception P1
MDRP[grey]      27         ;Move Direct Relative Point
SRP0            12         ;Set Reference Point 0
MDRP[grey]      10         ;Move Direct Relative Point
SRP1            28         ;Set Reference Point 1
SRP2            12         ;Set Reference Point 2
IP              8          ;Interpolate Point
SHPIX           -8 8       ;SHift point by a PIXel amount
SRP0            24         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 18         ;Move Direct Relative Point
DELTAP1         3 18 48 18 64 18 112 ;DELTA exception P1
DELTAP2         2 18 256 18 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 52 ;Move Indirect Relative Point
DELTAP1         2 52 11 52 251 ;DELTA exception P1
DELTAP2         5 52 267 52 283 52 299 52 315 52 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 58  ;Move Indirect Relative Point
DELTAP1         2 58 159 58 251 ;DELTA exception P1
DELTAP2         6 58 267 58 283 58 299 58 315 58 367 58 383 ;DELTA exception P2
SRP0            74         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 36         ;Move Direct Relative Point
DELTAP1         4 36 0 36 16 36 32 36 223 ;DELTA exception P1
DELTAP2         1 36 303   ;DELTA exception P2
MIRP[min,black] estemw 38  ;Move Indirect Relative Point
DELTAP1         5 38 55 38 71 38 86 38 102 38 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 42         ;Move Direct Relative Point
DELTAP1         6 42 80 42 96 42 112 42 176 42 192 42 208 ;DELTA exception P1
DELTAP2         5 42 256 42 272 42 288 42 336 42 352 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 64 ;Move Indirect Relative Point
DELTAP1         2 64 11 64 251 ;DELTA exception P1
DELTAP2         5 64 267 64 283 64 299 64 315 64 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 48  ;Move Indirect Relative Point
DELTAP1         7 48 15 48 63 48 79 48 143 48 159 48 223 48 239 ;DELTA exception P1
DELTAP2         6 48 303 48 319 48 367 48 383 48 447 48 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 70 ;Move Indirect Relative Point
DELTAP1         2 70 4 70 244 ;DELTA exception P1
DELTAP2         5 70 260 70 276 70 292 70 308 70 496 ;DELTA exception P2
SRP0            36         ;Set Reference Point 0
SRP1            24         ;Set Reference Point 1
SRP2            36         ;Set Reference Point 2
IP              1          ;Interpolate Point
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemw 34  ;Move Indirect Relative Point
DELTAP1         5 34 55 34 71 34 86 34 102 34 118 ;DELTA exception P1
SHP[rp2]        0          ;SHift Point using reference point
SRP1            28         ;Set Reference Point 1
SRP2            34         ;Set Reference Point 2
IP              31         ;Interpolate Point
IP              5          ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 16 85 16 101 16 117 14 90 14 106 14 122 ;DELTA exception P1
DELTAP1         12 44 85 44 101 44 117 20 85 20 101 20 117 46 90 46 106 46 122 22 90 22 106 22 122 ;DELTA exception P1
                           #--- NPUSHB    26 117 41 101 41 85 41 122 43 106 43 90 43 122 19 106 19 90 19 117 17 101 17 85 17 12 67 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    12 55 5 251 55 11 55 2 55 9 48 36 39 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    20 15 6 224 15 208 15 144 15 128 15 64 15 48 15 0 15 7 15 37 61 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    34 49 5 244 49 4 49 2 49 9 45 21 31 1 121 5 104 5 88 5 3 5 10 34 2 12 10 9 8 28 37 25 9 31 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   38 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    23 38 8 255 38 223 38 143 38 111 38 4 38 4 118 35 103 35 87 35 3 35 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 35  ;Move Indirect Relative Point
DELTAP1         3 35 87 35 103 35 118 ;DELTA exception P1
MIRP[rnd,grey]  tvheight 38 ;Move Indirect Relative Point
DELTAP1         4 38 111 38 143 38 223 38 255 ;DELTA exception P1
DELTAP2         8 38 287 38 335 38 367 38 399 38 431 38 447 38 479 38 511 ;DELTA exception P2
DELTAP3         1 38 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 31  ;Move Indirect Relative Point
SLOOP           9          ;Set LOOP variable
IP              25 37 28 8 9 10 12 2 34 ;Interpolate Point
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
DELTAP1         3 5 88 5 104 5 121 ;DELTA exception P1
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 21  ;Move Indirect Relative Point
ALIGNRP         45         ;ALIGN to Reference Point
MIRP[min,rnd,grey] headstem 49 ;Move Indirect Relative Point
DELTAP1         2 49 4 49 244 ;DELTA exception P1
DELTAP2         5 49 260 49 276 49 292 49 308 49 496 ;DELTA exception P2
SHP[rp2]        61         ;SHift Point using reference point
MIRP[rp0,rnd,grey] cvt_37 15  ;Move Indirect Relative Point
DELTAP1         7 15 0 15 48 15 64 15 128 15 144 15 208 15 224 ;DELTA exception P1
DELTAP2         6 15 288 15 304 15 352 15 368 15 432 15 448 ;DELTA exception P2
ALIGNRP         39         ;ALIGN to Reference Point
IP              36         ;Interpolate Point
IP              48         ;Interpolate Point
MIRP[min,rnd,grey] headstem 55 ;Move Indirect Relative Point
DELTAP1         2 55 11 55 251 ;DELTA exception P1
DELTAP2         5 55 267 55 283 55 299 55 315 55 511 ;DELTA exception P2
SHP[rp2]        67         ;SHift Point using reference point
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 17 85 17 101 17 117 19 90 19 106 19 122 43 90 43 106 43 122 41 85 41 101 41 117 ;DELTA exception P1
""",

    'uni0E14': """
                           #--- NPUSHB    44 122 17 106 17 90 17 3 117 23 101 23 85 23 122 21 106 21 90 21 6 5 38 41 35 118 41 102 41 86 41 71 41 55 41 5 41 16 127 1 0 1 2 1 55 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    10 45 5 251 45 11 45 2 45 9 16 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 25 6 224 25 208 25 144 25 128 25 64 25 48 25 0 25 7 25 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 51 5 244 51 4 51 2 51 9 ;PUSH N Bytes
                           #--- PUSHW_1   320       ;PUSH Words
                           #--- PUSHB_1   19        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- NPUSHB    51 19 2 112 19 96 19 2 19 35 13 28 8 118 28 102 28 86 28 71 28 55 28 5 28 16 16 29 1 29 118 8 102 8 86 8 71 8 55 8 5 8 16 32 35 16 35 0 35 3 35 54 ;PUSH N Bytes
SRP0            54         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 35         ;Move Direct Relative Point
DELTAP1         3 35 0 35 16 35 32 ;DELTA exception P1
MIRP[min,black] estemw 8   ;Move Indirect Relative Point
DELTAP1         5 8 55 8 71 8 86 8 102 8 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 29         ;Move Direct Relative Point
DELTAP1         1 29 16    ;DELTA exception P1
MIRP[min,black] estemw 28  ;Move Indirect Relative Point
DELTAP1         5 28 55 28 71 28 86 28 102 28 118 ;DELTA exception P1
SRP1            8          ;Set Reference Point 1
SRP2            28         ;Set Reference Point 2
IP              13         ;Interpolate Point
SRP0            35         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 19         ;Move Direct Relative Point
DELTAP1         2 19 96 19 112 ;DELTA exception P1
DELTAP2         2 19 304 19 320 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 51 ;Move Indirect Relative Point
DELTAP1         2 51 4 51 244 ;DELTA exception P1
DELTAP2         5 51 260 51 276 51 292 51 308 51 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 25  ;Move Indirect Relative Point
DELTAP1         7 25 0 25 48 25 64 25 128 25 144 25 208 25 224 ;DELTA exception P1
DELTAP2         6 25 288 25 304 25 352 25 368 25 432 25 448 ;DELTA exception P2
IP              16         ;Interpolate Point
MIRP[min,rnd,grey] headstem 45 ;Move Indirect Relative Point
DELTAP1         2 45 11 45 251 ;DELTA exception P1
DELTAP2         5 45 267 45 283 45 299 45 315 45 511 ;DELTA exception P2
SRP0            55         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 127 ;DELTA exception P1
MIRP[min,black] estemw 41  ;Move Indirect Relative Point
DELTAP1         5 41 55 41 71 41 86 41 102 41 118 ;DELTA exception P1
SRP1            35         ;Set Reference Point 1
SRP2            41         ;Set Reference Point 2
IP              38         ;Interpolate Point
IP              5          ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 21 90 21 106 21 122 23 85 23 101 23 117 ;DELTA exception P1
DELTAP1         3 17 90 17 106 17 122 ;DELTA exception P1
                           #--- NPUSHB    26 122 26 106 26 90 26 117 24 101 24 85 24 6 117 20 101 20 85 20 122 18 106 18 90 18 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 42 5 244 42 4 42 2 42 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 16 6 239 16 223 16 159 16 143 16 79 16 63 16 15 16 7 16 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    37 48 5 251 48 11 48 2 48 9 22 122 5 106 5 89 5 3 5 6 41 2 8 35 4 38 34 118 13 103 13 87 13 3 13 10 28 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         28         ;ALIGN to Reference Point
MIRP[min,black] estemt 13  ;Move Indirect Relative Point
DELTAP1         3 13 87 13 103 13 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_34 38  ;Move Indirect Relative Point
SLOOP           4          ;Set LOOP variable
IP              35 8 2 41  ;Interpolate Point
MIRP[min,black] estemtc 5  ;Move Indirect Relative Point
DELTAP1         3 5 89 5 106 5 122 ;DELTA exception P1
MDRP[rp0,rnd,white] 22         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 48 ;Move Indirect Relative Point
DELTAP1         2 48 11 48 251 ;DELTA exception P1
DELTAP2         5 48 267 48 283 48 299 48 315 48 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 16  ;Move Indirect Relative Point
DELTAP1         7 16 15 16 63 16 79 16 143 16 159 16 223 16 239 ;DELTA exception P1
DELTAP2         6 16 303 16 319 16 367 16 383 16 447 16 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 42 ;Move Indirect Relative Point
DELTAP1         2 42 4 42 244 ;DELTA exception P1
DELTAP2         5 42 260 42 276 42 292 42 308 42 496 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 18 90 18 106 18 122 20 85 20 101 20 117 ;DELTA exception P1
DELTAP1         6 24 85 24 101 24 117 26 90 26 106 26 122 ;DELTA exception P1
""",

    'uni0E15': """
                           #--- NPUSHB    49 122 17 106 17 90 17 3 117 23 101 23 85 23 122 21 106 21 90 21 6 6 5 4 39 38 37 6 41 35 118 41 102 41 86 41 71 41 55 41 5 41 16 127 1 0 1 2 1 55 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    10 45 5 251 45 11 45 2 45 9 16 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 25 6 224 25 208 25 144 25 128 25 64 25 48 25 0 25 7 25 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 51 5 244 51 4 51 2 51 9 ;PUSH N Bytes
                           #--- PUSHW_1   320       ;PUSH Words
                           #--- PUSHB_1   19        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- NPUSHB    51 19 2 112 19 96 19 2 19 35 13 28 8 118 28 102 28 86 28 71 28 55 28 5 28 16 16 29 1 29 118 8 102 8 86 8 71 8 55 8 5 8 16 32 35 16 35 0 35 3 35 54 ;PUSH N Bytes
SRP0            54         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 35         ;Move Direct Relative Point
DELTAP1         3 35 0 35 16 35 32 ;DELTA exception P1
MIRP[min,black] estemw 8   ;Move Indirect Relative Point
DELTAP1         5 8 55 8 71 8 86 8 102 8 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 29         ;Move Direct Relative Point
DELTAP1         1 29 16    ;DELTA exception P1
MIRP[min,black] estemw 28  ;Move Indirect Relative Point
DELTAP1         5 28 55 28 71 28 86 28 102 28 118 ;DELTA exception P1
SRP1            8          ;Set Reference Point 1
SRP2            28         ;Set Reference Point 2
IP              13         ;Interpolate Point
SRP0            35         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 19         ;Move Direct Relative Point
DELTAP1         2 19 96 19 112 ;DELTA exception P1
DELTAP2         2 19 304 19 320 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 51 ;Move Indirect Relative Point
DELTAP1         2 51 4 51 244 ;DELTA exception P1
DELTAP2         5 51 260 51 276 51 292 51 308 51 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 25  ;Move Indirect Relative Point
DELTAP1         7 25 0 25 48 25 64 25 128 25 144 25 208 25 224 ;DELTA exception P1
DELTAP2         6 25 288 25 304 25 352 25 368 25 432 25 448 ;DELTA exception P2
IP              16         ;Interpolate Point
MIRP[min,rnd,grey] headstem 45 ;Move Indirect Relative Point
DELTAP1         2 45 11 45 251 ;DELTA exception P1
DELTAP2         5 45 267 45 283 45 299 45 315 45 511 ;DELTA exception P2
SRP0            55         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 127 ;DELTA exception P1
MIRP[min,black] estemw 41  ;Move Indirect Relative Point
DELTAP1         5 41 55 41 71 41 86 41 102 41 118 ;DELTA exception P1
SRP1            35         ;Set Reference Point 1
SRP2            41         ;Set Reference Point 2
SLOOP           6          ;Set LOOP variable
IP              37 38 39 4 5 6 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 21 90 21 106 21 122 23 85 23 101 23 117 ;DELTA exception P1
DELTAP1         3 17 90 17 106 17 122 ;DELTA exception P1
                           #--- NPUSHB    26 122 26 106 26 90 26 117 24 101 24 85 24 6 117 20 101 20 85 20 122 18 106 18 90 18 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 42 5 244 42 4 42 2 42 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 16 6 239 16 223 16 159 16 143 16 79 16 63 16 15 16 7 16 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    60 48 5 251 48 11 48 2 48 9 22 22 38 7 133 5 117 5 101 5 85 5 69 5 53 5 16 5 0 5 8 5 6 121 4 104 4 88 4 3 4 10 37 41 2 8 35 4 39 34 118 13 103 13 87 13 3 13 10 28 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         28         ;ALIGN to Reference Point
MIRP[min,black] estemt 13  ;Move Indirect Relative Point
DELTAP1         3 13 87 13 103 13 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_34 39  ;Move Indirect Relative Point
SLOOP           4          ;Set LOOP variable
IP              35 8 2 41  ;Interpolate Point
ALIGNRP         37         ;ALIGN to Reference Point
MIRP[min,black] estemt 4   ;Move Indirect Relative Point
DELTAP1         3 4 88 4 104 4 121 ;DELTA exception P1
SHP[rp2]        6          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 5          ;Move Direct Relative Point
DELTAP1         8 5 0 5 16 5 53 5 69 5 85 5 101 5 117 5 133 ;DELTA exception P1
MIRP[min,black] cvt_7 38   ;Move Indirect Relative Point
MDRP[rp0,min,rnd,white] 22         ;Move Direct Relative Point
MDAP[rnd]       22         ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 48 ;Move Indirect Relative Point
DELTAP1         2 48 11 48 251 ;DELTA exception P1
DELTAP2         5 48 267 48 283 48 299 48 315 48 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 16  ;Move Indirect Relative Point
DELTAP1         7 16 15 16 63 16 79 16 143 16 159 16 223 16 239 ;DELTA exception P1
DELTAP2         6 16 303 16 319 16 367 16 383 16 447 16 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 42 ;Move Indirect Relative Point
DELTAP1         2 42 4 42 244 ;DELTA exception P1
DELTAP2         5 42 260 42 276 42 292 42 308 42 496 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 18 90 18 106 18 122 20 85 20 101 20 117 ;DELTA exception P1
DELTAP1         6 24 85 24 101 24 117 26 90 26 106 26 122 ;DELTA exception P1
""",

    'uni0E16': """
                           #--- NPUSHB    46 122 22 106 22 90 22 117 20 101 20 85 20 6 122 14 106 14 90 14 117 16 101 16 85 16 6 118 34 102 34 86 34 71 34 55 34 5 34 16 127 1 0 1 2 1 48 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 44 6 251 44 159 44 2 44 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 38 5 251 38 11 38 2 38 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    12 18 2 112 18 64 18 48 18 3 18 24 8 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    42 8 12 28 10 12 27 155 28 139 28 123 28 107 28 91 28 27 28 11 28 7 28 118 12 102 12 86 12 71 12 55 12 5 12 16 16 24 0 24 2 24 47 ;PUSH N Bytes
SRP0            47         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 24         ;Move Direct Relative Point
DELTAP1         2 24 0 24 16 ;DELTA exception P1
MIRP[min,black] estemw 12  ;Move Indirect Relative Point
DELTAP1         5 12 55 12 71 12 86 12 102 12 118 ;DELTA exception P1
MDRP[rp0,grey]  28         ;Move Direct Relative Point
DELTAP1         7 28 11 28 27 28 91 28 107 28 123 28 139 28 155 ;DELTA exception P1
MDRP[grey]      27         ;Move Direct Relative Point
SRP0            12         ;Set Reference Point 0
MDRP[grey]      10         ;Move Direct Relative Point
SRP1            28         ;Set Reference Point 1
SRP2            12         ;Set Reference Point 2
IP              8          ;Interpolate Point
SHPIX           -8 8       ;SHift point by a PIXel amount
SRP0            24         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 18         ;Move Direct Relative Point
DELTAP1         3 18 48 18 64 18 112 ;DELTA exception P1
DELTAP2         2 18 256 18 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 38 ;Move Indirect Relative Point
DELTAP1         2 38 11 38 251 ;DELTA exception P1
DELTAP2         5 38 267 38 283 38 299 38 315 38 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 44  ;Move Indirect Relative Point
DELTAP1         2 44 159 44 251 ;DELTA exception P1
DELTAP2         6 44 267 44 283 44 299 44 315 44 367 44 383 ;DELTA exception P2
SRP0            48         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 127 ;DELTA exception P1
MIRP[min,black] estemw 34  ;Move Indirect Relative Point
DELTAP1         5 34 55 34 71 34 86 34 102 34 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 16 85 16 101 16 117 14 90 14 106 14 122 ;DELTA exception P1
DELTAP1         6 20 85 20 101 20 117 22 90 22 106 22 122 ;DELTA exception P1
                           #--- NPUSHB    13 122 19 106 19 90 19 117 17 101 17 85 17 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 41 5 251 41 11 41 2 41 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 15 6 224 15 208 15 144 15 128 15 64 15 48 15 0 15 7 15 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    34 35 5 244 35 4 35 2 35 9 21 31 1 121 5 104 5 88 5 3 5 10 34 2 12 10 9 8 28 27 25 9 31 34 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 31  ;Move Indirect Relative Point
SLOOP           9          ;Set LOOP variable
IP              25 27 28 8 9 10 12 2 34 ;Interpolate Point
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
DELTAP1         3 5 88 5 104 5 121 ;DELTA exception P1
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 21  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 35 ;Move Indirect Relative Point
DELTAP1         2 35 4 35 244 ;DELTA exception P1
DELTAP2         5 35 260 35 276 35 292 35 308 35 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 15  ;Move Indirect Relative Point
DELTAP1         7 15 0 15 48 15 64 15 128 15 144 15 208 15 224 ;DELTA exception P1
DELTAP2         6 15 288 15 304 15 352 15 368 15 432 15 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 41 ;Move Indirect Relative Point
DELTAP1         2 41 11 41 251 ;DELTA exception P1
DELTAP2         5 41 267 41 283 41 299 41 315 41 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 17 85 17 101 17 117 19 90 19 106 19 122 ;DELTA exception P1
""",

    'uni0E17': """
                           #--- NPUSHB    52 122 14 106 14 90 14 117 12 101 12 85 12 6 117 20 101 20 85 20 122 18 106 18 90 18 6 24 9 8 8 30 10 118 30 102 30 86 30 71 30 55 30 5 30 16 127 1 0 1 2 1 44 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 34 6 244 34 144 34 2 34 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 40 5 244 40 4 40 2 40 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    35 16 3 79 16 63 16 47 16 3 16 9 118 22 102 22 86 22 71 22 55 22 5 22 16 175 10 32 10 16 10 0 10 4 10 43 ;PUSH N Bytes
SRP0            43         ;Set Reference Point 0
MDRP[rp0,rnd,white] 10         ;Move Direct Relative Point
DELTAP1         4 10 0 10 16 10 32 10 175 ;DELTA exception P1
MIRP[min,black] estemw 22  ;Move Indirect Relative Point
DELTAP1         5 22 55 22 71 22 86 22 102 22 118 ;DELTA exception P1
SHP[rp2]        9          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 16         ;Move Direct Relative Point
DELTAP1         3 16 47 16 63 16 79 ;DELTA exception P1
DELTAP2         3 16 287 16 303 16 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 40 ;Move Indirect Relative Point
DELTAP1         2 40 4 40 244 ;DELTA exception P1
DELTAP2         5 40 260 40 276 40 292 40 308 40 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 34  ;Move Indirect Relative Point
DELTAP1         2 34 144 34 244 ;DELTA exception P1
DELTAP2         6 34 260 34 276 34 292 34 308 34 352 34 368 ;DELTA exception P2
SRP0            44         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 127 ;DELTA exception P1
MIRP[min,black] estemw 30  ;Move Indirect Relative Point
DELTAP1         5 30 55 30 71 30 86 30 102 30 118 ;DELTA exception P1
SRP1            10         ;Set Reference Point 1
SRP2            30         ;Set Reference Point 2
IP              8          ;Interpolate Point
SRP0            8          ;Set Reference Point 0
MIRP[min,black] headstem 24 ;Move Indirect Relative Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 18 90 18 106 18 122 20 85 20 101 20 117 ;DELTA exception P1
DELTAP1         6 12 85 12 101 12 117 14 90 14 106 14 122 ;DELTA exception P1
                           #--- NPUSHB    20 122 15 106 15 90 15 117 17 101 17 85 17 6 114 23 99 23 84 23 3 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 31 5 244 31 4 31 2 31 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 13 6 239 13 223 13 159 13 143 13 79 13 63 13 15 13 7 13 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    29 37 5 251 37 11 37 2 37 9 121 5 104 5 88 5 3 5 10 27 30 2 8 24 23 5 19 34 9 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         9          ;ALIGN to Reference Point
MIRP[rp0,rnd,grey] cvt_34 19  ;Move Indirect Relative Point
SLOOP           5          ;Set LOOP variable
IP              23 24 8 2 30 ;Interpolate Point
ALIGNRP         27         ;ALIGN to Reference Point
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
DELTAP1         3 5 88 5 104 5 121 ;DELTA exception P1
MIRP[min,rnd,grey] headstem 37 ;Move Indirect Relative Point
DELTAP1         2 37 11 37 251 ;DELTA exception P1
DELTAP2         5 37 267 37 283 37 299 37 315 37 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 13  ;Move Indirect Relative Point
DELTAP1         7 13 15 13 63 13 79 13 143 13 159 13 223 13 239 ;DELTA exception P1
DELTAP2         6 13 303 13 319 13 367 13 383 13 447 13 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 31 ;Move Indirect Relative Point
DELTAP1         2 31 4 31 244 ;DELTA exception P1
DELTAP2         5 31 260 31 276 31 292 31 308 31 496 ;DELTA exception P2
DELTAP1         3 23 84 23 99 23 114 ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 17 85 17 101 17 117 15 90 15 106 15 122 ;DELTA exception P1
""",

    'uni0E18': """
                           #--- NPUSHB    65 15 22 25 12 4 19 9 118 31 102 31 86 31 71 31 55 31 5 31 16 127 5 1 5 33 19 33 118 3 102 3 86 3 71 3 55 3 5 3 16 224 1 208 1 192 1 3 1 118 28 102 28 86 28 71 28 55 28 5 28 16 175 9 1 9 ;PUSH N Bytes
MDAP[rnd]       9          ;Move Direct Absolute Point
DELTAP1         1 9 175    ;DELTA exception P1
MIRP[min,black] estemw 28  ;Move Indirect Relative Point
DELTAP1         5 28 55 28 71 28 86 28 102 28 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         3 1 192 1 208 1 224 ;DELTA exception P1
MIRP[min,black] estemw 3   ;Move Indirect Relative Point
DELTAP1         5 3 55 3 71 3 86 3 102 3 118 ;DELTA exception P1
SRP0            33         ;Set Reference Point 0
MDRP[rp0,min,rnd,white] 19         ;Move Direct Relative Point
SRP0            33         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 5          ;Move Direct Relative Point
DELTAP1         1 5 127    ;DELTA exception P1
MIRP[min,black] estemw 31  ;Move Indirect Relative Point
DELTAP1         5 31 55 31 71 31 86 31 102 31 118 ;DELTA exception P1
SRP1            9          ;Set Reference Point 1
SRP2            19         ;Set Reference Point 2
SLOOP           4          ;Set LOOP variable
IP              12 25 22 15 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    62 2 121 19 104 19 88 19 3 19 10 18 12 118 15 103 15 87 15 3 15 10 75 22 59 22 36 22 20 22 4 22 5 22 122 25 106 25 89 25 3 25 6 2 31 6 8 29 28 9 7 12 34 118 4 103 4 87 4 3 4 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 4   ;Move Indirect Relative Point
DELTAP1         3 4 87 4 103 4 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_34 12  ;Move Indirect Relative Point
SLOOP           7          ;Set LOOP variable
IP              9 28 29 8 6 31 2 ;Interpolate Point
MIRP[min,black] estemtc 25 ;Move Indirect Relative Point
DELTAP1         3 25 89 25 106 25 122 ;DELTA exception P1
MDRP[rp0,rnd,grey] 22         ;Move Direct Relative Point
DELTAP1         5 22 4 22 20 22 36 22 59 22 75 ;DELTA exception P1
MIRP[min,black] estemt 15  ;Move Indirect Relative Point
DELTAP1         3 15 87 15 103 15 118 ;DELTA exception P1
SRP0            12         ;Set Reference Point 0
MDRP[rp0,grey]  18         ;Move Direct Relative Point
MIRP[min,black] estemt 19  ;Move Indirect Relative Point
DELTAP1         3 19 88 19 104 19 121 ;DELTA exception P1
MDAP[rnd]       2          ;Move Direct Absolute Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E19': """
                           #--- NPUSHB    38 117 23 101 23 85 23 122 5 106 5 90 5 117 3 101 3 85 3 122 25 106 25 90 25 12 117 11 101 11 85 11 122 9 106 9 90 9 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 49 5 244 49 4 49 2 49 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 27 6 239 27 223 27 159 27 143 27 79 27 63 27 15 27 7 27 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 43 5 251 43 11 43 2 43 9 ;PUSH N Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   336       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    29 21 5 208 21 192 21 176 21 112 21 96 21 80 21 6 21 118 17 102 17 86 17 71 17 55 17 5 17 16 ;PUSH N Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    13 15 1 223 15 32 15 16 15 0 15 4 15 53 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 31 6 244 31 144 31 2 31 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 37 5 244 37 4 37 2 37 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    35 7 3 79 7 63 7 47 7 3 7 0 118 13 102 13 86 13 71 13 55 13 5 13 16 175 1 32 1 16 1 0 1 4 1 52 ;PUSH N Bytes
SRP0            52         ;Set Reference Point 0
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
DELTAP1         4 1 0 1 16 1 32 1 175 ;DELTA exception P1
MIRP[min,black] estemw 13  ;Move Indirect Relative Point
DELTAP1         5 13 55 13 71 13 86 13 102 13 118 ;DELTA exception P1
SHP[rp2]        0          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 7          ;Move Direct Relative Point
DELTAP1         3 7 47 7 63 7 79 ;DELTA exception P1
DELTAP2         3 7 287 7 303 7 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 37 ;Move Indirect Relative Point
DELTAP1         2 37 4 37 244 ;DELTA exception P1
DELTAP2         5 37 260 37 276 37 292 37 308 37 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 31  ;Move Indirect Relative Point
DELTAP1         2 31 144 31 244 ;DELTA exception P1
DELTAP2         6 31 260 31 276 31 292 31 308 31 352 31 368 ;DELTA exception P2
SRP0            53         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 15         ;Move Direct Relative Point
DELTAP1         4 15 0 15 16 15 32 15 223 ;DELTA exception P1
DELTAP2         1 15 303   ;DELTA exception P2
MIRP[min,black] estemw 17  ;Move Indirect Relative Point
DELTAP1         5 17 55 17 71 17 86 17 102 17 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 21         ;Move Direct Relative Point
DELTAP1         6 21 80 21 96 21 112 21 176 21 192 21 208 ;DELTA exception P1
DELTAP2         5 21 256 21 272 21 288 21 336 21 352 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 43 ;Move Indirect Relative Point
DELTAP1         2 43 11 43 251 ;DELTA exception P1
DELTAP2         5 43 267 43 283 43 299 43 315 43 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 27  ;Move Indirect Relative Point
DELTAP1         7 27 15 27 63 27 79 27 143 27 159 27 223 27 239 ;DELTA exception P1
DELTAP2         6 27 303 27 319 27 367 27 383 27 447 27 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 49 ;Move Indirect Relative Point
DELTAP1         2 49 4 49 244 ;DELTA exception P1
DELTAP2         5 49 260 49 276 49 292 49 308 49 496 ;DELTA exception P2
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 9 90 9 106 9 122 11 85 11 101 11 117 ;DELTA exception P1
DELTAP1         12 25 90 25 106 25 122 3 85 3 101 3 117 5 90 5 106 5 122 23 85 23 101 23 117 ;DELTA exception P1
                           #--- NPUSHB    26 122 22 106 22 90 22 117 20 101 20 85 20 6 122 6 106 6 90 6 117 8 101 8 85 8 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    11 46 5 251 46 11 46 2 46 9 27 15 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 18 6 224 18 208 18 144 18 128 18 64 18 48 18 0 18 7 18 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    12 40 5 244 40 4 40 2 40 9 24 31 0 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   28        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   28        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   28        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   28        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 28 5 244 28 4 28 2 28 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 4 6 239 4 223 4 159 4 143 4 79 4 63 4 15 4 7 4 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    11 34 5 251 34 11 34 2 34 9 10 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   17 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    23 17 8 255 17 223 17 143 17 111 17 4 17 4 118 14 103 14 87 14 3 14 10 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
MIRP[min,black] estemt 14  ;Move Indirect Relative Point
DELTAP1         3 14 87 14 103 14 118 ;DELTA exception P1
MIRP[rnd,grey]  tvheight 17 ;Move Indirect Relative Point
DELTAP1         4 17 111 17 143 17 223 17 255 ;DELTA exception P1
DELTAP2         8 17 287 17 335 17 367 17 399 17 431 17 447 17 479 17 511 ;DELTA exception P2
DELTAP3         1 17 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 10  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 34 ;Move Indirect Relative Point
DELTAP1         2 34 11 34 251 ;DELTA exception P1
DELTAP2         5 34 267 34 283 34 299 34 315 34 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 4   ;Move Indirect Relative Point
DELTAP1         7 4 15 4 63 4 79 4 143 4 159 4 223 4 239 ;DELTA exception P1
DELTAP2         6 4 303 4 319 4 367 4 383 4 447 4 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 28 ;Move Indirect Relative Point
DELTAP1         2 28 4 28 244 ;DELTA exception P1
DELTAP2         5 28 260 28 276 28 292 28 308 28 496 ;DELTA exception P2
SRP0            0          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 24  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 40 ;Move Indirect Relative Point
DELTAP1         2 40 4 40 244 ;DELTA exception P1
DELTAP2         5 40 260 40 276 40 292 40 308 40 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 18  ;Move Indirect Relative Point
DELTAP1         7 18 0 18 48 18 64 18 128 18 144 18 208 18 224 ;DELTA exception P1
DELTAP2         6 18 288 18 304 18 352 18 368 18 432 18 448 ;DELTA exception P2
IP              15         ;Interpolate Point
IP              27         ;Interpolate Point
MIRP[min,rnd,grey] headstem 46 ;Move Indirect Relative Point
DELTAP1         2 46 11 46 251 ;DELTA exception P1
DELTAP2         5 46 267 46 283 46 299 46 315 46 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 8 85 8 101 8 117 6 90 6 106 6 122 ;DELTA exception P1
DELTAP1         6 20 85 20 101 20 117 22 90 22 106 22 122 ;DELTA exception P1
""",

    'uni0E1A': """
                           #--- NPUSHB    44 122 5 106 5 90 5 117 3 101 3 85 3 6 117 11 101 11 85 11 122 9 106 9 90 9 6 118 17 102 17 86 17 71 17 55 17 5 17 16 127 15 1 15 31 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 21 6 244 21 144 21 2 21 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 27 5 244 27 4 27 2 27 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    34 7 3 79 7 63 7 47 7 3 7 118 13 102 13 86 13 71 13 55 13 5 13 16 175 1 32 1 16 1 0 1 4 1 30 ;PUSH N Bytes
SRP0            30         ;Set Reference Point 0
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
DELTAP1         4 1 0 1 16 1 32 1 175 ;DELTA exception P1
MIRP[min,black] estemw 13  ;Move Indirect Relative Point
DELTAP1         5 13 55 13 71 13 86 13 102 13 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 7          ;Move Direct Relative Point
DELTAP1         3 7 47 7 63 7 79 ;DELTA exception P1
DELTAP2         3 7 287 7 303 7 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 27 ;Move Indirect Relative Point
DELTAP1         2 27 4 27 244 ;DELTA exception P1
DELTAP2         5 27 260 27 276 27 292 27 308 27 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 21  ;Move Indirect Relative Point
DELTAP1         2 21 144 21 244 ;DELTA exception P1
DELTAP2         6 21 260 21 276 21 292 21 308 21 352 21 368 ;DELTA exception P2
SRP0            31         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 15         ;Move Direct Relative Point
DELTAP1         1 15 127   ;DELTA exception P1
MIRP[min,black] estemw 17  ;Move Indirect Relative Point
DELTAP1         5 17 55 17 71 17 86 17 102 17 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 9 90 9 106 9 122 11 85 11 101 11 117 ;DELTA exception P1
DELTAP1         6 3 85 3 101 3 117 5 90 5 106 5 122 ;DELTA exception P1
                           #--- NPUSHB    13 122 6 106 6 90 6 117 8 101 8 85 8 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 18 5 244 18 4 18 2 18 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 4 6 239 4 223 4 159 4 143 4 79 4 63 4 15 4 7 4 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    11 24 5 251 24 11 24 2 24 9 10 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   17 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    23 17 8 255 17 223 17 143 17 111 17 4 17 4 118 14 103 14 87 14 3 14 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 14  ;Move Indirect Relative Point
DELTAP1         3 14 87 14 103 14 118 ;DELTA exception P1
MIRP[rnd,grey]  tvheight 17 ;Move Indirect Relative Point
DELTAP1         4 17 111 17 143 17 223 17 255 ;DELTA exception P1
DELTAP2         8 17 287 17 335 17 367 17 399 17 431 17 447 17 479 17 511 ;DELTA exception P2
DELTAP3         1 17 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 10  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 24 ;Move Indirect Relative Point
DELTAP1         2 24 11 24 251 ;DELTA exception P1
DELTAP2         5 24 267 24 283 24 299 24 315 24 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 4   ;Move Indirect Relative Point
DELTAP1         7 4 15 4 63 4 79 4 143 4 159 4 223 4 239 ;DELTA exception P1
DELTAP2         6 4 303 4 319 4 367 4 383 4 447 4 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 18 ;Move Indirect Relative Point
DELTAP1         2 18 4 18 244 ;DELTA exception P1
DELTAP2         5 18 260 18 276 18 292 18 308 18 496 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 8 85 8 101 8 117 6 90 6 106 6 122 ;DELTA exception P1
""",

    'uni0E1B': """
                           #--- NPUSHB    44 122 5 106 5 90 5 117 3 101 3 85 3 6 117 11 101 11 85 11 122 9 106 9 90 9 6 118 17 102 17 86 17 71 17 55 17 5 17 16 127 15 1 15 31 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 21 6 244 21 144 21 2 21 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 27 5 244 27 4 27 2 27 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    34 7 3 79 7 63 7 47 7 3 7 118 13 102 13 86 13 71 13 55 13 5 13 16 175 1 32 1 16 1 0 1 4 1 30 ;PUSH N Bytes
SRP0            30         ;Set Reference Point 0
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
DELTAP1         4 1 0 1 16 1 32 1 175 ;DELTA exception P1
MIRP[min,black] estemw 13  ;Move Indirect Relative Point
DELTAP1         5 13 55 13 71 13 86 13 102 13 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 7          ;Move Direct Relative Point
DELTAP1         3 7 47 7 63 7 79 ;DELTA exception P1
DELTAP2         3 7 287 7 303 7 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 27 ;Move Indirect Relative Point
DELTAP1         2 27 4 27 244 ;DELTA exception P1
DELTAP2         5 27 260 27 276 27 292 27 308 27 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 21  ;Move Indirect Relative Point
DELTAP1         2 21 144 21 244 ;DELTA exception P1
DELTAP2         6 21 260 21 276 21 292 21 308 21 352 21 368 ;DELTA exception P2
SRP0            31         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 15         ;Move Direct Relative Point
DELTAP1         1 15 127   ;DELTA exception P1
MIRP[min,black] estemw 17  ;Move Indirect Relative Point
DELTAP1         5 17 55 17 71 17 86 17 102 17 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 9 90 9 106 9 122 11 85 11 101 11 117 ;DELTA exception P1
DELTAP1         6 3 85 3 101 3 117 5 90 5 106 5 122 ;DELTA exception P1
                           #--- NPUSHB    13 122 6 106 6 90 6 117 8 101 8 85 8 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 18 5 244 18 4 18 2 18 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 4 6 239 4 223 4 159 4 143 4 79 4 63 4 15 4 7 4 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    23 24 5 251 24 11 24 2 24 9 10 34 17 38 118 14 103 14 87 14 3 14 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 14  ;Move Indirect Relative Point
DELTAP1         3 14 87 14 103 14 118 ;DELTA exception P1
MIRP[rnd,grey]  cvt_38 17  ;Move Indirect Relative Point
MIRP[rp0,rnd,grey] cvt_34 10  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 24 ;Move Indirect Relative Point
DELTAP1         2 24 11 24 251 ;DELTA exception P1
DELTAP2         5 24 267 24 283 24 299 24 315 24 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 4   ;Move Indirect Relative Point
DELTAP1         7 4 15 4 63 4 79 4 143 4 159 4 223 4 239 ;DELTA exception P1
DELTAP2         6 4 303 4 319 4 367 4 383 4 447 4 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 18 ;Move Indirect Relative Point
DELTAP1         2 18 4 18 244 ;DELTA exception P1
DELTAP2         5 18 260 18 276 18 292 18 308 18 496 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 8 85 8 101 8 117 6 90 6 106 6 122 ;DELTA exception P1
""",

    'uni0E1C': """
                           #--- NPUSHB    53 122 15 106 15 90 15 117 13 101 13 85 13 6 122 7 106 7 90 7 117 9 101 9 85 9 6 2 19 18 1 2 3 6 22 4 118 22 102 22 86 22 71 22 55 22 5 22 16 127 20 1 20 36 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 32 6 251 32 159 32 2 32 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 26 5 251 26 11 26 2 26 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    31 11 2 112 11 64 11 48 11 3 11 3 118 16 102 16 86 16 71 16 55 16 5 16 16 16 4 0 4 2 4 35 ;PUSH N Bytes
SRP0            35         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 4          ;Move Direct Relative Point
DELTAP1         2 4 0 4 16 ;DELTA exception P1
MIRP[min,black] estemw 16  ;Move Indirect Relative Point
DELTAP1         5 16 55 16 71 16 86 16 102 16 118 ;DELTA exception P1
SHP[rp2]        3          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 11         ;Move Direct Relative Point
DELTAP1         3 11 48 11 64 11 112 ;DELTA exception P1
DELTAP2         2 11 256 11 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 26 ;Move Indirect Relative Point
DELTAP1         2 26 11 26 251 ;DELTA exception P1
DELTAP2         5 26 267 26 283 26 299 26 315 26 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 32  ;Move Indirect Relative Point
DELTAP1         2 32 159 32 251 ;DELTA exception P1
DELTAP2         6 32 267 32 283 32 299 32 315 32 367 32 383 ;DELTA exception P2
SRP0            36         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 20         ;Move Direct Relative Point
DELTAP1         1 20 127   ;DELTA exception P1
MIRP[min,black] estemw 22  ;Move Indirect Relative Point
DELTAP1         5 22 55 22 71 22 86 22 102 22 118 ;DELTA exception P1
SRP1            4          ;Set Reference Point 1
SRP2            22         ;Set Reference Point 2
SLOOP           6          ;Set LOOP variable
IP              3 2 1 18 19 2 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 9 85 9 101 9 117 7 90 7 106 7 122 ;DELTA exception P1
DELTAP1         6 13 85 13 101 13 117 15 90 15 106 15 122 ;DELTA exception P1
                           #--- NPUSHB    26 122 12 106 12 90 12 117 10 101 10 85 10 6 20 17 114 17 99 17 84 17 3 2 18 1 14 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 23 5 244 23 4 23 2 23 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 14 6 239 14 223 14 159 14 143 14 79 14 63 14 15 14 7 14 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    12 29 5 251 29 11 29 2 29 9 17 8 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   22 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    15 22 8 255 22 223 22 143 22 111 22 4 22 4 3 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         3          ;ALIGN to Reference Point
MIRP[rnd,grey]  tvheight 22 ;Move Indirect Relative Point
DELTAP1         4 22 111 22 143 22 223 22 255 ;DELTA exception P1
DELTAP2         8 22 287 22 335 22 367 22 399 22 431 22 447 22 479 22 511 ;DELTA exception P2
DELTAP3         1 22 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 8   ;Move Indirect Relative Point
IP              17         ;Interpolate Point
MIRP[min,rnd,grey] headstem 29 ;Move Indirect Relative Point
DELTAP1         2 29 11 29 251 ;DELTA exception P1
DELTAP2         5 29 267 29 283 29 299 29 315 29 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 14  ;Move Indirect Relative Point
DELTAP1         7 14 15 14 63 14 79 14 143 14 159 14 223 14 239 ;DELTA exception P1
DELTAP2         6 14 303 14 319 14 367 14 383 14 447 14 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 23 ;Move Indirect Relative Point
DELTAP1         2 23 4 23 244 ;DELTA exception P1
DELTAP2         5 23 260 23 276 23 292 23 308 23 496 ;DELTA exception P2
SRP1            14         ;Set Reference Point 1
SRP2            1          ;Set Reference Point 2
IP              18         ;Interpolate Point
IP              2          ;Interpolate Point
DELTAP1         3 17 84 17 99 17 114 ;DELTA exception P1
SRP0            17         ;Set Reference Point 0
ALIGNRP         20         ;ALIGN to Reference Point
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 10 85 10 101 10 117 12 90 12 106 12 122 ;DELTA exception P1
""",

    'uni0E1D': """
                           #--- NPUSHB    53 122 15 106 15 90 15 117 13 101 13 85 13 6 122 7 106 7 90 7 117 9 101 9 85 9 6 2 19 18 1 2 3 6 22 4 118 22 102 22 86 22 71 22 55 22 5 22 16 127 20 1 20 36 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 32 6 251 32 159 32 2 32 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 26 5 251 26 11 26 2 26 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    31 11 2 112 11 64 11 48 11 3 11 3 118 16 102 16 86 16 71 16 55 16 5 16 16 16 4 0 4 2 4 35 ;PUSH N Bytes
SRP0            35         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 4          ;Move Direct Relative Point
DELTAP1         2 4 0 4 16 ;DELTA exception P1
MIRP[min,black] estemw 16  ;Move Indirect Relative Point
DELTAP1         5 16 55 16 71 16 86 16 102 16 118 ;DELTA exception P1
SHP[rp2]        3          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 11         ;Move Direct Relative Point
DELTAP1         3 11 48 11 64 11 112 ;DELTA exception P1
DELTAP2         2 11 256 11 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 26 ;Move Indirect Relative Point
DELTAP1         2 26 11 26 251 ;DELTA exception P1
DELTAP2         5 26 267 26 283 26 299 26 315 26 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 32  ;Move Indirect Relative Point
DELTAP1         2 32 159 32 251 ;DELTA exception P1
DELTAP2         6 32 267 32 283 32 299 32 315 32 367 32 383 ;DELTA exception P2
SRP0            36         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 20         ;Move Direct Relative Point
DELTAP1         1 20 127   ;DELTA exception P1
MIRP[min,black] estemw 22  ;Move Indirect Relative Point
DELTAP1         5 22 55 22 71 22 86 22 102 22 118 ;DELTA exception P1
SRP1            4          ;Set Reference Point 1
SRP2            22         ;Set Reference Point 2
SLOOP           6          ;Set LOOP variable
IP              3 2 1 18 19 2 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 9 85 9 101 9 117 7 90 7 106 7 122 ;DELTA exception P1
DELTAP1         6 13 85 13 101 13 117 15 90 15 106 15 122 ;DELTA exception P1
                           #--- NPUSHB    26 122 12 106 12 90 12 117 10 101 10 85 10 6 20 17 114 17 99 17 84 17 3 2 18 1 14 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 23 5 244 23 4 23 2 23 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 14 6 239 14 223 14 159 14 143 14 79 14 63 14 15 14 7 14 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    16 29 5 251 29 11 29 2 29 9 17 8 34 22 38 3 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         3          ;ALIGN to Reference Point
MIRP[rnd,grey]  cvt_38 22  ;Move Indirect Relative Point
MIRP[rp0,rnd,grey] cvt_34 8   ;Move Indirect Relative Point
IP              17         ;Interpolate Point
MIRP[min,rnd,grey] headstem 29 ;Move Indirect Relative Point
DELTAP1         2 29 11 29 251 ;DELTA exception P1
DELTAP2         5 29 267 29 283 29 299 29 315 29 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 14  ;Move Indirect Relative Point
DELTAP1         7 14 15 14 63 14 79 14 143 14 159 14 223 14 239 ;DELTA exception P1
DELTAP2         6 14 303 14 319 14 367 14 383 14 447 14 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 23 ;Move Indirect Relative Point
DELTAP1         2 23 4 23 244 ;DELTA exception P1
DELTAP2         5 23 260 23 276 23 292 23 308 23 496 ;DELTA exception P2
SRP1            14         ;Set Reference Point 1
SRP2            1          ;Set Reference Point 2
IP              18         ;Interpolate Point
IP              2          ;Interpolate Point
DELTAP1         3 17 84 17 99 17 114 ;DELTA exception P1
SRP0            17         ;Set Reference Point 0
ALIGNRP         20         ;ALIGN to Reference Point
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 10 85 10 101 10 117 12 90 12 106 12 122 ;DELTA exception P1
""",

    'uni0E1E': """
                           #--- NPUSHB    51 117 6 101 6 85 6 122 8 106 8 90 8 6 117 14 101 14 85 14 122 12 106 12 90 12 6 2 19 18 3 20 16 1 118 22 102 22 86 22 71 22 55 22 5 22 16 127 20 1 20 36 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 26 6 244 26 144 26 2 26 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 32 5 244 32 4 32 2 32 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   10        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   10        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    35 10 3 79 10 63 10 47 10 3 10 3 118 16 102 16 86 16 71 16 55 16 5 16 16 175 4 32 4 16 4 0 4 4 4 35 ;PUSH N Bytes
SRP0            35         ;Set Reference Point 0
MDRP[rp0,rnd,white] 4          ;Move Direct Relative Point
DELTAP1         4 4 0 4 16 4 32 4 175 ;DELTA exception P1
MIRP[min,black] estemw 16  ;Move Indirect Relative Point
DELTAP1         5 16 55 16 71 16 86 16 102 16 118 ;DELTA exception P1
SHP[rp2]        3          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 10         ;Move Direct Relative Point
DELTAP1         3 10 47 10 63 10 79 ;DELTA exception P1
DELTAP2         3 10 287 10 303 10 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 32 ;Move Indirect Relative Point
DELTAP1         2 32 4 32 244 ;DELTA exception P1
DELTAP2         5 32 260 32 276 32 292 32 308 32 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 26  ;Move Indirect Relative Point
DELTAP1         2 26 144 26 244 ;DELTA exception P1
DELTAP2         6 26 260 26 276 26 292 26 308 26 352 26 368 ;DELTA exception P2
SRP0            36         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 20         ;Move Direct Relative Point
DELTAP1         1 20 127   ;DELTA exception P1
MIRP[min,black] estemw 22  ;Move Indirect Relative Point
DELTAP1         5 22 55 22 71 22 86 22 102 22 118 ;DELTA exception P1
ALIGNRP         1          ;ALIGN to Reference Point
SRP1            16         ;Set Reference Point 1
SRP2            20         ;Set Reference Point 2
SLOOP           3          ;Set LOOP variable
IP              18 19 2    ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 12 90 12 106 12 122 14 85 14 101 14 117 ;DELTA exception P1
DELTAP1         6 8 90 8 106 8 122 6 85 6 101 6 117 ;DELTA exception P1
                           #--- NPUSHB    20 125 2 106 2 90 2 3 117 11 101 11 85 11 122 9 106 9 90 9 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 23 5 244 23 4 23 2 23 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 7 6 239 7 223 7 159 7 143 7 79 7 63 7 15 7 7 7 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    17 29 5 251 29 11 29 2 29 9 20 19 18 17 2 5 13 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   22 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    15 22 8 255 22 223 22 143 22 111 22 4 22 4 3 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         3          ;ALIGN to Reference Point
MIRP[rnd,grey]  tvheight 22 ;Move Indirect Relative Point
DELTAP1         4 22 111 22 143 22 223 22 255 ;DELTA exception P1
DELTAP2         8 22 287 22 335 22 367 22 399 22 431 22 447 22 479 22 511 ;DELTA exception P2
DELTAP3         1 22 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 13  ;Move Indirect Relative Point
SLOOP           5          ;Set LOOP variable
IP              2 17 18 19 20 ;Interpolate Point
MIRP[min,rnd,grey] headstem 29 ;Move Indirect Relative Point
DELTAP1         2 29 11 29 251 ;DELTA exception P1
DELTAP2         5 29 267 29 283 29 299 29 315 29 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 7   ;Move Indirect Relative Point
DELTAP1         7 7 15 7 63 7 79 7 143 7 159 7 223 7 239 ;DELTA exception P1
DELTAP2         6 7 303 7 319 7 367 7 383 7 447 7 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 23 ;Move Indirect Relative Point
DELTAP1         2 23 4 23 244 ;DELTA exception P1
DELTAP2         5 23 260 23 276 23 292 23 308 23 496 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 9 90 9 106 9 122 11 85 11 101 11 117 ;DELTA exception P1
DELTAP1         3 2 90 2 106 2 125 ;DELTA exception P1
""",

    'uni0E1F': """
                           #--- NPUSHB    51 117 6 101 6 85 6 122 8 106 8 90 8 6 117 14 101 14 85 14 122 12 106 12 90 12 6 2 19 18 3 20 16 1 118 22 102 22 86 22 71 22 55 22 5 22 16 127 20 1 20 36 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 26 6 244 26 144 26 2 26 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 32 5 244 32 4 32 2 32 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   10        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   10        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    35 10 3 79 10 63 10 47 10 3 10 3 118 16 102 16 86 16 71 16 55 16 5 16 16 175 4 32 4 16 4 0 4 4 4 35 ;PUSH N Bytes
SRP0            35         ;Set Reference Point 0
MDRP[rp0,rnd,white] 4          ;Move Direct Relative Point
DELTAP1         4 4 0 4 16 4 32 4 175 ;DELTA exception P1
MIRP[min,black] estemw 16  ;Move Indirect Relative Point
DELTAP1         5 16 55 16 71 16 86 16 102 16 118 ;DELTA exception P1
SHP[rp2]        3          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 10         ;Move Direct Relative Point
DELTAP1         3 10 47 10 63 10 79 ;DELTA exception P1
DELTAP2         3 10 287 10 303 10 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 32 ;Move Indirect Relative Point
DELTAP1         2 32 4 32 244 ;DELTA exception P1
DELTAP2         5 32 260 32 276 32 292 32 308 32 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 26  ;Move Indirect Relative Point
DELTAP1         2 26 144 26 244 ;DELTA exception P1
DELTAP2         6 26 260 26 276 26 292 26 308 26 352 26 368 ;DELTA exception P2
SRP0            36         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 20         ;Move Direct Relative Point
DELTAP1         1 20 127   ;DELTA exception P1
MIRP[min,black] estemw 22  ;Move Indirect Relative Point
DELTAP1         5 22 55 22 71 22 86 22 102 22 118 ;DELTA exception P1
ALIGNRP         1          ;ALIGN to Reference Point
SRP1            16         ;Set Reference Point 1
SRP2            20         ;Set Reference Point 2
SLOOP           3          ;Set LOOP variable
IP              18 19 2    ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 12 90 12 106 12 122 14 85 14 101 14 117 ;DELTA exception P1
DELTAP1         6 8 90 8 106 8 122 6 85 6 101 6 117 ;DELTA exception P1
                           #--- NPUSHB    20 125 2 106 2 90 2 3 117 11 101 11 85 11 122 9 106 9 90 9 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 23 5 244 23 4 23 2 23 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 7 6 239 7 223 7 159 7 143 7 79 7 63 7 15 7 7 7 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    21 29 5 251 29 11 29 2 29 9 20 19 18 17 2 5 13 34 22 38 3 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         3          ;ALIGN to Reference Point
MIRP[rnd,grey]  cvt_38 22  ;Move Indirect Relative Point
MIRP[rp0,rnd,grey] cvt_34 13  ;Move Indirect Relative Point
SLOOP           5          ;Set LOOP variable
IP              2 17 18 19 20 ;Interpolate Point
MIRP[min,rnd,grey] headstem 29 ;Move Indirect Relative Point
DELTAP1         2 29 11 29 251 ;DELTA exception P1
DELTAP2         5 29 267 29 283 29 299 29 315 29 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 7   ;Move Indirect Relative Point
DELTAP1         7 7 15 7 63 7 79 7 143 7 159 7 223 7 239 ;DELTA exception P1
DELTAP2         6 7 303 7 319 7 367 7 383 7 447 7 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 23 ;Move Indirect Relative Point
DELTAP1         2 23 4 23 244 ;DELTA exception P1
DELTAP2         5 23 260 23 276 23 292 23 308 23 496 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 9 90 9 106 9 122 11 85 11 101 11 117 ;DELTA exception P1
DELTAP1         3 2 90 2 106 2 125 ;DELTA exception P1
""",

    'uni0E20': """
                           #--- NPUSHB    54 117 15 101 15 85 15 122 17 106 17 90 17 6 117 23 101 23 85 23 122 21 106 21 90 21 6 5 31 34 28 118 34 102 34 86 34 71 34 55 34 5 34 16 127 1 1 1 48 8 10 12 27 28 24 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 38 6 244 38 144 38 2 38 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 44 5 244 44 4 44 2 44 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   19        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   19        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    34 19 3 79 19 63 19 47 19 3 19 118 12 102 12 86 12 71 12 55 12 5 12 16 175 24 32 24 16 24 0 24 4 24 47 ;PUSH N Bytes
SRP0            47         ;Set Reference Point 0
MDRP[rp0,rnd,white] 24         ;Move Direct Relative Point
DELTAP1         4 24 0 24 16 24 32 24 175 ;DELTA exception P1
MIRP[min,black] estemw 12  ;Move Indirect Relative Point
DELTAP1         5 12 55 12 71 12 86 12 102 12 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 19         ;Move Direct Relative Point
DELTAP1         3 19 47 19 63 19 79 ;DELTA exception P1
DELTAP2         3 19 287 19 303 19 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 44 ;Move Indirect Relative Point
DELTAP1         2 44 4 44 244 ;DELTA exception P1
DELTAP2         5 44 260 44 276 44 292 44 308 44 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 38  ;Move Indirect Relative Point
DELTAP1         2 38 144 38 244 ;DELTA exception P1
DELTAP2         6 38 260 38 276 38 292 38 308 38 352 38 368 ;DELTA exception P2
SRP0            24         ;Set Reference Point 0
MDRP[rp0,grey]  28         ;Move Direct Relative Point
MDRP[grey]      27         ;Move Direct Relative Point
SRP0            12         ;Set Reference Point 0
MDRP[rp0,grey]  10         ;Move Direct Relative Point
MDRP[grey]      8          ;Move Direct Relative Point
SRP0            48         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         1 1 127    ;DELTA exception P1
MIRP[min,black] estemw 34  ;Move Indirect Relative Point
DELTAP1         5 34 55 34 71 34 86 34 102 34 118 ;DELTA exception P1
SRP1            28         ;Set Reference Point 1
SRP2            34         ;Set Reference Point 2
IP              31         ;Interpolate Point
IP              5          ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 21 90 21 106 21 122 23 85 23 101 23 117 ;DELTA exception P1
DELTAP1         6 17 90 17 106 17 122 15 85 15 101 15 117 ;DELTA exception P1
                           #--- NPUSHB    13 117 20 101 20 85 20 122 18 106 18 90 18 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 41 5 251 41 11 41 2 41 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 22 6 224 22 208 22 144 22 128 22 64 22 48 22 0 22 7 22 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    34 35 5 244 35 4 35 2 35 9 16 31 1 121 5 104 5 88 5 3 5 10 34 2 12 10 9 8 28 27 25 9 31 34 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 31  ;Move Indirect Relative Point
SLOOP           9          ;Set LOOP variable
IP              25 27 28 8 9 10 12 2 34 ;Interpolate Point
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
DELTAP1         3 5 88 5 104 5 121 ;DELTA exception P1
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 16  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 35 ;Move Indirect Relative Point
DELTAP1         2 35 4 35 244 ;DELTA exception P1
DELTAP2         5 35 260 35 276 35 292 35 308 35 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 22  ;Move Indirect Relative Point
DELTAP1         7 22 0 22 48 22 64 22 128 22 144 22 208 22 224 ;DELTA exception P1
DELTAP2         6 22 288 22 304 22 352 22 368 22 432 22 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 41 ;Move Indirect Relative Point
DELTAP1         2 41 11 41 251 ;DELTA exception P1
DELTAP2         5 41 267 41 283 41 299 41 315 41 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 18 90 18 106 18 122 20 85 20 101 20 117 ;DELTA exception P1
""",

    'uni0E21': """
                           #--- NPUSHB    70 117 15 101 15 85 15 122 6 106 6 90 6 117 4 101 4 85 4 122 17 106 17 90 17 12 117 23 101 23 85 23 122 21 106 21 90 21 117 12 101 12 85 12 122 10 106 10 90 10 12 1 118 29 102 29 86 29 71 29 55 29 5 29 16 127 27 1 27 55 45 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    10 33 6 244 33 144 33 2 33 36 51 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    10 39 5 244 39 4 39 2 39 9 8 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   19        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   19        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    35 19 3 79 19 63 19 47 19 3 19 2 118 25 102 25 86 25 71 25 55 25 5 25 16 175 13 32 13 16 13 0 13 4 13 54 ;PUSH N Bytes
SRP0            54         ;Set Reference Point 0
MDRP[rp0,rnd,white] 13         ;Move Direct Relative Point
DELTAP1         4 13 0 13 16 13 32 13 175 ;DELTA exception P1
MIRP[min,black] estemw 25  ;Move Indirect Relative Point
DELTAP1         5 25 55 25 71 25 86 25 102 25 118 ;DELTA exception P1
SHP[rp2]        2          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 19         ;Move Direct Relative Point
DELTAP1         3 19 47 19 63 19 79 ;DELTA exception P1
DELTAP2         3 19 287 19 303 19 319 ;DELTA exception P2
ALIGNRP         8          ;ALIGN to Reference Point
MIRP[min,rnd,grey] headstem 39 ;Move Indirect Relative Point
DELTAP1         2 39 4 39 244 ;DELTA exception P1
DELTAP2         5 39 260 39 276 39 292 39 308 39 496 ;DELTA exception P2
SHP[rp2]        51         ;SHift Point using reference point
MIRP[min,rnd,grey] cvt_36 33  ;Move Indirect Relative Point
DELTAP1         2 33 144 33 244 ;DELTA exception P1
DELTAP2         6 33 260 33 276 33 292 33 308 33 352 33 368 ;DELTA exception P2
SHP[rp2]        45         ;SHift Point using reference point
SRP0            55         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 27         ;Move Direct Relative Point
DELTAP1         1 27 127   ;DELTA exception P1
MIRP[min,black] estemw 29  ;Move Indirect Relative Point
DELTAP1         5 29 55 29 71 29 86 29 102 29 118 ;DELTA exception P1
ALIGNRP         1          ;ALIGN to Reference Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 10 90 10 106 10 122 12 85 12 101 12 117 21 90 21 106 21 122 23 85 23 101 23 117 ;DELTA exception P1
DELTAP1         12 17 90 17 106 17 122 4 85 4 101 4 117 6 90 6 106 6 122 15 85 15 101 15 117 ;DELTA exception P1
                           #--- NPUSHB    32 122 2 106 2 90 2 3 122 7 106 7 90 7 117 20 101 20 85 20 122 18 106 18 90 18 117 9 101 9 85 9 12 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    11 48 5 251 48 11 48 2 48 9 2 26 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 11 6 224 11 208 11 144 11 128 11 64 11 48 11 0 11 7 11 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    12 42 5 244 42 4 42 2 42 9 5 31 1 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 30 5 244 30 4 30 2 30 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 16 6 239 16 223 16 159 16 143 16 79 16 63 16 15 16 7 16 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    11 36 5 251 36 11 36 2 36 9 22 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   29 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    23 29 8 255 29 223 29 143 29 111 29 4 29 4 118 27 103 27 87 27 3 27 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 27  ;Move Indirect Relative Point
DELTAP1         3 27 87 27 103 27 118 ;DELTA exception P1
MIRP[rnd,grey]  tvheight 29 ;Move Indirect Relative Point
DELTAP1         4 29 111 29 143 29 223 29 255 ;DELTA exception P1
DELTAP2         8 29 287 29 335 29 367 29 399 29 431 29 447 29 479 29 511 ;DELTA exception P2
DELTAP3         1 29 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 22  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 36 ;Move Indirect Relative Point
DELTAP1         2 36 11 36 251 ;DELTA exception P1
DELTAP2         5 36 267 36 283 36 299 36 315 36 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 16  ;Move Indirect Relative Point
DELTAP1         7 16 15 16 63 16 79 16 143 16 159 16 223 16 239 ;DELTA exception P1
DELTAP2         6 16 303 16 319 16 367 16 383 16 447 16 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 30 ;Move Indirect Relative Point
DELTAP1         2 30 4 30 244 ;DELTA exception P1
DELTAP2         5 30 260 30 276 30 292 30 308 30 496 ;DELTA exception P2
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 5   ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 42 ;Move Indirect Relative Point
DELTAP1         2 42 4 42 244 ;DELTA exception P1
DELTAP2         5 42 260 42 276 42 292 42 308 42 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 11  ;Move Indirect Relative Point
DELTAP1         7 11 0 11 48 11 64 11 128 11 144 11 208 11 224 ;DELTA exception P1
DELTAP2         6 11 288 11 304 11 352 11 368 11 432 11 448 ;DELTA exception P2
IP              26         ;Interpolate Point
IP              2          ;Interpolate Point
MIRP[min,rnd,grey] headstem 48 ;Move Indirect Relative Point
DELTAP1         2 48 11 48 251 ;DELTA exception P1
DELTAP2         5 48 267 48 283 48 299 48 315 48 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 9 85 9 101 9 117 18 90 18 106 18 122 20 85 20 101 20 117 7 90 7 106 7 122 ;DELTA exception P1
DELTAP1         3 2 90 2 106 2 122 ;DELTA exception P1
""",

    'uni0E22': """
                           #--- NPUSHB    44 122 18 106 18 90 18 117 16 101 16 85 16 6 117 12 101 12 85 12 122 10 106 10 90 10 6 118 31 102 31 86 31 71 31 55 31 5 31 16 127 29 1 29 45 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 41 6 251 41 159 41 2 41 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    46 35 5 251 35 11 35 2 35 9 224 14 112 14 96 14 64 14 48 14 5 14 5 24 19 118 27 102 27 86 27 71 27 55 27 5 27 16 8 32 1 16 1 0 1 3 1 ;PUSH N Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
DELTAP1         3 1 0 1 16 1 32 ;DELTA exception P1
ALIGNRP         8          ;ALIGN to Reference Point
MIRP[min,black] estemw 27  ;Move Indirect Relative Point
DELTAP1         5 27 55 27 71 27 86 27 102 27 118 ;DELTA exception P1
SHP[rp2]        19         ;SHift Point using reference point
MDRP[rnd,grey]  24         ;Move Direct Relative Point
IP              5          ;Interpolate Point
MDRP[rp0,rnd,grey] 14         ;Move Direct Relative Point
DELTAP1         5 14 48 14 64 14 96 14 112 14 224 ;DELTA exception P1
MIRP[min,rnd,grey] headstem 35 ;Move Indirect Relative Point
DELTAP1         2 35 11 35 251 ;DELTA exception P1
DELTAP2         5 35 267 35 283 35 299 35 315 35 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 41  ;Move Indirect Relative Point
DELTAP1         2 41 159 41 251 ;DELTA exception P1
DELTAP2         6 41 267 41 283 41 299 41 315 41 367 41 383 ;DELTA exception P2
SRP0            45         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 29         ;Move Direct Relative Point
DELTAP1         1 29 127   ;DELTA exception P1
MIRP[min,black] estemw 31  ;Move Indirect Relative Point
DELTAP1         5 31 55 31 71 31 86 31 102 31 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 10 90 10 106 10 122 12 85 12 101 12 117 ;DELTA exception P1
DELTAP1         6 16 85 16 101 16 117 18 90 18 106 18 122 ;DELTA exception P1
                           #--- NPUSHB    24 122 15 106 15 90 15 117 13 101 13 85 13 6 5 121 24 104 24 88 24 3 24 10 23 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    10 32 5 244 32 4 32 2 32 9 19 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 17 6 239 17 223 17 159 17 143 17 79 17 63 17 15 17 7 17 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    11 38 5 251 38 11 38 2 38 9 11 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   31 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   31        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    23 31 8 255 31 223 31 143 31 111 31 4 31 4 118 28 103 28 87 28 3 28 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 28  ;Move Indirect Relative Point
DELTAP1         3 28 87 28 103 28 118 ;DELTA exception P1
MIRP[rnd,grey]  tvheight 31 ;Move Indirect Relative Point
DELTAP1         4 31 111 31 143 31 223 31 255 ;DELTA exception P1
DELTAP2         8 31 287 31 335 31 367 31 399 31 431 31 447 31 479 31 511 ;DELTA exception P2
DELTAP3         1 31 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 11  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 38 ;Move Indirect Relative Point
DELTAP1         2 38 11 38 251 ;DELTA exception P1
DELTAP2         5 38 267 38 283 38 299 38 315 38 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 17  ;Move Indirect Relative Point
DELTAP1         7 17 15 17 63 17 79 17 143 17 159 17 223 17 239 ;DELTA exception P1
DELTAP2         6 17 303 17 319 17 367 17 383 17 447 17 463 ;DELTA exception P2
IP              19         ;Interpolate Point
MIRP[min,rnd,grey] headstem 32 ;Move Indirect Relative Point
DELTAP1         2 32 4 32 244 ;DELTA exception P1
DELTAP2         5 32 260 32 276 32 292 32 308 32 496 ;DELTA exception P2
MDRP[rp0,min,rnd,grey] 23         ;Move Direct Relative Point
MIRP[min,black] estemt 24  ;Move Indirect Relative Point
DELTAP1         3 24 88 24 104 24 121 ;DELTA exception P1
IP              5          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 13 85 13 101 13 117 15 90 15 106 15 122 ;DELTA exception P1
""",

    'uni0E23': """
                           #--- PUSHB_1   117       ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- PUSHB_1   101       ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- PUSHB_1   85        ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- NPUSHB    20 122 1 106 1 90 1 6 117 7 101 7 85 7 122 5 106 5 90 5 6 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 41 6 244 41 144 41 2 41 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 47 5 244 47 4 47 2 47 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   3         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   3         ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    48 3 3 79 3 63 3 47 3 3 3 118 34 102 34 86 34 71 34 55 34 5 34 16 8 8 18 25 28 15 5 22 12 22 51 118 31 102 31 86 31 71 31 55 31 5 31 16 12 ;PUSH N Bytes
MDAP[rnd]       12         ;Move Direct Absolute Point
MIRP[min,black] estemw 31  ;Move Indirect Relative Point
DELTAP1         5 31 55 31 71 31 86 31 102 31 118 ;DELTA exception P1
SRP0            51         ;Set Reference Point 0
MDRP[rp0,min,rnd,white] 22         ;Move Direct Relative Point
SRP1            12         ;Set Reference Point 1
SRP2            22         ;Set Reference Point 2
SLOOP           5          ;Set LOOP variable
IP              15 28 25 18 8 ;Interpolate Point
MDAP[rnd]       8          ;Move Direct Absolute Point
MIRP[min,black] estemw 34  ;Move Indirect Relative Point
DELTAP1         5 34 55 34 71 34 86 34 102 34 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 3          ;Move Direct Relative Point
DELTAP1         3 3 47 3 63 3 79 ;DELTA exception P1
DELTAP2         3 3 287 3 303 3 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 47 ;Move Indirect Relative Point
DELTAP1         2 47 4 47 244 ;DELTA exception P1
DELTAP2         5 47 260 47 276 47 292 47 308 47 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 41  ;Move Indirect Relative Point
DELTAP1         2 41 144 41 244 ;DELTA exception P1
DELTAP2         6 41 260 41 276 41 292 41 308 41 352 41 368 ;DELTA exception P2
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 5 90 5 106 5 122 7 85 7 101 7 117 ;DELTA exception P1
DELTAP1         6 1 90 1 106 1 122 -1 85 -1 101 -1 117 ;DELTA exception P1
                           #--- NPUSHB    13 117 4 101 4 85 4 122 2 106 2 90 2 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 44 5 251 44 11 44 2 44 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 6 6 224 6 208 6 144 6 128 6 64 6 48 6 0 6 7 6 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    63 38 5 244 38 4 38 2 38 9 0 31 50 121 22 104 22 88 22 3 22 10 21 15 118 18 103 18 87 18 3 18 10 75 25 59 25 36 25 20 25 4 25 5 25 122 28 106 28 89 28 3 28 6 34 9 11 32 31 12 6 15 34 50 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       50         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 15  ;Move Indirect Relative Point
SLOOP           6          ;Set LOOP variable
IP              12 31 32 11 9 34 ;Interpolate Point
MIRP[min,black] estemtc 28 ;Move Indirect Relative Point
DELTAP1         3 28 89 28 106 28 122 ;DELTA exception P1
MDRP[rp0,rnd,grey] 25         ;Move Direct Relative Point
DELTAP1         5 25 4 25 20 25 36 25 59 25 75 ;DELTA exception P1
MIRP[min,black] estemt 18  ;Move Indirect Relative Point
DELTAP1         3 18 87 18 103 18 118 ;DELTA exception P1
SRP0            15         ;Set Reference Point 0
MDRP[rp0,grey]  21         ;Move Direct Relative Point
MIRP[min,black] estemt 22  ;Move Indirect Relative Point
DELTAP1         3 22 88 22 104 22 121 ;DELTA exception P1
SRP0            50         ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 0   ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 38 ;Move Indirect Relative Point
DELTAP1         2 38 4 38 244 ;DELTA exception P1
DELTAP2         5 38 260 38 276 38 292 38 308 38 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 6   ;Move Indirect Relative Point
DELTAP1         7 6 0 6 48 6 64 6 128 6 144 6 208 6 224 ;DELTA exception P1
DELTAP2         6 6 288 6 304 6 352 6 368 6 432 6 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 44 ;Move Indirect Relative Point
DELTAP1         2 44 11 44 251 ;DELTA exception P1
DELTAP2         5 44 267 44 283 44 299 44 315 44 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 2 90 2 106 2 122 4 85 4 101 4 117 ;DELTA exception P1
""",

    'uni0E24': """
                           #--- NPUSHB    20 118 34 102 34 86 34 71 34 55 34 5 34 16 127 1 0 1 2 1 48 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 44 6 251 44 159 44 2 44 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 38 5 251 38 11 38 2 38 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    12 18 2 112 18 64 18 48 18 3 18 24 8 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    42 8 12 28 10 12 27 155 28 139 28 123 28 107 28 91 28 27 28 11 28 7 28 118 12 102 12 86 12 71 12 55 12 5 12 16 16 24 0 24 2 24 47 ;PUSH N Bytes
SRP0            47         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 24         ;Move Direct Relative Point
DELTAP1         2 24 0 24 16 ;DELTA exception P1
MIRP[min,black] estemw 12  ;Move Indirect Relative Point
DELTAP1         5 12 55 12 71 12 86 12 102 12 118 ;DELTA exception P1
MDRP[rp0,grey]  28         ;Move Direct Relative Point
DELTAP1         7 28 11 28 27 28 91 28 107 28 123 28 139 28 155 ;DELTA exception P1
MDRP[grey]      27         ;Move Direct Relative Point
SRP0            12         ;Set Reference Point 0
MDRP[grey]      10         ;Move Direct Relative Point
SRP1            28         ;Set Reference Point 1
SRP2            12         ;Set Reference Point 2
IP              8          ;Interpolate Point
SHPIX           -8 8       ;SHift point by a PIXel amount
SRP0            24         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 18         ;Move Direct Relative Point
DELTAP1         3 18 48 18 64 18 112 ;DELTA exception P1
DELTAP2         2 18 256 18 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 38 ;Move Indirect Relative Point
DELTAP1         2 38 11 38 251 ;DELTA exception P1
DELTAP2         5 38 267 38 283 38 299 38 315 38 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 44  ;Move Indirect Relative Point
DELTAP1         2 44 159 44 251 ;DELTA exception P1
DELTAP2         6 44 267 44 283 44 299 44 315 44 367 44 383 ;DELTA exception P2
SRP0            48         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 127 ;DELTA exception P1
MIRP[min,black] estemw 34  ;Move Indirect Relative Point
DELTAP1         5 34 55 34 71 34 86 34 102 34 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    16 122 19 106 19 90 19 117 17 101 17 85 17 6 1 0 47 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 41 5 251 41 11 41 2 41 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 15 6 224 15 208 15 144 15 128 15 64 15 48 15 0 15 7 15 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    34 35 5 244 35 4 35 2 35 9 21 31 47 121 5 104 5 88 5 3 5 10 34 2 12 10 9 8 28 27 25 9 31 34 47 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       47         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 31  ;Move Indirect Relative Point
SLOOP           9          ;Set LOOP variable
IP              25 27 28 8 9 10 12 2 34 ;Interpolate Point
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
DELTAP1         3 5 88 5 104 5 121 ;DELTA exception P1
SRP0            47         ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 21  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 35 ;Move Indirect Relative Point
DELTAP1         2 35 4 35 244 ;DELTA exception P1
DELTAP2         5 35 260 35 276 35 292 35 308 35 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 15  ;Move Indirect Relative Point
DELTAP1         7 15 0 15 48 15 64 15 128 15 144 15 208 15 224 ;DELTA exception P1
DELTAP2         6 15 288 15 304 15 352 15 368 15 432 15 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 41 ;Move Indirect Relative Point
DELTAP1         2 41 11 41 251 ;DELTA exception P1
DELTAP2         5 41 267 41 283 41 299 41 315 41 511 ;DELTA exception P2
SRP0            47         ;Set Reference Point 0
MIRP[rnd,grey]  evheight_lu 1 ;Move Indirect Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 17 85 17 101 17 117 19 90 19 106 19 122 ;DELTA exception P1
""",

    'uni0E25': """
                           #--- NPUSHB    55 122 18 106 18 90 18 117 16 101 16 85 16 6 117 12 101 12 85 12 122 10 106 10 90 10 6 31 38 41 35 5 24 27 7 27 118 41 102 41 86 41 71 41 55 41 5 41 16 127 1 0 1 2 1 55 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 51 6 251 51 159 51 2 51 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 45 5 251 45 11 45 2 45 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    31 14 2 112 14 64 14 48 14 3 14 35 118 8 102 8 86 8 71 8 55 8 5 8 16 16 20 0 20 2 20 54 ;PUSH N Bytes
SRP0            54         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 20         ;Move Direct Relative Point
DELTAP1         2 20 0 20 16 ;DELTA exception P1
MIRP[min,black] estemw 8   ;Move Indirect Relative Point
DELTAP1         5 8 55 8 71 8 86 8 102 8 118 ;DELTA exception P1
MDRP[rnd,grey]  35         ;Move Direct Relative Point
MDRP[rp0,rnd,grey] 14         ;Move Direct Relative Point
DELTAP1         3 14 48 14 64 14 112 ;DELTA exception P1
DELTAP2         2 14 256 14 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 45 ;Move Indirect Relative Point
DELTAP1         2 45 11 45 251 ;DELTA exception P1
DELTAP2         5 45 267 45 283 45 299 45 315 45 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 51  ;Move Indirect Relative Point
DELTAP1         2 51 159 51 251 ;DELTA exception P1
DELTAP2         6 51 267 51 283 51 299 51 315 51 367 51 383 ;DELTA exception P2
SRP0            55         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 127 ;DELTA exception P1
MIRP[min,black] estemw 41  ;Move Indirect Relative Point
DELTAP1         5 41 55 41 71 41 86 41 102 41 118 ;DELTA exception P1
ALIGNRP         27         ;ALIGN to Reference Point
SRP1            7          ;Set Reference Point 1
SRP2            27         ;Set Reference Point 2
IP              24         ;Interpolate Point
IP              5          ;Interpolate Point
SRP1            35         ;Set Reference Point 1
SRP2            41         ;Set Reference Point 2
IP              38         ;Interpolate Point
IP              31         ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 10 90 10 106 10 122 12 85 12 101 12 117 ;DELTA exception P1
DELTAP1         6 16 85 16 101 16 117 18 90 18 106 18 122 ;DELTA exception P1
                           #--- NPUSHB    13 122 15 106 15 90 15 117 13 101 13 85 13 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 48 5 251 48 11 48 2 48 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 11 6 224 11 208 11 144 11 128 11 64 11 48 11 0 11 7 11 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    43 42 5 244 42 4 42 2 42 9 17 31 1 121 5 104 5 88 5 3 5 10 24 34 121 31 104 31 88 31 3 31 10 34 24 7 41 28 8 21 7 38 34 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 38  ;Move Indirect Relative Point
SLOOP           7          ;Set LOOP variable
IP              21 8 28 41 7 24 34 ;Interpolate Point
MIRP[min,black] estemt 31  ;Move Indirect Relative Point
DELTAP1         3 31 88 31 104 31 121 ;DELTA exception P1
MDAP[rnd]       34         ;Move Direct Absolute Point
MDAP[rnd]       24         ;Move Direct Absolute Point
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
DELTAP1         3 5 88 5 104 5 121 ;DELTA exception P1
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 17  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 42 ;Move Indirect Relative Point
DELTAP1         2 42 4 42 244 ;DELTA exception P1
DELTAP2         5 42 260 42 276 42 292 42 308 42 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 11  ;Move Indirect Relative Point
DELTAP1         7 11 0 11 48 11 64 11 128 11 144 11 208 11 224 ;DELTA exception P1
DELTAP2         6 11 288 11 304 11 352 11 368 11 432 11 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 48 ;Move Indirect Relative Point
DELTAP1         2 48 11 48 251 ;DELTA exception P1
DELTAP2         5 48 267 48 283 48 299 48 315 48 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 13 85 13 101 13 117 15 90 15 106 15 122 ;DELTA exception P1
""",

    'uni0E26': """
                           #--- NPUSHB    54 117 15 101 15 85 15 122 17 106 17 90 17 6 117 23 101 23 85 23 122 21 106 21 90 21 6 5 31 34 28 118 34 102 34 86 34 71 34 55 34 5 34 16 127 1 1 1 48 8 10 12 27 28 24 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 38 6 244 38 144 38 2 38 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 44 5 244 44 4 44 2 44 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   19        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   19        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    34 19 3 79 19 63 19 47 19 3 19 118 12 102 12 86 12 71 12 55 12 5 12 16 175 24 32 24 16 24 0 24 4 24 47 ;PUSH N Bytes
SRP0            47         ;Set Reference Point 0
MDRP[rp0,rnd,white] 24         ;Move Direct Relative Point
DELTAP1         4 24 0 24 16 24 32 24 175 ;DELTA exception P1
MIRP[min,black] estemw 12  ;Move Indirect Relative Point
DELTAP1         5 12 55 12 71 12 86 12 102 12 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 19         ;Move Direct Relative Point
DELTAP1         3 19 47 19 63 19 79 ;DELTA exception P1
DELTAP2         3 19 287 19 303 19 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 44 ;Move Indirect Relative Point
DELTAP1         2 44 4 44 244 ;DELTA exception P1
DELTAP2         5 44 260 44 276 44 292 44 308 44 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 38  ;Move Indirect Relative Point
DELTAP1         2 38 144 38 244 ;DELTA exception P1
DELTAP2         6 38 260 38 276 38 292 38 308 38 352 38 368 ;DELTA exception P2
SRP0            24         ;Set Reference Point 0
MDRP[rp0,grey]  28         ;Move Direct Relative Point
MDRP[grey]      27         ;Move Direct Relative Point
SRP0            12         ;Set Reference Point 0
MDRP[rp0,grey]  10         ;Move Direct Relative Point
MDRP[grey]      8          ;Move Direct Relative Point
SRP0            48         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         1 1 127    ;DELTA exception P1
MIRP[min,black] estemw 34  ;Move Indirect Relative Point
DELTAP1         5 34 55 34 71 34 86 34 102 34 118 ;DELTA exception P1
SRP1            28         ;Set Reference Point 1
SRP2            34         ;Set Reference Point 2
IP              31         ;Interpolate Point
IP              5          ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 21 90 21 106 21 122 23 85 23 101 23 117 ;DELTA exception P1
DELTAP1         6 17 90 17 106 17 122 15 85 15 101 15 117 ;DELTA exception P1
                           #--- NPUSHB    16 117 20 101 20 85 20 122 18 106 18 90 18 6 1 0 47 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 41 5 251 41 11 41 2 41 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   22        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 22 6 224 22 208 22 144 22 128 22 64 22 48 22 0 22 7 22 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    34 35 5 244 35 4 35 2 35 9 16 31 47 121 5 104 5 88 5 3 5 10 34 2 12 10 9 8 28 27 25 9 31 34 47 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       47         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 31  ;Move Indirect Relative Point
SLOOP           9          ;Set LOOP variable
IP              25 27 28 8 9 10 12 2 34 ;Interpolate Point
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
DELTAP1         3 5 88 5 104 5 121 ;DELTA exception P1
SRP0            47         ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 16  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 35 ;Move Indirect Relative Point
DELTAP1         2 35 4 35 244 ;DELTA exception P1
DELTAP2         5 35 260 35 276 35 292 35 308 35 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 22  ;Move Indirect Relative Point
DELTAP1         7 22 0 22 48 22 64 22 128 22 144 22 208 22 224 ;DELTA exception P1
DELTAP2         6 22 288 22 304 22 352 22 368 22 432 22 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 41 ;Move Indirect Relative Point
DELTAP1         2 41 11 41 251 ;DELTA exception P1
DELTAP2         5 41 267 41 283 41 299 41 315 41 511 ;DELTA exception P2
SRP0            47         ;Set Reference Point 0
MIRP[rnd,grey]  evheight_lu 1 ;Move Indirect Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 18 90 18 106 18 122 20 85 20 101 20 117 ;DELTA exception P1
""",

    'uni0E27': """
                           #--- PUSHB_1   117       ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- PUSHB_1   101       ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- PUSHB_1   85        ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- NPUSHB    24 122 1 106 1 90 1 6 117 7 101 7 85 7 122 5 106 5 90 5 6 12 19 22 16 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 29 6 244 29 144 29 2 29 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 35 5 244 35 4 35 2 35 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   3         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   3         ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    31 3 3 79 3 63 3 47 3 3 3 118 22 102 22 86 22 71 22 55 22 5 22 16 127 8 0 8 2 8 39 16 ;PUSH N Bytes
MDAP[rnd]       16         ;Move Direct Absolute Point
SRP0            39         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 8          ;Move Direct Relative Point
DELTAP1         2 8 0 8 127 ;DELTA exception P1
MIRP[min,black] estemw 22  ;Move Indirect Relative Point
DELTAP1         5 22 55 22 71 22 86 22 102 22 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 3          ;Move Direct Relative Point
DELTAP1         3 3 47 3 63 3 79 ;DELTA exception P1
DELTAP2         3 3 287 3 303 3 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 35 ;Move Indirect Relative Point
DELTAP1         2 35 4 35 244 ;DELTA exception P1
DELTAP2         5 35 260 35 276 35 292 35 308 35 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 29  ;Move Indirect Relative Point
DELTAP1         2 29 144 29 244 ;DELTA exception P1
DELTAP2         6 29 260 29 276 29 292 29 308 29 352 29 368 ;DELTA exception P2
SRP1            16         ;Set Reference Point 1
SRP2            22         ;Set Reference Point 2
IP              19         ;Interpolate Point
IP              12         ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 5 90 5 106 5 122 7 85 7 101 7 117 ;DELTA exception P1
DELTAP1         6 1 90 1 106 1 122 -1 85 -1 101 -1 117 ;DELTA exception P1
                           #--- NPUSHB    13 117 4 101 4 85 4 122 2 106 2 90 2 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 32 5 251 32 11 32 2 32 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 6 6 224 6 208 6 144 6 128 6 64 6 48 6 0 6 7 6 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    29 26 5 244 26 4 26 2 26 9 0 31 38 15 121 12 104 12 88 12 3 12 10 15 22 9 3 19 34 38 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       38         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 19  ;Move Indirect Relative Point
SLOOP           3          ;Set LOOP variable
IP              9 22 15    ;Interpolate Point
MIRP[min,black] estemt 12  ;Move Indirect Relative Point
DELTAP1         3 12 88 12 104 12 121 ;DELTA exception P1
MDAP[rnd]       15         ;Move Direct Absolute Point
SRP0            38         ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 0   ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 26 ;Move Indirect Relative Point
DELTAP1         2 26 4 26 244 ;DELTA exception P1
DELTAP2         5 26 260 26 276 26 292 26 308 26 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 6   ;Move Indirect Relative Point
DELTAP1         7 6 0 6 48 6 64 6 128 6 144 6 208 6 224 ;DELTA exception P1
DELTAP2         6 6 288 6 304 6 352 6 368 6 432 6 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 32 ;Move Indirect Relative Point
DELTAP1         2 32 11 32 251 ;DELTA exception P1
DELTAP2         5 32 267 32 283 32 299 32 315 32 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 2 90 2 106 2 122 4 85 4 101 4 117 ;DELTA exception P1
""",

    'uni0E28': """
                           #--- NPUSHB    27 122 30 106 30 90 30 117 28 101 28 85 28 6 122 22 106 22 90 22 117 24 101 24 85 24 6 52 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    33 9 8 52 4 47 9 11 45 6 54 42 50 49 118 54 102 54 86 54 71 54 55 54 5 54 16 127 1 0 1 2 1 68 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    10 58 5 251 58 11 58 2 58 9 32 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 26 6 224 26 208 26 144 26 128 26 64 26 48 26 0 26 7 26 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 64 5 244 64 4 64 2 64 9 ;PUSH N Bytes
                           #--- PUSHW_1   320       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- NPUSHB    51 20 2 112 20 96 20 2 20 42 17 35 14 118 35 102 35 86 35 71 35 55 35 5 35 16 16 36 1 36 118 14 102 14 86 14 71 14 55 14 5 14 16 32 42 16 42 0 42 3 42 67 ;PUSH N Bytes
SRP0            67         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 42         ;Move Direct Relative Point
DELTAP1         3 42 0 42 16 42 32 ;DELTA exception P1
MIRP[min,black] estemw 14  ;Move Indirect Relative Point
DELTAP1         5 14 55 14 71 14 86 14 102 14 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 36         ;Move Direct Relative Point
DELTAP1         1 36 16    ;DELTA exception P1
MIRP[min,black] estemw 35  ;Move Indirect Relative Point
DELTAP1         5 35 55 35 71 35 86 35 102 35 118 ;DELTA exception P1
SRP1            14         ;Set Reference Point 1
SRP2            35         ;Set Reference Point 2
IP              17         ;Interpolate Point
SRP0            42         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 20         ;Move Direct Relative Point
DELTAP1         2 20 96 20 112 ;DELTA exception P1
DELTAP2         2 20 304 20 320 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 64 ;Move Indirect Relative Point
DELTAP1         2 64 4 64 244 ;DELTA exception P1
DELTAP2         5 64 260 64 276 64 292 64 308 64 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 26  ;Move Indirect Relative Point
DELTAP1         7 26 0 26 48 26 64 26 128 26 144 26 208 26 224 ;DELTA exception P1
DELTAP2         6 26 288 26 304 26 352 26 368 26 432 26 448 ;DELTA exception P2
IP              32         ;Interpolate Point
MIRP[min,rnd,grey] headstem 58 ;Move Indirect Relative Point
DELTAP1         2 58 11 58 251 ;DELTA exception P1
DELTAP2         5 58 267 58 283 58 299 58 315 58 511 ;DELTA exception P2
SRP0            68         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 127 ;DELTA exception P1
MIRP[min,black] estemw 54  ;Move Indirect Relative Point
DELTAP1         5 54 55 54 71 54 86 54 102 54 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 49         ;Move Direct Relative Point
MDRP[grey]      50         ;Move Direct Relative Point
SRP1            42         ;Set Reference Point 1
SRP2            54         ;Set Reference Point 2
SLOOP           6          ;Set LOOP variable
IP              45 11 9 47 4 52 ;Interpolate Point
SHPIX           8 9        ;SHift point by a PIXel amount
SHPIX           -8 52      ;SHift point by a PIXel amount
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 24 85 24 101 24 117 22 90 22 106 22 122 ;DELTA exception P1
DELTAP1         6 28 85 28 101 28 117 30 90 30 106 30 122 ;DELTA exception P1
                           #--- NPUSHB    27 116 47 100 47 84 47 123 4 107 4 91 4 6 122 27 106 27 90 27 117 25 101 25 85 25 6 47 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- PUSHB_3   4 8 17    ;PUSH Bytes
                           #--- PUSHW_1   -16       ;PUSH Words
                           #--- NPUSHB    15 32 8 116 20 100 20 84 20 121 32 105 32 89 32 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    11 55 5 244 55 4 55 2 55 9 20 32 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 29 6 239 29 223 29 159 29 143 29 79 29 63 29 15 29 7 29 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    34 61 5 251 61 11 61 2 61 9 23 122 11 106 11 89 11 3 11 6 50 17 4 52 9 47 54 2 14 42 9 45 34 35 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         35         ;ALIGN to Reference Point
MIRP[rp0,rnd,grey] cvt_34 45  ;Move Indirect Relative Point
SLOOP           9          ;Set LOOP variable
IP              42 14 2 54 47 9 52 4 17 ;Interpolate Point
MDRP[min,rnd,grey] 50         ;Move Direct Relative Point
MIRP[min,black] estemtc 11 ;Move Indirect Relative Point
DELTAP1         3 11 89 11 106 11 122 ;DELTA exception P1
MDRP[rp0,rnd,white] 23         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 61 ;Move Indirect Relative Point
DELTAP1         2 61 11 61 251 ;DELTA exception P1
DELTAP2         5 61 267 61 283 61 299 61 315 61 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 29  ;Move Indirect Relative Point
DELTAP1         7 29 15 29 63 29 79 29 143 29 159 29 223 29 239 ;DELTA exception P1
DELTAP2         6 29 303 29 319 29 367 29 383 29 447 29 463 ;DELTA exception P2
IP              32         ;Interpolate Point
IP              20         ;Interpolate Point
MIRP[min,rnd,grey] headstem 55 ;Move Indirect Relative Point
DELTAP1         2 55 4 55 244 ;DELTA exception P1
DELTAP2         5 55 260 55 276 55 292 55 308 55 496 ;DELTA exception P2
DELTAP1         6 32 89 32 105 32 121 20 84 20 100 20 116 ;DELTA exception P1
SHPIX           8 32       ;SHift point by a PIXel amount
SHPIX           -16 17     ;SHift point by a PIXel amount
SHPIX           8 4        ;SHift point by a PIXel amount
SHPIX           -8 47      ;SHift point by a PIXel amount
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 25 85 25 101 25 117 27 90 27 106 27 122 ;DELTA exception P1
DELTAP1         6 4 91 4 107 4 123 47 84 47 100 47 116 ;DELTA exception P1
""",

    'uni0E29': """
                           #--- NPUSHB    64 122 5 106 5 90 5 117 3 101 3 85 3 6 122 23 106 23 90 23 117 25 101 25 85 25 117 11 101 11 85 11 122 9 106 9 90 9 12 30 56 62 3 21 27 34 32 118 40 102 40 86 40 71 40 55 40 5 40 16 127 15 1 15 66 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   44        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 44 6 244 44 144 44 2 44 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 50 5 244 50 4 50 2 50 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    34 7 3 79 7 63 7 47 7 3 7 118 13 102 13 86 13 71 13 55 13 5 13 16 175 1 32 1 16 1 0 1 4 1 65 ;PUSH N Bytes
SRP0            65         ;Set Reference Point 0
MDRP[rp0,rnd,white] 1          ;Move Direct Relative Point
DELTAP1         4 1 0 1 16 1 32 1 175 ;DELTA exception P1
MIRP[min,black] estemw 13  ;Move Indirect Relative Point
DELTAP1         5 13 55 13 71 13 86 13 102 13 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 7          ;Move Direct Relative Point
DELTAP1         3 7 47 7 63 7 79 ;DELTA exception P1
DELTAP2         3 7 287 7 303 7 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 50 ;Move Indirect Relative Point
DELTAP1         2 50 4 50 244 ;DELTA exception P1
DELTAP2         5 50 260 50 276 50 292 50 308 50 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 44  ;Move Indirect Relative Point
DELTAP1         2 44 144 44 244 ;DELTA exception P1
DELTAP2         6 44 260 44 276 44 292 44 308 44 352 44 368 ;DELTA exception P2
SRP0            66         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 15         ;Move Direct Relative Point
DELTAP1         1 15 127   ;DELTA exception P1
MIRP[min,black] estemw 40  ;Move Indirect Relative Point
DELTAP1         5 40 55 40 71 40 86 40 102 40 118 ;DELTA exception P1
ALIGNRP         32         ;ALIGN to Reference Point
SHP[rp2]        34         ;SHift Point using reference point
MDRP[rp0,min,rnd,white] 27         ;Move Direct Relative Point
MDRP[rnd,grey]  21         ;Move Direct Relative Point
SLOOP           3          ;Set LOOP variable
IP              62 56 30   ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 9 90 9 106 9 122 11 85 11 101 11 117 25 85 25 101 25 117 23 90 23 106 23 122 ;DELTA exception P1
DELTAP1         6 3 85 3 101 3 117 5 90 5 106 5 122 ;DELTA exception P1
                           #--- NPUSHB    26 122 6 106 6 90 6 117 22 101 22 85 22 122 20 106 20 90 20 117 8 101 8 85 8 12 35 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    12 16 8 35 40 16 32 30 59 53 7 18 24 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   41        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 41 5 244 41 4 41 2 41 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   4         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 4 6 239 4 223 4 159 4 143 4 79 4 63 4 15 4 7 4 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   47        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    12 47 5 251 47 11 47 2 47 9 24 10 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   34 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   34        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    23 34 8 255 34 223 34 143 34 111 34 4 34 4 118 14 103 14 87 14 3 14 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 14  ;Move Indirect Relative Point
DELTAP1         3 14 87 14 103 14 118 ;DELTA exception P1
MIRP[rnd,grey]  tvheight 34 ;Move Indirect Relative Point
DELTAP1         4 34 111 34 143 34 223 34 255 ;DELTA exception P1
DELTAP2         8 34 287 34 335 34 367 34 399 34 431 34 447 34 479 34 511 ;DELTA exception P2
DELTAP3         1 34 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 10  ;Move Indirect Relative Point
IP              24         ;Interpolate Point
MIRP[min,rnd,grey] headstem 47 ;Move Indirect Relative Point
DELTAP1         2 47 11 47 251 ;DELTA exception P1
DELTAP2         5 47 267 47 283 47 299 47 315 47 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 4   ;Move Indirect Relative Point
DELTAP1         7 4 15 4 63 4 79 4 143 4 159 4 223 4 239 ;DELTA exception P1
DELTAP2         6 4 303 4 319 4 367 4 383 4 447 4 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 41 ;Move Indirect Relative Point
DELTAP1         2 41 4 41 244 ;DELTA exception P1
DELTAP2         5 41 260 41 276 41 292 41 308 41 496 ;DELTA exception P2
MDAP[rnd]       24         ;Move Direct Absolute Point
MDRP[rp0,rnd,grey] 18         ;Move Direct Relative Point
SLOOP           7          ;Set LOOP variable
IP              53 59 30 32 16 40 35 ;Interpolate Point
SHPIX           8 16       ;SHift point by a PIXel amount
SHPIX           -8 35      ;SHift point by a PIXel amount
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 8 85 8 101 8 117 20 90 20 106 20 122 22 85 22 101 22 117 6 90 6 106 6 122 ;DELTA exception P1
""",

    'uni0E2A': """
                           #--- NPUSHB    27 122 18 106 18 90 18 117 16 101 16 85 16 6 117 12 101 12 85 12 122 10 106 10 90 10 6 51 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- NPUSHB    38 35 8 30 51 46 35 37 44 6 53 41 5 24 27 8 49 48 27 118 53 102 53 86 53 71 53 55 53 5 53 16 127 1 0 1 2 1 67 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 63 6 251 63 159 63 2 63 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 57 5 251 57 11 57 2 57 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    31 14 2 112 14 64 14 48 14 3 14 41 118 8 102 8 86 8 71 8 55 8 5 8 16 16 20 0 20 2 20 66 ;PUSH N Bytes
SRP0            66         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 20         ;Move Direct Relative Point
DELTAP1         2 20 0 20 16 ;DELTA exception P1
MIRP[min,black] estemw 8   ;Move Indirect Relative Point
DELTAP1         5 8 55 8 71 8 86 8 102 8 118 ;DELTA exception P1
MDRP[rnd,grey]  41         ;Move Direct Relative Point
MDRP[rp0,rnd,grey] 14         ;Move Direct Relative Point
DELTAP1         3 14 48 14 64 14 112 ;DELTA exception P1
DELTAP2         2 14 256 14 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 57 ;Move Indirect Relative Point
DELTAP1         2 57 11 57 251 ;DELTA exception P1
DELTAP2         5 57 267 57 283 57 299 57 315 57 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 63  ;Move Indirect Relative Point
DELTAP1         2 63 159 63 251 ;DELTA exception P1
DELTAP2         6 63 267 63 283 63 299 63 315 63 367 63 383 ;DELTA exception P2
SRP0            67         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 127 ;DELTA exception P1
MIRP[min,black] estemw 53  ;Move Indirect Relative Point
DELTAP1         5 53 55 53 71 53 86 53 102 53 118 ;DELTA exception P1
ALIGNRP         27         ;ALIGN to Reference Point
MDRP[rp0,rnd,grey] 48         ;Move Direct Relative Point
MDRP[grey]      49         ;Move Direct Relative Point
SRP1            8          ;Set Reference Point 1
SRP2            27         ;Set Reference Point 2
IP              24         ;Interpolate Point
IP              5          ;Interpolate Point
SRP1            41         ;Set Reference Point 1
SRP2            53         ;Set Reference Point 2
SLOOP           6          ;Set LOOP variable
IP              44 37 35 46 51 30 ;Interpolate Point
SHPIX           8 35       ;SHift point by a PIXel amount
SHPIX           -8 51      ;SHift point by a PIXel amount
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 10 90 10 106 10 122 12 85 12 101 12 117 ;DELTA exception P1
DELTAP1         6 16 85 16 101 16 117 18 90 18 106 18 122 ;DELTA exception P1
                           #--- NPUSHB    27 116 46 100 46 84 46 123 30 107 30 91 30 6 122 15 106 15 90 15 117 13 101 13 85 13 6 46 ;PUSH N Bytes
                           #--- PUSHW_1   -8        ;PUSH Words
                           #--- PUSHB_2   30 8      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 60 5 251 60 11 60 2 60 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 11 6 224 11 208 11 144 11 128 11 64 11 48 11 0 11 7 11 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    45 54 5 244 54 4 54 2 54 9 17 31 1 121 5 104 5 88 5 3 5 10 24 40 121 37 104 37 88 37 3 37 10 49 27 40 24 8 53 28 8 21 8 44 34 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 44  ;Move Indirect Relative Point
SLOOP           8          ;Set LOOP variable
IP              21 8 28 53 8 24 40 27 ;Interpolate Point
MDRP[min,rnd,grey] 49         ;Move Direct Relative Point
MIRP[min,black] estemt 37  ;Move Indirect Relative Point
DELTAP1         3 37 88 37 104 37 121 ;DELTA exception P1
MDAP[rnd]       40         ;Move Direct Absolute Point
MDAP[rnd]       24         ;Move Direct Absolute Point
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
DELTAP1         3 5 88 5 104 5 121 ;DELTA exception P1
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 17  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 54 ;Move Indirect Relative Point
DELTAP1         2 54 4 54 244 ;DELTA exception P1
DELTAP2         5 54 260 54 276 54 292 54 308 54 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 11  ;Move Indirect Relative Point
DELTAP1         7 11 0 11 48 11 64 11 128 11 144 11 208 11 224 ;DELTA exception P1
DELTAP2         6 11 288 11 304 11 352 11 368 11 432 11 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 60 ;Move Indirect Relative Point
DELTAP1         2 60 11 60 251 ;DELTA exception P1
DELTAP2         5 60 267 60 283 60 299 60 315 60 511 ;DELTA exception P2
SHPIX           8 30       ;SHift point by a PIXel amount
SHPIX           -8 46      ;SHift point by a PIXel amount
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 13 85 13 101 13 117 15 90 15 106 15 122 ;DELTA exception P1
DELTAP1         6 30 91 30 107 30 123 46 84 46 100 46 116 ;DELTA exception P1
""",

    'uni0E2B': """
                           #--- NPUSHB    47 122 12 106 12 90 12 117 10 101 10 85 10 6 117 30 101 30 85 30 122 28 106 28 90 28 117 18 101 18 85 18 122 16 106 16 90 16 12 0 26 1 22 9 6 6 36 8 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    13 58 5 244 58 4 58 2 58 9 4 34 24 3 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 26 6 239 26 223 26 159 26 143 26 79 26 63 26 15 26 7 26 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    30 52 5 251 52 11 52 2 52 9 32 118 36 102 36 86 36 71 36 55 36 5 36 16 127 1 0 1 2 1 62 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 40 6 244 40 144 40 2 40 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 46 5 244 46 4 46 2 46 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    35 14 3 79 14 63 14 47 14 3 14 7 118 20 102 20 86 20 71 20 55 20 5 20 16 175 8 32 8 16 8 0 8 4 8 61 ;PUSH N Bytes
SRP0            61         ;Set Reference Point 0
MDRP[rp0,rnd,white] 8          ;Move Direct Relative Point
DELTAP1         4 8 0 8 16 8 32 8 175 ;DELTA exception P1
MIRP[min,black] estemw 20  ;Move Indirect Relative Point
DELTAP1         5 20 55 20 71 20 86 20 102 20 118 ;DELTA exception P1
SHP[rp2]        7          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 14         ;Move Direct Relative Point
DELTAP1         3 14 47 14 63 14 79 ;DELTA exception P1
DELTAP2         3 14 287 14 303 14 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 46 ;Move Indirect Relative Point
DELTAP1         2 46 4 46 244 ;DELTA exception P1
DELTAP2         5 46 260 46 276 46 292 46 308 46 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 40  ;Move Indirect Relative Point
DELTAP1         2 40 144 40 244 ;DELTA exception P1
DELTAP2         6 40 260 40 276 40 292 40 308 40 352 40 368 ;DELTA exception P2
SRP0            62         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 127 ;DELTA exception P1
MIRP[min,black] estemw 36  ;Move Indirect Relative Point
DELTAP1         5 36 55 36 71 36 86 36 102 36 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 32         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 52 ;Move Indirect Relative Point
DELTAP1         2 52 11 52 251 ;DELTA exception P1
DELTAP2         5 52 267 52 283 52 299 52 315 52 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 26  ;Move Indirect Relative Point
DELTAP1         7 26 15 26 63 26 79 26 143 26 159 26 223 26 239 ;DELTA exception P1
DELTAP2         6 26 303 26 319 26 367 26 383 26 447 26 463 ;DELTA exception P2
SLOOP           3          ;Set LOOP variable
IP              24 34 4    ;Interpolate Point
MIRP[min,rnd,grey] headstem 58 ;Move Indirect Relative Point
DELTAP1         2 58 4 58 244 ;DELTA exception P1
DELTAP2         5 58 260 58 276 58 292 58 308 58 496 ;DELTA exception P2
SRP1            8          ;Set Reference Point 1
SRP2            36         ;Set Reference Point 2
IP              6          ;Interpolate Point
SRP0            6          ;Set Reference Point 0
MIRP[min,black] headstem 22 ;Move Indirect Relative Point
DELTAP1         1 26 0     ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 16 90 16 106 16 122 18 85 18 101 18 117 28 90 28 106 28 122 30 85 30 101 30 117 ;DELTA exception P1
DELTAP1         6 10 85 10 101 10 117 12 90 12 106 12 122 ;DELTA exception P1
                           #--- NPUSHB    58 117 31 101 31 85 31 122 33 106 33 90 33 6 117 15 101 15 85 15 122 13 106 13 90 13 117 27 101 27 85 27 122 25 106 25 90 25 12 114 21 99 21 84 21 3 34 24 121 4 104 4 88 4 3 4 10 49 49 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 37 5 244 37 4 37 2 37 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    20 11 6 239 11 223 11 159 11 143 11 79 11 63 11 15 11 7 11 37 55 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    20 43 5 251 43 11 43 2 43 9 29 36 2 6 22 21 5 17 34 7 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         7          ;ALIGN to Reference Point
MIRP[rp0,rnd,grey] cvt_34 17  ;Move Indirect Relative Point
SLOOP           5          ;Set LOOP variable
IP              21 22 6 2 36 ;Interpolate Point
ALIGNRP         29         ;ALIGN to Reference Point
MIRP[min,rnd,grey] headstem 43 ;Move Indirect Relative Point
DELTAP1         2 43 11 43 251 ;DELTA exception P1
DELTAP2         5 43 267 43 283 43 299 43 315 43 511 ;DELTA exception P2
SHP[rp2]        55         ;SHift Point using reference point
MIRP[rp0,rnd,grey] cvt_37 11  ;Move Indirect Relative Point
DELTAP1         7 11 15 11 63 11 79 11 143 11 159 11 223 11 239 ;DELTA exception P1
DELTAP2         6 11 303 11 319 11 367 11 383 11 447 11 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 37 ;Move Indirect Relative Point
DELTAP1         2 37 4 37 244 ;DELTA exception P1
DELTAP2         5 37 260 37 276 37 292 37 308 37 496 ;DELTA exception P2
SHP[rp2]        49         ;SHift Point using reference point
SRP0            49         ;Set Reference Point 0
MIRP[min,black] estemt 4   ;Move Indirect Relative Point
DELTAP1         3 4 88 4 104 4 121 ;DELTA exception P1
IP              24         ;Interpolate Point
IP              34         ;Interpolate Point
DELTAP1         3 21 84 21 99 21 114 ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 25 90 25 106 25 122 27 85 27 101 27 117 13 90 13 106 13 122 15 85 15 101 15 117 ;DELTA exception P1
DELTAP1         6 33 90 33 106 33 122 31 85 31 101 31 117 ;DELTA exception P1
""",

    'uni0E2C': """
                           #--- NPUSHB    56 117 6 101 6 85 6 117 22 101 22 85 22 122 24 106 24 90 24 122 8 106 8 90 8 12 117 14 101 14 85 14 117 30 101 30 85 30 122 12 106 12 90 12 122 28 106 28 90 28 12 2 19 18 3 20 16 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 55 6 244 55 144 55 2 55 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 61 5 244 61 4 61 2 61 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    29 26 3 79 26 63 26 47 26 3 26 1 118 39 102 39 86 39 71 39 55 39 5 39 16 127 20 1 20 65 ;PUSH N Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 43 6 244 43 144 43 2 43 36 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 49 5 244 49 4 49 2 49 9 ;PUSH N Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   10        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- PUSHB_1   10        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    35 10 3 79 10 63 10 47 10 3 10 3 118 16 102 16 86 16 71 16 55 16 5 16 16 175 4 32 4 16 4 0 4 4 4 64 ;PUSH N Bytes
SRP0            64         ;Set Reference Point 0
MDRP[rp0,rnd,white] 4          ;Move Direct Relative Point
DELTAP1         4 4 0 4 16 4 32 4 175 ;DELTA exception P1
MIRP[min,black] estemw 16  ;Move Indirect Relative Point
DELTAP1         5 16 55 16 71 16 86 16 102 16 118 ;DELTA exception P1
SHP[rp2]        3          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 10         ;Move Direct Relative Point
DELTAP1         3 10 47 10 63 10 79 ;DELTA exception P1
DELTAP2         3 10 287 10 303 10 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 49 ;Move Indirect Relative Point
DELTAP1         2 49 4 49 244 ;DELTA exception P1
DELTAP2         5 49 260 49 276 49 292 49 308 49 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 43  ;Move Indirect Relative Point
DELTAP1         2 43 144 43 244 ;DELTA exception P1
DELTAP2         6 43 260 43 276 43 292 43 308 43 352 43 368 ;DELTA exception P2
SRP0            65         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 20         ;Move Direct Relative Point
DELTAP1         1 20 127   ;DELTA exception P1
MIRP[min,black] estemw 39  ;Move Indirect Relative Point
DELTAP1         5 39 55 39 71 39 86 39 102 39 118 ;DELTA exception P1
ALIGNRP         1          ;ALIGN to Reference Point
MDRP[rp0,rnd,grey] 26         ;Move Direct Relative Point
DELTAP1         3 26 47 26 63 26 79 ;DELTA exception P1
DELTAP2         3 26 287 26 303 26 319 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 61 ;Move Indirect Relative Point
DELTAP1         2 61 4 61 244 ;DELTA exception P1
DELTAP2         5 61 260 61 276 61 292 61 308 61 496 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 55  ;Move Indirect Relative Point
DELTAP1         2 55 144 55 244 ;DELTA exception P1
DELTAP2         6 55 260 55 276 55 292 55 308 55 352 55 368 ;DELTA exception P2
SRP1            16         ;Set Reference Point 1
SRP2            20         ;Set Reference Point 2
SLOOP           3          ;Set LOOP variable
IP              18 19 2    ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 28 90 28 106 28 122 12 90 12 106 12 122 30 85 30 101 30 117 14 85 14 101 14 117 ;DELTA exception P1
DELTAP1         12 8 90 8 106 8 122 24 90 24 106 24 122 22 85 22 101 22 117 6 85 6 101 6 117 ;DELTA exception P1
                           #--- NPUSHB    32 125 2 106 2 90 2 3 122 25 106 25 90 25 117 11 101 11 85 11 122 9 106 9 90 9 117 27 101 27 85 27 12 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    11 52 5 244 52 4 52 2 52 9 32 39 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 23 6 239 23 223 23 159 23 143 23 79 23 63 23 15 23 7 23 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    12 58 5 251 58 11 58 2 58 9 29 35 1 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 40 5 244 40 4 40 2 40 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   7         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 7 6 239 7 223 7 159 7 143 7 79 7 63 7 15 7 7 7 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    19 46 5 251 46 11 46 2 46 9 20 19 18 17 2 5 13 34 3 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
ALIGNRP         3          ;ALIGN to Reference Point
MIRP[rp0,rnd,grey] cvt_34 13  ;Move Indirect Relative Point
SLOOP           5          ;Set LOOP variable
IP              2 17 18 19 20 ;Interpolate Point
MIRP[min,rnd,grey] headstem 46 ;Move Indirect Relative Point
DELTAP1         2 46 11 46 251 ;DELTA exception P1
DELTAP2         5 46 267 46 283 46 299 46 315 46 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 7   ;Move Indirect Relative Point
DELTAP1         7 7 15 7 63 7 79 7 143 7 159 7 223 7 239 ;DELTA exception P1
DELTAP2         6 7 303 7 319 7 367 7 383 7 447 7 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 40 ;Move Indirect Relative Point
DELTAP1         2 40 4 40 244 ;DELTA exception P1
DELTAP2         5 40 260 40 276 40 292 40 308 40 496 ;DELTA exception P2
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_35 29  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 58 ;Move Indirect Relative Point
DELTAP1         2 58 11 58 251 ;DELTA exception P1
DELTAP2         5 58 267 58 283 58 299 58 315 58 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 23  ;Move Indirect Relative Point
DELTAP1         7 23 15 23 63 23 79 23 143 23 159 23 223 23 239 ;DELTA exception P1
DELTAP2         6 23 303 23 319 23 367 23 383 23 447 23 463 ;DELTA exception P2
IP              39         ;Interpolate Point
IP              32         ;Interpolate Point
MIRP[min,rnd,grey] headstem 52 ;Move Indirect Relative Point
DELTAP1         2 52 4 52 244 ;DELTA exception P1
DELTAP2         5 52 260 52 276 52 292 52 308 52 496 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 27 85 27 101 27 117 9 90 9 106 9 122 11 85 11 101 11 117 25 90 25 106 25 122 ;DELTA exception P1
DELTAP1         3 2 90 2 106 2 125 ;DELTA exception P1
""",

    'uni0E2D': """
                           #--- NPUSHB    50 122 12 106 12 90 12 117 10 101 10 85 10 6 117 6 101 6 85 6 122 4 106 4 90 4 6 19 26 29 23 118 29 102 29 86 29 71 29 55 29 5 29 16 127 15 0 15 2 15 43 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 39 6 251 39 159 39 2 39 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 33 5 251 33 11 33 2 33 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   8         ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    31 8 2 112 8 64 8 48 8 3 8 23 118 13 102 13 86 13 71 13 55 13 5 13 16 16 1 0 1 2 1 42 ;PUSH N Bytes
SRP0            42         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 16 ;DELTA exception P1
MIRP[min,black] estemw 13  ;Move Indirect Relative Point
DELTAP1         5 13 55 13 71 13 86 13 102 13 118 ;DELTA exception P1
MDRP[rnd,grey]  23         ;Move Direct Relative Point
MDRP[rp0,rnd,grey] 8          ;Move Direct Relative Point
DELTAP1         3 8 48 8 64 8 112 ;DELTA exception P1
DELTAP2         2 8 256 8 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 33 ;Move Indirect Relative Point
DELTAP1         2 33 11 33 251 ;DELTA exception P1
DELTAP2         5 33 267 33 283 33 299 33 315 33 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 39  ;Move Indirect Relative Point
DELTAP1         2 39 159 39 251 ;DELTA exception P1
DELTAP2         6 39 267 39 283 39 299 39 315 39 367 39 383 ;DELTA exception P2
SRP0            43         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 15         ;Move Direct Relative Point
DELTAP1         2 15 0 15 127 ;DELTA exception P1
MIRP[min,black] estemw 29  ;Move Indirect Relative Point
DELTAP1         5 29 55 29 71 29 86 29 102 29 118 ;DELTA exception P1
SRP1            23         ;Set Reference Point 1
SRP2            29         ;Set Reference Point 2
IP              26         ;Interpolate Point
IP              19         ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 4 90 4 106 4 122 6 85 6 101 6 117 ;DELTA exception P1
DELTAP1         6 10 85 10 101 10 117 12 90 12 106 12 122 ;DELTA exception P1
                           #--- NPUSHB    13 117 7 101 7 85 7 122 9 106 9 90 9 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 30 5 244 30 4 30 2 30 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 11 6 239 11 223 11 159 11 143 11 79 11 63 11 15 11 7 11 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    36 36 5 251 36 11 36 2 36 9 5 22 121 19 104 19 88 19 3 19 10 29 16 22 3 26 34 118 14 103 14 87 14 3 14 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 14  ;Move Indirect Relative Point
DELTAP1         3 14 87 14 103 14 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_34 26  ;Move Indirect Relative Point
SLOOP           3          ;Set LOOP variable
IP              22 16 29   ;Interpolate Point
MIRP[min,black] estemt 19  ;Move Indirect Relative Point
DELTAP1         3 19 88 19 104 19 121 ;DELTA exception P1
MDAP[rnd]       22         ;Move Direct Absolute Point
MDRP[rp0,min,rnd,white] 5          ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 36 ;Move Indirect Relative Point
DELTAP1         2 36 11 36 251 ;DELTA exception P1
DELTAP2         5 36 267 36 283 36 299 36 315 36 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 11  ;Move Indirect Relative Point
DELTAP1         7 11 15 11 63 11 79 11 143 11 159 11 223 11 239 ;DELTA exception P1
DELTAP2         6 11 303 11 319 11 367 11 383 11 447 11 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 30 ;Move Indirect Relative Point
DELTAP1         2 30 4 30 244 ;DELTA exception P1
DELTAP2         5 30 260 30 276 30 292 30 308 30 496 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 9 90 9 106 9 122 7 85 7 101 7 117 ;DELTA exception P1
""",

    'uni0E2E': """
                           #--- NPUSHB    27 122 12 106 12 90 12 117 10 101 10 85 10 6 117 6 101 6 85 6 122 4 106 4 90 4 6 33 ;PUSH N Bytes
                           #--- PUSHW_1   -16       ;PUSH Words
                           #--- NPUSHB    47 50 24 18 33 28 50 20 48 52 26 8 35 23 118 35 102 35 86 35 71 35 55 35 5 35 16 127 15 0 15 2 15 58 118 55 102 55 86 55 71 55 55 55 5 55 16 23 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 45 6 251 45 159 45 2 45 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 39 5 251 39 11 39 2 39 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   8         ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    32 8 2 112 8 64 8 48 8 3 8 118 13 102 13 86 13 71 13 55 13 5 13 16 23 32 1 16 1 0 1 3 1 ;PUSH N Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
DELTAP1         3 1 0 1 16 1 32 ;DELTA exception P1
ALIGNRP         23         ;ALIGN to Reference Point
MIRP[min,black] estemw 13  ;Move Indirect Relative Point
DELTAP1         5 13 55 13 71 13 86 13 102 13 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 8          ;Move Direct Relative Point
DELTAP1         3 8 48 8 64 8 112 ;DELTA exception P1
DELTAP2         2 8 256 8 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 39 ;Move Indirect Relative Point
DELTAP1         2 39 11 39 251 ;DELTA exception P1
DELTAP2         5 39 267 39 283 39 299 39 315 39 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 45  ;Move Indirect Relative Point
DELTAP1         2 45 159 45 251 ;DELTA exception P1
DELTAP2         6 45 267 45 283 45 299 45 315 45 367 45 383 ;DELTA exception P2
SRP0            23         ;Set Reference Point 0
MIRP[min,black] estemw 55  ;Move Indirect Relative Point
DELTAP1         5 55 55 55 71 55 86 55 102 55 118 ;DELTA exception P1
SRP0            58         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 15         ;Move Direct Relative Point
DELTAP1         2 15 0 15 127 ;DELTA exception P1
MIRP[min,black] estemw 35  ;Move Indirect Relative Point
DELTAP1         5 35 55 35 71 35 86 35 102 35 118 ;DELTA exception P1
SRP1            23         ;Set Reference Point 1
SRP2            35         ;Set Reference Point 2
SLOOP           8          ;Set LOOP variable
IP              26 52 48 20 50 28 33 18 ;Interpolate Point
SHPIX           24 50      ;SHift point by a PIXel amount
SHPIX           -16 33     ;SHift point by a PIXel amount
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 4 90 4 106 4 122 6 85 6 101 6 117 ;DELTA exception P1
DELTAP1         6 10 85 10 101 10 117 12 90 12 106 12 122 ;DELTA exception P1
                           #--- NPUSHB    13 117 7 101 7 85 7 122 9 106 9 90 9 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 36 5 244 36 4 36 2 36 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 11 6 239 11 223 11 159 11 143 11 79 11 63 11 15 11 7 11 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    41 42 5 251 42 11 42 2 42 9 5 48 7 18 33 50 28 4 20 121 52 104 52 88 52 3 52 10 35 16 26 34 118 14 103 14 87 14 3 14 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 14  ;Move Indirect Relative Point
DELTAP1         3 14 87 14 103 14 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_34 26  ;Move Indirect Relative Point
IP              16         ;Interpolate Point
IP              35         ;Interpolate Point
MIRP[min,black] estemt 52  ;Move Indirect Relative Point
DELTAP1         3 52 88 52 104 52 121 ;DELTA exception P1
MDRP[rp0,rnd,grey] 20         ;Move Direct Relative Point
SLOOP           4          ;Set LOOP variable
IP              28 50 33 18 ;Interpolate Point
MIRP[min,black] cvt_7 48   ;Move Indirect Relative Point
MDRP[rp0,min,rnd,white] 5          ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 42 ;Move Indirect Relative Point
DELTAP1         2 42 11 42 251 ;DELTA exception P1
DELTAP2         5 42 267 42 283 42 299 42 315 42 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 11  ;Move Indirect Relative Point
DELTAP1         7 11 15 11 63 11 79 11 143 11 159 11 223 11 239 ;DELTA exception P1
DELTAP2         6 11 303 11 319 11 367 11 383 11 447 11 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 36 ;Move Indirect Relative Point
DELTAP1         2 36 4 36 244 ;DELTA exception P1
DELTAP2         5 36 260 36 276 36 292 36 308 36 496 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 9 90 9 106 9 122 7 85 7 101 7 117 ;DELTA exception P1
""",

    'uni0E2F': """
                           #--- NPUSHB    13 117 12 101 12 85 12 122 10 106 10 90 10 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    10 27 5 251 27 11 27 2 27 9 17 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 14 6 224 14 208 14 144 14 128 14 64 14 48 14 0 14 7 14 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    31 33 5 244 33 4 33 2 33 9 19 5 8 22 118 23 102 23 86 23 71 23 55 23 5 23 16 127 1 1 1 37 ;PUSH N Bytes
SRP0            37         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         1 1 127    ;DELTA exception P1
MIRP[min,black] estemw 23  ;Move Indirect Relative Point
DELTAP1         5 23 55 23 71 23 86 23 102 23 118 ;DELTA exception P1
ALIGNRP         22         ;ALIGN to Reference Point
MDRP[rp0,rnd,grey] 8          ;Move Direct Relative Point
IP              5          ;Interpolate Point
IP              19         ;Interpolate Point
MIRP[min,rnd,grey] headstem 33 ;Move Indirect Relative Point
DELTAP1         2 33 4 33 244 ;DELTA exception P1
DELTAP2         5 33 260 33 276 33 292 33 308 33 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 14  ;Move Indirect Relative Point
DELTAP1         7 14 0 14 48 14 64 14 128 14 144 14 208 14 224 ;DELTA exception P1
DELTAP2         6 14 288 14 304 14 352 14 368 14 432 14 448 ;DELTA exception P2
IP              17         ;Interpolate Point
MIRP[min,rnd,grey] headstem 27 ;Move Indirect Relative Point
DELTAP1         2 27 11 27 251 ;DELTA exception P1
DELTAP2         5 27 267 27 283 27 299 27 315 27 511 ;DELTA exception P2
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 10 90 10 106 10 122 12 85 12 101 12 117 ;DELTA exception P1
                           #--- NPUSHB    23 122 15 106 15 90 15 117 13 101 13 85 13 6 121 5 104 5 88 5 3 5 10 19 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 24 5 244 24 4 24 2 24 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 17 6 239 17 223 17 159 17 143 17 79 17 63 17 15 17 7 17 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    12 30 5 251 30 11 30 2 30 9 2 11 34 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   23 1      ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    14 23 8 255 23 223 23 143 23 111 23 4 23 4 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[rnd,grey]  tvheight 23 ;Move Indirect Relative Point
DELTAP1         4 23 111 23 143 23 223 23 255 ;DELTA exception P1
DELTAP2         8 23 287 23 335 23 367 23 399 23 431 23 447 23 479 23 511 ;DELTA exception P2
DELTAP3         1 23 543   ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_34 11  ;Move Indirect Relative Point
IP              2          ;Interpolate Point
MIRP[min,rnd,grey] headstem 30 ;Move Indirect Relative Point
DELTAP1         2 30 11 30 251 ;DELTA exception P1
DELTAP2         5 30 267 30 283 30 299 30 315 30 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 17  ;Move Indirect Relative Point
DELTAP1         7 17 15 17 63 17 79 17 143 17 159 17 223 17 239 ;DELTA exception P1
DELTAP2         6 17 303 17 319 17 367 17 383 17 447 17 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 24 ;Move Indirect Relative Point
DELTAP1         2 24 4 24 244 ;DELTA exception P1
DELTAP2         5 24 260 24 276 24 292 24 308 24 496 ;DELTA exception P2
MDRP[rp0,rnd,grey] 19         ;Move Direct Relative Point
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
DELTAP1         3 5 88 5 104 5 121 ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 13 85 13 101 13 117 15 90 15 106 15 122 ;DELTA exception P1
""",

    'uni0E30': """
                           #--- NPUSHB    26 122 5 106 5 90 5 117 37 101 37 85 37 122 35 106 35 90 35 117 7 101 7 85 7 12 51 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    10 21 5 251 21 11 21 2 21 9 39 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    20 9 6 224 9 208 9 144 9 128 9 64 9 48 9 0 9 7 9 37 57 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    20 27 5 244 27 4 27 2 27 9 45 15 33 32 3 16 3 0 3 3 3 ;PUSH N Bytes
MDAP[rnd]       3          ;Move Direct Absolute Point
DELTAP1         3 3 0 3 16 3 32 ;DELTA exception P1
ALIGNRP         33         ;ALIGN to Reference Point
MDRP[rnd,grey]  15         ;Move Direct Relative Point
SHP[rp2]        45         ;SHift Point using reference point
MIRP[min,rnd,grey] headstem 27 ;Move Indirect Relative Point
DELTAP1         2 27 4 27 244 ;DELTA exception P1
DELTAP2         5 27 260 27 276 27 292 27 308 27 496 ;DELTA exception P2
SHP[rp2]        57         ;SHift Point using reference point
MIRP[rp0,rnd,grey] cvt_37 9   ;Move Indirect Relative Point
DELTAP1         7 9 0 9 48 9 64 9 128 9 144 9 208 9 224 ;DELTA exception P1
DELTAP2         6 9 288 9 304 9 352 9 368 9 432 9 448 ;DELTA exception P2
ALIGNRP         39         ;ALIGN to Reference Point
MIRP[min,rnd,grey] headstem 21 ;Move Indirect Relative Point
DELTAP1         2 21 11 21 251 ;DELTA exception P1
DELTAP2         5 21 267 21 283 21 299 21 315 21 511 ;DELTA exception P2
SHP[rp2]        51         ;SHift Point using reference point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 7 85 7 101 7 117 35 90 35 106 35 122 37 85 37 101 37 117 5 90 5 106 5 122 ;DELTA exception P1
                           #--- NPUSHB    51 117 38 101 38 85 38 122 10 106 10 90 10 117 8 101 8 85 8 122 40 106 40 90 40 12 117 34 101 34 85 34 117 4 101 4 85 4 122 2 106 2 90 2 122 32 106 32 90 32 12 44 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 48 6 251 48 159 48 2 48 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   54        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    29 54 5 251 54 11 54 2 54 9 112 36 32 36 2 36 118 41 103 41 87 41 3 41 10 47 30 1 30 14 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 18 6 251 18 159 18 2 18 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    25 24 5 251 24 11 24 2 24 9 112 6 32 6 2 6 118 11 103 11 87 11 3 11 10 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
MIRP[min,black] estemt 11  ;Move Indirect Relative Point
DELTAP1         3 11 87 11 103 11 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 6          ;Move Direct Relative Point
DELTAP1         2 6 32 6 112 ;DELTA exception P1
MIRP[min,rnd,grey] headstem 24 ;Move Indirect Relative Point
DELTAP1         2 24 11 24 251 ;DELTA exception P1
DELTAP2         5 24 267 24 283 24 299 24 315 24 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 18  ;Move Indirect Relative Point
DELTAP1         2 18 159 18 251 ;DELTA exception P1
DELTAP2         6 18 267 18 283 18 299 18 315 18 367 18 383 ;DELTA exception P2
MDRP[rnd,grey]  14         ;Move Direct Relative Point
MDAP[rnd]       30         ;Move Direct Absolute Point
DELTAP1         1 30 47    ;DELTA exception P1
MIRP[min,black] estemt 41  ;Move Indirect Relative Point
DELTAP1         3 41 87 41 103 41 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 36         ;Move Direct Relative Point
DELTAP1         2 36 32 36 112 ;DELTA exception P1
MIRP[min,rnd,grey] headstem 54 ;Move Indirect Relative Point
DELTAP1         2 54 11 54 251 ;DELTA exception P1
DELTAP2         5 54 267 54 283 54 299 54 315 54 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 48  ;Move Indirect Relative Point
DELTAP1         2 48 159 48 251 ;DELTA exception P1
DELTAP2         6 48 267 48 283 48 299 48 315 48 367 48 383 ;DELTA exception P2
MDRP[rnd,grey]  44         ;Move Direct Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 32 90 32 106 32 122 2 90 2 106 2 122 4 85 4 101 4 117 34 85 34 101 34 117 ;DELTA exception P1
DELTAP1         12 40 90 40 106 40 122 8 85 8 101 8 117 10 90 10 106 10 122 38 85 38 101 38 117 ;DELTA exception P1
""",

    'uni0E31': """
                           #--- NPUSHB    13 117 7 101 7 85 7 122 5 106 5 90 5 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 21 5 251 21 11 21 2 21 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 9 6 224 9 208 9 144 9 128 9 64 9 48 9 0 9 7 9 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    11 27 5 244 27 4 27 2 27 9 15 3 ;PUSH N Bytes
MDAP[rnd]       3          ;Move Direct Absolute Point
MDRP[rnd,grey]  15         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 27 ;Move Indirect Relative Point
DELTAP1         2 27 4 27 244 ;DELTA exception P1
DELTAP2         5 27 260 27 276 27 292 27 308 27 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 9   ;Move Indirect Relative Point
DELTAP1         7 9 0 9 48 9 64 9 128 9 144 9 208 9 224 ;DELTA exception P1
DELTAP2         6 9 288 9 304 9 352 9 368 9 432 9 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 21 ;Move Indirect Relative Point
DELTAP1         2 21 11 21 251 ;DELTA exception P1
DELTAP2         5 21 267 21 283 21 299 21 315 21 511 ;DELTA exception P2
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 5 90 5 106 5 122 7 85 7 101 7 117 ;DELTA exception P1
                           #--- NPUSHB    27 122 10 106 10 90 10 117 8 101 8 85 8 6 117 4 101 4 85 4 122 2 106 2 90 2 6 14 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 18 6 251 18 159 18 2 18 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 24 5 251 24 11 24 2 24 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    25 6 2 112 6 64 6 48 6 3 6 118 11 103 11 87 11 3 11 10 111 0 63 0 2 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         2 0 63 0 111 ;DELTA exception P1
MIRP[min,black] estemt 11  ;Move Indirect Relative Point
DELTAP1         3 11 87 11 103 11 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 6          ;Move Direct Relative Point
DELTAP1         3 6 48 6 64 6 112 ;DELTA exception P1
DELTAP2         2 6 256 6 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 24 ;Move Indirect Relative Point
DELTAP1         2 24 11 24 251 ;DELTA exception P1
DELTAP2         5 24 267 24 283 24 299 24 315 24 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 18  ;Move Indirect Relative Point
DELTAP1         2 18 159 18 251 ;DELTA exception P1
DELTAP2         6 18 267 18 283 18 299 18 315 18 367 18 383 ;DELTA exception P2
MDRP[rnd,grey]  14         ;Move Direct Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 2 90 2 106 2 122 4 85 4 101 4 117 ;DELTA exception P1
DELTAP1         6 8 85 8 101 8 117 10 90 10 106 10 122 ;DELTA exception P1
""",

    'uni0E32': """
                           #--- NPUSHB    25 5 12 15 9 118 15 102 15 86 15 71 15 55 15 5 15 16 127 1 0 1 2 1 16 9 ;PUSH N Bytes
MDAP[rnd]       9          ;Move Direct Absolute Point
SRP0            16         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         2 1 0 1 127 ;DELTA exception P1
MIRP[min,black] estemw 15  ;Move Indirect Relative Point
DELTAP1         5 15 55 15 71 15 86 15 102 15 118 ;DELTA exception P1
SRP1            9          ;Set Reference Point 1
SRP2            15         ;Set Reference Point 2
IP              12         ;Interpolate Point
IP              5          ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    17 8 121 5 104 5 88 5 3 5 10 15 2 8 3 12 34 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 12  ;Move Indirect Relative Point
SLOOP           3          ;Set LOOP variable
IP              8 2 15     ;Interpolate Point
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
DELTAP1         3 5 88 5 104 5 121 ;DELTA exception P1
MDAP[rnd]       8          ;Move Direct Absolute Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E33': """
                           #--- NPUSHB    28 118 15 102 15 86 15 71 15 55 15 5 15 16 3 121 9 105 9 89 9 72 9 56 9 5 9 16 0 ;PUSH N Bytes
MDAP[rnd]       0          ;Move Direct Absolute Point
MIRP[min,black] estemw 9   ;Move Indirect Relative Point
DELTAP1         5 9 56 9 72 9 89 9 105 9 121 ;DELTA exception P1
MDRP[rp0,rnd,grey] 3          ;Move Direct Relative Point
MIRP[min,black] estemw 15  ;Move Indirect Relative Point
DELTAP1         5 15 55 15 71 15 86 15 102 15 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    13 6 9 12 9 3 15 16 111 0 63 0 2 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         2 0 63 0 111 ;DELTA exception P1
MIRP[rp0,rnd,grey] estemw 15  ;Move Indirect Relative Point
IP              3          ;Interpolate Point
IP              9          ;Interpolate Point
MDRP[rp0,rnd,white] 12         ;Move Direct Relative Point
MIRP[min,black] headstem 6 ;Move Indirect Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E35': """
                           #--- NPUSHB    37 118 18 102 18 86 18 71 18 55 18 5 18 16 3 122 10 105 10 88 10 3 10 6 121 12 105 12 89 12 72 12 56 12 5 12 16 0 ;PUSH N Bytes
MDAP[rnd]       0          ;Move Direct Absolute Point
MIRP[min,black] estemw 12  ;Move Indirect Relative Point
DELTAP1         5 12 56 12 72 12 89 12 105 12 121 ;DELTA exception P1
MIRP[min,black] estemtc 10 ;Move Indirect Relative Point
DELTAP1         3 10 88 10 105 10 122 ;DELTA exception P1
MDRP[rp0,rnd,grey] 3          ;Move Direct Relative Point
MIRP[min,black] estemw 18  ;Move Indirect Relative Point
DELTAP1         5 18 55 18 71 18 86 18 102 18 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    15 11 11 6 9 15 12 3 18 16 111 0 63 0 2 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         2 0 63 0 111 ;DELTA exception P1
MIRP[rp0,rnd,grey] estemw 18  ;Move Indirect Relative Point
IP              3          ;Interpolate Point
IP              12         ;Interpolate Point
MDRP[rp0,rnd,white] 15         ;Move Direct Relative Point
MIRP[rp0,min,black] headstem 6 ;Move Indirect Relative Point
MDRP[min,rnd,grey] 11         ;Move Direct Relative Point
MDAP[rnd]       11         ;Move Direct Absolute Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E36': """
                           #--- NPUSHB    45 118 25 102 25 86 25 71 25 55 25 5 25 16 3 0 4 37 1 37 28 96 8 1 8 39 11 31 1 31 28 14 121 19 105 19 89 19 72 19 56 19 5 19 16 0 ;PUSH N Bytes
MDAP[rnd]       0          ;Move Direct Absolute Point
MIRP[min,black] estemw 19  ;Move Indirect Relative Point
DELTAP1         5 19 56 19 72 19 89 19 105 19 121 ;DELTA exception P1
MDRP[rp0,min,rnd,grey] 14         ;Move Direct Relative Point
MIRP[min,rnd,grey] cvt_28 31  ;Move Indirect Relative Point
DELTAP1         1 31 11    ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_39 8   ;Move Indirect Relative Point
DELTAP1         1 8 96     ;DELTA exception P1
MIRP[min,rnd,grey] cvt_28 37  ;Move Indirect Relative Point
DELTAP1         1 37 4     ;DELTA exception P1
SRP0            0          ;Set Reference Point 0
MDRP[rp0,rnd,grey] 3          ;Move Direct Relative Point
MIRP[min,black] estemw 25  ;Move Indirect Relative Point
DELTAP1         5 25 55 25 71 25 86 25 102 25 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    30 4 28 1 28 28 96 17 1 17 39 11 34 1 34 28 11 11 6 9 22 19 3 25 16 111 0 63 0 2 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         2 0 63 0 111 ;DELTA exception P1
MIRP[rp0,rnd,grey] estemw 25  ;Move Indirect Relative Point
IP              3          ;Interpolate Point
IP              19         ;Interpolate Point
MDRP[rp0,min,rnd,grey] 22         ;Move Direct Relative Point
MIRP[rp0,min,black] headstem 6 ;Move Indirect Relative Point
MDRP[rp0,rnd,white] 11         ;Move Direct Relative Point
MDAP[rnd]       11         ;Move Direct Absolute Point
MIRP[min,rnd,grey] cvt_28 34  ;Move Indirect Relative Point
DELTAP1         1 34 11    ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_39 17  ;Move Indirect Relative Point
DELTAP1         1 17 96    ;DELTA exception P1
MIRP[min,rnd,grey] cvt_28 28  ;Move Indirect Relative Point
DELTAP1         1 28 4     ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E37': """
                           #--- NPUSHB    49 118 22 102 22 86 22 71 22 55 22 5 22 16 3 0 121 9 104 9 88 9 3 9 10 11 11 121 14 104 14 88 14 3 14 10 121 16 105 16 89 16 72 16 56 16 5 16 16 0 ;PUSH N Bytes
MDAP[rnd]       0          ;Move Direct Absolute Point
MIRP[min,black] estemw 16  ;Move Indirect Relative Point
DELTAP1         5 16 56 16 72 16 89 16 105 16 121 ;DELTA exception P1
MIRP[rp0,min,black] estemt 14  ;Move Indirect Relative Point
DELTAP1         3 14 88 14 104 14 121 ;DELTA exception P1
MDRP[rp0,min,rnd,grey] 11         ;Move Direct Relative Point
MDAP[rnd]       11         ;Move Direct Absolute Point
MIRP[min,black] estemt 9   ;Move Indirect Relative Point
DELTAP1         3 9 88 9 104 9 121 ;DELTA exception P1
SRP0            0          ;Set Reference Point 0
MDRP[rp0,rnd,grey] 3          ;Move Direct Relative Point
MIRP[min,black] estemw 22  ;Move Indirect Relative Point
DELTAP1         5 22 55 22 71 22 86 22 102 22 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    18 15 10 10 6 9 13 11 19 16 3 22 16 111 0 63 0 2 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         2 0 63 0 111 ;DELTA exception P1
MIRP[rp0,rnd,grey] estemw 22  ;Move Indirect Relative Point
IP              3          ;Interpolate Point
IP              16         ;Interpolate Point
MDRP[rp0,rnd,white] 19         ;Move Direct Relative Point
IP              11         ;Interpolate Point
IP              13         ;Interpolate Point
MIRP[rp0,min,black] headstem 6 ;Move Indirect Relative Point
MDRP[min,rnd,grey] 10         ;Move Direct Relative Point
MDAP[rnd]       10         ;Move Direct Absolute Point
SHP[rp2]        15         ;SHift Point using reference point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E38': """
                           #--- PUSHB_6   17 23 7 1 9 13 ;PUSH Bytes
MDAP[rnd]       13         ;Move Direct Absolute Point
MIRP[min,black] headstem 1 ;Move Indirect Relative Point
MDRP[min,rnd,grey] 7          ;Move Direct Relative Point
IP              23         ;Interpolate Point
IP              17         ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    10 1 20 14 96 4 1 4 39 10 26 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       26         ;Move Direct Absolute Point
MDRP[rp0,min,rnd,white] 10         ;Move Direct Relative Point
MIRP[rp0,min,rnd,grey] cvt_39 4   ;Move Indirect Relative Point
DELTAP1         1 4 96     ;DELTA exception P1
IP              14         ;Interpolate Point
IP              20         ;Interpolate Point
MDRP[min,rnd,grey] 1          ;Move Direct Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E39': """
                           #--- NPUSHB    10 21 27 7 1 9 13 13 15 9 17 ;PUSH N Bytes
MDAP[rnd]       17         ;Move Direct Absolute Point
MIRP[rp0,min,black] headstem 15 ;Move Indirect Relative Point
MDRP[rp0,min,rnd,white] 13         ;Move Direct Relative Point
MDAP[rnd]       13         ;Move Direct Absolute Point
MIRP[min,black] headstem 1 ;Move Indirect Relative Point
MDRP[min,rnd,grey] 7          ;Move Direct Relative Point
IP              27         ;Interpolate Point
IP              21         ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    9 1 7 18 24 14 4 17 10 30 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       30         ;Move Direct Absolute Point
MDRP[rp0,min,rnd,white] 10         ;Move Direct Relative Point
MDRP[rnd,grey]  17         ;Move Direct Relative Point
MDRP[rp0,rnd,grey] 4          ;Move Direct Relative Point
ALIGNRP         14         ;ALIGN to Reference Point
IP              24         ;Interpolate Point
IP              18         ;Interpolate Point
MIRP[min,black] cvt_7 1    ;Move Indirect Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E3A': """
                           #--- PUSHB_2   3 9       ;PUSH Bytes
MDAP[rnd]       9          ;Move Direct Absolute Point
MDRP[min,rnd,grey] 3          ;Move Direct Relative Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- PUSHB_3   0 6 12    ;PUSH Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       12         ;Move Direct Absolute Point
MDRP[rp0,min,rnd,white] 6          ;Move Direct Relative Point
MDRP[min,rnd,grey] 0          ;Move Direct Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E3F': """
                           #--- NPUSHB    31 64 4 7 9 4 38 10 8 4 13 46 38 40 39 13 33 25 64 3 0 9 3 26 10 27 26 13 21 3 1 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
CALL            0 1 3      ;CALL function
SHP[rp1]        21         ;SHift Point using reference point
MIRP[min,black] ecstemt 26 ;Move Indirect Relative Point
SHP[rp2]        27         ;SHift Point using reference point
CALL            10 26 3    ;CALL function
CALL            9 0 3 64   ;CALL function
MDAP[rnd]       25         ;Move Direct Absolute Point
SHP[rp1]        33         ;SHift Point using reference point
MIRP[min,black] ecstemt 39 ;Move Indirect Relative Point
SHP[rp2]        40         ;SHift Point using reference point
MDAP[rnd]       38         ;Move Direct Absolute Point
SHP[rp1]        46         ;SHift Point using reference point
MIRP[min,black] ecstemt 4  ;Move Indirect Relative Point
SHP[rp2]        8          ;SHift Point using reference point
CALL            10 38 4    ;CALL function
CALL            9 7 4 64   ;CALL function
                           #--- NPUSHB    36 15 43 0 50 1 12 16 43 43 18 16 30 1 0 7 34 47 0 15 0 71 4 5 23 36 1 1 26 38 26 16 0 3 1 3 49 ;PUSH N Bytes
SVTCA[x-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       49         ;Move Direct Absolute Point
MDRP[rp0,rnd,white] 3          ;Move Direct Relative Point
DELTAP1         1 3 0      ;DELTA exception P1
MIRP[min,black] estemw 26  ;Move Indirect Relative Point
SHP[rp2]        38         ;SHift Point using reference point
SRP0            26         ;Set Reference Point 0
CALL            1 1        ;CALL function
SHP[rp2]        36         ;SHift Point using reference point
SHP[rp2]        23         ;SHift Point using reference point
SHP[rp2]        5          ;SHift Point using reference point
CALL            4 71 0 15 0 ;CALL function
SHP[rp2]        47         ;SHift Point using reference point
SHP[rp2]        34         ;SHift Point using reference point
SHP[rp2]        7          ;SHift Point using reference point
SRP0            0          ;Set Reference Point 0
CALL            1 30       ;CALL function
MIRP[min,black] estemw 18  ;Move Indirect Relative Point
MDRP[rp0,rnd,white] 43         ;Move Direct Relative Point
SRP1            43         ;Set Reference Point 1
MIRP[min,black] estemw 12  ;Move Indirect Relative Point
CALL            1 50       ;CALL function
SRP1            0          ;Set Reference Point 1
SRP2            43         ;Set Reference Point 2
IP              15         ;Interpolate Point
                           #--- PUSHB_7   12 38 15 39 18 25 26 ;PUSH Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
SRP1            26         ;Set Reference Point 1
SRP2            25         ;Set Reference Point 2
IP              18         ;Interpolate Point
SRP1            39         ;Set Reference Point 1
IP              15         ;Interpolate Point
SRP2            38         ;Set Reference Point 2
IP              12         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
IUP[x]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E40': """
                           #--- PUSHB_1   117       ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- PUSHB_1   101       ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- PUSHB_1   85        ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- NPUSHB    20 122 1 106 1 90 1 6 122 7 106 7 90 7 117 9 101 9 85 9 6 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 23 6 251 23 159 23 2 23 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   17        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 17 5 251 17 11 17 2 17 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   11        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    24 11 2 112 11 64 11 48 11 3 11 118 5 102 5 86 5 71 5 55 5 5 5 16 3 ;PUSH N Bytes
MDAP[rnd]       3          ;Move Direct Absolute Point
MIRP[min,black] estemw 5   ;Move Indirect Relative Point
DELTAP1         5 5 55 5 71 5 86 5 102 5 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 11         ;Move Direct Relative Point
DELTAP1         3 11 48 11 64 11 112 ;DELTA exception P1
DELTAP2         2 11 256 11 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 17 ;Move Indirect Relative Point
DELTAP1         2 17 11 17 251 ;DELTA exception P1
DELTAP2         5 17 267 17 283 17 299 17 315 17 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 23  ;Move Indirect Relative Point
DELTAP1         2 23 159 23 251 ;DELTA exception P1
DELTAP2         6 23 267 23 283 23 299 23 315 23 367 23 383 ;DELTA exception P2
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 9 85 9 101 9 117 7 90 7 106 7 122 ;DELTA exception P1
DELTAP1         6 1 90 1 106 1 122 -1 85 -1 101 -1 117 ;DELTA exception P1
                           #--- NPUSHB    13 122 12 106 12 90 12 117 10 101 10 85 10 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   20        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 20 5 251 20 11 20 2 20 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   8         ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   8         ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   8         ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   8         ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   8         ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 8 6 224 8 208 8 144 8 128 8 64 8 48 8 0 8 7 8 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    11 14 5 244 14 4 14 2 14 9 0 31 ;PUSH N Bytes
                           #--- PUSHW_1   543       ;PUSH Words
                           #--- PUSHB_2   5 1       ;PUSH Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   5         ;PUSH Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   5         ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   5         ;PUSH Bytes
                           #--- PUSHW_1   431       ;PUSH Words
                           #--- PUSHB_1   5         ;PUSH Bytes
                           #--- PUSHW_1   399       ;PUSH Words
                           #--- PUSHB_1   5         ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   5         ;PUSH Bytes
                           #--- PUSHW_1   335       ;PUSH Words
                           #--- PUSHB_1   5         ;PUSH Bytes
                           #--- PUSHW_1   287       ;PUSH Words
                           #--- NPUSHB    14 5 8 255 5 223 5 143 5 111 5 4 5 4 26 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       26         ;Move Direct Absolute Point
MIRP[rnd,grey]  tvheight 5 ;Move Indirect Relative Point
DELTAP1         4 5 111 5 143 5 223 5 255 ;DELTA exception P1
DELTAP2         8 5 287 5 335 5 367 5 399 5 431 5 447 5 479 5 511 ;DELTA exception P2
DELTAP3         1 5 543    ;DELTA exception P3
MIRP[rp0,rnd,grey] cvt_31 0   ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 14 ;Move Indirect Relative Point
DELTAP1         2 14 4 14 244 ;DELTA exception P1
DELTAP2         5 14 260 14 276 14 292 14 308 14 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 8   ;Move Indirect Relative Point
DELTAP1         7 8 0 8 48 8 64 8 128 8 144 8 208 8 224 ;DELTA exception P1
DELTAP2         6 8 288 8 304 8 352 8 368 8 432 8 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 20 ;Move Indirect Relative Point
DELTAP1         2 20 11 20 251 ;DELTA exception P1
DELTAP2         5 20 267 20 283 20 299 20 315 20 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 10 85 10 101 10 117 12 90 12 106 12 122 ;DELTA exception P1
""",

    'uni0E41': """
                           #--- PUSHB_1   117       ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- PUSHB_1   101       ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- PUSHB_1   85        ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- NPUSHB    41 122 1 106 1 90 1 6 117 37 101 37 85 37 122 35 106 35 90 35 6 22 15 27 10 4 19 118 30 102 30 86 30 71 30 55 30 5 30 16 7 3 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 51 6 251 51 159 51 2 51 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 45 5 251 45 11 45 2 45 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    24 39 2 112 39 64 39 48 39 3 39 118 33 102 33 86 33 71 33 55 33 5 33 16 3 ;PUSH N Bytes
MDAP[rnd]       3          ;Move Direct Absolute Point
MIRP[min,black] estemw 33  ;Move Indirect Relative Point
DELTAP1         5 33 55 33 71 33 86 33 102 33 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 39         ;Move Direct Relative Point
DELTAP1         3 39 48 39 64 39 112 ;DELTA exception P1
DELTAP2         2 39 256 39 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 45 ;Move Indirect Relative Point
DELTAP1         2 45 11 45 251 ;DELTA exception P1
DELTAP2         5 45 267 45 283 45 299 45 315 45 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 51  ;Move Indirect Relative Point
DELTAP1         2 51 159 51 251 ;DELTA exception P1
DELTAP2         6 51 267 51 283 51 299 51 315 51 367 51 383 ;DELTA exception P2
SRP0            3          ;Set Reference Point 0
MDRP[rp0,rnd,grey] 7          ;Move Direct Relative Point
MIRP[min,black] estemw 30  ;Move Indirect Relative Point
DELTAP1         5 30 55 30 71 30 86 30 102 30 118 ;DELTA exception P1
MDRP[rnd,grey]  19         ;Move Direct Relative Point
SLOOP           4          ;Set LOOP variable
IP              10 27 15 22 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 35 90 35 106 35 122 37 85 37 101 37 117 ;DELTA exception P1
DELTAP1         6 1 90 1 106 1 122 -1 85 -1 101 -1 117 ;DELTA exception P1
                           #--- NPUSHB    53 117 38 101 38 85 38 122 40 106 40 90 40 6 33 4 31 6 30 7 6 0 10 118 15 103 15 87 15 3 15 10 75 22 59 22 36 22 20 22 4 22 5 22 121 27 104 27 88 27 3 27 10 10 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 48 5 251 48 11 48 2 48 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 36 6 224 36 208 36 144 36 128 36 64 36 48 36 0 36 7 36 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    12 42 5 244 42 4 42 2 42 9 0 31 54 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       54         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_31 0   ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 42 ;Move Indirect Relative Point
DELTAP1         2 42 4 42 244 ;DELTA exception P1
DELTAP2         5 42 260 42 276 42 292 42 308 42 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 36  ;Move Indirect Relative Point
DELTAP1         7 36 0 36 48 36 64 36 128 36 144 36 208 36 224 ;DELTA exception P1
DELTAP2         6 36 288 36 304 36 352 36 368 36 432 36 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 48 ;Move Indirect Relative Point
DELTAP1         2 48 11 48 251 ;DELTA exception P1
DELTAP2         5 48 267 48 283 48 299 48 315 48 511 ;DELTA exception P2
MDAP[rnd]       10         ;Move Direct Absolute Point
MIRP[min,black] estemt 27  ;Move Indirect Relative Point
DELTAP1         3 27 88 27 104 27 121 ;DELTA exception P1
MDRP[rp0,rnd,grey] 22         ;Move Direct Relative Point
DELTAP1         5 22 4 22 20 22 36 22 59 22 75 ;DELTA exception P1
MIRP[min,black] estemt 15  ;Move Indirect Relative Point
DELTAP1         3 15 87 15 103 15 118 ;DELTA exception P1
SRP1            10         ;Set Reference Point 1
SRP2            0          ;Set Reference Point 2
SLOOP           6          ;Set LOOP variable
IP              7 30 6 31 4 33 ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 40 90 40 106 40 122 38 85 38 101 38 117 ;DELTA exception P1
""",

    'uni0E43': """
                           #--- PUSHB_1   117       ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- PUSHB_1   101       ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- PUSHB_1   85        ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- NPUSHB    46 122 21 106 21 90 21 117 19 101 19 85 19 122 1 106 1 90 1 12 117 38 101 38 85 38 122 36 106 36 90 36 6 118 29 102 29 86 29 71 29 55 29 5 29 16 9 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   58        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    10 58 5 251 58 11 58 2 58 9 17 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   64        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    10 64 5 244 64 4 64 2 64 9 23 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 52 6 251 52 159 52 2 52 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 46 5 251 46 11 46 2 46 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   40        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    24 40 2 112 40 64 40 48 40 3 40 118 34 102 34 86 34 71 34 55 34 5 34 16 3 ;PUSH N Bytes
MDAP[rnd]       3          ;Move Direct Absolute Point
MIRP[min,black] estemw 34  ;Move Indirect Relative Point
DELTAP1         5 34 55 34 71 34 86 34 102 34 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 40         ;Move Direct Relative Point
DELTAP1         3 40 48 40 64 40 112 ;DELTA exception P1
DELTAP2         2 40 256 40 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 46 ;Move Indirect Relative Point
DELTAP1         2 46 11 46 251 ;DELTA exception P1
DELTAP2         5 46 267 46 283 46 299 46 315 46 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 52  ;Move Indirect Relative Point
DELTAP1         2 52 159 52 251 ;DELTA exception P1
DELTAP2         6 52 267 52 283 52 299 52 315 52 367 52 383 ;DELTA exception P2
MDAP[rnd]       23         ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 64 ;Move Indirect Relative Point
DELTAP1         2 64 4 64 244 ;DELTA exception P1
DELTAP2         5 64 260 64 276 64 292 64 308 64 496 ;DELTA exception P2
MDRP[rp0,rnd,grey] 17         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 58 ;Move Indirect Relative Point
DELTAP1         2 58 11 58 251 ;DELTA exception P1
DELTAP2         5 58 267 58 283 58 299 58 315 58 511 ;DELTA exception P2
MDRP[rp0,min,rnd,white] 9          ;Move Direct Relative Point
MIRP[min,black] estemw 29  ;Move Indirect Relative Point
DELTAP1         5 29 55 29 71 29 86 29 102 29 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 36 90 36 106 36 122 38 85 38 101 38 117 ;DELTA exception P1
DELTAP1         12 1 90 1 106 1 122 19 85 19 101 19 117 21 90 21 106 21 122 -1 85 -1 101 -1 117 ;DELTA exception P1
                           #--- NPUSHB    25 117 39 101 39 85 39 122 18 106 18 90 18 122 41 106 41 90 41 117 16 101 16 85 16 12 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    17 55 5 244 55 4 55 2 55 9 112 20 96 20 32 20 3 20 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   61        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    33 61 5 251 61 11 61 2 61 9 127 14 111 14 95 14 79 14 63 14 47 14 6 14 121 12 104 12 88 12 3 12 10 26 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 49 5 251 49 11 49 2 49 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   37        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 37 6 224 37 208 37 144 37 128 37 64 37 48 37 0 37 7 37 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    12 43 5 244 43 4 43 2 43 9 0 31 67 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       67         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_31 0   ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 43 ;Move Indirect Relative Point
DELTAP1         2 43 4 43 244 ;DELTA exception P1
DELTAP2         5 43 260 43 276 43 292 43 308 43 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 37  ;Move Indirect Relative Point
DELTAP1         7 37 0 37 48 37 64 37 128 37 144 37 208 37 224 ;DELTA exception P1
DELTAP2         6 37 288 37 304 37 352 37 368 37 432 37 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 49 ;Move Indirect Relative Point
DELTAP1         2 49 11 49 251 ;DELTA exception P1
DELTAP2         5 49 267 49 283 49 299 49 315 49 511 ;DELTA exception P2
MDAP[rnd]       26         ;Move Direct Absolute Point
MIRP[rp0,min,black] estemt 12  ;Move Indirect Relative Point
DELTAP1         3 12 88 12 104 12 121 ;DELTA exception P1
MDRP[rp0,rnd,grey] 14         ;Move Direct Relative Point
DELTAP1         6 14 47 14 63 14 79 14 95 14 111 14 127 ;DELTA exception P1
MIRP[min,rnd,grey] headstem 61 ;Move Indirect Relative Point
DELTAP1         2 61 11 61 251 ;DELTA exception P1
DELTAP2         5 61 267 61 283 61 299 61 315 61 511 ;DELTA exception P2
MDRP[rp0,rnd,grey] 20         ;Move Direct Relative Point
DELTAP1         3 20 32 20 96 20 112 ;DELTA exception P1
MIRP[min,rnd,grey] headstem 55 ;Move Indirect Relative Point
DELTAP1         2 55 4 55 244 ;DELTA exception P1
DELTAP2         5 55 260 55 276 55 292 55 308 55 496 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 16 85 16 101 16 117 41 90 41 106 41 122 18 90 18 106 18 122 39 85 39 101 39 117 ;DELTA exception P1
""",

    'uni0E44': """
                           #--- PUSHB_1   117       ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- PUSHB_1   101       ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- PUSHB_1   85        ;PUSH Bytes
                           #--- PUSHW_1   -1        ;PUSH Words
                           #--- NPUSHB    30 122 1 106 1 90 1 6 117 31 101 31 85 31 122 29 106 29 90 29 6 7 24 9 21 12 19 16 7 15 3 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 45 6 251 45 159 45 2 45 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 39 5 251 39 11 39 2 39 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    24 33 2 112 33 64 33 48 33 3 33 118 27 102 27 86 27 71 27 55 27 5 27 16 3 ;PUSH N Bytes
MDAP[rnd]       3          ;Move Direct Absolute Point
MIRP[min,black] estemw 27  ;Move Indirect Relative Point
DELTAP1         5 27 55 27 71 27 86 27 102 27 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 33         ;Move Direct Relative Point
DELTAP1         3 33 48 33 64 33 112 ;DELTA exception P1
DELTAP2         2 33 256 33 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 39 ;Move Indirect Relative Point
DELTAP1         2 39 11 39 251 ;DELTA exception P1
DELTAP2         5 39 267 39 283 39 299 39 315 39 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 45  ;Move Indirect Relative Point
DELTAP1         2 45 159 45 251 ;DELTA exception P1
DELTAP2         6 45 267 45 283 45 299 45 315 45 367 45 383 ;DELTA exception P2
SRP0            3          ;Set Reference Point 0
MDRP[rnd,grey]  15         ;Move Direct Relative Point
SLOOP           7          ;Set LOOP variable
IP              16 19 12 21 9 24 7 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 29 90 29 106 29 122 31 85 31 101 31 117 ;DELTA exception P1
DELTAP1         6 1 90 1 106 1 122 -1 85 -1 101 -1 117 ;DELTA exception P1
                           #--- NPUSHB    34 122 34 106 34 90 34 117 32 101 32 85 32 6 118 19 103 19 87 19 3 19 10 12 16 122 7 105 7 88 7 3 7 6 24 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 42 5 251 42 11 42 2 42 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   30        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 30 6 224 30 208 30 144 30 128 30 64 30 48 30 0 30 7 30 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    12 36 5 244 36 4 36 2 36 9 0 31 48 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       48         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_31 0   ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 36 ;Move Indirect Relative Point
DELTAP1         2 36 4 36 244 ;DELTA exception P1
DELTAP2         5 36 260 36 276 36 292 36 308 36 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 30  ;Move Indirect Relative Point
DELTAP1         7 30 0 30 48 30 64 30 128 30 144 30 208 30 224 ;DELTA exception P1
DELTAP2         6 30 288 30 304 30 352 30 368 30 432 30 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 42 ;Move Indirect Relative Point
DELTAP1         2 42 11 42 251 ;DELTA exception P1
DELTAP2         5 42 267 42 283 42 299 42 315 42 511 ;DELTA exception P2
MDAP[rnd]       24         ;Move Direct Absolute Point
MIRP[min,black] estemtc 7  ;Move Indirect Relative Point
DELTAP1         3 7 88 7 105 7 122 ;DELTA exception P1
MDRP[rnd,grey]  16         ;Move Direct Relative Point
MDRP[rp0,rnd,grey] 12         ;Move Direct Relative Point
MIRP[min,black] estemt 19  ;Move Indirect Relative Point
DELTAP1         3 19 87 19 103 19 118 ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 32 85 32 101 32 117 34 90 34 106 34 122 ;DELTA exception P1
""",

    'uni0E45': """
                           #--- NPUSHB    23 5 12 15 9 118 15 102 15 86 15 71 15 55 15 5 15 16 127 1 1 1 16 9 ;PUSH N Bytes
MDAP[rnd]       9          ;Move Direct Absolute Point
SRP0            16         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         1 1 127    ;DELTA exception P1
MIRP[min,black] estemw 15  ;Move Indirect Relative Point
DELTAP1         5 15 55 15 71 15 86 15 102 15 118 ;DELTA exception P1
SRP1            9          ;Set Reference Point 1
SRP2            15         ;Set Reference Point 2
IP              12         ;Interpolate Point
IP              5          ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    20 1 0 16 8 121 5 104 5 88 5 3 5 10 15 2 8 3 12 34 16 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       16         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 12  ;Move Indirect Relative Point
SLOOP           3          ;Set LOOP variable
IP              8 2 15     ;Interpolate Point
MIRP[min,black] estemt 5   ;Move Indirect Relative Point
DELTAP1         3 5 88 5 104 5 121 ;DELTA exception P1
MDAP[rnd]       8          ;Move Direct Absolute Point
SRP0            16         ;Set Reference Point 0
MIRP[rnd,grey]  evheight_lu 1 ;Move Indirect Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E46': """
                           #--- NPUSHB    35 117 15 101 15 85 15 122 17 106 17 90 17 6 117 11 101 11 85 11 122 9 106 9 90 9 6 6 5 4 23 22 21 6 25 19 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 29 5 251 29 11 29 2 29 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 13 6 224 13 208 13 144 13 128 13 64 13 48 13 0 13 7 13 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    25 35 5 244 35 4 35 2 35 9 19 118 25 103 25 87 25 3 25 10 79 1 0 1 2 1 ;PUSH N Bytes
MDAP[rnd]       1          ;Move Direct Absolute Point
DELTAP1         2 1 0 1 79 ;DELTA exception P1
MIRP[min,black] estemt 25  ;Move Indirect Relative Point
DELTAP1         3 25 87 25 103 25 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 19         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 35 ;Move Indirect Relative Point
DELTAP1         2 35 4 35 244 ;DELTA exception P1
DELTAP2         5 35 260 35 276 35 292 35 308 35 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 13  ;Move Indirect Relative Point
DELTAP1         7 13 0 13 48 13 64 13 128 13 144 13 208 13 224 ;DELTA exception P1
DELTAP2         6 13 288 13 304 13 352 13 368 13 432 13 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 29 ;Move Indirect Relative Point
DELTAP1         2 29 11 29 251 ;DELTA exception P1
DELTAP2         5 29 267 29 283 29 299 29 315 29 511 ;DELTA exception P2
SRP1            19         ;Set Reference Point 1
SRP2            25         ;Set Reference Point 2
SLOOP           6          ;Set LOOP variable
IP              21 22 23 4 5 6 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 9 90 9 106 9 122 11 85 11 101 11 117 ;DELTA exception P1
DELTAP1         6 17 90 17 106 17 122 15 85 15 101 15 117 ;DELTA exception P1
                           #--- NPUSHB    16 122 14 106 14 90 14 117 12 101 12 85 12 6 1 0 38 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 26 5 244 26 4 26 2 26 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 16 6 239 16 223 16 159 16 143 16 79 16 63 16 15 16 7 16 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    54 32 5 251 32 11 32 2 32 9 10 10 118 22 103 22 87 22 3 22 10 133 5 117 5 101 5 85 5 69 5 53 5 16 5 0 5 8 5 4 121 6 104 6 88 6 3 6 10 23 25 2 21 34 38 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       38         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_34 21  ;Move Indirect Relative Point
IP              2          ;Interpolate Point
IP              25         ;Interpolate Point
ALIGNRP         23         ;ALIGN to Reference Point
MIRP[min,black] estemt 6   ;Move Indirect Relative Point
DELTAP1         3 6 88 6 104 6 121 ;DELTA exception P1
SHP[rp2]        4          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 5          ;Move Direct Relative Point
DELTAP1         8 5 0 5 16 5 53 5 69 5 85 5 101 5 117 5 133 ;DELTA exception P1
MIRP[min,black] estemt 22  ;Move Indirect Relative Point
DELTAP1         3 22 87 22 103 22 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 10         ;Move Direct Relative Point
MDAP[rnd]       10         ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 32 ;Move Indirect Relative Point
DELTAP1         2 32 11 32 251 ;DELTA exception P1
DELTAP2         5 32 267 32 283 32 299 32 315 32 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 16  ;Move Indirect Relative Point
DELTAP1         7 16 15 16 63 16 79 16 143 16 159 16 223 16 239 ;DELTA exception P1
DELTAP2         6 16 303 16 319 16 367 16 383 16 447 16 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 26 ;Move Indirect Relative Point
DELTAP1         2 26 4 26 244 ;DELTA exception P1
DELTAP2         5 26 260 26 276 26 292 26 308 26 496 ;DELTA exception P2
SRP0            38         ;Set Reference Point 0
MIRP[rnd,grey]  evheight_lu 1 ;Move Indirect Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 12 85 12 101 12 117 14 90 14 106 14 122 ;DELTA exception P1
""",

    'uni0E47': """
                           #--- NPUSHB    18 23 9 3 5 29 26 4 10 47 53 127 35 16 35 2 35 17 41 ;PUSH N Bytes
MDAP[rnd]       41         ;Move Direct Absolute Point
MDRP[rnd,grey]  17         ;Move Direct Relative Point
MDRP[rnd,grey]  35         ;Move Direct Relative Point
DELTAP1         2 35 16 35 127 ;DELTA exception P1
IP              53         ;Interpolate Point
IP              47         ;Interpolate Point
MDRP[rp0,rnd,grey] 10         ;Move Direct Relative Point
SLOOP           4          ;Set LOOP variable
IP              26 29 5 3  ;Interpolate Point
MIRP[min,black] headstem 23 ;Move Indirect Relative Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    29 16 13 7 20 29 3 32 50 44 5 112 38 96 38 20 38 4 38 4 38 26 7 7 111 0 63 0 2 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         2 0 63 0 111 ;DELTA exception P1
ALIGNRP         7          ;ALIGN to Reference Point
MIRP[min,black] cvt_7 26   ;Move Indirect Relative Point
MDRP[rnd,grey]  38         ;Move Direct Relative Point
DELTAP1         4 38 4 38 20 38 96 38 112 ;DELTA exception P1
SLOOP           5          ;Set LOOP variable
IP              44 50 32 3 29 ;Interpolate Point
MDRP[rp0,min,rnd,grey] 20         ;Move Direct Relative Point
MIRP[rp0,min,black] cvt_7 13   ;Move Indirect Relative Point
MDRP[min,rnd,grey] 16         ;Move Direct Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E47.high': """
                           #--- NPUSHB    12 3 5 29 26 23 5 10 47 53 35 17 41 ;PUSH N Bytes
MDAP[rnd]       41         ;Move Direct Absolute Point
MDRP[rnd,grey]  17         ;Move Direct Relative Point
MDRP[rnd,grey]  35         ;Move Direct Relative Point
IP              53         ;Interpolate Point
IP              47         ;Interpolate Point
MDRP[rp0,rnd,grey] 10         ;Move Direct Relative Point
SLOOP           5          ;Set LOOP variable
IP              23 26 29 5 3 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    19 20 13 26 29 3 32 50 44 6 38 7 143 0 111 0 63 0 3 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         3 0 63 0 111 0 143 ;DELTA exception P1
ALIGNRP         7          ;ALIGN to Reference Point
MDRP[rnd,grey]  38         ;Move Direct Relative Point
SLOOP           6          ;Set LOOP variable
IP              44 50 32 3 29 26 ;Interpolate Point
MDRP[rnd,grey]  13         ;Move Direct Relative Point
IP              20         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E48': """
                           #--- NPUSHB    10 121 1 104 1 88 1 3 1 10 0 ;PUSH N Bytes
MDAP[rnd]       0          ;Move Direct Absolute Point
MIRP[min,black] estemt 1   ;Move Indirect Relative Point
DELTAP1         3 1 88 1 104 1 121 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    9 3 143 0 111 0 63 0 3 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         3 0 63 0 111 0 143 ;DELTA exception P1
MDRP[min,grey]  3          ;Move Direct Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E48.low': """
                           #--- NPUSHB    14 121 1 105 1 89 1 72 1 56 1 5 1 16 0 ;PUSH N Bytes
MDAP[rnd]       0          ;Move Direct Absolute Point
MIRP[min,black] estemw 1   ;Move Indirect Relative Point
DELTAP1         5 1 56 1 72 1 89 1 105 1 121 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- PUSHB_7   3 111 0 63 0 2 0 ;PUSH Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         2 0 63 0 111 ;DELTA exception P1
MDRP[min,grey]  3          ;Move Direct Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E49': """
                           #--- NPUSHB    9 18 6 28 34 9 5 2 22 15 ;PUSH N Bytes
MDAP[rnd]       15         ;Move Direct Absolute Point
MDRP[rnd,grey]  22         ;Move Direct Relative Point
MDRP[rnd,grey]  2          ;Move Direct Relative Point
SLOOP           5          ;Set LOOP variable
IP              9 34 28 6 18 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    16 21 25 31 3 12 18 3 6 143 0 111 0 63 0 3 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         3 0 63 0 111 0 143 ;DELTA exception P1
MDRP[rp0,rnd,grey] 6          ;Move Direct Relative Point
IP              3          ;Interpolate Point
IP              18         ;Interpolate Point
MDRP[rp0,rnd,grey] 12         ;Move Direct Relative Point
SLOOP           3          ;Set LOOP variable
IP              31 25 21   ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E49.low': """
                           #--- NPUSHB    42 125 7 109 7 124 19 108 19 4 117 13 101 13 85 13 122 11 106 11 90 11 6 2 4 34 1 34 28 18 6 96 9 1 9 39 11 28 1 28 28 22 15 ;PUSH N Bytes
MDAP[rnd]       15         ;Move Direct Absolute Point
MDRP[rnd,grey]  22         ;Move Direct Relative Point
MIRP[min,rnd,grey] cvt_28 28  ;Move Indirect Relative Point
DELTAP1         1 28 11    ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_39 9   ;Move Indirect Relative Point
DELTAP1         1 9 96     ;DELTA exception P1
IP              6          ;Interpolate Point
IP              18         ;Interpolate Point
MIRP[min,rnd,grey] cvt_28 34  ;Move Indirect Relative Point
DELTAP1         1 34 4     ;DELTA exception P1
MDRP[rnd,grey]  2          ;Move Direct Relative Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 11 90 11 106 11 122 13 85 13 101 13 117 ;DELTA exception P1
DELTAP1         4 19 108 19 124 7 109 7 125 ;DELTA exception P1
                           #--- NPUSHB    52 117 14 101 14 85 14 122 16 106 16 90 16 6 117 10 101 10 85 10 122 8 106 8 90 8 6 11 31 1 31 28 111 12 1 12 39 4 25 1 25 28 21 6 18 3 7 111 0 63 0 2 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         2 0 63 0 111 ;DELTA exception P1
MIRP[min,black] cvt_7 3    ;Move Indirect Relative Point
SHP[rp2]        18         ;SHift Point using reference point
MDRP[rp0,rnd,grey] 6          ;Move Direct Relative Point
MDRP[rnd,grey]  21         ;Move Direct Relative Point
MIRP[min,rnd,grey] cvt_28 25  ;Move Indirect Relative Point
DELTAP1         1 25 4     ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_39 12  ;Move Indirect Relative Point
DELTAP1         1 12 111   ;DELTA exception P1
MIRP[min,rnd,grey] cvt_28 31  ;Move Indirect Relative Point
DELTAP1         1 31 11    ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 8 90 8 106 8 122 10 85 10 101 10 117 ;DELTA exception P1
DELTAP1         6 16 90 16 106 16 122 14 85 14 101 14 117 ;DELTA exception P1
""",

    'uni0E4A': """
                           #--- NPUSHB    20 44 50 48 15 1 15 10 7 8 7 6 26 25 24 6 21 37 4 7 29 ;PUSH N Bytes
MDAP[rnd]       29         ;Move Direct Absolute Point
MIRP[min,black] cvt_7 4    ;Move Indirect Relative Point
MDRP[rnd,grey]  37         ;Move Direct Relative Point
MDRP[rp0,rnd,grey] 21         ;Move Direct Relative Point
SLOOP           6          ;Set LOOP variable
IP              24 25 26 6 7 8 ;Interpolate Point
MIRP[min,black] cvt_7 10   ;Move Indirect Relative Point
MDRP[rnd,grey]  15         ;Move Direct Relative Point
DELTAP1         1 15 48    ;DELTA exception P1
IP              50         ;Interpolate Point
IP              44         ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   -16       ;PUSH Words
                           #--- NPUSHB    32 6 8 7 36 26 24 47 41 112 12 80 12 64 12 48 12 32 12 5 12 32 2 7 18 143 1 111 1 63 1 3 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
DELTAP1         3 1 63 1 111 1 143 ;DELTA exception P1
ALIGNRP         18         ;ALIGN to Reference Point
MIRP[min,black] cvt_7 2    ;Move Indirect Relative Point
SHP[rp2]        32         ;SHift Point using reference point
MDRP[rnd,grey]  12         ;Move Direct Relative Point
DELTAP1         5 12 32 12 48 12 64 12 80 12 112 ;DELTA exception P1
IP              41         ;Interpolate Point
IP              47         ;Interpolate Point
MDRP[rp0,rnd,grey] 24         ;Move Direct Relative Point
ALIGNRP         26         ;ALIGN to Reference Point
MDRP[rnd,grey]  36         ;Move Direct Relative Point
MIRP[min,black] cvt_7 8    ;Move Indirect Relative Point
SHP[rp2]        6          ;SHift Point using reference point
IUP[y]                     ;Interpolate Untouched Points through the outline
SHPIX           -16 25     ;SHift point by a PIXel amount
""",

    'uni0E4A.low': """
                           #--- NPUSHB    22 44 50 112 15 96 15 2 15 10 9 8 7 6 26 25 24 6 21 37 4 9 29 ;PUSH N Bytes
MDAP[rnd]       29         ;Move Direct Absolute Point
MIRP[min,black] headstem 4 ;Move Indirect Relative Point
MDRP[rnd,grey]  37         ;Move Direct Relative Point
MDRP[rp0,rnd,grey] 21         ;Move Direct Relative Point
SLOOP           6          ;Set LOOP variable
IP              24 25 26 6 7 8 ;Interpolate Point
MIRP[min,black] headstem 10 ;Move Indirect Relative Point
MDRP[rnd,grey]  15         ;Move Direct Relative Point
DELTAP1         2 15 96 15 112 ;DELTA exception P1
IP              50         ;Interpolate Point
IP              44         ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- PUSHB_1   25        ;PUSH Bytes
                           #--- PUSHW_1   -16       ;PUSH Words
                           #--- NPUSHB    30 6 8 7 36 26 24 47 41 112 12 80 12 64 12 48 12 32 12 5 12 32 2 7 18 111 1 63 1 2 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
DELTAP1         2 1 63 1 111 ;DELTA exception P1
ALIGNRP         18         ;ALIGN to Reference Point
MIRP[min,black] cvt_7 2    ;Move Indirect Relative Point
SHP[rp2]        32         ;SHift Point using reference point
MDRP[rnd,grey]  12         ;Move Direct Relative Point
DELTAP1         5 12 32 12 48 12 64 12 80 12 112 ;DELTA exception P1
IP              41         ;Interpolate Point
IP              47         ;Interpolate Point
MDRP[rp0,rnd,grey] 24         ;Move Direct Relative Point
ALIGNRP         26         ;ALIGN to Reference Point
MDRP[rnd,grey]  36         ;Move Direct Relative Point
MIRP[min,black] cvt_7 8    ;Move Indirect Relative Point
SHP[rp2]        6          ;SHift Point using reference point
IUP[y]                     ;Interpolate Untouched Points through the outline
SHPIX           -16 25     ;SHift point by a PIXel amount
""",

    'uni0E4B': """
                           #--- PUSHB_7   3 5 1 7 7 11 10 ;PUSH Bytes
MDAP[rnd]       10         ;Move Direct Absolute Point
MDRP[rp0,rnd,grey] 11         ;Move Direct Relative Point
ALIGNRP         7          ;ALIGN to Reference Point
MIRP[rp0,min,black] cvt_7 1    ;Move Indirect Relative Point
ALIGNRP         5          ;ALIGN to Reference Point
MDRP[rnd,grey]  3          ;Move Direct Relative Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    14 7 5 8 7 2 11 143 0 111 0 63 0 3 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         3 0 63 0 111 0 143 ;DELTA exception P1
MDRP[rp0,rnd,grey] 11         ;Move Direct Relative Point
ALIGNRP         2          ;ALIGN to Reference Point
MIRP[rp0,min,black] cvt_7 8    ;Move Indirect Relative Point
ALIGNRP         5          ;ALIGN to Reference Point
MDRP[rnd,grey]  7          ;Move Direct Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E4B.low': """
                           #--- PUSHB_7   3 5 1 9 7 11 10 ;PUSH Bytes
MDAP[rnd]       10         ;Move Direct Absolute Point
MDRP[rp0,rnd,grey] 11         ;Move Direct Relative Point
ALIGNRP         7          ;ALIGN to Reference Point
MIRP[rp0,min,black] headstem 1 ;Move Indirect Relative Point
ALIGNRP         5          ;ALIGN to Reference Point
MDRP[rnd,grey]  3          ;Move Direct Relative Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    12 7 5 8 9 2 11 111 0 63 0 2 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         2 0 63 0 111 ;DELTA exception P1
MDRP[rp0,rnd,grey] 11         ;Move Direct Relative Point
ALIGNRP         2          ;ALIGN to Reference Point
MIRP[rp0,min,black] headstem 8 ;Move Indirect Relative Point
ALIGNRP         5          ;ALIGN to Reference Point
MDRP[rnd,grey]  7          ;Move Direct Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E4C': """
                           #--- PUSHB_5   23 29 3 11 17 ;PUSH Bytes
MDAP[rnd]       17         ;Move Direct Absolute Point
MDRP[rnd,grey]  11         ;Move Direct Relative Point
MDRP[rnd,grey]  3          ;Move Direct Relative Point
IP              29         ;Interpolate Point
IP              23         ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    14 14 7 10 26 20 6 143 0 111 0 63 0 3 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         3 0 63 0 111 0 143 ;DELTA exception P1
MDRP[rp0,rnd,grey] 6          ;Move Direct Relative Point
IP              20         ;Interpolate Point
IP              26         ;Interpolate Point
MDRP[min,rnd,grey] 10         ;Move Direct Relative Point
MIRP[min,black] cvt_7 14   ;Move Indirect Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E4C.low': """
                           #--- NPUSHB    17 4 30 1 30 28 96 3 1 3 39 11 24 1 24 28 12 18 ;PUSH N Bytes
MDAP[rnd]       18         ;Move Direct Absolute Point
MDRP[rnd,grey]  12         ;Move Direct Relative Point
MIRP[min,rnd,grey] cvt_28 24  ;Move Indirect Relative Point
DELTAP1         1 24 11    ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_39 3   ;Move Indirect Relative Point
DELTAP1         1 3 96     ;DELTA exception P1
MIRP[min,rnd,grey] cvt_28 30  ;Move Indirect Relative Point
DELTAP1         1 30 4     ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    24 15 7 11 11 27 1 27 28 111 6 1 6 39 4 21 1 21 28 111 0 63 0 2 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         2 0 63 0 111 ;DELTA exception P1
MIRP[min,rnd,grey] cvt_28 21  ;Move Indirect Relative Point
DELTAP1         1 21 4     ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_39 6   ;Move Indirect Relative Point
DELTAP1         1 6 111    ;DELTA exception P1
MIRP[min,rnd,grey] cvt_28 27  ;Move Indirect Relative Point
DELTAP1         1 27 11    ;DELTA exception P1
MDRP[min,rnd,grey] 11         ;Move Direct Relative Point
MIRP[min,black] cvt_7 15   ;Move Indirect Relative Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E4D': """
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   21        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 21 5 244 21 4 21 2 21 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   3         ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   3         ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   3         ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   3         ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   3         ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 3 6 239 3 223 3 159 3 143 3 79 3 63 3 15 3 7 3 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    10 15 5 251 15 11 15 2 15 9 9 ;PUSH N Bytes
MDAP[rnd]       9          ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 15 ;Move Indirect Relative Point
DELTAP1         2 15 11 15 251 ;DELTA exception P1
DELTAP2         5 15 267 15 283 15 299 15 315 15 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 3   ;Move Indirect Relative Point
DELTAP1         7 3 15 3 63 3 79 3 143 3 159 3 223 3 239 ;DELTA exception P1
DELTAP2         6 3 303 3 319 3 367 3 383 3 447 3 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 21 ;Move Indirect Relative Point
DELTAP1         2 21 4 21 244 ;DELTA exception P1
DELTAP2         5 21 260 21 276 21 292 21 308 21 496 ;DELTA exception P2
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 18 5 251 18 11 18 2 18 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   6         ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 6 6 224 6 208 6 144 6 128 6 64 6 48 6 0 6 7 6 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   12        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   12        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   12        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   12        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    15 12 5 244 12 4 12 2 12 9 111 0 63 0 2 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         2 0 63 0 111 ;DELTA exception P1
MIRP[min,rnd,grey] headstem 12 ;Move Indirect Relative Point
DELTAP1         2 12 4 12 244 ;DELTA exception P1
DELTAP2         5 12 260 12 276 12 292 12 308 12 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 6   ;Move Indirect Relative Point
DELTAP1         7 6 0 6 48 6 64 6 128 6 144 6 208 6 224 ;DELTA exception P1
DELTAP2         6 6 288 6 304 6 352 6 368 6 432 6 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 18 ;Move Indirect Relative Point
DELTAP1         2 18 11 18 251 ;DELTA exception P1
DELTAP2         5 18 267 18 283 18 299 18 315 18 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E4D.high': """

""",

    'uni0E4E': """
                           #--- NPUSHB    11 29 9 4 20 9 7 33 24 3 9 15 ;PUSH N Bytes
MDAP[rnd]       15         ;Move Direct Absolute Point
MDRP[rp0,rnd,grey] 9          ;Move Direct Relative Point
SLOOP           3          ;Set LOOP variable
IP              24 33 7    ;Interpolate Point
MIRP[min,black] headstem 20 ;Move Indirect Relative Point
MDRP[rp0,rnd,grey] 4          ;Move Direct Relative Point
MIRP[min,black] headstem 29 ;Move Indirect Relative Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    16 7 25 7 24 17 7 24 12 33 7 111 0 63 0 2 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
DELTAP1         2 0 63 0 111 ;DELTA exception P1
MIRP[min,black] cvt_7 33   ;Move Indirect Relative Point
MDRP[rp0,rnd,grey] 12         ;Move Direct Relative Point
IP              24         ;Interpolate Point
MIRP[min,black] cvt_7 17   ;Move Indirect Relative Point
MDAP[rnd]       24         ;Move Direct Absolute Point
MIRP[min,black] cvt_7 25   ;Move Indirect Relative Point
IP              7          ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E4F': """
                           #--- NPUSHB    35 39 45 33 27 33 121 15 105 15 89 15 72 15 56 15 5 15 16 9 3 27 118 21 102 21 86 21 71 21 55 21 5 21 16 3 ;PUSH N Bytes
MDAP[rnd]       3          ;Move Direct Absolute Point
MIRP[rp0,min,black] estemw 21  ;Move Indirect Relative Point
DELTAP1         5 21 55 21 71 21 86 21 102 21 118 ;DELTA exception P1
MDRP[min,rnd,white] 27         ;Move Direct Relative Point
SRP0            3          ;Set Reference Point 0
MDRP[rp0,rnd,grey] 9          ;Move Direct Relative Point
MIRP[rp0,min,black] estemw 15  ;Move Indirect Relative Point
DELTAP1         5 15 56 15 72 15 89 15 105 15 121 ;DELTA exception P1
MDRP[min,rnd,white] 33         ;Move Direct Relative Point
SRP1            27         ;Set Reference Point 1
SRP2            33         ;Set Reference Point 2
IP              45         ;Interpolate Point
IP              39         ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    35 42 36 24 30 30 121 18 105 18 89 18 72 18 56 18 5 18 16 6 0 24 118 12 102 12 86 12 71 12 55 12 5 12 16 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
MIRP[rp0,min,black] estemw 12  ;Move Indirect Relative Point
DELTAP1         5 12 55 12 71 12 86 12 102 12 118 ;DELTA exception P1
MDRP[min,rnd,white] 24         ;Move Direct Relative Point
SRP0            0          ;Set Reference Point 0
MDRP[rp0,rnd,grey] 6          ;Move Direct Relative Point
MIRP[rp0,min,black] estemw 18  ;Move Indirect Relative Point
DELTAP1         5 18 56 18 72 18 89 18 105 18 121 ;DELTA exception P1
MDRP[min,rnd,white] 30         ;Move Direct Relative Point
SRP1            30         ;Set Reference Point 1
SRP2            24         ;Set Reference Point 2
IP              36         ;Interpolate Point
IP              42         ;Interpolate Point
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E50': """
                           #--- NPUSHB    44 118 9 102 9 86 9 71 9 55 9 5 9 16 128 15 16 15 0 15 3 15 25 118 21 102 21 86 21 71 21 55 21 5 21 16 32 3 16 3 0 3 3 3 24 ;PUSH N Bytes
SRP0            24         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 3          ;Move Direct Relative Point
DELTAP1         3 3 0 3 16 3 32 ;DELTA exception P1
MIRP[min,black] estemw 21  ;Move Indirect Relative Point
DELTAP1         5 21 55 21 71 21 86 21 102 21 118 ;DELTA exception P1
SRP0            25         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 15         ;Move Direct Relative Point
DELTAP1         3 15 0 15 16 15 128 ;DELTA exception P1
MIRP[min,black] estemw 9   ;Move Indirect Relative Point
DELTAP1         5 9 55 9 71 9 86 9 102 9 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
                           #--- NPUSHB    24 118 12 103 12 87 12 3 12 10 0 31 24 121 18 104 18 88 18 3 18 10 6 32 24 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       24         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_32 6   ;Move Indirect Relative Point
MIRP[min,black] estemt 18  ;Move Indirect Relative Point
DELTAP1         3 18 88 18 104 18 121 ;DELTA exception P1
SRP0            24         ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 0   ;Move Indirect Relative Point
MIRP[min,black] estemt 12  ;Move Indirect Relative Point
DELTAP1         3 12 87 12 103 12 118 ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
""",

    'uni0E51': """
                           #--- NPUSHB    13 117 31 101 31 85 31 122 29 106 29 90 29 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 45 5 244 45 4 45 2 45 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 27 6 239 27 223 27 159 27 143 27 79 27 63 27 15 27 7 27 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   39        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    59 39 5 251 39 11 39 2 39 9 13 33 33 33 16 3 118 9 102 9 86 9 71 9 55 9 5 9 16 128 16 16 16 0 16 3 16 49 118 22 102 22 86 22 71 22 55 22 5 22 16 32 3 16 3 0 3 3 3 48 ;PUSH N Bytes
SRP0            48         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 3          ;Move Direct Relative Point
DELTAP1         3 3 0 3 16 3 32 ;DELTA exception P1
MIRP[min,black] estemw 22  ;Move Indirect Relative Point
DELTAP1         5 22 55 22 71 22 86 22 102 22 118 ;DELTA exception P1
SRP0            49         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 16         ;Move Direct Relative Point
DELTAP1         3 16 0 16 16 16 128 ;DELTA exception P1
MIRP[min,black] estemw 9   ;Move Indirect Relative Point
DELTAP1         5 9 55 9 71 9 86 9 102 9 118 ;DELTA exception P1
SRP1            3          ;Set Reference Point 1
SRP2            16         ;Set Reference Point 2
IP              33         ;Interpolate Point
MDAP[rnd]       33         ;Move Direct Absolute Point
MDAP[rnd]       33         ;Move Direct Absolute Point
MDRP[rnd,grey]  13         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 39 ;Move Indirect Relative Point
DELTAP1         2 39 11 39 251 ;DELTA exception P1
DELTAP2         5 39 267 39 283 39 299 39 315 39 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 27  ;Move Indirect Relative Point
DELTAP1         7 27 15 27 63 27 79 27 143 27 159 27 223 27 239 ;DELTA exception P1
DELTAP2         6 27 303 27 319 27 367 27 383 27 447 27 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 45 ;Move Indirect Relative Point
DELTAP1         2 45 4 45 244 ;DELTA exception P1
DELTAP2         5 45 260 45 276 45 292 45 308 45 496 ;DELTA exception P2
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 29 90 29 106 29 122 31 85 31 101 31 117 ;DELTA exception P1
                           #--- NPUSHB    26 122 34 106 34 90 34 117 32 101 32 85 32 6 117 28 101 28 85 28 122 26 106 26 90 26 6 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   36        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 36 6 251 36 159 36 2 36 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    47 42 5 251 42 11 42 2 42 9 30 117 25 102 25 87 25 3 25 6 0 122 19 105 19 88 19 3 19 6 9 16 22 3 0 5 6 32 122 12 105 12 88 12 3 12 6 13 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       13         ;Move Direct Absolute Point
MIRP[min,black] estemtc 12 ;Move Indirect Relative Point
DELTAP1         3 12 88 12 105 12 122 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_32 6   ;Move Indirect Relative Point
SLOOP           5          ;Set LOOP variable
IP              0 3 22 16 9 ;Interpolate Point
MIRP[min,black] estemtc 19 ;Move Indirect Relative Point
DELTAP1         3 19 88 19 105 19 122 ;DELTA exception P1
MDAP[rnd]       0          ;Move Direct Absolute Point
MIRP[min,black] estemtc 25 ;Move Indirect Relative Point
DELTAP1         3 25 87 25 102 25 117 ;DELTA exception P1
MDRP[rp0,rnd,grey] 30         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 42 ;Move Indirect Relative Point
DELTAP1         2 42 11 42 251 ;DELTA exception P1
DELTAP2         5 42 267 42 283 42 299 42 315 42 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 36  ;Move Indirect Relative Point
DELTAP1         2 36 159 36 251 ;DELTA exception P1
DELTAP2         6 36 267 36 283 36 299 36 315 36 367 36 383 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 26 90 26 106 26 122 28 85 28 101 28 117 ;DELTA exception P1
DELTAP1         6 32 85 32 101 32 117 34 90 34 106 34 122 ;DELTA exception P1
""",

    'uni0E52': """
                           #--- NPUSHB    55 117 31 101 31 85 31 122 33 106 33 90 33 6 117 27 101 27 85 27 122 25 106 25 90 25 6 22 21 20 39 38 37 6 41 35 118 41 102 41 86 41 71 41 55 41 5 41 16 127 17 0 17 2 17 55 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   45        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 45 5 251 45 11 45 2 45 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   29        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 29 6 224 29 208 29 144 29 128 29 64 29 48 29 0 29 7 29 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   51        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    48 51 5 244 51 4 51 2 51 9 118 24 102 24 86 24 71 24 55 24 5 24 16 31 35 15 35 2 35 118 12 102 12 86 12 71 12 55 12 5 12 16 16 4 0 4 2 4 54 ;PUSH N Bytes
SRP0            54         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 4          ;Move Direct Relative Point
DELTAP1         2 4 0 4 16 ;DELTA exception P1
MIRP[min,black] estemw 12  ;Move Indirect Relative Point
DELTAP1         5 12 55 12 71 12 86 12 102 12 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 35         ;Move Direct Relative Point
DELTAP1         2 35 15 35 31 ;DELTA exception P1
MIRP[min,black] estemw 24  ;Move Indirect Relative Point
DELTAP1         5 24 55 24 71 24 86 24 102 24 118 ;DELTA exception P1
MIRP[min,rnd,grey] headstem 51 ;Move Indirect Relative Point
DELTAP1         2 51 4 51 244 ;DELTA exception P1
DELTAP2         5 51 260 51 276 51 292 51 308 51 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 29  ;Move Indirect Relative Point
DELTAP1         7 29 0 29 48 29 64 29 128 29 144 29 208 29 224 ;DELTA exception P1
DELTAP2         6 29 288 29 304 29 352 29 368 29 432 29 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 45 ;Move Indirect Relative Point
DELTAP1         2 45 11 45 251 ;DELTA exception P1
DELTAP2         5 45 267 45 283 45 299 45 315 45 511 ;DELTA exception P2
SRP0            55         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 17         ;Move Direct Relative Point
DELTAP1         2 17 0 17 127 ;DELTA exception P1
MIRP[min,black] estemw 41  ;Move Indirect Relative Point
DELTAP1         5 41 55 41 71 41 86 41 102 41 118 ;DELTA exception P1
SRP1            35         ;Set Reference Point 1
SRP2            41         ;Set Reference Point 2
SLOOP           6          ;Set LOOP variable
IP              37 38 39 20 21 22 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 25 90 25 106 25 122 27 85 27 101 27 117 ;DELTA exception P1
DELTAP1         6 33 90 33 106 33 122 31 85 31 101 31 117 ;DELTA exception P1
                           #--- NPUSHB    13 122 30 106 30 90 30 117 28 101 28 85 28 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 42 5 244 42 4 42 2 42 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   32        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 32 6 239 32 223 32 159 32 143 32 79 32 63 32 15 32 7 32 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   48        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    56 48 5 251 48 11 48 2 48 9 26 26 38 197 21 181 21 165 21 149 21 133 21 53 21 37 21 21 21 5 21 9 21 22 121 20 104 20 88 20 3 20 10 9 37 39 32 118 16 103 16 87 16 3 16 10 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
MIRP[min,black] estemt 16  ;Move Indirect Relative Point
DELTAP1         3 16 87 16 103 16 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] cvt_32 39  ;Move Indirect Relative Point
ALIGNRP         37         ;ALIGN to Reference Point
MDRP[min,rnd,grey] 9          ;Move Direct Relative Point
MIRP[min,black] estemt 20  ;Move Indirect Relative Point
DELTAP1         3 20 88 20 104 20 121 ;DELTA exception P1
SHP[rp2]        22         ;SHift Point using reference point
MDRP[rp0,min,rnd,grey] 21         ;Move Direct Relative Point
DELTAP1         9 21 5 21 21 21 37 21 53 21 133 21 149 21 165 21 181 21 197 ;DELTA exception P1
MDRP[black]     38         ;Move Direct Relative Point
MDRP[rp0,rnd,grey] 26         ;Move Direct Relative Point
MDAP[rnd]       26         ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 48 ;Move Indirect Relative Point
DELTAP1         2 48 11 48 251 ;DELTA exception P1
DELTAP2         5 48 267 48 283 48 299 48 315 48 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 32  ;Move Indirect Relative Point
DELTAP1         7 32 15 32 63 32 79 32 143 32 159 32 223 32 239 ;DELTA exception P1
DELTAP2         6 32 303 32 319 32 367 32 383 32 447 32 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 42 ;Move Indirect Relative Point
DELTAP1         2 42 4 42 244 ;DELTA exception P1
DELTAP2         5 42 260 42 276 42 292 42 308 42 496 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 28 85 28 101 28 117 30 90 30 106 30 122 ;DELTA exception P1
""",

    'uni0E53': """
                           #--- NPUSHB    66 122 30 106 30 90 30 117 28 101 28 85 28 6 122 22 106 22 90 22 117 24 101 24 85 24 6 41 118 10 102 10 86 10 71 10 55 10 5 10 16 11 11 4 35 118 47 102 47 86 47 71 47 55 47 5 47 16 128 4 16 4 0 4 3 4 63 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 59 6 251 59 159 59 2 59 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   53        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 53 5 251 53 11 53 2 53 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    32 26 2 112 26 64 26 48 26 3 26 118 17 102 17 86 17 71 17 55 17 5 17 16 32 35 16 35 0 35 3 35 62 ;PUSH N Bytes
SRP0            62         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 35         ;Move Direct Relative Point
DELTAP1         3 35 0 35 16 35 32 ;DELTA exception P1
MIRP[min,black] estemw 17  ;Move Indirect Relative Point
DELTAP1         5 17 55 17 71 17 86 17 102 17 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 26         ;Move Direct Relative Point
DELTAP1         3 26 48 26 64 26 112 ;DELTA exception P1
DELTAP2         2 26 256 26 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 53 ;Move Indirect Relative Point
DELTAP1         2 53 11 53 251 ;DELTA exception P1
DELTAP2         5 53 267 53 283 53 299 53 315 53 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 59  ;Move Indirect Relative Point
DELTAP1         2 59 159 59 251 ;DELTA exception P1
DELTAP2         6 59 267 59 283 59 299 59 315 59 367 59 383 ;DELTA exception P2
SRP0            63         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 4          ;Move Direct Relative Point
DELTAP1         3 4 0 4 16 4 128 ;DELTA exception P1
MIRP[min,black] estemw 47  ;Move Indirect Relative Point
DELTAP1         5 47 55 47 71 47 86 47 102 47 118 ;DELTA exception P1
SRP1            35         ;Set Reference Point 1
SRP2            4          ;Set Reference Point 2
IP              11         ;Interpolate Point
MDAP[rnd]       11         ;Move Direct Absolute Point
MIRP[min,black] estemw 10  ;Move Indirect Relative Point
DELTAP1         5 10 55 10 71 10 86 10 102 10 118 ;DELTA exception P1
IP              41         ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 24 85 24 101 24 117 22 90 22 106 22 122 ;DELTA exception P1
DELTAP1         6 28 85 28 101 28 117 30 90 30 106 30 122 ;DELTA exception P1
                           #--- NPUSHB    13 122 27 106 27 90 27 117 25 101 25 85 25 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 56 5 251 56 11 56 2 56 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 23 6 224 23 208 23 144 23 128 23 64 23 48 23 0 23 7 23 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   50        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    34 50 5 244 50 4 50 2 50 9 29 31 1 11 14 121 7 104 7 88 7 3 7 10 38 11 47 4 41 17 35 6 44 32 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_32 44  ;Move Indirect Relative Point
SLOOP           6          ;Set LOOP variable
IP              35 17 41 4 47 11 ;Interpolate Point
ALIGNRP         38         ;ALIGN to Reference Point
MIRP[min,black] estemt 7   ;Move Indirect Relative Point
DELTAP1         3 7 88 7 104 7 121 ;DELTA exception P1
SHP[rp2]        14         ;SHift Point using reference point
MDAP[rnd]       11         ;Move Direct Absolute Point
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 29  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 50 ;Move Indirect Relative Point
DELTAP1         2 50 4 50 244 ;DELTA exception P1
DELTAP2         5 50 260 50 276 50 292 50 308 50 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 23  ;Move Indirect Relative Point
DELTAP1         7 23 0 23 48 23 64 23 128 23 144 23 208 23 224 ;DELTA exception P1
DELTAP2         6 23 288 23 304 23 352 23 368 23 432 23 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 56 ;Move Indirect Relative Point
DELTAP1         2 56 11 56 251 ;DELTA exception P1
DELTAP2         5 56 267 56 283 56 299 56 315 56 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 25 85 25 101 25 117 27 90 27 106 27 122 ;DELTA exception P1
""",

    'uni0E54': """
                           #--- NPUSHB    13 117 37 101 37 85 37 122 35 106 35 90 35 6 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   55        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    11 55 5 244 55 4 55 2 55 9 42 30 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 33 6 239 33 223 33 159 33 143 33 79 33 63 33 15 33 7 33 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    38 49 5 251 49 11 49 2 49 9 45 39 39 39 18 25 18 118 25 102 25 86 25 71 25 55 25 5 25 16 32 10 16 10 0 10 3 10 58 ;PUSH N Bytes
SRP0            58         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 10         ;Move Direct Relative Point
DELTAP1         3 10 0 10 16 10 32 ;DELTA exception P1
MIRP[min,black] estemw 25  ;Move Indirect Relative Point
DELTAP1         5 25 55 25 71 25 86 25 102 25 118 ;DELTA exception P1
MDAP[rnd]       18         ;Move Direct Absolute Point
SRP1            25         ;Set Reference Point 1
SRP2            18         ;Set Reference Point 2
IP              39         ;Interpolate Point
MDAP[rnd]       39         ;Move Direct Absolute Point
MDAP[rnd]       39         ;Move Direct Absolute Point
MDRP[rnd,grey]  45         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 49 ;Move Indirect Relative Point
DELTAP1         2 49 11 49 251 ;DELTA exception P1
DELTAP2         5 49 267 49 283 49 299 49 315 49 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 33  ;Move Indirect Relative Point
DELTAP1         7 33 15 33 63 33 79 33 143 33 159 33 223 33 239 ;DELTA exception P1
DELTAP2         6 33 303 33 319 33 367 33 383 33 447 33 463 ;DELTA exception P2
IP              30         ;Interpolate Point
IP              42         ;Interpolate Point
MIRP[min,rnd,grey] headstem 55 ;Move Indirect Relative Point
DELTAP1         2 55 4 55 244 ;DELTA exception P1
DELTAP2         5 55 260 55 276 55 292 55 308 55 496 ;DELTA exception P2
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 35 90 35 106 35 122 37 85 37 101 37 117 ;DELTA exception P1
                           #--- NPUSHB    38 117 38 101 38 85 38 122 40 106 40 90 40 6 117 34 101 34 85 34 122 32 106 32 90 32 6 117 28 102 28 87 28 3 28 6 7 31 0 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 46 5 244 46 4 46 2 46 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   42        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 42 6 239 42 223 42 159 42 143 42 79 42 63 42 15 42 7 42 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    23 52 5 251 52 11 52 2 52 9 36 36 121 21 104 21 88 21 3 21 10 17 25 10 ;PUSH N Bytes
                           #--- PUSHW_1   527       ;PUSH Words
                           #--- PUSHB_2   14 1      ;PUSH Bytes
                           #--- PUSHW_1   495       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   351       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- NPUSHB    21 14 5 207 14 175 14 31 14 3 14 2 118 45 103 45 87 45 3 45 10 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
MIRP[min,black] estemt 45  ;Move Indirect Relative Point
DELTAP1         3 45 87 45 103 45 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] tvheight_num 14 ;Move Indirect Relative Point
DELTAP1         3 14 31 14 175 14 207 ;DELTA exception P1
DELTAP2         5 14 319 14 351 14 383 14 463 14 495 ;DELTA exception P2
DELTAP3         1 14 527   ;DELTA exception P3
IP              10         ;Interpolate Point
IP              25         ;Interpolate Point
MDRP[rnd,grey]  17         ;Move Direct Relative Point
MIRP[rp0,min,black] estemt 21  ;Move Indirect Relative Point
DELTAP1         3 21 88 21 104 21 121 ;DELTA exception P1
MDRP[rp0,min,rnd,white] 36         ;Move Direct Relative Point
MDAP[rnd]       36         ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 52 ;Move Indirect Relative Point
DELTAP1         2 52 11 52 251 ;DELTA exception P1
DELTAP2         5 52 267 52 283 52 299 52 315 52 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 42  ;Move Indirect Relative Point
DELTAP1         7 42 15 42 63 42 79 42 143 42 159 42 223 42 239 ;DELTA exception P1
DELTAP2         6 42 303 42 319 42 367 42 383 42 447 42 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 46 ;Move Indirect Relative Point
DELTAP1         2 46 4 46 244 ;DELTA exception P1
DELTAP2         5 46 260 46 276 46 292 46 308 46 496 ;DELTA exception P2
SRP0            0          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 7   ;Move Indirect Relative Point
MIRP[min,black] estemtc 28 ;Move Indirect Relative Point
DELTAP1         3 28 87 28 102 28 117 ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 32 90 32 106 32 122 34 85 34 101 34 117 ;DELTA exception P1
DELTAP1         6 40 90 40 106 40 122 38 85 38 101 38 117 ;DELTA exception P1
""",

    'uni0E55': """
                           #--- NPUSHB    25 117 47 101 47 85 47 122 45 106 45 90 45 117 19 101 19 85 19 122 17 106 17 90 17 12 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   77        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   77        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   77        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   77        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 77 5 244 77 4 77 2 77 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   15        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 15 6 239 15 223 15 159 15 143 15 79 15 63 15 15 15 7 15 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   71        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   71        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   71        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   71        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    10 71 5 251 71 11 71 2 71 9 21 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    11 65 5 244 65 4 65 2 65 9 52 40 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 43 6 239 43 223 43 159 43 143 43 79 43 63 43 15 43 7 43 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   59        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    38 59 5 251 59 11 59 2 59 9 55 49 49 49 28 35 28 118 35 102 35 86 35 71 35 55 35 5 35 16 32 10 16 10 0 10 3 10 80 ;PUSH N Bytes
SRP0            80         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 10         ;Move Direct Relative Point
DELTAP1         3 10 0 10 16 10 32 ;DELTA exception P1
MIRP[min,black] estemw 35  ;Move Indirect Relative Point
DELTAP1         5 35 55 35 71 35 86 35 102 35 118 ;DELTA exception P1
MDAP[rnd]       28         ;Move Direct Absolute Point
SRP1            35         ;Set Reference Point 1
SRP2            28         ;Set Reference Point 2
IP              49         ;Interpolate Point
MDAP[rnd]       49         ;Move Direct Absolute Point
MDAP[rnd]       49         ;Move Direct Absolute Point
MDRP[rnd,grey]  55         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 59 ;Move Indirect Relative Point
DELTAP1         2 59 11 59 251 ;DELTA exception P1
DELTAP2         5 59 267 59 283 59 299 59 315 59 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 43  ;Move Indirect Relative Point
DELTAP1         7 43 15 43 63 43 79 43 143 43 159 43 223 43 239 ;DELTA exception P1
DELTAP2         6 43 303 43 319 43 367 43 383 43 447 43 463 ;DELTA exception P2
IP              40         ;Interpolate Point
IP              52         ;Interpolate Point
MIRP[min,rnd,grey] headstem 65 ;Move Indirect Relative Point
DELTAP1         2 65 4 65 244 ;DELTA exception P1
DELTAP2         5 65 260 65 276 65 292 65 308 65 496 ;DELTA exception P2
MDRP[rp0,rnd,grey] 21         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 71 ;Move Indirect Relative Point
DELTAP1         2 71 11 71 251 ;DELTA exception P1
DELTAP2         5 71 267 71 283 71 299 71 315 71 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 15  ;Move Indirect Relative Point
DELTAP1         7 15 15 15 63 15 79 15 143 15 159 15 223 15 239 ;DELTA exception P1
DELTAP2         6 15 303 15 319 15 367 15 383 15 447 15 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 77 ;Move Indirect Relative Point
DELTAP1         2 77 4 77 244 ;DELTA exception P1
DELTAP2         5 77 260 77 276 77 292 77 308 77 496 ;DELTA exception P2
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 17 90 17 106 17 122 19 85 19 101 19 117 45 90 45 106 45 122 47 85 47 101 47 117 ;DELTA exception P1
                           #--- NPUSHB    62 122 22 106 22 90 22 117 20 101 20 85 20 122 50 106 50 90 50 117 48 101 48 85 48 12 122 14 106 14 90 14 117 44 101 44 85 44 122 42 106 42 90 42 117 16 101 16 85 16 12 117 38 102 38 87 38 3 38 6 7 31 0 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 56 5 244 56 4 56 2 56 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 52 6 239 52 223 52 159 52 143 52 79 52 63 52 15 52 7 52 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    21 62 5 251 62 11 62 2 62 9 46 46 121 31 104 31 88 31 3 31 10 23 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   68        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   68        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   68        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   68        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   68        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 68 6 251 68 159 68 2 68 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   74        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   74        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   74        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   74        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 74 5 251 74 11 74 2 74 9 ;PUSH N Bytes
                           #--- PUSHW_1   479       ;PUSH Words
                           #--- PUSHB_1   18        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- NPUSHB    10 18 2 144 18 1 18 27 13 35 10 ;PUSH N Bytes
                           #--- PUSHW_1   527       ;PUSH Words
                           #--- PUSHB_2   23 1      ;PUSH Bytes
                           #--- PUSHW_1   495       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   351       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- NPUSHB    21 23 5 207 23 175 23 31 23 3 23 2 118 55 103 55 87 55 3 55 10 0 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       0          ;Move Direct Absolute Point
MIRP[min,black] estemt 55  ;Move Indirect Relative Point
DELTAP1         3 55 87 55 103 55 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] tvheight_num 23 ;Move Indirect Relative Point
DELTAP1         3 23 31 23 175 23 207 ;DELTA exception P1
DELTAP2         5 23 319 23 351 23 383 23 463 23 495 ;DELTA exception P2
DELTAP3         1 23 527   ;DELTA exception P3
IP              10         ;Interpolate Point
IP              35         ;Interpolate Point
ALIGNRP         13         ;ALIGN to Reference Point
MDRP[rnd,grey]  27         ;Move Direct Relative Point
MDRP[rp0,rnd,grey] 18         ;Move Direct Relative Point
DELTAP1         1 18 144   ;DELTA exception P1
DELTAP2         2 18 368 18 479 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 74 ;Move Indirect Relative Point
DELTAP1         2 74 11 74 251 ;DELTA exception P1
DELTAP2         5 74 267 74 283 74 299 74 315 74 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 68  ;Move Indirect Relative Point
DELTAP1         2 68 159 68 251 ;DELTA exception P1
DELTAP2         6 68 267 68 283 68 299 68 315 68 367 68 383 ;DELTA exception P2
SRP0            23         ;Set Reference Point 0
MIRP[rp0,min,black] estemt 31  ;Move Indirect Relative Point
DELTAP1         3 31 88 31 104 31 121 ;DELTA exception P1
MDRP[rp0,min,rnd,white] 46         ;Move Direct Relative Point
MDAP[rnd]       46         ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 62 ;Move Indirect Relative Point
DELTAP1         2 62 11 62 251 ;DELTA exception P1
DELTAP2         5 62 267 62 283 62 299 62 315 62 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 52  ;Move Indirect Relative Point
DELTAP1         7 52 15 52 63 52 79 52 143 52 159 52 223 52 239 ;DELTA exception P1
DELTAP2         6 52 303 52 319 52 367 52 383 52 447 52 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 56 ;Move Indirect Relative Point
DELTAP1         2 56 4 56 244 ;DELTA exception P1
DELTAP2         5 56 260 56 276 56 292 56 308 56 496 ;DELTA exception P2
SRP0            0          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 7   ;Move Indirect Relative Point
MIRP[min,black] estemtc 38 ;Move Indirect Relative Point
DELTAP1         3 38 87 38 102 38 117 ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         12 16 85 16 101 16 117 42 90 42 106 42 122 44 85 44 101 44 117 14 90 14 106 14 122 ;DELTA exception P1
DELTAP1         12 48 85 48 101 48 117 50 90 50 106 50 122 20 85 20 101 20 117 22 90 22 106 22 122 ;DELTA exception P1
""",

    'uni0E56': """
                           #--- NPUSHB    35 117 10 101 10 85 10 122 8 106 8 90 8 6 118 40 102 40 86 40 71 40 55 40 5 40 16 128 20 16 20 0 20 3 20 56 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   46        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 46 5 251 46 11 46 2 46 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   12        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   12        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   12        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   12        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   12        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 12 6 224 12 208 12 144 12 128 12 64 12 48 12 0 12 7 12 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   52        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    16 52 5 244 52 4 52 2 52 9 6 27 31 30 34 7 27 ;PUSH N Bytes
MDAP[rnd]       27         ;Move Direct Absolute Point
MIRP[min,black] cvt_7 34   ;Move Indirect Relative Point
MDRP[rp0,rnd,grey] 30         ;Move Direct Relative Point
MDRP[grey]      31         ;Move Direct Relative Point
SRP0            27         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 6          ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 52 ;Move Indirect Relative Point
DELTAP1         2 52 4 52 244 ;DELTA exception P1
DELTAP2         5 52 260 52 276 52 292 52 308 52 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 12  ;Move Indirect Relative Point
DELTAP1         7 12 0 12 48 12 64 12 128 12 144 12 208 12 224 ;DELTA exception P1
DELTAP2         6 12 288 12 304 12 352 12 368 12 432 12 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 46 ;Move Indirect Relative Point
DELTAP1         2 46 11 46 251 ;DELTA exception P1
DELTAP2         5 46 267 46 283 46 299 46 315 46 511 ;DELTA exception P2
SRP0            56         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 20         ;Move Direct Relative Point
DELTAP1         3 20 0 20 16 20 128 ;DELTA exception P1
MIRP[min,black] estemw 40  ;Move Indirect Relative Point
DELTAP1         5 40 55 40 71 40 86 40 102 40 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 8 90 8 106 8 122 10 85 10 101 10 117 ;DELTA exception P1
                           #--- NPUSHB    26 122 13 106 13 90 13 117 11 101 11 85 11 6 117 7 101 7 85 7 122 5 106 5 90 5 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   49        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 49 5 251 49 11 49 2 49 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   9         ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 9 6 224 9 208 9 144 9 128 9 64 9 48 9 0 9 7 9 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   43        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    38 43 5 244 43 4 43 2 43 9 3 118 17 103 17 87 17 3 17 10 0 31 55 30 31 121 23 104 23 88 23 3 23 10 34 26 37 32 55 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       55         ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_32 37  ;Move Indirect Relative Point
IP              26         ;Interpolate Point
IP              34         ;Interpolate Point
MIRP[min,black] estemt 23  ;Move Indirect Relative Point
DELTAP1         3 23 88 23 104 23 121 ;DELTA exception P1
MDRP[rp0,rnd,grey] 31         ;Move Direct Relative Point
MDRP[grey]      30         ;Move Direct Relative Point
SRP0            55         ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 0   ;Move Indirect Relative Point
MIRP[min,black] estemt 17  ;Move Indirect Relative Point
DELTAP1         3 17 87 17 103 17 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 3          ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 43 ;Move Indirect Relative Point
DELTAP1         2 43 4 43 244 ;DELTA exception P1
DELTAP2         5 43 260 43 276 43 292 43 308 43 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 9   ;Move Indirect Relative Point
DELTAP1         7 9 0 9 48 9 64 9 128 9 144 9 208 9 224 ;DELTA exception P1
DELTAP2         6 9 288 9 304 9 352 9 368 9 432 9 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 49 ;Move Indirect Relative Point
DELTAP1         2 49 11 49 251 ;DELTA exception P1
DELTAP2         5 49 267 49 283 49 299 49 315 49 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 5 90 5 106 5 122 7 85 7 101 7 117 ;DELTA exception P1
DELTAP1         6 11 85 11 101 11 117 13 90 13 106 13 122 ;DELTA exception P1
""",

    'uni0E57': """
                           #--- NPUSHB    81 122 30 106 30 90 30 117 28 101 28 85 28 6 122 22 106 22 90 22 117 24 101 24 85 24 6 41 118 11 102 11 86 11 71 11 55 11 5 11 16 12 12 5 35 118 47 102 47 86 47 71 47 55 47 5 47 16 5 5 54 35 118 56 102 56 86 56 71 56 55 56 5 56 16 127 54 0 54 2 54 73 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   69        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   69        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   69        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   69        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   69        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 69 6 251 69 159 69 2 69 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 63 5 251 63 11 63 2 63 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   26        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    24 26 2 112 26 64 26 48 26 3 26 118 18 102 18 86 18 71 18 55 18 5 18 16 35 ;PUSH N Bytes
MDAP[rnd]       35         ;Move Direct Absolute Point
MIRP[min,black] estemw 18  ;Move Indirect Relative Point
DELTAP1         5 18 55 18 71 18 86 18 102 18 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 26         ;Move Direct Relative Point
DELTAP1         3 26 48 26 64 26 112 ;DELTA exception P1
DELTAP2         2 26 256 26 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 63 ;Move Indirect Relative Point
DELTAP1         2 63 11 63 251 ;DELTA exception P1
DELTAP2         5 63 267 63 283 63 299 63 315 63 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 69  ;Move Indirect Relative Point
DELTAP1         2 69 159 69 251 ;DELTA exception P1
DELTAP2         6 69 267 69 283 69 299 69 315 69 367 69 383 ;DELTA exception P2
SRP0            73         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 54         ;Move Direct Relative Point
DELTAP1         2 54 0 54 127 ;DELTA exception P1
MIRP[min,black] estemw 56  ;Move Indirect Relative Point
DELTAP1         5 56 55 56 71 56 86 56 102 56 118 ;DELTA exception P1
SRP1            35         ;Set Reference Point 1
SRP2            54         ;Set Reference Point 2
IP              5          ;Interpolate Point
MDAP[rnd]       5          ;Move Direct Absolute Point
MIRP[min,black] estemw 47  ;Move Indirect Relative Point
DELTAP1         5 47 55 47 71 47 86 47 102 47 118 ;DELTA exception P1
SRP1            35         ;Set Reference Point 1
SRP2            5          ;Set Reference Point 2
IP              12         ;Interpolate Point
MDAP[rnd]       12         ;Move Direct Absolute Point
MIRP[min,black] estemw 11  ;Move Indirect Relative Point
DELTAP1         5 11 55 11 71 11 86 11 102 11 118 ;DELTA exception P1
IP              41         ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 24 85 24 101 24 117 22 90 22 106 22 122 ;DELTA exception P1
DELTAP1         6 28 85 28 101 28 117 30 90 30 106 30 122 ;DELTA exception P1
                           #--- NPUSHB    17 122 27 106 27 90 27 117 25 101 25 85 25 6 12 12 15 23 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   66        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   66        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   66        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   66        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 66 5 251 66 11 66 2 66 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   23        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 23 6 224 23 208 23 144 23 128 23 64 23 48 23 0 23 7 23 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    43 60 5 244 60 4 60 2 60 9 29 31 1 15 121 8 104 8 88 8 3 8 10 56 38 17 5 41 18 35 5 44 32 2 118 50 103 50 87 50 3 50 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 50  ;Move Indirect Relative Point
DELTAP1         3 50 87 50 103 50 118 ;DELTA exception P1
IP              2          ;Interpolate Point
MIRP[rp0,rnd,grey] cvt_32 44  ;Move Indirect Relative Point
SLOOP           5          ;Set LOOP variable
IP              35 18 41 5 17 ;Interpolate Point
ALIGNRP         38         ;ALIGN to Reference Point
MDRP[rnd,grey]  56         ;Move Direct Relative Point
MIRP[min,black] estemt 8   ;Move Indirect Relative Point
DELTAP1         3 8 88 8 104 8 121 ;DELTA exception P1
SHP[rp2]        15         ;SHift Point using reference point
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 29  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 60 ;Move Indirect Relative Point
DELTAP1         2 60 4 60 244 ;DELTA exception P1
DELTAP2         5 60 260 60 276 60 292 60 308 60 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 23  ;Move Indirect Relative Point
DELTAP1         7 23 0 23 48 23 64 23 128 23 144 23 208 23 224 ;DELTA exception P1
DELTAP2         6 23 288 23 304 23 352 23 368 23 432 23 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 66 ;Move Indirect Relative Point
DELTAP1         2 66 11 66 251 ;DELTA exception P1
DELTAP2         5 66 267 66 283 66 299 66 315 66 511 ;DELTA exception P2
SRP1            23         ;Set Reference Point 1
SRP2            15         ;Set Reference Point 2
IP              12         ;Interpolate Point
MDAP[rnd]       12         ;Move Direct Absolute Point
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 25 85 25 101 25 117 27 90 27 106 27 122 ;DELTA exception P1
""",

    'uni0E58': """
                           #--- NPUSHB    26 117 42 101 42 85 42 122 40 106 40 90 40 6 50 29 52 27 4 38 54 54 7 24 24 38 19 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   65        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 65 5 244 65 4 65 2 65 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   38        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 38 6 239 38 223 38 159 38 143 38 79 38 63 38 15 38 7 38 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   69        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   69        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   69        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   69        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    25 69 5 251 69 11 69 2 69 9 44 12 118 19 102 19 86 19 71 19 55 19 5 19 16 4 ;PUSH N Bytes
MDAP[rnd]       4          ;Move Direct Absolute Point
MIRP[min,black] estemw 19  ;Move Indirect Relative Point
DELTAP1         5 19 55 19 71 19 86 19 102 19 118 ;DELTA exception P1
MDAP[rnd]       12         ;Move Direct Absolute Point
MDRP[rp0,rnd,grey] 44         ;Move Direct Relative Point
MIRP[min,rnd,grey] headstem 69 ;Move Indirect Relative Point
DELTAP1         2 69 11 69 251 ;DELTA exception P1
DELTAP2         5 69 267 69 283 69 299 69 315 69 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 38  ;Move Indirect Relative Point
DELTAP1         7 38 15 38 63 38 79 38 143 38 159 38 223 38 239 ;DELTA exception P1
DELTAP2         6 38 303 38 319 38 367 38 383 38 447 38 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 65 ;Move Indirect Relative Point
DELTAP1         2 65 4 65 244 ;DELTA exception P1
DELTAP2         5 65 260 65 276 65 292 65 308 65 496 ;DELTA exception P2
SRP1            19         ;Set Reference Point 1
SRP2            38         ;Set Reference Point 2
IP              24         ;Interpolate Point
MDAP[rnd]       24         ;Move Direct Absolute Point
MIRP[min,black] cvt_7 54   ;Move Indirect Relative Point
SRP1            54         ;Set Reference Point 1
SRP2            38         ;Set Reference Point 2
SLOOP           4          ;Set LOOP variable
IP              27 52 29 50 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 40 90 40 106 40 122 42 85 42 101 42 117 ;DELTA exception P1
                           #--- NPUSHB    35 117 39 101 39 85 39 122 37 106 37 90 37 6 121 52 104 52 88 52 3 52 10 27 118 32 103 32 87 32 3 32 10 47 31 1 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   56        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    9 56 5 244 56 4 56 2 56 9 ;PUSH N Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   447       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- PUSHB_1   35        ;PUSH Bytes
                           #--- PUSHW_1   303       ;PUSH Words
                           #--- NPUSHB    19 35 6 239 35 223 35 159 35 143 35 79 35 63 35 15 35 7 35 37 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   62        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    25 62 5 251 62 11 62 2 62 9 41 41 22 15 121 15 104 15 88 15 3 15 10 11 19 4 ;PUSH N Bytes
                           #--- PUSHW_1   527       ;PUSH Words
                           #--- PUSHB_2   8 1       ;PUSH Bytes
                           #--- PUSHW_1   495       ;PUSH Words
                           #--- PUSHB_1   8         ;PUSH Bytes
                           #--- PUSHW_1   463       ;PUSH Words
                           #--- PUSHB_1   8         ;PUSH Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   8         ;PUSH Bytes
                           #--- PUSHW_1   351       ;PUSH Words
                           #--- PUSHB_1   8         ;PUSH Bytes
                           #--- PUSHW_1   319       ;PUSH Words
                           #--- NPUSHB    21 8 5 207 8 175 8 31 8 3 8 2 118 22 103 22 87 22 3 22 10 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[min,black] estemt 22  ;Move Indirect Relative Point
DELTAP1         3 22 87 22 103 22 118 ;DELTA exception P1
MIRP[rp0,rnd,grey] tvheight_num 8 ;Move Indirect Relative Point
DELTAP1         3 8 31 8 175 8 207 ;DELTA exception P1
DELTAP2         5 8 319 8 351 8 383 8 463 8 495 ;DELTA exception P2
DELTAP3         1 8 527    ;DELTA exception P3
IP              4          ;Interpolate Point
IP              19         ;Interpolate Point
MDRP[rnd,grey]  11         ;Move Direct Relative Point
MIRP[min,black] estemt 15  ;Move Indirect Relative Point
DELTAP1         3 15 88 15 104 15 121 ;DELTA exception P1
SRP1            15         ;Set Reference Point 1
SRP2            22         ;Set Reference Point 2
IP              41         ;Interpolate Point
MDAP[rnd]       41         ;Move Direct Absolute Point
MIRP[min,rnd,grey] headstem 62 ;Move Indirect Relative Point
DELTAP1         2 62 11 62 251 ;DELTA exception P1
DELTAP2         5 62 267 62 283 62 299 62 315 62 511 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 35  ;Move Indirect Relative Point
DELTAP1         7 35 15 35 63 35 79 35 143 35 159 35 223 35 239 ;DELTA exception P1
DELTAP2         6 35 303 35 319 35 367 35 383 35 447 35 463 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 56 ;Move Indirect Relative Point
DELTAP1         2 56 4 56 244 ;DELTA exception P1
DELTAP2         5 56 260 56 276 56 292 56 308 56 496 ;DELTA exception P2
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 47  ;Move Indirect Relative Point
MIRP[min,black] estemt 32  ;Move Indirect Relative Point
DELTAP1         3 32 87 32 103 32 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 27         ;Move Direct Relative Point
MIRP[min,black] estemt 52  ;Move Indirect Relative Point
DELTAP1         3 52 88 52 104 52 121 ;DELTA exception P1
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 37 90 37 106 37 122 39 85 39 101 39 117 ;DELTA exception P1
""",

    'uni0E59': """
                           #--- NPUSHB    61 122 20 106 20 90 20 117 18 101 18 85 18 6 117 14 101 14 85 14 122 12 106 12 90 12 6 46 39 51 34 4 43 56 43 31 56 2 56 118 0 102 0 86 0 71 0 55 0 5 0 16 2 111 1 95 1 0 1 3 1 31 ;PUSH N Bytes
                           #--- PUSHW_1   383       ;PUSH Words
                           #--- PUSHB_1   66        ;PUSH Bytes
                           #--- PUSHW_1   367       ;PUSH Words
                           #--- PUSHB_1   66        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   66        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   66        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   66        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 66 6 251 66 159 66 2 66 36 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   60        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 60 5 251 60 11 60 2 60 9 ;PUSH N Bytes
                           #--- PUSHW_1   272       ;PUSH Words
                           #--- PUSHB_1   16        ;PUSH Bytes
                           #--- PUSHW_1   256       ;PUSH Words
                           #--- NPUSHB    32 16 2 112 16 64 16 48 16 3 16 118 8 102 8 86 8 71 8 55 8 5 8 16 32 25 16 25 0 25 3 25 69 ;PUSH N Bytes
SRP0            69         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 25         ;Move Direct Relative Point
DELTAP1         3 25 0 25 16 25 32 ;DELTA exception P1
MIRP[min,black] estemw 8   ;Move Indirect Relative Point
DELTAP1         5 8 55 8 71 8 86 8 102 8 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 16         ;Move Direct Relative Point
DELTAP1         3 16 48 16 64 16 112 ;DELTA exception P1
DELTAP2         2 16 256 16 272 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 60 ;Move Indirect Relative Point
DELTAP1         2 60 11 60 251 ;DELTA exception P1
DELTAP2         5 60 267 60 283 60 299 60 315 60 511 ;DELTA exception P2
MIRP[min,rnd,grey] cvt_36 66  ;Move Indirect Relative Point
DELTAP1         2 66 159 66 251 ;DELTA exception P1
DELTAP2         6 66 267 66 283 66 299 66 315 66 367 66 383 ;DELTA exception P2
IP              31         ;Interpolate Point
MDAP[rnd]       1          ;Move Direct Absolute Point
DELTAP1         3 1 0 1 95 1 111 ;DELTA exception P1
MDRP[grey]      2          ;Move Direct Relative Point
MIRP[rp0,min,black] estemw 0   ;Move Indirect Relative Point
DELTAP1         5 0 55 0 71 0 86 0 102 0 118 ;DELTA exception P1
MDRP[grey]      56         ;Move Direct Relative Point
SRP1            2          ;Set Reference Point 1
SRP2            56         ;Set Reference Point 2
IP              31         ;Interpolate Point
MDAP[rnd]       43         ;Move Direct Absolute Point
SRP1            56         ;Set Reference Point 1
SRP2            43         ;Set Reference Point 2
SLOOP           4          ;Set LOOP variable
IP              34 51 39 46 ;Interpolate Point
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 12 90 12 106 12 122 14 85 14 101 14 117 ;DELTA exception P1
DELTAP1         6 18 85 18 101 18 117 20 90 20 106 20 122 ;DELTA exception P1
                           #--- NPUSHB    13 122 15 106 15 90 15 117 17 101 17 85 17 6 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   63        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    9 63 5 251 63 11 63 2 63 9 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   13        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 13 6 224 13 208 13 144 13 128 13 64 13 48 13 0 13 7 13 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   57        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    42 57 5 244 57 4 57 2 57 9 19 31 1 118 39 103 39 87 39 3 39 10 46 5 121 51 104 51 88 51 3 51 10 42 28 56 2 8 25 4 34 32 1 ;PUSH N Bytes
SVTCA[y-axis]              ;Set freedom and projection Vectors To Coordinate Axis
MDAP[rnd]       1          ;Move Direct Absolute Point
MIRP[rp0,rnd,grey] cvt_32 34  ;Move Indirect Relative Point
SLOOP           4          ;Set LOOP variable
IP              25 8 2 56  ;Interpolate Point
ALIGNRP         28         ;ALIGN to Reference Point
MDRP[rnd,grey]  42         ;Move Direct Relative Point
MIRP[min,black] estemt 51  ;Move Indirect Relative Point
DELTAP1         3 51 88 51 104 51 121 ;DELTA exception P1
SHP[rp2]        5          ;SHift Point using reference point
MDRP[rp0,rnd,grey] 46         ;Move Direct Relative Point
MIRP[min,black] estemt 39  ;Move Indirect Relative Point
DELTAP1         3 39 87 39 103 39 118 ;DELTA exception P1
SRP0            1          ;Set Reference Point 0
MIRP[rp0,rnd,grey] cvt_31 19  ;Move Indirect Relative Point
MIRP[min,rnd,grey] headstem 57 ;Move Indirect Relative Point
DELTAP1         2 57 4 57 244 ;DELTA exception P1
DELTAP2         5 57 260 57 276 57 292 57 308 57 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 13  ;Move Indirect Relative Point
DELTAP1         7 13 0 13 48 13 64 13 128 13 144 13 208 13 224 ;DELTA exception P1
DELTAP2         6 13 288 13 304 13 352 13 368 13 432 13 448 ;DELTA exception P2
MIRP[min,rnd,grey] headstem 63 ;Move Indirect Relative Point
DELTAP1         2 63 11 63 251 ;DELTA exception P1
DELTAP2         5 63 267 63 283 63 299 63 315 63 511 ;DELTA exception P2
IUP[y]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 17 85 17 101 17 117 15 90 15 106 15 122 ;DELTA exception P1
""",

    'uni0E5A': """
                           #--- NPUSHB    53 117 20 101 20 85 20 122 18 106 18 90 18 6 118 23 102 23 86 23 71 23 55 23 5 23 16 22 32 1 16 1 0 1 3 1 118 39 102 39 86 39 71 39 55 39 5 39 16 127 37 1 37 41 ;PUSH N Bytes
                           #--- PUSHW_1   511       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   315       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   299       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   283       ;PUSH Words
                           #--- PUSHB_1   27        ;PUSH Bytes
                           #--- PUSHW_1   267       ;PUSH Words
                           #--- NPUSHB    10 27 5 251 27 11 27 2 27 9 17 ;PUSH N Bytes
                           #--- PUSHW_1   448       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   432       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   368       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   352       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   304       ;PUSH Words
                           #--- PUSHB_1   14        ;PUSH Bytes
                           #--- PUSHW_1   288       ;PUSH Words
                           #--- NPUSHB    19 14 6 224 14 208 14 144 14 128 14 64 14 48 14 0 14 7 14 37 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   292       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   276       ;PUSH Words
                           #--- PUSHB_1   33        ;PUSH Bytes
                           #--- PUSHW_1   260       ;PUSH Words
                           #--- NPUSHB    18 33 5 244 33 4 33 2 33 9 128 8 16 8 0 8 3 8 40 ;PUSH N Bytes
SRP0            40         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 8          ;Move Direct Relative Point
DELTAP1         3 8 0 8 16 8 128 ;DELTA exception P1
MIRP[min,rnd,grey] headstem 33 ;Move Indirect Relative Point
DELTAP1         2 33 4 33 244 ;DELTA exception P1
DELTAP2         5 33 260 33 276 33 292 33 308 33 496 ;DELTA exception P2
MIRP[rp0,rnd,grey] cvt_37 14  ;Move Indirect Relative Point
DELTAP1         7 14 0 14 48 14 64 14 128 14 144 14 208 14 224 ;DELTA exception P1
DELTAP2         6 14 288 14 304 14 352 14 368 14 432 14 448 ;DELTA exception P2
IP              17         ;Interpolate Point
MIRP[min,rnd,grey] headstem 27 ;Move Indirect Relative Point
DELTAP1         2 27 11 27 251 ;DELTA exception P1
DELTAP2         5 27 267 27 283 27 299 27 315 27 511 ;DELTA exception P2
SRP0            41         ;Set Reference Point 0
MDRP[rp0,rnd,grey] 37         ;Move Direct Relative Point
DELTAP1         1 37 127   ;DELTA exception P1
MIRP[min,black] estemw 39  ;Move Indirect Relative Point
DELTAP1         5 39 55 39 71 39 86 39 102 39 118 ;DELTA exception P1
MDRP[rp0,rnd,grey] 1          ;Move Direct Relative Point
DELTAP1         3 1 0 1 16 1 32 ;DELTA exception P1
ALIGNRP         22         ;ALIGN to Reference Point
MIRP[min,black] estemw 23  ;Move Indirect Relative Point
DELTAP1         5 23 55 23 71 23 86 23 102 23 118 ;DELTA exception P1
IUP[x]                     ;Interpolate Untouched Points through the outline
DELTAP1         6 18 90 18 106 18 122 20 85 20 101 20 117 ;DELTA exception P1
                           #--- NPUSHB    23 122 15 106 15 90 15 117 13 101 13 85 13 6 121 5 104 5 88 5 3 5 10 19 ;PUSH N Bytes
                           #--- PUSHW_1   496       ;PUSH Words
                           #--- PUSHB_1   24        ;PUSH Bytes
                           #--- PUSHW_1   308       ;PUSH Words
                       