#!/usr/bin/env python
#   #----- MODIFY pseudo_code_dict BY -----------
#   #----- SUBSTITUTE FUNCTION IN TEXT FORM -----
#   #----- TO REAL pseudo_code ------------------
#   
#   ### THIS LINE IN THE TOP
#   from dttcmd import *
#
#   ### THESE LINES IN THE BOTTOM
#   self_func = []
#   for i in dir():
#       if callable(eval(i)): self_func.append(i)
#   
#   for i in pseudo_code_dict.keys():
#       p_list = pseudo_code_dict[i].sp_listit('\n')
#       for j in range(len(p_list)):
#           if '(' in p_list[j]:
#               if p_list[j].sp_listit('(',1)[0] in self_func:
#                   l = [n for n in range(len(p_list[j])) if p_list[j][n] == ')']
#                   t = p_list[j][:l[-1]+1]
#                   p_list[j] = p_list[j].rep_listace(t, eval(t))
#       pseudo_code_dict[i] = '\n'.join(p_list)
#   

import sys

from dttcmd import *

header_file = 'header_' + __name__.strip('man_')
exec 'from %s import *' % (header_file,)

#func_arg_list = [[2, 0], [1, 0], [3, 1], [1, 1], [4, 0], [0, 1], [0, 1], [0, 1], [3, 0], [3, 0], [2, 0], [1, 0], [1, 0], [4, 0], [3, 0], [5, 0], [2, 0], [2, 0], [2, 0], [3, 0], [0, 0]]
#
#cvt_dict = {
#    'evheight_lu' : 0,   #  -422
#    'tvheight_lu' : 0,   #  -422
#    'vbase' : 1,   #  0
#    'tvheight_num' : 2,   #  908
#    'evheight' : 3,   #  1062
#    'tvheight' : 4,   #  1140
#    'ecvheight' : 5,   #  1450
#    'tvheight_po' : 5,   #  1450
#    'estemtc' : 6,   #  218
#    'ecstemt' : 6,   #  218
#    'tstemtc' : 6,   #  218
#    'cvt_7' : 7,   #  130
#    'cvt_8' : 8,   #  139
#    'estemt' : 9,   #  207
#    'tstemt' : 9,   #  207
#    'estemw' : 10,   #  240
#    'tstemw' : 11,   #  240
#    'ecstemw' : 12,   #  253
#    'cvt_13' : 13,   #  233
#    'ecstemtc': 13,  #230
#    'cvt_14' : 14,   #  242
#    'cvt_15' : 15,   #  214
#    'cvt_16' : 16,   #  188
#    'sarastemw' : 16,   #  188
#    'stemwa' : 16,   #  188
#    'cvt_17' : 17,   #  216
#    'cvt_18' : 18,   #  210
#    'cvt_19' : 19,   #  175
#    'cvt_20' : 20,   #  177
#    'sarastemt':20,
#    'cvt_21' : 21,   #  231
#    'cvt_22' : 22,   #  113
#    'head_sara_stem' : 22,   #  113
#    'cvt_23' : 23,   #  133
##USER LAND
#    'tvheight_num_shoot' : 24,  # 908+24=932
#    'evheight_shoot' : 25,      # 1062+24=1086
#    'tvheight_shoot' : 26,      # 1140+24=1164
#    'ecvheight_shoot' : 27,     # 1450+27=1477
#    'headstem'  : 28,    # 140
#    'headdia'   : 29,    # 430
#    'headstemplushole' : 30,    # 290 
#    'estemwc'   : 31,   # 260
#    'ecstemwc'   : 32,   # 273
#    'vbase_shoot': 33,  #24
#    'tvbase_shoot': 33,  #24
#    'head_sara':    34, #360
#    }


#---GENERATE STEM FUNCTION---
#predefine delta string of stem (put before gen_cvt_func)
#ds_headstemplushole = "15-4 16-4 17-2 18-6 19-2 20+2 21-2 24+4 28+4 29+4 30+4 32-4 33+4 34+4 38+8 "
ds_headstemplushole = "19-8 25+4 26-4 27-4 28-4 29-4 30+4 31+4 34-8 "
ds_headstem = "9-4 "
ds_headdia = "13+1 14+8 "
ds_head_sara_stem = "9-4 10-4 "
ds_head_sara = "9+8 10+8 15+8 "
#ds_tstemtc = "9-1 10-1 11-1 12-1 13-1 14-1 15-1 16-1 "
#ds_tstemtc_thin = "9-2 10-2 11-2 12-2 13-2 14-2 15-2 16-2 "
#ds_tstemt = "9-1 10-1 11-1 12-1 13-1 14-1 15-1 16-1 "
#ds_tstemt_thin = "9-2 10-2 11-2 12-2 13-2 14-2 15-2 16-2 "
ds_tstemwm = "12-4 "

gen_cvt_func_dict = {
    #FOR UNROUNDED STEM
    #[min,black]
    #'mb':   ['estem*','tstem*','stem*','ecstem*'],
    #[min,rnd,black]
    #'mrb':  ['headstem*','head_sara_stem','head_sara'],
    #
    #FOR ROUNDED STEM
    #[min,rnd,black]
    'mrb':  ['estem*','tstem*','stem*','ecstem*','headstem*','head_sara_stem','head_sara','sarastem*','wanstem*'],
    #[rp0,rnd,grey]
    '0rg':  ['headdia'],
    }

for arg,cvt_list in gen_cvt_func_dict.iteritems():
    new_list = []
    for i in cvt_list:
        if i[-1]=='*':
            c = i.strip('*')
            n = len(c)
            l = [x for x in cvt_dict.keys() if x[:n]==c]
            new_list.extend(l)
        else:
            new_list.append(i)
        
    for i in new_list:
        for j in ['1','1m','2','2m']:   #1=forward/bottomup, #2=reverse/topdown
            if j[-1] == 'm':    #m=move rp0
                cmd = 'mirp0'+arg
            else:
                cmd = 'mirp'+arg
            if j[0] == '1': #1=forward/bottomup, #2=reverse/topdown
                direction = '+'
            else:
                direction = '-'
            #AUTO GENERATE delta string
            try:
                exec "a = ds_%s " % (i,)
            except:
                exec "ds_%s = ''" % (i,)

            #GEN FUNC
            exec '''def %s_%s(s,direction="%s"):
    return %s("%s",s,ds_%s,direction)
''' % (i,j,direction,cmd,i,i,)

            #GEN EXTRA FUNC FOR THIN OF estemt, tstemt
            #USE IN UPPER STEM OF kho_khai, kho_kwai
            #***PREDEFINE: ds_estemt_thin
            if i in ['estemt','estemtc','tstemt','tstemtc']:
                #AUTO GENERATE delta string
                try:
                    exec "a = ds_%s_thin " % (i,)
                except:
                    #DEFAULT VALUE FOR 14,15,16 ppem
                    exec "ds_%s_thin = '14-2 15-2 16-2 '" % (i,)
                #GEN FUNC
                exec '''def %s_thin_%s(s,direction="%s"):
    return %s("%s",s,ds_%s_thin,direction)
''' % (i,j,direction,cmd,i,i,)


#EXAMPLE OF CVT FUNCTION DEFINED:
#
#def estemw_1(s): return """
#   MIRP[rnd,black]    estemw s
#   f_dstr(s,"ds_estemw")
#   """
#
#def estemw_2(s): return """
#   MIRP[rnd,black]    estemw s
#   f_dstr(s,"ds_estemw",direction="-")
#   """


#----------------------------------------
#DRY HEAD: KEEP HEAD OF CHARACTERS DRIED FOR 14,15,16 ppem
#ENABLE DRY HEAD FOR BOOK
ds_dryhead = "11+2 12+2 13+2 14+3 15+3 16+3 "
def dh1(*l): #dry head 
    d = {}
    for s in l:
        if s-1 < 0 or s+1 < 0:
            raise ValueError("ds value < 0: dh1(%s)" % (l,))
        d[s-1] = ds_dryhead
        d[s+1] = swap_dstr(ds_dryhead)
    return f_dstr_dict(d)
#    return f_dstr_dict({
#        s-1: "15+4 16+3 17+3 18+3 ",
#        s+1: "15-4 16-3 17-3 18-3 " })

def dh2(*l): #dry head
    d = {}
    for s in l:
        if s-1 < 0 or s+1 < 0:
            raise ValueError("ds value < 0: dh2(%s)" % (l,))
        d[s-1] = swap_dstr(ds_dryhead)
        d[s+1] = ds_dryhead
    return f_dstr_dict(d)
#    return f_dstr_dict({
#        s-1: "15-4 16-3 17-3 18-3 ",
#        s+1: "15+4 16+3 17+3 18+3 " })

def dh11(s): #dry 1 point +
    return f_dstr(s,ds_dryhead)

def dh12(s): #dry 1 point -
    return f_dstr(s,ds_dryhead,direction='-')

#DISABLE DRY HEAD FOR BOLD
#def dh1(*l):
#    return ""
#def dh2(*l):
#    return ""
#def dh11(s):
#    return ""
#def dh12(s):
#    return ""


ds_ud = "11+1 12+2 13+2 14+3 15+3 16+3 "
def ud1(s): #universal dry +
    return f_dstr(s,ds_ud)

def ud2(s): #universal dry -
    return f_dstr(s,ds_ud,direction='-')

ds_udx = "11+2 12+3 13+4 14+4 15+4 16+4 17+6 18+4 "
def udx1(s): #universal dry +
    return f_dstr(s,ds_udx)

def udx2(s): #universal dry -
    return f_dstr(s,ds_udx,direction='-')


#================================================
def evbc1(s,li=[]):
    return pl(""
        , mirp0rg("evbase_shoot",s)
        , f_ip(li)
        )

def tvbc(s,li=[]):  #thai vbase curve
    return pl(""
        , mirp0rg("tvbase_shoot",s)
        , f_ip(li)
        )

def tvblu(s,li=[]):
    return pl(""
        , mirprg("tvheight_lu",s)
        , f_ip(li)
        )

def tvblum(s,li=[]):
    return pl(""
        , mirp0rg("tvheight_lu",s)
        , f_ip(li)
        )

def tvtc2(s,li=[]): #thai vtop curve
    return pl(""
        , mirp0rg("tvheight_shoot",s,"")
        , f_ip(li)
        )

def tvt2(s,li=[]):
    return pl(""
        #, 'SROUND 74', mirprg("tvheight",s), 'RTG'
        , 'SROUND 74', mirprg("tvheight",s,"9-8 31+8"), 'RTG'
        , f_ip(li)
        )

def tvt2m(s,li=[]):
    return pl(""
        , mirp0rg("vheight",s,ds_vheight)
        , f_ip(li)
        )

def tvtpo(s,li=[]):
    return pl(""
        , mirprg("tvheight_po",s)
        , f_ip(li)
        )

def tvtpom(s,li=[]):
    return pl(""
        , mirp0rg("tvheight_po",s)
        , f_ip(li)
        )

def thbsara(s):
    return mdapr(s)

def tvtsara(s):
    return mdapr(s,"11+8 16+8 ")

def tvtwanayuk(s):
    #return mdapr(s,"14-8 15-8 16+8 17+8 18+8 ")
    return mdapr(s,"14-8 ")


def tvtn(s, li=[]):
    return pl(""
        , 'SROUND 73', mirp0rg("tvheight_num",s,"21+8 "), 'RTG'
        , f_ip(li)
        )

def tvtnc(s, li=[]):
    return pl(""
        , mirp0rg("tvheight_num_shoot",s)
        , f_ip(li)
        )
#==================================================

def head_0(s,li,direction="+",dia="headdia", dsh_extra=""):
    #round head
    s,add1 = gen_alignrp(s)
    i1,addi1 = gen_alignrp(li[0],2)
    i2,addi2 = gen_alignrp(li[1],2)
    l = li[2:]
    reverse_dir = direction.replace('+','*').replace('-','+').replace('*','-')
    if dia == "head_sara":
        ds_dia = ds_head_sara
        stem = "head_sara_stem"
        ds_stem = ds_head_sara_stem
    else:
        ds_dia = ds_headdia
        stem = "headstem"
        ds_stem = ds_headstem
    if l:
        addip = f_ip(l)
    else:
        addip = ""
    if dsh_extra:
        add1_extra = f_dstr(s,dsh_extra)
    else:
        add1_extra = ""
    return pl(""
        , 'SROUND 3'
        , mirpmrb(stem,i1,ds_stem,direction)
        , addi1
        , 'SROUND 69'
        , mirp0rg(dia,s,ds_dia,direction)
        , add1_extra
        , add1
        , addip
        , 'SROUND 3'
        , mirpmrb(stem,i2,ds_stem,reverse_dir)
        , addi2
        , 'RTG'
        )

def head1(s,li,dsh_extra=""):
    #left to right
    return head_0(s,li,direction="+",dsh_extra=dsh_extra)

def head2(s,li,dsh_extra=""):
    #right to left
    li = [li[1],li[0]] + li[2:]
    return head_0(s,li,direction="-",dsh_extra=dsh_extra)

def headsara1(s,li,dsh_extra=""):
    return head_0(s,li,direction="+",dia="head_sara",dsh_extra=dsh_extra)

def headsara2(s,li,dsh_extra=""):
    li = [li[1],li[0]] + li[2:]
    return head_0(s,li,direction="-",dia="head_sara",dsh_extra=dsh_extra)



def xhead0(s2,s3,direction="+"):
    s2,add2 = gen_alignrp(s2,2)
    s3,add3 = gen_alignrp(s3,2)
    return pl(""
        , 'SROUND 3'
        , headstem_1(s2,direction=direction)
        , add2
        , 'RTG'
        , headstemplushole_1(s3,direction=direction)
        , add3
        , 'RTG'
        )


def xhead1(s1,s2,s3,dstr="25+8 ",direction="+"):
    s1,add1 = gen_alignrp(s1)
    return pl(""
        , 'SROUND 72'
        , mdrp0mrg(s1,dstr)
        , 'RTG'
        , add1
        , xhead0(s2,s3,direction)
        )

def xhead2(s1,s2,s3,dstr="10+4 ",direction="-"):
    s1,add1 = gen_alignrp(s1)
    return pl(""
        , 'SROUND 72'
        , mdrp0rg(s1,dstr)
        , 'RTG'
        , add1
        , xhead0(s2,s3,direction)
        )

def xhead2s(s1,s2,s3,dstr="",direction="-"):
    return xhead2(s1,s2,s3,dstr=dstr,direction=direction)

#================================================
def v_notch_ko_kai(s1,s1s,s2):
    return pl(""
        , mdrp0rg(s1,"23+8 ")
        , alignrp(s1s)
        , stem_notch_1(s2)
        , dx(s2,-8)
        )

def v_head_kho_khai(s1,li1, s2, s3,s4, li4, add1=""):
    return pl(""
#        , tvtc2(s1,li1)
, tvtc2(s1,li1+[s4])
        , add1
        #, 'RTDG',tstemt_thin_2(s2),'RTG'
        , 'SROUND 4',tstemt_thin_2(s2),'RTG'
#        , mdrp0rg(s3,"10+8 14+8 15+8 16+8 ")
#        , head2(s4,li4)
, mdapr(s4)
, xhead0(li4[0],li4[1])
        )

def v_head_kho_khuat(s1,s1s,li1, s2,s2s, s3,s4, s5,s6,li6 , add1=""):
    return pl(""
#        , tvtc2(s1, li1)
, tvtc2(s1, li1+[s6])
        , alignrp(s1s)
        , add1
#        , tstemt_2(s2)
#        , shprp2(s2s)
, tstemt_2m(s2)
, alignrp(s2s)
#        , 'RUTG', mdrp0mrg(s3,"18-8 19-8 "), 'RTG'
        , 'RUTG', mdrp0mrg(s3), 'RTG'
        , mdrpb(s4)
#        , mdrp0rg(s5)
#        , mdapr(s5,"10+8 14+8 15+8 16+8 ")
#        , head2(s6,li6)
, mdapr(s6)
, xhead0(li6[0],li6[1])
        )

def v_top_kho_khwai(s1,li1,s2, s3,s4,li4,add1=""):
    if len(li4) > 3:
        add4 = f_dstr_dict({
            li4[2]:"14+2 15+2 16+2 ",
            li4[3]:"14-4 15-4 16-4 ",
            })
    else:
        add4 = ""
    return pl(""
        , tvtc2(s1,li1)
        , add1
        , tstemtc_thin_2(s2)
        , 'RUTG', mdrp0rw(s3), 'RTG'
        , head2(s4,li4)
        , add4
        )

def v_top_kho_khon(s1,s1s,li1, s2,s2s, s3,s4, s5,s6,li6):
    if len(li6) > 3:
        add6 = f_dstr_dict({
            li6[2]:"14+2 15+2 16+2 ",
            li6[3]:"14-4 15-4 16-4 ",
            })
    else:
        add6 = ""
    return pl(""
        , tvtc2(s1,li1)
        , alignrp(s1s)
        , tstemtc_2(s2)
        , shprp2(s2s)
        , 'RUTG'
        , mdrp0rg(s3)
        , 'RTG'
        , tstemt_2(s4)
        , mdrp0mrw(s5)
        , mdapr(s5)
        , head2(s6,li6)
        , add6
        )
        
def v_top_ro_rua(s1,li1, s2, s3,s4,s5,s6):
    return pl(""
        , tvtc2(s1,li1)
        , tstemtc_thin_2m(s2)
        , mdrp0g(s3)
        , tstemt_1(s4)
        , srp0(s1)
        , mdrp0g(s5)
        , tstemt_2(s6)
        )

def h_sara_i(r1,r2,r3,r4):
    return pl(""
        , thbsara(r1)
        , tstemtc_2(r2)
        , mdrp0rg(r4)
        , tstemtc_1(r3)
        )

def v_sara_i(s1,s2,li12,s3):
    return pl(""
        , tvtsara(s1)
        , mdrp0rg(s2)
        , f_ip(li12)
#        , sarastemt_1m(s3)
, mdrp0mrb(s3)
        , dx(s2,8)
        , iy()
        )

#================================================
#new point reference
#f0,r0,...: use tuple to align multiple points

def trs_no_nu(r1,r2, h1,h2,li, r0, dsr="10+8 11+8 12+8 ",rstem='tstemw'):
    #thai rear stem of no nu
    return pl(""
        , mdapr(r0)
        , mdrp0mrw(h2,dsr)
        , head2(h1,li)
        , f_dstr(h2,"9+4 10-4 11-4 12-4 13+4 ")
#1#        , mdrp0rg(r1,"11-8 12-8 17-8 18-8 19-8 ")
#2#        , 'SROUND 73',ip_round(h1,h2,r1),'RTG'
#3#, 'SROUND 71', mdrp0rg(r1), 'RTG'
#4#, ip_round(h1,h2,r2), ip_round(h1,r2,r1), srp0(r1)
#        , tstemw_1(r2)
#
#        , ip_round(li[0],li[1],r2)
, ip_round(li[0],h2,r2)
        , mirpmrb(rstem,r1)
        )

def trs_e(f1,f2, r1, r0):
    #sara e
    return pl(""
        , mdapr(r0)
        , mdrp0mrw(r1)
#        , mdrp0rg(f1,"12+8 13+8 ")
        , mdrp0rg(f1,"10-8 15+8 ")
        , tstemw_1(f2)
        )

#================================================
def tx2_0(f0, f1,f2, r1,r2, r0, fstem='tstemw',rstem='tstemw',fround=70,rround=70,dsf="",dsr=""):
    #thai x-direction walk for 2 stem: ko_kai,
    return uxrs2(f0, f1,fstem,f2, r1,rstem,r2, r0, fround=fround, rround=rround,dsf=dsf,dsr=dsr)

def tx2_0k(f0, f1,f2, r1,r2, r0, fstem='tstemw',rstem='tstemw',fround=72,rround=70,dsf="",dsr=""):
    return tx2_0(f0, f1,f2, r1,r2, r0, fstem,rstem,fround,rround,dsf,dsr)

def tx2_n(f0, f1,f2, r1,r2, r0, fstem='tstemwm',rstem='tstemwm',fround=70,rround=70,dsf="",dsr=""):
    return tx2_0(f0, f1,f2, r1,r2, r0, fstem,rstem,fround,rround,dsf,dsr)

def tx2_1(f0, f1,f2,f3, f4,f5, r1,r2, r0, dsf="9+8 "):
    #thai x-direction walk for 2 stem: tho_thahan,
    fx4,temp = gen_alignrp(f4)
    return pl(""
        , tx2_0(f0, f4,f5, r1,r2, r0, fround=70, dsf=dsf)
        , srp0(fx4)
        , xhead1(f1,f2,f3)
        )

def tx2_2(f0, f1,f2, f3,f4,f5, r1,r2, r0, fround=70):
    #thai x-direction walk for 2 stem: pho_phung
    fx1,temp = gen_alignrp(f1)
    return pl(""
        , tx2_0(f0, f1,f2, r1,r2, r0, fround=fround)
        , srp0(fx1)
        , xhead2(f3,f4,f5)
        )

def tx2_3(f0, f1,f2,li12, f3,f4, f5,f6, r1,r2, r0, dsh_extra="",i56=-1, dsf="10-8 "):
    #kho_khai
    fx0,temp = gen_alignrp(f0)
    f1,addf1 = gen_alignrp(f1)
    fx3,temp = gen_alignrp(f3)
    f5,addf5 = gen_alignrp(f5)
    f6,addf6 = gen_alignrp(f6,2)
    rx1,temp = gen_alignrp(r1)
    if i56 >= 0:
        addi56 = f_ip([i56])
    else:
        addi56 = ""
    return pl(""
        , tx2_0(f0, f3,f4, r1,r2, r0, rround=70, dsf=dsf)
        , ip_round(f0,f3, f1)
        , addf1
        , head1(f2,li12,dsh_extra=dsh_extra)
        , 'SROUND 10'
        , ip_round(fx3,rx1,f5)
        , addf5
        , 'RTG'
        , mdrpg(f6)
        , addi56
        , addf6
        , f_dstr(f5,"14+2 15+2 16+2 ")
        )


def tx1(r1,r2, r0, rstem='tstemw',rround=70):
    #thai x-direction walk for 1 stem
    return uxrs1(r1,rstem,r2, r0, rround=rround)

def tx1_0(f0, f1, r1,r2, r0, rstem='tstemw', rround=70):
    #thai x-direction walk for 1 stem: ngo_ngu
    f0,addf0 = gen_alignrp(f0)
    f1,addf1 = gen_alignrp(f1)
    rx1,temp = gen_alignrp(r1)
    return pl(""
        , tx1(r1,r2, r0, rstem=rstem, rround=rround)
        , ip_round(f0,rx1, f1)
        )

def tx1_1(f0, f1,f2, r1, r0, fstem='tstemw', fround=72, rround=70):
    return uxrs1f(f0,f1,fstem,f2,r1,r0,fround,rround)



def tx3_0(f0, f1,f2, m1,m2, r1,r2, r0, fstem='tstemwm',mstem='tstemwm',rstem='tstemwm',dsf="",dsm="",dsr="",fround=70):
    #thai x-direction walk for 3 stem: cho_choe
    return uxus3(f0, f1,fstem,f2, m1,mstem,m2, r1,rstem,r2, r0, dsf=dsf, dsm=dsm, dsr=dsr,fround=fround)

def tx3_n(f0, f1,f2, m1,m2, r1,r2, r0, fstem='tstemwm',mstem='tstemwm',rstem='tstemwm',dsf="",dsm="",dsr="",fround=70):
    #thai x-direction walk for 3 stem: cho_choe
    return uxrs3(f0, f1,fstem,f2, m1,mstem,m2, r1,rstem,r2, r0, dsf=dsf, dsm=dsm, dsr=dsr,fround=fround)

#================================================
def th_ko_kai(s0, s1,s2,s3, s4,s5,s6):
    return pl(""
        , add_ip(s0,s1,[s2])
        , srp0(s2)
        , mdrpg(s3)
        , srp0(s4)
        , mdrp0g(s5)
        , mdrpg(s6)
        )

def th_kho_khwai(s1, s2,s3,i23, s4,s5,li45, s6, mstem="tstemw",ds="10-4 15-8 "):
    return pl(""
        , srp0(s1)
        , mdrp0rg(s2)
        , mirpmrb(mstem,s3)
        , f_ip([i23])
#1#        , srp0(s6)
#1#        , mdrp0mrw(s5)
#1#        , head2(s5,li45)
#2#        , ip_round(s1,s6,s4)
#2#        , head1(s5,li45)
#3#        , srp0(s6)
#3#        , mdrpmrw(s5)
#3#        , ip_round(s1,s5,s4,"15-8 ")
#3#        , head1(s5,li45)
        , ip_round(s1,s6,s4,ds)
        , head1(s5,li45)
        )

#================================================
pseudo_code_dict = {

    'uni0E01':      #KO KAI
        packline(""
        , tx2_0(28, 15,13, 1,27, 29)
#        , th_ko_kai(15, 20,19, 8,9, s0=28)
, th_ko_kai(28, 15,20,8, 13,10,19)
        , add_ip(20,27,[5,24])
        , ix()
        #y
        , sy()
        , mdap(1)
        , alignrp(14)
        , tvtc2(24,[16,19,20,21,8,9,10,13, 2,27])
        , tstemt_2(5)
        , iy()
        ),

    'uni0E02':    #KHO KHAI
        packline(""
        , tx2_3(53, 21,15,[50,44,12], 1,32, 7,27, 36,38, 54)
        , ud2(12)
        , ix()
        , dh2(18)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(33)
        , tvt2(38)
        , v_head_kho_khai(24,[2,32,4,29], 10, 12,18,[41,47])
        , iy()
        , dh2(15,27)
        ),

    'uni0E03':    #KHO KHUAT
        packline(""
        , tx2_3(56, 24,18,[53,47,13], 1,35, 7,30, 39,41, 57, dsh_extra="")
        , add_ip(24,30, [26,27,28, 9,10,11])
        , ix()
        , dh1(15)
        , dh2(21)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(36)
        , tvt2(41)
        , v_head_kho_khuat(28,26,[2,35,4,32], 9,11, 10,27, 15,20,[44,50])
        , iy()
        , dh2(18,30)
        ),

    'uni0E04':    #KHO KHWAI
        packline(""
        , tx2_0k(54, 35,8, 1,41, 55)
        , th_kho_khwai(35, 29,27,11, 14,20,[51,45,25], 1)
        , add_ip(35,41,[38,5])
        , ix()
        , dh1(17)
        , dh2(23)
        #y
        , sy()
        , mdap(1)
        , alignrp(28)
        , v_top_kho_khwai(38,[35,8,11,2,41],5, 17,23,[42,48,25,14])
        , ud2(11)
        , iy()
        , dh2(20)
        ),

    'uni0E05':    #KHO KHON
        packline(""
        , tx2_0k(54, 35,8, 1,41, 55)
        , th_kho_khwai(35, 29,27,11, 14,20,[51,45,20], 1)
        , add_ip(35,41,[37,38,39,4,5,6])
        , ix()
        , dh1(17)
        , dh2(23)
        #y
        , sy()
        , mdap(1)
        , alignrp(28)
        , v_top_kho_khon(39,37,[35,8,11,2,41],4,6, 5,38, 17,23,[42,48,25,14])
        , ud2(11)
        , iy()
        , dh2(20)
        ),

    'uni0E06':    #KHO RAKHANG
        packline(""
        , tx2_3(78, 37,31,[63,57,26], 14,(48,3), 20,43, (51,1),53, 79, dsh_extra="",dsf="10-8 11-8 12-8 17-8 ")
        , add_ip(37,43,[39,40,41,22,23,24])
        , srp0(14)
        , xhead1(9,75,69)
        , ix()
        , dh1(28,12)
        , dh2(34,6)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(51)
        , tvt2(53)
        , v_head_kho_khuat(41,39,[15,48,17,45,20,43], 22,24, 23,40, 28,34,[54,60])
        , srp0(1)
        , tvbc(6)
        , head1(12,[66,72, 49,3])
        , ud1(3)
        , iy()
        , dh2(31,43)
        , dh1(9)
        ),

    'uni0E07':    #NGO NGU
        packline(""
        , tx2_0(38, 1,9, 11,23, 39, fstem='tstemwm')
        , ip_round(38,1,4)
        , srp0(11)
        , xhead1(17,35,29)
        , ix()
        , dh1(20)
        , dh2(14)
        #y
        , sy()
        , mdapr(1)
#        , tstemt_1(8)
, tstemwm_1(8)
        , tvtc2(20,[5])
        , head2(14,[26,32])
        , mdapr(5)
        , iy()
        , dh1(17)
        ),

    'uni0E08':    #CHO CHAN
        packline(""
        , tx2_0(48, 1,0, 20,33, 49)
        , ip_round(48,1,26)
        , ip_round(48,1,8)
        , srp0(8)
        , head1(14,[45,39,2])
        , add_ip(26,33,[30,23])
        , add_ip(1,0,[17])
        , ix()
        , dh1(11)
        , dh2(5)
        #y
        , sy()
        , mdap(1)
        , tstemtc_1(17)
        , tvtc2(30,[26,20,33])
        , tstemt_2(23)
        , mdapr(26)
        , mdrp0mrw(11)
        , head2(5,[36,42])
        , iy()
        , dh1(8)
        ),

    'uni0E09':    #CHO CHING
        packline(""
        , trs_no_nu(16,30, 40,34,[63,57], 67,dsr="10+8 11+8 12+8 17+8 ")
        , iprs_front_stem(66, 1,'tstemw',(13,0), 30, dsf="15+8 16+8 ")
        , xhead1(7,51,45)
        , ip_round(66,1,23)
        , add_ip(23,30,[27,20])
        , ix()
        , dh1(10)
        , dh2(4,37)
        #y
        , sy()
        , mdap(0)
        , tstemt_1(14)
        , tvtc2(27,[17,30,23])
        , tstemt_2(20)
        , mdapr(23)
        , mdrp0mrw(10)
        , head2(4,[42,48])
        , srp0(0)
        , tvbc(37)
        , head1(16,[54,60,40,31])
        , iy()
        , dh1(7)
        , dh2(34)
        ),

    'uni0E0A':    #CHO CHANG
        packline(""
        , tx2_3(66, 21,15,[63,57,12], 1,32, 7,27, 36,51, 67)
        , add_ip(27,37,[40])
        , srp0(40)
        , mdrpg(48)
        , srp0(36)
        , mdrp0rg(44)
        , tstemw_1(45)
        , ud2(12)
        , ud2(48)
        , ix()
        , dh2(18)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(33)
        , v_head_kho_khai(24,[2,32,7,27,41,40,48,37,51], 10, 12,18,[54,60],
            add1=mdrpmrg(44))
        , iy()
        , dh2(15,27,7)
        ),

    'uni0E0B':    #SO SO
        packline(""
        , tx2_3(69, 24,18,[66,60,13], 1,35, 7,30, 39,54, 70, dsh_extra="")
        , add_ip(24,30, [26,27,28,9,10,11])
        , add_ip(30,39,[43])
        , srp0(43)
        , mdrpg(51)
        , srp0(39)
        , mdrp0mrg(47)
        , tstemw_1(48)
        , dx(51,-8)
        , ix()
        , dh1(15)
        , dh2(21)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(36)
        , v_head_kho_khuat(28,26,[2,35,7,30,44,43,51,40,54], 9,11, 10,27, 15,21,[57,63],
            add1=mdrpmrg(47))
        , iy()
        , dh2(18,30,7)
        ),

    'uni0E0C':    #CHO_CHOE
        packline(""
        , tx3_0(81, 39,27, 15,51, 54,56, 82)
        , srp0(54), mdrpg(1)
        , f_dstr_dict({27:ds_tstemwm, 51:ds_tstemwm+"13-4 14-4 15-4 ", 56:ds_tstemwm})
        , srp0(39)
        , xhead2s(33,60,66)
        , srp0(15)
        , mdrp0rg(11,"11-4 ")
        , head1(3,[78,72])
        , th_ko_kai(81, 39,44,22, 27,24,43)
        #
        , add_ip(44,51,[48,19])
        , ix()
        , dh1(30)
        , dh2(36,8)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(54)
        , tvt2(56)
        , tvtc2(48,[40,43,44,45,22,23,27,27,16,51])
        , tstemt_2(19)
        , srp0(1)
        , tvbc(36)
        , alignrp(8)
        , head1((30,15),[(57,69),(63,75),52,3])
#        , f_dstr(3,"14+3 15+3 16+3 ")
        , iy()
        , dh1(11)
        , dh2(33)
        ),

    'uni0E0D.descless':    #YO YING
        packline(""
        , tx3_0(58, 25,13, 1,37, 41,43, 59, fstem="tstemwm",mstem="tstemwm",rstem="tstemwm")
        , f_dstr_dict({13:ds_tstemwm, 37:ds_tstemwm+"13-4 14-4 15-4 ", 43:ds_tstemwm})
        , srp0(25)
        , xhead2(19,49,55)
        , th_ko_kai(58, 25,30,8, 13,10,29)
        #
        , add_ip(30,37,[34,5])
        , ix()
        , dh1(16)
        , dh2(22)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(38)
        , tvt2(43)
        , tvtc2(34,[26,29,30,31,8,9,10,13, 2,37])
        , tstemt_2(5)
        , srp0(1)
        , tvbc(22)
        , head1(16,[46,52])
        , iy()
        , dh2(19)
        ),

    'desc.uni0E0D':
        packline(""
        , thbsara(18)
        , mdrp0rg(6)
        , mdrprg(12)
        , f_ip([30,24])
        , ix()
        #y
        , sy()
        , mdap(33)
        , mdrp0mrw(9)
        , mdrprg(17)
        , mdrp0rg(3)
        , f_ip([27,21])
        , mdrp0rg(0)
        , mdrpmrb(14)
        , iy()
        ),

    'uni0E0E':    #DO CHADA
        packline(""
        , tx2_1(77, 37,64,58, 42,30, (18,1),54, 78)
        , f_dstr_dict({30:"10-4 ",54:"10-4 "})
        , th_ko_kai(77, 42,47,25, 30,27,46)
        , srp0(1)
        , mdrprg(69)
        , f_ip([13,16,3])
        , mdrp0rg(8)
        , mdrpmrg(74)
        , add_ip(47,54,[51,22])
        , dx(69,8)
        , dx(16,-8)
        , ix()
        , dh1(40,11)
        , dh2(34,5)
        #y
        , sy()
        , mdap(77)
        , tvtc2(51,[43,46,47,48,25,26,27,30, 19,54])
        , tstemt_2(22)
        , srp0(77)
        , tvbc(34)
        , head1(40,[55,61])
        , srp0(77)
        , tvblum(5)
        , alignrp(1)
        , head1(11,[67,71, 13,69,3,16,18])
#
        , dx(3,8)
        , dx(13,-8)
        , iy()
        , dh1(37,8)
        ),

    'uni0E0F':    #TO PATAK
        packline(""
        , tx2_1(83, 43,70,64, 48,36, (24,1),60, 84)
        , f_dstr_dict({36:"10-4 ",60:"10-4 "})
        , th_ko_kai(83, 48,53,31, 36,33,52)
        , srp0(24)
        , mdrprg(75)
        , f_ip([16,19,21,2,6])
        , mdrp0rg(11)
        , mdrpmrg(80)
        , add_ip(53,60,[57,28])
        , dx(75,8)
        , dx(19,-8)
        , ix()
        , dh1(46,14)
        , dh2(40,8)
        #y
        , sy()
        , mdap(83)
        , tvtc2(57,[49,52,53,54, 31,32,33,36, 25,60])
        , tstemt_2(28)
        , srp0(83)
        , tvbc(40)
        , head1(46,[61,67])
        , srp0(83)
        , tvblum(8)
        , alignrp(4)
        , alignrp(1)
        , head1(14,[73,77, 16,19,75,6,21,22,2])
#
        , dx(6,8)
        , dx(16,-8)
        , iy()
        , dh1(43,11)
        ),

    'uni0E10.descless':    #THO THAN
        packline(""
        , tx2_0(63, 23,45, 20,48, 64)
        , ip_round(13,48,8)
        , srp0(8)
        , head1(14,[60,54,2])
        , ip_round(8,48,1)
        , srp0(1)
        , tstemw_1(0)
        , f_ip([17])
        , srp0(48)
        , mdrprw(35)
        , add_ip(23,35,[27,42])
        , ud2(45)
        , ix()
        , dh1(11)
        , dh2(5)
        #y
        , sy()
        , mdapr(1)
        , tstemtc_1(17)
        , v_top_ro_rua(27,[23,24,45,46,20,48], 42, 37,32,34,35)
        , srp0(46)
        , tstemt_2(22)
        , ip_round(22,1,11)
        , srp0(11)
        , head2(5,[51,57])
        , srp0(1)
        , iy()
        , dh1(8)
        ),

    'desc.uni0E10':
        packline(""
        , thbsara(39)
        , mdrpmrb(27)
        , mdrprg(33)
        , f_ip([49,43])
        , mdrp0rg(21)
        , f_ip([23,25,1,5,6])
        , mdrprg(13)
        , f_ip([59,54,18,8])
        , ix()
        #y
        , sy()
        , mdap(62)
        , mdrp0mrw(36)
        , mdrp0rg(30)
        , f_ip([40,46])
        , mdrp0rg(1)
        , alignrp(5)
        , alignrp(10)
        , mdrpmrb(27)
        , shprp2(23)
        , mdrprg(16)
        , f_ip([52,56])
        , iy()
        ),

    'uni0E11':    #THO NANGMONTHO
        packline(""
        , tx2_3(58, 35,29,[55,49,24], 12,11, 18,8, 1,45, 59, i56=41, dsh_extra="")
        , add_ip(35,8, [37,38,39, 20,21,22])
        , ix()
        , dh1(24)
        , dh2(32)
        #y
        , sy()
        , mdap(1)
        , alignrp(11)
        , v_head_kho_khuat(39,37,[13,10,18,8,41,6,2,50], 20,22, 21,38, 23,32,[46,52], add1=pl( alignrp(43), tstemt_2(4)))
        , ud2(41)
        , iy()
        , dh2(29)
        ),

    'uni0E12':    #THO PHUTHAO
        packline(""
        , tx3_0(80, 44,19, 12,50, 53,55, 81, fstem="tstemt", dsr="12+8 ")
        , f_dstr_dict({50:ds_tstemwm+"13-4 14-4 15-4 16-4 17-4 ", 55:ds_tstemwm})
        , srp0(53)
        , mdrpg(1)
        , th_kho_khwai(44, 38,37,22, 27,33,[65,59,24], 12, mstem="tstemwm",ds="10-4 ")
        , ip_round(12,47,71)
        , srp0(71)
        , mirp0rg('headstem',3)
        , head2(9,[77,71])
        , add_ip(44,50,[46,47,48,15,16,17])
        , ud1(24)
        , ix()
        , dh11(25)
        , dh1(30)
        , dh2(6)
        #y
        , sy()
        , mdap(1)
        , alignrp(37)
        , tstemt_1(22)
        , shprp2(53)
        , tvt2(55)
        , v_top_kho_khon(48,46,[44,19,13,50], 15,17, 16,47, 30,24,[56,62])
        , srp0(1)
        , tvbc(6)
        , head1(12,[68,74,51,3])
        , ud1(3)
        , iy()
        , dh1(27,9)
        , dh2(33)
        ),

    'uni0E13':    #NO NEN
        packline(""
        , trs_no_nu(40,42, 52,46,[75,69], 79, dsr="10+8 11+8 12+8 14+8 ", rstem='tstemwm')
        , iprs_front_stem(78, 25,'tstemwm',13, 40)
        , xhead2(19,57,63)
        , th_ko_kai(78, 25,30,8, 13,10,29)
        , iprs_middle_stem(25, 1,'tstemwm',37, 40)
        , f_dstr_dict({13:ds_tstemwm, 37:ds_tstemwm+"13-4 14-4 15-4 ", 42:ds_tstemwm})
        , add_ip(30,37,[34,5])
        , srp0(37)
        , mdrpg(0)
        , ix()
        , dh1(16)
        , dh2(22,49)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(38)
        , tvt2(42)
        , tvtc2(34,[26,29,30,31, 8,9,10,13, 2,37])
        , tstemt_2(5)
        , srp0(1)
        , tvbc(22)
        , alignrp(49)
        , head1((16,43),[(54,66),(60,72),40,52])
        , ud1(52)
        , iy()
        , dh2(19,46)
        ),

    'uni0E14':    #DO DEK
        packline(""
        , tx2_0k(52, 33,8, 1,39, 53)
        , th_kho_khwai(33, 27,26,11, 16,22,[49,43,13], 1)
        , add_ip(33,39,[36,5])
        , ix()
        , ud1(13)
        , dh11(14)
        , dh1(19)
        #y
        , sy()
        , mdap(1)
        , alignrp(26)
        , tstemt_1(11)
        , v_top_kho_khwai(36,[33,8,2,39],5,19,13,[40,46])
        , iy()
        , dh1(16)
        , dh2(22)
        ),

    'uni0E15':    #TO TAO
        packline(""
        , tx2_0k(52, 33,8, 1,39, 53)
        , th_kho_khwai(33, 27,26,11, 16,22,[49,43,13], 1)
        , add_ip(33,39,[35,36,37,4,5,6])
        , ud1(13)
        , ix()
        , dh11(14)
        , dh1(19)
        #y
        , sy()
        , mdap(1)
        , alignrp(26)
        , tstemt_1(11)
        , v_top_kho_khon(37,35,[33,8,2,39], 4,6, 5,36, 19,13,[40,46])
        , iy()
        , dh1(16)
        , dh2(22)
        ),

    'uni0E16':      #THO THUNG
        packline(""
        , tx2_2(50, 25,13, 19,41,47, 1,37, 51)
        , th_ko_kai(50, 25,30,8, 13,10,29)
        , ix()
        , dh1(16)
        , dh2(22)
        #y
        , sy()
        , mdap(1)
        , tvtc2(34,[26,29,30,31,8,9,10,13, 2,37])
        , tstemt_2(5)
        , srp0(1)
        , tvbc(22)
        , head1(16,[38,44])
        , iy()
        , dh2(19)
        ),

    'uni0E17':      #THO THAHAN
        packline(""
        , tx2_1(41, 15,38,32, 9,(21,8), 1,28, 42)
        , f_dstr_dict({21:"10-4 ", 8:"10-4 "})
        , add_ip(21,1,[6])
        , srp0(6)
        , mdrpg(24) 
        , ix()
        , dh1(18)
        , dh2(12)
        #y
        , sy()
        , mdap(1)
        , alignrp(8)
        , tvtc2(18,[22,24,8,2,28])
        , alignrp(26)
        , tstemt_2(4)
        , head2(12,[29,35])
#        , ud2(22)
#, f_dstr(22,"12-6 13-6 14-8 15-8 16-8 ")
        , iy()
        , dh1(15)
        ),

    'uni0E18':      #THO THONG
        packline(""
        , tx2_0(39, 1,3, 7,36, 40, dsf="10-8 ")
        , 'RTDG'
        , ip_round(39,1,11)
        , tstemtc_1(33)
        , 'RTG'
        , srp0(40)
        , mdrpmrw(23)
        , add_ip(11,23,[15,30,20,25])
        , ud2(33)
        , ix()
        #y
        , sy()
        , mdap(1)
        , tstemt_1(4)
        , v_top_ro_rua(15,[2,11,12,33,34,8,36], 30, 25,20, 22,23)
        , srp0(34)
        , tstemt_2(10)
        , iy()
        ),

    'uni0E19':      #NO NU
        packline(""
        , trs_no_nu(16,18, 28,22,[51,45], 55)
        , iprs_front_stem(54, 1,'tstemw',(13,0), 16, dsf="15+8 17+8 ")
        , f_dstr_dict({13:"10-4 17-4 ", 0:"10-4 17-4 ", 16:"17+8 ", 18:"10-4 17+4 "})
        , xhead1(7,39,33)
        , ix()
        , dh1(10)
        , dh2(25,4)
        #y
        , sy()
        , mdap(0)
        , tstemt_1(14)
        , tvt2(18)
        , tvtc2(10)
        , head2(4,[30,36])
        , srp0(0)
        , tvbc(25)
        , head1(19,[42,48,28,16])
#        , f_dstr(28,"14+4 15+4 16+4 ")
,ud1(28)
        , iy()
        , dh1(7)
        , dh2(22)
        ),  

    'uni0E1A':      #BO BAIMAI
        packline(""
        , tx2_1(34, 7,31,25, 1,13, 17,19, 35)
        , f_dstr_dict({13:"10-4 ", 19:"10-4 "})
        , ix()
        , dh1(10)
        , dh2(4)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(14)
        , tvt2(19)
        , tvtc2(10)
        , head2(4,[22,28])
        , iy()
        , dh1(7)
        ),

    'uni0E1B':      #PO PLA
        packline(""
        , tx2_1(34, 7,31,25, 1,13, 17,19, 35)
        , f_dstr_dict({13:"10-4 ", 19:"10-4 "})
        , ix()
        , dh1(10)
        , dh2(4)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(14)
        , tvtpo(19)
        , tvtc2(10)
        , head2(4,[22,28])
        , iy()
        , dh1(7)
        ),

    'uni0E1C':      #PHO PHUNG
        packline(""
        , tx2_2(35, 4,16, 11,26,32, 20,22, 36)
        , add_ip(16,20,[3,2,1])
        , srp0(2)
        , mdrpg(18)
        , mdrpg(19)
        , ix()
        , dh1(8)
        , dh2(14)
        #y  
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvt2(22)
        , tvtc2(8,[17])
        , head2(14,[23,29])
        , add_ip(14,1,[18,2])
        , ud1(2)
        , ud2(17)
        , srp0(17)
        , alignrp(20)
        , iy()
        , dh2(11)
        ),  

    'uni0E1D':      #FO FA
        packline(""
        , tx2_2(35, 4,16, 11,26,32, 20,22, 36)
        , add_ip(16,20,[3,2,1])
        , srp0(2)
        , mdrpg(18)
        , mdrpg(19)
        , ix()
        , dh1(8)
        , dh2(14)
        #y  
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvtpo(22)
        , tvtc2(8,[17])
        , head2(14,[23,29])
        , add_ip(14,1,[18,2])
        , ud1(2)
        , ud2(17)
        , srp0(17)
        , alignrp(20)
        , iy()
        , dh2(11)
        ),  

    'uni0E1E':      #PHO PHAN
        packline(""
        , tx2_1(35, 10,32,26, 4,(16,3), (20,1),22, 36)
        , f_dstr_dict({16:"10-4 ", 3:"10-4 ", 20:"10+4 ", 1:"10+4 "})
        , add_ip(16,20,[2])
        , srp0(2)
        , mdrpg(18)
        , mdrpg(19)
        , ix()
        , dh1(13)
        , dh2(7)
        #y
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvt2(22)
        , tvtc2(13,[2,17,18,19])
        , head2(7,[23,29])
        , ud1(2)
        , ud2(17)
        , srp0(17)
        , alignrp(20)
        , iy()
        , dh1(10)
        ),

    'uni0E1F':      #FO FAN
        packline(""
        , tx2_1(35, 10,32,26, 4,(16,3), (20,1),22, 36)
        , f_dstr_dict({16:"10-4 ", 3:"10-4 ", 20:"10+4 ", 1:"10+4 "})
        , add_ip(16,20,[2])
        , srp0(2)
        , mdrpg(18)
        , mdrpg(19)
        , ix()
        , dh1(13)
        , dh2(7)
        #y
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvtpo(22)
        , tvtc2(13,[2,17,18,19])
        , head2(7,[23,29])
        , ud1(2)
        , ud2(17)
        , srp0(17)
        , alignrp(20)
        , iy()
        , dh1(10)
        ),

    'uni0E20':    #PHO SAMPHAO
        packline(""
        , tx2_1(50, 20,47,41, 25,13, 1,37, 51)
        , f_dstr_dict({13:"10-4 ", 37:"10-4 "})
        , th_ko_kai(50, 25,30,8, 13,10,29)
        , add_ip(30,37,[34,5])
        , ix()
        , dh1(23)
        , dh2(17)
        #y
        , sy()
        , mdap(1)
        , tvtc2(34,[26,29,30,31,8,9,10,13,2,37])
        , tstemt_2(5)
        , srp0(1)
        , tvbc(17)
        , head1(23,[38,44])
        , iy()
        , dh1(20)
        ),

    'uni0E21':      #MO MA
        packline(""
        , tx2_1(56, (20,9),(41,53),(35,47), 14,(26,3), (29,1),31, 57)
        , f_dstr_dict({26:"10-4 ", 3:"10-4 ", 31:"10-4 "})
        , ix()
        , dh1(23,12)
        , dh2(17,6)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(29)
        , tvt2(31)
        , tvtc2(23)
        , head2(17,[32,38])
        , srp0(1)
        , tvbc(6)
        , head1(12,[44,50,27,3])
        , ud1(3)
        , iy()
        , dh1(20,9)
        ),
    
    'uni0E22':    #YO YAK
        packline(""
        , tx2_0(51, 3,28, 34,36, 52)
        , srp0(3)
        , mdrprg(25)
        , f_ip([7])
        , mdrp0rg(10)
        , tstemw_1(21)
        , ip_round(28,34,16)
        , xhead0(42,48,direction='-')
        , f_dstr_dict({21:"10-4 ", 25:"10+4 ", 28:"10-4 "})
        , ix()
        , dh1(13)
        , dh2(19)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(31)
        , tvt2(36)
        , tvtc2(13)
        , head2(19,[39,45,21])
        , ip_round(19,31,24)
        , tstemt_2(25)
        , f_ip([7])
        , iy()
        , dh2(16)
        ),

    'uni0E23':    #RO RUA
        packline(""
        , tx2_0(53, 12,34, 8,37, 54, fstem='tstemtc',rround=73)
        , srp0(8)
        , xhead1(3,50,44)
        , srp0(54)
        , mdrpmrw(24)
        , add_ip(12,24,[16,31,26,21])
        , ud2(34)
        , ix() 
        , dh1(6)
        , dh11(1), dh12(40)
        #y
        , sy() 
        , mdap(53)
        , v_top_ro_rua(16,[12,13,34,35,9,37], 31, 26,21, 23,24)
        , srp0(35)
        , tstemt_2(11)
        , srp0(53)
        , tvbc(0)
        , head1(6,[41,47])
        , iy()
        , dh1(3)
        ),  

    'uni0E24':      #RU
        packline(""
        , tx2_2(50, 25,13, 19,41,47, 1,37, 51)
        , th_ko_kai(50, 25,30,8, 13,10,29)
        , add_ip(30,37,[34,5])
        , ix()
        #y
        , sy()
        , mdap(50)
        , tvtc2(34,[26,29,30,31, 8,9,10,13, 2,37])
        , tstemt_2(5)
        , srp0(50)
        , tvbc(22)
        , head1(16,[38,44])
        , srp0(50)
        , tvblu(1)
        , iy()
        , dh2(19)
        ),

    'uni0E25':      #LO LING
        packline(""
        , tx2_2(53, 19,7, 13,44,50, (1,26),40, 54)
        , add_ip(53,19,[33])
        , add_ip(19,26,[23,5])
        , add_ip(33,40,[37,30])
        , ix()
        , dh1(10)
        , dh2(16)
        #y
        , sy()
        , mdap(1)
        , tvtc2(37,[20,7,27,40,26,23,33])
        , tstemt_2(30)
        , mdapr(33)
        , mdapr(23,"9-8 ")
        , tstemt_2(4)
        , srp0(1)
        , tvbc(16)
        , head1(10,[41,47])
        , ud2(26)
        , iy()
        , dh2(13)
        ),

    'uni0E26':    #LU
        packline(""
        , tx2_1(50, 20,47,41, 25,13, 1,37, 51)
        , f_dstr_dict({13:"10-4 ", 37:"10-4 "})
        , th_ko_kai(50, 25,30,8, 13,10,29)
        , add_ip(30,37,[34,5])
        , ix()
        , dh1(23)
        , dh2(17)
        #y
        , sy()
        , mdap(50)
        , tvtc2(34,[26,29,30,31, 8,9,10,13, 2,37])
        , tstemt_2(5)
        , srp0(50)
        , tvbc(17)
        , head1(23,[38,44])
        , srp0(50)
        , tvblu(1)
        , iy()
        , dh1(20)
        ),

    'uni0E27':    #WO WAEN
        packline(""
        , tx1_0(38, 15, 8,22, 39)
        , srp0(8)
        , xhead1(3,35,29)
        , add_ip(15,22,[19,12])
        , ix()
        , dh1(6)
        , dh11(1), dh12(25)
        #y
        , sy()
        , mdap(38)
        , tvtc2(19,[9,22,15])
        , tstemt_2(12)
        , mdapr(15)
        , srp0(38)
        , tvbc(0)
        , head1(6,[26,32])
        , iy()
        , dh1(3)
        ),  

    'uni0E28':    #SO SALA
        packline(""
        , tx2_0k(66, 41,14, 1,53, 67)
        , th_kho_khwai(41, 35,33,17, 20,26,[63,57,31], 1)
        , add_ip(41,53,[44,11,9,46,51,4])
        , dx(9,8)
        , dx(51,-8)
        , ix()
        , dh1(23)
        , dh2(29)
        #y
        , sy()
        , mdap(1)
        , alignrp(34)
        , v_top_kho_khwai(44,[41,14,2,48,9,46,51,4,17], 11, 23,29,[54,60,31,20],add1=mdrpmrg(48))
        , dx(31,8)
        , dx(17,-16)
        , dx(4,8)
        , dx(46,-8)
        , iy()
        , dh2(26)
        , f_dstr_dict({46:"14-4 15-4 16-4 ", 4:"14+4 15+4 16+4 "})
        ),

    'uni0E29':      #SO RUSI
        packline(""
        , tx2_1(65, 7,50,44, 1,(13,39), (23,34),(25,29), 66)
        , f_dstr_dict({13:"10-4 ", 39:"10-4 ", 25:"10-4 ", 29:"10-4 "})
        , srp0(23)
        , mdrp0mrw(20)
        , add_ip(39,20,[62,56])
        , ix()
        , dh1(10,17)
        , dh2(4,37)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(40)
        , tvt2(25)
        , tvtc2(10,[17])
        , head2(4,[41,47])
        , mdapr(17)
        , mdrp0rg(37)
        , f_ip([53,59,39,14,35,23,29,26])
        , dx(35,8)
        , dx(26,-8)
        , dx(35,8)
        , iy()
        , dh1(7)
        , dh2(20)
        ),

    'uni0E2A':      #SO SUA
        packline(""
        , tx2_2(65, 19,7, 13,56,62, (26,1),52, 66)
        , add_ip(65,19,[39])
        , add_ip(19,26,[23,4])
        , add_ip(39,52,[43,36,34,45,50,29])
        , dx(34,8)
        , dx(50,-8)
        , ix()
        , dh1(10)
        , dh2(16)
        #y
        , sy()
        , mdap(1)
        , tvtc2(43,[20,7,27,52,45,34,50,29,26,39,23])
        , mdrpmrg(47)
        , tstemt_2(36)
        , mdapr(39)
        , mdapr(23,"9-8 ")
        , tstemt_2(4)
        , srp0(1)
        , tvbc(16)
        , head1(10,[53,59])
        , dx(29,8)
        , dx(45,-8)
        , ud2(26)
        , iy()
        , dh2(13)
        , f_dstr_dict({45:"14-4 15-4 16-4 ", 29:"14+4 15+4 16+4 "})
        ),

    'uni0E2B':      #HO HIP
        packline(""
        , tx2_1(63, 15,48,42, 9,(21,8), 1,38, 64)
        , f_dstr_dict({21:"10-4 ", 8:"10-4 "})
        , add_ip(21,1,[6])
        , srp0(6)
        , mdrpg(24) 
        , srp0(38)
        , mdrp0rg(34)
#FOR UNROUNDED STEM
#        , 'SROUND 70', mdapr(34), 'RTG'
        , head2(28,[60,54,26,36,4])
        , f_dstr_dict({28:"9-4 ",34:"9+2 "})
        , dx(26,8)
        , dx(36,-8)
        , ix()
        , dh1(18,31)
        , dh2(12)
        #y
        , sy()
        , mdap(1)
        , alignrp(8)
        , tvtc2(18,[22,24,6,2,38])
        , alignrp(31)
        , head2(12,[(39,51),(45,57)])
        , srp0(51)
        , tstemt_2(4)
        , f_ip([26,36])
#        , ud2(22)
        , iy()
        , dh1(15,28)
        , dh2(34)
        ),

    'uni0E2C':      #LO CHULA
        packline(""
        , tx2_1(60, 10,45,39, 4,(16,3), (20,1),(35,32), 61)
        , f_dstr_dict({16:"10-4 ", 3:"10-4 ", 20:"10+4 ", 1:"10+4 "})
        , srp0(20)
        , xhead1(26,57,51)
        , add_ip(16,20,[2])
        , srp0(2)
        , mdrpg(18)
        , mdrpg(19)
        , ix()
        , dh1(13,29)
        , dh2(7,23)
        #y
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvtc2(13,[17])
        , head2(7,[36,42])
        , srp0(13)
        , mdrp0mrg(29)
        , head2(23,[48,54,35,32])
        , add_ip(23,1,[18,2])
        , ud1(2)
        , ud2(17)
        , srp0(17)
        , alignrp(20)
        , iy()
        , dh1(10,26)
        ),

    'uni0E2D':      #O ANG
        packline(""
        , tx2_2(50, 3,15, 10,41,47, 21,35, 51)
        , ip_round(50,3,28)
        , add_ip(28,35,[32,25])
        , ix()
        , dh1(7)
        , dh2(13)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(18)
        , tvtc2(32,[22,35,28])
        , tstemt_2(25)
        , mdapr(28)
        , mdrp0mrw(7)
        , head2(13,[38,44])
        , iy()
        , dh2(10)
        ),  

    'uni0E2E':      #HO NOKHUK
        packline(""
        , tx2_2(64, 3,15, 10,45,51, 21,39, 65)
        , srp0(1)
        , mdrp0rg(29)
        , tstemw_1(61)
        , add_ip(29,39,[32,38,54,26, 34,37,24,56])
        , ud1(56)
        , ud2(37)
        , ix()
        , dh1(7)
        , dh2(13)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(18)
        , tvtc2(32,[22,39])
#        , tstemt_2(58)
,mdrpmrb(58)
        , mdrp0rg(26)
        , f_ip([34,37,24,56])
#        , sarastemt_1(54)
,mdrpmrb(54,"18-8 19-8 ")
        , mdrp0mrw(7)
        , head2(13,[42,48])
        , dx(24,8)
        , dx(34,-8)
        , iy()
        , dh2(10)
        ),

    'uni0E2F':      #PAIYAN NOI
        packline(""
        , tx1_0(39, 11, (1,25),26, 40)
        , head1(17,[36,30,20])
        , ix()  
        , dh1(14)
        #y  
        , sy()
        , mdap(1)
        , tvt2(25)
        , tvtc2(14,[2])
        , head2(8,[27,33,20])
        , mdrp0rg(5)
        , tstemt_1(22)
        , ud1(2)
        , iy()
        , dh2(17)
        ),  

    'uni0E30':      #SARA A
        packline(""
        , srp0(66)
        , 'SROUND 71' , mdrp0rw(6) , 'RTG'
        , alignrp(39)
        , head1((12,45),[(30,63),(24,57),14,47])
        , mdapr(67)
        , mdrp0mrw(18)
        , alignrp(51)
        , ud1(3)
        , srp0(3)
        , alignrp(36)
        , ud1(15)
        , srp0(15)
        , alignrp(48)
        , ix()
        , dh1(42,9)
        #y  
        , sy()
        , mdapr(0)
        , tstemt_1(14)
        , mdrp0rg(3,"9+8 15-8 16-8 ")
        , head1(9,[21,27])
        , mdrprg(17)
        #
        , mdapr(33)
        , tstemt_1(47)
        , mdrp0rg(36,"9+8 15-8 16-8 ")
        , head1(42,[54,60])
        , mdrprg(50)
        , dx(3,8)
        , dx(36,8)
        , dx(0,8)
        , dx(33,8)
        , iy()
        , dh1(6,39)
        , dh2(12,45)
        ),

    'uni0E31':      #MAI HAN-AKAT
        packline(""
        , mdapr(12)
        , mdrprg(18)
        , head2(6,[30,24])
        , ud1(3)
        , ud1(15)
        , ix()
        , dh1(9)
        #y  
        , sy()
        , tvtsara(0)
        , tstemt_1(14)
        , mdrp0rg(3,"9+8 15-8 16-8 ")
        , head1(9,[21,27])
        , mdrprg(17)
        , iy()
        , dh1(6)
        , dh2(12)
        ),

    'uni0E32':    #SARA AA
        packline(""
        , tx1_0(16, 8, 1,15, 17)
        , add_ip(8,15,[12,5])
        , ix()
        #y
        , sy()
        , mdap(1)
        , tvtc2(12,[8,2,15])
        , tstemt_2(5)
        , mdapr(8)
        , iy()
        ),  

    'uni0E34':    #SARA I
        packline(""
        , h_sara_i(0,11,17,3)
        , ix()
        #y
        , sy()
        , v_sara_i(0,14,[17,4,3,10,11], 7)
        , iy()
        ),
    
    'uni0E35':    #SARA II
        packline(""
        , h_sara_i(0,15,21,3)
        , srp0(0)
        , alignrp(12)
        , tstemtc_2(10)
        , ix()
        #y
        , sy()
        , v_sara_i(0,18,[21,4,3,15,13],7)
        , f_ip([9])
        , mdrpmrg(11)
        , ud2(9)
        , iy()
        ),
    
    'uni0E36':    #SARA UE
        packline(""
        , h_sara_i(0,21,27,3)
        , srp0(0)
        , mdrp0mrg(15)
        , head2(9,[39,33,18])
        , ix()
        #y
        , sy()
        , v_sara_i(0,24,[27,4,3,21,20],7)
        , mdrp0mrg(12)
        , head2(18,[30,36,9])
        , iy()
        ),

    'uni0E37':    #SARA UUE
        packline(""
        , h_sara_i(0,19,25,3)
        , srp0(0)
        , alignrp(17)
        , tstemtc_2m(15)
        , mdrp0mrg(12)
        , tstemtc_2(10)
        , dx(17,-8)
        , dx(12,-8)
        , ix()
        #y  
        , sy()   
        , v_sara_i(0,22,[25,4,3,19,17],7)
        , f_ip([9,12,14])
        , mdrp0mrg(11)
        , alignrp(16)
        , ud2(14)
        , iy()
        ),  

    'uni0E38':    #SARA U
        packline(""
        , thbsara(13)
        , mdrpmrb(1)
        , mdrpmrg(7)
        , f_ip([23,17])
        , ix()
        #y  
        , sy()
        , mdap(26) 
        , mdrp0mrw(10)
        , mdrp0rg(4)
        , f_ip([14,20])
        , mdrpmrg(1)
        , iy()
        ),  

    'uni0E39':    #SARA UU
        packline(""
        , thbsara(17)
        , mdrp0mrb(15)
        , mdrp0mrw(13)
#URS        , mdapr(13)
        , mdrpmrb(1)
        , mdrpmrg(7)
        , f_ip([27,21])
        , ix() 
        #y  
        , sy()
        , mdap(30)
        , mdrp0mrw(10)
        , mdrprg(17)
        , mdrp0rg(4)
        , alignrp(14)
        , f_ip([24,18])
        , mdrpmrb(1)
        , iy()
        ),

    'uni0E3A':    #PHINTHU
        packline(""
        , thbsara(9)
        , mdrpmrb(3)
        , ix() 
        #y  
        , sy()
        , mdap(12)
        , mdrp0mrw(6)
        , mdrpmrb(0)
        , iy() 
        ),

    'uni0E3F':    #THAI CURRENCY SYMBOL BAHT
        packline(""
        , tx2_0(49, 3,(25,38), 30,18, 50, fround=70)
        , srp0(30)
        , mdrp0g(43)
        , tstemw_1(12)
        , iprs_middle_stem(25, (23,1,36,5),'wanstemt',(34,22,47,7), 43)
        , ix()
        #y  
        , sy()
        , mdapr(2)
        , alignrp(22)
        , mdrpmrg(1)
        , tstemt_1(23)
        , shprp2(35)
        , mdapr(5)
        , alignrp(8)
        , mdrpmrg(6)
        , tstemt_2(37)
        , shprp2(47)
        , iprs_middle_stem(5, (36,48),'tstemt',(24,34), 23)
        , f_ip([15])
        , iy()
        ),

    'uni0E40':    #SARA E
        packline(""
        , trs_e(3,5, 11, 27)
        , xhead2(11,17,23)
        , ix()
        , dh1(8)
        , dh11(1), dh12(13)
        #y  
        , sy()
        , mdap(26)
        , tvt2(5)
        , tvbc(0)
        , head1(8,[14,20])
        , iy()
        , dh2(11)
        ),

    'uni0E42':    #SARA O
        packline(""
        , mdapr(7)
        , tstemtc_1(29)
        , mdapr(54)
        , mdrprw(19)
        , trs_e(3,32, 38, 54)
        , xhead2(38,44,50)
        , add_ip(7,19,[11,26,16,21])
        , ud2(29)
        , ix()
        , dh1(35)
        , dh11(1), dh12(40)
        #y  
        , sy()
        , mdap(53)
        , tvbc(0)
        , head1(35,[41,47])
        #
        , mdap(11)
        , tstemt_2(26)
        , 'RTDG'
        , mdrp0rg(21)
        , 'RTG'
        , tstemt_1(16)
        , srp0(11)
        , mdrp0rg(18)
        , tstemt_2(19)
        , add_ip(11,0,[4,7,8,29,30,32])
        , srp0(30)
        , tstemt_2(6)
        , iy()   
        , dh2(39)
        ),

    'uni0E43':    #SARA AI MAI MUAN
        packline(""
        , trs_e(3,34, 40, 68)
        , xhead2(40,46,52)
        , mdapr(23)
        , 'RDTG',tstemt_1(64),'RTG'
        , mdrp0rg(17)
        , f_ip([14])
        , 'RDTG',tstemt_2(58),'RTG'
        , mdrp0mrw(9)
        , tstemwm_1(29)
        , f_dstr(9,"14+2 15+2 16+2 ")
        , ix()
        , dh1(37)
        , dh2(20)
        , dh11(1), dh12(42)
        #y  
        , sy()
        , mdap(67)
        , tvbc(0) 
        , head1(37,[43,49])
        #
        , mdap(26)
        , tstemt_2m(12)
        , mdrp0rg(14,"11+8 12+8 13+8 14+8 15+8 16+8 ")
        , 'RDTG',tstemt_2(61),'RTG'
        , mdrp0rg(20,"11-8 15-8 16-8 ")
        , 'RDTG',tstemt_1(55),'RTG'
        , iy()
        , dh2(17,40)
        ),

    'uni0E44':    #SARA AI MAIMALAI
        packline(""
        , trs_e(3,19, 25, 41)
        , xhead2(25,31,37)
        , srp0(40)
        , mdrprg(11)
        , add_ip(11,3,[12,15,8,7])
        , ix()
        , dh1(22)
        , dh11(1), dh12(27)
        #y  
        , sy()
        , mdap(40)
        , tvbc(0)
        , head1(22,[28,34])
        #
        , mdap(19)
        , tstemtc_2(4)
        , mdrprg(12)
        , mdrp0rg(7)
        , f_ip([15])
        , ud2(15)
        , iy()
        , dh2(25)
        ),

    'uni0E45':    #LAKKHANGYAO
        packline(""
        , tx1(1,15, 17)
        , mdapr(8)
        , add_ip(8,15,[12,5])
        , ix()
        #y
        , sy()
        , mdap(16)
        , tvtc2(12,[8,2,15])
        , tstemt_2(5)
        , mdapr(8)
        , srp0(16)
        , tvblu(1)
        , iy()
        ),

    'uni0E46':    #MAIYAMOK
        packline(""
        , tx2_0(38, 19,8, 1,25, 39, fstem='tstemtc')
        , head1(13,[35,29])
        , add_ip(19,25,[21,22,23,4,5,6])
        , ix()
        , dh1(10)
        , dh2(16)
        #y
        , sy()
        , mdap(38)
        , tvtc2(21,[2,25])
        , alignrp(23)
        , tstemt_2(6)
        , shprp2(4)
        , 'RUTG'
        , mdrp0rg(5)
        , 'RTG'
        , tstemt_1(22)
        , mdrp0rg(10)
        , mdapr(10)
        , head2(16,[26,32])
        #
        , srp0(38)
        , tvblu(1)
        , iy()
        , dh2(13)
        ),

    'uni0E47':    #MAITAIKHU
        packline(""
        , mdap(41)
        , mdrprg(17)
        , 'RDTG',mdrprg(35),'RTG'
        , f_ip([53,47,33])
        , mdrp0rg(10)
        , f_ip([26,28,5,7])
        , mdrpmrb(23)
        , dx(23,-8)
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , alignrp(7)
        , mdrpmrb(26)
        , 'RDTG',mdrprg(38),'RTG'
        , f_ip([44,50,33,5,28])
        , mdrp0mrg(20)
        , mdrp0mrb(13)
        , mdrpmrg(16)
        , dx(20,8)
        , iy()
        ),

    'uni0E47.high':    #MAITAIKHU
        packline(""
        , mdap(41)
        , mdrprg(17)
        , 'RTDG',mdrprg(35),'RTG'
        , f_ip([53,47])
        , mdrp0rg(10)
        , f_ip([26,29,5,3])
        , mdrpg(23)
        , ix()
        #y
        , sy()
        , tvtwanayuk(0)
        , alignrp(7)
        , mdrpg(26)
        , 'RTDG',mdrprg(38),'RTG'
        , f_ip([44,50,33,5,28])
        , mdrp0mrg(20)
        , mdrp0mg(15)
        , mdrpmrg(16)
        , iy()
        ),

    'uni0E48':    #MAI EK
        packline(""
        , mdap(0)
        , mdrpmrb(1)
        , ix()
        #y
        , sy()
        , tvtwanayuk(0)
        , mdrpg(3)
        , iy()
        ),

    'uni0E48.low':    #MAI EK
        packline(""
        , thbsara(0)
        , mdrpmrb(1)
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , mdrpmg(3)
        , iy()
        ),

    'uni0E49':    #MAI THO
        packline(""
        , mdap(12)
        , mdrprg(19)
        , mdrprg(6)
        , f_ip([31,25,1,3,15])
        , ix()
        #y
        , sy()
        , tvtwanayuk(0)
        , mdrp0rg(3)
        , f_ip([1,15])
        , mdrp0rg(9)
        , f_ip([22,28])
        , mdrprg(18)
        , dx(15,-8)
        , iy()
        ),

    'uni0E49.low':    #MAI THO
        packline(""
        , mdapr(12)
        , mdrprg(19)
        #, 'RTDG',mdrp0rg(6),'RTG',f_ip([31,25,3,15])
        , mdrp0rg(6), f_ip([31,25,3,15])
        , mdrprg(0)
        , ix()
        , ud1(16)
#        , dh1(9)
        #y
        , sy()
        , tvtsara(0)
        , mdrpmrb(1)
        , shprp2(15)
        , mdrp0rg(3)
        #, 'RTDG',mdrp0rg(9),'RTG',f_ip([22,28])
        , mdrp0rg(9), f_ip([22,28])
        , mdrprg(18)
        , dx(15,-8)
        , iy()
#        , dh1(6)
#        , dh2(12)
        ),

    'uni0E4A':    #MAI TRI
        packline(""
        , mdap(28)
        , mdrpg(3)
        , mdrprg(34)
        , mdrp0rg(20)
        , f_ip([23,24,25,5,6,7])
        , mdrpg(9)
        #, 'RTDG',mdrprg(14),'RTG'
        , mdrprg(14)
        , f_ip([46,40])
        , ix()
        #y
        , sy()
        , tvtwanayuk(0)
        , alignrp(17)
        , mdrpg(38)
        , shprp2(1)
        #, 'RTDG',mdrprg(11),'RTG'
        , mdrprg(11)
        , f_ip([37,43])
        , mdrp0rg(25)
        , alignrp(23)
        , mdrprg(33)
        , mdrpg(5)
        , shprp2(7)
        , iy()
        , dx(24,-16)
        ),

    'uni0E4A.low':    #MAI TRI
        packline(""
        , mdap(28)
        , tstemt_2(3)
        , mdrprg(34)
        , mdrp0rg(20)
        , f_ip([23,24,25,5,6,7])
        , tstemt_1(9)
        , 'RDTG',mdrp0rg(14),'RTG'
        , f_ip([46,40])
        , ix()
        , dx(31,16)
        #y
        , sy()
        , tvtsara(0)
        , alignrp(17)
        , mdrpmrb(30)
        , 'RDTG',mdrprg(11),'RTG'
        , f_ip([43,37])
        , mdrp0rg(25)
        , alignrp(23)
        , mdrprg(33)
        , mdrpg(6), f_ip([5,7,24])
        , dx(30,-8)
        , iy()
        , dx(24,-16)
        ),

    'uni0E4B':    #MAI CHATTAWA
       packline(""
        , mdapr(10)
        , mdrp0mrg(0)
        , alignrp(7)
        , mdrpg(10)
        , 'SROUND 4',mdrp0mrg(1),'RTG'
        , alignrp(6)
        , mdrpg(3)
        , ix()
        #y  
        , sy()
        , tvtwanayuk(0)
        , mdrp0mrg(10)
        , alignrp(3)
        , mdrpg(0)
        , 'SROUND 4',mdrp0mrg(9),'RTG'
        , alignrp(4)
        , mdrpg(7)
        , iy()
        ),

    'uni0E4B.low':    #MAI CHATTAWA
        packline(""
        , thbsara(10)
        , mdrp0mrg(0)
        , alignrp(7)
        , mdrpg(10)
        , 'SROUND 4', mdrp0mrb(1), 'RTG'
        , alignrp(6)
        , mdrpg(3)
        , ix()
        #y  
        , sy()
        , tvtsara(0)
        , mdrp0mrg(10)
        , alignrp(3)
        , mdrpg(0)
        , 'SROUND 4', mdrp0mrb(9), 'RTG'
        , alignrp(4)
        , mdrpg(7)
        , iy()
        ),

    'uni0E4C':    #THANTHAKAT
        packline(""
        , mdap(15)
        , mdrprg(10)
        , mdrpmrg(3), f_ip([27,21])
        , ix()
        #y  
        , sy()
        , tvtwanayuk(0)
        , mdrp0mrg(6), f_ip([18,24])
        , mdrpmrg(9)
        , mdrpmb(12)
        , iy()
        ),

    'uni0E4C.low':    #THANTHAKAT
        packline(""
        , mdap(15)
        , mdrprg(10)
        , mdrpmrg(3), f_ip([27,21])
        , ix()
        , dh11(1), dh12(17)
        #y  
        , sy()
        , tvtsara(0)
        , mdrp0mrg(6), f_ip([18,24])
        , mdrpmrg(9)
        , mdrpmrb(12)
        , dx(6,-8)
        , iy()
        , dh1(3)
        , dh2(15)
        ),

    'uni0E4D':    #NIKHAHIT
        packline(""
        , mdap(9)
        , head2(3,[21,15])
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , head1(6,[12,18])
        , iy()
        ),

    'uni0E4D.high':    #NIKHAHIT
        packline(""
        , mdap(9)
        , mdrprg(3)
        , f_ip([21,15])
        , ix()
        #y
        , sy()
        , tvtwanayuk(0)
        , mdrprg(6)
        , f_ip([12,18])
        , iy()
        ),

    'uni0E4E':    #YAMAKKAN
        packline(""
        , thbsara(16)
        , mdrp0rg(10)
        , f_ip([26,0,7])
        , mdrpmrb(21)
        , mdrp0rg(4)
        , mdrpmrb(30)
        , ix()
        #
        , sy()
        , tvtsara(0)
        , mdrpmrb(33)
        , mdrp0rg(13)
        , f_ip([24])
        , mdrpmrb(18)
        , mdapr(24)
        , mdrpmrb(27)
        , f_ip([7])
        , iy()
        ),

    'uni0E4F':    #FONGMAN
        packline(""
        , mdapr(49) 
        , mdrp0mrw(9,"9+8 ")
        , mdrp0mrb(15)
        , mdrpmrw(33)
        , srp0(9)
        , mdrp0rg(3)
        , mdrp0mrb(21)
        , mdrpmrw(27)
        , add_ip(27,33,[45,39])
        , ix()
        #y  
        , sy()
        , mdapr(0) 
        , mdrp0mrb(12)
        , mdrpmrw(24)
        , srp0(0)
        , mdrp0rg(6)
        , mdrp0mrb(18)
        , mdrpmrw(30)
        , add_ip(30,24,[36,42])
        , iy()
        ),

    'uni0E50':    #THAI DIGIT ZERO
        packline(""
        , tx2_0(24, 3,21, 15,9, 25)
        , ix()
        #y  
        , sy()
        , mdap(24)
        , tvtnc(6)
        , tstemt_2(18)
        , srp0(24)
        , tvbc(0)
        , tstemt_1(12)
        , iy()
        ),

    'uni0E51':    #THAI DIGIT ONE
        packline(""
        , tx2_n(48, 3,22, 16,9, 49)
        , ip_round(3,16,27)
        , mdrpmrg(13)
        , head1(33,[45,39])
        , ix()
        , dh1(30)
        #y  
        , sy()
        , mdapr(13)
        , tstemtc_2(12)
        , tvtnc(6,[0,3,22,16,9])
        , tstemtc_2(19)
        , mdapr(0)
        , tstemtc_1(25)
        , ip_round(19,0,30)
        , xhead0(42,36,direction='-')
        , iy()
        , dh1(27)
        , dh2(33)
        ),

    'uni0E52':    #THAI DIGIT TWO
        packline(""
        , tx2_n(54, 3,8, 13,39, 55)
        , ip_round(8,13,31)
        , tstemw_1(19)
        , head1(24,[51,45])
        , add_ip(31,39,[34,35,36,15,16,17])
        , ix()
        , dh1(21)
        , dh2(27)
        #y  
        , sy()
        , mdap(0)
        , tstemt_1(11)
        , tvtnc(36)
        , alignrp(34)
        , mdrpmrg(6)
        , tstemt_2(15)
        , shprp2(17)
        , 'RUTG' , mdrp0mrg(16), 'RTG'
        , mdrpb(35)
        , srp0(36)
        , mdrp0rg(21,"")
        , head2(27,[42,48])
        , iy()
        , dh2(24)
        ),

    'uni0E53':    #THAI DIGIT THREE
        packline(""
        , tx3_n(56, 30,18, 11,9, 3,42, 57)
        , srp0(30)
        , xhead2(24,47,53,dstr="")
        , add_ip(11,9,[36])
        , ix()
        , dh1(21)
        , dh2(27)
        #y  
        , sy()
        , mdap(1)
        , tvtnc(39,[30,18,12,9,3,47,11,36])
        , alignrp(33)
        , tstemt_2(6)
        , shprp2(15)
        , srp0(1)
        , tvbc(27)
        , head1(21,[44,50])
        , iy()
        , dh2(24)
        ),

    'uni0E54':    #THAI DIGIT FOUR
        packline(""
        , tx1_1(57, 8,21, 0, 58, fstem="tstemwm")
        , ip_round(8,0,32)
        , head1(38,[54,48,26,41,3])
        , ip_round(0,58,15)
        , ud1(26)
        , ix()
        , dh1(35)
        #y  
        , sy()
        , mdap(0)
        , tstemt_1(44)
        , tvtn(12,[8,21])
        , mdrprg(14)
        , tstemt_2(17)
        , srp0(0)
        , mdrp0rg(35,"9-4 18-8 ")
        , f_ip([41,26,3])
        , xhead0(51,45,direction='-')
        , srp0(0)
        , tvbc(5)
        , tstemt_1(24)
        , iy()
        , dh1(32)
        , dh2(38)
        ),

    'uni0E55':    #THAI DIGIT FIVE
        packline(""
        , tx1_1(78, 8,30, 0, 79, fstem="tstemwm")
        , ip_round(8,0,41)
        , alignrp(13)
        , head1((47,19),[(63,75),(57,69),50,35,3])
        , ip_round(0,79,24)
        , ud1(35)
        , ix()
        , dh1(44,16)
        #y  
        , sy()
        , mdap(0)
        , tstemt_1(53)
        , tvtn(21,[8,30])
        , alignrp(11)
        , mdrprg(23)
        , tstemt_2(26)
        , mdrp0rg(16)
        , xhead0(72,66,direction='-')
        , srp0(0)
        , mdrp0rg(44,"9-4 18-8 ")
        , f_ip([50,35,3])
        , xhead0(60,54,direction='-')
        , srp0(0)
        , tvbc(5)
        , tstemt_1(33)
        , iy()
        , dh1(41)
        , dh2(47)
        ),

    'uni0E56':    #THAI DIGIT SIX
        packline(""
        , tx1(19,38, 54, rstem="tstemwm")
        , ip_round(53,19,6)
        , head1(12,[50,44,14])
        , add_ip(53,50,[28,29,25,32])
        , ix()
        , dh1(9)
        #y  
        , sy()
        , mdap(53)
        , tvtnc(35,[19,38,25,32]) 
        , tstemt_2(22)
        , mdrp0rg(29)
        , tstemw_2(28)
        , srp0(53)
        , tvbc(0)
        , tstemt_1(16)
        , mdrp0rg(3)
        , head1(9,[41,47])
        , iy()
        , dh1(6)
        , dh2(12)
        ),

    'uni0E57':    #THAI DIGIT SEVEN
        packline(""
        , tx2_n(72, 34,19, 52,57, 73)
        , iprs_middle_stem(34, 4,'tstemwm',46, 52, mround=70)
        , iprs_middle_stem(34, 12,'tstemwm',10, 4, mround=72)
        , f_ip([40])
        , srp0(34)
        , xhead2(25,63,69, dstr="")
        , add_ip(29,12,[37,16])
        , add_ip(10,4,[43,7])
        , ix()
        , dh1(22)
        , dh2(28)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(49)
        , tvtnc(43,[34,19,12,4,46,40])
        , alignrp(37)
        , mdrprg(54)
        , tstemt_2(7)
        , shprp2(16)
        , srp0(1)
        , tvbc(28)
        , head1(22,[60,66])
        , iy()
        , dh2(25)
        ),

    'uni0E58':    #THAI DIGIT EIGHT
        packline(""
        , tx1_1(55, 7,20, 37, 56, fstem="tstemwm")
        , srp0(37)
        , head2(31,[52,46,28])
        , ip_round(20,31,23)
        , mdrpg(25)
        , f_ip([24,4,3])
        , srp0(37)
        , mdrprg(14)
        , ud1(28)
        , ix()  
        , dh1(34)
        #y  
        , sy()
        , mdap(0)
        , alignrp(4)
        , tstemt_1(28)
        , shprp2(23)
        , tvtn(11,[7,20])
        , mdrprg(13)
        , tstemt_2(16)
        , srp0(0)
        , mdrp0rg(34)
        , head2(40,[43,49])
        , srp0(0)
        , mdrp0rg(24)
        , tstemw_2(3)
        , iy()
        , dh1(31)
        ),

    'uni0E59':    #THAI DIGIT NINE
        packline(""
        , tx2_n(64, 24,7, 1,0, 65)
#        , xhead2(18,55,61,dstr="9-8 ")
, mdrp0rg(10), head1(18,[61,55])
        , add_ip(7,1,[27,4,3,2,30,49])
        , add_ip(30,0,[33,46,43,36])
        , srp0(0)
        , mdrp0rg(40)
        , ix()  
        , dh1(15)
        #y  
        , sy()
        , mdap(1)
        , tvtnc(33,[24,7,2,49,30])
        , alignrp(27)
        , mdrprg(39)
        , tstemt_2(46)
        , shprp2(4)
        , mdrp0rg(43)
        , tstemt_1(36)
        , srp0(1)
        , tvbc(21)
        , head1(15,[52,58])
        , iy()
        , dh1(12)
        , dh2(18)
        ),

    'uni0E5A':      #ANGKHANKHU
        packline(""
        , tx1(40,42, 44, rstem="tstemwm")
        , srp0(40)
        , mdrp0mrw(26)
        , tstemwm_2(1)
        , shprp2(25)
        , ip_round(43,1,11)
        , head1(17,[36,30])
        , ix()
        , dh1(14)
        #y  
        , sy()
        , mdap(1)
        , alignrp(40)
        , tvt2(25,[2,26,41,42])
        , tvtc2(14)
        , head2(8,[27,33,20])
        , mdrp0rg(5)
        , tstemt_1(22)
        , iy()
        , dh2(17)
        ),

    'uni0E5B':      #KHOMUT
        packline(""
        , tx1_1(59, 3,14, 36, 60, fstem="tstemwm")
        , xhead2(9,50,56)
        , add_ip(9,36,[20,25,30,44,41,38])
        , ix()
        , dh2(12)
        #y  
        , sy()
        , mdapr(6)
        , mdapr(59)
        , tvbc(0)
        , tstemt_1m(17)
        , mdrp0mrw(12) 
        , xhead0(47,53)
        , mdapr(20)
        , mdapr(43)
        , add_ip(20,43,[25,30,40])
        , mdapr(36)
        , tstemt_1(35)
        , iy()
        , dh2(9)
        ),

    }



#++++++++++++++++++++++++++++++

#----- MODIFY pseudo_code_dict BY -----------
#----- SUBSTITUTE FUNCTION IN TEXT FORM -----
#----- TO REAL pseudo_code ------------------
from dttcmd import *

self_func = []
for i in dir():
    if callable(eval(i)): self_func.append(i)

for i in pseudo_code_dict.keys():
    p_list = pseudo_code_dict[i].split('\n')
    for j in range(len(p_list)):
        if '(' in p_list[j]:
            if p_list[j].split('(',1)[0] in self_func:
                l = [n for n in range(len(p_list[j])) if p_list[j][n] == ')']
                t = p_list[j][:l[-1]+1]
                p_list[j] = p_list[j].rep_listace(t, eval(t))
    pseudo_code_dict[i] = '\n'.join(p_list)
