#!/usr/bin/env python
#   #----- MODIFY pseudo_code_dict BY -----------
#   #----- SUBSTITUTE FUNCTION IN TEXT FORM -----
#   #----- TO REAL pseudo_code ------------------
#   
#   ### THIS LINE IN THE TOP
#   from dttcmd import *
#
#   ### THESE LINES IN THE BOTTOM
#   self_func = []
#   for i in dir():
#       if callable(eval(i)): self_func.append(i)
#   
#   for i in pseudo_code_dict.keys():
#       p_list = pseudo_code_dict[i].sp_listit('\n')
#       for j in range(len(p_list)):
#           if '(' in p_list[j]:
#               if p_list[j].sp_listit('(',1)[0] in self_func:
#                   l = [n for n in range(len(p_list[j])) if p_list[j][n] == ')']
#                   t = p_list[j][:l[-1]+1]
#                   p_list[j] = p_list[j].rep_listace(t, eval(t))
#       pseudo_code_dict[i] = '\n'.join(p_list)
#   

from dttcmd import *

func_arg_list = [[2, 0], [1, 0], [3, 1], [1, 1], [4, 0], [0, 1], [0, 1], [0, 1], [3, 0], [3, 0], [2, 0], [1, 0], [1, 0], [4, 0], [3, 0], [5, 0], [2, 0], [2, 0], [2, 0], [3, 0], [0, 0]]

cvt_dict = {
    'evheight_lu' : 0,   #  -422
    'tvheight_lu' : 0,   #  -422
    'vbase' : 1,   #  0
    'tvheight_num' : 2,   #  908
    'evheight' : 3,   #  1062
    'tvheight' : 4,   #  1140
    'ecvheight' : 5,   #  1450
    'tvheight_po' : 5,   #  1450
    'estemtc' : 6,   #  218
    'ecstemt' : 6,   #  218
    'tstemtc' : 6,   #  218
    'cvt_7' : 7,   #  130
    'cvt_8' : 8,   #  139
    'estemt' : 9,   #  207
    'tstemt' : 9,   #  207
    'estemw' : 10,   #  240
    'tstemw' : 11,   #  240
    'ecstemw' : 12,   #  253
    'cvt_13' : 13,   #  233
    'ecstemtc': 13,  #230
    'cvt_14' : 14,   #  242
    'cvt_15' : 15,   #  214
    'cvt_16' : 16,   #  188
    'stemw_sara' : 16,   #  188
    'stemwa' : 16,   #  188
    'cvt_17' : 17,   #  216
    'cvt_18' : 18,   #  210
    'cvt_19' : 19,   #  175
    'cvt_20' : 20,   #  177
    'stemt_sara':20,
    'cvt_21' : 21,   #  231
    'cvt_22' : 22,   #  113
    'head_sara_stem' : 22,   #  113
    'cvt_23' : 23,   #  133
#USER LAND
    'tvheight_num_shoot' : 24,  # 908+24=932
    'evheight_shoot' : 25,      # 1062+24=1086
    'tvheight_shoot' : 26,      # 1140+24=1164
    'ecvheight_shoot' : 27,     # 1450+27=1477
    'headstem'  : 28,    # 140
    'headdia'   : 29,    # 430
    'headstemplushole' : 30,    # 290 
    'estemwc'   : 31,   # 260
    'ecstemwc'   : 32,   # 273
    'vbase_shoot': 33,  #24
    'tvbase_shoot': 33,  #24
    'head_sara':    34, #360
    }

#---GENERATE STEM FUNCTION---
#predefine delta string of stem (put before gen_cvt_func)
ds_headstemplushole = "18-4 19+2 20+2 21-2 24+4 28+4 29+4 30+4 32-4 33+4 34+4 38+8 "
ds_head_sara_stem = "9-4 10-4 "

gen_cvt_func_dict = {
    #[min,black]
    'mb':   ['estem*','tstem*','stem*','ecstem*'],
    #[min,rnd,black]
    'mrb':  ['headstem*','head_sara_stem','head_sara'],
    #[rp0,rnd,grey]
    '0rg':  ['headdia'],
    }

for arg,cvt_list in gen_cvt_func_dict.iteritems():
    new_list = []
    for i in cvt_list:
        if i[-1]=='*':
            c = i.strip('*')
            n = len(c)
            l = [x for x in cvt_dict.keys() if x[:n]==c]
            new_list.extend(l)
        else:
            new_list.append(i)
        
    for i in new_list:
        for j in ['1','1m','2','2m']:   #1=forward/bottomup, #2=reverse/topdown
            if j[-1] == 'm':    #m=move rp0
                cmd = 'mirp0'+arg
            else:
                cmd = 'mirp'+arg
            if j[0] == '1': #1=forward/bottomup, #2=reverse/topdown
                direction = '+'
            else:
                direction = '-'
            #AUTO GENERATE delta string
            try:
                exec "a = ds_%s " % (i,)
            except:
                exec "ds_%s = ''" % (i,)

            #GEN FUNC
            exec '''def %s_%s(s,direction="%s"):
    return %s("%s",s,ds_%s,direction)
''' % (i,j,direction,cmd,i,i,)

            #GEN EXTRA FUNC FOR THIN OF estemt, tstemt
            #USE IN UPPER STEM OF kho_khai, kho_kwai
            #***PREDEFINE: ds_estemt_thin
            if i in ['estemt','estemtc','tstemt','tstemtc']:
                #AUTO GENERATE delta string
                try:
                    exec "a = ds_%s_thin " % (i,)
                except:
                    exec "ds_%s_thin = ''" % (i,)
                #GEN FUNC
                exec '''def %s_thin_%s(s,direction="%s"):
    return %s("%s",s,ds_%s_thin,direction)
''' % (i,j,direction,cmd,i,i,)


#EXAMPLE OF CVT FUNCTION DEFINED:
#
#def estemw_1(s): = """
#   MIRP[rnd,black]    estemw s
#   f_dstr(s,"ds_estemw")
#   """
#
#def estemw_2(s): = """
#   MIRP[rnd,black]    estemw s
#   f_dstr(s,"ds_estemw",direction="-")
#   """

#----------------------------------------
#DRY HEAD
#ENABLE DRY HEAD FOR BOOK
dh_dstr = "14+3 15+3 16+3 "
def dh1(*l): #dry head
    d = {}
    for s in l:
        d[s-1] = dh_dstr
        d[s+1] = swap_dstr(dh_dstr)
    return f_dstr_dict(d)
#    return f_dstr_dict({
#        s-1: "15+4 16+3 17+3 18+3 ",
#        s+1: "15-4 16-3 17-3 18-3 " })

def dh2(*l): #dry head
    d = {}
    for s in l:
        d[s-1] = swap_dstr(dh_dstr)
        d[s+1] = dh_dstr
    return f_dstr_dict(d)
#    return f_dstr_dict({
#        s-1: "15-4 16-3 17-3 18-3 ",
#        s+1: "15+4 16+3 17+3 18+3 " })
#DISABLE DRY HEAD FOR BOLD
def dh1(*l):
    return ""
def dh2(*l):
    return ""


#----------------------------------------
def dx(s,x):
    return """
SHPIX   %s %s
""" % (x,s)

#================================================
def vbc1(s,li=[]):
    return pl(""
        , mirp0rg("vbase_shoot",s)
        , f_ip(li)
        )

def tvbc(s,li=[]):  #thai vbase curve
    return pl(""
        , mirp0rg("tvbase_shoot",s)
        , f_ip(li)
        )

def tvblu(s,li=[]):
    return pl(""
        , mirprg("tvheight_lu",s)
        , f_ip(li)
        )

def tvblum(s,li=[]):
    return pl(""
        , mirp0rg("tvheight_lu",s)
        , f_ip(li)
        )

def tvtc2(s,li=[]): #thai vtop curve
    return pl(""
        , mirp0rg("tvheight_shoot",s,"")
        , f_ip(li)
        )

def tvt2(s,li=[]):
    return pl(""
        , 'SROUND 74', mirprg("tvheight",s), 'RTG'
        , f_ip(li)
        )

def vt2m(s,li=[]):
    return pl(""
        , mirp0rg("vheight",s,ds_vheight)
        , f_ip(li)
        )

def tvtpo(s,li=[]):
    return pl(""
        , mirprg("tvheight_po",s)
        , f_ip(li)
        )

def vtpom(s,li=[]):
    return pl(""
        , mirp0rg("vheight_po",s)
        , f_ip(li)
        )

def thbsara(s):
    return pl( 'RUTG', mdapr(s), 'RTG' )

def tvtsara(s):
    return mdapr(s,"12+8 15+8 ")

def tvtwanayuk(s):
    return mdapr(s,"12+8 14+8 15+8 17+8 ")


def tvtn(s, li=[]):
    return pl(""
        , 'SROUND 73', mirp0rg("tvheight_num",s,"21+8 "), 'RTG'
        , f_ip(li)
        )

def tvtnc(s, li=[]):
    return pl(""
        , mirp0rg("tvheight_num_shoot",s)
        , f_ip(li)
        )
#==================================================

def head_0(s,li,direction="+",dia="headdia", dsh_extra=""):
    #round head
    s,add1 = gen_alignrp(s)
    i1,addi1 = gen_alignrp(li[0],2)
    i2,addi2 = gen_alignrp(li[1],2)
    l = li[2:]
    reverse_dir = direction.replace('+','*').replace('-','+').replace('*','-')
    if dia == "head_sara":
        ds_dia = ds_head_sara
        stem = "head_sara_stem"
        ds_stem = ds_head_sara_stem
    else:
        ds_dia = ds_headdia
        stem = "headstem"
        ds_stem = ds_headstem
    if l:
        addip = f_ip(l)
    else:
        addip = ""
    if dsh_extra:
        add1_extra = f_dstr(s,dsh_extra)
    else:
        add1_extra = ""
    return pl(""
        , 'SROUND 2'
        , mirpmrb(stem,i1,ds_stem,direction)
        , addi1
        , 'SROUND 69'
        , mirp0rg(dia,s,ds_dia,direction)
        , add1_extra
        , add1
        , addip
        , 'SROUND 2'
        , mirpmrb(stem,i2,ds_stem,reverse_dir)
        , addi2
        , 'RTG'
        )

def head1(s,li,dsh_extra=""):
    #left to right
    return head_0(s,li,direction="+",dsh_extra=dsh_extra)

def head2(s,li,dsh_extra=""):
    #right to left
    li = [li[1],li[0]] + li[2:]
    return head_0(s,li,direction="-",dsh_extra=dsh_extra)

def headsara1(s,li,dsh_extra=""):
    return head_0(s,li,direction="+",dia="head_sara",dsh_extra=dsh_extra)

def headsara2(s,li,dsh_extra=""):
    li = [li[1],li[0]] + li[2:]
    return head_0(s,li,direction="-",dia="head_sara",dsh_extra=dsh_extra)



def xhead0(s2,s3,direction="+"):
    s2,add2 = gen_alignrp(s2,2)
    s3,add3 = gen_alignrp(s3,2)
    return pl(""
        , 'SROUND 2'
        , headstem_1(s2,direction=direction)
        , add2
        , 'SROUND 5'
        , headstemplushole_1(s3,direction=direction)
        , add3
        , 'RTG'
        )


def xhead1(s1,s2,s3,dstr="28-8 ",direction="+"):
    s1,add1 = gen_alignrp(s1)
    return pl(""
        , 'SROUND 69'
        , mdrp0mrg(s1,dstr)
        , 'RTG'
        , add1
        , xhead0(s2,s3,direction)
        )

def xhead2(s1,s2,s3,dstr="",direction="-"):
    s1,add1 = gen_alignrp(s1)
    return pl(""
        , 'SROUND 70'
        , mdrp0rg(s1,dstr)
        , 'RTG'
        , add1
        , xhead0(s2,s3,direction)
        )


#================================================
def v_notch_ko_kai(s1,s1s,s2):
    return pl(""
        , mdrp0rg(s1,"23+8 ")
        , alignrp(s1s)
        , stem_notch_1(s2)
        , dx(s2,-8)
        )

def v_head_kho_khai(s1,li1, s2, s3,s4, li4, add1=""):
    return pl(""
        , tvtc2(s1,li1)
        , add1
        , tstemt_thin_2(s2)
        , mdrp0rg(s3)
        , head2(s4,li4)
        )

def v_head_kho_khuat(s1,s1s,li1, s2,s2s, s3,s4, s5,s6,li6 , add1=""):
    return pl(""
        , tvtc2(s1, li1)
        , alignrp(s1s)
        , add1
        , tstemt_2(s2)
        , shprp2(s2s)
#        , mdrp0mrg(s3,"9-3 10-3 11-3 12-3 17-3 16-3 18-3 19-3 20-3 21-3 ")
        , 'RUTG'
        , mdrp0mrg(s3)
        , 'RTG'
        , mdrpb(s4)
        , mdrp0rg(s5)
        , mdapr(s5)
        , head2(s6,li6)
        )

def v_top_kho_khwai(s1,li1,s2, s3,s4,li4,add1=""):
    if len(li4) > 3:
        add4 = f_dstr_dict({
            li4[2]:"14+2 15+2 16+2 ",
            li4[3]:"14-4 15-4 16-4 ",
            })
    else:
        add4 = ""
    return pl(""
        , tvtc2(s1,li1)
        , add1
        , tstemtc_thin_2(s2)
        , 'RUTG'
        , mdrp0rw(s3)
        , 'RTG'
        , head2(s4,li4)
        , add4
        )

def v_top_kho_khon(s1,s1s,li1, s2,s2s, s3,s4, s5,s6,li6):
    if len(li6) > 3:
        add6 = f_dstr_dict({
            li6[2]:"14+2 15+2 16+2 ",
            li6[3]:"14-4 15-4 16-4 ",
            })
    else:
        add6 = ""
    return pl(""
        , tvtc2(s1,li1)
        , alignrp(s1s)
        , tstemt_2(s2)
        , shprp2(s2s)
        , 'RUTG'
        , mdrp0rg(s3)
        , 'RTG'
        , stemt_sara_2(s4)
        , mdrp0mrw(s5)
        , mdapr(s5)
        , head2(s6,li6)
        , add6
        )
        
def v_top_ro_rua(s1,li1, s2, s3,s4,s5,s6):
    return pl(""
        , tvtc2(s1,li1)
        , tstemtc_thin_2(s2)
        , 'RTDG'
        , mdrp0rg(s3)
        , 'RTG'
        , tstemt_1(s4)
        , srp0(s1)
        , mdrp0g(s5)
        , tstemt_2(s6)
        )

#================================================
#new point reference
#f0,r0,...: use tuple to align multiple points

def trs_no_nu(r1,r2, h1,h2,li, r0):
    #thai rear stem of no nu
    return pl(""
        , mdapr(r0)
        , mdrp0mrw(h2)
        , head2(h1,li)
        , f_dstr(h2,"12+4 13+6 ")
        , mdrp0rg(r1)
        , tstemw_1(r2)
        )


#================================================
def thw0(f0, f1,f2, r1,r2, r0, fround=71, fstem='tstemw',rstem='tstemw'):
    #thai horizontal walk: ko_kai,
    return u_x2(f0, f1,fstem,f2, r1,rstem,r2, r0, fround=fround)

def thw1(f0, f1,f2,f3, f4,f5, r1,r2, r0, fround=69):
    #thai horizontal walk: tho_thahan,
    fx4,temp = gen_alignrp(f4)
    return pl(""
        , thw0(f0, f4,f5, r1,r2, r0, fround)
        , srp0(fx4)
        , xhead1(f1,f2,f3)
        )

def thw2(f0, f1,f2, f3,f4,f5, r1,r2, r0, fround=69):
    #pho_phung
    fx1,temp = gen_alignrp(f1)
    return pl(""
        , thw0(f0, f1,f2, r1,r2, r0)
        , srp0(fx1)
        , xhead2(f3,f4,f5)
        )

def thw3(f0, f1,f2,li12, f3,f4, f5,f6, r1,r2, r0, fround=73, dsh_extra="",i56=-1):
    #kho_khai
    fx0,temp = gen_alignrp(f0)
    f1,addf1 = gen_alignrp(f1)
    fx3,temp = gen_alignrp(f3)
    f5,addf5 = gen_alignrp(f5)
    f6,addf6 = gen_alignrp(f6,2)
    rx1,temp = gen_alignrp(r1)
    if i56 >= 0:
        addi56 = f_ip([i56])
    else:
        addi56 = ""
    return pl(""
        , thw0(f0, f3,f4, r1,r2, r0, fround)
        , ip_round(f0,f3, f1)
        , addf1
        , head1(f2,li12,dsh_extra=dsh_extra)
        , 'SROUND 10'
        , ip_round(fx3,rx1,f5)
        , addf5
        , 'RTG'
        , tstemw_1(f6)
        , addi56
        , addf6
        )

#================================================
def th_ko_kai(s1, s2,s3, s4,s5, s0=-1):
    if s0 >= 0:
        ips0 = pl( add_ip(s0,s1, [s2]), srp0(s2) )
    else:
        ips0 = pl( srp0(s1), mdrp0g(s2) )
    return pl(""
        , ips0
        , mdrpg(s3)
        , tstemw_1m(s4)
        , mdrpg(s5)
        )

def th_kho_khwai(s1, s2,s3,i23, s4,s5,li45, s6):
    return pl(""
        , srp0(s1)
        , mdrp0rg(s2)
        , tstemw_1(s3)
        , f_ip([i23])
#        , srp0(s6)
#        , mdrp0mrw(s5)
#        , head2(s5,li45)
        , ip_round(s1,s6,s4)
        , mdapr(s4)
        , head1(s5,li45)
        )

#================================================
pseudo_code_dict = {

    'uni0E01':      #KO KAI
        packline(""
        , thw0(25, 14,12, 1,24, 26)
        , th_ko_kai(14, 18,17, 8,9, s0=25)
        , add_ip(14,24,[5,21])
        , ix()
        #y
        , sy()
        , mdap(1)
        , alignrp(13)
        , tvtc2(21,[15,12,2,24, 18,8,17,9,10])
        , tstemt_2(5)
        , iy()
        ),

    'uni0E02':    #KHO KHAI
        packline(""
        , thw3(44, 19,13,[41,35,10], 1,27, 4,25, 29,31, 45)
        , ix()
        , dh2(15)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(28)
        , tvt2(31)
        , v_head_kho_khai(22,[2,27,4,25], 7, 10,16,[32,38])
        , iy()
        , dh2(13)
        ),

    'uni0E03':    #KHO KHUAT
        packline(""
        , thw3(50, 23,17,[47,41,12], 1,33, 4,31, 35,37, 51, dsh_extra="18-8 ")
        , add_ip(23,31, [26,27,28, 7,8,9])
        , ix()
        , dh1(14)
        , dh2(20)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(34)
        , tvt2(37)
        , v_head_kho_khuat(28,26,[4,31,2,33], 7,9, 8,27, 14,20,[38,44])
        , iy()
        , dh2(17)
        ),

    'uni0E04':    #KHO KHWAI
        packline(""
        , thw0(55, 36,8, 1,42, 56, fround=68)
        , th_kho_khwai(36, 30,29,11, 14,20,[52,46,26], 1)
        , add_ip(36,42,[39,5])
        , ix()
        , dh1(17)
        , dh2(23)
        #y
        , sy()
        , mdap(1)
        , alignrp(29)
        , v_top_kho_khwai(39,[36,8,11,2,42],5, 17,23,[43,49,26,14])
        , dx(26,12)
        , dx(11,-16)
        , iy()
        , dh2(20)
        ),

    'uni0E05':    #KHO KHON
        packline(""
        , thw0(55, 36,8, 1,42, 56, fround=68)
        , th_kho_khwai(36, 30,29,11, 14,20,[52,46,26], 1)
        , add_ip(36,42,[38,39,40,4,5,6])
        , ix()
        , dh1(17)
        , dh2(23)
        #y
        , sy()
        , mdap(1)
        , alignrp(29)
        , v_top_kho_khon(40,38,[36,8,11,2,42],4,6, 5,39, 17,23,[43,49,26,14])
        , dx(26,12)
        , dx(11,-16)
        , iy()
        , dh2(20)
        ),

    'uni0E06':    #KHO RAKHANG
        packline(""
        , thw3(74, 35,29,[59,53,24], 13,45, 16,43, (47,1),49, 75, fround=74, dsh_extra="18-8 ")
        , add_ip(35,43,[38,39,40,19,20,21])
        , srp0(13)
        , xhead1(8,71,65)
        , ix()
        , dh1(26,11)
        , dh2(32,5)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(47)
        , tvt2(49)
        , v_head_kho_khuat(40,38,[16,43,14,45], 19,21, 20,39, 26,32,[50,56])
        , srp0(1)
        , tvbc(5)
        , head1(11,[62,68, 46,2])
        , iy()
        , dh2(29)
        , dh1(8)
        ),

    'uni0E07':    #NGO NGU
        packline(""
        , thw0(40, 4,5, 12,24, 41, fstem='ecstemw')
        , srp0(12)
        , xhead1(18,37,31)
        , ix()
        , dh1(21)
        , dh2(15)
        #y
        , sy()
        , mdapr(40)
        , tvtc2(21,[4,12,25])
        , head2(15,[28,34])
        , srp0(40)
        , tvbc(0)
        , tstemtc_1(9)
        , mdapr(4)
        , iy()
        , dh1(18)
        ),

    'uni0E08':    #CHO CHAN
        packline(""
        , thw0(52, 3,15, 22,36, 53)
        , srp0(3)
        , xhead1(9,49,43)
        , add_ip(3,36,[0,19])
        , add_ip(52,3,[30])
        , add_ip(30,36,[26,33])
        , ix()
        , dh1(12)
        , dh2(6)
        #y
        , sy()
        , mdap(52)
        , tvtc2(33,[29,3,16,22,37,23,36])
        , tstemt_2(26)
        , mdrp0rg(12,"12-8 ")
        , head2(6,[40,46])
        , srp0(52)
        , tvbc(0)
        , tstemt_1(19)
        , mdapr(29)
        , iy()
        , dh1(9)
        ),

    'uni0E09':    #CHO CHING
        packline(""
        , trs_no_nu(15,29, 39,33,[61,55], 65)
        , ip_front_stem(64, 1,'tstemw',(13,0), 29)
        , xhead1(7,49,43)
        , add_ip(64,1,[23])
        , add_ip(23,29,[26,19])
        , ix()
        , dh1(10)
        , dh2(4,36)
        #y
        , sy()
        , mdap(0)
        , tstemt_1(14)
        , tvtc2(26,[16,29,22])
        , tstemt_2(19)
        , mdapr(22)
        , mdrp0mrw(10)
        , head2(4,[40,46])
        , srp0(0)
        , tvbc(36)
        , head1(30,[52,58,39,15])
        , iy()
        , dh1(7)
        , dh2(33)
        ),

    'uni0E0A':    #CHO CHANG
        packline(""
        , thw3(56, 19,13,[53,47,10], 1,42, 4,25, 37,36, 57, i56=40)
        , srp0(4)
        , mdrpg(34)
        , dx(34,-8)
        , srp0(37)
        , mdrp0mrg(29)
        , tstemw_1(30)
        , ix()
        , dh2(16)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(43)
        , v_head_kho_khai(22,[2,42,38,36,4,25,40,34], 7, 10,16,[44,50],
            add1=mdrpmrg(30))
        , f_dstr(25,"14-3 15-3 16-3 ")
        , iy()
        , dh2(13)
        ),

    'uni0E0B':    #SO SO
        packline(""
        , thw3(62, 23,17,[69,53,12], 1,48, 4,31, 43,42, 63, dsh_extra="18-8 ",i56=46)
        , add_ip(23,31, [26,27,28,7,8,9])
        , srp0(4)
        , mdrpg(40)
        , dx(40,-8)
        , srp0(43)
        , mdrp0mrg(35)
        , tstemw_1(36)
        , ix()
        , dh1(14)
        , dh2(20)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(49)
        , v_head_kho_khuat(28,26,[2,48,44,42,4,31,46,40], 7,9, 8,27, 14,20,[50,56],
            add1=mdrpmrg(36))
        , f_dstr(31,"14-3 15-3 16-3 ")
        , iy()
        , dh2(17)
        ),

    'uni0E0C':    #CHO_CHOE
        packline(""
        , u_x3(73, 34,'tstemw',22, 11,'tstemw',44, 46,'tstemw',48, 74)
        , srp0(34)
        , xhead2(28,52,58)
        , srp0(11)
        , 'SROUND 70'
        , mdrp0rg(8)
        , 'RTG'
        , head1(2,[70,64])
        , th_ko_kai(34, 38,37, 18,19, s0=73)
        #
        , add_ip(38,44,[41,15])
        , ix()
        , dh1(25)
        , dh2(31,5)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(46)
        , tvt2(48)
        , tvtc2(41,[35,37,38,18,19,20, 12,44])
        , tstemt_2(15)
        , srp0(1)
        , tvbc(31)
        , alignrp(5)
        , head1((25,11),[(49,61),(55,67),45,2])
        , f_dstr(2,"14+3 15+3 16+3 ")
        , iy()
        , dh1(8)
        , dh2(28)
        ),

    'uni0E0D.descless':    #YO YING
        packline(""
        , u_x3(51, 24,'tstemw',12, 1,'tstemw',34, 36,'tstemw',38, 52)
        , srp0(24)
        , xhead2(18,42,48)
        #
        , add_ip(28,34,[31,5])
        , ix()
        , dh1(15)
        , dh2(21)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(35)
        , tvt2(38)
        , tvtc2(31,[25,27,28, 8,9,10,12, 2,34])
        , tstemt_2(5)
        , srp0(1)
        , tvbc(21)
        , head1(15,[39,45])
        , iy()
        , dh2(18)
        ),

    'desc.uni0E0D':
        packline(""
        , thbsara(19)
        , mdrp0rg(6)
        , headsara1(12,[31,25])
        , ix()
        #y
        , sy()
        , mdap(34)
        , mdrp0mrw(9)
        , mdrprg(18)
        , headsara2(3,[22,28])
        , mdrp0rg(0)
        , stemt_sara_1(15)
        , iy()
        ),

    'uni0E0E':    #DO CHADA
        packline(""
        , thw1(76, 38,63,57, 43,31, (20,1),53, 77)
        , th_ko_kai(43, 47,46, 27,29)
        , srp0(1)
        , mdrprg(68)
        , f_ip([13,18,3])
        , mdrp0rg(8)
        , stemw_sara_1(73)
        , add_ip(47,53,[50,24])
        , dx(68,8)
        , dx(18,-8)
        , ix()
        , dh1(41,11)
        , dh2(35,5)
        #y
        , sy()
        , mdap(76)
        , tvtc2(50,[44,46,47, 27,28,29,31, 21,53])
        , tstemt_2(24)
        , srp0(76)
        , tvbc(35)
        , head1(41,[54,60])
        , srp0(76)
        , tvblum(5)
        , alignrp(1)
#        , 'RDTG'
#        , stemt_sara_1(66)
#        , 'RTG'
#        , mdrp0rg(11)
#        , f_ip([13,68,3,18,20])
#        , 'RDTG'
#        , stemt_sara_2(70)
#        , 'RTG'
        , head1(11,[66,70, 13,68,3,18,20])
#
        , dx(3,8)
        , dx(13,-8)
        , iy()
        , dh1(38,8)
        ),

    'uni0E0F':    #TO PATAK
        packline(""
        , thw1(82, 44,69,63, 49,37, (26,1),59, 83)
        , th_ko_kai(49, 53,52, 33,34)
        , srp0(26)
        , mdrprg(74)
        , f_ip([16,21,23,24,2,3,6])
        , mdrp0rg(11)
        , stemw_sara_1(80)
        , add_ip(53,59,[56,30])
        , dx(74,8)
        , dx(21,-8)
        , ix()
        , dh1(47,14)
        , dh2(41,8)
        #y
        , sy()
        , mdap(82)
        , tvtc2(56,[50,52,53, 33,34,35,37, 27,59])
        , tstemt_2(30)
        , srp0(82)
        , tvbc(41)
        , head1(47,[60,66])
        , srp0(82)
        , tvblum(8)
        , alignrp(4)
        , alignrp(1)
#        , stemt_sara_1(72)
#        , mdrp0rg(14)
#        , f_ip([16,11,23,24,2,6])
#        , stemt_sara_2(76)
        , head1(14,[72,76, 16,11,23,24,2,6])
#
        , dx(6,8)
        , dx(16,-8)
        , iy()
        , dh1(44,11)
        ),

    'uni0E10.descless':    #THO THAN
        packline(""
        , thw0(64, 3,15, 22,48, 65)
        , srp0(3)
        , xhead1(9,61,55)
        , add_ip(3,48,[0,19])
        , add_ip(64,3,[26])
        , srp0(26)
        , tstemw_1(45)
        , srp0(65)
        , mdrpmrw(36)
        , add_ip(26,36,[29,42])
        , ix()
        , dh1(12)
        , dh2(6)
        #y
        , sy()
        , mdapr(64)
        , v_top_ro_rua(29,[26,48,46,25,23,48,12], 42, 39,32,35,36)
        , mdapr(12)
        , head2(6,[52,58])
        , srp0(64)
        , tvbc(0)
        , tstemt_1(19)
        , iy()
        , dh1(9)
        ),

    'desc.uni0E10':
        packline(""
        , thbsara(38)
        , stemw_sara_2(26)
        , headsara2(32,[48,42])
        , mdrp0rg(21)
        , add_ip(21,26,[23,24,25,1,2,3,4])
        , headsara2(11,[58,53,16,6])
        , ix()
        #y
        , sy()
        , mdap(61)
        , mdrp0mrw(35)
        , headsara2(29,[39,45])
        , mdrp0rg(1)
        , alignrp(4)
        , alignrp(8)
        , stemt_sara_1(26)
        , shprp2(23)
        , headsara1(14,[51,55])
        , iy()
        ),

    'uni0E11':    #THO NANGMONTHO
        packline(""
        , thw3(60, 33,27,[57,51,22], 11,10, 14,41, 1,47, 61, fround=72, dsh_extra="18-8 ")
        , add_ip(33,41, [36,37,38, 17,18,19])
        , srp0(14)
        , mdrpg(8)
        , ix()
        , dh1(21)
        , dh2(27)
        #y
        , sy()
        , mdap(1)
        , alignrp(10)
        , v_head_kho_khuat(38,36,[12,14,41,8,2,47], 17,19, 18,37, 24,30,[48,54], add1=pl( alignrp(44), tstemt_2(5)))
        , iy()
        , dh2(24)
        ),

    'uni0E12':    #THO PHUTHAO
        packline(""
        , u_x3(80, 45,'tstemw',18, 11,'tstemw',51, (53,1),'tstemw',55, 81)
        , th_kho_khwai(45, 39,38,23, 29,35,[65,59,26], 11)
        , srp0(11)
        , 'SROUND 70'
        , mdrp0rg(8)
        , 'RTG'
        , head1(2,[77,71])
        , add_ip(45,51,[47,48,49,14,15,16])
        , ix()
        , dh1(32)
        , dh2(5)
        , f_dstr(27,dh_dstr)
        #y
        , sy()
        , mdap(1)
        , alignrp(38)
        , tstemt_1(23)
        , shprp2(53)
        , tvt2(55)
        , v_top_kho_khon(49,47,[45,18,12,51], 14,16, 15,48, 32,26,[56,62])
        , srp0(1)
        , tvbc(5)
        , head1(11,[68,74,52,2])
        , f_dstr(2,"15+4 16+6 ")
        , iy()
        , dh1(29,8)
        , dh2(35)
        ),

    'uni0E13':    #NO NEN
        packline(""
        , trs_no_nu(36,38, 48,42,[70,64], 74)
        , ip_front_stem(73, 24,'tstemw',12, 38)
        , xhead2(18,52,58)
        , th_ko_kai(24,28,27,8,9,s0=73)
        , ip_round(24,38,1)
        , tstemw_1(34)
        , shprp2(0)
        , add_ip(28,34,[31,5])
        , ix()
        , dh1(15)
        , dh2(21,45)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(35)
        , tvt2(38)
        , tvtc2(31,[25,27,28,8,9,10,12,2,34])
        , tstemt_2(5)
        , srp0(1)
        , tvbc(21)
        , alignrp(45)
        , head1((15,39),[(49,61),(55,67),36,48])
        , iy()
        , dh2(18,42)
        ),

    'uni0E14':    #DO DEK
        packline(""
        , thw0(54, 35,8, 1,41, 55, fround=68)
        , th_kho_khwai(35, 29,28,13, 19,25,[51,45,16], 1)
        , add_ip(35,41,[38,5])
        , ix()
        , dh1(22)
        , f_dstr(17,dh_dstr)
        #y
        , sy()
        , mdap(1)
        , alignrp(28)
        , tstemt_1(13)
        , v_top_kho_khwai(38,[35,8,2,41],5,22,16,[42,48])
        , iy()
        , dh1(19)
        , dh2(25)
        ),

    'uni0E15':    #TO TAO
        packline(""
        , thw0(54, 35,8, 1,41, 55, fround=68)
        , th_kho_khwai(35, 29,28,13, 19,25,[51,45,16], 1)
        , add_ip(35,41,[38,5])
        , ix()
        , dh1(22)
        , f_dstr(17,dh_dstr)
        #y
        , sy()
        , mdap(1)
        , alignrp(28)
        , tstemt_1(13)
        , v_top_kho_khon(39,37,[35,8,2,41], 4,6, 5,38, 22,16,[42,48])
        , iy()
        , dh1(19)
        , dh2(25)
        ),

    'uni0E16':      #THO THUNG
        packline(""
        , thw2(47, 24,12, 18,38,44, 1, 34, 48)
        , th_ko_kai(24, 28,27, 8,9, s0=47)
        , ix()
        , dh1(15)
        , dh2(21)
        #y
        , sy()
        , mdap(1)
        , tvtc2(31,[25,27,28,8,9,10,12,2,34])
        , tstemt_2(5)
        , srp0(1)
        , tvbc(21)
        , head1(15,[35,41])
        , iy()
        , dh2(18)
        ),

    'uni0E17':      #THO THAHAN
        packline(""
        , thw1(43, 16,40,34, 10,(22,9), 1,30, 44)
        , add_ip(22,2,[8])
        , mdrpg(24) 
        , ix()
        , dh1(19)
        , dh2(13)
        #y
        , sy()
        , mdap(1)
        , alignrp(9)
        , tvtc2(19,[23,24,8,2,30])
        , alignrp(27)
        , tstemt_2(5)
        , head2(13,[31,37])
        #, f_dstr(23,"14-4 15-5 16-6 ")
        , iy()
        , dh1(16)
        ),

    'uni0E18':      #THO THONG
        packline(""
        , thw0(32, 1,3, 5,31, 33)
        , add_ip(32,1,[9])
        , srp0(9)
        , tstemw_1(28)
        , srp0(33)
        , mdrpmrw(19)
        , add_ip(9,19,[12,25,22,15])
        , ix()
        #y
        , sy()
        , mdap(1)
        , tstemt_1(4)
        , v_top_ro_rua(12,[9,28,29,8,6,31,2], 25,22,15,18,19)
        , mdapr(2)
        , iy()
        ),

    'uni0E19':      #NO NU
        packline(""
        , trs_no_nu(15,17, 27,21,[49,43], 53)
        , ip_front_stem(52, 1,'tstemw',(14,0), 17)
        , xhead1(7,37,31)
        , ix()
        , dh1(10)
        , dh2(24,4)
        #y
        , sy()
        , mdap(0)
        , tstemt_1(14)
        , tvt2(17)
        , tvtc2(10)
        , head2(4,[28,34])
        , srp0(0)
        , tvbc(24)
        , head1(18,[40,46,15,27])
#        , f_dstr(27,"15+4 16+4 ")
        , iy()
        , dh1(7)
        , dh2(21)
        ),  

    'uni0E1A':      #BO BAIMAI
        packline(""
        , thw1(30, 7,27,21, 1,13, 15,17, 31)
        , ix()
        , dh1(10)
        , dh2(4)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(14)
        , tvt2(17)
        , tvtc2(10)
        , head2(4,[18,24])
        , iy()
        , dh1(7)
        ),

    'uni0E1B':      #PO PLA
        packline(""
        , thw1(30, 7,27,21, 1,13, 15,17, 31)
        , ix()
        , dh1(10)
        , dh2(4)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(14)
        , tvtpo(17)
        , tvtc2(10)
        , head2(4,[18,24])
        , iy()
        , dh1(7)
        ),

    'uni0E1C':      #PHO PHUNG
        packline(""
        , thw2(35, 4,16, 11,26,32, 20,22, 36)
        , add_ip(4,22,[3,2,1,18,19,2])
        , ix()
        , dh1(8)
        , dh2(14)
        #y  
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvt2(22)
        , tvtc2(8,[17])
        , head2(14,[23,29])
        , add_ip(14,1,[18,2])
        , f_dstr(17,"14-4 15-5 16-6 ")
        , srp0(17)
        , alignrp(20)
        , iy()
        , dh2(11)
        ),  

    'uni0E1D':      #FO FA
        packline(""
        , thw2(35, 4,16, 11,26,32, 20,22, 36)
        , add_ip(4,22,[3,2,1,18,19,2])
        , ix()
        , dh1(8)
        , dh2(14)
        #y  
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvtpo(22)
        , tvtc2(8,[17])
        , head2(14,[23,29])
        , add_ip(14,1,[18,2])
        , f_dstr(17,"14-4 15-5 16-6 ")
        , srp0(17)
        , alignrp(20)
        , iy()
        , dh2(11)
        ),  

    'uni0E1E':      #PHO PHAN
        packline(""
        , thw1(35, 10,32,26, 4,(16,3), (20,1),22, 36)
        , add_ip(16,20,[18,19,2])
        , ix()
        , dh1(13)
        , dh2(7)
        #y
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvt2(22)
        , tvtc2(13,[2,17,18,19,20])
        , head2(7,[23,29])
        , iy()
        , dh1(10)
        , f_dstr(2,"14+3 15+3 16+6 ")
        ),

    'uni0E1F':      #FO FAN
        packline(""
        , thw1(35, 10,32,26, 4,(16,3), (20,1),22, 36)
        , add_ip(16,20,[18,19,2])
        , ix()
        , dh1(13)
        , dh2(7)
        #y
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvtpo(22)
        , tvtc2(13,[2,17,18,19,20])
        , head2(7,[23,29])
        , iy()
        , dh1(10)
        , f_dstr(2,"14+3 15+3 16+6 ")
        ),

    'uni0E20':    #PHO SAMPHAO
        packline(""
        , thw1(47, 19,44,38, 24,12, 1,34, 48)
        , th_ko_kai(24,28,27,8,9)
        , add_ip(28,34,[31,5])
        , ix()
        , dh1(22)
        , dh2(16)
        #y
        , sy()
        , mdap(1)
        , tvtc2(31,[25,27,28, 8,9,10,12, 2,34])
        , tstemt_2(5)
        , srp0(1)
        , tvbc(16)
        , head1(22,[35,41])
        , iy()
        , dh1(19)
        ),

    'uni0E21':      #MO MA
        packline(""
        , thw1(54, (19,8),(39,51),(33,45), 13,(25,2), (27,1),29, 55)
        , ix()
        , dh1(22,11)
        , dh2(16,5)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(27)
        , tvt2(29)
        , tvtc2(22)
        , head2(16,[30,36])
        , srp0(1)
        , tvbc(5)
        , head1(11,[42,48,26,2])
        , iy()
        , dh1(19,8)
        , f_dstr(2,"14+3 15+3 16+3 ")
        ),
    
    'uni0E22':    #YO YAK
        packline(""
        , thw2(44, (1,8),(27,19), 14,35,41, 29,31, 45)
        , srp0(1)
        , mdrprg(24)
        , f_ip([5])
        , ix()
        , dh1(11)
        , dh2(17)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(28)
        , tvt2(31)
        , tvtc2(11)
        , head2(17,[32,38,19])
        , mdrp0mrg(23)
        , tstemt_2(24)
        , f_ip([5])
        , iy()
        , dh2(14)
        ),

    'uni0E23':    #RO RUA
        packline(""
        , thw0(54, 12,35, 8,38, 55)
        , srp0(8)
        , xhead1(3,51,45)
        , srp0(55)
        , mdrpmrw(24)
        , add_ip(12,24,[15,32,27,20])
        , ix() 
        , dh1(6)
        , dh2(0)
        #y
        , sy() 
        , mdap(54)
        , v_top_ro_rua(15,[12,35,36,11,9,38], 32, 27,20, 23,24)
        , srp0(54)
        , tvbc(0)
        , head1(6,[42,48])
        , iy()
        , dh1(3)
        ),  

    'uni0E24':      #RU
        packline(""
        , thw2(47, 24,12, 18,38,44, 1, 34, 48)
        , th_ko_kai(24, 28,27, 8,9, s0=47)
        , add_ip(28,34,[31,5])
        , ix()
        #y
        , sy()
        , mdap(47)
        , tvtc2(31,[25,27,28,8,9,10,12,2,34])
        , tstemt_2(5)
        , srp0(47)
        , tvbc(21)
        , head1(15,[35,41])
        , srp0(47)
        , tvblu(1)
        , iy()
        , dh2(18)
        ),

    'uni0E25':      #LO LING
        packline(""
        , thw2(54, 20,8, 14,45,51, (1,27),41, 55)
        , add_ip(54,20,[35])
        , add_ip(20,27,[24,5])
        , add_ip(35,41,[38,31])
        , ix()
        , dh1(11)
        , dh2(17)
        #y
        , sy()
        , mdap(1)
        , tvtc2(38,[21,8,28,41,27,24,34])
        , tstemt_2(31)
        , mdapr(34)
        , mdapr(24)
        , tstemt_2(5)
        , srp0(1)
        , tvbc(17)
        , head1(11,[42,48])
        , iy()
        , dh2(14)
        ),

    'uni0E26':    #LU
        packline(""
        , thw1(47, 19,44,38, 24,12, 1,34, 48)
        , th_ko_kai(24,28,27,8,9)
        , add_ip(28,34,[31,5])
        , ix()
        , dh1(22)
        , dh2(16)
        #y
        , sy()
        , mdap(47)
        , tvtc2(31,[25,27,28, 8,9,10,12, 2,34])
        , tstemt_2(5)
        , srp0(47)
        , tvbc(16)
        , head1(22,[35,41])
        , srp0(47)
        , tvblu(1)
        , iy()
        , dh1(19)
        ),

    'uni0E27':    #WO WAEN
        packline(""
        , thw0(38, 16,15, 8,22, 39, fstem='headstem')
        , srp0(8)
        , xhead1(3,35,29)
        , add_ip(16,22,[19,12])
        , ix()
        , dh1(6)
        , dh2(0)
        #y
        , sy()
        , mdap(38)
        , tvtc2(19,[9,22,15])
        , tstemt_2(12)
        , mdapr(15)
        , srp0(38)
        , tvbc(0)
        , head1(6,[26,32])
        , iy()
        , dh1(3)
        ),  

    'uni0E28':    #SO SALA
        packline(""
        , thw0(67, 42,14, 1,54, 68, fround=68)
        , th_kho_khwai(42, 36,35,17, 20,26,[64,58,32], 1)
        , add_ip(42,54,[45,11,47,52,9,4])
        , dx(9,8)
        , dx(52,-8)
        , ix()
        , dh1(23)
        , dh2(29)
        #y
        , sy()
        , mdap(1)
        , alignrp(35)
        , v_top_kho_khwai(45,[42,14,2,54,47,9,52,4,17], 11, 23,29,[55,61,32,20],add1=mdrpmrg(50))
        , dx(32,8)
        , dx(17,-16)
        , dx(4,8)
        , dx(47,-8)
        , iy()
        , dh2(26)
        , f_dstr_dict({47:"14-4 15-4 16-4 ", 4:"14+4 15+4 16+4 "})
        ),

    'uni0E29':      #SO RUSI
        packline(""
        , thw1(65, 7,50,44, 1,13, (15,32),(40,34), 66)
        , srp0(32)
        , mdrp0mrw(27)
        , mdrprg(21)
        , f_ip([62,56,30])
        , ix()
        , dh1(10,24)
        , dh2(4)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(14)
        , tvt2(34)
        , tvtc2(10,[24])
        , head2(4,[41,47])
        , mdapr(24)
        , mdrp0rg(18)
        , f_ip([53,59,30,32,16,40,35])
        , dx(16,8)
        , dx(35,-8)
        , iy()
        , dh1(7,21)
        ),

    'uni0E2A':      #SO SUA
        packline(""
        , thw2(66, 20,8, 14,57,63, (1,27),53, 67)
        , add_ip(66,20,[41])
        , add_ip(20,27,[24,5])
        , add_ip(41,53,[44,37,46,51,35,30])
        , dx(35,8)
        , dx(51,-8)
        , ix()
        , dh1(11)
        , dh2(17)
        #y
        , sy()
        , mdap(1)
        , tvtc2(44,[21,8,28,53,8,24,40,27])
        , mdrpmrg(49)
        , tstemt_2(37)
        , mdapr(40)
        , mdapr(24)
        , tstemt_2(5)
        , srp0(1)
        , tvbc(17)
        , head1(11,[54,60])
        , dx(30,8)
        , dx(46,-8)
        , iy()
        , dh2(14)
        , f_dstr_dict({46:"14-4 15-4 16-4 ", 30:"14+4 15+4 16+4 "})
        ),

    'uni0E2B':      #HO HIP
        packline(""
        , thw1(61, 14,46,40, 8,(20,7), 1,36, 62)
        , add_ip(20,2,[6])
        , srp0(6)
        , mdrpg(22) 
        , srp0(36)
        , mdrp0rg(32)
        , 'SROUND 70'
        , mdapr(32)
        , 'RTG'
        , head2(26,[58,52,24,34,4])
        , ix()
        , dh1(17,29)
        , dh2(11)
        #y
        , sy()
        , mdap(1)
        , alignrp(7)
        , tvtc2(17,[21,22,6,2,36])
        , alignrp(29)
        , head2(11,[(37,49),(43,55)])
        , srp0(49)
        , tstemt_2(4)
        , f_ip([24,34])
        , f_dstr(21,"14-4 15-5 16-6 ")
        , iy()
        , dh1(14,26)
        , dh2(32)
        ),

    'uni0E2C':      #LO CHULA
        packline(""
        , thw1(64, 10,49,43, 4,(16,3), (20,1),39, 65)
        , srp0(20)
        , xhead1(26,61,55)
        , add_ip(16,20,[18,19,2])
        , ix()
        , dh1(13,29)
        , dh2(7,23)
        #y
        , sy()
        , mdap(1)
        , alignrp(3)
        , tvtc2(13,[2,17,18,19,20])
        , head2(7,[40,46])
        , srp0(1)
        , mirp0rg("ecvheight_shoot",29)
        , head2(23,[52,58,39,32])
        , iy()
        , dh1(10,26)
        , f_dstr(2,"14+3 15+3 16+6 ")
        ),

    'uni0E2D':      #O ANG
        packline(""
        , thw2(42, 1,13, 8,33,39, 15,29, 43)
        , add_ip(42,1,[23])
        , add_ip(23,29,[26,19])
        , ix()
        , dh1(5)
        , dh2(11)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(14)
        , tvtc2(26,[22,16,29])
        , tstemt_2(19)
        , mdapr(22)
        , mdrp0mrw(5)
        , head2(11,[30,36])
        , iy()
        , dh2(8)
        ),  

    'uni0E2E':      #HO NOKHUK
        packline(""
        , thw2(58, (1,23),(13,43), 8,49,55, 15,35, 59)
        , add_ip(23,35,[26,40,36,20, 38,33,28])
        , dx(38,24)
        , dx(33,-16)
        , ix()
        , dh1(5)
        , dh2(11)
        #y
        , sy()
        , mdap(1)
        , tstemt_1(14)
        , tvtc2(26,[16,35])
        , tstemt_2(40)
        , mdrp0rg(20)
        , f_ip([28,38,33,18])
        , stemt_sara_1(36)
        , mdrp0mrw(5)
        , head2(11,[46,52])
        , iy()
        , dh2(8)
        ),

    'uni0E2F':      #PAIYAN NOI
        packline(""
        , thw0(36, 8,17, (1,22),23, 37, fstem='headstemplushole')
        , head1(14,[33,27,17])
        , ix()  
        , dh1(11)
        #y  
        , sy()
        , mdap(1)
        , tvt2(23)
        , tvtc2(11,[2])
        , head2(17,[24,30])
        , mdrp0rg(19)
        , tstemt_2(5)
        , iy()
        , dh2(14)
        ),  

    'uni0E30':      #SARA A
        packline(""
        , srp0(60)
        , 'SROUND 70'
        , mdrp0rw(3)
        , 'RTG'
        , alignrp(33)
        , head1((9,39),[(27,57),(21,51)])
        , mdapr(61)
        , mdrp0mrg(15)
        , alignrp(45)
        , ix()
        , dh1(36,6)
        #y  
        , sy()
        , mdapr(0)
        , tstemt_1(11)
        , xhead2(6,24,18)
        , mdrprg(14)
        #
        , mdapr(30,"11+8 ")
        , tstemt_1(41)
        , xhead2(36,54,48)
        , mdrprg(44)
        , iy()
        , dh1(3,33)
        , dh2(39,9)
        ),

    'uni0E31':      #MAI HAN-AKAT
        packline(""
        , mdapr(3)
        , mdrprg(15)
        , head1(9,[27,21])
        , ix()
        , dh1(6)
        #y  
        , sy()
        , tvtsara(0)
        , tstemt_1(11)
        , xhead2(6,24,18)
        , mdrprg(14)
        , iy()
        , dh1(3)
        , dh2(9)
        ),

    'uni0E32':    #SARA AA
        packline(""
        , thw0(16, 9,8, 1,15, 17, fstem='headstem')
        , add_ip(9,15,[12,5])
        , ix()
        #y
        , sy()
        , mdap(1)
        , tvtc2(12,[8,2,15])
        , tstemt_2(5)
        , mdapr(8)
        , iy()
        ),  

    'uni0E34':    #SARA I
        packline(""
        , thbsara(0)
        , tstemw_2(9)
        , mdrp0rg(3)
        , tstemw_1(15)
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , mirp0rg("tstemw",15)
        , f_ip([3,9])
        , mdrp0rw(12)
        , stemw_sara_1(6)
        , iy()
        ),
    
    'uni0E35':    #SARA II
        packline(""
        , thbsara(0)
        , tstemw_2(12)
        , tstemtc_2(10)
        , mdrp0rg(3)
        , tstemw_1(18)
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , mirp0rg("tstemw",18)
        , f_ip([3,12])
        , mdrp0rw(15)
        , stemw_sara_1m(6)
        , mdrpmrg(11)
        , mdapr(11)
        , iy()
        ),
    
    'uni0E36':    #SARA UE
        packline(""
        , thbsara(0)
        , tstemw_2(19)
        , mdrp0mrg(14)
        , headsara2(8,[37,31])
        , srp0(0)
        , mdrp0rg(3)
        , tstemw_1(25)
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , mirp0rg("tstemw",25)
        , f_ip([3,19])
        , mdrp0mrg(22)
        , stemw_sara_1m(6)
        , mdrp0rw(11)
        , mdapr(11)
        , headsara2(17,[28,34])
        , iy()
        ),

    'uni0E37':    #SARA UUE
        packline(""
        , thbsara(0)
        , tstemw_2(16)
        , tstemt_2m(14)
        , mdrp0mrg(11)
        , mdapr(11)
        , tstemt_2(9)
        , srp0(0)
        , mdrp0rg(3)
        , tstemw_1(22)
        , ix()
        #y  
        , sy()   
        , tvtsara(0)
        , mirp0rg("tstemw",22)
        , f_ip([3,16])
        , mdrp0rw(19)
        , f_ip([11,13])
        , stemw_sara_1m(6)
        , mdrpmrg(10)
        , mdapr(10)
        , shprp2(15)
        , iy()
        ),  

    'uni0E38':    #SARA U
        packline(""
        , thbsara(13)
        , stemw_sara_2(1)
        , mdrpmrg(7)
        , f_ip([23,17])
        , ix()
        #y  
        , sy()
        , mdap(26) 
        , mdrp0mrw(10)
        , head_sara_2m(4)
        , f_ip([14,20])
        , mdrpmrg(1)
        , iy()
        ),  

    'uni0E39':    #SARA UU
        packline(""
        , thbsara(17)
        , stemw_sara_2m(15)
        , mdrp0mrw(13)
        , mdapr(13)
        , stemw_sara_2(1)
        , mdrpmrg(7)
        , f_ip([27,21])
        , ix() 
        #y  
        , sy()
        , mdap(30)
        , mdrp0mrw(10)
        , mdrprg(17)
        , mdrp0rg(4)
        , alignrp(14)
        , f_ip([24,18])
        , stemt_sara_2(1)
        , iy()
        ),

    'uni0E3A':    #PHINTHU
        packline(""
        , thbsara(9)
        , mdrpmrg(3)
        , ix() 
        #y  
        , sy()
        , mdap(12)
        , mdrp0mrw(6)
        , mdrpmrg(0)
        , iy() 
        ),

    'uni0E3F':    #THAI CURRENCY SYMBOL BAHT
        packline(""
        , thw0(49, 3,(26,39), 30,18, 50, fround=70, fstem='ecstemt', rstem='ecstemtc')
        , srp0(30)
        , mdrp0g(43)
        , ecstemtc_1(12)
        , ip_middle_stem(26, (23,1,36,5),'headstem',(34,22,47,7), 43)
        , ix()
        #y  
        , sy()
        , mdapr(2)
        , alignrp(22)
        , mdrpmrg(1)
        , stemw_sara_1(23)
        , shprp2(35)
        , mdapr(5)
        , alignrp(8)
        , mdrpmrg(6)
        , stemw_sara_2(37)
        , shprp2(47)
        , ip_middle_stem(5, (36,48),'stemw_sara',(24,34), 23)
        , f_ip([15])
        , iy()
        ),

    'uni0E40':    #SARA E
        packline(""
        , u_x1f(26, 3,'tstemw',5, 11, 27)
        , xhead2(11,17,23)
        , ix()
        , dh1(8)
        , dh2(0)
        #y  
        , sy()
        , mdap(26)
        , tvt2(5)
        , tvbc(0)
        , head1(8,[14,20])
        , iy()
        , dh2(11)
        ),

    'uni0E42':    #SARA O
        packline(""
        , u_x1f(54, 3,'tstemw',33, 39, 55)
        , xhead2(39,45,51)
        , ip_round(54,3,7)
        , tstemw_1(30)
        , mdrprg(19)
        , f_ip([10,27,15,22])
        , ix()
        , dh1(36)
        , dh2(0)
        #y  
        , sy()
        , mdap(54)
        , tvbc(0)
        , head1(36,[42,48])
        #
        , mdap(10)
        , tstemt_2(27)
        , 'RTDG'
        , mdrp0rg(22)
        , 'RTG'
        , tstemt_1(15)
        , srp0(10)
        , mdrp0rg(18)
        , tstemt_2(19)
        , add_ip(10,0,[7,30,6,31,4,33])
        , iy()   
        , dh2(39)
        ),

    'uni0E43':    #SARA AI MAI MUAN
        packline(""
        , u_x1f(67, 3,'tstemw',34, 40, 68)
        , xhead2(40,46,52)
        , mdrp0rg(9)
        , tstemw_1(29)
        , mdrp0mrw(17)
        , 'SROUND 70'
        , mdrpmrb(58)
        , 'RTG'
        , mdrp0rg(23)
        , 'SROUND 70'
        , mdrpmrb(64)
        , 'RTG'
        , ix()
        , dh1(37)
        , dh2(20,0)
        #y  
        , sy()
        , mdap(67)
        , tvbc(0) 
        , head1(37,[43,49])
        #
        , mdap(26)
        , tstemt_2m(12)
        , mdrp0rg(14,"11+8 12+8 13+8 14+8 15+8 16+8 ")
        , 'SROUND 70'
        , mdrpmrb(61)
        , 'RTG'
        , mdrp0rg(20,"11-8 15-8 16-8 ")
        , 'SROUND 70'
        , mdrpmrb(55)
        , 'RTG'
        , iy()
        , dh2(17,40)
        ),

    'uni0E44':    #SARA AI MAIMALAI
        packline(""
        , u_x1f(48, 3,'tstemw',27, 33, 49)
        , xhead2(33,39,45)
        , srp0(3)
        , mdrprg(15)
        , f_ip([16,19,12,21,9,24,7])
        , ix()
        , dh1(30)
        , dh2(0)
        #y  
        , sy()
        , mdap(48)
        , tvbc(0)
        , head1(30,[36,42])
        #
        , mdap(24)
        , tstemtc_2(7)
        , mdrprg(16)
        , mdrp0rg(12)
        , tstemt_1(19)
        , iy()
        , dh2(33)
        ),

    'uni0E45':    #LAKKHANGYAO
        packline(""
        , u_x1(16, 1,'tstemw',15, 17)
        , mdrp0rg(9)
        , mirpmb('headstem',8)
        , add_ip(9,15,[12,5])
        , ix()
        #y
        , sy()
        , mdap(16)
        , tvtc2(12,[8,2,15])
        , tstemt_2(5)
        , mdapr(8)
        , srp0(16)
        , tvblu(1)
        , iy()
        ),

    'uni0E46':    #MAIYAMOK
        packline(""
        , thw0(38, 19,8, 1,25, 39, fstem='tstemt')
        , head1(13,[35,29])
        , add_ip(19,25,[21,22,23,4,5,6])
        , ix()
        , dh1(10)
        , dh2(16)
        #y
        , sy()
        , mdap(38)
        , tvtc2(21,[2,25])
        , alignrp(23)
        , tstemt_2(6)
        , shprp2(4)
        , 'RUTG'
        , mdrp0rg(5)
        , 'RTG'
        , tstemt_1(22)
        , mdrp0rg(10)
        , mdapr(10)
        , head2(16,[26,32])
        #
        , srp0(38)
        , tvblu(1)
        , iy()
        , dh2(13)
        ),

    'uni0E47':    #MAITAIKHU
        packline(""
        , mdap(41)
        , mdrprg(17)
        , mdrprg(35,"10-8 16+8 ")
        , f_ip([53,47])
        , mdrp0rg(10)
        , f_ip([26,29,5,3])
        , stemw_sara_1(23)
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , alignrp(7)
        , stemt_sara_1(26)
        , mdrprg(38,"9-4 10-4 15-8 16-8 20-8 21-8 ")
        , f_ip([44,50,32,3,29])
        , mdrp0mrg(20)
        , stemt_sara_1m(13)
        , mdrpmrg(16)
        , iy()
        ),

    'uni0E47.high':    #MAITAIKHU
        packline(""
        , mdap(44)
        , mdrprg(19)
        , mdrprg(38)
        , f_ip([56,50])
        , mdrp0rg(12)
        , f_ip([25,28,31,9,5])
        , ix()
        #y
        , sy()
        , tvtwanayuk(0)
        , alignrp(9)
        , mdrprg(41)
        , f_ip([47,53,31,5,28,36])
        , mdrprg(16)
        , f_ip([21])
        , iy()
        ),

    'uni0E48':    #MAI EK
        packline(""
        , mdap(0)
        , tstemt_2(1)
        , ix()
        #y
        , sy()
        , tvtwanayuk(0)
        , mdrpmg(3)
        , iy()
        ),

    'uni0E48.low':    #MAI EK
        packline(""
        , thbsara(0)
        , stemw_sara_2(1)
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , mdrpmg(3)
        , iy()
        ),

    'uni0E49':    #MAI THO
        packline(""
        , mdap(15)
        , mdrprg(22)
        , mdrprg(2)
        , f_ip([9,34,28,6,18])
        , ix()
        #y
        , sy()
        , tvtwanayuk(0)
        , mdrp0rg(6)
        , f_ip([3,18])
        , mdrp0rg(12)
        , f_ip([31,25,21])
        , iy()
        ),

    'uni0E49.low':    #MAI THO
        packline(""
        , mdap(15)
        , mdrprg(22)
        , headsara2(9,[34,28,6,18])
        , mdrprg(2)
        , ix()
        , dh1(12)
        , f_dstr_dict({19:"15+5 16+5 ", 7:"15+6 16+6 "}) 
        #y
        , sy()
        , tvtsara(0)
        , stemt_sara_1(3)
        , shprp2(18)
        , mdrp0rg(6)
        , mdrprg(21)
        , headsara1(12,[25,31])
        , iy()
        , dh1(9)
        , dh2(15)
        ),

    'uni0E4A':    #MAI TRI
        packline(""
        , mdap(29)
        , stemt_sara_2(4)
        , mdrprg(37)
        , mdrp0rg(21)
        , f_ip([24,25,26,6,7,8])
        , stemt_sara_2(10)
        , mdrprg(15,"12-8 18-8 ")
        , f_ip([50,44])
        , ix()
        #y
        , sy()
        , tvtwanayuk(1)
        , alignrp(18)
        , stemt_sara_1(2)
        , shprp2(32)
        , mdrprg(12,"11-8 12-8 13-8 14-8 16-8 ")
        , f_ip([41,47])
        , mdrp0rg(24)
        , alignrp(26)
        , mdrprg(36)
        , stemt_sara_2(8)
        , shprp2(6)
        , iy()
        , dx(25,-16)
        ),

    'uni0E4A.low':    #MAI TRI
        packline(""
        , mdap(29)
        , stemw_sara_2(4)
        , mdrprg(37)
        , mdrp0rg(21)
        , f_ip([24,25,26,6,7,8])
        , stemw_sara_2(10)
        , mdrprg(15,"15-8 16-8 ")
        , f_ip([50,44])
        , ix()
        , dh1(12)
        , dh2(18)
        #y
        , sy()
        , tvtsara(1)
        , alignrp(18)
        , stemt_sara_1(2)
        , shprp2(32)
        , mdrprg(12,"11-8 12-8 13-8 14-8 16-8 ")
        , f_ip([41,47])
        , mdrp0rg(24)
        , alignrp(26)
        , mdrprg(36)
        , stemt_sara_2(8)
        , shprp2(6)
        , iy()
        , dh1(21)
        , dh2(15)
        , dx(25,-16)
        ),

    'uni0E4B':    #MAI CHATTAWA
        packline(""
        , mdap(10)
        , mdrp0rg(11)
        , alignrp(7)
        , stemt_sara_2m(1)
        , alignrp(5)
        , mdrprg(3)
        , ix()
        #y  
        , sy()
        , tvtwanayuk(0)
        , mdrp0rg(11)
        , alignrp(2)
        , stemt_sara_1m(8)
        , alignrp(5)
        , mdrprg(7)
        , iy()
        ),

    'uni0E4B.low':    #MAI CHATTAWA
        packline(""
        , thbsara(10)
        , mdrp0rg(11)
        , alignrp(7)
        , stemw_sara_2m(1)
        , alignrp(5)
        , mdrprg(3)
        , ix()
        #y  
        , sy()
        , tvtsara(0)
        , mdrp0rg(11)
        , alignrp(2)
        , stemw_sara_1m(8)
        , alignrp(5)
        , mdrprg(7)
        , iy()
        ),

    'uni0E4C':    #THANTHAKAT
        packline(""
        , mdap(17)
        , mdrprg(11)
        , mdrprg(3)
        , f_ip([29,23])
        , ix()
        #y  
        , sy()
        , tvtwanayuk(0)
        , mdrp0rg(6)
        , f_ip([20,26])
        , mdrpmrg(10)
        , stemt_sara_2(14)
        , iy()
        ),

    'uni0E4C.low':    #THANTHAKAT
        packline(""
        , mdap(14)
        , mdrprg(10)
        , headsara2(3,[26,20])
        , ix()
        #y  
        , sy()
        , tvtsara(0)
        , headsara1(6,[17,23])
        , mdrpmrg(9)
        , stemt_sara_2(12)
        , iy()
        ),

    'uni0E4D':    #NIKHAHIT
        packline(""
        , mdap(9)
        , head2(3,[21,15])
        , ix()
        #y
        , sy()
        , tvtsara(0)
        , head1(6,[12,18])
        , iy()
        ),

    'uni0E4D.high':    #NIKHAHIT
        packline(""
        , mdap(9)
        , mdrprg(8)
        , f_ip([21,15])
        , ix()
        #y
        , sy()
        , tvtwanayuk(0)
        , mdrprg(6)
        , f_ip([12,18])
        , iy()
        ),

    'uni0E4E':    #YAMAKKAN
        packline(""
        , thbsara(15)
        , mdrp0rg(10)
        , f_ip([25,34,7])
        , stemw_sara_1(21)
        , mdrp0rg(4)
        , stemw_sara_1(30)
        , ix()
        #
        , sy()
        , tvtsara(0)
        , stemt_sara_1(33)
        , mdrp0rg(13)
        , f_ip([24])
        , stemt_sara_2(18)
        , mdapr(24)
        , stemt_sara_2(27)
        , f_ip([7])
        , iy()
        ),

    'uni0E4F':    #FONGMAN
        packline(""
        , mdapr(37) 
        , mdrp0mrw(9)
        , tstemw_2m(15)
        , mdrpmrw(33)
        , srp0(9)
        , mdrp0rg(3)
        , tstemw_1m(21)
        , mdrpmrw(27)
#        , add_ip(27,33,[45,39])
        , ix()
        #y  
        , sy()
        , mdapr(0) 
        , tstemw_1m(12)
        , mdrpmrw(24)
        , srp0(0)
        , mdrp0rg(6)
        , tstemw_2m(18)
        , mdrpmrw(30)
#        , add_ip(30,24,[36,42])
        , iy()
        ),

    'uni0E50':    #THAI DIGIT ZERO
        packline(""
        , thw0(24, 3,21, 15,9, 25)
        , ix()
        #y  
        , sy()
        , mdap(24)
        , tvtnc(6)
        , tstemt_2(18)
        , srp0(24)
        , tvbc(0)
        , tstemt_1(12)
        , iy()
        ),

    'uni0E51':    #THAI DIGIT ONE
        packline(""
        , thw0(48, 3,22, 16,9, 49)
        , ip_round(3,16,27)
        , mdapr(27)
        , mdrpmrg(13)
        , head1(33,[45,39])
        , ix()
        , dh1(30)
        #y  
        , sy()
        , mdapr(13)
        , tstemtc_2(12)
        , tvtnc(6,[0,3,22,16,9])
        , tstemtc_2(19)
        , mdapr(0)
        , tstemtc_1(25)
        , mdrp0rg(30)
        , xhead0(42,36,direction='-')
        , iy()
        , dh1(27)
        , dh2(33)
        ),

    'uni0E52':    #THAI DIGIT TWO
        packline(""
        , thw0(54, 4,12, 17,41, 55)
        , ip_round(4,17,35)
        , tstemw_1(24)
        , head1(29,[51,45])
        , add_ip(35,41,[37,38,39,20,21,22])
        , ix()
        , dh1(26)
        , dh2(32)
        #y  
        , sy()
        , mdap(0)
        , tstemt_1(16)
        , tvtnc(39)
        , alignrp(37)
        , mdrpmrg(9)
        , tstemt_2(20)
        , shprp2(22)
        , 'RUTG' , mdrp0mrg(21), 'RTG'
        , mdrpb(38)
        , srp0(39)
        , mdrp0rg(26)
        , mdapr(26)
        , head2(32,[42,48])
        , iy()
        , dh2(29)
        ),

    'uni0E53':    #THAI DIGIT THREE
        packline(""
        , thw0(60, 33,17, 4,45, 61)
        , xhead2(24,51,57)
        , ip_round(33,4,11)
        , tstemw_1(10)
        , f_ip([39])
        , ix()
        , dh1(21)
        , dh2(27)
        #y  
        , sy()
        , mdap(1)
        , tvtnc(42,[33,17,11,39,4,45])
        , alignrp(36)
        , tstemt_2(7)
        , shprp2(14)
#        , mdapr(11)
        , srp0(1)
        , tvbc(27)
        , head1(21,[48,54])
        , iy()
        , dh2(24)
        ),

    'uni0E54':    #THAI DIGIT FOUR
        packline(""
        , u_x1f(57, 10,'tstemw',25, 44, 58)
        , ip_round(10,44,32)
        , head1(38,[54,48,30,41])
        , srp0(44)
        , mdrprg(18)
        , ix()
        , dh1(35)
        #y  
        , sy()
        , mdap(0)
        , tstemt_1(44)
        , tvtn(14,[10,25])
        , mdrprg(17)
        , tstemt_2(21)
        , srp0(0)
        , mdrp0rg(35,"18-8 ")
        , f_ip([30,41])
        , xhead0(51,45,direction='-')
        , srp0(0)
        , tvbc(7)
        , tstemtc_1(28)
        , iy()
        , dh1(32)
        , dh2(38)
        ),

    'uni0E55':    #THAI DIGIT FIVE
        packline(""
        , u_x1f(78, 10,'tstemw',34, 53, 79)
        , ip_round(10,53,41)
        , head1(47,[63,57,39,50])
        , srp0(53)
        , mdrprg(27)
        , srp0(41)
        , mdrp0rg(15)
        , head1(21,[75,69,13,23])
        , ix()
        , dh1(44,18)
        #y  
        , sy()
        , mdap(0)
        , tstemt_1(53)
        , tvtn(23,[10,34])
        , alignrp(13)
        , mdrprg(26)
        , tstemt_2(30)
        , mdrp0rg(18,"18-8 ")
        , xhead0(72,66,direction='-')
        , srp0(0)
        , mdrp0rg(44,"18-8 ")
        , f_ip([39,50])
        , xhead0(60,54,direction='-')
        , srp0(0)
        , tvbc(7)  
        , tstemtc_1(37)
        , iy()
        , dh1(47,21)
        , dh2(41,15)
        ),

    'uni0E56':    #THAI DIGIT SIX
        packline(""
        , thw0(55, 27,34, 20,40, 56, fstem='stemt_sara')
        , mdrprg(30)
        , mdrp0rg(6)
        , head1(12,[52,46])
        , ix()
        , dh1(9)
        #y  
        , sy()
        , mdap(55)
        , tvtnc(37,[20,40]) 
        , tstemt_2(23)
        , mdrp0rg(31)
        , mdrpg(30)
        , srp0(55)
        , tvbc(0)
        , tstemt_1(17)
        , mdrp0rg(3)
        , head1(9,[43,49])
        , iy()
        , dh1(6)
        , dh2(12)
        ),

    'uni0E57':    #THAI DIGIT SEVEN
        packline(""
        , thw0(70, 34,17, 52,54, 71)
        , ip_middle_stem(34, 4,'tstemw',46, 52)
        , ip_middle_stem(34, 11,'tstemw',10, 4)
        , f_ip([40])
        , srp0(34)
        , xhead2(25,61,67)
        , add_ip(17,11,[37,14])
        , add_ip(10,4,[43,7])
        , ix()
        , dh1(22)
        , dh2(28)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(49)
        , f_ip([2])
        , tvtnc(43,[34,17,40,4,46,11])
        , alignrp(37)
        , mdrprg(54)
        , tstemt_2(7)
        , shprp2(14)
        , srp0(1)
        , tvbc(28)
        , head1(22,[58,64])
        , iy()
        , dh2(25)
        ),

    'uni0E58':    #THAI DIGIT EIGHT
        packline(""
        , u_x1f(62, 4,'tstemw',19, 40, 63)
        , srp0(40)
        , head2(34,[59,53,31])
        , ip_round(19,34,0)
        , stemt_sara_2(22)
        , add_ip(0,40,[24,48,29,43])
        , srp0(40)
        , mdrprg(12)
        , ix()  
        , dh1(37)
        #y  
        , sy()
        , mdap(1)
        , tstemt_1(22)
        , tvtn(8,[4,19])
        , mdrprg(11)
        , tstemt_2(15)
        , srp0(1)
        , mdrp0rg(37)
        , head2(31,[50,56])
        , srp0(1)
        , tvbc(43)
        , tstemt_1(29)
        , mdrp0rg(24)
        , tstemt_2(48)
        , iy()
        , dh1(34)
        ),

    'uni0E59':    #THAI DIGIT NINE
        packline(""
        , thw0(64, 25,8, 1,0, 65)
        , xhead2(16,55,61)
        , add_ip(25,1,[2])
        , srp0(2)
        , tstemw_1(51)
        , f_ip([31])
        , add_ip(8,2,[28,5])
        , srp0(1)
        , mdrp0rg(40)
        , f_ip([34,4,37,44])
        , mdrpg(41)
        , ix()  
        , dh1(13)
        , dh2(19)
        #y  
        , sy()
        , mdap(1)
        , tvtnc(34,[25,8,2,51,31])
        , alignrp(28)
        , mdrprg(40)
        , tstemt_2(47)
        , shprp2(5)
        , mdrp0rg(44)
        , tstemt_1(37)
        , srp0(1)
        , tvbc(19)
        , head1(13,[52,58])
        , iy()
        , dh1(16)
        ),

    'uni0E5A':      #ANGKHANKHU
        packline(""
        , thw0(40, 8,17, 37,39, 41, fstem='ecstemwc')
        , head1(14,[33,27])
        , ip_middle_stem(8, (1,22),'tstemw',23, 37)
        , ix()
        , dh1(11)
        #y  
        , sy()
        , mdap(1)
        , alignrp(37)
        , tvt2(23)
        , shprp2(39)
        , tvtc2(11,[2])
        , head2(17,[24,30])
        , mdrp0rg(19)
        , tstemt_2(5)
        , iy()
        , dh2(14)
        ),

    'uni0E5B':      #KHOMUT
        packline(""
        , u_x1f(86, 3,'tstemw',27, 55, 87)
        , mdrp0rg(15)
        , xhead0(83,77)
        , mdrp0rg(9)
        , tstemtc_2(21)
        , add_ip(9,87,[33,71,39,65,45,59])
        , ix()
        , dh1(18)
        , dh2(12)
        #y  
        , sy()
        , mdapr(6)
        , tstemt_2(24)
        , mdapr(86)
        , tvbc(0)
        , tstemt_1m(30)
        , mdrp0mrw(12) 
        , mdapr(12)
        , head1(18,[74,80])
        , add_ip(24,30,[36,39,42,45,48, 71,68,65,62,59])
        , mdapr(53)
        , tstemt_2(56)
        , iy()
        , dh1(15)
        ),

    }



#++++++++++++++++++++++++++++++

#----- MODIFY pseudo_code_dict BY -----------
#----- SUBSTITUTE FUNCTION IN TEXT FORM -----
#----- TO REAL pseudo_code ------------------
from dttcmd import *

self_func = []
for i in dir():
    if callable(eval(i)): self_func.append(i)

for i in pseudo_code_dict.keys():
    p_list = pseudo_code_dict[i].split('\n')
    for j in range(len(p_list)):
        if '(' in p_list[j]:
            if p_list[j].split('(',1)[0] in self_func:
                l = [n for n in range(len(p_list[j])) if p_list[j][n] == ')']
                t = p_list[j][:l[-1]+1]
                p_list[j] = p_list[j].rep_listace(t, eval(t))
    pseudo_code_dict[i] = '\n'.join(p_list)
