#!/usr/bin/env python
import sys
import os
import dfont
from dttcmd import *

#pseudo_file = 'pseudo_code.txt'
#inst_file = 'inst.txt'
#
def usage():
    print '''
usage:
decoding:
    %s  -d FONTNAME | --decode-header FONTNAME | --decode-all FONTNAME

encoding:
    %s [ -inst | -mod ] [ -b ] -fFONTNAME [ CHARACTER | --all ]


decoding:
    -d      : use instruction code from gedit and decode to gedit

    --decode-header : get cvt value and fpgm in sfd file, 
                      generate header_FONTNAME.py

    --decode-all    : get cvt value and fpgm from header_FONTNAME.py
                      and decode instruction code from sfd file,
                      generate inst_FONTNAME.py

encoding:
    --inst  : use inst_FONTNAME.py to encode instruction code
    --mod   : use mod_FONTNAME.py to encode instruction code
            : otherwise use man_FONTNAME.py

    -b      : generate both instruction code and pseudo code to gedit
    
    --all   : process all characters in inst_|mod_|man_FONTNAME.py, 
              write changed in source file (.sfd) directly.

''' % (sys.argv[0],sys.argv[0])
    return


if __name__ == "__main__":
    filename = ''
    for i in sys.argv[1:]:
        if i[:2] == '-d' or i in ['--decode-header','--decode-all']:
            for j in sys.argv[1:]:
                if j[0] != '-':
                    filename = j
                    break
            break
        elif i[:2] == '-f':
            filename = i[2:]
            sys.argv.remove(i)
            break

    if not filename:
        usage()
        sys.exit(1)

    mod_filename = filename.replace('-','_')
    sfd_file = filename + '.sfd'

    #DECODE
    if '-d' in sys.argv:
        #$0 -d = DECODE CONTENT IN inst_file TO pseudo_file AND EDIT IT
        exec "from header_%s import *" % (mod_filename,)
        gedit_pseudo(cvt_dict,func_arg_list)
        sys.exit(0)
    elif '--decode-header' in sys.argv:
        dfont.gen_header_code(sfd_file)
        sys.exit(0)
    elif '--decode-all' in sys.argv:
        dfont.inst_decode_all(sfd_file)
        sys.exit(0)

    #ENCODE
    elif '-a' in sys.argv:
        #-a: USE CODE FROM AUTO-INSTUCTION IN FILE inst_FONTNAME.py
        sys.argv.remove('-a')
        exec "from inst_%s import *" % (mod_filename,)
    elif '-mod' in sys.argv:
        #-mod: USE CODE FROM MODIFIED AUTO-INSTUCTION mod_FONTNAME.py
        sys.argv.remove('-mod')
        exec "from mod_%s import *" % (mod_filename,)
    else:
        #default: USE MANUAL INSTRUCTION CODE (man_FONTNAME.py)
        exec "from man_%s import *" % (mod_filename,)

    #ALL CHARS
    if '--all' in sys.argv:    #find&replace in sfd file
        #$0 --all = ENCODE ALL CHARS
        print "Encoding all character in %s" % (sfd_file)
        dfont.inst_encode_all( sfd_file, pseudo_code_dict, cvt_dict )
    #ONE CHAR IN GEDIT
    elif '-b' in sys.argv:   #both pseudo code & instructed code
        sys.argv.remove('-b')
        txt = pseudo_code_dict[sys.argv[1]]
        gedit(txt,cvt_dict,1)
    else:           #instructed code
        txt = pseudo_code_dict[sys.argv[1]]
        gedit(txt,cvt_dict)
