#!/usr/bin/env python
from dttcmd import *

func_arg_list = [[2, 0], [1, 0], [3, 1], [1, 1], [4, 0], [0, 1], [0, 1], [0, 1], [3, 0], [3, 0], [2, 0], [1, 0], [1, 0], [4, 0], [3, 0], [5, 0], [2, 0], [2, 0], [2, 0], [3, 0], [0, 0]]

cvt_dict = {
    'vheight_lo':       0,  # -205
    'cvt_1':            1,  # 0
    'vheight':          2,  # 437
    'vheight_cap':      3,  # 583
    'vheight_po' :      4,  # 623
    'cvt_5' :           5,  # 638
    'stemt' :           6,  # 100
    'stem':6,#100
    'cvt_7' :           7,  # 63
    'stemw' :           8,  # 100
    'cvt_9' :           9,  # 75
    'cvt_10' :          10, # 61
    'cvt_11' :          11, # 102
    'cvt_12' :          12, # 98
#USER LAND
    'stemt_thin':      13, # 90
    'stemw_thin':      13, # 90
    'headstem':      14, # 50
    'headstemplushole': 15, # 110
    'head_sara':        16, # 140
    'stemw_sara':        17, # 80
    'stemt_sara':        17, # 80
    'vheight_cap_shoot':18, # 576
    'vbase_shoot':      19, # 16
    'vbase_thai_shoot': 20, # 10
    'stem_notch':    21, # 70
    'w_285':     22, # 285
    'vheight_shoot':23,# 451
    'vheight_lu':       24, # 165
    'vheight_num':      25, # 380
    'vheight_num_shoot':26, # 391
    'headdia':          27, # 160
    'w_266':            28, # 266
    'w_362':            29, # 362
    'w_316':            30, # 316
    'w_214':            31, # 214
    }

#PUT THESE LINE IN THE BOTTOM OF CODE
#   #----- MODIFY pseudo_code_dict BY -----------
#   #----- SUBSTITUTE FUNCTION IN TEXT FORM -----
#   #----- TO REAL pseudo_code ------------------
#   from dttcmd import *
#   self_func = []
#   for i in dir():
#       if callable(eval(i)): self_func.append(i)
#   
#   
#   for i in pseudo_code_dict.keys():
#       pl = pseudo_code_dict[i].split('\n')
#       for j in range(len(pl)):
#           if '(' in pl[j]:
#               if pl[j].split('(',1)[0] in self_func:
#                   l = [n for n in range(len(pl[j])) if pl[j][n] == ')']
#                   t = pl[j][:l[-1]+1]
#                   pl[j] = pl[j].replace(t, eval(t))
#       pseudo_code_dict[i] = '\n'.join(pl)

#----------------------------------------
#   code
#----------------------------------------


#----------------------------------------
#DRY HEAD
#dh_dstr = "15+4 16+3 17+3 18+3 "
#def dh1(*l): #dry head
#    d = {}
#    for s in l:
#        d[s-1] = dh_dstr
#        d[s+1] = swap_dstr(dh_dstr)
#    return f_dstr_dict(d)
##    return f_dstr_dict({
##        s-1: "15+4 16+3 17+3 18+3 ",
##        s+1: "15-4 16-3 17-3 18-3 " })
#
#def dh2(*l): #dry head
#    d = {}
#    for s in l:
#        d[s-1] = swap_dstr(dh_dstr)
#        d[s+1] = dh_dstr
#    return f_dstr_dict(d)
##    return f_dstr_dict({
##        s-1: "15-4 16-3 17-3 18-3 ",
##        s+1: "15+4 16+3 17+3 18+3 " })
#DISABLE DRY HEAD FOR BOLD
def dh1(*l):
    return ""
def dh2(*l):
    return ""


#----------------------------------------
def dx(s,x):
    return """
SHPIX   %s %s
""" % (x,s)

#----------------------------------------

#---GENERATE STEM FUNCTION---
#predefine delta string of stem
ds_stemw = ""
ds_stemt = ""
ds_stem_notch = ""
ds_headstem = "9-4 30-4 31-4 32-4 33-4 34-4 "
ds_stemw_sara = ""
ds_stemt_sara = ""
ds_stemw_thin = ""
ds_stemt_thin = ""
ds_headstemplushole = "9-4 30+4 31+4 32-4 33-4 34-4 "
ds_headsara = "9-4 "

#def stemw_1(s): = """
#   MIRP[rnd,black]    stemw s
#   f_dstr(s,"ds_stemw")
#   """
#def stemw_2(s): = """
#   MIRP[rnd,black]    stemw s
#   f_dstr(s,"ds_stemw",direction="-")
#   """
for i in ['stemw','stemt',
            'stem_notch','headstem','headstemplushole',
            'stemw_sara','stemt_sara',
            'stemw_thin','stemt_thin'
            ]:
    for j in ['1','1m','2','2m']:   #1=forward/bottomup, #2=reverse/topdown
        if j[-1] == 'm':            #m=move rp0
            cmd = 'mirp0mb'
        else:
            cmd = 'mirpmb'
        if i in ['headstem','headstemplushole']:    #round
            cmd = cmd[:-1] + 'r' + cmd[-1]  
        if i in ['headstemplushole']:   #grey
            cmd = cmd[:-1] + 'g'
        if j[0] == '1':             #1=forward/bottomup, #2=reverse/topdown
            direction = '+'
        else:
            direction = '-'
        exec '''def %s_%s(s,direction="%s"):
    return %s("%s",s,ds_%s,direction,)
''' % (i,j,direction,cmd,i,i,)


#================================================
def vbc1(s,li=[]):
    return pl(""
        , mirp0rg("vbase_shoot",s)
        , f_ip(li)
        )

def vbct(s,li=[]):
    return pl(""
        , mirp0rg("vbase_thai_shoot",s)
        , f_ip(li)
        )

def vblu(s,li=[]):
    return pl(""
        , mirprg("vheight_lu",s)
        , f_ip(li)
        )

def vblum(s,li=[]):
    return pl(""
        , mirp0rg("vheight_lu",s)
        , f_ip(li)
        )

def vtc2(s,li=[]):
    return pl(""
        , mirp0rg("vheight_shoot",s,"12+8 ")
        , f_ip(li)
        )

ds_vheight = "10+8 12+8 17+8 19+8 24+8 26+8 28+8 30+8 33+8 35+8 37+8 39+8 40+8 "
def vt2(s,li=[]):
    return pl(""
        , mirprg("vheight",s,ds_vheight)
        , f_ip(li)
        )

def vt2m(s,li=[]):
    return pl(""
        , mirp0rg("vheight",s,ds_vheight)
        , f_ip(li)
        )

def vtpo(s,li=[]):
    return pl(""
        , mirprg("vheight_po",s)
        , f_ip(li)
        )

def vtpom(s,li=[]):
    return pl(""
        , mirp0rg("vheight_po",s)
        , f_ip(li)
        )

ds_vheight_num = "9+8 17+8 22+8 27+8 30+8 35+8 38+8 "
def vtn(s, li=[]):
    return pl(""
        , mirp0rg("vheight_num",s,ds_vheight_num)
        , f_ip(li)
        )

def vtnc(s, li=[]):
    return pl(""
        , mirp0rg("vheight_num_shoot",s)
        , f_ip(li)
        )

def head_0(s,li,direction="+",small=False,ss=-1,l1s=-1,l2s=-1,dia="headdia"):
    if small:
        ds = "16-8 22-8 29-8 "
    else:
        ds = "16-8 22-8 29-8 "
    if dia == "head_sara":
        ds = ""
    if direction == "-":
        l1 = li[1]
        l2 = li[0]
        temp = l1s
        l1s = l2s
        l2s = temp
        ds = swap_dstr(ds)
        if dia == "head_sara":
            stem1 = stemw_sara_2(l1)
            stem2 = stemw_sara_1(l2)
        else:
            stem1 = headstem_2(l1)
            stem2 = headstem_1(l2)
    else:
        l1 = li[0]
        l2 = li[1]
        if dia == "head_sara":
            stem1 = stemw_sara_1(l1)
            stem2 = stemw_sara_2(l2)
        else:
            stem1 = headstem_1(l1)
            stem2 = headstem_2(l2)
    if len(li)>2:
        ip = f_ip(li[2:])
    else:
        ip = ""
    if ss >= 0:
        add_ss = alignrp(ss)
    else:
        add_ss = ""
    if l1s >= 0:
        add_l1s = shprp2(l1s)
    else:
        add_l1s = ""
    if l2s >= 0:
        add_l2s = shprp2(l2s)
    else:
        add_l2s = ""
    return pl(""
        , stem1
        , add_l1s
        , mirp0rg(dia,s,ds)
        , add_ss
        , ip
        , stem2
        , add_l2s
        )

def head1(s,li,small=False,ss=-1,l1s=-1,l2s=-1):
    #left to right
    return head_0(s,li,direction="+",small=small,ss=ss,l1s=l1s,l2s=l2s)

def head2(s,li,small=False,ss=-1,l1s=-1,l2s=-1):
    #right to left
    return head_0(s,li,direction="-",small=small,ss=ss,l1s=l1s,l2s=l2s)

def headsara1(s,li,small=False,ss=-1,l1s=-1,l2s=-1,dia="head_sara"):
    #left to right
    return head_0(s,li,direction="+",small=small,ss=ss,l1s=l1s,l2s=l2s,dia=dia)

def headsara2(s,li,small=False,ss=-1,l1s=-1,l2s=-1,dia="head_sara"):
    #right to left
    return head_0(s,li,direction="-",small=small,ss=ss,l1s=l1s,l2s=l2s,dia=dia)


def xhead0(s2,s3,direction="+",s2s=-1,s3s=-1):
    add2 = add3 = ""
    if s2s >=0 : add2 = shprp2(s2s)
    if s3s >=0 : add3 = shprp2(s3s)
    return pl(""
        , headstem_1(s2,direction=direction)
        , add2
        , headstemplushole_1(s3,direction=direction)
        , add3
        )


def xhead1(s1,s2,s3,dstr="16-8 28+8 29+8 39+8 ",direction="+",s1s=-1,s2s=-1,s3s=-1):
    add1 = ""
    if s1s >=0 : add1 = alignrp(s1s)
    return pl(""
        , mdrp0rg(s1,dstr)
        , add1
        , xhead0(s2,s3,direction,s2s,s3s)
        )

def xhead2(s1,s2,s3,dstr="16+8 23+8 ",direction="-"):
    return xhead1(s1,s2,s3,dstr,direction)

def yhead1(s1,s2,s3,dstr="",direction="+"):
    return xhead1(s1,s2,s3,dstr,direction)


#================================================
def v_notch_ko_kai(s1,s1s,s2):
    return pl(""
        , mdrp0rg(s1,"23+8 ")
        , alignrp(s1s)
        , stem_notch_1(s2)
        , dx(s2,-8)
        )

def v_head_kho_khuat(s1,s1s,li1, s2,s2s, s3,s4, s5,s6,li6 , add1=""):
    return pl(""
        , vtc2(s1, li1)
        , alignrp(s1s)
        , add1
        , stem_notch_2(s2)
        , shprp2(s2s)
        , mdrp0mrg(s3,"9-6 10-6 11-6 12-6 13-6 14-6 15-6 16-6 ")
        , mdrpmb(s4)
        , mdrp0rg(s5)
        , head2(s6,li6,small=True)
        )

def v_top_kho_khwai(s1,li1,s2, s3,s4,li4,add1=""):
    return pl(""
        , vtc2(s1,li1)
        , add1
        , stemt_2(s2)
        , mdrp0rw(s3,"9-8 14-8 15-8 22-8 28-8 ")
        , head2(s4,li4,small=True)
        )

def v_top_kho_khon(s1,s1s,li1, s2,s2s, s3,s4, s5,s6,li6):
    ds = "9-4 10-4 11-4 15-6 16-6 17-6 18-6 "
    return pl(""
        , vtc2(s1,li1)
        , alignrp(s1s)
        , stemt_2(s2)
        , shprp2(s2s)
        , mdrp0rg(s3)
        , stemt_sara_2(s4)
        , mdrp0mrw(s5)
        , head2(s6,li6,small=True)
        , f_dstr_dict( { s3:ds, s4:ds } )
        )
        
#================================================
def hs1(s,ds="9-8 "):    #start point #1 forward
    #ko_kai, kho_khwai
    return mdapr(s,ds)

def hs2(s,ds="9-8 14-8 "):    #start point #2 reverse
    #kho_khai, cho_chan
    return mdapr(s,ds)

def hw1(s,li=[],ds="11+8 23+8 26+8 "): 
    #make width #1  forward
    #move from front stem of ko_kai to rear stem
    return pl(""
        , mirp0rg("w_316",s,ds)
        , f_ip(li)
        )

def hw2(s,li=[],ds="11-8 12-8 "): 
    #make width #2  reverse
    return pl(""
        , mirp0rg("w_362",s,ds)
        , f_ip(li)
        )

def hw3(s,li=[],ds="17-8 "): 
    #make width #3 forward, pho_samphao
    return pl(""
        , mirp0rg("w_266",s,ds)
        , f_ip(li)
        )

def hw4(s,li=[],ds="11+8 "): 
    #make width #4 forward
    return pl(""
        , mirp0rg("w_214",s,ds)
        , f_ip(li)
        )

def hw5(s,li=[],ds="9-8 11+8 12+8 15+8 17-8 26+8 33+8 "): 
    #make width #5 forward, tho_thahan
    return pl(""
        , mirp0rg("w_285",s,ds)
        , f_ip(li)
        )

def hf1(s1,s2,s3,s4,s5,s1s=-1,s2s=-1,s3s=-1,s4s=-1,s5s=-1,dstr1="12-8 13-8 14-8 15-8 17+8 18+8 19+8 ",add1=""):
    #front h for tho_thahan, po_pan, no_nu, etc.
    if s1s >= 0:
        add1 = pl(alignrp(s1s), add1)
    if s2s >= 0:
        add2 = shprp2(s2s)
    else:
        add2 = ""
    add3 = xhead1(s3,s4,s5,s1s=s3s,s2s=s4s,s3s=s5s) 
    return pl(""
        , mdap(s1,dstr1)
        , add1
        , stemw_1(s2)
        , add2
        , add3
        )

def hf_ko_kai(s1,s2,t2,s3,s4):
    return pl(""
        , hs1(s1)
        , stemw_1(s2)
        , mdrprg(t2,"")
        , mdrp0g(s3,"9+4 ")
        , stemw_1(s4)
        )

def hf_kho_khai(s1,s2,s3,li, dstr="9-8 12-8 13-8 14-8 16+8 17-8 21-8 22-8 "):
    return pl(""
        , mdapr(s1,dstr)
        , mdrp0rg(s2,"16-8 ")
        , head2(s3,li,small=True)
        )

def h_pho_samphao(s1,s2,t2,s3,s4,s5,s6,s7,s8,s9):
    return pl(""
        , mdap(s1,"16+8 17+8 ")
        , stemw_1(s2)
        , mdrprg(t2,"16+4 ")
        , mdrp0g(s3,"")
        , stemw_1(s4)
        , srp0(s1)
        , xhead1(s5,s6,s7)
        , srp0(s1)
        , hw3(s8)
        , stemw_1(s9)
        )

def hw_kho_khai_1(s1,s2, s3,s4, s5,s6, add1="",add2="",add3="",add4="",add5="",add6=""):
    return pl(""
        , mdapr(s1)
        , add1
        , stemw_1(s2)
        , add2
        , mdrp0rg(s3)
        , add3
        , add4
        , srp0(s1)
        , hw4(s5)
        , add5
        , stemw_1(s6)
        , add6
        )

def hw_kho_khai(s1,t1,s2, s3,s4, s5,s6):
    add1 = mdrprg(t1,"14+8 15+8 ")
    add2 = add4 = ""
    add3 = stemw_thin_1(s4)
    return  hw_kho_khai_1(s1,s2, s3,s4, s5,s6, add1,add2,add3,add4)

def hw_cho_chang(s1,t1,s2, s3,s4,s4s,t4, s5,s6, s7,s8):
    add1 = mdrprg(t1,"14+8 15+8 16+8 ")
    add2 = add5 = ""
    add3 = stemw_thin_1m(s4)
    add4 = pl(alignrp(s4s), mdrpg(t4))
    add6 = pl(mdrp0rg(s7,"9+8 10+8 "), stemw_2(s8))
    return  hw_kho_khai_1(s1,s2, s3,s4, s5,s6, add1,add2,add3,add4,add5,add6)


def hw_tho_nangmontho(s1,s2, s3,s4, s5,s6):
#    add1 = add2 = add3 = add4 = add5 = add6 = ""
#    return  hw_kho_khai_1(s1,s2, s3,s4, s5,s6, add1,add2,add3,add4,add5,add6)
    return pl(""
        , mdapr(s1)
        , stemw_1(s2)
        , mdrp0rg(s3)
        , stemw_thin_1(s4)
        , srp0(s1)
        , mdrp0rg(s5,"10-8 ")
        , stemw_1(s6)
        )

def h_kho_khwai(s1,s2, s3,s4,i4, s5,s6,li6, s7,s8, li8=[]):
    return pl(""
        , hs1(s1,"9-8 ")
        , stemw_1(s2)
        , mdrp0rg(s3,"10-8 ")
        , stemw_1(s4)
        , add_ip(s4,s2,[i4])
        , srp0(s1)
        , mdrp0rg(s5,"10-8 14-8 17-8 ")
        , head1(s6,li6,small=True)
        , srp0(s1)
        , hw1(s7)
        , stemw_1(s8)
        , add_ip(s3,s8,li8)
        )

def hw_kho_rakhang(s1,s2,s2s, s3, s4, s5,s5s,s6):
    add1 = add4 = ""
    add2 = shprp2(s2s)
    add3 = stemw_thin_1(s4)
    add5 = alignrp(s5s)
    return hw_kho_khai_1(s1,s2, s3,s4, s5,s6, add1,add2,add3,add4,add5)

def hr_no_nu(s1,s2, s3,s4,li):
    return pl(""
        , mdapr(s1,"9-8 11-8 12-8 14-8 19-8 ")
        , stemw_1(s2)
        , mdrp0rg(s3,"9+4 10+4 ")
        , head2(s4,li)
        )

#================================================
pseudo_code_dict = {

    'uni0E01':      #KO KAI
        packline(""
        , hf_ko_kai(16,14,11, 19,8)
        , srp0(16)
        , hw1(1)
        , stemw_1(25)
        , ix()
        #y
        , sy()
        , mdap(1)
        , alignrp(15)
        , vtc2(22)
        , stemt_2(5)
        , v_notch_ko_kai(17,14,8)
        , iy()
        ),

    'uni0E02':    #KHO KHAI
        packline(""
        , hf_kho_khai(6,19,25,[50,44])
        , hw_kho_khai(6,3,36, 12,31, 38,40)
        , ix()
        , dh2(22)
        #y
        , sy()
        , mdap(1)
        , stemt_1(5)
        , shprp2(37)
        , vt2(40)
        , vtc2(28,[7,36,12,31])
        , stemt_thin_2(15)
        , yhead1(22,41,47)
        , iy()
        , dh2(19)
        ),

    'uni0E03':    #KHO KHUAT
        packline(""
        , hf_kho_khai(6,23,29,[56,50])
        , stemw_thin_1(20)
        , hw_kho_khai(6,3,42, 12,37, 44,46)
        , add_ip(29,37, [32,33,34, 15,16,17])
        , ix()
        , dh1(22)
        , dh2(28)
        #y
        , sy()
        , mdap(1)
        , stemt_1(5)
        , shprp2(43)
        , vt2(46)
        , v_head_kho_khuat(34,32,[7,42,12,37], 15,17, 16,33, 20,26, [47,53])
        , iy()
        , dh2(23)
        ),

    'uni0E04':    #KHO KHWAI
        packline(""
        , h_kho_khwai(28,26, 34,8,11, 13,18,[50,44,24], 1,40,[5,37])
        , ix()
        , dh1(15)
        , dh2(21)
        #y
        , sy()
        , mdap(1)
        , alignrp(27)
        , v_top_kho_khwai(37,[34,8,29,26,11,2,40],5, 15,21,[41,47,24,13])
        , dx(24,12)
        , dx(11,-16)
        , iy()
        , dh2(18)
        ),

    'uni0E05':    #KHO KHON
        packline(""
        , h_kho_khwai(28,26, 34,8,11, 13,18,[50,44,24], 1,40,[5,37])
        , ix()
        , dh1(15)
        , dh2(21)
        #y
        , sy()
        , mdap(1)
        , alignrp(27)
        , v_top_kho_khon(38,36,[34,8,11,29,26,2,40], 4,6, 5,37, 15,21,[41,47])
        , dx(24,12)
        , dx(11,-16)
        , iy()
        , dh2(18)
        ),

    'uni0E06':    #KHO RAKHANG
        packline(""
        , hf_kho_khai(13, 30,36,[64,58])
        , stemw_thin_1(27)
        , srp0(13)
        , xhead1(9,76,70)
        , hw_kho_rakhang(13,49,3, 19,44, 52,1, 54)
        , add_ip(36,44,[39,40,41,22,23,24])
        , ix()
        , dh1(27)
        , dh2(33)
        , dh1(12)
        , dh2(6)
        #y
        , sy()
        , mdap(1)
        , stemt_1(52)
        , vt2(54)
        , v_head_kho_khuat(41,39,[19,44,14,49], 22,24, 23,40, 27,33,[55,61])
        , srp0(1)
        , vbct(6)
        , head1(12,[67,73, 50,3],small=True)
        , iy()
        , dh2(30)
        , dh1(9)
        ),

    'uni0E07':    #NGO NGU
        packline(""
        , mdapr(17,"9-8 ")
        , stemw_1(29)
        , mdrprg(6)
        , xhead1(23,42,36)
        , ix()
        , dh1(26)
        , dh2(20)
        #y
        , sy()
        , mdapr(0)
        , stemt_1(14)
        , vtc2(26,[9])
        , head2(20,[33,39])
        , mdapr(9)
        , iy()
        , dh1(23)
        ),

    'uni0E08':    #CHO CHAN
        packline(""
        , hs2(17)
        , stemw_1(34)
        , mdrp0rg(1,"10-8 ")
        , stemw_1(0)
        , shprp2(14)
        , xhead1(7,46,40)
        , srp0(17)
        , hw2(28,[20,31])
        , stemw_1(23)
        , ix()
        , dh1(10)
        , dh2(4)
        #y
        , sy()
        , mdap(1)
        , vtc2(31,[34,17,14,26])
        , stemt_2(20)
        , mdrp0rg(10,"9-8 15-8 ")
        , head2(4,[37,43])
        , mdapr(26)
        , iy()
        , dh1(7)
        ),

    'uni0E09':    #CHO CHING
        packline(""
        , hr_no_nu(16,37, 41,47,[72,66])
        , srp0(16)
        , mdrp0rg(1,"13-8 18+8 19+8 21-8 24-8 25-8 ")
        , stemw_1(0)
        , shprp2(13)
        , xhead1(7,60,54)
        , mdrp0rg(29)
        , stemw_1(23)
        , ix()
        , dh1(10)
        , dh2(4)
        , dh2(44)
        #y
        , sy()
        , mdap(0)
        , stemt_thin_1(14)
        , vtc2(34,[17,37])
        , stemt_2(20)
        , mdrp0rw(10,"12-8 19-8 30-8 ")
        , mdrpg(26)
        , head2(4,[51,57])
        , srp0(0)
        , vbct(44)
        , head1(16,[63,69,38,49])
        , iy()
        , dh1(7)
        , dh2(41)
        , dh1(47)
        ),

    'uni0E0A':    #CHO CHANG
        packline(""
        , hf_kho_khai(6, 19,25,[58,52])
        , hw_cho_chang(6,3,70, 12,31,65,45, 61,48, 34,40)
        , ix()
        , dh2(19)
        #y
        , sy()
        , mdap(1)
        , stemt_1(5)
        , shprp2(71)
        , vtc2(28,[12,31,65,45,7,70])
        , mdrp0mrg(37)
        , stemt_sara_2(42)
        , srp0(28)
        , stemt_thin_2(15)
        , mdrprg(55)
        , mdrp0rg(22)
        , headstem_2(49)
        , iy()
        , dh2(19)
        ),

    'uni0E0B':    #SO SO
        packline(""
        , hf_kho_khai(6,23,29, [64,58])
        , stemw_thin_1(20)
        , hw_cho_chang(6,3,76, 12,37,71,51, 67,54, 40,46)
        , add_ip(29,37, [32,33,34,15,16,17])
        , ix()
        , dh1(20)
        , dh2(26)
        #y
        , sy()
        , mdap(1)
        , stemt_1(5)
        , shprp2(77)
        , v_head_kho_khuat(34,32,[12,37,71,51,7,76], 15,17, 16,33, 20,26, [55,61], add1=pl(mdrp0mrg(43),stemt_thin_2(48),srp0(34)))
        , iy()
        , dh2(23)
        ),

    'uni0E0C':    #CHO_CHOE
        packline(""
        , mdap(37,"9-8 10-8 11-8 12-8 24-8 25-8 ")
        , stemw_1(25)
        , mdrprg(22)
        , mdrp0g(40,"9+4 10+4 11+4 12+4 ")
        , stemw_1(19)
        , srp0(37)
        , xhead2(31,55,61,"19-8 23+8 ")
        #
        , srp0(37)
        , mdrp0rg(12,"19-8 27-8 35+8 ")
        , stemw_1(46)
        , mdrp0rg(9,"15-8 16-8 ")
        , head1(3,[73,67])
        , srp0(12)
        , mdrp0rg(49,"17-8 23-8 24-8 29-8 42-8 44-8 ")
        , alignrp(1)
        , stemw_1(51)
        , ix()
        , dh1(27)
        , dh2(34,6)
        #y
        , sy()
        , mdap(1)
        , vt2(51,[49])
        , vtc2(43,[13,46])
        , stemt_2(16)
        , v_notch_ko_kai(38,25,19)
        , srp0(1)
        , vbct(34)
        , alignrp(6)
        , head1(28,[52,58,12,3],ss=47,l1s=64,l2s=70) 
        , iy()
        , dh1(9)
        , dh2(31)
        ),

    'uni0E0D.descless':    #YO YING
        packline(""
        , mdap(26,"9-8 10-8 11-8 12-8 24-8 25-8 ")
        , stemw_1(14)
        , mdrprg(11)
        , mdrp0g(29,"9+4 10+4 11+4 12+4 ")
        , stemw_1(8)
        , srp0(26)
        , xhead2(20,43,49)
        #
        , srp0(26)
        , mdrp0rg(1,"19-8 27-8 35+8 ")
        , stemw_1(35)
        , mdrp0rg(37,"17-8 23-8 24-8 29-8 42-8 44-8 ")
        , stemw_1(39)
        , ix()
        , dh1(17)
        , dh2(23)
        #y
        , sy()
        , mdap(1)
        , stemt_1(36)
        , vt2(39)
        , vtc2(32,[2,35])
        , stemt_2(5)
        , v_notch_ko_kai(27,14,8)
        , srp0(1)
        , vbct(23)
        , head1(17,[40,46])
        , iy()
        , dh2(20)
        ),

    'desc.uni0E0D':
        packline(""
        , mdap(25)
        , mdrp0rg(6)
        , headsara1(12,[39,33])
        , ix()
        #y
        , sy()
        , mdap(42)
        , mdrp0mrw(9)
        , mdrprg(22)
        , headsara2(3,[30,36])
        , mdrp0rg(0)
        , stemt_sara_1(16)
        , iy()
        ),

    'uni0E0E':    #DO CHADA
        packline(""
        , h_pho_samphao(51,39,36, 54,33, 46,70,64, 26,60)
        , alignrp(1)
        , mdrp0rg(8)
        , headstem_1(80)
        , mdrprg(75)
        , add_ip(80,26,[13,20,3])
        , ix()
        , dh1(49,11)
        , dh2(43,5)
        #y
        , sy()
        , mdap(83)
        , vtc2(57,[27,60])
        , stemt_2(30)
        , v_notch_ko_kai(52,39,33)
        , srp0(83)
        , vbct(43)
        , head1(49,[61,67])
        , srp0(83)
        , vblum(1)
        , stemt_1(26)
        , mdrp0rg(5)
        , headstem_1(73)
        , mdrp0rg(11)
        , f_ip([13,24,3])
        , headstem_2(77)
        , mdrprg(18)
        , iy()
        , dh1(46,8)
        ),

    'uni0E0F':    #TO PATAK
        packline(""
        , h_pho_samphao(62,50,47, 65,44, 57,81,75, 37,71)
        , mdrp0rg(13)  
        , headstem_1(91)
        , mdrprg(86)
        , add_ip(86,37,[18,22,29,31,34,1,3,5,6,8])
        , ix()
        , dh1(60,16)
        , dh2(54,10)
        #y
        , sy()
        , mdap(94)
        , vtc2(68,[38,71])
        , stemt_2(41)
        , v_notch_ko_kai(63,50,44)
        , srp0(94)
        , vbct(54)
        , head1(60,[72,78])
        , srp0(94)
        , vblum(10)
        , alignrp(6)
        , alignrp(1)
        , headstem_1(84)
        , mdrp0rg(16)
        , f_ip([18,29,35,31,34,3,8])
        , headstem_2(88)
        , mdrprg(22)
        , iy()
        , dh1(57,13)
        ),

    'uni0E10.descless':    #THO THAN
        packline(""
        , hs2(18)
        , stemw_1m(45)
        , mdrprg(32)
        , srp0(18)
        , mdrp0rg(1)
        , stemw_1(0)
        , shprp2(14)
        , xhead1(7,58,52)
        , srp0(18)
        , mdrp0rg(23,"14+8 16-8 ")
        , stemw_1(41)
        , add_ip(23,32,[26,38,29,35])
        , ix()
        , dh1(10)
        , dh2(4)
        #y
        , sy()
        , mdap(1)
        , vtc2(26,[18,45])
        , stemt_2(37)
        , mdrp0rg(35)
        , stemt_1(29)
        , srp0(26)
        , mdrp0rg(21)
        , stem_notch_1(41)
        , mdrp0rg(10)
        , head2(4,[49,55])
        , iy()
        , dh1(7)
        ),

    'desc.uni0E10':
        packline(""
        , mdap(40)
        , stemw_sara_2(28)
        , headsara2(34,[50,44])
        , mdrp0rg(23)
        , f_ip([24,25,26,1,2,3])
        , headsara2(11,[62,66,17,5])
        , ix()
        #y
        , sy()
        , mdap(65)
        , mdrp0mrw(37)
        , headsara2(31,[41,47])
        , mdrp0rg(1)
        , alignrp(4)
        , alignrp(8)
        , stemt_sara_1(27)
        , shprp2(24)
        , headsara1(14,[53,59])
        , iy()
        ),

    'uni0E11':    #THO NANGMONTHO
        packline(""
        , hf_kho_khai(11,28,34,[58,52],dstr="9-8 13-8 14-8 15-8 18-8 19-8 22-8 24-8 33-8 39-8 ")
        , hw_tho_nangmontho(11,10,17,42,1,48)
        , add_ip(34,42, [37,38,39, 20,21,22])
        , ix()
        , dh1(25)
        , dh2(31)
        #y
        , sy()
        , mdap(1)
        , alignrp(10)
        , v_head_kho_khuat(39,37,[12,17,42], 20,22, 21,38, 25,31, [49,55], add1=pl(alignrp(45), stemt_thin_2(5)))
        , iy()
        , dh2(31)
        ),

    'uni0E12':    #THO PHUTHAO
        packline(""
        , mdap(42,"10-8 11-8 12-8 13-8 14-8 15-8 ")
        , stemw_1(41)
        , f_ip([25])
        , mdrp0rg(48,"11+8 12+8 13+8 14+8 15+8 ")
        , stemw_1(19)
        , srp0(42)
        , mdrp0rg(30,"17-8 18-8 19-8 20-8 30-8 31-8 35-8 42-8 43-8 ")
        , head1(36,[69,63,27,38],small=True)
        #
        , srp0(42)
        , mdrp0rg(12,"14-8 17-8 19-8 23+8 24+8 29-8 ")
        , stemw_1(54)
        , mdrp0rg(9)
        , head1(3,[81,75])
        , srp0(12)
        , mdrp0rg(57,"18-8 25-8 33-8 34-8 47-8 ")
        , alignrp(1)
        , stemw_1(59)
        , add_ip(48,54,[50,51,52,15,16,17])
        , ix()
        , dh1(33)
        , dh2(6)
        #y
        , sy()
        , mdap(1)
        , alignrp(41)
        , stemt_1(57)
        , vt2(59)
        , v_top_kho_khon(52,50,[13,54,48,19,25],15,17,16,51,33,38,[60,66])
        , srp0(1)
        , vbct(6)
        , head1(12,[72,78,55,3])
        , iy()
        , dh1(36)
        , dh2(30,9)
        ),

    'uni0E13':    #NO NEN
        packline(""
        , mdap(26,"9-8 10-8 11-8 12-8 24-8 25-8 ")
        , stemw_1(14)
        , mdrprg(11,"9+4 10+4 11+4 12+4 24+4 25+4 ")
        , mdrp0g(29)
        , stemw_1(8)
        , srp0(26)
        , xhead2(20,57,63)
        #
        , srp0(26)
        , mdrp0rg(1,"20+8 ")
        , stemw_1(0)
        , shprp2(35)
        , mdrp0rg(38,"17-8 ")
        , stemw_1(40)
        , mdrp0rg(44)
        , head2(50,[75,69])
        , ix()
        , dh1(17)
        , dh2(23,47)
        #y  
        , sy()
        , mdap(1)
        , vt2(40)
        , vtc2(32,[2,35,36])
        , stemt_2(5)
        , v_notch_ko_kai(27,14,8)
        , srp0(1)
        , vbct(23)
        , alignrp(47)
        , head1(17,[54,60,41,52], ss=38,l1s=66,l2s=72)
        , iy()
        , dh2(20,44)
        ),

    'uni0E14':    #DO DEK
        packline(""
        , h_kho_khwai(29,28, 33,8,11, 16,22,[49,43,13,25], 1,39, [36,5])
        , ix()
        , dh1(19)
        #y
        , sy()
        , mdap(1)
        , alignrp(28)
        , v_top_kho_khwai(36,[11,33,8,2,39],5,19,25,[40,46,13])
        , iy()
        , dh1(16)
        , dh2(22)
        ),

    'uni0E15':    #TO TAO
        packline(""
        , h_kho_khwai(29,28, 33,8,11, 16,22,[49,43,13,25], 1,39, [36,5])
        , ix()
        , dh1(19)
        #y
        , sy()
        , mdap(1)
        , alignrp(28)
        , v_top_kho_khon(37,35,[33,8,2,39,11], 4,6,5,36, 19,25,[40,46,13])
        , iy()
        , dh1(16)
        , dh2(22)
        ),

    'uni0E16':      #THO THUNG
        packline(""
        , hf_ko_kai(26,14,11, 29,8)
        , srp0(26)
        , xhead2(20,39,45)
        , srp0(26)
        , hw1(1)
        , stemw_1(35)
        , ix()
        #y
        , sy()
        , mdap(1)
        , vtc2(32,[2,35])
        , stemt_2(5)
        , v_notch_ko_kai(27,14,8)
        , srp0(1)
        , vbct(23)
        , head1(17,[36,42])
        , iy()
        , dh2(20)
        ),

    'uni0E17':      #THO THAHAN
        packline(""
        , hf1(11,23,17,42,36,s2s=10)
        , srp0(11)
        , hw5(1,[8])
        , stemw_1(32)
        , mdap(8)
        , stemw_sara_2(26)
        , ix()
        , dh1(21)
        , dh2(15)
        #y
        , sy()
        , mdap(1)
        , alignrp(10)
        , vtc2(20,[24,26,8,2,32])
        , alignrp(29)
        , stemt_thin_2(5)
        , head2(14,[33,39])
        , iy()
        , dh1(17)
        ),

    'uni0E18':      #THO THONG
        packline(""
        , mdap(1)
        , stemw_1(3)
        , mdrp0g(10)
        , stemw_1(28)
        , srp0(1)
        , mdrp0rg(5)
        , stemw_1m(31)
        , mdrpg(19)
        , ix()
        #y
        , sy()
        , mdap(1)
        , stemt_1(4)
        , vtc2(13)
        , stemt_2(25)
        , mdrp0rg(22)
        , stemt_1(16)
        , srp0(13)
        , mdrp0rg(9)
        , stem_notch_1(29)
        , mdrpg(3)
        , iy()
        ),

    'uni0E19':      #NO NU
        packline(""
        , hf1(1,13,7,41,35, s2s=0)
        , hr_no_nu(16,18, 22,28,[53,47])
        , ix()
        , dh1(10)
        , dh2(25,4)
        #y
        , sy()
        , mdap(0)
        , stemt_1(14)
        , vt2(18)
        , vtc2(10)
        , head2(4,[32,38])
        , srp0(0)
        , vbct(25)
        , head1(16,[44,50,19,30])
        , f_dstr(16,"15+4 16+4 ")
        , iy()
        , dh1(7,28)
        , dh2(22)
        ),  

    'uni0E1A':      #BO BAIMAI
        packline(""
        , hf1(6,18,12,32,26,add1=mdrprg(3))
        , srp0(6)
        , hw5(20)
        , stemw_1(22)
        , ix()
        , dh1(15)
        , dh2(9)
        #y  
        , sy()
        , mdap(1)
        , stemt_1(5)
        , shprp2(19)
        , vt2(22)
        , vtc2(15)
        , head2(9,[23,29])
        , iy()
        , dh1(12)
        ),

    'uni0E1B':      #PO PLA
        packline(""
        , hf1(6,18,12,32,26,add1=mdrprg(3))
        , srp0(6)
        , hw5(20)
        , stemw_1(22)
        , ix()
        , dh1(15)
        , dh2(9)
        #y  
        , sy()
        , mdap(1)
        , stemt_1(5)
        , shprp2(19)
        , vtpo(22)
        , vtc2(15)
        , head2(9,[23,29])
        , iy()
        , dh1(12)
        ),

    'uni0E1C':      #PHO PHUNG
        packline(""
        , mdap(4,"9-8 10-8 19-8 ")
        , stemw_1(16)
        , shprp2(3)
        , xhead2(11,26,32)
        , srp0(4)
        , mdrp0rg(20,"10+8 ")
        , alignrp(1)
        , stemw_1(22)
        , add_ip(16,20,[18,19,2])
        , ix()
        , dh1(8)
        , dh2(14)
        #y  
        , sy()
        , mdap(1)
        , alignrp(3)
        , vt2(22)
        , vtc2(8,[17,20])
        , head2(14,[23,29])
        , add_ip(14,1,[18,2])
        , iy()
        , dh2(11)
        ),  

    'uni0E1D':      #FO FA
        packline(""
        , mdap(4,"9-8 10-8 19-8 ")
        , stemw_1(16)
        , shprp2(3)
        , xhead2(11,26,32)
        , srp0(4)
        , mdrp0rg(20,"10+8 ")
        , alignrp(1)
        , stemw_1(22)
        , add_ip(16,20,[18,19,2])
        , ix()
        , dh1(8)
        , dh2(14)
        #y  
        , sy()
        , mdap(1)
        , alignrp(3)
        , vtpo(22)
        , vtc2(8,[17,20])
        , head2(14,[23,29])
        , add_ip(14,1,[18,2])
        , iy()
        , dh2(11)
        ),  

    'uni0E1E':      #PHO PHAN
        packline(""
        , hf1(4,16,10,32,26,s2s=3)
        , srp0(4)
        , hw5(1)
        , alignrp(20)
        , stemw_1(22)
        , add_ip(16,20,[18,19,2])
        , ix()
        , dh1(13)
        , dh2(7)
        #y
        , sy()
        , mdap(1)
        , alignrp(3)
        , vt2(22)
        , shprp2(19)
        , vtc2(13,[2,17,20])
        , head2(7,[23,29])
        , iy()
        , dh1(10)
        ),

    'uni0E1F':      #FO FAN
        packline(""
        , hf1(4,16,10,32,26,s2s=3)
        , srp0(4)
        , hw5(1)
        , alignrp(20)
        , stemw_1(22)
        , add_ip(16,20,[18,19,2])
        , ix()
        , dh1(13)
        , dh2(7)
        #y
        , sy()
        , mdap(1)
        , alignrp(3)
        , vtpo(22)
        , vt2(19)
        , vtc2(13,[2,17,20])
        , head2(7,[23,29])
        , iy()
        , dh1(10)
        ),

    'uni0E20':    #PHO SAMPHAO
        packline(""
        , h_pho_samphao(26,14,11, 29,8, 21,45,39, 1,35)
        , ix()
        , dh1(24)
        , dh2(18)
        #y
        , sy()
        , mdap(1)
        , vtc2(32,[2,35])
        , stemt_2(5)
        , v_notch_ko_kai(27,14,8)
        , srp0(1)
        , vbct(18)
        , head1(24,[36,42])
        , iy()
        , dh1(21)
        ),

    'uni0E21':      #MO MA
        packline(""
        , hf1(13,25,19,40,34,s2s=3,s3s=9,s4s=52,s5s=46)
        , srp0(13)
        , hw5(28)
        , alignrp(1)
        , stemw_1(30)
        , ix()
        , dh1(22,12)
        , dh2(16,6)
        #y
        , sy()
        , mdap(1)
        , stemt_thin_1(28)
        , vt2(30)
        , vtc2(22)
        , head2(16,[31,37])
        , srp0(1)
        , vbct(6)
        , head1(12,[43,49,26,3])
        , iy()
        , dh1(19,9)
        ),
    
    'uni0E22':    #YO YAK
        packline(""
        , hs1(1)
        , stemw_1(34)
        , f_ip([5])
        , mdrprg(28)
        , mdrp0rg(8)
        , stemw_1(22)
        , xhead2(14,42,48,dstr="")
        , srp0(1)
        , hw1(36)
        , stemw_1(38)
        , ix()
        , dh1(11)
        , dh2(17)
        #y
        , sy()
        , mdap(1)
        , stemt_1(35)
        , vt2(38)
        , vtc2(11)
        , head2(17,[39,45,20],small=True)
        , mdrp0mrg(31,"9-8 10-8 ")
        , stemt_thin_1(25)
        , f_ip([5])
        , iy()
        , dh2(14)
        ),

    'uni0E23':    #RO RUA
        packline(""
        , mdap(8,"9-8 ")
        , stemw_1(36)
        , xhead1(3,49,43)
        , srp0(8)
        , mdrp0rg(14,"11+8 15-8 18-8 28-8 31-8 ")
        , stemw_1(32)
        , mdrprg(23)
        , ix() 
        , dh1(6)
        , dh2(0)
        #y
        , sy() 
        , mdap(52)
        , vtc2(17)
        , stemt_2(29)
        , mdrp0rg(26)
        , stemt_1(20)
        , srp0(17)
        , mdrp0rg(12)
        , stem_notch_1(33)
        , srp0(52)
        , vbct(0)
        , head1(6,[40,46])
        , iy()
        , dh1(3)
        ),  

    'uni0E24':      #RU
        packline(""
        , hf_ko_kai(26,14,11, 29,8)
        , srp0(26)
        , xhead2(20,39,45)
        , srp0(26)
        , hw1(1) 
        , stemw_1(35)
        , ix()
        #y
        , sy()
        , mdap(48)
        , vblu(0)
        , vtc2(32)
        , stemt_2(5)
        , v_notch_ko_kai(27,14,8)
        , srp0(48)
        , vbct(23)
        , head1(17,[36,42])
        , iy()
        , dh2(20)
        ),

    'uni0E25':      #LO LING
        packline(""
        , mdap(19,"9-8 14-8 22-8 ")
        , stemw_1(7)
        , mdrp0rg(39,"9+8 10+8 ")
        , stemw_1(33)
        , srp0(19)
        , xhead2(13,51,57)
        , srp0(19)
        , mdrp0rg(1,"21+8 ")
        , alignrp(26)
        , stemw_1(47)
        , add_ip(19,1,[23,4])
        , add_ip(39,47,[44,30])
        , ix()
        , dh1(10)
        , dh2(16)
        #y
        , sy()
        , mdap(1)
        , vtc2(44,[26,27,47])
        , stemt_2(30)
        , mdrprg(36,"9+8 10+8 15+8 ")
        , mdrp0rg(23,"9-8 ")
        , stemt_thin_2(4)
        , srp0(1)
        , vbct(16)
        , head1(10,[48,54])
        , iy()
        , dh2(13)
        ),

    'uni0E26':    #LU
        packline(""
        , h_pho_samphao(26,14,11, 29,8, 21,45,39, 1,35)
        , ix()
        , dh1(24)
        , dh2(18)
        #y
        , sy()
        , mdap(48)
        , vtc2(32,[2,35])
        , stemt_2(5)
        , v_notch_ko_kai(27,14,8)
        , srp0(48)
        , vblu(1)
        , vbct(18)
        , head1(24,[36,42])
        , iy()
        , dh1(21)
        ),

    'uni0E27':    #WO WAEN
        packline(""
        , mdap(8,"9-8 11+8 ")
        , stemw_1(29)
        , xhead1(3,42,36)
        , srp0(8)
        , mdrp0rg(21,"10-8 ")
        , stemw_1(15)
        , ix()
        , dh1(6)
        , dh2(0)
        #y
        , sy()
        , mdap(45)
        , vtc2(26,[9,29])
        , stemt_2(12)
        , mdrprg(18)
        , srp0(45)
        , vbct(0)
        , head1(6,[33,39])
        , iy()
        , dh1(3)
        ),  

    'uni0E28':    #SO SALA
        packline(""
        , h_kho_khwai(19,18, 25,62,48, 50,9,[74,68,53,7], 1,47,[28,59,56,4,31,44])
        , ix()
        , dh1(5)
        , dh2(12)
        #y
        , sy()
        , mdap(1)
        , alignrp(18)
        , v_top_kho_khwai(28,[31,44,56,4,25,62,2,47], 59, 52,12,[65,71,7],add1=mdrpmrg(36))  
        , iy()
        , dh2(9)
        ),

    'uni0E29':      #SO RUSI
        packline(""
        , hf1(6,18,12,63,57,add1=pl(""
            , mdrprg(3)
            , mdrp0rg(29)
            , head1(35,[75,69],small=True)
            , srp0(6)
            ))
        , srp0(6)
        , hw5(20)
        , alignrp(40)
        , stemw_1(53)
        , shprp2(42)
        , ix()
        , dh1(15,32)
        , dh2(9)
        #y  
        , sy()
        , mdap(1)
        , stemt_1(5)
        , shprp2(19)
        , vt2(42)
        , vtc2(15,[32])
        , head2(9,[54,60])
        , mdapr(32)
        , mdrp0rg(32)
        , head2(26,[66,72])
        , mdrp0rg(23)
        , stemt_sara_2(38)
        , add_ip(32,23,[40,43,21,53])
        , iy()
        , dh1(12,29)
        , dh2(35)
        ),

    'uni0E2A':      #SO SUA
        packline(""
        , mdap(19,"9-8 14-8 22-8 ")
        , stemw_1(7)
        , mdrp0rg(39,"9+8 10+8 ")
        , stemw_1(33)
        , srp0(19) 
        , xhead2(13,75,81)
        , srp0(19)
        , mdrp0rg(1,"21+8 ")
        , alignrp(63)
        , stemw_1(62)
        , add_ip(19,1,[23,4,25,28,70])
        , add_ip(39,62,[44,30,46,60])
        , ix()
        , dh1(10)
        , dh2(16)
        #y
        , sy()
        , mdap(1) 
        , vtc2(44,[46,60,28,67,65,62])
        , mdrpmrg(52)
        , stemt_2(30)
        , mdrprg(36,"9+8 10+8 15+8 ")
        , mdrp0rg(23,"9-8 ")
        , stemt_thin_2(4)
        , f_ip([70,63])
        , srp0(1)
        , vbct(16)
        , head1(10,[72,78])
        , iy()
        , dh2(13)
        ),

    'uni0E2B':      #HO HIP
        packline(""
        , hf1(11,23,17,54,48,s2s=10)
        , srp0(11)
        , hw5(1,[8])
        , stemw_1(44)
        , mdrp0rg(38)
        , head2(32,[66,60,41])
        , f_dstr_dict({ 32:"15-8 16-8 ",
                        66:"15-8 16-8 " })
        , mdap(8)
        , stemw_sara_2(26)
        , ix()
        , dh1(20,35)
        , dh2(14)
        #y
        , sy()
        , mdap(1)
        , alignrp(10)
        , vtc2(20,[24,26,8,2,44])
        , alignrp(35)
        , head2(14,[45,51,29,41,5],l1s=57,l2s=63)
        , mdrprg(5)
        , iy()
        , dh1(17,32)
        , dh2(38)
        ),

    'uni0E2C':      #LO CHULA
        packline(""
        , hf1(4,16,10,54,48,s2s=3)
        , srp0(4)
        , hw5(1)
        , alignrp(20)
        , stemw_1(44)
        , add_ip(16,20,[18,19,2])
        , xhead1(26,66,60)
        , ix()
        , dh1(13,29)
        , dh2(7,23)
        #y
        , sy()
        , mdap(1)
        , alignrp(3)
        , vtc2(13,[17,20])
        , head2(7,[45,51])
        , srp0(13)
        , mdrp0mrg(29)
        , head2(23,[57,63,44,33,37])
        , alignrp(19)
        , add_ip(19,1,[2])
        , iy()
        , dh1(10,26)
        ),

    'uni0E2D':      #O ANG
        packline(""
        , mdap(1,"12-8 13-8 14-8 19-8 20-8 ")
        , stemw_1(13)
        , mdrp0rg(28)
        , stemw_1(22)
        , srp0(1)
        , xhead2(8,40,46)
        #
        , srp0(1)
        , mdrp0rg(15,"12+8 ")
        , stemw_1(36)
        , ix()
        , dh1(5)
        , dh2(11)
        #y
        , sy()
        , mdap(1)
        , stemt_1(14)
        , vtc2(33,[16,36,25,5])
        , stemt_2(19)
        , mdap(5,"9-8 15-8 16-8 ")
        , head2(11,[37,43])
        , mdapr(25)
        , iy()
        , dh2(8)
        ),  

    'uni0E2E':      #HO NOKHUK
        packline(""
        , mdap(1,"9-8 14-8 ")
        , stemw_1(13)
        , mdrp0rg(25)
        , stemw_1(65)
        , srp0(1)
        , xhead2(8,47,53)
        #
        , srp0(1)
        , mdap(15)
        , stemw_1(43)
        , mdrprg(37)
        , add_ip(25,43,[59,31,40,19])
        , ix()  
        , dh1(5)
        , dh2(11)
        #y  
        , sy()
        , mdap(1) 
        , stemt_1(14)
        , vtc2(28,[16,43])
        , stem_notch_2(62)
        , mdrprg(34)
        , mdrp0rg(22)
        , f_ip([25,65,59,31,40,19])
        , stem_notch_1(56)
        , mdrp0rg(5)
        , head2(11,[44,50])
        , iy()
        , dh2(8)
        ),  

    'uni0E2F':      #PAIYAN NOI
        packline(""
        , mdap(6,"9-8 ")
        , alignrp(28)
        , stemw_1(29)
        , mdrprg(3)
        , mdrp0rg(16)
        , head1(22,[39,33])
        , ix()  
        , dh1(19)
        #y  
        , sy()
        , mdap(1)
        , stemt_1(5)
        , vtc2(19,[7])
        , alignrp(29)
        , xhead0(36,30,direction="-")
        , mdrp0rg(10)
        , stemt_sara_1(24)
        , iy()
        , dh2(22)
        ),  

    'uni0E30':      #SARA A
        packline(""
        , mdap(6)
        , alignrp(47)
        , head1(12,[38,32],ss=53,l1s=79,l2s=73)
        , srp0(6)
        , mdrp0rg(24,"10+8 ")
        , alignrp(65)
        , stemw_sara_2(18)
        , shprp2(59)
        , ix()
        , dh1(50,9)
        #y  
        , sy()
        , mdap(0)
        , stemt_sara_1(14)
        , mdrp0rg(3)
        , head1(9,[29,35])
        , mdrprg(21)
        , srp0(0)
        , vt2m(50)
        , mdrprg(62)
        , head2(44,[70,76])
        , mdrp0rg(41)
        , stemt_sara_1(55)
        , iy()
        , dh2(53,12)
        ),

    'uni0E31':      #MAI HAN-AKAT
        packline(""
        , mdap(6)
        , head1(12,[38,32])
        , srp0(6)
        , mdrp0rg(24,"10+8 ")
        , stemw_sara_2(18)
        , ix()
        , dh1(9)
        #y  
        , sy()
        , mdap(0)
        , stemt_sara_1(14)
        , mdrp0rg(3)
        , head1(9,[29,35])
        , mdrprg(21)
        , iy()
        , dh2(12)
        ),

    'uni0E32':    #SARA AA
        packline(""
        , mdap(1,"9-8 11+8 ")
        , stemw_1(22)
        , mdrp0rg(14,"10-8 ")
        , stemw_1(8)
        , ix()
        #y
        , sy()
        , mdap(1)
        , vtc2(19,[2,22,11])
        , stemt_2(5)
        , mdapr(11)
        , iy()
        ),

#    'uni0E34':    #SARA I
#        packline(""
#        , mdap(0)
#        , stemw_2(7)
#        , mdrp0rg(1)
#        , stemw_1(13)
#        , ix()
#        #y
#        , sy()
#        , mdap(0)
#        , stemt_1(7)
#        , mdrp0rg(4,"16+8 17+8 18+8 19+8 ")
#        , stemt_2(10)
#        , iy()
#        ),
#    
#    'uni0E35':    #SARA II
#        packline(""
#        , mdap(0)
#        , stemw_2(7)
#        , alignrp(10)
#        , mdrp0rg(1)
#        , stemw_1(16)
#        , ix()
#        #y
#        , sy()
#        , mdap(0)
#        , stemt_1(10)
#        , mdrp0rg(4,"16+8 17+8 18+8 19+8 ")
#        , stemt_2(13)
#        , mdrpmrg(8)
#        , iy()
#        ),
#    
#    'uni0E36':    #SARA UE
#        packline(""
#        , mdap(0)
#        , stemw_2(20)
#        , mdrp0mrg(15)
#        , headsara2(9,[36,30])
#        , srp0(0)
#        , mdrp0rg(1)
#        , stemw_1(26)
#        , ix()
#        #y
#        , sy()
#        , mdap(0) 
#        , stemt_1(20)
#        , mdrp0rg(4,"16+8 17+8 18+8 19+8 ")
#        , stemt_2(23)
#        , mdrp0mrg(12)
#        , headsara2(18,[27,33])
#        , iy()
#        ),
#
#    'uni0E37':    #SARA UUE
#        packline(""
#        , mdap(0)
#        , stemw_2(11)
#        , shprp2(14)
#        , mdrp0rg(8,"12-8 13-8 14-8 15-8 16-8 17-8 18-8 ")
#        , stemw_2(6)
#        , srp0(0)
#        , mdrp0rg(1)
#        , stemw_1(20)
#        , ix()
#        #y  
#        , sy()
#        , mdap(0)
#        , stemt_1(20)
#        , mdrp0rg(4,"16+8 17+8 18+8 19+8 ")
#        , f_ip([6,9,11])
#        , stemt_2(17)
#        , mdrpmrg(8)
#        , shprp2(13)
#        , iy()
#        ),  
#
    'uni0E38':    #SARA U
        packline(""
        , mdap(13)
        , stemw_sara_2(1)
        , mdrpmrg(7,"9-8 ")
        , f_ip([23,17])
        , ix()
        #y  
        , sy()
        , mdap(26) 
        , mdrp0mrw(10)
        , mdrp0rg(4)
        , f_ip([20,14])
        , mdrpmrg(1)
        , iy()
        ),  

    'uni0E39':    #SARA UU
        packline(""
        , mdap(17)
        , stem_notch_2(15)
        , mdrp0mrg(13,"12-8 13-8 ")
        , stem_notch_2(1)
        , mdrpmrg(7,"9-8 ")
        , f_ip([27,21])
        , ix() 
        #y  
        , sy()
        , mdap(30)
        , mdrp0mrw(10)
        , alignrp(16)
        , mdrp0rg(4)
        , alignrp(14)
        , f_ip([24,18])
        , stem_notch_2(1)
        , iy()
        ),

    'uni0E3A':    #PHINTHU
        packline(""
        , mdap(9)
        , mdrpmrg(3)
        , ix() 
        #y  
        , sy()
        , mdap(12)
        , mdrp0mrw(6)
        , mdrpmrg(0)
        , iy() 
        ),

#    'uni0E3F':    #THAI CURRENCY SYMBOL BAHT
#        packline(""
#        , mdap(9,"11-8 12-8 13-8 14-8 ")
#        , stemw_1(54)
#        , shprp2(50)
#        , mdrprg(6)
#        , shprp2(13)
#        #
#        , mdrp0rg(52,"11+8 ")
#        , alignrp(48)
#        , alignrp(2)
#        , alignrp(16)
#        , stemw_1(64)
#        , shprp2(47)
#        , shprp2(36)
#        , shprp2(21)
#        #
#        , mdrp0rg(60)
#        , f_ip([29])
#        , stemw_1(32)
#        , mdrp0rg(43,"12+8 ")
#        , stemw_1(26)
#        , ix() 
#        #y  
#        , sy()
#        , mdap(3)
#        , alignrp(36)
#        , mdrprg(0)
#        , stemt_1(52)
#        , shprp2(56)
#        , shprp2(9)
#        #
#        , mdrp0rg(53)
#        , f_ip([60,32])
#        , alignrp(64)
#        , stemt_1(48)
#        , f_ip([29])
#        , shprp2(39)
#        #
#        , mdrp0rg(16)
#        , f_ip([43,26])
#        , alignrp(22)
#        , mdrprg(19)
#        , stemt_2(49)
#        , shprp2(10)
#        , shprp2(47)
#        , iy() 
#        ), 
#
    'uni0E40':    #SARA E
        packline(""
        , mdap(3)
        , stemw_1(5)
        , xhead1(11,17,23)
        , ix()
        , dh1(8)
        , dh2(0)
        #y  
        , sy()
        , mdap(26)
        , vt2(5)
        , vbct(0)
        , head1(8,[14,20])
        , iy()
        , dh2(11)
        ),

    'uni0E42':    #SARA O
        packline(""
        , mdap(3)
        , stemw_1(31)
        , xhead1(37,43,49)
        , srp0(3)
        , mdrp0rg(9)
        , stemw_1(27)
        , mdrprg(18)
        , ix()
        , dh1(34)
        , dh2(0)
        #y  
        , sy()
        , mdap(52)
        , vbct(0)
        , head1(34,[40,46])
        #
        , mdap(12)
        , stemt_2(24)
        , mdrp0rg(21)
        , stemt_1(15)
        , srp0(12)
        , mdrp0rg(7)
        , stemt_thin_1(28)
        , iy()   
        , dh2(37)
        ),

    'uni0E43':    #SARA AI MAI MUAN
        packline(""
        , mdap(3)
        , stemw_1(27)
        , xhead1(33,39,45)
        , srp0(3)
        , mdrp0rg(21)
        , stemw_thin_1(10)
        , head1(15,[57,51])
        , ix()
        , dh1(12,30)
        , dh2(18,0)
        #y  
        , sy()
        , mdap(60)
        , vbct(0) 
        , head1(30,[36,42])
        #
        , mdap(24)
        , stemt_2(7)
        , mdrp0rg(12)
        , head2(18,[48,54])
        , iy()
        , dh2(15,33)
        ),

    'uni0E44':    #SARA AI MAIMALAI
        packline(""
        , mdap(3)
        , stemw_1(20)
        , xhead1(26,32,38)
        , srp0(3)
        , mdrp0rg(11)
        , f_ip([5,6,18,19])
        , stemw_thin_1(16)
        , ix()
        , dh1(23)
        , dh2(0)
        #y  
        , sy()
        , mdap(41)
        , vbct(0)
        , head1(23,[29,35])
        #
        , mdap(19)
        , stemt_2(4)
        , mdrprg(14)
        , mdrp0rg(5)
        , stemt_thin_1(18)
        , iy()
        , dh2(26)
        ),

    'uni0E45':    #LAKKHANGYAO
        packline(""
        , mdap(1)
        , stemw_1(22)
        , mdrp0rg(14,"10-8 ")
        , stemw_1(8)
        , ix()
        #y
        , sy()
        , mdap(23)
        , vblu(1)
        , vtc2(19,[2,22,11])
        , stemt_2(5)
        , mdapr(11)
        , iy()
        ),

    'uni0E46':    #MAIYAMOK
        packline(""
        , mdap(9)
        , stemw_1(35)
        , mdrprg(3)
        , mdrp0rg(27)
        , add_ip(27,35,[30,31,32,13,14,15])
        , stemw_1(18)
        , head1(21,[48,42])
        , ix()
        , dh2(24)
        #y
        , sy()
        , mdap(51)
        , vtc2(32,[10,35])
        , alignrp(30)
        , stemt_sara_2(13)
        , shprp2(15)
        , mdrp0rg(14)
        , stemt_sara_1(31)
        , srp0(32)
        , mdrp0rg(18)
        , head2(24,[39,45])
        #
        , srp0(51)
        , vblum(0)
        , stemt_1(6)
        , iy()
        , dh2(21)
        ),

#    'uni0E47':    #MAITAIKHU
#        packline(""
#        , mdap(42)
#        , mdrprg(18)
#        , headsara2(36,[55,49])
#        , mdrp0rg(7)
#        , f_ip([30,31,5])
#        , stemw_sara_1(26)
#        , ix()
#        #y
#        , sy()
#        , mdap(0)
#        , alignrp(4)
#        , stemt_sara_1(29)
#        , headsara1(39,[45,52,31,3,34])
#        , mdrp0mrg(22)
#        , stemt_sara_1(11)
#        , mdrpmrg(15,"13+4 14+4 15+4 16+4 17+4 ")
#        , iy()
#        ),
#
#    'uni0E48.low':    #MAI EK
#        packline(""
#        , mdap(7)
#        , stemt_2(2)
#        , ix()
#        #y
#        , sy()
#        , mdap(0)
#        , mdrpmrg(5)
#        , iy()
#        ),
#
#    'uni0E49.low':    #MAI THO
#        packline(""
#        , mdap(15)
#        , mdrprg(26)
#        , headsara2(9,[39,33,4,18])
#        , mdrprg(0)
#        , ix()
#        #y
#        , sy()
#        , mdap(0)
#        , stemt_sara_1(1)
#        , shprp2(18)
#        , mdrp0mrg(6)
#        , headsara1(12,[30,36])
#        , mdrpmrg(23)
#        , f_dstr(6,"13+8 14+8 15+8 16+8 17+8 18+8 ")
#        , iy()
#        ),
#
#    'uni0E4A.low':    #MAI TRI
#        packline(""
#        , mdap(59)
#        , stemw_sara_2(52)
#        , mdrp0rg(48)
#        , stemw_sara_2(8)
#        , mdrp0rg(15)
#        , stemw_sara_2(17)
#        , mdrp0rg(29)
#        , headsara2(35,[72,66,24])
#        , ix()
#        #y
#        , sy()
#        , mdap(1)
#        , alignrp(32)
#        , stemt_sara_1(7)
#        , shprp2(49)
#        , headsara1(26,[63,69,17])
#        , mdrp0rg(39)
#        , alignrp(45)
#        , f_ip([42])
#        , mdrpmrg(56)
#        , stemt_sara_2(21)
#        , shprp2(12)
#        , iy()
#        ),
#
#    'uni0E4B.low':    #MAI CHATTAWA
#        packline(""
#        , mdap(18)
#        , mdrp0rg(21)
#        , alignrp(14)
#        , stemw_sara_2m(2)
#        , alignrp(9)
#        , mdrprg(6)
#        , ix()
#        #y  
#        , sy()
#        , mdap(0)
#        , mdrp0rg(21)
#        , alignrp(3)
#        , stemt_sara_1m(15)
#        , alignrp(9)
#        , mdrprg(12)
#        , iy()
#        ),
#
#    'uni0E4C.low':    #THANTHAKAT
#        packline(""
#        , mdap(22)
#        , mdrprg(16)
#        , headsara2(3,[34,28])
#        , ix()
#        #y  
#        , sy()
#        , mdap(0)
#        , headsara1(6,[25,31])
#        , mdrpmrg(13)
#        , stemt_sara_2(20)
#        , iy()
#        ),
#
#    'uni0E4D':    #NIKHAHIT
#        packline(""
#        , mdap(9)
#        , head2(3,[21,15])
#        , ix()
#        #y
#        , sy()
#        , mdap(0)
#        , head1(6,[12,18])
#        , iy()
#        ),
#
#    'uni0E4E':    #YAMAKKAN
#        packline(""
#        , mdap(18)
#        , mdrp0rg(10)
#        , f_ip([36,8,55])
#        , stemw_sara_1(30)
#        , mdrp0rg(3)
#        , stemw_sara_1(48)
#        , ix()
#        #
#        , sy()
#        , mdap(0)
#        , stemt_sara_1(51)
#        , mdrp0rg(6)
#        , f_ip([39])
#        , stemt_sara_2(45)
#        , mdrp0rg(13)
#        , f_ip([21])
#        , stemt_sara_2(27)
#        , iy()
#        ),
##        packline(""
##        , mdap(18)
##        , stemw_sara_2(24)
##        , mdrp0rg(10)
##        , f_ip([13,27])
##        , stemw_sara_1(30)
##        , f_ip([8])
##        , srp0(18)
##        , mdrp0mrw(36)
##        , stemw_sara_2(42)
##        , mdrpmrw(55)
##        , mdrp0rg(3)
##        , f_ip([6,45])
##        , stemw_sara_1(48)
##        , ix()
##        #y
##        , sy()
##        , mdap(0)
##        , stemt_sara_1(51)
##        , mdrp0rg(6)
##        , f_ip([3,48])
##        , stemt_sara_2(45)
##        , f_ip([8])
##        , srp0(0)
##        , mdrp0rg(39)
##        , stemt_sara_1(33)
##        , mdrp0rg(13)
##        , f_ip([10,30])
##        , stemt_sara_2(27)
##        , srp0(33)
##        , mdrp0mrw(21)
##        , stemt_sara_1(16)
##        , iy()
##        ),
#
    'uni0E4F':    #FONGMAN
        packline(""
        , mdap(3) 
        , stem_notch_1(21)
        , mdrprg(27)
        , mdrp0rg(9)
        , stem_notch_2(15)
        , mdrprg(33)
        , add_ip(27,33,[45,39])
        , ix()
        #y  
        , sy()
        , mdap(6) 
        , stem_notch_2(18)
        , mdrprg(30)
        , mdrp0rg(0)
        , stem_notch_1(12)
        , mdrprg(24)
        , add_ip(30,24,[36,42])
        , iy()
        ),

    'uni0E50':    #THAI DIGIT ZERO
        packline(""
        , mdap(3,"9-8 ")
        , stemw_1(21)
        , mdrp0rg(9)
        , stemw_2(15)
        , ix()
        #y  
        , sy()
        , mdap(24)
        , vtnc(6)
        , stemt_2(18)
        , srp0(24)
        , vbct(0)
        , stemt_1(12)
        , iy()
        ),

    'uni0E51':    #THAI DIGIT ONE
        packline(""
        , mdap(3,"9-8 10-8 ")
        , stemw_1(29)
        #
        , mdrp0rg(9,"10+8 17+8 ")
        , stemw_2(23)
        , mdrprg(17)
        , mdrp0rg(40,"9-8 15-8 20-8 ")
        , head2(34,[52,46])
        , ix()
        , dh1(37)
        #y  
        , sy()
        , mdap(0)
        , mdrpmrg(14)
        , vtnc(6)
        , stemt_2(26)
        , srp0(0)
        , mdrp0rg(0)
        , stemt_1(32)
        , mdrp0rg(37)
        , xhead0(49,43,direction='-')
        , iy()
        , dh1(34)
        , dh2(40)
        ),

    'uni0E52':    #THAI DIGIT TWO
        packline(""
        , mdap(1)
        , stemw_1(14)
        , mdrp0rg(7)
        , stemw_thin_1(12)
        , srp0(1)
        , mdrp0rg(36,"11-8 ")
        , stemw_sara_1(25)
        , head1(30,[54,48])
        #
        , srp0(1)
        , mdrp0rg(42)
        , stemw_2(18)
        , add_ip(36,18,[38,39,40,21,22,23])
        , ix()
        , dh1(27)
        , dh2(33)
        #y  
        , sy()
        , mdap(0)
        , stemt_1(16)
        , vtnc(40)
        , alignrp(38)
        , mdrprg(10)
        , mdrprg(22)
        , f_ip([39,21,23])
        , mdrp0rg(27)
        , head2(33,[45,51])
        , iy()
        , dh2(30)
        ),

    'uni0E53':    #THAI DIGIT THREE
        packline(""
        , mdap(32,"9-8 10-8 ")
        , stemw_1(20)
        , xhead2(26,49,55)
        #
        , srp0(32)
        , mdrp0rg(13)
        , stemw_1(8)
        , f_ip([39])
        , mdrp0rg(1)
        , stemw_1(45)
        , ix()
        , dh1(23)
        , dh2(29)
        #y  
        , sy()
        , mdap(1)
        , vtnc(42,[33,20,14,8,2,45,11])
        , alignrp(36)
        , stemt_2(5)
        , shprp2(17)
        , srp0(1)
        , vbct(29)
        , head1(23,[46,52])
        , iy()
        , dh2(26)
        ),


    'uni0E54':    #THAI DIGIT FOUR
        packline(""
        , mdap(4,"9-8 10-8 11-8 ")
        , stemw_1(26)
        , mdrp0rg(33)
        , xhead2(39,52,58)
        , mdrprg(47)
        , mdrprg(17)
        , f_dstr(33,"14+8 15+8 16+8 ")
        , ix()
        , dh1(36)
        #y  
        , sy()
        , mdap(1)
        , stemt_1(30)
        , shprp2(44)
        , vtn(7)
        , stemt_2(23)
        , mdrprg(14)
        , mdrp0rg(36,"9-8 12-8 ")
        , head2(42,[49,55])
        , iy()
        , dh1(33)
        , dh2(39)
        ),

    'uni0E55':    #THAI DIGIT FIVE
        packline(""
        , mdap(4,"9-8 10-8 11-8 ")
        , stemw_1(36)
        , mdrp0rg(43)
        , xhead2(49,62,68)
        , mdrprg(57)
        , mdrprg(27)
        , f_dstr(43,"14+8 15+8 16+8 ")
        , mdrp0rg(15)
        , head2(9,[80,74])
        , ix()
        , dh1(46,12)
        #y  
        , sy()
        , mdap(1)
        , stemt_1(40)
        , shprp2(54)
        , vtn(17)
        , alignrp(7)
        , alignrp(71)
        , stemt_2(33)
        , mdrprg(24)
        , mdrprg(12)
        , f_ip([77])
        , mdrp0rg(46,"9-8 12-8 ")
        , head2(52,[59,65])
        , iy()
        , dh1(43,9)
        , dh2(49,15)
        ),

    'uni0E56':    #THAI DIGIT SIX
        packline(""
        , mdap(22,"9-8 ")
        , stemw_1(36)
        , mdrprg(28)
        , mdrp0rg(4)
        , head1(10,[53,47])
        #
        , srp0(22)
        , mdrp0rg(41,"15+8 ")
        , stemw_2(15)
        , ix()
        , dh1(7)
        #y  
        , sy()
        , mdap(56)
        , vtnc(38) 
        , mdrprg(31)
        , stemt_2(18)
        , srp0(56)
        , vbct(0)
        , stemt_1(12)
        , mdrp0rg(2,"9+8 ")
        , head1(7,[44,50])
        , iy()
        , dh1(4)
        , dh2(10)
        ),

    'uni0E57':    #THAI DIGIT SEVEN
        packline(""
        , mdap(33,"13-8 14-8 15-8 16-8 17-8 18-8 19-8 20-8 40-8 41-8 42-8 ")
        , stemw_1(21)
        , xhead2(27,63,69)
        #
        , mdrp0rg(16,"9-8 10-8 11+8 12+8 13+8 18+8 23-8 24-8 29-8 ")
        , stemw_1(11)
        , f_ip([40])
        , mdrp0rg(6,"11-8 12-8 18-8 19-8 ")
        , stemw_1(46)
        , mdrpg(3)
        , mdrp0rg(51,"10+8 17+8 26-8 27-8 ")
        , stemw_1(56)
        , ix()
        , dh1(24)
        , dh2(30)
        #y  
        , sy()
        , mdap(1)
        , stemt_1(6)
        , shprp2(47)
        , vtnc(43,[34,21,17,11,7,46,14])
        , alignrp(37)
        , mdrprg(54)
        , stemt_2(9)
        , shprp2(19)
        , srp0(1)
        , vbct(30)
        , head1(24,[60,66])
        , iy()
        , dh2(27)
        ),

    'uni0E58':    #THAI DIGIT EIGHT
        packline(""
        , mdap(7,"13-8 14-8 ")
        , stemw_1(29)
        , mdrp0rg(32)
        , stemw_sara_1(3)
        #
        , srp0(7)
        , mdrp0rg(45,"16-8 ")
        , mdrprg(20)
        , head2(39,[58,52,37])
        , ix()  
        , dh1(42)
        #y  
        , sy()
        , mdap(61)
        , vtn(11)
        , mdrprg(17)
        , stemt_2(25)
        , srp0(61)
        , vbct(0)
        , alignrp(4)
        , stemt_1(32)
        , stemt_thin_1(37)
        , mdrp0rg(42)
        , alignrp(34)
        , xhead0(55,49,direction='-')
        , stemt_2(3)
        , iy()
        , dh1(39)
        , dh2(45)
        ),

    'uni0E59':    #THAI DIGIT NINE
        packline(""
        , mdap(22)
        , stemw_1(7)
        , mdrp0rg(16,"9-8 13-8 14-8 ")
        , head2(10,[59,53])
        , srp0(16)
        , mdrp0rg(2)
        , stemw_1(49)
        , f_ip([27])
        , mdrp0rg(1)
        , stemw_1(0)
        , mdrprg(40)
        , ix()  
        , dh1(13)
        , dh2(19)
        #y  
        , sy()
        , mdap(1)
        , vtnc(29,[22,7,2,49])
        , alignrp(25)
        , mdrprg(37)
        , stemt_2(47)
        , shprp2(4)
        , mdrp0rg(44)
        , stemt_1(32)
        , srp0(1)
        , vbct(19)
        , head1(13,[50,56])
        , iy()
        , dh1(16)
        ),

    'uni0E5A':      #ANGKHANKHU
        packline(""
        , mdap(43,"9-8 ")
        , stemw_1(45)
        , mdrp0mrw(29)
        , stemw_2(6)
        , shprp2(28)
        , mdrprg(3,"10+8 ")
        , mdrp0rg(16)
        , head1(22,[39,33])
        , ix()
        , dh1(19)
        #y  
        , sy()
        , mdap(1)
        , alignrp(43)
        , stemt_1(5)
        , vtc2(19,[7])
        , alignrp(29)
        , alignrp(45)
        , xhead0(36,30,direction="-")
        , mdrp0rg(10)
        , stemt_sara_1(24)
        , iy()
        , dh2(22)
        ),

#    'uni0E5B':      #KHOMUT
#        packline(""
#        , mdap(3,"10-8 ")
#        , stemw_1(26)
#        , mdrp0rg(9)
#        , stemw_2(20)
#        , head2(15,[71,65])
#        , srp0(9)
#        , mdrprg(46)
#        , f_ip([32,33,34,35,36,37,38,39,40,41,51,52,53,54,55,56,57,58])
#        , ix()
#        , dh1(18)
#        , dh2(12)
#        #y  
#        , sy()
#        , mdap(74)
#        , vtnc(6)
#        , stemt_2(23)
#        , srp0(74)
#        , vbct(0)
#        , stemt_1(29)
#        , mdrp0rg(12)
#        , alignrp(56)
#        , alignrp(53)
#        , head1(18,[62,68])
#        , alignrp(33)
#        , alignrp(36)
#        , alignrp(39)
#        , mdrp0rg(43)
#        , stemt_2(49)
#        , iy()
#        , dh1(15)
#        ),

    }



#++++++++++++++++++++++++++++++

#----- MODIFY pseudo_code_dict BY -----------
#----- SUBSTITUTE FUNCTION IN TEXT FORM -----
#----- TO REAL pseudo_code ------------------
from dttcmd import *

self_func = []
for i in dir():
    if callable(eval(i)): self_func.append(i)

for i in pseudo_code_dict.keys():
    pl = pseudo_code_dict[i].split('\n')
    for j in range(len(pl)):
        if '(' in pl[j]:
            if pl[j].split('(',1)[0] in self_func:
                l = [n for n in range(len(pl[j])) if pl[j][n] == ')']
                t = pl[j][:l[-1]+1]
                pl[j] = pl[j].replace(t, eval(t))
    pseudo_code_dict[i] = '\n'.join(pl)
